<?php
$page = 'ASW Founders | Home';
$pageDesc = '""';
$pageTag = '""';
include 'includes/header.php';
$page = 'Home';
?>

<header class="hero">
    <div class="padding-global">
        <div class="container-large">
            <div data-w-id="fb10b157-a64e-8b72-eaef-ac4a671a70b7"
                class="padding-section-large margin-top-hero no-padding-bottom">
                <div class="margin-bottom">
                    <div style="opacity:0" class="button-group is-center">
                        <div class="button is-small is-icon is-secondary top-text align-center">
                            <img src="images/pic2.svg" loading="lazy" alt="Webflow Logo" class="icon-embed-xsmall">
                            <div class="icon-1x1-hero" data-w-id="447e8603-f810-1904-d73c-914a1f22412c"
                                data-animation-type="lottie" data-src="https://cdn.prod.website-files.com/66c74b953957211a234767e2/66cd848167641295ddeff769_5KBngCIUTK.json"
                                data-loop="1" data-direction="1" data-autoplay="1" data-is-ix2-target="0" data-renderer="svg" data-default-duration="2.0416666666666665" data-duration="0">
                            </div>
                            <div class="icon-embed-xsmall w-embed">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--simple-icons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                    <path fill="currentColor"
                                        d="m15.337 23.979l7.216-1.561s-2.604-17.613-2.625-17.73c-.018-.116-.114-.192-.211-.192s-1.929-.136-1.929-.136s-1.275-1.274-1.439-1.411a.384.384 0 0 0-.121-.074l-.914 21.104h.023zM11.71 11.305s-.81-.424-1.774-.424c-1.447 0-1.504.906-1.504 1.141c0 1.232 3.24 1.715 3.24 4.629c0 2.295-1.44 3.76-3.406 3.76c-2.354 0-3.54-1.465-3.54-1.465l.646-2.086s1.245 1.066 2.28 1.066a.944.944 0 0 0 .975-.932c0-1.619-2.654-1.694-2.654-4.359c-.034-2.237 1.571-4.416 4.827-4.416c1.257 0 1.875.361 1.875.361l-.945 2.715l-.02.01zM11.17.83c.136 0 .271.038.405.135c-.984.465-2.064 1.639-2.508 3.992a62.82 62.82 0 0 1-1.889.578C7.697 3.75 8.951.84 11.17.84V.83zm1.235 2.949v.135c-.754.232-1.583.484-2.394.736c.466-1.777 1.333-2.645 2.085-2.971c.193.501.309 1.176.309 2.1zm.539-2.234c.694.074 1.141.867 1.429 1.755c-.349.114-.735.231-1.158.366v-.252c0-.752-.096-1.371-.271-1.871v.002zm2.992 1.289c-.02 0-.06.021-.078.021s-.289.075-.714.21c-.423-1.233-1.176-2.37-2.508-2.37h-.115C12.135.209 11.669 0 11.265 0C8.159 0 6.675 3.877 6.21 5.846c-1.194.365-2.063.636-2.16.674c-.675.213-.694.232-.772.87c-.075.462-1.83 14.063-1.83 14.063L15.009 24l.927-21.166z">
                                    </path>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="header26_component">
                    <div class="margin-bottom margin-xxlarge">
                        <div class="text-align-center">
                            <div data-w-id="fb10b157-a64e-8b72-eaef-ac4a671a70bb" class="hero-heading-wrap">
                                <div class="margin-bottom margin-small">
                                    <h1 class="hero-head">
                                        <span data-w-id="9fc81c2e-3123-f7e1-fb31-20a41c8be93b"
                                            style="-webkit-transform:translate3d(0, 88px, -156px) scale3d(1, 1, 1) rotateX(-67deg) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 88px, -156px) scale3d(1, 1, 1) rotateX(-67deg) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 88px, -156px) scale3d(1, 1, 1) rotateX(-67deg) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 88px, -156px) scale3d(1, 1, 1) rotateX(-67deg) rotateY(0) rotateZ(0) skew(0, 0);transform-style:preserve-3d;opacity:0"
                                            class="hero-heading-top">Webflow</span>
                                        <span data-w-id="61d02a96-69ec-10b1-29fa-9cf366d7f5b9" style="opacity:0" class="hero-heading-top">&amp;</span>
                                        <span data-w-id="5554f6b9-3c0b-8251-fb96-933dfc89f342"
                                            style="-webkit-transform:translate3d(0, 88px, -156px) scale3d(1, 1, 1) rotateX(-67deg) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 88px, -156px) scale3d(1, 1, 1) rotateX(-67deg) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 88px, -156px) scale3d(1, 1, 1) rotateX(-67deg) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 88px, -156px) scale3d(1, 1, 1) rotateX(-67deg) rotateY(0) rotateZ(0) skew(0, 0);transform-style:preserve-3d;opacity:0"
                                            class="hero-heading-top">Shopify</span>
                                        <span style="opacity:0" class="text-style-hero-gradient">
                                            connected</span>
                                    </h1>
                                </div>
                                <div style="opacity:0" class="hero-paragraph-wrap">
                                    <p>Explore the easiest way to design complex
                                        <strong>Shopify </strong>stores completely within
                                        <strong>Webflow</strong>, assisted by <strong>AI</strong>
                                        <span class="ai-icon hide-desktop">
                                            <strong>.</strong></span>
                                    </p>
                                    <div class="icon-embed-xsmall hide-tablet w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                            <path fill="currentColor" fill-rule="evenodd"
                                                d="M9 4.5a.75.75 0 0 1 .721.544l.813 2.846a3.75 3.75 0 0 0 2.576 2.576l2.846.813a.75.75 0 0 1 0 1.442l-2.846.813a3.75 3.75 0 0 0-2.576 2.576l-.813 2.846a.75.75 0 0 1-1.442 0l-.813-2.846a3.75 3.75 0 0 0-2.576-2.576l-2.846-.813a.75.75 0 0 1 0-1.442l2.846-.813A3.75 3.75 0 0 0 7.466 7.89l.813-2.846A.75.75 0 0 1 9 4.5Zm9-3a.75.75 0 0 1 .728.568l.258 1.036a2.63 2.63 0 0 0 1.91 1.91l1.036.258a.75.75 0 0 1 0 1.456l-1.036.258a2.63 2.63 0 0 0-1.91 1.91l-.258 1.036a.75.75 0 0 1-1.456 0l-.258-1.036a2.625 2.625 0 0 0-1.91-1.91l-1.036-.258a.75.75 0 0 1 0-1.456l1.036-.258a2.625 2.625 0 0 0 1.91-1.91l.258-1.036A.75.75 0 0 1 18 1.5ZM16.5 15a.75.75 0 0 1 .712.513l.394 1.183c.15.447.5.799.948.948l1.183.395a.75.75 0 0 1 0 1.422l-1.183.395a1.5 1.5 0 0 0-.948.948l-.395 1.183a.75.75 0 0 1-1.422 0l-.395-1.183a1.5 1.5 0 0 0-.948-.948l-1.183-.395a.75.75 0 0 1 0-1.422l1.183-.395a1.5 1.5 0 0 0 .948-.948l.395-1.183A.75.75 0 0 1 16.5 15Z"
                                                clip-rule="evenodd">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="margin-top margin-medium">
                                    <div style="opacity:0" class="button-group is-center">
                                        <a href="academy.php" class="button is-small is-secondary w-button">Getting Started</a>
                                        <a href="#" class="button is-small is-icon is-hover-right w-inline-block">
                                            <div>Launch</div>
                                            <div class="dropdown-chevron rotate w-embed">
                                                <svg width=" 100%" height=" 100%" viewbox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M2.55806 6.29544C2.46043 6.19781 2.46043 6.03952 2.55806 5.94189L3.44195 5.058C3.53958 4.96037 3.69787 4.96037 3.7955 5.058L8.00001 9.26251L12.2045 5.058C12.3021 4.96037 12.4604 4.96037 12.5581 5.058L13.4419 5.94189C13.5396 6.03952 13.5396 6.19781 13.4419 6.29544L8.17678 11.5606C8.07915 11.6582 7.92086 11.6582 7.82323 11.5606L2.55806 6.29544Z"
                                                        fill="currentColor">
                                                    </path>
                                                </svg>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="blog-post-header2_image-wrapper">
                        <div data-poster-url="images/pic3.jpg"
                            data-video-urls="images/video1.mp4,images/video2.webm"
                            data-autoplay="true" data-loop="true" data-wf-ignore="true"
                            class="background-video hero w-background-video w-background-video-atom">
                            <video id="e4d7c03d-ad68-9e73-6764-dea309910773-video" autoplay="" loop=""
                                style="background-image:url(&quot;images/pic3.jpg&quot;)"
                                muted="" playsinline="" data-wf-ignore="true" data-object-fit="cover">
                                <source src="images/video1.mp4" data-wf-ignore="true">
                                <source src="images/video2.webm" data-wf-ignore="true">
                            </video>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
<section class="bento-grid">
    <div class="padding-global">
        <div class="container-large">
            <div class="padding-section-large">
                <div class="margin-bottom margin-xxlarge">
                    <div class="text-align-center">
                        <div class="max-width-large align-center">
                            <div class="margin-bottom margin-small">
                                <div class="button is-secondary is-small is-tagline">A new way to sell online</div>
                            </div>
                            <div class="margin-bottom margin-small">
                                <h2>Design is key to boosting sales</h2>
                            </div>
                            <p class="text-size-medium">Design in <strong>Webflow</strong>. Connect with
                                <strong>ASW Founders</strong>. Manage with <strong>Shopify</strong>.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="w-layout-grid layout398_component">
                    <div id="w-node-_802942d2-829f-fd1a-aeaa-b5ed10e30b57-23476836" class="w-layout-grid layout398_row">
                        <div class="w-layout-grid layout398_column">
                            <div class="layout398_card-large">
                                <div id="w-node-_802942d2-829f-fd1a-aeaa-b5ed10e30b5a-23476836"
                                    class="layout398_card-large-image-wrapper padding">
                                    <img width="510" sizes="(max-width: 767px) 77vw, 510px" alt="ASW Founders Webflow and Shopify Connected" src="images/pic4.avif" loading="lazy">
                                </div>
                                <div class="layout398_card-large-content video dark">
                                    <div class="layout398_card-large-content-top">
                                        <div class="margin-bottom margin-xsmall">
                                            <h3 class="heading-style-h5">Server Sync - Always in line</h3>
                                        </div>
                                        <p>You can easily import your Shopify data into Webflow and keep your Webflow project always
                                            synced with Shopify automatically.</p>
                                    </div>
                                    <div class="margin-top margin-small">
                                        <div class="button-group">
                                            <a href="#" class="button is-icon is-alternate is-small no-shadow hover-right w-inline-block">
                                                <div>How it works</div>
                                                <div class="icon-embed-xxsmall w-embed">
                                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                                        <path fill="currentColor" fill-rule="evenodd"
                                                            d="M3 10a.75.75 0 0 1 .75-.75h10.638L10.23 5.29a.75.75 0 1 1 1.04-1.08l5.5 5.25a.75.75 0 0 1 0 1.08l-5.5 5.25a.75.75 0 1 1-1.04-1.08l4.158-3.96H3.75A.75.75 0 0 1 3 10Z" clip-rule="evenodd">
                                                        </path>
                                                    </svg>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div id="w-node-_802942d2-829f-fd1a-aeaa-b5ed10e30b6c-23476836" class="layout398_card-small">
                                </div>
                            </div>
                            <div id="w-node-_802942d2-829f-fd1a-aeaa-b5ed10e30b7d-23476836" class="layout398_card-small">
                                <div class="layout398_card-small-content color-white">
                                    <div class="layout398_card-small-content-top">
                                        <div class="margin-bottom margin-small">
                                            <div class="icon-1x1-medium w-embed">
                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                                    <path fill="currentColor" fill-rule="evenodd"
                                                        d="M2.25 6a3 3 0 0 1 3-3h13.5a3 3 0 0 1 3 3v12a3 3 0 0 1-3 3H5.25a3 3 0 0 1-3-3V6Zm18 3H3.75v9a1.5 1.5 0 0 0 1.5 1.5h13.5a1.5 1.5 0 0 0 1.5-1.5V9Zm-15-3.75A.75.75 0 0 0 4.5 6v.008c0 .414.336.75.75.75h.008a.75.75 0 0 0 .75-.75V6a.75.75 0 0 0-.75-.75H5.25Zm1.5.75a.75.75 0 0 1 .75-.75h.008a.75.75 0 0 1 .75.75v.008a.75.75 0 0 1-.75.75H7.5a.75.75 0 0 1-.75-.75V6Zm3-.75A.75.75 0 0 0 9 6v.008c0 .414.336.75.75.75h.008a.75.75 0 0 0 .75-.75V6a.75.75 0 0 0-.75-.75H9.75Z"
                                                        clip-rule="evenodd">
                                                    </path>
                                                </svg>
                                            </div>
                                        </div>
                                        <div class="margin-bottom margin-xsmall">
                                            <h3 class="heading-style-h5 text-color-secondary">HQ Templates</h3>
                                        </div>
                                        <p class="text-color-secondary">
                                            Built by expert Webflow designers and developers to speed up
                                            your work.
                                        </p>
                                    </div>
                                    <div class="margin-top margin-small">
                                        <div class="button-group">
                                            <a href="templates.php" class="button is-icon is-alternate is-small no-shadow hover-right w-inline-block">
                                                <div>Browse templates</div>
                                                <div class="icon-embed-xxsmall w-embed">
                                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                                        <path fill="currentColor" fill-rule="evenodd"
                                                            d="M3 10a.75.75 0 0 1 .75-.75h10.638L10.23 5.29a.75.75 0 1 1 1.04-1.08l5.5 5.25a.75.75 0 0 1 0 1.08l-5.5 5.25a.75.75 0 1 1-1.04-1.08l4.158-3.96H3.75A.75.75 0 0 1 3 10Z"
                                                            clip-rule="evenodd">
                                                        </path>
                                                    </svg>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="w-layout-grid layout398_column _3columns">
                            <div class="layout398_card-small-content">
                                <div class="layout398_card-small-content-top">
                                    <div class="margin-bottom margin-small">
                                        <img src="images/pic2.svg" loading="lazy" alt="Webflow Logo" class="icon-embed-medium">
                                    </div>
                                    <div class="margin-bottom margin-xsmall">
                                        <h3 class="heading-style-h5">Stay in We<span>bflow</span></h3>
                                    </div>
                                    <p>Build your store visually within the Webflow designer without any limitations. Publish
                                        directly from Webflow and make any design change in no time.</p>
                                </div>
                            </div>
                            <div id="w-node-_898a68cb-9c58-bf67-f87c-64b8059987e6-23476836" class="layout398_card-small">
                                <div class="layout398_card-small-content color-main">
                                    <div class="layout398_card-small-content-top">
                                        <div class="margin-bottom margin-small">
                                            <!-- <img src="images/pic1.svg" loading="lazy" alt="ASW Founders Logo" class="icon-1x1-medium"> -->
                                            <h6>LOGOHERE</h6>
                                        </div>
                                        <div class="margin-bottom margin-xsmall">
                                            <h3 class="heading-style-h5">Connect with ASW Founders</h3>
                                        </div>
                                        <p>Connect Webflow to Shopify with no need to export code or launch any conversion.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="layout398_card-large">
                                <div id="w-node-_802942d2-829f-fd1a-aeaa-b5ed10e30b8e-23476836"
                                    class="layout398_card-large-image-wrapper">
                                </div>
                                <div class="layout398_card-large-content black">
                                    <div class="layout398_card-large-content-top">
                                        <div class="margin-bottom margin-small">
                                            <div class="icon-embed-medium w-embed">
                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--simple-icons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                                    <path fill="currentColor"
                                                        d="m15.337 23.979l7.216-1.561s-2.604-17.613-2.625-17.73c-.018-.116-.114-.192-.211-.192s-1.929-.136-1.929-.136s-1.275-1.274-1.439-1.411a.384.384 0 0 0-.121-.074l-.914 21.104h.023zM11.71 11.305s-.81-.424-1.774-.424c-1.447 0-1.504.906-1.504 1.141c0 1.232 3.24 1.715 3.24 4.629c0 2.295-1.44 3.76-3.406 3.76c-2.354 0-3.54-1.465-3.54-1.465l.646-2.086s1.245 1.066 2.28 1.066a.944.944 0 0 0 .975-.932c0-1.619-2.654-1.694-2.654-4.359c-.034-2.237 1.571-4.416 4.827-4.416c1.257 0 1.875.361 1.875.361l-.945 2.715l-.02.01zM11.17.83c.136 0 .271.038.405.135c-.984.465-2.064 1.639-2.508 3.992a62.82 62.82 0 0 1-1.889.578C7.697 3.75 8.951.84 11.17.84V.83zm1.235 2.949v.135c-.754.232-1.583.484-2.394.736c.466-1.777 1.333-2.645 2.085-2.971c.193.501.309 1.176.309 2.1zm.539-2.234c.694.074 1.141.867 1.429 1.755c-.349.114-.735.231-1.158.366v-.252c0-.752-.096-1.371-.271-1.871v.002zm2.992 1.289c-.02 0-.06.021-.078.021s-.289.075-.714.21c-.423-1.233-1.176-2.37-2.508-2.37h-.115C12.135.209 11.669 0 11.265 0C8.159 0 6.675 3.877 6.21 5.846c-1.194.365-2.063.636-2.16.674c-.675.213-.694.232-.772.87c-.075.462-1.83 14.063-1.83 14.063L15.009 24l.927-21.166z">
                                                    </path>
                                                </svg>
                                            </div>
                                        </div>
                                        <div class="margin-bottom margin-xsmall">
                                            <h3 class="heading-style-h5">Manage with Shopify</h3>
                                        </div>
                                        <p>Manage with Shopify&#x27;s built-in solutions for order management, products, customers,
                                            emails, discounts, shipping labels and more...</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="w-layout-grid layout398_column">
                            <div class="layout398_card-large">
                                <div id="w-node-_802942d2-829f-fd1a-aeaa-b5ed10e30ba2-23476836"
                                    class="layout398_card-large-image-wrapper">
                                    <div data-poster-url="images/pic5.jpg" data-video-urls="images/video3.mp4,images/video4.webm" data-autoplay="true" data-loop="true" data-wf-ignore="true" class="background-video top-radius w-background-video w-background-video-atom">
                                        <video id="dc6f699a-f328-df0f-da14-8938bf7b9a76-video" autoplay="" loop="" style="background-image:url(&quot;images/pic5.jpg&quot;)" muted="" playsinline="" data-wf-ignore="true" data-object-fit="cover">
                                            <source src="images/video3.mp4" data-wf-ignore="true">
                                            <source src="images/video4.webm" data-wf-ignore="true">
                                        </video>
                                    </div>
                                </div>
                                <div class="layout398_card-large-content white no-top-radius">
                                    <div class="layout398_card-large-content-top">
                                        <div class="margin-bottom margin-xsmall">
                                            <h3 class="heading-style-h5 text-color-secondary">Product customization</h3>
                                        </div>
                                        <p class="text-color-secondary">Discover how many striking things you can do with the power of Webflow &amp; Shopify in your hands.</p>
                                    </div>
                                    <div class="margin-top margin-small">
                                        <div class="button-group">
                                            <a href="features.php" class="button is-icon is-alternate is-small no-shadow hover-right w-inline-block">
                                                <div>What you can do</div>
                                                <div class="icon-embed-xxsmall w-embed">
                                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                                        <path fill="currentColor" fill-rule="evenodd"
                                                            d="M3 10a.75.75 0 0 1 .75-.75h10.638L10.23 5.29a.75.75 0 1 1 1.04-1.08l5.5 5.25a.75.75 0 0 1 0 1.08l-5.5 5.25a.75.75 0 1 1-1.04-1.08l4.158-3.96H3.75A.75.75 0 0 1 3 10Z"
                                                            clip-rule="evenodd">
                                                        </path>
                                                    </svg>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div id="w-node-_802942d2-829f-fd1a-aeaa-b5ed10e30bb4-23476836" class="layout398_card-small">
                                <div class="layout398_card-small-content color-dark-white">
                                    <div class="layout398_card-small-content-top">
                                        <div class="margin-bottom margin-small">
                                            <div class="icon-1x1-medium white w-embed">
                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                                    <path fill="currentColor"
                                                        d="M11.25 5.337c0-.355-.186-.676-.401-.959a1.647 1.647 0 0 1-.349-1.003c0-1.036 1.007-1.875 2.25-1.875S15 2.34 15 3.375c0 .369-.128.713-.349 1.003c-.215.283-.401.604-.401.959c0 .332.278.598.61.578c1.91-.114 3.79-.342 5.632-.676a.75.75 0 0 1 .878.645a49.17 49.17 0 0 1 .376 5.452a.657.657 0 0 1-.66.664c-.354 0-.675-.186-.958-.401a1.647 1.647 0 0 0-1.003-.349c-1.035 0-1.875 1.007-1.875 2.25s.84 2.25 1.875 2.25c.369 0 .713-.128 1.003-.349c.283-.215.604-.401.959-.401c.31 0 .557.262.534.571a48.774 48.774 0 0 1-.595 4.845a.75.75 0 0 1-.61.61c-1.82.317-3.673.533-5.555.642a.58.58 0 0 1-.611-.581c0-.355.186-.676.401-.959c.221-.29.349-.634.349-1.003c0-1.035-1.007-1.875-2.25-1.875s-2.25.84-2.25 1.875c0 .369.128.713.349 1.003c.215.283.401.604.401.959a.641.641 0 0 1-.658.643a49.118 49.118 0 0 1-4.708-.36a.75.75 0 0 1-.645-.878c.293-1.614.504-3.257.629-4.924A.53.53 0 0 0 5.337 15c-.355 0-.676.186-.959.401c-.29.221-.634.349-1.003.349c-1.036 0-1.875-1.007-1.875-2.25s.84-2.25 1.875-2.25c.369 0 .713.128 1.003.349c.283.215.604.401.959.401a.656.656 0 0 0 .659-.663a47.703 47.703 0 0 0-.31-4.82a.75.75 0 0 1 .83-.832c1.343.155 2.703.254 4.077.294a.64.64 0 0 0 .657-.642Z">
                                                    </path>
                                                </svg>
                                            </div>
                                        </div>
                                        <div class="margin-bottom margin-xsmall">
                                            <h3 class="heading-style-h5">Premium add-ons</h3>
                                        </div>
                                        <p>Discover the list of Shopify app fully integrated with ASW Founders.</p>
                                    </div>
                                    <div class="margin-top margin-small">
                                        <div class="button-group">
                                            <a href="add-ons.php" class="button is-icon is-alternate is-small no-shadow hover-right w-inline-block">
                                                <div>Browse add-ons</div>
                                                <div class="icon-embed-xxsmall w-embed">
                                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                                        <path fill="currentColor" fill-rule="evenodd"
                                                            d="M3 10a.75.75 0 0 1 .75-.75h10.638L10.23 5.29a.75.75 0 1 1 1.04-1.08l5.5 5.25a.75.75 0 0 1 0 1.08l-5.5 5.25a.75.75 0 1 1-1.04-1.08l4.158-3.96H3.75A.75.75 0 0 1 3 10Z"
                                                            clip-rule="evenodd">
                                                        </path>
                                                    </svg>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="_4-steps-guide">
    <div class="padding-global">
        <div class="container-large">
            <div class="padding-section-large">
                <div data-w-id="56ad80a3-95b2-5691-d551-d2cbddd3a4d9" class="w-layout-grid layout486_component">
                    <div class="layout486_content-left">
                        <div class="layout486_number">0</div>
                        <div class="layout486_number-wrapper">
                            <div class="layout486_number">1</div>
                            <div class="layout486_number">2</div>
                            <div class="layout486_number">3</div>
                            <div class="layout486_number">4</div>
                        </div>
                    </div>
                    <div id="w-node-_56ad80a3-95b2-5691-d551-d2cbddd3a4e6-23476836" class="layout486_content-right">
                        <div class="layout486_content">
                            <div class="layout486_number show-mobile-landscape">01</div>
                            <div class="layout486_progress-wrapper">
                                <div class="layout486_progress-bar"></div>
                            </div>
                            <div class="margin-bottom margin-xsmall">
                                <div class="button is-secondary is-small is-tagline">Setup</div>
                            </div>
                            <div class="margin-bottom margin-small">
                                <h2>Launch the Shopify App into your store</h2>
                            </div>
                            <p class="text-size-medium">
                                <strong>Let&#x27;s get ASW Founders set up!</strong> First, head over to the
                                Shopify App Store and install the official ASW Founders app. Once it&#x27;s installed, it&#x27;ll automatically take you to the ASW Founders dashboard. There, you&#x27;ll be able to link your Shopify store to your Webflow project. Easy peasy!
                            </p>
                            <div class="margin-top margin-medium">
                                <div class="button-group">
                                    <a href="#" class="button is-icon is-small w-inline-block">
                                        <div class="icon-embed-xsmall w-embed">
                                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--simple-icons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                                <path fill="currentColor"
                                                    d="m15.337 23.979l7.216-1.561s-2.604-17.613-2.625-17.73c-.018-.116-.114-.192-.211-.192s-1.929-.136-1.929-.136s-1.275-1.274-1.439-1.411a.384.384 0 0 0-.121-.074l-.914 21.104h.023zM11.71 11.305s-.81-.424-1.774-.424c-1.447 0-1.504.906-1.504 1.141c0 1.232 3.24 1.715 3.24 4.629c0 2.295-1.44 3.76-3.406 3.76c-2.354 0-3.54-1.465-3.54-1.465l.646-2.086s1.245 1.066 2.28 1.066a.944.944 0 0 0 .975-.932c0-1.619-2.654-1.694-2.654-4.359c-.034-2.237 1.571-4.416 4.827-4.416c1.257 0 1.875.361 1.875.361l-.945 2.715l-.02.01zM11.17.83c.136 0 .271.038.405.135c-.984.465-2.064 1.639-2.508 3.992a62.82 62.82 0 0 1-1.889.578C7.697 3.75 8.951.84 11.17.84V.83zm1.235 2.949v.135c-.754.232-1.583.484-2.394.736c.466-1.777 1.333-2.645 2.085-2.971c.193.501.309 1.176.309 2.1zm.539-2.234c.694.074 1.141.867 1.429 1.755c-.349.114-.735.231-1.158.366v-.252c0-.752-.096-1.371-.271-1.871v.002zm2.992 1.289c-.02 0-.06.021-.078.021s-.289.075-.714.21c-.423-1.233-1.176-2.37-2.508-2.37h-.115C12.135.209 11.669 0 11.265 0C8.159 0 6.675 3.877 6.21 5.846c-1.194.365-2.063.636-2.16.674c-.675.213-.694.232-.772.87c-.075.462-1.83 14.063-1.83 14.063L15.009 24l.927-21.166z">
                                                </path>
                                            </svg>
                                        </div>
                                        <div>Install app</div>
                                    </a>
                                </div>
                            </div>
                            <div class="image-wrap margin-top">
                                <div data-poster-url="images/pic6.jpg" data-video-urls="images/video5.mp4,images/video6.webm" data-autoplay="false" data-loop="true" data-wf-ignore="true"
                                    class="background-video big w-background-video w-background-video-atom">
                                    <video id="93a9b608-c096-15e6-7299-1fd9130e577b-video" loop="" style="background-image:url(&quot;images/pic6.jpg&quot;)" muted="" playsinline="" data-wf-ignore="true" data-object-fit="cover">
                                        <source src="images/video5.mp4" data-wf-ignore="true">
                                        <source src="images/video6.webm" data-wf-ignore="true">
                                    </video>
                                    <noscript>
                                        <style>
                                            [data-wf-bgvideo-fallback-img] {
                                                display: none;
                                            }

                                            @media (prefers-reduced-motion: reduce) {
                                                [data-wf-bgvideo-fallback-img] {
                                                    position: absolute;
                                                    z-index: -100;
                                                    display: inline-block;
                                                    height: 100%;
                                                    width: 100%;
                                                    object-fit: cover;
                                                }
                                            }
                                        </style>
                                        <img data-wf-bgvideo-fallback-img="true" src="images/pic6.jpg" alt="">
                                    </noscript>
                                    <div aria-live="polite">
                                        <button type="button" data-w-bg-video-control="true" aria-controls="93a9b608-c096-15e6-7299-1fd9130e577b-video" data-w-id="0a28c0ac-71ab-8e81-40b0-84fe345b67be" class="w-backgroundvideo-backgroundvideoplaypausebutton play-pause-button w-background-video--control">
                                            <span class="play-state">
                                                <img width="50" loading="lazy" alt="Pause video" src="images/pic7.svg" class="play-pause-image">
                                            </span>
                                            <span hidden="">
                                                <img width="50" loading="lazy" alt="Play video" src="images/pic7.svg" class="play-pause-image">
                                            </span>
                                        </button>
                                    </div>
                                    <div style="display:block" class="background-cover first"></div>
                                </div>
                            </div>
                        </div>
                        <div class="layout486_content">
                            <div class="layout486_number show-mobile-landscape">02</div>
                            <div class="layout486_progress-wrapper">
                                <div class="layout486_progress-bar"></div>
                            </div>
                            <div class="margin-bottom margin-xsmall">
                                <div class="button is-secondary is-small is-tagline">Connect</div>
                            </div>
                            <div class="margin-bottom margin-small">
                                <h2>Connect your store with Webflow</h2>
                            </div>
                            <p class="text-size-medium">Pick the Webflow project you want to hook up to Shopify and let ASW Founders
                                do its thing with one click. Before diving into customization, don&#x27;t forget to connect your
                                domain in the ASW Founders dashboard (in your project settings) and paste our magic JS script into the
                                custom code section.</p>
                            <div class="image-wrap margin-top">
                                <div data-poster-url="images/pic6.jpg" data-video-urls="images/video7.mp4,images/video8.webm" data-autoplay="false" data-loop="true" data-wf-ignore="true" class="background-video big w-background-video w-background-video-atom">
                                    <video id="6eed7495-2ba0-4693-8a67-99c499c14edc-video" loop="" style="background-image:url(&quot;images/pic6.jpg&quot;)" muted="" playsinline="" data-wf-ignore="true" data-object-fit="cover">
                                        <source src="images/video7.mp4" data-wf-ignore="true">
                                        <source src="images/video8.webm" data-wf-ignore="true">
                                    </video>
                                    <noscript>
                                        <style>
                                            [data-wf-bgvideo-fallback-img] {
                                                display: none;
                                            }

                                            @media (prefers-reduced-motion: reduce) {
                                                [data-wf-bgvideo-fallback-img] {
                                                    position: absolute;
                                                    z-index: -100;
                                                    display: inline-block;
                                                    height: 100%;
                                                    width: 100%;
                                                    object-fit: cover;
                                                }
                                            }
                                        </style>
                                        <img data-wf-bgvideo-fallback-img="true" src="images/pic6.jpg" alt="">
                                    </noscript>
                                    <div aria-live="polite">
                                        <button type="button" data-w-bg-video-control="true"
                                            aria-controls="6eed7495-2ba0-4693-8a67-99c499c14edc-video"
                                            data-w-id="6eed7495-2ba0-4693-8a67-99c499c14edd"
                                            class="w-backgroundvideo-backgroundvideoplaypausebutton play-pause-button w-background-video--control">
                                            <span class="play-state">
                                                <img width="50" loading="lazy" alt="Pause video"
                                                    src="images/pic7.svg" class="play-pause-image">
                                            </span>
                                            <span hidden="">
                                                <img width="50" loading="lazy" alt="Play video" src="images/pic7.svg" class="play-pause-image">
                                            </span>
                                        </button>
                                    </div>
                                    <div style="display:block" class="background-cover second"></div>
                                </div>
                            </div>
                        </div>
                        <div class="layout486_content">
                            <div class="layout486_number show-mobile-landscape">03</div>
                            <div class="layout486_progress-wrapper">
                                <div class="layout486_progress-bar"></div>
                            </div>
                            <div class="margin-bottom margin-xsmall">
                                <div class="button is-secondary is-small is-tagline">Customize</div>
                            </div>
                            <div class="margin-bottom margin-small">
                                <h2>Customize the project with our app</h2>
                            </div>
                            <p class="text-size-medium">Customize any element of your store with the Official ASW Founders Webflow App. Copy &amp; paste all the elements you need without moving out from the Webflow designer.</p>
                            <div class="margin-top margin-medium">
                                <div class="button-group">
                                    <a href="#" class="button is-icon is-small w-inline-block">
                                        <img src="images/pic2.svg" loading="lazy" alt="Webflow Logo" class="icon-embed-xsmall">
                                        <div>Install app</div>
                                    </a>
                                </div>
                            </div>
                            <div class="image-wrap margin-top">
                                <div data-poster-url="images/pic6.jpg" data-video-urls="images/video9.mp4,images/video10.webm" data-autoplay="false" data-loop="true" data-wf-ignore="true" class="background-video big w-background-video w-background-video-atom">
                                    <video id="70ffd5a2-6b87-9d5a-47af-4028546ff4d2-video" loop="" style="background-image:url(&quot;images/pic6.jpg&quot;)" muted="" playsinline="" data-wf-ignore="true" data-object-fit="cover">
                                        <source src="images/video9.mp4" data-wf-ignore="true">
                                        <source src="images/video10.webm" data-wf-ignore="true">
                                    </video>
                                    <noscript>
                                        <style>
                                            [data-wf-bgvideo-fallback-img] {
                                                display: none;
                                            }

                                            @media (prefers-reduced-motion: reduce) {
                                                [data-wf-bgvideo-fallback-img] {
                                                    position: absolute;
                                                    z-index: -100;
                                                    display: inline-block;
                                                    height: 100%;
                                                    width: 100%;
                                                    object-fit: cover;
                                                }
                                            }
                                        </style>
                                        <img data-wf-bgvideo-fallback-img="true" src="images/pic6.jpg" alt="">
                                    </noscript>
                                    <div aria-live="polite">
                                        <button type="button" data-w-bg-video-control="true"
                                            aria-controls="70ffd5a2-6b87-9d5a-47af-4028546ff4d2-video"
                                            data-w-id="70ffd5a2-6b87-9d5a-47af-4028546ff4d3"
                                            class="w-backgroundvideo-backgroundvideoplaypausebutton play-pause-button w-background-video--control">
                                            <span class="play-state">
                                                <img width="50" loading="lazy" alt="Pause video" src="images/pic7.svg" class="play-pause-image">
                                            </span>
                                            <span hidden="">
                                                <img width="50" loading="lazy" alt="Play video" src="images/pic7.svg" class="play-pause-image">
                                            </span>
                                        </button>
                                    </div>
                                    <div style="display:block" class="background-cover third"></div>
                                </div>
                            </div>
                        </div>
                        <div class="layout486_content">
                            <div class="layout486_number show-mobile-landscape">04</div>
                            <div class="layout486_progress-wrapper">
                                <div class="layout486_progress-bar"></div>
                            </div>
                            <div class="margin-bottom margin-xsmall">
                                <div class="button is-secondary is-small is-tagline">Manage</div>
                            </div>
                            <div class="margin-bottom margin-small">
                                <h2>Keep CMSs synced with our server plan</h2>
                            </div>
                            <p class="text-size-medium">You can easily import your Shopify data into Webflow and keep your
                                Webflow project and Shopify store automatically synced through our CMS Server Sync functionality.
                            </p>
                            <div class="image-wrap margin-top">
                                <div data-poster-url="images/pic6.jpg" data-video-urls="images/video11.mp4,images/video12.webm" data-autoplay="false" data-loop="true" data-wf-ignore="true" class="background-video big w-background-video w-background-video-atom">
                                    <video id="b14479f6-db03-a6db-2065-e9df1b49422a-video" loop="" style="background-image:url(&quot;images/pic6.jpg&quot;)" muted="" playsinline="" data-wf-ignore="true" data-object-fit="cover">
                                        <source src="images/video11.mp4" data-wf-ignore="true">
                                        <source src="images/video12.webm" data-wf-ignore="true">
                                    </video>
                                    <noscript>
                                        <style>
                                            [data-wf-bgvideo-fallback-img] {
                                                display: none;
                                            }

                                            @media (prefers-reduced-motion: reduce) {
                                                [data-wf-bgvideo-fallback-img] {
                                                    position: absolute;
                                                    z-index: -100;
                                                    display: inline-block;
                                                    height: 100%;
                                                    width: 100%;
                                                    object-fit: cover;
                                                }
                                            }
                                        </style>
                                        <img data-wf-bgvideo-fallback-img="true" src="images/pic6.jpg" alt="">
                                    </noscript>
                                    <div aria-live="polite">
                                        <button type="button" data-w-bg-video-control="true"
                                            aria-controls="b14479f6-db03-a6db-2065-e9df1b49422a-video"
                                            data-w-id="b14479f6-db03-a6db-2065-e9df1b49422b"
                                            class="w-backgroundvideo-backgroundvideoplaypausebutton play-pause-button w-background-video--control">
                                            <span class="play-state">
                                                <img width="50" loading="lazy" alt="Pause video" src="images/pic7.svg" class="play-pause-image"></span>
                                            <span hidden="">
                                                <img width="50" loading="lazy" alt="Play video" src="images/pic7.svg" class="play-pause-image">
                                            </span>
                                        </button>
                                    </div>
                                    <div style="display:block" class="background-cover fourth"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="banner">
    <div class="padding-global">
        <div class="container-large">
            <div class="padding-section-large">
                <div class="w-layout-grid elements-card">
                    <div class="layout1_content padding">
                        <div class="margin-bottom margin-xxsmall">
                            <div class="button is-secondary is-small is-tagline">Built with Client-First v2.1</div>
                        </div>
                        <div class="margin-bottom">
                            <h3 class="heading-style-h1">50+ Webflow elements</h3>
                        </div>
                        <p class="text-size-medium">
                            <strong>Seamlessly integrate Shopify into your Webflow projects with our pre-built elements.</strong> Simply copy and paste these elements directly into your design using our Webflow App, and focus on creating stunning visuals. No coding required.
                        </p>
                        <div class="margin-top margin-medium">
                            <div class="button-group">
                                <a href="features.php" class="button is-secondary is-small w-button">
                                    More details</a>
                                <a href="#" class="button is-icon is-small w-inline-block">
                                    <img src="images/pic2.svg" loading="lazy" alt="Webflow Logo" class="icon-embed-xsmall">
                                    <div>Install app</div>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="layout1_image-wrapper loop">
                        <div id="w-node-c76ec6c3-81f9-1e55-376a-9ee37a7a9ef7-7a7a9ede"
                            data-w-id="c76ec6c3-81f9-1e55-376a-9ee37a7a9ef7" class="header76_content-right">
                            <div class="elements-list-wrapper _1">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                            <path fill="currentColor"
                                                d="M2.25 2.25a.75.75 0 0 0 0 1.5h1.386c.17 0 .318.114.362.278l2.558 9.592a3.752 3.752 0 0 0-2.806 3.63c0 .414.336.75.75.75h15.75a.75.75 0 0 0 0-1.5H5.378A2.25 2.25 0 0 1 7.5 15h11.218a.75.75 0 0 0 .674-.421a60.358 60.358 0 0 0 2.96-7.228a.75.75 0 0 0-.525-.965A60.864 60.864 0 0 0 5.68 4.509l-.232-.867A1.875 1.875 0 0 0 3.636 2.25H2.25Zm1.5 18a1.5 1.5 0 1 1 3 0a1.5 1.5 0 0 1-3 0Zm12.75 0a1.5 1.5 0 1 1 3 0a1.5 1.5 0 0 1-3 0Z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Add to cart</div>
                            </div>
                            <div class="elements-list-wrapper _2">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                            <path fill="currentColor"
                                                d="M10 3.75a2 2 0 1 0-4 0a2 2 0 0 0 4 0Zm7.25.75a.75.75 0 0 0 0-1.5h-5.5a.75.75 0 0 0 0 1.5h5.5ZM5 3.75a.75.75 0 0 1-.75.75h-1.5a.75.75 0 0 1 0-1.5h1.5a.75.75 0 0 1 .75.75ZM4.25 17a.75.75 0 0 0 0-1.5h-1.5a.75.75 0 0 0 0 1.5h1.5Zm13 0a.75.75 0 0 0 0-1.5h-5.5a.75.75 0 0 0 0 1.5h5.5ZM9 10a.75.75 0 0 1-.75.75h-5.5a.75.75 0 0 1 0-1.5h5.5A.75.75 0 0 1 9 10Zm8.25.75a.75.75 0 0 0 0-1.5h-1.5a.75.75 0 0 0 0 1.5h1.5ZM14 10a2 2 0 1 0-4 0a2 2 0 0 0 4 0Zm-4 6.25a2 2 0 1 0-4 0a2 2 0 0 0 4 0Z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Products filter<br></div>
                            </div>
                            <div class="elements-list-wrapper _3">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                            <path fill="currentColor" fill-rule="evenodd"
                                                d="M4.93 1.31a41.401 41.401 0 0 1 10.14 0A2.213 2.213 0 0 1 17 3.517V18.25a.75.75 0 0 1-1.075.676l-2.8-1.344l-2.8 1.344a.75.75 0 0 1-.65 0l-2.8-1.344l-2.8 1.344A.75.75 0 0 1 3 18.25V3.517c0-1.103.806-2.068 1.93-2.207Zm8.85 5.97a.75.75 0 0 0-1.06-1.06l-6.5 6.5a.75.75 0 1 0 1.06 1.06l6.5-6.5ZM9 8a1 1 0 1 1-2 0a1 1 0 0 1 2 0Zm3 5a1 1 0 1 0 0-2a1 1 0 0 0 0 2Z"
                                                clip-rule="evenodd">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Discount<br></div>
                            </div>
                            <div class="elements-list-wrapper _4">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                            <g fill="currentColor" fill-rule="evenodd" clip-rule="evenodd">
                                                <path
                                                    d="M3 4.25A2.25 2.25 0 0 1 5.25 2h5.5A2.25 2.25 0 0 1 13 4.25v2a.75.75 0 0 1-1.5 0v-2a.75.75 0 0 0-.75-.75h-5.5a.75.75 0 0 0-.75.75v11.5c0 .414.336.75.75.75h5.5a.75.75 0 0 0 .75-.75v-2a.75.75 0 0 1 1.5 0v2A2.25 2.25 0 0 1 10.75 18h-5.5A2.25 2.25 0 0 1 3 15.75V4.25Z">
                                                </path>
                                                <path
                                                    d="M19 10a.75.75 0 0 0-.75-.75H8.704l1.048-.943a.75.75 0 1 0-1.004-1.114l-2.5 2.25a.75.75 0 0 0 0 1.114l2.5 2.25a.75.75 0 1 0 1.004-1.114l-1.048-.943h9.546A.75.75 0 0 0 19 10Z">
                                                </path>
                                            </g>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Login form</div>
                            </div>
                            <div class="elements-list-wrapper _5">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                            <path fill="currentColor" fill-rule="evenodd"
                                                d="M1.5 6a2.25 2.25 0 0 1 2.25-2.25h16.5A2.25 2.25 0 0 1 22.5 6v12a2.25 2.25 0 0 1-2.25 2.25H3.75A2.25 2.25 0 0 1 1.5 18V6ZM3 16.06V18c0 .414.336.75.75.75h16.5A.75.75 0 0 0 21 18v-1.94l-2.69-2.689a1.5 1.5 0 0 0-2.12 0l-.88.879l.97.97a.75.75 0 1 1-1.06 1.06l-5.16-5.159a1.5 1.5 0 0 0-2.12 0L3 16.061Zm10.125-7.81a1.125 1.125 0 1 1 2.25 0a1.125 1.125 0 0 1-2.25 0Z"
                                                clip-rule="evenodd">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Image slider</div>
                            </div>
                            <div class="elements-list-wrapper _6">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                            <path fill="currentColor" fill-rule="evenodd"
                                                d="M18 10a8 8 0 1 1-16 0a8 8 0 0 1 16 0Zm-5.5-2.5a2.5 2.5 0 1 1-5 0a2.5 2.5 0 0 1 5 0ZM10 12a5.99 5.99 0 0 0-4.793 2.39A6.483 6.483 0 0 0 10 16.5a6.483 6.483 0 0 0 4.793-2.11A5.99 5.99 0 0 0 10 12Z"
                                                clip-rule="evenodd">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Account Info</div>
                            </div>
                            <div class="elements-list-wrapper _7">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                            <path fill="currentColor" fill-rule="evenodd"
                                                d="m9.69 18.933l.003.001C9.89 19.02 10 19 10 19s.11.02.308-.066l.002-.001l.006-.003l.018-.008a5.741 5.741 0 0 0 .281-.14c.186-.096.446-.24.757-.433c.62-.384 1.445-.966 2.274-1.765C15.302 14.988 17 12.493 17 9A7 7 0 1 0 3 9c0 3.492 1.698 5.988 3.355 7.584a13.731 13.731 0 0 0 2.273 1.765a11.842 11.842 0 0 0 .976.544l.062.029l.018.008l.006.003ZM10 11.25a2.25 2.25 0 1 0 0-4.5a2.25 2.25 0 0 0 0 4.5Z"
                                                clip-rule="evenodd">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Store locator</div>
                            </div>
                            <div class="elements-list-wrapper _8">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                            <path fill="currentColor" fill-rule="evenodd"
                                                d="M9 3.5a5.5 5.5 0 1 0 0 11a5.5 5.5 0 0 0 0-11ZM2 9a7 7 0 1 1 12.452 4.391l3.328 3.329a.75.75 0 1 1-1.06 1.06l-3.329-3.328A7 7 0 0 1 2 9Z"
                                                clip-rule="evenodd">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Predictive search</div>
                            </div>
                            <div class="elements-list-wrapper _9">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                            <path fill="currentColor" fill-rule="evenodd"
                                                d="M10.5 3.75a6 6 0 0 0-5.98 6.496A5.25 5.25 0 0 0 6.75 20.25H18a4.5 4.5 0 0 0 2.206-8.423a3.75 3.75 0 0 0-4.133-4.303A6.001 6.001 0 0 0 10.5 3.75Zm2.03 5.47a.75.75 0 0 0-1.06 0l-3 3a.75.75 0 1 0 1.06 1.06l1.72-1.72v4.94a.75.75 0 0 0 1.5 0v-4.94l1.72 1.72a.75.75 0 1 0 1.06-1.06l-3-3Z"
                                                clip-rule="evenodd">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">File upload</div>
                            </div>
                            <div class="elements-list-wrapper _10">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                            <path fill="currentColor"
                                                d="M5.127 3.502L5.25 3.5h9.5c.041 0 .082 0 .123.002A2.251 2.251 0 0 0 12.75 2h-5.5a2.25 2.25 0 0 0-2.123 1.502ZM1 10.25A2.25 2.25 0 0 1 3.25 8h13.5A2.25 2.25 0 0 1 19 10.25v5.5A2.25 2.25 0 0 1 16.75 18H3.25A2.25 2.25 0 0 1 1 15.75v-5.5ZM3.25 6.5c-.04 0-.082 0-.123.002A2.25 2.25 0 0 1 5.25 5h9.5c.98 0 1.814.627 2.123 1.502a3.819 3.819 0 0 0-.123-.002H3.25Z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Bundles</div>
                            </div>
                        </div>
                        <div id="w-node-_4153e1c9-dcc3-4a95-d7a4-bc763bd8c6f8-7a7a9ede" class="header76_content-right">
                            <div class="elements-list-wrapper _1">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                            <path fill="currentColor"
                                                d="M2.25 2.25a.75.75 0 0 0 0 1.5h1.386c.17 0 .318.114.362.278l2.558 9.592a3.752 3.752 0 0 0-2.806 3.63c0 .414.336.75.75.75h15.75a.75.75 0 0 0 0-1.5H5.378A2.25 2.25 0 0 1 7.5 15h11.218a.75.75 0 0 0 .674-.421a60.358 60.358 0 0 0 2.96-7.228a.75.75 0 0 0-.525-.965A60.864 60.864 0 0 0 5.68 4.509l-.232-.867A1.875 1.875 0 0 0 3.636 2.25H2.25Zm1.5 18a1.5 1.5 0 1 1 3 0a1.5 1.5 0 0 1-3 0Zm12.75 0a1.5 1.5 0 1 1 3 0a1.5 1.5 0 0 1-3 0Z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Add to cart</div>
                            </div>
                            <div class="elements-list-wrapper _2">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                            <path fill="currentColor"
                                                d="M10 3.75a2 2 0 1 0-4 0a2 2 0 0 0 4 0Zm7.25.75a.75.75 0 0 0 0-1.5h-5.5a.75.75 0 0 0 0 1.5h5.5ZM5 3.75a.75.75 0 0 1-.75.75h-1.5a.75.75 0 0 1 0-1.5h1.5a.75.75 0 0 1 .75.75ZM4.25 17a.75.75 0 0 0 0-1.5h-1.5a.75.75 0 0 0 0 1.5h1.5Zm13 0a.75.75 0 0 0 0-1.5h-5.5a.75.75 0 0 0 0 1.5h5.5ZM9 10a.75.75 0 0 1-.75.75h-5.5a.75.75 0 0 1 0-1.5h5.5A.75.75 0 0 1 9 10Zm8.25.75a.75.75 0 0 0 0-1.5h-1.5a.75.75 0 0 0 0 1.5h1.5ZM14 10a2 2 0 1 0-4 0a2 2 0 0 0 4 0Zm-4 6.25a2 2 0 1 0-4 0a2 2 0 0 0 4 0Z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Products filter<br></div>
                            </div>
                            <div class="elements-list-wrapper _3">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                            <path fill="currentColor" fill-rule="evenodd"
                                                d="M4.93 1.31a41.401 41.401 0 0 1 10.14 0A2.213 2.213 0 0 1 17 3.517V18.25a.75.75 0 0 1-1.075.676l-2.8-1.344l-2.8 1.344a.75.75 0 0 1-.65 0l-2.8-1.344l-2.8 1.344A.75.75 0 0 1 3 18.25V3.517c0-1.103.806-2.068 1.93-2.207Zm8.85 5.97a.75.75 0 0 0-1.06-1.06l-6.5 6.5a.75.75 0 1 0 1.06 1.06l6.5-6.5ZM9 8a1 1 0 1 1-2 0a1 1 0 0 1 2 0Zm3 5a1 1 0 1 0 0-2a1 1 0 0 0 0 2Z"
                                                clip-rule="evenodd">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Discount<br></div>
                            </div>
                            <div class="elements-list-wrapper _4">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                            <g fill="currentColor" fill-rule="evenodd" clip-rule="evenodd">
                                                <path
                                                    d="M3 4.25A2.25 2.25 0 0 1 5.25 2h5.5A2.25 2.25 0 0 1 13 4.25v2a.75.75 0 0 1-1.5 0v-2a.75.75 0 0 0-.75-.75h-5.5a.75.75 0 0 0-.75.75v11.5c0 .414.336.75.75.75h5.5a.75.75 0 0 0 .75-.75v-2a.75.75 0 0 1 1.5 0v2A2.25 2.25 0 0 1 10.75 18h-5.5A2.25 2.25 0 0 1 3 15.75V4.25Z">
                                                </path>
                                                <path
                                                    d="M19 10a.75.75 0 0 0-.75-.75H8.704l1.048-.943a.75.75 0 1 0-1.004-1.114l-2.5 2.25a.75.75 0 0 0 0 1.114l2.5 2.25a.75.75 0 1 0 1.004-1.114l-1.048-.943h9.546A.75.75 0 0 0 19 10Z">
                                                </path>
                                            </g>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Login form</div>
                            </div>
                            <div class="elements-list-wrapper _5">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                            <path fill="currentColor" fill-rule="evenodd"
                                                d="M1.5 6a2.25 2.25 0 0 1 2.25-2.25h16.5A2.25 2.25 0 0 1 22.5 6v12a2.25 2.25 0 0 1-2.25 2.25H3.75A2.25 2.25 0 0 1 1.5 18V6ZM3 16.06V18c0 .414.336.75.75.75h16.5A.75.75 0 0 0 21 18v-1.94l-2.69-2.689a1.5 1.5 0 0 0-2.12 0l-.88.879l.97.97a.75.75 0 1 1-1.06 1.06l-5.16-5.159a1.5 1.5 0 0 0-2.12 0L3 16.061Zm10.125-7.81a1.125 1.125 0 1 1 2.25 0a1.125 1.125 0 0 1-2.25 0Z"
                                                clip-rule="evenodd">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Image slider</div>
                            </div>
                            <div class="elements-list-wrapper _6">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                            <path fill="currentColor" fill-rule="evenodd"
                                                d="M18 10a8 8 0 1 1-16 0a8 8 0 0 1 16 0Zm-5.5-2.5a2.5 2.5 0 1 1-5 0a2.5 2.5 0 0 1 5 0ZM10 12a5.99 5.99 0 0 0-4.793 2.39A6.483 6.483 0 0 0 10 16.5a6.483 6.483 0 0 0 4.793-2.11A5.99 5.99 0 0 0 10 12Z"
                                                clip-rule="evenodd">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Account Info</div>
                            </div>
                            <div class="elements-list-wrapper _7">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                            <path fill="currentColor" fill-rule="evenodd"
                                                d="m9.69 18.933l.003.001C9.89 19.02 10 19 10 19s.11.02.308-.066l.002-.001l.006-.003l.018-.008a5.741 5.741 0 0 0 .281-.14c.186-.096.446-.24.757-.433c.62-.384 1.445-.966 2.274-1.765C15.302 14.988 17 12.493 17 9A7 7 0 1 0 3 9c0 3.492 1.698 5.988 3.355 7.584a13.731 13.731 0 0 0 2.273 1.765a11.842 11.842 0 0 0 .976.544l.062.029l.018.008l.006.003ZM10 11.25a2.25 2.25 0 1 0 0-4.5a2.25 2.25 0 0 0 0 4.5Z"
                                                clip-rule="evenodd">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Store locator</div>
                            </div>
                            <div class="elements-list-wrapper _8">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                            <path fill="currentColor" fill-rule="evenodd"
                                                d="M9 3.5a5.5 5.5 0 1 0 0 11a5.5 5.5 0 0 0 0-11ZM2 9a7 7 0 1 1 12.452 4.391l3.328 3.329a.75.75 0 1 1-1.06 1.06l-3.329-3.328A7 7 0 0 1 2 9Z"
                                                clip-rule="evenodd">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Predictive search</div>
                            </div>
                            <div class="elements-list-wrapper _9">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                            <path fill="currentColor" fill-rule="evenodd"
                                                d="M10.5 3.75a6 6 0 0 0-5.98 6.496A5.25 5.25 0 0 0 6.75 20.25H18a4.5 4.5 0 0 0 2.206-8.423a3.75 3.75 0 0 0-4.133-4.303A6.001 6.001 0 0 0 10.5 3.75Zm2.03 5.47a.75.75 0 0 0-1.06 0l-3 3a.75.75 0 1 0 1.06 1.06l1.72-1.72v4.94a.75.75 0 0 0 1.5 0v-4.94l1.72 1.72a.75.75 0 1 0 1.06-1.06l-3-3Z"
                                                clip-rule="evenodd">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">File upload</div>
                            </div>
                            <div class="elements-list-wrapper _10">
                                <div class="navbar-dropdown8_icon-wrapper big">
                                    <div class="icon-embed-medium w-embed">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                            <path fill="currentColor"
                                                d="M5.127 3.502L5.25 3.5h9.5c.041 0 .082 0 .123.002A2.251 2.251 0 0 0 12.75 2h-5.5a2.25 2.25 0 0 0-2.123 1.502ZM1 10.25A2.25 2.25 0 0 1 3.25 8h13.5A2.25 2.25 0 0 1 19 10.25v5.5A2.25 2.25 0 0 1 16.75 18H3.25A2.25 2.25 0 0 1 1 15.75v-5.5ZM3.25 6.5c-.04 0-.082 0-.123.002A2.25 2.25 0 0 1 5.25 5h9.5c.98 0 1.814.627 2.123 1.502a3.819 3.819 0 0 0-.123-.002H3.25Z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="features-label">Bundles</div>
                            </div>
                        </div>
                        <div class="cover-opacity"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section data-w-id="79dc4bc2-ba1d-0b50-e7f6-1e6b8adff1ba" class="section_banner13">
    <div class="padding-section-large">
        <div class="banner13_component">
            <h1 class="banner13_heading-top">no-code, no-export, no-problems, no-code, no-export, no-problems, no-code, no-export, no-problems, no-code, no-export, no-problems, </h1>
            <h1 class="banner13_heading-bottom">#webflow #shopify #webflow #shopify #webflow #shopify</h1>
        </div>
    </div>
</section>
<section class="hover-list">
    <div class="padding-global">
        <div class="container-large">
            <div class="padding-section-large">
                <div class="margin-bottom margin-medium">
                    <div class="button is-secondary is-small is-tagline">Community is our priority</div>
                </div>
                <div class="cta38_component">
                    <a data-w-id="57c99c6e-5ba5-7dbd-98ff-87ffbfe7a649" href="ai-assistant.php"
                        class="cta38_link-block w-inline-block">
                        <div class="navbar-dropdown8_icon-wrapper big">
                            <div class="icon-embed-medium w-embed">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                    <path fill="currentColor" fill-rule="evenodd"
                                        d="M9 4.5a.75.75 0 0 1 .721.544l.813 2.846a3.75 3.75 0 0 0 2.576 2.576l2.846.813a.75.75 0 0 1 0 1.442l-2.846.813a3.75 3.75 0 0 0-2.576 2.576l-.813 2.846a.75.75 0 0 1-1.442 0l-.813-2.846a3.75 3.75 0 0 0-2.576-2.576l-2.846-.813a.75.75 0 0 1 0-1.442l2.846-.813A3.75 3.75 0 0 0 7.466 7.89l.813-2.846A.75.75 0 0 1 9 4.5Zm9-3a.75.75 0 0 1 .728.568l.258 1.036a2.63 2.63 0 0 0 1.91 1.91l1.036.258a.75.75 0 0 1 0 1.456l-1.036.258a2.63 2.63 0 0 0-1.91 1.91l-.258 1.036a.75.75 0 0 1-1.456 0l-.258-1.036a2.625 2.625 0 0 0-1.91-1.91l-1.036-.258a.75.75 0 0 1 0-1.456l1.036-.258a2.625 2.625 0 0 0 1.91-1.91l.258-1.036A.75.75 0 0 1 18 1.5ZM16.5 15a.75.75 0 0 1 .712.513l.394 1.183c.15.447.5.799.948.948l1.183.395a.75.75 0 0 1 0 1.422l-1.183.395a1.5 1.5 0 0 0-.948.948l-.395 1.183a.75.75 0 0 1-1.422 0l-.395-1.183a1.5 1.5 0 0 0-.948-.948l-1.183-.395a.75.75 0 0 1 0-1.422l1.183-.395a1.5 1.5 0 0 0 .948-.948l.395-1.183A.75.75 0 0 1 16.5 15Z"
                                        clip-rule="evenodd">
                                    </path>
                                </svg>
                            </div>
                        </div>
                        <div class="cta38_link-image-wrapper pointer-events-off">
                            <img src="images/pic8.webp" loading="eager" sizes="100vw" alt="ASW Founders AI" class="cta38_link-image">
                        </div>
                        <h3 class="cta38_link-text">AI assistant <span class="new-tag big dark">beta</span></h3>
                    </a>
                    <a data-w-id="57c99c6e-5ba5-7dbd-98ff-87ffbfe7a650" href="support.php"
                        class="cta38_link-block w-inline-block">
                        <div class="navbar-dropdown8_icon-wrapper big">
                            <div class="icon-embed-medium w-embed">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--heroicons" width="100%" height="100%" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                    <path fill="currentColor" fill-rule="evenodd"
                                        d="M12.516 2.17a.75.75 0 0 0-1.032 0a11.209 11.209 0 0 1-7.877 3.08a.75.75 0 0 0-.722.515A12.74 12.74 0 0 0 2.25 9.75c0 5.942 4.064 10.933 9.563 12.348a.749.749 0 0 0 .374 0c5.499-1.415 9.563-6.406 9.563-12.348c0-1.39-.223-2.73-.635-3.985a.75.75 0 0 0-.722-.516l-.143.001c-2.996 0-5.717-1.17-7.734-3.08Zm3.094 8.016a.75.75 0 1 0-1.22-.872l-3.236 4.53L9.53 12.22a.75.75 0 0 0-1.06 1.06l2.25 2.25a.75.75 0 0 0 1.14-.094l3.75-5.25Z"
                                        clip-rule="evenodd">
                                    </path>
                                </svg>
                            </div>
                        </div>
                        <h3 class="cta38_link-text">Premium support</h3>
                        <div class="cta38_link-image-wrapper pointer-events-off">
                            <img src="https://cdn.prod.website-files.com/66c74b953957211a234767e2/66e7e755e98601f55976ec61_Screenshot%202024-09-16%20100703.avif" loading="eager" sizes="100vw" alt="Connect to Webflow" class="cta38_link-image">
                        </div>
                    </a><a data-w-id="57c99c6e-5ba5-7dbd-98ff-87ffbfe7a657" href="academy.php"
                        class="cta38_link-block w-inline-block">
                        <div class="navbar-dropdown8_icon-wrapper big">
                            <div class="icon-embed-medium w-embed"><svg xmlns="http://www.w3.org/2000/svg"
                                    xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img"
                                    class="iconify iconify--heroicons" width="100%" height="100%"
                                    preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                    <g fill="currentColor">
                                        <path
                                            d="M11.7 2.805a.75.75 0 0 1 .6 0A60.65 60.65 0 0 1 22.83 8.72a.75.75 0 0 1-.231 1.337a49.949 49.949 0 0 0-9.902 3.912l-.003.002l-.34.18a.75.75 0 0 1-.707 0A50.009 50.009 0 0 0 7.5 12.174v-.224a.36.36 0 0 1 .172-.311a54.614 54.614 0 0 1 4.653-2.52a.75.75 0 0 0-.65-1.352a56.129 56.129 0 0 0-4.78 2.589a1.858 1.858 0 0 0-.859 1.228a49.803 49.803 0 0 0-4.634-1.527a.75.75 0 0 1-.231-1.337A60.653 60.653 0 0 1 11.7 2.805Z">
                                        </path>
                                        <path
                                            d="M13.06 15.473a48.45 48.45 0 0 1 7.666-3.282a61.14 61.14 0 0 1 .255 4.285a.75.75 0 0 1-.46.71a47.878 47.878 0 0 0-8.105 4.342a.75.75 0 0 1-.832 0a47.877 47.877 0 0 0-8.104-4.342a.75.75 0 0 1-.461-.71c.035-1.442.121-2.87.255-4.286A48.4 48.4 0 0 1 6 13.18v1.27a1.5 1.5 0 0 0-.14 2.508c-.09.38-.222.753-.397 1.11c.452.213.901.434 1.346.661a6.729 6.729 0 0 0 .551-1.608a1.5 1.5 0 0 0 .14-2.67v-.645a48.549 48.549 0 0 1 3.44 1.668a2.25 2.25 0 0 0 2.12 0Z">
                                        </path>
                                        <path
                                            d="M4.462 19.462c.42-.419.753-.89 1-1.394c.453.213.902.434 1.347.661a6.743 6.743 0 0 1-1.286 1.794a.75.75 0 1 1-1.06-1.06Z">
                                        </path>
                                    </g>
                                </svg></div>
                        </div>
                        <h3 class="cta38_link-text">Academy<span class="new-tag big">new</span></h3>
                        <div class="cta38_link-image-wrapper pointer-events-off"><img
                                src="images/services1.avif"
                                loading="eager" sizes="100vw"
                                srcset="images/services1.avif"
                                alt="ASW Founders-academy" class="cta38_link-image"></div>
                    </a><a data-w-id="57c99c6e-5ba5-7dbd-98ff-87ffbfe7a65e" href="https://discord.gg/MKeQqEZmjd"
                        target="_blank" class="cta38_link-block w-inline-block">
                        <div class="navbar-dropdown8_icon-wrapper big">
                            <div class="icon-embed-medium w-embed"><svg xmlns="http://www.w3.org/2000/svg"
                                    xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img"
                                    class="iconify iconify--simple-icons" width="100%" height="100%"
                                    preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                    <path fill="currentColor"
                                        d="M20.317 4.37a19.791 19.791 0 0 0-4.885-1.515a.074.074 0 0 0-.079.037c-.21.375-.444.864-.608 1.25a18.27 18.27 0 0 0-5.487 0a12.64 12.64 0 0 0-.617-1.25a.077.077 0 0 0-.079-.037A19.736 19.736 0 0 0 3.677 4.37a.07.07 0 0 0-.032.027C.533 9.046-.32 13.58.099 18.057a.082.082 0 0 0 .031.057a19.9 19.9 0 0 0 5.993 3.03a.078.078 0 0 0 .084-.028a14.09 14.09 0 0 0 1.226-1.994a.076.076 0 0 0-.041-.106a13.107 13.107 0 0 1-1.872-.892a.077.077 0 0 1-.008-.128a10.2 10.2 0 0 0 .372-.292a.074.074 0 0 1 .077-.01c3.928 1.793 8.18 1.793 12.062 0a.074.074 0 0 1 .078.01c.12.098.246.198.373.292a.077.077 0 0 1-.006.127a12.299 12.299 0 0 1-1.873.892a.077.077 0 0 0-.041.107c.36.698.772 1.362 1.225 1.993a.076.076 0 0 0 .084.028a19.839 19.839 0 0 0 6.002-3.03a.077.077 0 0 0 .032-.054c.5-5.177-.838-9.674-3.549-13.66a.061.061 0 0 0-.031-.03zM8.02 15.33c-1.183 0-2.157-1.085-2.157-2.419c0-1.333.956-2.419 2.157-2.419c1.21 0 2.176 1.096 2.157 2.42c0 1.333-.956 2.418-2.157 2.418zm7.975 0c-1.183 0-2.157-1.085-2.157-2.419c0-1.333.955-2.419 2.157-2.419c1.21 0 2.176 1.096 2.157 2.42c0 1.333-.946 2.418-2.157 2.418Z">
                                    </path>
                                </svg></div>
                        </div>
                        <h3 class="cta38_link-text">Discord community</h3>
                        <div class="cta38_link-image-wrapper pointer-events-off"><img
                                src="images/services2.avif"
                                loading="eager" sizes="100vw"
                                srcset="images/services2.avif"
                                alt="ASW Founders discord" class="cta38_link-image no-border"></div>
                    </a><a data-w-id="e487dd06-24b0-9b26-0786-29ba00574979"
                        href="https://docs.ASW Founders.io/getting-started/intro/" target="_blank"
                        class="cta38_link-block w-inline-block">
                        <div class="navbar-dropdown8_icon-wrapper big">
                            <div class="icon-embed-medium w-embed"><svg xmlns="http://www.w3.org/2000/svg"
                                    xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img"
                                    class="iconify iconify--heroicons" width="100%" height="100%"
                                    preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                    <path fill="currentColor"
                                        d="M4.75 3A1.75 1.75 0 0 0 3 4.75v2.752l.104-.002h13.792c.035 0 .07 0 .104.002V6.75A1.75 1.75 0 0 0 15.25 5h-3.836a.25.25 0 0 1-.177-.073L9.823 3.513A1.75 1.75 0 0 0 8.586 3H4.75ZM3.104 9a1.75 1.75 0 0 0-1.673 2.265l1.385 4.5A1.75 1.75 0 0 0 4.488 17h11.023a1.75 1.75 0 0 0 1.673-1.235l1.384-4.5A1.75 1.75 0 0 0 16.896 9H3.104Z">
                                    </path>
                                </svg></div>
                        </div>
                        <h3 class="cta38_link-text">Docs</h3>
                        <div class="cta38_link-image-wrapper pointer-events-off"><img
                                src="images/services3.avif"
                                loading="eager" sizes="100vw"
                                srcset="images/services3.avif"
                                alt="ASW Founders docs" class="cta38_link-image"></div>
                    </a><a data-w-id="ee547063-8eed-853a-cbfd-d355c1632d75" href="news.php"
                        class="cta38_link-block w-inline-block">
                        <div class="navbar-dropdown8_icon-wrapper big">
                            <div class="icon-embed-medium w-embed"><svg xmlns="http://www.w3.org/2000/svg"
                                    xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img"
                                    class="iconify iconify--heroicons" width="100%" height="100%"
                                    preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                    <path fill="currentColor"
                                        d="M13.92 3.845a19.361 19.361 0 0 1-6.3 1.98C6.765 5.942 5.89 6 5 6a4 4 0 0 0-.504 7.969a15.974 15.974 0 0 0 1.271 3.341c.397.77 1.342 1 2.05.59l.867-.5c.726-.42.94-1.321.588-2.021a12.07 12.07 0 0 1-.448-1.004c1.8.358 3.511.964 5.096 1.78A17.964 17.964 0 0 0 15 10c0-2.161-.381-4.234-1.08-6.155Zm1.323-.748A19.456 19.456 0 0 1 16.5 10a19.47 19.47 0 0 1-1.257 6.904l-.03.077a.75.75 0 0 0 1.401.537a20.902 20.902 0 0 0 1.312-5.745a1.999 1.999 0 0 0 0-3.545a20.902 20.902 0 0 0-1.312-5.745a.75.75 0 0 0-1.4.537l.029.077Z">
                                    </path>
                                </svg></div>
                        </div>
                        <h3 class="cta38_link-text">News</h3>
                        <div class="cta38_link-image-wrapper pointer-events-off"><img
                                src="images/services4.avif"
                                loading="eager" sizes="100vw"
                                srcset="images/services4.avif"
                                alt="ASW Founders news" class="cta38_link-image"></div>
                    </a>
                    <div class="cta38_hover-css w-embed">
                        <style>
                            /* Prevents hover states from being used on Tablet & Mobile */
                            @media only screen and (min-width: 992px) {


                                .cta38_component a {
                                    color: #000000;
                                }

                                .cta38_component:hover a {
                                    color: #c4c4c4;
                                }

                                .cta38_component:hover a:hover {
                                    color: #000000;
                                }

                            }
                        </style>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<header class="section_header15">
    <div class="padding-global">
        <div class="container-large">
            <div class="padding-section-large">
                <div class="header15_component">
                    <div class="margin-bottom-6 margin-xxlarge">
                        <div class="w-layout-grid header15_content-wrapper">
                            <div class="header15_content-left">
                                <div class="margin-bottom margin-small">
                                    <div class="button is-secondary is-small is-tagline">10X Faster Workflows</div>
                                </div>
                                <h2>ASW Founders &amp; Relume</h2>
                            </div>
                            <div class="header15_content-right">
                                <p class="text-size-medium">You can now harness the combined power of <strong>Relume </strong>and
                                    <strong>ASW Founders </strong>to effortlessly launch <strong>Shopify </strong>stores designed
                                    entirely in <strong>Webflow</strong>, in almost no time! This Relume Library includes more than
                                    <strong>150 components </strong>ready to use with Shopify.
                                </p>
                                <div class="margin-top margin-medium">
                                    <div class="button-group"><a href="relume-library.php"
                                            class="button is-secondary is-small w-button">More details</a><a
                                            href="https://www.relume.io/folder?folder_id=f3460ed8-15db-4cec-b25c-3c68e51a24b2"
                                            target="_blank" class="button is-small hide-mobile-landscape w-button">Go to Library</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="header15_image-wrapper">
                        <div class="relume-image-container">
                            <div data-poster-url="https://cdn.prod.website-files.com/66c74b953957211a234767e2%2F673607d65153a3aa6490273f_Comp%201_4%20%281%29-poster-00001.jpg" data-video-urls="https://cdn.prod.website-files.com/66c74b953957211a234767e2%2F673607d65153a3aa6490273f_Comp%201_4%20%281%29-transcode.mp4,https://cdn.prod.website-files.com/66c74b953957211a234767e2%2F673607d65153a3aa6490273f_Comp%201_4%20%281%29-transcode.webm" data-autoplay="true" data-loop="true" data-wf-ignore="true" class="background-video hero w-background-video w-background-video-atom"><video id="96f15289-3c5a-b077-277c-ff2be902d456-video" autoplay="" loop="" style="background-image:url(&quot;https://cdn.prod.website-files.com/66c74b953957211a234767e2%2F673607d65153a3aa6490273f_Comp%201_4%20%281%29-poster-00001.jpg&quot;)" muted="" playsinline="" data-wf-ignore="true" data-object-fit="cover">
                                    <source src="https://cdn.prod.website-files.com/66c74b953957211a234767e2%2F673607d65153a3aa6490273f_Comp%201_4%20%281%29-transcode.mp4" data-wf-ignore="true">
                                    <source src="https://cdn.prod.website-files.com/66c74b953957211a234767e2%2F673607d65153a3aa6490273f_Comp%201_4%20%281%29-transcode.webm" data-wf-ignore="true">
                                </video></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
<header class="section_header80">
    <div class="padding-global">
        <div class="header80_component">
            <div class="header80_content-wrapper">
                <div class="header80_images-wrapper">
                    <div class="header80_image-list"><a href="https://www.cesarmillan.com/" target="_blank"
                            class="header80_image-wrapper is-image-1 w-inline-block"><img
                                src="images/card1.webp"
                                loading="lazy" sizes="(max-width: 767px) 30vw, (max-width: 991px) 28vw, 22vw"
                                srcset="images/card1.webp"
                                alt="ASW Founders Showcase" class="header80_image"></a><a href="https://www.360barberacademy.com/en"
                            target="_blank" class="header80_image-wrapper is-image-7 w-inline-block"><img
                                src="images/card6.avif"
                                loading="lazy" sizes="(max-width: 991px) 100vw, 22vw"
                                srcset="images/card6.avif"
                                alt="ASW Founders Showcase" class="header80_image"></a><a href="https://www.radiantsoutherncharm.com/"
                            target="_blank" class="header80_image-wrapper is-image-2 w-inline-block"><img
                                src="images/card2.webp"
                                loading="lazy" id="w-node-_0dac20ba-f108-a1ae-0897-1a2b7a76be56-23476836"
                                sizes="(max-width: 767px) 30vw, (max-width: 991px) 28vw, 22vw" alt="ASW Founders Showcase"
                                srcset="images/card2.webp"
                                class="header80_image"></a><a href="https://www.gripdivision.se/en" target="_blank"
                            class="header80_image-wrapper is-image-3 w-inline-block"><img
                                src="images/card3.webp"
                                loading="lazy" id="w-node-_0dac20ba-f108-a1ae-0897-1a2b7a76be58-23476836"
                                sizes="(max-width: 767px) 28vw, (max-width: 991px) 26vw, 20vw" alt="ASW Founders Showcase"
                                srcset="images/card3.webp"
                                class="header80_image"></a><a href="https://www.renewitdecksupply.com/" target="_blank"
                            class="header80_image-wrapper is-image-4 w-inline-block"><img
                                src="images/card4.webp"
                                loading="lazy" id="w-node-_0dac20ba-f108-a1ae-0897-1a2b7a76be5a-23476836"
                                sizes="(max-width: 767px) 26vw, (max-width: 991px) 24vw, 20vw" alt="ASW Founders Showcase"
                                srcset="images/card4.webp"
                                class="header80_image"></a><a href="https://www.flowstatecoffee.co/" target="_blank"
                            class="header80_image-wrapper is-image-4-copy w-inline-block"><img
                                src="images/card7.avif"
                                loading="lazy" id="w-node-e3f272f3-44c9-3a8f-2617-8efbf9e757a1-23476836"
                                sizes="(max-width: 991px) 100vw, 20vw" alt="ASW Founders Showcase"
                                srcset="images/card7.avif"
                                class="header80_image"></a></div>
                </div>
                <div class="header80_images-wrapper images-wrapper-right">
                    <div class="header80_image-list image-list-right"><a href="https://www.slapfunk.com/" target="_blank"
                            class="header80_image-wrapper is-image-5 w-inline-block"><img
                                src="images/card5.webp"
                                loading="lazy" id="w-node-_0dac20ba-f108-a1ae-0897-1a2b7a76be5e-23476836"
                                sizes="(max-width: 767px) 28vw, (max-width: 991px) 26vw, 20vw" alt="ASW Founders Showcase"
                                srcset="images/card5.webp"
                                class="header80_image"></a><a href="https://www.lumenearz.com/" target="_blank"
                            class="header80_image-wrapper is-image-5-copy w-inline-block"><img
                                src="images/card9.avif"
                                loading="lazy" id="w-node-f800611a-7fbd-4573-565e-f7d1afb1b41f-23476836"
                                sizes="(max-width: 991px) 100vw, 20vw" alt="ASW Founders Showcase"
                                srcset="images/card9.avif"
                                class="header80_image"></a><a href="https://www.wetheknot.com/" target="_blank"
                            class="header80_image-wrapper is-image-6 w-inline-block"><img
                                src="images/card8.webp"
                                loading="lazy" id="w-node-_0dac20ba-f108-a1ae-0897-1a2b7a76be60-23476836"
                                sizes="(max-width: 767px) 30vw, (max-width: 991px) 28vw, 22vw" alt="ASW Founders Showcase"
                                srcset="images/card8.webp"
                                class="header80_image"></a><a href="https://www.letitdough.co/" target="_blank"
                            class="header80_image-wrapper is-image-6-copy w-inline-block"><img
                                src="images/card6.avif"
                                loading="lazy" id="w-node-_52f7b04e-37d5-4c7b-9a05-f1b320ed53ef-23476836"
                                sizes="(max-width: 991px) 100vw, 18vw" alt="ASW Founders Showcase"
                                srcset="images/card6.avif"
                                class="header80_image"></a></div>
                </div>
                <div class="header80_content">
                    <div class="text-align-center">
                        <div class="margin-bottom">
                            <div class="button is-secondary is-small is-tagline mini">Thousands are already using it</div>
                        </div>
                        <div class="margin-bottom margin-small">
                            <h2 class="heading-style-h1 hero">Made with ASW Founders</h2>
                        </div>
                        <div class="margin-top margin-small">
                            <div class="button-group is-center z-index-2"><a href="showcase.php"
                                    class="button w-button">Showcase your project</a></div>
                        </div>
                    </div>
                </div>
            </div>
            <div data-w-id="0dac20ba-f108-a1ae-0897-1a2b7a76be6e" class="header80_ix-trigger"></div>
        </div>
    </div>
</header>
<section class="section_cta7">
    <div class="padding-global">
        <div class="container-large">
            <div class="padding-section-large no-padding-bottom">
                <div class="cta7_component">
                    <div id="w-node-cd97ed83-4e57-4c4d-8bc4-b6b8859e1bf2-859e1bed" class="cta7_content">
                        <div class="max-width-large">
                            <div class="margin-bottom margin-xsmall">
                                <h3 class="heading-style-h1 mobile-align-center">Use it for free. <br>Pay only when you go live.
                                </h3>
                            </div>
                        </div>
                    </div>
                    <div class="cta7_button-row"><a href="pricing.php" class="button is-icon is-alternate w-inline-block">
                            <div class="icon-embed-xsmall w-embed"><svg xmlns="http://www.w3.org/2000/svg"
                                    xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img"
                                    class="iconify iconify--heroicons" width="100%" height="100%"
                                    preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                    <path fill="currentColor" fill-rule="evenodd"
                                        d="M9 4.5a.75.75 0 0 1 .721.544l.813 2.846a3.75 3.75 0 0 0 2.576 2.576l2.846.813a.75.75 0 0 1 0 1.442l-2.846.813a3.75 3.75 0 0 0-2.576 2.576l-.813 2.846a.75.75 0 0 1-1.442 0l-.813-2.846a3.75 3.75 0 0 0-2.576-2.576l-2.846-.813a.75.75 0 0 1 0-1.442l2.846-.813A3.75 3.75 0 0 0 7.466 7.89l.813-2.846A.75.75 0 0 1 9 4.5Zm9-3a.75.75 0 0 1 .728.568l.258 1.036a2.63 2.63 0 0 0 1.91 1.91l1.036.258a.75.75 0 0 1 0 1.456l-1.036.258a2.63 2.63 0 0 0-1.91 1.91l-.258 1.036a.75.75 0 0 1-1.456 0l-.258-1.036a2.625 2.625 0 0 0-1.91-1.91l-1.036-.258a.75.75 0 0 1 0-1.456l1.036-.258a2.625 2.625 0 0 0 1.91-1.91l.258-1.036A.75.75 0 0 1 18 1.5ZM16.5 15a.75.75 0 0 1 .712.513l.394 1.183c.15.447.5.799.948.948l1.183.395a.75.75 0 0 1 0 1.422l-1.183.395a1.5 1.5 0 0 0-.948.948l-.395 1.183a.75.75 0 0 1-1.422 0l-.395-1.183a1.5 1.5 0 0 0-.948-.948l-1.183-.395a.75.75 0 0 1 0-1.422l1.183-.395a1.5 1.5 0 0 0 .948-.948l.395-1.183A.75.75 0 0 1 16.5 15Z"
                                        clip-rule="evenodd"></path>
                                </svg></div>
                            <div>Launch your project today</div>
                        </a>
                        <div class="button-label">Build your store in minutes, not days!</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php
include 'includes/footer.php';
$page = 'Home';
?>