/*!
 * Webflow: Front-end site library
 * @license MIT
 * Inline scripts may access the api using an async handler:
 *   var Webflow = Webflow || [];
 *   Webflow.push(readyFunction);
 */

(() => {
  var lw = Object.create;
  var wi = Object.defineProperty;
  var uw = Object.getOwnPropertyDescriptor;
  var cw = Object.getOwnPropertyNames;
  var hw = Object.getPrototypeOf,
    fw = Object.prototype.hasOwnProperty;
  var Ee = (e, t) => () => (e && (t = e((e = 0))), t);
  var E = (e, t) => () => (t || e((t = { exports: {} }).exports, t), t.exports),
    He = (e, t) => {
      for (var r in t) wi(e, r, { get: t[r], enumerable: !0 });
    },
    sh = (e, t, r, n) => {
      if ((t && typeof t == "object") || typeof t == "function")
        for (let i of cw(t))
          !fw.call(e, i) &&
            i !== r &&
            wi(e, i, {
              get: () => t[i],
              enumerable: !(n = uw(t, i)) || n.enumerable,
            });
      return e;
    };
  var me = (e, t, r) => (
      (r = e != null ? lw(hw(e)) : {}),
      sh(
        t || !e || !e.__esModule
          ? wi(r, "default", { value: e, enumerable: !0 })
          : r,
        e
      )
    ),
    ht = (e) => sh(wi({}, "__esModule", { value: !0 }), e);
  var Vs = E(() => {
    "use strict";
    window.tram = (function (e) {
      function t(C, B) {
        var G = new W.Bare();
        return G.init(C, B);
      }
      function r(C) {
        return C.replace(/[A-Z]/g, function (B) {
          return "-" + B.toLowerCase();
        });
      }
      function n(C) {
        var B = parseInt(C.slice(1), 16),
          G = (B >> 16) & 255,
          U = (B >> 8) & 255,
          Q = 255 & B;
        return [G, U, Q];
      }
      function i(C, B, G) {
        return (
          "#" + ((1 << 24) | (C << 16) | (B << 8) | G).toString(16).slice(1)
        );
      }
      function a() {}
      function o(C, B) {
        f("Type warning: Expected: [" + C + "] Got: [" + typeof B + "] " + B);
      }
      function s(C, B, G) {
        f("Units do not match [" + C + "]: " + B + ", " + G);
      }
      function l(C, B, G) {
        if ((B !== void 0 && (G = B), C === void 0)) return G;
        var U = G;
        return (
          Oe.test(C) || !Ie.test(C)
            ? (U = parseInt(C, 10))
            : Ie.test(C) && (U = 1e3 * parseFloat(C)),
          0 > U && (U = 0),
          U === U ? U : G
        );
      }
      function f(C) {
        te.debug && window && window.console.warn(C);
      }
      function u(C) {
        for (var B = -1, G = C ? C.length : 0, U = []; ++B < G; ) {
          var Q = C[B];
          Q && U.push(Q);
        }
        return U;
      }
      var h = (function (C, B, G) {
          function U(le) {
            return typeof le == "object";
          }
          function Q(le) {
            return typeof le == "function";
          }
          function K() {}
          function se(le, oe) {
            function re() {
              var Ge = new ce();
              return Q(Ge.init) && Ge.init.apply(Ge, arguments), Ge;
            }
            function ce() {}
            oe === G && ((oe = le), (le = Object)), (re.Bare = ce);
            var fe,
              xe = (K[C] = le[C]),
              tt = (ce[C] = re[C] = new K());
            return (
              (tt.constructor = re),
              (re.mixin = function (Ge) {
                return (ce[C] = re[C] = se(re, Ge)[C]), re;
              }),
              (re.open = function (Ge) {
                if (
                  ((fe = {}),
                  Q(Ge)
                    ? (fe = Ge.call(re, tt, xe, re, le))
                    : U(Ge) && (fe = Ge),
                  U(fe))
                )
                  for (var bn in fe) B.call(fe, bn) && (tt[bn] = fe[bn]);
                return Q(tt.init) || (tt.init = le), re;
              }),
              re.open(oe)
            );
          }
          return se;
        })("prototype", {}.hasOwnProperty),
        m = {
          ease: [
            "ease",
            function (C, B, G, U) {
              var Q = (C /= U) * C,
                K = Q * C;
              return (
                B +
                G * (-2.75 * K * Q + 11 * Q * Q + -15.5 * K + 8 * Q + 0.25 * C)
              );
            },
          ],
          "ease-in": [
            "ease-in",
            function (C, B, G, U) {
              var Q = (C /= U) * C,
                K = Q * C;
              return B + G * (-1 * K * Q + 3 * Q * Q + -3 * K + 2 * Q);
            },
          ],
          "ease-out": [
            "ease-out",
            function (C, B, G, U) {
              var Q = (C /= U) * C,
                K = Q * C;
              return (
                B +
                G * (0.3 * K * Q + -1.6 * Q * Q + 2.2 * K + -1.8 * Q + 1.9 * C)
              );
            },
          ],
          "ease-in-out": [
            "ease-in-out",
            function (C, B, G, U) {
              var Q = (C /= U) * C,
                K = Q * C;
              return B + G * (2 * K * Q + -5 * Q * Q + 2 * K + 2 * Q);
            },
          ],
          linear: [
            "linear",
            function (C, B, G, U) {
              return (G * C) / U + B;
            },
          ],
          "ease-in-quad": [
            "cubic-bezier(0.550, 0.085, 0.680, 0.530)",
            function (C, B, G, U) {
              return G * (C /= U) * C + B;
            },
          ],
          "ease-out-quad": [
            "cubic-bezier(0.250, 0.460, 0.450, 0.940)",
            function (C, B, G, U) {
              return -G * (C /= U) * (C - 2) + B;
            },
          ],
          "ease-in-out-quad": [
            "cubic-bezier(0.455, 0.030, 0.515, 0.955)",
            function (C, B, G, U) {
              return (C /= U / 2) < 1
                ? (G / 2) * C * C + B
                : (-G / 2) * (--C * (C - 2) - 1) + B;
            },
          ],
          "ease-in-cubic": [
            "cubic-bezier(0.550, 0.055, 0.675, 0.190)",
            function (C, B, G, U) {
              return G * (C /= U) * C * C + B;
            },
          ],
          "ease-out-cubic": [
            "cubic-bezier(0.215, 0.610, 0.355, 1)",
            function (C, B, G, U) {
              return G * ((C = C / U - 1) * C * C + 1) + B;
            },
          ],
          "ease-in-out-cubic": [
            "cubic-bezier(0.645, 0.045, 0.355, 1)",
            function (C, B, G, U) {
              return (C /= U / 2) < 1
                ? (G / 2) * C * C * C + B
                : (G / 2) * ((C -= 2) * C * C + 2) + B;
            },
          ],
          "ease-in-quart": [
            "cubic-bezier(0.895, 0.030, 0.685, 0.220)",
            function (C, B, G, U) {
              return G * (C /= U) * C * C * C + B;
            },
          ],
          "ease-out-quart": [
            "cubic-bezier(0.165, 0.840, 0.440, 1)",
            function (C, B, G, U) {
              return -G * ((C = C / U - 1) * C * C * C - 1) + B;
            },
          ],
          "ease-in-out-quart": [
            "cubic-bezier(0.770, 0, 0.175, 1)",
            function (C, B, G, U) {
              return (C /= U / 2) < 1
                ? (G / 2) * C * C * C * C + B
                : (-G / 2) * ((C -= 2) * C * C * C - 2) + B;
            },
          ],
          "ease-in-quint": [
            "cubic-bezier(0.755, 0.050, 0.855, 0.060)",
            function (C, B, G, U) {
              return G * (C /= U) * C * C * C * C + B;
            },
          ],
          "ease-out-quint": [
            "cubic-bezier(0.230, 1, 0.320, 1)",
            function (C, B, G, U) {
              return G * ((C = C / U - 1) * C * C * C * C + 1) + B;
            },
          ],
          "ease-in-out-quint": [
            "cubic-bezier(0.860, 0, 0.070, 1)",
            function (C, B, G, U) {
              return (C /= U / 2) < 1
                ? (G / 2) * C * C * C * C * C + B
                : (G / 2) * ((C -= 2) * C * C * C * C + 2) + B;
            },
          ],
          "ease-in-sine": [
            "cubic-bezier(0.470, 0, 0.745, 0.715)",
            function (C, B, G, U) {
              return -G * Math.cos((C / U) * (Math.PI / 2)) + G + B;
            },
          ],
          "ease-out-sine": [
            "cubic-bezier(0.390, 0.575, 0.565, 1)",
            function (C, B, G, U) {
              return G * Math.sin((C / U) * (Math.PI / 2)) + B;
            },
          ],
          "ease-in-out-sine": [
            "cubic-bezier(0.445, 0.050, 0.550, 0.950)",
            function (C, B, G, U) {
              return (-G / 2) * (Math.cos((Math.PI * C) / U) - 1) + B;
            },
          ],
          "ease-in-expo": [
            "cubic-bezier(0.950, 0.050, 0.795, 0.035)",
            function (C, B, G, U) {
              return C === 0 ? B : G * Math.pow(2, 10 * (C / U - 1)) + B;
            },
          ],
          "ease-out-expo": [
            "cubic-bezier(0.190, 1, 0.220, 1)",
            function (C, B, G, U) {
              return C === U
                ? B + G
                : G * (-Math.pow(2, (-10 * C) / U) + 1) + B;
            },
          ],
          "ease-in-out-expo": [
            "cubic-bezier(1, 0, 0, 1)",
            function (C, B, G, U) {
              return C === 0
                ? B
                : C === U
                ? B + G
                : (C /= U / 2) < 1
                ? (G / 2) * Math.pow(2, 10 * (C - 1)) + B
                : (G / 2) * (-Math.pow(2, -10 * --C) + 2) + B;
            },
          ],
          "ease-in-circ": [
            "cubic-bezier(0.600, 0.040, 0.980, 0.335)",
            function (C, B, G, U) {
              return -G * (Math.sqrt(1 - (C /= U) * C) - 1) + B;
            },
          ],
          "ease-out-circ": [
            "cubic-bezier(0.075, 0.820, 0.165, 1)",
            function (C, B, G, U) {
              return G * Math.sqrt(1 - (C = C / U - 1) * C) + B;
            },
          ],
          "ease-in-out-circ": [
            "cubic-bezier(0.785, 0.135, 0.150, 0.860)",
            function (C, B, G, U) {
              return (C /= U / 2) < 1
                ? (-G / 2) * (Math.sqrt(1 - C * C) - 1) + B
                : (G / 2) * (Math.sqrt(1 - (C -= 2) * C) + 1) + B;
            },
          ],
          "ease-in-back": [
            "cubic-bezier(0.600, -0.280, 0.735, 0.045)",
            function (C, B, G, U, Q) {
              return (
                Q === void 0 && (Q = 1.70158),
                G * (C /= U) * C * ((Q + 1) * C - Q) + B
              );
            },
          ],
          "ease-out-back": [
            "cubic-bezier(0.175, 0.885, 0.320, 1.275)",
            function (C, B, G, U, Q) {
              return (
                Q === void 0 && (Q = 1.70158),
                G * ((C = C / U - 1) * C * ((Q + 1) * C + Q) + 1) + B
              );
            },
          ],
          "ease-in-out-back": [
            "cubic-bezier(0.680, -0.550, 0.265, 1.550)",
            function (C, B, G, U, Q) {
              return (
                Q === void 0 && (Q = 1.70158),
                (C /= U / 2) < 1
                  ? (G / 2) * C * C * (((Q *= 1.525) + 1) * C - Q) + B
                  : (G / 2) *
                      ((C -= 2) * C * (((Q *= 1.525) + 1) * C + Q) + 2) +
                    B
              );
            },
          ],
        },
        d = {
          "ease-in-back": "cubic-bezier(0.600, 0, 0.735, 0.045)",
          "ease-out-back": "cubic-bezier(0.175, 0.885, 0.320, 1)",
          "ease-in-out-back": "cubic-bezier(0.680, 0, 0.265, 1)",
        },
        p = document,
        g = window,
        c = "bkwld-tram",
        v = /[\-\.0-9]/g,
        y = /[A-Z]/,
        b = "number",
        x = /^(rgb|#)/,
        S = /(em|cm|mm|in|pt|pc|px)$/,
        T = /(em|cm|mm|in|pt|pc|px|%)$/,
        I = /(deg|rad|turn)$/,
        P = "unitless",
        L = /(all|none) 0s ease 0s/,
        M = /^(width|height)$/,
        _ = " ",
        F = p.createElement("a"),
        w = ["Webkit", "Moz", "O", "ms"],
        R = ["-webkit-", "-moz-", "-o-", "-ms-"],
        k = function (C) {
          if (C in F.style) return { dom: C, css: C };
          var B,
            G,
            U = "",
            Q = C.split("-");
          for (B = 0; B < Q.length; B++)
            U += Q[B].charAt(0).toUpperCase() + Q[B].slice(1);
          for (B = 0; B < w.length; B++)
            if (((G = w[B] + U), G in F.style))
              return { dom: G, css: R[B] + C };
        },
        z = (t.support = {
          bind: Function.prototype.bind,
          transform: k("transform"),
          transition: k("transition"),
          backface: k("backface-visibility"),
          timing: k("transition-timing-function"),
        });
      if (z.transition) {
        var ee = z.timing.dom;
        if (((F.style[ee] = m["ease-in-back"][0]), !F.style[ee]))
          for (var A in d) m[A][0] = d[A];
      }
      var N = (t.frame = (function () {
          var C =
            g.requestAnimationFrame ||
            g.webkitRequestAnimationFrame ||
            g.mozRequestAnimationFrame ||
            g.oRequestAnimationFrame ||
            g.msRequestAnimationFrame;
          return C && z.bind
            ? C.bind(g)
            : function (B) {
                g.setTimeout(B, 16);
              };
        })()),
        X = (t.now = (function () {
          var C = g.performance,
            B = C && (C.now || C.webkitNow || C.msNow || C.mozNow);
          return B && z.bind
            ? B.bind(C)
            : Date.now ||
                function () {
                  return +new Date();
                };
        })()),
        ae = h(function (C) {
          function B(ue, ge) {
            var Ae = u(("" + ue).split(_)),
              ve = Ae[0];
            ge = ge || {};
            var ze = Y[ve];
            if (!ze) return f("Unsupported property: " + ve);
            if (!ge.weak || !this.props[ve]) {
              var ct = ze[0],
                Ye = this.props[ve];
              return (
                Ye || (Ye = this.props[ve] = new ct.Bare()),
                Ye.init(this.$el, Ae, ze, ge),
                Ye
              );
            }
          }
          function G(ue, ge, Ae) {
            if (ue) {
              var ve = typeof ue;
              if (
                (ge ||
                  (this.timer && this.timer.destroy(),
                  (this.queue = []),
                  (this.active = !1)),
                ve == "number" && ge)
              )
                return (
                  (this.timer = new Z({
                    duration: ue,
                    context: this,
                    complete: K,
                  })),
                  void (this.active = !0)
                );
              if (ve == "string" && ge) {
                switch (ue) {
                  case "hide":
                    re.call(this);
                    break;
                  case "stop":
                    se.call(this);
                    break;
                  case "redraw":
                    ce.call(this);
                    break;
                  default:
                    B.call(this, ue, Ae && Ae[1]);
                }
                return K.call(this);
              }
              if (ve == "function") return void ue.call(this, this);
              if (ve == "object") {
                var ze = 0;
                tt.call(
                  this,
                  ue,
                  function (Re, ow) {
                    Re.span > ze && (ze = Re.span), Re.stop(), Re.animate(ow);
                  },
                  function (Re) {
                    "wait" in Re && (ze = l(Re.wait, 0));
                  }
                ),
                  xe.call(this),
                  ze > 0 &&
                    ((this.timer = new Z({ duration: ze, context: this })),
                    (this.active = !0),
                    ge && (this.timer.complete = K));
                var ct = this,
                  Ye = !1,
                  Pi = {};
                N(function () {
                  tt.call(ct, ue, function (Re) {
                    Re.active && ((Ye = !0), (Pi[Re.name] = Re.nextStyle));
                  }),
                    Ye && ct.$el.css(Pi);
                });
              }
            }
          }
          function U(ue) {
            (ue = l(ue, 0)),
              this.active
                ? this.queue.push({ options: ue })
                : ((this.timer = new Z({
                    duration: ue,
                    context: this,
                    complete: K,
                  })),
                  (this.active = !0));
          }
          function Q(ue) {
            return this.active
              ? (this.queue.push({ options: ue, args: arguments }),
                void (this.timer.complete = K))
              : f(
                  "No active transition timer. Use start() or wait() before then()."
                );
          }
          function K() {
            if (
              (this.timer && this.timer.destroy(),
              (this.active = !1),
              this.queue.length)
            ) {
              var ue = this.queue.shift();
              G.call(this, ue.options, !0, ue.args);
            }
          }
          function se(ue) {
            this.timer && this.timer.destroy(),
              (this.queue = []),
              (this.active = !1);
            var ge;
            typeof ue == "string"
              ? ((ge = {}), (ge[ue] = 1))
              : (ge = typeof ue == "object" && ue != null ? ue : this.props),
              tt.call(this, ge, Ge),
              xe.call(this);
          }
          function le(ue) {
            se.call(this, ue), tt.call(this, ue, bn, aw);
          }
          function oe(ue) {
            typeof ue != "string" && (ue = "block"),
              (this.el.style.display = ue);
          }
          function re() {
            se.call(this), (this.el.style.display = "none");
          }
          function ce() {
            this.el.offsetHeight;
          }
          function fe() {
            se.call(this),
              e.removeData(this.el, c),
              (this.$el = this.el = null);
          }
          function xe() {
            var ue,
              ge,
              Ae = [];
            this.upstream && Ae.push(this.upstream);
            for (ue in this.props)
              (ge = this.props[ue]), ge.active && Ae.push(ge.string);
            (Ae = Ae.join(",")),
              this.style !== Ae &&
                ((this.style = Ae), (this.el.style[z.transition.dom] = Ae));
          }
          function tt(ue, ge, Ae) {
            var ve,
              ze,
              ct,
              Ye,
              Pi = ge !== Ge,
              Re = {};
            for (ve in ue)
              (ct = ue[ve]),
                ve in de
                  ? (Re.transform || (Re.transform = {}),
                    (Re.transform[ve] = ct))
                  : (y.test(ve) && (ve = r(ve)),
                    ve in Y ? (Re[ve] = ct) : (Ye || (Ye = {}), (Ye[ve] = ct)));
            for (ve in Re) {
              if (((ct = Re[ve]), (ze = this.props[ve]), !ze)) {
                if (!Pi) continue;
                ze = B.call(this, ve);
              }
              ge.call(this, ze, ct);
            }
            Ae && Ye && Ae.call(this, Ye);
          }
          function Ge(ue) {
            ue.stop();
          }
          function bn(ue, ge) {
            ue.set(ge);
          }
          function aw(ue) {
            this.$el.css(ue);
          }
          function ut(ue, ge) {
            C[ue] = function () {
              return this.children
                ? sw.call(this, ge, arguments)
                : (this.el && ge.apply(this, arguments), this);
            };
          }
          function sw(ue, ge) {
            var Ae,
              ve = this.children.length;
            for (Ae = 0; ve > Ae; Ae++) ue.apply(this.children[Ae], ge);
            return this;
          }
          (C.init = function (ue) {
            if (
              ((this.$el = e(ue)),
              (this.el = this.$el[0]),
              (this.props = {}),
              (this.queue = []),
              (this.style = ""),
              (this.active = !1),
              te.keepInherited && !te.fallback)
            ) {
              var ge = J(this.el, "transition");
              ge && !L.test(ge) && (this.upstream = ge);
            }
            z.backface &&
              te.hideBackface &&
              D(this.el, z.backface.css, "hidden");
          }),
            ut("add", B),
            ut("start", G),
            ut("wait", U),
            ut("then", Q),
            ut("next", K),
            ut("stop", se),
            ut("set", le),
            ut("show", oe),
            ut("hide", re),
            ut("redraw", ce),
            ut("destroy", fe);
        }),
        W = h(ae, function (C) {
          function B(G, U) {
            var Q = e.data(G, c) || e.data(G, c, new ae.Bare());
            return Q.el || Q.init(G), U ? Q.start(U) : Q;
          }
          C.init = function (G, U) {
            var Q = e(G);
            if (!Q.length) return this;
            if (Q.length === 1) return B(Q[0], U);
            var K = [];
            return (
              Q.each(function (se, le) {
                K.push(B(le, U));
              }),
              (this.children = K),
              this
            );
          };
        }),
        q = h(function (C) {
          function B() {
            var K = this.get();
            this.update("auto");
            var se = this.get();
            return this.update(K), se;
          }
          function G(K, se, le) {
            return se !== void 0 && (le = se), K in m ? K : le;
          }
          function U(K) {
            var se = /rgba?\((\d+),\s*(\d+),\s*(\d+)/.exec(K);
            return (se ? i(se[1], se[2], se[3]) : K).replace(
              /#(\w)(\w)(\w)$/,
              "#$1$1$2$2$3$3"
            );
          }
          var Q = { duration: 500, ease: "ease", delay: 0 };
          (C.init = function (K, se, le, oe) {
            (this.$el = K), (this.el = K[0]);
            var re = se[0];
            le[2] && (re = le[2]),
              ne[re] && (re = ne[re]),
              (this.name = re),
              (this.type = le[1]),
              (this.duration = l(se[1], this.duration, Q.duration)),
              (this.ease = G(se[2], this.ease, Q.ease)),
              (this.delay = l(se[3], this.delay, Q.delay)),
              (this.span = this.duration + this.delay),
              (this.active = !1),
              (this.nextStyle = null),
              (this.auto = M.test(this.name)),
              (this.unit = oe.unit || this.unit || te.defaultUnit),
              (this.angle = oe.angle || this.angle || te.defaultAngle),
              te.fallback || oe.fallback
                ? (this.animate = this.fallback)
                : ((this.animate = this.transition),
                  (this.string =
                    this.name +
                    _ +
                    this.duration +
                    "ms" +
                    (this.ease != "ease" ? _ + m[this.ease][0] : "") +
                    (this.delay ? _ + this.delay + "ms" : "")));
          }),
            (C.set = function (K) {
              (K = this.convert(K, this.type)), this.update(K), this.redraw();
            }),
            (C.transition = function (K) {
              (this.active = !0),
                (K = this.convert(K, this.type)),
                this.auto &&
                  (this.el.style[this.name] == "auto" &&
                    (this.update(this.get()), this.redraw()),
                  K == "auto" && (K = B.call(this))),
                (this.nextStyle = K);
            }),
            (C.fallback = function (K) {
              var se =
                this.el.style[this.name] || this.convert(this.get(), this.type);
              (K = this.convert(K, this.type)),
                this.auto &&
                  (se == "auto" && (se = this.convert(this.get(), this.type)),
                  K == "auto" && (K = B.call(this))),
                (this.tween = new V({
                  from: se,
                  to: K,
                  duration: this.duration,
                  delay: this.delay,
                  ease: this.ease,
                  update: this.update,
                  context: this,
                }));
            }),
            (C.get = function () {
              return J(this.el, this.name);
            }),
            (C.update = function (K) {
              D(this.el, this.name, K);
            }),
            (C.stop = function () {
              (this.active || this.nextStyle) &&
                ((this.active = !1),
                (this.nextStyle = null),
                D(this.el, this.name, this.get()));
              var K = this.tween;
              K && K.context && K.destroy();
            }),
            (C.convert = function (K, se) {
              if (K == "auto" && this.auto) return K;
              var le,
                oe = typeof K == "number",
                re = typeof K == "string";
              switch (se) {
                case b:
                  if (oe) return K;
                  if (re && K.replace(v, "") === "") return +K;
                  le = "number(unitless)";
                  break;
                case x:
                  if (re) {
                    if (K === "" && this.original) return this.original;
                    if (se.test(K))
                      return K.charAt(0) == "#" && K.length == 7 ? K : U(K);
                  }
                  le = "hex or rgb string";
                  break;
                case S:
                  if (oe) return K + this.unit;
                  if (re && se.test(K)) return K;
                  le = "number(px) or string(unit)";
                  break;
                case T:
                  if (oe) return K + this.unit;
                  if (re && se.test(K)) return K;
                  le = "number(px) or string(unit or %)";
                  break;
                case I:
                  if (oe) return K + this.angle;
                  if (re && se.test(K)) return K;
                  le = "number(deg) or string(angle)";
                  break;
                case P:
                  if (oe || (re && T.test(K))) return K;
                  le = "number(unitless) or string(unit or %)";
              }
              return o(le, K), K;
            }),
            (C.redraw = function () {
              this.el.offsetHeight;
            });
        }),
        O = h(q, function (C, B) {
          C.init = function () {
            B.init.apply(this, arguments),
              this.original || (this.original = this.convert(this.get(), x));
          };
        }),
        H = h(q, function (C, B) {
          (C.init = function () {
            B.init.apply(this, arguments), (this.animate = this.fallback);
          }),
            (C.get = function () {
              return this.$el[this.name]();
            }),
            (C.update = function (G) {
              this.$el[this.name](G);
            });
        }),
        j = h(q, function (C, B) {
          function G(U, Q) {
            var K, se, le, oe, re;
            for (K in U)
              (oe = de[K]),
                (le = oe[0]),
                (se = oe[1] || K),
                (re = this.convert(U[K], le)),
                Q.call(this, se, re, le);
          }
          (C.init = function () {
            B.init.apply(this, arguments),
              this.current ||
                ((this.current = {}),
                de.perspective &&
                  te.perspective &&
                  ((this.current.perspective = te.perspective),
                  D(this.el, this.name, this.style(this.current)),
                  this.redraw()));
          }),
            (C.set = function (U) {
              G.call(this, U, function (Q, K) {
                this.current[Q] = K;
              }),
                D(this.el, this.name, this.style(this.current)),
                this.redraw();
            }),
            (C.transition = function (U) {
              var Q = this.values(U);
              this.tween = new ie({
                current: this.current,
                values: Q,
                duration: this.duration,
                delay: this.delay,
                ease: this.ease,
              });
              var K,
                se = {};
              for (K in this.current) se[K] = K in Q ? Q[K] : this.current[K];
              (this.active = !0), (this.nextStyle = this.style(se));
            }),
            (C.fallback = function (U) {
              var Q = this.values(U);
              this.tween = new ie({
                current: this.current,
                values: Q,
                duration: this.duration,
                delay: this.delay,
                ease: this.ease,
                update: this.update,
                context: this,
              });
            }),
            (C.update = function () {
              D(this.el, this.name, this.style(this.current));
            }),
            (C.style = function (U) {
              var Q,
                K = "";
              for (Q in U) K += Q + "(" + U[Q] + ") ";
              return K;
            }),
            (C.values = function (U) {
              var Q,
                K = {};
              return (
                G.call(this, U, function (se, le, oe) {
                  (K[se] = le),
                    this.current[se] === void 0 &&
                      ((Q = 0),
                      ~se.indexOf("scale") && (Q = 1),
                      (this.current[se] = this.convert(Q, oe)));
                }),
                K
              );
            });
        }),
        V = h(function (C) {
          function B(re) {
            le.push(re) === 1 && N(G);
          }
          function G() {
            var re,
              ce,
              fe,
              xe = le.length;
            if (xe)
              for (N(G), ce = X(), re = xe; re--; )
                (fe = le[re]), fe && fe.render(ce);
          }
          function U(re) {
            var ce,
              fe = e.inArray(re, le);
            fe >= 0 &&
              ((ce = le.slice(fe + 1)),
              (le.length = fe),
              ce.length && (le = le.concat(ce)));
          }
          function Q(re) {
            return Math.round(re * oe) / oe;
          }
          function K(re, ce, fe) {
            return i(
              re[0] + fe * (ce[0] - re[0]),
              re[1] + fe * (ce[1] - re[1]),
              re[2] + fe * (ce[2] - re[2])
            );
          }
          var se = { ease: m.ease[1], from: 0, to: 1 };
          (C.init = function (re) {
            (this.duration = re.duration || 0), (this.delay = re.delay || 0);
            var ce = re.ease || se.ease;
            m[ce] && (ce = m[ce][1]),
              typeof ce != "function" && (ce = se.ease),
              (this.ease = ce),
              (this.update = re.update || a),
              (this.complete = re.complete || a),
              (this.context = re.context || this),
              (this.name = re.name);
            var fe = re.from,
              xe = re.to;
            fe === void 0 && (fe = se.from),
              xe === void 0 && (xe = se.to),
              (this.unit = re.unit || ""),
              typeof fe == "number" && typeof xe == "number"
                ? ((this.begin = fe), (this.change = xe - fe))
                : this.format(xe, fe),
              (this.value = this.begin + this.unit),
              (this.start = X()),
              re.autoplay !== !1 && this.play();
          }),
            (C.play = function () {
              this.active ||
                (this.start || (this.start = X()), (this.active = !0), B(this));
            }),
            (C.stop = function () {
              this.active && ((this.active = !1), U(this));
            }),
            (C.render = function (re) {
              var ce,
                fe = re - this.start;
              if (this.delay) {
                if (fe <= this.delay) return;
                fe -= this.delay;
              }
              if (fe < this.duration) {
                var xe = this.ease(fe, 0, 1, this.duration);
                return (
                  (ce = this.startRGB
                    ? K(this.startRGB, this.endRGB, xe)
                    : Q(this.begin + xe * this.change)),
                  (this.value = ce + this.unit),
                  void this.update.call(this.context, this.value)
                );
              }
              (ce = this.endHex || this.begin + this.change),
                (this.value = ce + this.unit),
                this.update.call(this.context, this.value),
                this.complete.call(this.context),
                this.destroy();
            }),
            (C.format = function (re, ce) {
              if (((ce += ""), (re += ""), re.charAt(0) == "#"))
                return (
                  (this.startRGB = n(ce)),
                  (this.endRGB = n(re)),
                  (this.endHex = re),
                  (this.begin = 0),
                  void (this.change = 1)
                );
              if (!this.unit) {
                var fe = ce.replace(v, ""),
                  xe = re.replace(v, "");
                fe !== xe && s("tween", ce, re), (this.unit = fe);
              }
              (ce = parseFloat(ce)),
                (re = parseFloat(re)),
                (this.begin = this.value = ce),
                (this.change = re - ce);
            }),
            (C.destroy = function () {
              this.stop(),
                (this.context = null),
                (this.ease = this.update = this.complete = a);
            });
          var le = [],
            oe = 1e3;
        }),
        Z = h(V, function (C) {
          (C.init = function (B) {
            (this.duration = B.duration || 0),
              (this.complete = B.complete || a),
              (this.context = B.context),
              this.play();
          }),
            (C.render = function (B) {
              var G = B - this.start;
              G < this.duration ||
                (this.complete.call(this.context), this.destroy());
            });
        }),
        ie = h(V, function (C, B) {
          (C.init = function (G) {
            (this.context = G.context),
              (this.update = G.update),
              (this.tweens = []),
              (this.current = G.current);
            var U, Q;
            for (U in G.values)
              (Q = G.values[U]),
                this.current[U] !== Q &&
                  this.tweens.push(
                    new V({
                      name: U,
                      from: this.current[U],
                      to: Q,
                      duration: G.duration,
                      delay: G.delay,
                      ease: G.ease,
                      autoplay: !1,
                    })
                  );
            this.play();
          }),
            (C.render = function (G) {
              var U,
                Q,
                K = this.tweens.length,
                se = !1;
              for (U = K; U--; )
                (Q = this.tweens[U]),
                  Q.context &&
                    (Q.render(G), (this.current[Q.name] = Q.value), (se = !0));
              return se
                ? void (this.update && this.update.call(this.context))
                : this.destroy();
            }),
            (C.destroy = function () {
              if ((B.destroy.call(this), this.tweens)) {
                var G,
                  U = this.tweens.length;
                for (G = U; G--; ) this.tweens[G].destroy();
                (this.tweens = null), (this.current = null);
              }
            });
        }),
        te = (t.config = {
          debug: !1,
          defaultUnit: "px",
          defaultAngle: "deg",
          keepInherited: !1,
          hideBackface: !1,
          perspective: "",
          fallback: !z.transition,
          agentTests: [],
        });
      (t.fallback = function (C) {
        if (!z.transition) return (te.fallback = !0);
        te.agentTests.push("(" + C + ")");
        var B = new RegExp(te.agentTests.join("|"), "i");
        te.fallback = B.test(navigator.userAgent);
      }),
        t.fallback("6.0.[2-5] Safari"),
        (t.tween = function (C) {
          return new V(C);
        }),
        (t.delay = function (C, B, G) {
          return new Z({ complete: B, duration: C, context: G });
        }),
        (e.fn.tram = function (C) {
          return t.call(null, this, C);
        });
      var D = e.style,
        J = e.css,
        ne = { transform: z.transform && z.transform.css },
        Y = {
          color: [O, x],
          background: [O, x, "background-color"],
          "outline-color": [O, x],
          "border-color": [O, x],
          "border-top-color": [O, x],
          "border-right-color": [O, x],
          "border-bottom-color": [O, x],
          "border-left-color": [O, x],
          "border-width": [q, S],
          "border-top-width": [q, S],
          "border-right-width": [q, S],
          "border-bottom-width": [q, S],
          "border-left-width": [q, S],
          "border-spacing": [q, S],
          "letter-spacing": [q, S],
          margin: [q, S],
          "margin-top": [q, S],
          "margin-right": [q, S],
          "margin-bottom": [q, S],
          "margin-left": [q, S],
          padding: [q, S],
          "padding-top": [q, S],
          "padding-right": [q, S],
          "padding-bottom": [q, S],
          "padding-left": [q, S],
          "outline-width": [q, S],
          opacity: [q, b],
          top: [q, T],
          right: [q, T],
          bottom: [q, T],
          left: [q, T],
          "font-size": [q, T],
          "text-indent": [q, T],
          "word-spacing": [q, T],
          width: [q, T],
          "min-width": [q, T],
          "max-width": [q, T],
          height: [q, T],
          "min-height": [q, T],
          "max-height": [q, T],
          "line-height": [q, P],
          "scroll-top": [H, b, "scrollTop"],
          "scroll-left": [H, b, "scrollLeft"],
        },
        de = {};
      z.transform &&
        ((Y.transform = [j]),
        (de = {
          x: [T, "translateX"],
          y: [T, "translateY"],
          rotate: [I],
          rotateX: [I],
          rotateY: [I],
          scale: [b],
          scaleX: [b],
          scaleY: [b],
          skew: [I],
          skewX: [I],
          skewY: [I],
        })),
        z.transform &&
          z.backface &&
          ((de.z = [T, "translateZ"]),
          (de.rotateZ = [I]),
          (de.scaleZ = [b]),
          (de.perspective = [S]));
      var Oe = /ms/,
        Ie = /s|\./;
      return (e.tram = t);
    })(window.jQuery);
  });
  var lh = E((wee, oh) => {
    "use strict";
    var pw = window.$,
      dw = Vs() && pw.tram;
    oh.exports = (function () {
      var e = {};
      e.VERSION = "1.6.0-Webflow";
      var t = {},
        r = Array.prototype,
        n = Object.prototype,
        i = Function.prototype,
        a = r.push,
        o = r.slice,
        s = r.concat,
        l = n.toString,
        f = n.hasOwnProperty,
        u = r.forEach,
        h = r.map,
        m = r.reduce,
        d = r.reduceRight,
        p = r.filter,
        g = r.every,
        c = r.some,
        v = r.indexOf,
        y = r.lastIndexOf,
        b = Array.isArray,
        x = Object.keys,
        S = i.bind,
        T =
          (e.each =
          e.forEach =
            function (w, R, k) {
              if (w == null) return w;
              if (u && w.forEach === u) w.forEach(R, k);
              else if (w.length === +w.length) {
                for (var z = 0, ee = w.length; z < ee; z++)
                  if (R.call(k, w[z], z, w) === t) return;
              } else
                for (var A = e.keys(w), z = 0, ee = A.length; z < ee; z++)
                  if (R.call(k, w[A[z]], A[z], w) === t) return;
              return w;
            });
      (e.map = e.collect =
        function (w, R, k) {
          var z = [];
          return w == null
            ? z
            : h && w.map === h
            ? w.map(R, k)
            : (T(w, function (ee, A, N) {
                z.push(R.call(k, ee, A, N));
              }),
              z);
        }),
        (e.find = e.detect =
          function (w, R, k) {
            var z;
            return (
              I(w, function (ee, A, N) {
                if (R.call(k, ee, A, N)) return (z = ee), !0;
              }),
              z
            );
          }),
        (e.filter = e.select =
          function (w, R, k) {
            var z = [];
            return w == null
              ? z
              : p && w.filter === p
              ? w.filter(R, k)
              : (T(w, function (ee, A, N) {
                  R.call(k, ee, A, N) && z.push(ee);
                }),
                z);
          });
      var I =
        (e.some =
        e.any =
          function (w, R, k) {
            R || (R = e.identity);
            var z = !1;
            return w == null
              ? z
              : c && w.some === c
              ? w.some(R, k)
              : (T(w, function (ee, A, N) {
                  if (z || (z = R.call(k, ee, A, N))) return t;
                }),
                !!z);
          });
      (e.contains = e.include =
        function (w, R) {
          return w == null
            ? !1
            : v && w.indexOf === v
            ? w.indexOf(R) != -1
            : I(w, function (k) {
                return k === R;
              });
        }),
        (e.delay = function (w, R) {
          var k = o.call(arguments, 2);
          return setTimeout(function () {
            return w.apply(null, k);
          }, R);
        }),
        (e.defer = function (w) {
          return e.delay.apply(e, [w, 1].concat(o.call(arguments, 1)));
        }),
        (e.throttle = function (w) {
          var R, k, z;
          return function () {
            R ||
              ((R = !0),
              (k = arguments),
              (z = this),
              dw.frame(function () {
                (R = !1), w.apply(z, k);
              }));
          };
        }),
        (e.debounce = function (w, R, k) {
          var z,
            ee,
            A,
            N,
            X,
            ae = function () {
              var W = e.now() - N;
              W < R
                ? (z = setTimeout(ae, R - W))
                : ((z = null), k || ((X = w.apply(A, ee)), (A = ee = null)));
            };
          return function () {
            (A = this), (ee = arguments), (N = e.now());
            var W = k && !z;
            return (
              z || (z = setTimeout(ae, R)),
              W && ((X = w.apply(A, ee)), (A = ee = null)),
              X
            );
          };
        }),
        (e.defaults = function (w) {
          if (!e.isObject(w)) return w;
          for (var R = 1, k = arguments.length; R < k; R++) {
            var z = arguments[R];
            for (var ee in z) w[ee] === void 0 && (w[ee] = z[ee]);
          }
          return w;
        }),
        (e.keys = function (w) {
          if (!e.isObject(w)) return [];
          if (x) return x(w);
          var R = [];
          for (var k in w) e.has(w, k) && R.push(k);
          return R;
        }),
        (e.has = function (w, R) {
          return f.call(w, R);
        }),
        (e.isObject = function (w) {
          return w === Object(w);
        }),
        (e.now =
          Date.now ||
          function () {
            return new Date().getTime();
          }),
        (e.templateSettings = {
          evaluate: /<%([\s\S]+?)%>/g,
          interpolate: /<%=([\s\S]+?)%>/g,
          escape: /<%-([\s\S]+?)%>/g,
        });
      var P = /(.)^/,
        L = {
          "'": "'",
          "\\": "\\",
          "\r": "r",
          "\n": "n",
          "\u2028": "u2028",
          "\u2029": "u2029",
        },
        M = /\\|'|\r|\n|\u2028|\u2029/g,
        _ = function (w) {
          return "\\" + L[w];
        },
        F = /^\s*(\w|\$)+\s*$/;
      return (
        (e.template = function (w, R, k) {
          !R && k && (R = k), (R = e.defaults({}, R, e.templateSettings));
          var z = RegExp(
              [
                (R.escape || P).source,
                (R.interpolate || P).source,
                (R.evaluate || P).source,
              ].join("|") + "|$",
              "g"
            ),
            ee = 0,
            A = "__p+='";
          w.replace(z, function (W, q, O, H, j) {
            return (
              (A += w.slice(ee, j).replace(M, _)),
              (ee = j + W.length),
              q
                ? (A +=
                    `'+
    ((__t=(` +
                    q +
                    `))==null?'':_.escape(__t))+
    '`)
                : O
                ? (A +=
                    `'+
    ((__t=(` +
                    O +
                    `))==null?'':__t)+
    '`)
                : H &&
                  (A +=
                    `';
    ` +
                    H +
                    `
    __p+='`),
              W
            );
          }),
            (A += `';
    `);
          var N = R.variable;
          if (N) {
            if (!F.test(N))
              throw new Error("variable is not a bare identifier: " + N);
          } else
            (A =
              `with(obj||{}){
    ` +
              A +
              `}
    `),
              (N = "obj");
          A =
            `var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};
    ` +
            A +
            `return __p;
    `;
          var X;
          try {
            X = new Function(R.variable || "obj", "_", A);
          } catch (W) {
            throw ((W.source = A), W);
          }
          var ae = function (W) {
            return X.call(this, W, e);
          };
          return (
            (ae.source =
              "function(" +
              N +
              `){
    ` +
              A +
              "}"),
            ae
          );
        }),
        e
      );
    })();
  });
  var Ne = E((Cee, gh) => {
    "use strict";
    var ye = {},
      Mr = {},
      Or = [],
      zs = window.Webflow || [],
      Ut = window.jQuery,
      pt = Ut(window),
      mw = Ut(document),
      _t = Ut.isFunction,
      ft = (ye._ = lh()),
      ch = (ye.tram = Vs() && Ut.tram),
      Mi = !1,
      Hs = !1;
    ch.config.hideBackface = !1;
    ch.config.keepInherited = !0;
    ye.define = function (e, t, r) {
      Mr[e] && fh(Mr[e]);
      var n = (Mr[e] = t(Ut, ft, r) || {});
      return hh(n), n;
    };
    ye.require = function (e) {
      return Mr[e];
    };
    function hh(e) {
      ye.env() &&
        (_t(e.design) && pt.on("__wf_design", e.design),
        _t(e.preview) && pt.on("__wf_preview", e.preview)),
        _t(e.destroy) && pt.on("__wf_destroy", e.destroy),
        e.ready && _t(e.ready) && gw(e);
    }
    function gw(e) {
      if (Mi) {
        e.ready();
        return;
      }
      ft.contains(Or, e.ready) || Or.push(e.ready);
    }
    function fh(e) {
      _t(e.design) && pt.off("__wf_design", e.design),
        _t(e.preview) && pt.off("__wf_preview", e.preview),
        _t(e.destroy) && pt.off("__wf_destroy", e.destroy),
        e.ready && _t(e.ready) && vw(e);
    }
    function vw(e) {
      Or = ft.filter(Or, function (t) {
        return t !== e.ready;
      });
    }
    ye.push = function (e) {
      if (Mi) {
        _t(e) && e();
        return;
      }
      zs.push(e);
    };
    ye.env = function (e) {
      var t = window.__wf_design,
        r = typeof t < "u";
      if (!e) return r;
      if (e === "design") return r && t;
      if (e === "preview") return r && !t;
      if (e === "slug") return r && window.__wf_slug;
      if (e === "editor") return window.WebflowEditor;
      if (e === "test") return window.__wf_test;
      if (e === "frame") return window !== window.top;
    };
    var Ci = navigator.userAgent.toLowerCase(),
      ph = (ye.env.touch =
        "ontouchstart" in window ||
        (window.DocumentTouch && document instanceof window.DocumentTouch)),
      yw = (ye.env.chrome =
        /chrome/.test(Ci) &&
        /Google/.test(navigator.vendor) &&
        parseInt(Ci.match(/chrome\/(\d+)\./)[1], 10)),
      Ew = (ye.env.ios = /(ipod|iphone|ipad)/.test(Ci));
    ye.env.safari = /safari/.test(Ci) && !yw && !Ew;
    var Gs;
    ph &&
      mw.on("touchstart mousedown", function (e) {
        Gs = e.target;
      });
    ye.validClick = ph
      ? function (e) {
          return e === Gs || Ut.contains(e, Gs);
        }
      : function () {
          return !0;
        };
    var dh = "resize.webflow orientationchange.webflow load.webflow",
      bw = "scroll.webflow " + dh;
    ye.resize = js(pt, dh);
    ye.scroll = js(pt, bw);
    ye.redraw = js();
    function js(e, t) {
      var r = [],
        n = {};
      return (
        (n.up = ft.throttle(function (i) {
          ft.each(r, function (a) {
            a(i);
          });
        })),
        e && t && e.on(t, n.up),
        (n.on = function (i) {
          typeof i == "function" && (ft.contains(r, i) || r.push(i));
        }),
        (n.off = function (i) {
          if (!arguments.length) {
            r = [];
            return;
          }
          r = ft.filter(r, function (a) {
            return a !== i;
          });
        }),
        n
      );
    }
    ye.location = function (e) {
      window.location = e;
    };
    ye.env() && (ye.location = function () {});
    ye.ready = function () {
      (Mi = !0), Hs ? xw() : ft.each(Or, uh), ft.each(zs, uh), ye.resize.up();
    };
    function uh(e) {
      _t(e) && e();
    }
    function xw() {
      (Hs = !1), ft.each(Mr, hh);
    }
    var hr;
    ye.load = function (e) {
      hr.then(e);
    };
    function mh() {
      hr && (hr.reject(), pt.off("load", hr.resolve)),
        (hr = new Ut.Deferred()),
        pt.on("load", hr.resolve);
    }
    ye.destroy = function (e) {
      (e = e || {}),
        (Hs = !0),
        pt.triggerHandler("__wf_destroy"),
        e.domready != null && (Mi = e.domready),
        ft.each(Mr, fh),
        ye.resize.off(),
        ye.scroll.off(),
        ye.redraw.off(),
        (Or = []),
        (zs = []),
        hr.state() === "pending" && mh();
    };
    Ut(ye.ready);
    mh();
    gh.exports = window.Webflow = ye;
  });
  var Ws = E((Mee, vh) => {
    function Sw(e, t, r, n) {
      for (var i = e.length, a = r + (n ? 1 : -1); n ? a-- : ++a < i; )
        if (t(e[a], a, e)) return a;
      return -1;
    }
    vh.exports = Sw;
  });
  var Eh = E((Oee, yh) => {
    function _w() {
      (this.__data__ = []), (this.size = 0);
    }
    yh.exports = _w;
  });
  var Oi = E((Ree, bh) => {
    function Iw(e, t) {
      return e === t || (e !== e && t !== t);
    }
    bh.exports = Iw;
  });
  var xn = E((Dee, xh) => {
    var Tw = Oi();
    function Aw(e, t) {
      for (var r = e.length; r--; ) if (Tw(e[r][0], t)) return r;
      return -1;
    }
    xh.exports = Aw;
  });
  var _h = E((Fee, Sh) => {
    var Pw = xn(),
      ww = Array.prototype,
      Cw = ww.splice;
    function Mw(e) {
      var t = this.__data__,
        r = Pw(t, e);
      if (r < 0) return !1;
      var n = t.length - 1;
      return r == n ? t.pop() : Cw.call(t, r, 1), --this.size, !0;
    }
    Sh.exports = Mw;
  });
  var Th = E((Lee, Ih) => {
    var Ow = xn();
    function Rw(e) {
      var t = this.__data__,
        r = Ow(t, e);
      return r < 0 ? void 0 : t[r][1];
    }
    Ih.exports = Rw;
  });
  var Ph = E((qee, Ah) => {
    var Dw = xn();
    function Fw(e) {
      return Dw(this.__data__, e) > -1;
    }
    Ah.exports = Fw;
  });
  var Ch = E((kee, wh) => {
    var Lw = xn();
    function qw(e, t) {
      var r = this.__data__,
        n = Lw(r, e);
      return n < 0 ? (++this.size, r.push([e, t])) : (r[n][1] = t), this;
    }
    wh.exports = qw;
  });
  var Sn = E((Nee, Mh) => {
    var kw = Eh(),
      Nw = _h(),
      Bw = Th(),
      Vw = Ph(),
      Gw = Ch();
    function Rr(e) {
      var t = -1,
        r = e == null ? 0 : e.length;
      for (this.clear(); ++t < r; ) {
        var n = e[t];
        this.set(n[0], n[1]);
      }
    }
    Rr.prototype.clear = kw;
    Rr.prototype.delete = Nw;
    Rr.prototype.get = Bw;
    Rr.prototype.has = Vw;
    Rr.prototype.set = Gw;
    Mh.exports = Rr;
  });
  var Rh = E((Bee, Oh) => {
    var zw = Sn();
    function Hw() {
      (this.__data__ = new zw()), (this.size = 0);
    }
    Oh.exports = Hw;
  });
  var Fh = E((Vee, Dh) => {
    function jw(e) {
      var t = this.__data__,
        r = t.delete(e);
      return (this.size = t.size), r;
    }
    Dh.exports = jw;
  });
  var qh = E((Gee, Lh) => {
    function Ww(e) {
      return this.__data__.get(e);
    }
    Lh.exports = Ww;
  });
  var Nh = E((zee, kh) => {
    function Uw(e) {
      return this.__data__.has(e);
    }
    kh.exports = Uw;
  });
  var Us = E((Hee, Bh) => {
    var Xw =
      typeof global == "object" && global && global.Object === Object && global;
    Bh.exports = Xw;
  });
  var dt = E((jee, Vh) => {
    var $w = Us(),
      Kw = typeof self == "object" && self && self.Object === Object && self,
      Yw = $w || Kw || Function("return this")();
    Vh.exports = Yw;
  });
  var Dr = E((Wee, Gh) => {
    var Qw = dt(),
      Zw = Qw.Symbol;
    Gh.exports = Zw;
  });
  var Wh = E((Uee, jh) => {
    var zh = Dr(),
      Hh = Object.prototype,
      Jw = Hh.hasOwnProperty,
      eC = Hh.toString,
      _n = zh ? zh.toStringTag : void 0;
    function tC(e) {
      var t = Jw.call(e, _n),
        r = e[_n];
      try {
        e[_n] = void 0;
        var n = !0;
      } catch {}
      var i = eC.call(e);
      return n && (t ? (e[_n] = r) : delete e[_n]), i;
    }
    jh.exports = tC;
  });
  var Xh = E((Xee, Uh) => {
    var rC = Object.prototype,
      nC = rC.toString;
    function iC(e) {
      return nC.call(e);
    }
    Uh.exports = iC;
  });
  var Xt = E(($ee, Yh) => {
    var $h = Dr(),
      aC = Wh(),
      sC = Xh(),
      oC = "[object Null]",
      lC = "[object Undefined]",
      Kh = $h ? $h.toStringTag : void 0;
    function uC(e) {
      return e == null
        ? e === void 0
          ? lC
          : oC
        : Kh && Kh in Object(e)
        ? aC(e)
        : sC(e);
    }
    Yh.exports = uC;
  });
  var It = E((Kee, Qh) => {
    function cC(e) {
      var t = typeof e;
      return e != null && (t == "object" || t == "function");
    }
    Qh.exports = cC;
  });
  var Xs = E((Yee, Zh) => {
    var hC = Xt(),
      fC = It(),
      pC = "[object AsyncFunction]",
      dC = "[object Function]",
      mC = "[object GeneratorFunction]",
      gC = "[object Proxy]";
    function vC(e) {
      if (!fC(e)) return !1;
      var t = hC(e);
      return t == dC || t == mC || t == pC || t == gC;
    }
    Zh.exports = vC;
  });
  var ef = E((Qee, Jh) => {
    var yC = dt(),
      EC = yC["__core-js_shared__"];
    Jh.exports = EC;
  });
  var nf = E((Zee, rf) => {
    var $s = ef(),
      tf = (function () {
        var e = /[^.]+$/.exec(($s && $s.keys && $s.keys.IE_PROTO) || "");
        return e ? "Symbol(src)_1." + e : "";
      })();
    function bC(e) {
      return !!tf && tf in e;
    }
    rf.exports = bC;
  });
  var Ks = E((Jee, af) => {
    var xC = Function.prototype,
      SC = xC.toString;
    function _C(e) {
      if (e != null) {
        try {
          return SC.call(e);
        } catch {}
        try {
          return e + "";
        } catch {}
      }
      return "";
    }
    af.exports = _C;
  });
  var of = E((ete, sf) => {
    var IC = Xs(),
      TC = nf(),
      AC = It(),
      PC = Ks(),
      wC = /[\\^$.*+?()[\]{}|]/g,
      CC = /^\[object .+?Constructor\]$/,
      MC = Function.prototype,
      OC = Object.prototype,
      RC = MC.toString,
      DC = OC.hasOwnProperty,
      FC = RegExp(
        "^" +
          RC.call(DC)
            .replace(wC, "\\$&")
            .replace(
              /hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,
              "$1.*?"
            ) +
          "$"
      );
    function LC(e) {
      if (!AC(e) || TC(e)) return !1;
      var t = IC(e) ? FC : CC;
      return t.test(PC(e));
    }
    sf.exports = LC;
  });
  var uf = E((tte, lf) => {
    function qC(e, t) {
      return e?.[t];
    }
    lf.exports = qC;
  });
  var $t = E((rte, cf) => {
    var kC = of(),
      NC = uf();
    function BC(e, t) {
      var r = NC(e, t);
      return kC(r) ? r : void 0;
    }
    cf.exports = BC;
  });
  var Ri = E((nte, hf) => {
    var VC = $t(),
      GC = dt(),
      zC = VC(GC, "Map");
    hf.exports = zC;
  });
  var In = E((ite, ff) => {
    var HC = $t(),
      jC = HC(Object, "create");
    ff.exports = jC;
  });
  var mf = E((ate, df) => {
    var pf = In();
    function WC() {
      (this.__data__ = pf ? pf(null) : {}), (this.size = 0);
    }
    df.exports = WC;
  });
  var vf = E((ste, gf) => {
    function UC(e) {
      var t = this.has(e) && delete this.__data__[e];
      return (this.size -= t ? 1 : 0), t;
    }
    gf.exports = UC;
  });
  var Ef = E((ote, yf) => {
    var XC = In(),
      $C = "__lodash_hash_undefined__",
      KC = Object.prototype,
      YC = KC.hasOwnProperty;
    function QC(e) {
      var t = this.__data__;
      if (XC) {
        var r = t[e];
        return r === $C ? void 0 : r;
      }
      return YC.call(t, e) ? t[e] : void 0;
    }
    yf.exports = QC;
  });
  var xf = E((lte, bf) => {
    var ZC = In(),
      JC = Object.prototype,
      eM = JC.hasOwnProperty;
    function tM(e) {
      var t = this.__data__;
      return ZC ? t[e] !== void 0 : eM.call(t, e);
    }
    bf.exports = tM;
  });
  var _f = E((ute, Sf) => {
    var rM = In(),
      nM = "__lodash_hash_undefined__";
    function iM(e, t) {
      var r = this.__data__;
      return (
        (this.size += this.has(e) ? 0 : 1),
        (r[e] = rM && t === void 0 ? nM : t),
        this
      );
    }
    Sf.exports = iM;
  });
  var Tf = E((cte, If) => {
    var aM = mf(),
      sM = vf(),
      oM = Ef(),
      lM = xf(),
      uM = _f();
    function Fr(e) {
      var t = -1,
        r = e == null ? 0 : e.length;
      for (this.clear(); ++t < r; ) {
        var n = e[t];
        this.set(n[0], n[1]);
      }
    }
    Fr.prototype.clear = aM;
    Fr.prototype.delete = sM;
    Fr.prototype.get = oM;
    Fr.prototype.has = lM;
    Fr.prototype.set = uM;
    If.exports = Fr;
  });
  var wf = E((hte, Pf) => {
    var Af = Tf(),
      cM = Sn(),
      hM = Ri();
    function fM() {
      (this.size = 0),
        (this.__data__ = {
          hash: new Af(),
          map: new (hM || cM)(),
          string: new Af(),
        });
    }
    Pf.exports = fM;
  });
  var Mf = E((fte, Cf) => {
    function pM(e) {
      var t = typeof e;
      return t == "string" || t == "number" || t == "symbol" || t == "boolean"
        ? e !== "__proto__"
        : e === null;
    }
    Cf.exports = pM;
  });
  var Tn = E((pte, Of) => {
    var dM = Mf();
    function mM(e, t) {
      var r = e.__data__;
      return dM(t) ? r[typeof t == "string" ? "string" : "hash"] : r.map;
    }
    Of.exports = mM;
  });
  var Df = E((dte, Rf) => {
    var gM = Tn();
    function vM(e) {
      var t = gM(this, e).delete(e);
      return (this.size -= t ? 1 : 0), t;
    }
    Rf.exports = vM;
  });
  var Lf = E((mte, Ff) => {
    var yM = Tn();
    function EM(e) {
      return yM(this, e).get(e);
    }
    Ff.exports = EM;
  });
  var kf = E((gte, qf) => {
    var bM = Tn();
    function xM(e) {
      return bM(this, e).has(e);
    }
    qf.exports = xM;
  });
  var Bf = E((vte, Nf) => {
    var SM = Tn();
    function _M(e, t) {
      var r = SM(this, e),
        n = r.size;
      return r.set(e, t), (this.size += r.size == n ? 0 : 1), this;
    }
    Nf.exports = _M;
  });
  var Di = E((yte, Vf) => {
    var IM = wf(),
      TM = Df(),
      AM = Lf(),
      PM = kf(),
      wM = Bf();
    function Lr(e) {
      var t = -1,
        r = e == null ? 0 : e.length;
      for (this.clear(); ++t < r; ) {
        var n = e[t];
        this.set(n[0], n[1]);
      }
    }
    Lr.prototype.clear = IM;
    Lr.prototype.delete = TM;
    Lr.prototype.get = AM;
    Lr.prototype.has = PM;
    Lr.prototype.set = wM;
    Vf.exports = Lr;
  });
  var zf = E((Ete, Gf) => {
    var CM = Sn(),
      MM = Ri(),
      OM = Di(),
      RM = 200;
    function DM(e, t) {
      var r = this.__data__;
      if (r instanceof CM) {
        var n = r.__data__;
        if (!MM || n.length < RM - 1)
          return n.push([e, t]), (this.size = ++r.size), this;
        r = this.__data__ = new OM(n);
      }
      return r.set(e, t), (this.size = r.size), this;
    }
    Gf.exports = DM;
  });
  var Ys = E((bte, Hf) => {
    var FM = Sn(),
      LM = Rh(),
      qM = Fh(),
      kM = qh(),
      NM = Nh(),
      BM = zf();
    function qr(e) {
      var t = (this.__data__ = new FM(e));
      this.size = t.size;
    }
    qr.prototype.clear = LM;
    qr.prototype.delete = qM;
    qr.prototype.get = kM;
    qr.prototype.has = NM;
    qr.prototype.set = BM;
    Hf.exports = qr;
  });
  var Wf = E((xte, jf) => {
    var VM = "__lodash_hash_undefined__";
    function GM(e) {
      return this.__data__.set(e, VM), this;
    }
    jf.exports = GM;
  });
  var Xf = E((Ste, Uf) => {
    function zM(e) {
      return this.__data__.has(e);
    }
    Uf.exports = zM;
  });
  var Kf = E((_te, $f) => {
    var HM = Di(),
      jM = Wf(),
      WM = Xf();
    function Fi(e) {
      var t = -1,
        r = e == null ? 0 : e.length;
      for (this.__data__ = new HM(); ++t < r; ) this.add(e[t]);
    }
    Fi.prototype.add = Fi.prototype.push = jM;
    Fi.prototype.has = WM;
    $f.exports = Fi;
  });
  var Qf = E((Ite, Yf) => {
    function UM(e, t) {
      for (var r = -1, n = e == null ? 0 : e.length; ++r < n; )
        if (t(e[r], r, e)) return !0;
      return !1;
    }
    Yf.exports = UM;
  });
  var Jf = E((Tte, Zf) => {
    function XM(e, t) {
      return e.has(t);
    }
    Zf.exports = XM;
  });
  var Qs = E((Ate, ep) => {
    var $M = Kf(),
      KM = Qf(),
      YM = Jf(),
      QM = 1,
      ZM = 2;
    function JM(e, t, r, n, i, a) {
      var o = r & QM,
        s = e.length,
        l = t.length;
      if (s != l && !(o && l > s)) return !1;
      var f = a.get(e),
        u = a.get(t);
      if (f && u) return f == t && u == e;
      var h = -1,
        m = !0,
        d = r & ZM ? new $M() : void 0;
      for (a.set(e, t), a.set(t, e); ++h < s; ) {
        var p = e[h],
          g = t[h];
        if (n) var c = o ? n(g, p, h, t, e, a) : n(p, g, h, e, t, a);
        if (c !== void 0) {
          if (c) continue;
          m = !1;
          break;
        }
        if (d) {
          if (
            !KM(t, function (v, y) {
              if (!YM(d, y) && (p === v || i(p, v, r, n, a))) return d.push(y);
            })
          ) {
            m = !1;
            break;
          }
        } else if (!(p === g || i(p, g, r, n, a))) {
          m = !1;
          break;
        }
      }
      return a.delete(e), a.delete(t), m;
    }
    ep.exports = JM;
  });
  var rp = E((Pte, tp) => {
    var eO = dt(),
      tO = eO.Uint8Array;
    tp.exports = tO;
  });
  var ip = E((wte, np) => {
    function rO(e) {
      var t = -1,
        r = Array(e.size);
      return (
        e.forEach(function (n, i) {
          r[++t] = [i, n];
        }),
        r
      );
    }
    np.exports = rO;
  });
  var sp = E((Cte, ap) => {
    function nO(e) {
      var t = -1,
        r = Array(e.size);
      return (
        e.forEach(function (n) {
          r[++t] = n;
        }),
        r
      );
    }
    ap.exports = nO;
  });
  var hp = E((Mte, cp) => {
    var op = Dr(),
      lp = rp(),
      iO = Oi(),
      aO = Qs(),
      sO = ip(),
      oO = sp(),
      lO = 1,
      uO = 2,
      cO = "[object Boolean]",
      hO = "[object Date]",
      fO = "[object Error]",
      pO = "[object Map]",
      dO = "[object Number]",
      mO = "[object RegExp]",
      gO = "[object Set]",
      vO = "[object String]",
      yO = "[object Symbol]",
      EO = "[object ArrayBuffer]",
      bO = "[object DataView]",
      up = op ? op.prototype : void 0,
      Zs = up ? up.valueOf : void 0;
    function xO(e, t, r, n, i, a, o) {
      switch (r) {
        case bO:
          if (e.byteLength != t.byteLength || e.byteOffset != t.byteOffset)
            return !1;
          (e = e.buffer), (t = t.buffer);
        case EO:
          return !(e.byteLength != t.byteLength || !a(new lp(e), new lp(t)));
        case cO:
        case hO:
        case dO:
          return iO(+e, +t);
        case fO:
          return e.name == t.name && e.message == t.message;
        case mO:
        case vO:
          return e == t + "";
        case pO:
          var s = sO;
        case gO:
          var l = n & lO;
          if ((s || (s = oO), e.size != t.size && !l)) return !1;
          var f = o.get(e);
          if (f) return f == t;
          (n |= uO), o.set(e, t);
          var u = aO(s(e), s(t), n, i, a, o);
          return o.delete(e), u;
        case yO:
          if (Zs) return Zs.call(e) == Zs.call(t);
      }
      return !1;
    }
    cp.exports = xO;
  });
  var Li = E((Ote, fp) => {
    function SO(e, t) {
      for (var r = -1, n = t.length, i = e.length; ++r < n; ) e[i + r] = t[r];
      return e;
    }
    fp.exports = SO;
  });
  var qe = E((Rte, pp) => {
    var _O = Array.isArray;
    pp.exports = _O;
  });
  var Js = E((Dte, dp) => {
    var IO = Li(),
      TO = qe();
    function AO(e, t, r) {
      var n = t(e);
      return TO(e) ? n : IO(n, r(e));
    }
    dp.exports = AO;
  });
  var gp = E((Fte, mp) => {
    function PO(e, t) {
      for (var r = -1, n = e == null ? 0 : e.length, i = 0, a = []; ++r < n; ) {
        var o = e[r];
        t(o, r, e) && (a[i++] = o);
      }
      return a;
    }
    mp.exports = PO;
  });
  var eo = E((Lte, vp) => {
    function wO() {
      return [];
    }
    vp.exports = wO;
  });
  var to = E((qte, Ep) => {
    var CO = gp(),
      MO = eo(),
      OO = Object.prototype,
      RO = OO.propertyIsEnumerable,
      yp = Object.getOwnPropertySymbols,
      DO = yp
        ? function (e) {
            return e == null
              ? []
              : ((e = Object(e)),
                CO(yp(e), function (t) {
                  return RO.call(e, t);
                }));
          }
        : MO;
    Ep.exports = DO;
  });
  var xp = E((kte, bp) => {
    function FO(e, t) {
      for (var r = -1, n = Array(e); ++r < e; ) n[r] = t(r);
      return n;
    }
    bp.exports = FO;
  });
  var Ft = E((Nte, Sp) => {
    function LO(e) {
      return e != null && typeof e == "object";
    }
    Sp.exports = LO;
  });
  var Ip = E((Bte, _p) => {
    var qO = Xt(),
      kO = Ft(),
      NO = "[object Arguments]";
    function BO(e) {
      return kO(e) && qO(e) == NO;
    }
    _p.exports = BO;
  });
  var An = E((Vte, Pp) => {
    var Tp = Ip(),
      VO = Ft(),
      Ap = Object.prototype,
      GO = Ap.hasOwnProperty,
      zO = Ap.propertyIsEnumerable,
      HO = Tp(
        (function () {
          return arguments;
        })()
      )
        ? Tp
        : function (e) {
            return VO(e) && GO.call(e, "callee") && !zO.call(e, "callee");
          };
    Pp.exports = HO;
  });
  var Cp = E((Gte, wp) => {
    function jO() {
      return !1;
    }
    wp.exports = jO;
  });
  var qi = E((Pn, kr) => {
    var WO = dt(),
      UO = Cp(),
      Rp = typeof Pn == "object" && Pn && !Pn.nodeType && Pn,
      Mp = Rp && typeof kr == "object" && kr && !kr.nodeType && kr,
      XO = Mp && Mp.exports === Rp,
      Op = XO ? WO.Buffer : void 0,
      $O = Op ? Op.isBuffer : void 0,
      KO = $O || UO;
    kr.exports = KO;
  });
  var ki = E((zte, Dp) => {
    var YO = 9007199254740991,
      QO = /^(?:0|[1-9]\d*)$/;
    function ZO(e, t) {
      var r = typeof e;
      return (
        (t = t ?? YO),
        !!t &&
          (r == "number" || (r != "symbol" && QO.test(e))) &&
          e > -1 &&
          e % 1 == 0 &&
          e < t
      );
    }
    Dp.exports = ZO;
  });
  var Ni = E((Hte, Fp) => {
    var JO = 9007199254740991;
    function eR(e) {
      return typeof e == "number" && e > -1 && e % 1 == 0 && e <= JO;
    }
    Fp.exports = eR;
  });
  var qp = E((jte, Lp) => {
    var tR = Xt(),
      rR = Ni(),
      nR = Ft(),
      iR = "[object Arguments]",
      aR = "[object Array]",
      sR = "[object Boolean]",
      oR = "[object Date]",
      lR = "[object Error]",
      uR = "[object Function]",
      cR = "[object Map]",
      hR = "[object Number]",
      fR = "[object Object]",
      pR = "[object RegExp]",
      dR = "[object Set]",
      mR = "[object String]",
      gR = "[object WeakMap]",
      vR = "[object ArrayBuffer]",
      yR = "[object DataView]",
      ER = "[object Float32Array]",
      bR = "[object Float64Array]",
      xR = "[object Int8Array]",
      SR = "[object Int16Array]",
      _R = "[object Int32Array]",
      IR = "[object Uint8Array]",
      TR = "[object Uint8ClampedArray]",
      AR = "[object Uint16Array]",
      PR = "[object Uint32Array]",
      Se = {};
    Se[ER] =
      Se[bR] =
      Se[xR] =
      Se[SR] =
      Se[_R] =
      Se[IR] =
      Se[TR] =
      Se[AR] =
      Se[PR] =
        !0;
    Se[iR] =
      Se[aR] =
      Se[vR] =
      Se[sR] =
      Se[yR] =
      Se[oR] =
      Se[lR] =
      Se[uR] =
      Se[cR] =
      Se[hR] =
      Se[fR] =
      Se[pR] =
      Se[dR] =
      Se[mR] =
      Se[gR] =
        !1;
    function wR(e) {
      return nR(e) && rR(e.length) && !!Se[tR(e)];
    }
    Lp.exports = wR;
  });
  var Np = E((Wte, kp) => {
    function CR(e) {
      return function (t) {
        return e(t);
      };
    }
    kp.exports = CR;
  });
  var Vp = E((wn, Nr) => {
    var MR = Us(),
      Bp = typeof wn == "object" && wn && !wn.nodeType && wn,
      Cn = Bp && typeof Nr == "object" && Nr && !Nr.nodeType && Nr,
      OR = Cn && Cn.exports === Bp,
      ro = OR && MR.process,
      RR = (function () {
        try {
          var e = Cn && Cn.require && Cn.require("util").types;
          return e || (ro && ro.binding && ro.binding("util"));
        } catch {}
      })();
    Nr.exports = RR;
  });
  var Bi = E((Ute, Hp) => {
    var DR = qp(),
      FR = Np(),
      Gp = Vp(),
      zp = Gp && Gp.isTypedArray,
      LR = zp ? FR(zp) : DR;
    Hp.exports = LR;
  });
  var no = E((Xte, jp) => {
    var qR = xp(),
      kR = An(),
      NR = qe(),
      BR = qi(),
      VR = ki(),
      GR = Bi(),
      zR = Object.prototype,
      HR = zR.hasOwnProperty;
    function jR(e, t) {
      var r = NR(e),
        n = !r && kR(e),
        i = !r && !n && BR(e),
        a = !r && !n && !i && GR(e),
        o = r || n || i || a,
        s = o ? qR(e.length, String) : [],
        l = s.length;
      for (var f in e)
        (t || HR.call(e, f)) &&
          !(
            o &&
            (f == "length" ||
              (i && (f == "offset" || f == "parent")) ||
              (a &&
                (f == "buffer" || f == "byteLength" || f == "byteOffset")) ||
              VR(f, l))
          ) &&
          s.push(f);
      return s;
    }
    jp.exports = jR;
  });
  var Vi = E(($te, Wp) => {
    var WR = Object.prototype;
    function UR(e) {
      var t = e && e.constructor,
        r = (typeof t == "function" && t.prototype) || WR;
      return e === r;
    }
    Wp.exports = UR;
  });
  var io = E((Kte, Up) => {
    function XR(e, t) {
      return function (r) {
        return e(t(r));
      };
    }
    Up.exports = XR;
  });
  var $p = E((Yte, Xp) => {
    var $R = io(),
      KR = $R(Object.keys, Object);
    Xp.exports = KR;
  });
  var Gi = E((Qte, Kp) => {
    var YR = Vi(),
      QR = $p(),
      ZR = Object.prototype,
      JR = ZR.hasOwnProperty;
    function eD(e) {
      if (!YR(e)) return QR(e);
      var t = [];
      for (var r in Object(e)) JR.call(e, r) && r != "constructor" && t.push(r);
      return t;
    }
    Kp.exports = eD;
  });
  var fr = E((Zte, Yp) => {
    var tD = Xs(),
      rD = Ni();
    function nD(e) {
      return e != null && rD(e.length) && !tD(e);
    }
    Yp.exports = nD;
  });
  var Mn = E((Jte, Qp) => {
    var iD = no(),
      aD = Gi(),
      sD = fr();
    function oD(e) {
      return sD(e) ? iD(e) : aD(e);
    }
    Qp.exports = oD;
  });
  var Jp = E((ere, Zp) => {
    var lD = Js(),
      uD = to(),
      cD = Mn();
    function hD(e) {
      return lD(e, cD, uD);
    }
    Zp.exports = hD;
  });
  var rd = E((tre, td) => {
    var ed = Jp(),
      fD = 1,
      pD = Object.prototype,
      dD = pD.hasOwnProperty;
    function mD(e, t, r, n, i, a) {
      var o = r & fD,
        s = ed(e),
        l = s.length,
        f = ed(t),
        u = f.length;
      if (l != u && !o) return !1;
      for (var h = l; h--; ) {
        var m = s[h];
        if (!(o ? m in t : dD.call(t, m))) return !1;
      }
      var d = a.get(e),
        p = a.get(t);
      if (d && p) return d == t && p == e;
      var g = !0;
      a.set(e, t), a.set(t, e);
      for (var c = o; ++h < l; ) {
        m = s[h];
        var v = e[m],
          y = t[m];
        if (n) var b = o ? n(y, v, m, t, e, a) : n(v, y, m, e, t, a);
        if (!(b === void 0 ? v === y || i(v, y, r, n, a) : b)) {
          g = !1;
          break;
        }
        c || (c = m == "constructor");
      }
      if (g && !c) {
        var x = e.constructor,
          S = t.constructor;
        x != S &&
          "constructor" in e &&
          "constructor" in t &&
          !(
            typeof x == "function" &&
            x instanceof x &&
            typeof S == "function" &&
            S instanceof S
          ) &&
          (g = !1);
      }
      return a.delete(e), a.delete(t), g;
    }
    td.exports = mD;
  });
  var id = E((rre, nd) => {
    var gD = $t(),
      vD = dt(),
      yD = gD(vD, "DataView");
    nd.exports = yD;
  });
  var sd = E((nre, ad) => {
    var ED = $t(),
      bD = dt(),
      xD = ED(bD, "Promise");
    ad.exports = xD;
  });
  var ld = E((ire, od) => {
    var SD = $t(),
      _D = dt(),
      ID = SD(_D, "Set");
    od.exports = ID;
  });
  var ao = E((are, ud) => {
    var TD = $t(),
      AD = dt(),
      PD = TD(AD, "WeakMap");
    ud.exports = PD;
  });
  var zi = E((sre, gd) => {
    var so = id(),
      oo = Ri(),
      lo = sd(),
      uo = ld(),
      co = ao(),
      md = Xt(),
      Br = Ks(),
      cd = "[object Map]",
      wD = "[object Object]",
      hd = "[object Promise]",
      fd = "[object Set]",
      pd = "[object WeakMap]",
      dd = "[object DataView]",
      CD = Br(so),
      MD = Br(oo),
      OD = Br(lo),
      RD = Br(uo),
      DD = Br(co),
      pr = md;
    ((so && pr(new so(new ArrayBuffer(1))) != dd) ||
      (oo && pr(new oo()) != cd) ||
      (lo && pr(lo.resolve()) != hd) ||
      (uo && pr(new uo()) != fd) ||
      (co && pr(new co()) != pd)) &&
      (pr = function (e) {
        var t = md(e),
          r = t == wD ? e.constructor : void 0,
          n = r ? Br(r) : "";
        if (n)
          switch (n) {
            case CD:
              return dd;
            case MD:
              return cd;
            case OD:
              return hd;
            case RD:
              return fd;
            case DD:
              return pd;
          }
        return t;
      });
    gd.exports = pr;
  });
  var Id = E((ore, _d) => {
    var ho = Ys(),
      FD = Qs(),
      LD = hp(),
      qD = rd(),
      vd = zi(),
      yd = qe(),
      Ed = qi(),
      kD = Bi(),
      ND = 1,
      bd = "[object Arguments]",
      xd = "[object Array]",
      Hi = "[object Object]",
      BD = Object.prototype,
      Sd = BD.hasOwnProperty;
    function VD(e, t, r, n, i, a) {
      var o = yd(e),
        s = yd(t),
        l = o ? xd : vd(e),
        f = s ? xd : vd(t);
      (l = l == bd ? Hi : l), (f = f == bd ? Hi : f);
      var u = l == Hi,
        h = f == Hi,
        m = l == f;
      if (m && Ed(e)) {
        if (!Ed(t)) return !1;
        (o = !0), (u = !1);
      }
      if (m && !u)
        return (
          a || (a = new ho()),
          o || kD(e) ? FD(e, t, r, n, i, a) : LD(e, t, l, r, n, i, a)
        );
      if (!(r & ND)) {
        var d = u && Sd.call(e, "__wrapped__"),
          p = h && Sd.call(t, "__wrapped__");
        if (d || p) {
          var g = d ? e.value() : e,
            c = p ? t.value() : t;
          return a || (a = new ho()), i(g, c, r, n, a);
        }
      }
      return m ? (a || (a = new ho()), qD(e, t, r, n, i, a)) : !1;
    }
    _d.exports = VD;
  });
  var fo = E((lre, Pd) => {
    var GD = Id(),
      Td = Ft();
    function Ad(e, t, r, n, i) {
      return e === t
        ? !0
        : e == null || t == null || (!Td(e) && !Td(t))
        ? e !== e && t !== t
        : GD(e, t, r, n, Ad, i);
    }
    Pd.exports = Ad;
  });
  var Cd = E((ure, wd) => {
    var zD = Ys(),
      HD = fo(),
      jD = 1,
      WD = 2;
    function UD(e, t, r, n) {
      var i = r.length,
        a = i,
        o = !n;
      if (e == null) return !a;
      for (e = Object(e); i--; ) {
        var s = r[i];
        if (o && s[2] ? s[1] !== e[s[0]] : !(s[0] in e)) return !1;
      }
      for (; ++i < a; ) {
        s = r[i];
        var l = s[0],
          f = e[l],
          u = s[1];
        if (o && s[2]) {
          if (f === void 0 && !(l in e)) return !1;
        } else {
          var h = new zD();
          if (n) var m = n(f, u, l, e, t, h);
          if (!(m === void 0 ? HD(u, f, jD | WD, n, h) : m)) return !1;
        }
      }
      return !0;
    }
    wd.exports = UD;
  });
  var po = E((cre, Md) => {
    var XD = It();
    function $D(e) {
      return e === e && !XD(e);
    }
    Md.exports = $D;
  });
  var Rd = E((hre, Od) => {
    var KD = po(),
      YD = Mn();
    function QD(e) {
      for (var t = YD(e), r = t.length; r--; ) {
        var n = t[r],
          i = e[n];
        t[r] = [n, i, KD(i)];
      }
      return t;
    }
    Od.exports = QD;
  });
  var mo = E((fre, Dd) => {
    function ZD(e, t) {
      return function (r) {
        return r == null ? !1 : r[e] === t && (t !== void 0 || e in Object(r));
      };
    }
    Dd.exports = ZD;
  });
  var Ld = E((pre, Fd) => {
    var JD = Cd(),
      eF = Rd(),
      tF = mo();
    function rF(e) {
      var t = eF(e);
      return t.length == 1 && t[0][2]
        ? tF(t[0][0], t[0][1])
        : function (r) {
            return r === e || JD(r, e, t);
          };
    }
    Fd.exports = rF;
  });
  var On = E((dre, qd) => {
    var nF = Xt(),
      iF = Ft(),
      aF = "[object Symbol]";
    function sF(e) {
      return typeof e == "symbol" || (iF(e) && nF(e) == aF);
    }
    qd.exports = sF;
  });
  var ji = E((mre, kd) => {
    var oF = qe(),
      lF = On(),
      uF = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
      cF = /^\w*$/;
    function hF(e, t) {
      if (oF(e)) return !1;
      var r = typeof e;
      return r == "number" ||
        r == "symbol" ||
        r == "boolean" ||
        e == null ||
        lF(e)
        ? !0
        : cF.test(e) || !uF.test(e) || (t != null && e in Object(t));
    }
    kd.exports = hF;
  });
  var Vd = E((gre, Bd) => {
    var Nd = Di(),
      fF = "Expected a function";
    function go(e, t) {
      if (typeof e != "function" || (t != null && typeof t != "function"))
        throw new TypeError(fF);
      var r = function () {
        var n = arguments,
          i = t ? t.apply(this, n) : n[0],
          a = r.cache;
        if (a.has(i)) return a.get(i);
        var o = e.apply(this, n);
        return (r.cache = a.set(i, o) || a), o;
      };
      return (r.cache = new (go.Cache || Nd)()), r;
    }
    go.Cache = Nd;
    Bd.exports = go;
  });
  var zd = E((vre, Gd) => {
    var pF = Vd(),
      dF = 500;
    function mF(e) {
      var t = pF(e, function (n) {
          return r.size === dF && r.clear(), n;
        }),
        r = t.cache;
      return t;
    }
    Gd.exports = mF;
  });
  var jd = E((yre, Hd) => {
    var gF = zd(),
      vF =
        /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,
      yF = /\\(\\)?/g,
      EF = gF(function (e) {
        var t = [];
        return (
          e.charCodeAt(0) === 46 && t.push(""),
          e.replace(vF, function (r, n, i, a) {
            t.push(i ? a.replace(yF, "$1") : n || r);
          }),
          t
        );
      });
    Hd.exports = EF;
  });
  var vo = E((Ere, Wd) => {
    function bF(e, t) {
      for (var r = -1, n = e == null ? 0 : e.length, i = Array(n); ++r < n; )
        i[r] = t(e[r], r, e);
      return i;
    }
    Wd.exports = bF;
  });
  var Qd = E((bre, Yd) => {
    var Ud = Dr(),
      xF = vo(),
      SF = qe(),
      _F = On(),
      IF = 1 / 0,
      Xd = Ud ? Ud.prototype : void 0,
      $d = Xd ? Xd.toString : void 0;
    function Kd(e) {
      if (typeof e == "string") return e;
      if (SF(e)) return xF(e, Kd) + "";
      if (_F(e)) return $d ? $d.call(e) : "";
      var t = e + "";
      return t == "0" && 1 / e == -IF ? "-0" : t;
    }
    Yd.exports = Kd;
  });
  var Jd = E((xre, Zd) => {
    var TF = Qd();
    function AF(e) {
      return e == null ? "" : TF(e);
    }
    Zd.exports = AF;
  });
  var Rn = E((Sre, em) => {
    var PF = qe(),
      wF = ji(),
      CF = jd(),
      MF = Jd();
    function OF(e, t) {
      return PF(e) ? e : wF(e, t) ? [e] : CF(MF(e));
    }
    em.exports = OF;
  });
  var Vr = E((_re, tm) => {
    var RF = On(),
      DF = 1 / 0;
    function FF(e) {
      if (typeof e == "string" || RF(e)) return e;
      var t = e + "";
      return t == "0" && 1 / e == -DF ? "-0" : t;
    }
    tm.exports = FF;
  });
  var Wi = E((Ire, rm) => {
    var LF = Rn(),
      qF = Vr();
    function kF(e, t) {
      t = LF(t, e);
      for (var r = 0, n = t.length; e != null && r < n; ) e = e[qF(t[r++])];
      return r && r == n ? e : void 0;
    }
    rm.exports = kF;
  });
  var Ui = E((Tre, nm) => {
    var NF = Wi();
    function BF(e, t, r) {
      var n = e == null ? void 0 : NF(e, t);
      return n === void 0 ? r : n;
    }
    nm.exports = BF;
  });
  var am = E((Are, im) => {
    function VF(e, t) {
      return e != null && t in Object(e);
    }
    im.exports = VF;
  });
  var om = E((Pre, sm) => {
    var GF = Rn(),
      zF = An(),
      HF = qe(),
      jF = ki(),
      WF = Ni(),
      UF = Vr();
    function XF(e, t, r) {
      t = GF(t, e);
      for (var n = -1, i = t.length, a = !1; ++n < i; ) {
        var o = UF(t[n]);
        if (!(a = e != null && r(e, o))) break;
        e = e[o];
      }
      return a || ++n != i
        ? a
        : ((i = e == null ? 0 : e.length),
          !!i && WF(i) && jF(o, i) && (HF(e) || zF(e)));
    }
    sm.exports = XF;
  });
  var um = E((wre, lm) => {
    var $F = am(),
      KF = om();
    function YF(e, t) {
      return e != null && KF(e, t, $F);
    }
    lm.exports = YF;
  });
  var hm = E((Cre, cm) => {
    var QF = fo(),
      ZF = Ui(),
      JF = um(),
      e2 = ji(),
      t2 = po(),
      r2 = mo(),
      n2 = Vr(),
      i2 = 1,
      a2 = 2;
    function s2(e, t) {
      return e2(e) && t2(t)
        ? r2(n2(e), t)
        : function (r) {
            var n = ZF(r, e);
            return n === void 0 && n === t ? JF(r, e) : QF(t, n, i2 | a2);
          };
    }
    cm.exports = s2;
  });
  var Xi = E((Mre, fm) => {
    function o2(e) {
      return e;
    }
    fm.exports = o2;
  });
  var yo = E((Ore, pm) => {
    function l2(e) {
      return function (t) {
        return t?.[e];
      };
    }
    pm.exports = l2;
  });
  var mm = E((Rre, dm) => {
    var u2 = Wi();
    function c2(e) {
      return function (t) {
        return u2(t, e);
      };
    }
    dm.exports = c2;
  });
  var vm = E((Dre, gm) => {
    var h2 = yo(),
      f2 = mm(),
      p2 = ji(),
      d2 = Vr();
    function m2(e) {
      return p2(e) ? h2(d2(e)) : f2(e);
    }
    gm.exports = m2;
  });
  var Kt = E((Fre, ym) => {
    var g2 = Ld(),
      v2 = hm(),
      y2 = Xi(),
      E2 = qe(),
      b2 = vm();
    function x2(e) {
      return typeof e == "function"
        ? e
        : e == null
        ? y2
        : typeof e == "object"
        ? E2(e)
          ? v2(e[0], e[1])
          : g2(e)
        : b2(e);
    }
    ym.exports = x2;
  });
  var bm = E((Lre, Em) => {
    var S2 = /\s/;
    function _2(e) {
      for (var t = e.length; t-- && S2.test(e.charAt(t)); );
      return t;
    }
    Em.exports = _2;
  });
  var Sm = E((qre, xm) => {
    var I2 = bm(),
      T2 = /^\s+/;
    function A2(e) {
      return e && e.slice(0, I2(e) + 1).replace(T2, "");
    }
    xm.exports = A2;
  });
  var $i = E((kre, Tm) => {
    var P2 = Sm(),
      _m = It(),
      w2 = On(),
      Im = 0 / 0,
      C2 = /^[-+]0x[0-9a-f]+$/i,
      M2 = /^0b[01]+$/i,
      O2 = /^0o[0-7]+$/i,
      R2 = parseInt;
    function D2(e) {
      if (typeof e == "number") return e;
      if (w2(e)) return Im;
      if (_m(e)) {
        var t = typeof e.valueOf == "function" ? e.valueOf() : e;
        e = _m(t) ? t + "" : t;
      }
      if (typeof e != "string") return e === 0 ? e : +e;
      e = P2(e);
      var r = M2.test(e);
      return r || O2.test(e) ? R2(e.slice(2), r ? 2 : 8) : C2.test(e) ? Im : +e;
    }
    Tm.exports = D2;
  });
  var wm = E((Nre, Pm) => {
    var F2 = $i(),
      Am = 1 / 0,
      L2 = 17976931348623157e292;
    function q2(e) {
      if (!e) return e === 0 ? e : 0;
      if (((e = F2(e)), e === Am || e === -Am)) {
        var t = e < 0 ? -1 : 1;
        return t * L2;
      }
      return e === e ? e : 0;
    }
    Pm.exports = q2;
  });
  var Eo = E((Bre, Cm) => {
    var k2 = wm();
    function N2(e) {
      var t = k2(e),
        r = t % 1;
      return t === t ? (r ? t - r : t) : 0;
    }
    Cm.exports = N2;
  });
  var bo = E((Vre, Mm) => {
    var B2 = Ws(),
      V2 = Kt(),
      G2 = Eo(),
      z2 = Math.max;
    function H2(e, t, r) {
      var n = e == null ? 0 : e.length;
      if (!n) return -1;
      var i = r == null ? 0 : G2(r);
      return i < 0 && (i = z2(n + i, 0)), B2(e, V2(t, 3), i);
    }
    Mm.exports = H2;
  });
  var he = E((Gre, Om) => {
    var Ki = function (e) {
      return e && e.Math == Math && e;
    };
    Om.exports =
      Ki(typeof globalThis == "object" && globalThis) ||
      Ki(typeof window == "object" && window) ||
      Ki(typeof self == "object" && self) ||
      Ki(typeof global == "object" && global) ||
      (function () {
        return this;
      })() ||
      Function("return this")();
  });
  var Fe = E((zre, Rm) => {
    Rm.exports = function (e) {
      try {
        return !!e();
      } catch {
        return !0;
      }
    };
  });
  var mt = E((Hre, Dm) => {
    var j2 = Fe();
    Dm.exports = !j2(function () {
      return (
        Object.defineProperty({}, 1, {
          get: function () {
            return 7;
          },
        })[1] != 7
      );
    });
  });
  var rt = E((jre, Fm) => {
    var Dn = Function.prototype.call;
    Fm.exports = Dn.bind
      ? Dn.bind(Dn)
      : function () {
          return Dn.apply(Dn, arguments);
        };
  });
  var Nm = E((km) => {
    "use strict";
    var Lm = {}.propertyIsEnumerable,
      qm = Object.getOwnPropertyDescriptor,
      W2 = qm && !Lm.call({ 1: 2 }, 1);
    km.f = W2
      ? function (t) {
          var r = qm(this, t);
          return !!r && r.enumerable;
        }
      : Lm;
  });
  var Fn = E((Ure, Bm) => {
    Bm.exports = function (e, t) {
      return {
        enumerable: !(e & 1),
        configurable: !(e & 2),
        writable: !(e & 4),
        value: t,
      };
    };
  });
  var _e = E((Xre, Gm) => {
    var Vm = Function.prototype,
      xo = Vm.bind,
      So = Vm.call,
      U2 = xo && xo.bind(So);
    Gm.exports = xo
      ? function (e) {
          return e && U2(So, e);
        }
      : function (e) {
          return (
            e &&
            function () {
              return So.apply(e, arguments);
            }
          );
        };
  });
  var Gr = E(($re, Hm) => {
    var zm = _e(),
      X2 = zm({}.toString),
      $2 = zm("".slice);
    Hm.exports = function (e) {
      return $2(X2(e), 8, -1);
    };
  });
  var dr = E((Kre, jm) => {
    var K2 = he(),
      Y2 = _e(),
      Q2 = Fe(),
      Z2 = Gr(),
      _o = K2.Object,
      J2 = Y2("".split);
    jm.exports = Q2(function () {
      return !_o("z").propertyIsEnumerable(0);
    })
      ? function (e) {
          return Z2(e) == "String" ? J2(e, "") : _o(e);
        }
      : _o;
  });
  var Yi = E((Yre, Wm) => {
    var eL = he(),
      tL = eL.TypeError;
    Wm.exports = function (e) {
      if (e == null) throw tL("Can't call method on " + e);
      return e;
    };
  });
  var Tt = E((Qre, Um) => {
    var rL = dr(),
      nL = Yi();
    Um.exports = function (e) {
      return rL(nL(e));
    };
  });
  var Pe = E((Zre, Xm) => {
    Xm.exports = function (e) {
      return typeof e == "function";
    };
  });
  var je = E((Jre, $m) => {
    var iL = Pe();
    $m.exports = function (e) {
      return typeof e == "object" ? e !== null : iL(e);
    };
  });
  var nt = E((ene, Km) => {
    var Io = he(),
      aL = Pe(),
      sL = function (e) {
        return aL(e) ? e : void 0;
      };
    Km.exports = function (e, t) {
      return arguments.length < 2 ? sL(Io[e]) : Io[e] && Io[e][t];
    };
  });
  var Qi = E((tne, Ym) => {
    var oL = _e();
    Ym.exports = oL({}.isPrototypeOf);
  });
  var Yt = E((rne, Qm) => {
    var lL = nt();
    Qm.exports = lL("navigator", "userAgent") || "";
  });
  var Qt = E((nne, ng) => {
    var rg = he(),
      To = Yt(),
      Zm = rg.process,
      Jm = rg.Deno,
      eg = (Zm && Zm.versions) || (Jm && Jm.version),
      tg = eg && eg.v8,
      gt,
      Zi;
    tg &&
      ((gt = tg.split(".")),
      (Zi = gt[0] > 0 && gt[0] < 4 ? 1 : +(gt[0] + gt[1])));
    !Zi &&
      To &&
      ((gt = To.match(/Edge\/(\d+)/)),
      (!gt || gt[1] >= 74) &&
        ((gt = To.match(/Chrome\/(\d+)/)), gt && (Zi = +gt[1])));
    ng.exports = Zi;
  });
  var Ao = E((ine, ag) => {
    var ig = Qt(),
      uL = Fe();
    ag.exports =
      !!Object.getOwnPropertySymbols &&
      !uL(function () {
        var e = Symbol();
        return (
          !String(e) ||
          !(Object(e) instanceof Symbol) ||
          (!Symbol.sham && ig && ig < 41)
        );
      });
  });
  var Po = E((ane, sg) => {
    var cL = Ao();
    sg.exports = cL && !Symbol.sham && typeof Symbol.iterator == "symbol";
  });
  var wo = E((sne, og) => {
    var hL = he(),
      fL = nt(),
      pL = Pe(),
      dL = Qi(),
      mL = Po(),
      gL = hL.Object;
    og.exports = mL
      ? function (e) {
          return typeof e == "symbol";
        }
      : function (e) {
          var t = fL("Symbol");
          return pL(t) && dL(t.prototype, gL(e));
        };
  });
  var Ln = E((one, lg) => {
    var vL = he(),
      yL = vL.String;
    lg.exports = function (e) {
      try {
        return yL(e);
      } catch {
        return "Object";
      }
    };
  });
  var vt = E((lne, ug) => {
    var EL = he(),
      bL = Pe(),
      xL = Ln(),
      SL = EL.TypeError;
    ug.exports = function (e) {
      if (bL(e)) return e;
      throw SL(xL(e) + " is not a function");
    };
  });
  var Zt = E((une, cg) => {
    var _L = vt();
    cg.exports = function (e, t) {
      var r = e[t];
      return r == null ? void 0 : _L(r);
    };
  });
  var fg = E((cne, hg) => {
    var IL = he(),
      Co = rt(),
      Mo = Pe(),
      Oo = je(),
      TL = IL.TypeError;
    hg.exports = function (e, t) {
      var r, n;
      if (
        (t === "string" && Mo((r = e.toString)) && !Oo((n = Co(r, e)))) ||
        (Mo((r = e.valueOf)) && !Oo((n = Co(r, e)))) ||
        (t !== "string" && Mo((r = e.toString)) && !Oo((n = Co(r, e))))
      )
        return n;
      throw TL("Can't convert object to primitive value");
    };
  });
  var zr = E((hne, pg) => {
    pg.exports = !1;
  });
  var Ji = E((fne, mg) => {
    var dg = he(),
      AL = Object.defineProperty;
    mg.exports = function (e, t) {
      try {
        AL(dg, e, { value: t, configurable: !0, writable: !0 });
      } catch {
        dg[e] = t;
      }
      return t;
    };
  });
  var qn = E((pne, vg) => {
    var PL = he(),
      wL = Ji(),
      gg = "__core-js_shared__",
      CL = PL[gg] || wL(gg, {});
    vg.exports = CL;
  });
  var Ro = E((dne, Eg) => {
    var ML = zr(),
      yg = qn();
    (Eg.exports = function (e, t) {
      return yg[e] || (yg[e] = t !== void 0 ? t : {});
    })("versions", []).push({
      version: "3.19.0",
      mode: ML ? "pure" : "global",
      copyright: "\xA9 2021 Denis Pushkarev (zloirock.ru)",
    });
  });
  var Me = E((mne, bg) => {
    var OL = he(),
      RL = Yi(),
      DL = OL.Object;
    bg.exports = function (e) {
      return DL(RL(e));
    };
  });
  var it = E((gne, xg) => {
    var FL = _e(),
      LL = Me(),
      qL = FL({}.hasOwnProperty);
    xg.exports =
      Object.hasOwn ||
      function (t, r) {
        return qL(LL(t), r);
      };
  });
  var ea = E((vne, Sg) => {
    var kL = _e(),
      NL = 0,
      BL = Math.random(),
      VL = kL((1).toString);
    Sg.exports = function (e) {
      return "Symbol(" + (e === void 0 ? "" : e) + ")_" + VL(++NL + BL, 36);
    };
  });
  var we = E((yne, Pg) => {
    var GL = he(),
      zL = Ro(),
      _g = it(),
      HL = ea(),
      Ig = Ao(),
      Ag = Po(),
      Hr = zL("wks"),
      mr = GL.Symbol,
      Tg = mr && mr.for,
      jL = Ag ? mr : (mr && mr.withoutSetter) || HL;
    Pg.exports = function (e) {
      if (!_g(Hr, e) || !(Ig || typeof Hr[e] == "string")) {
        var t = "Symbol." + e;
        Ig && _g(mr, e)
          ? (Hr[e] = mr[e])
          : Ag && Tg
          ? (Hr[e] = Tg(t))
          : (Hr[e] = jL(t));
      }
      return Hr[e];
    };
  });
  var Og = E((Ene, Mg) => {
    var WL = he(),
      UL = rt(),
      wg = je(),
      Cg = wo(),
      XL = Zt(),
      $L = fg(),
      KL = we(),
      YL = WL.TypeError,
      QL = KL("toPrimitive");
    Mg.exports = function (e, t) {
      if (!wg(e) || Cg(e)) return e;
      var r = XL(e, QL),
        n;
      if (r) {
        if (
          (t === void 0 && (t = "default"), (n = UL(r, e, t)), !wg(n) || Cg(n))
        )
          return n;
        throw YL("Can't convert object to primitive value");
      }
      return t === void 0 && (t = "number"), $L(e, t);
    };
  });
  var kn = E((bne, Rg) => {
    var ZL = Og(),
      JL = wo();
    Rg.exports = function (e) {
      var t = ZL(e, "string");
      return JL(t) ? t : t + "";
    };
  });
  var ta = E((xne, Fg) => {
    var eq = he(),
      Dg = je(),
      Do = eq.document,
      tq = Dg(Do) && Dg(Do.createElement);
    Fg.exports = function (e) {
      return tq ? Do.createElement(e) : {};
    };
  });
  var Fo = E((Sne, Lg) => {
    var rq = mt(),
      nq = Fe(),
      iq = ta();
    Lg.exports =
      !rq &&
      !nq(function () {
        return (
          Object.defineProperty(iq("div"), "a", {
            get: function () {
              return 7;
            },
          }).a != 7
        );
      });
  });
  var ra = E((kg) => {
    var aq = mt(),
      sq = rt(),
      oq = Nm(),
      lq = Fn(),
      uq = Tt(),
      cq = kn(),
      hq = it(),
      fq = Fo(),
      qg = Object.getOwnPropertyDescriptor;
    kg.f = aq
      ? qg
      : function (t, r) {
          if (((t = uq(t)), (r = cq(r)), fq))
            try {
              return qg(t, r);
            } catch {}
          if (hq(t, r)) return lq(!sq(oq.f, t, r), t[r]);
        };
  });
  var Be = E((Ine, Bg) => {
    var Ng = he(),
      pq = je(),
      dq = Ng.String,
      mq = Ng.TypeError;
    Bg.exports = function (e) {
      if (pq(e)) return e;
      throw mq(dq(e) + " is not an object");
    };
  });
  var at = E((zg) => {
    var gq = he(),
      vq = mt(),
      yq = Fo(),
      Vg = Be(),
      Eq = kn(),
      bq = gq.TypeError,
      Gg = Object.defineProperty;
    zg.f = vq
      ? Gg
      : function (t, r, n) {
          if ((Vg(t), (r = Eq(r)), Vg(n), yq))
            try {
              return Gg(t, r, n);
            } catch {}
          if ("get" in n || "set" in n) throw bq("Accessors not supported");
          return "value" in n && (t[r] = n.value), t;
        };
  });
  var Nn = E((Ane, Hg) => {
    var xq = mt(),
      Sq = at(),
      _q = Fn();
    Hg.exports = xq
      ? function (e, t, r) {
          return Sq.f(e, t, _q(1, r));
        }
      : function (e, t, r) {
          return (e[t] = r), e;
        };
  });
  var Bn = E((Pne, jg) => {
    var Iq = _e(),
      Tq = Pe(),
      Lo = qn(),
      Aq = Iq(Function.toString);
    Tq(Lo.inspectSource) ||
      (Lo.inspectSource = function (e) {
        return Aq(e);
      });
    jg.exports = Lo.inspectSource;
  });
  var Xg = E((wne, Ug) => {
    var Pq = he(),
      wq = Pe(),
      Cq = Bn(),
      Wg = Pq.WeakMap;
    Ug.exports = wq(Wg) && /native code/.test(Cq(Wg));
  });
  var na = E((Cne, Kg) => {
    var Mq = Ro(),
      Oq = ea(),
      $g = Mq("keys");
    Kg.exports = function (e) {
      return $g[e] || ($g[e] = Oq(e));
    };
  });
  var Vn = E((Mne, Yg) => {
    Yg.exports = {};
  });
  var vr = E((One, tv) => {
    var Rq = Xg(),
      ev = he(),
      qo = _e(),
      Dq = je(),
      Fq = Nn(),
      ko = it(),
      No = qn(),
      Lq = na(),
      qq = Vn(),
      Qg = "Object already initialized",
      Vo = ev.TypeError,
      kq = ev.WeakMap,
      ia,
      Gn,
      aa,
      Nq = function (e) {
        return aa(e) ? Gn(e) : ia(e, {});
      },
      Bq = function (e) {
        return function (t) {
          var r;
          if (!Dq(t) || (r = Gn(t)).type !== e)
            throw Vo("Incompatible receiver, " + e + " required");
          return r;
        };
      };
    Rq || No.state
      ? ((Jt = No.state || (No.state = new kq())),
        (Zg = qo(Jt.get)),
        (Bo = qo(Jt.has)),
        (Jg = qo(Jt.set)),
        (ia = function (e, t) {
          if (Bo(Jt, e)) throw new Vo(Qg);
          return (t.facade = e), Jg(Jt, e, t), t;
        }),
        (Gn = function (e) {
          return Zg(Jt, e) || {};
        }),
        (aa = function (e) {
          return Bo(Jt, e);
        }))
      : ((gr = Lq("state")),
        (qq[gr] = !0),
        (ia = function (e, t) {
          if (ko(e, gr)) throw new Vo(Qg);
          return (t.facade = e), Fq(e, gr, t), t;
        }),
        (Gn = function (e) {
          return ko(e, gr) ? e[gr] : {};
        }),
        (aa = function (e) {
          return ko(e, gr);
        }));
    var Jt, Zg, Bo, Jg, gr;
    tv.exports = { set: ia, get: Gn, has: aa, enforce: Nq, getterFor: Bq };
  });
  var Ho = E((Rne, nv) => {
    var Go = mt(),
      Vq = it(),
      rv = Function.prototype,
      Gq = Go && Object.getOwnPropertyDescriptor,
      zo = Vq(rv, "name"),
      zq = zo && function () {}.name === "something",
      Hq = zo && (!Go || (Go && Gq(rv, "name").configurable));
    nv.exports = { EXISTS: zo, PROPER: zq, CONFIGURABLE: Hq };
  });
  var Lt = E((Dne, ov) => {
    var jq = he(),
      iv = Pe(),
      Wq = it(),
      av = Nn(),
      Uq = Ji(),
      Xq = Bn(),
      sv = vr(),
      $q = Ho().CONFIGURABLE,
      Kq = sv.get,
      Yq = sv.enforce,
      Qq = String(String).split("String");
    (ov.exports = function (e, t, r, n) {
      var i = n ? !!n.unsafe : !1,
        a = n ? !!n.enumerable : !1,
        o = n ? !!n.noTargetGet : !1,
        s = n && n.name !== void 0 ? n.name : t,
        l;
      if (
        (iv(r) &&
          (String(s).slice(0, 7) === "Symbol(" &&
            (s = "[" + String(s).replace(/^Symbol\(([^)]*)\)/, "$1") + "]"),
          (!Wq(r, "name") || ($q && r.name !== s)) && av(r, "name", s),
          (l = Yq(r)),
          l.source || (l.source = Qq.join(typeof s == "string" ? s : ""))),
        e === jq)
      ) {
        a ? (e[t] = r) : Uq(t, r);
        return;
      } else i ? !o && e[t] && (a = !0) : delete e[t];
      a ? (e[t] = r) : av(e, t, r);
    })(Function.prototype, "toString", function () {
      return (iv(this) && Kq(this).source) || Xq(this);
    });
  });
  var er = E((Fne, lv) => {
    var Zq = Math.ceil,
      Jq = Math.floor;
    lv.exports = function (e) {
      var t = +e;
      return t !== t || t === 0 ? 0 : (t > 0 ? Jq : Zq)(t);
    };
  });
  var jr = E((Lne, uv) => {
    var ek = er(),
      tk = Math.max,
      rk = Math.min;
    uv.exports = function (e, t) {
      var r = ek(e);
      return r < 0 ? tk(r + t, 0) : rk(r, t);
    };
  });
  var hv = E((qne, cv) => {
    var nk = er(),
      ik = Math.min;
    cv.exports = function (e) {
      return e > 0 ? ik(nk(e), 9007199254740991) : 0;
    };
  });
  var Te = E((kne, fv) => {
    var ak = hv();
    fv.exports = function (e) {
      return ak(e.length);
    };
  });
  var sa = E((Nne, dv) => {
    var sk = Tt(),
      ok = jr(),
      lk = Te(),
      pv = function (e) {
        return function (t, r, n) {
          var i = sk(t),
            a = lk(i),
            o = ok(n, a),
            s;
          if (e && r != r) {
            for (; a > o; ) if (((s = i[o++]), s != s)) return !0;
          } else
            for (; a > o; o++)
              if ((e || o in i) && i[o] === r) return e || o || 0;
          return !e && -1;
        };
      };
    dv.exports = { includes: pv(!0), indexOf: pv(!1) };
  });
  var Wo = E((Bne, gv) => {
    var uk = _e(),
      jo = it(),
      ck = Tt(),
      hk = sa().indexOf,
      fk = Vn(),
      mv = uk([].push);
    gv.exports = function (e, t) {
      var r = ck(e),
        n = 0,
        i = [],
        a;
      for (a in r) !jo(fk, a) && jo(r, a) && mv(i, a);
      for (; t.length > n; ) jo(r, (a = t[n++])) && (~hk(i, a) || mv(i, a));
      return i;
    };
  });
  var oa = E((Vne, vv) => {
    vv.exports = [
      "constructor",
      "hasOwnProperty",
      "isPrototypeOf",
      "propertyIsEnumerable",
      "toLocaleString",
      "toString",
      "valueOf",
    ];
  });
  var la = E((yv) => {
    var pk = Wo(),
      dk = oa(),
      mk = dk.concat("length", "prototype");
    yv.f =
      Object.getOwnPropertyNames ||
      function (t) {
        return pk(t, mk);
      };
  });
  var bv = E((Ev) => {
    Ev.f = Object.getOwnPropertySymbols;
  });
  var Sv = E((Hne, xv) => {
    var gk = nt(),
      vk = _e(),
      yk = la(),
      Ek = bv(),
      bk = Be(),
      xk = vk([].concat);
    xv.exports =
      gk("Reflect", "ownKeys") ||
      function (t) {
        var r = yk.f(bk(t)),
          n = Ek.f;
        return n ? xk(r, n(t)) : r;
      };
  });
  var Iv = E((jne, _v) => {
    var Sk = it(),
      _k = Sv(),
      Ik = ra(),
      Tk = at();
    _v.exports = function (e, t) {
      for (var r = _k(t), n = Tk.f, i = Ik.f, a = 0; a < r.length; a++) {
        var o = r[a];
        Sk(e, o) || n(e, o, i(t, o));
      }
    };
  });
  var ua = E((Wne, Tv) => {
    var Ak = Fe(),
      Pk = Pe(),
      wk = /#|\.prototype\./,
      zn = function (e, t) {
        var r = Mk[Ck(e)];
        return r == Rk ? !0 : r == Ok ? !1 : Pk(t) ? Ak(t) : !!t;
      },
      Ck = (zn.normalize = function (e) {
        return String(e).replace(wk, ".").toLowerCase();
      }),
      Mk = (zn.data = {}),
      Ok = (zn.NATIVE = "N"),
      Rk = (zn.POLYFILL = "P");
    Tv.exports = zn;
  });
  var pe = E((Une, Av) => {
    var Uo = he(),
      Dk = ra().f,
      Fk = Nn(),
      Lk = Lt(),
      qk = Ji(),
      kk = Iv(),
      Nk = ua();
    Av.exports = function (e, t) {
      var r = e.target,
        n = e.global,
        i = e.stat,
        a,
        o,
        s,
        l,
        f,
        u;
      if (
        (n
          ? (o = Uo)
          : i
          ? (o = Uo[r] || qk(r, {}))
          : (o = (Uo[r] || {}).prototype),
        o)
      )
        for (s in t) {
          if (
            ((f = t[s]),
            e.noTargetGet ? ((u = Dk(o, s)), (l = u && u.value)) : (l = o[s]),
            (a = Nk(n ? s : r + (i ? "." : "#") + s, e.forced)),
            !a && l !== void 0)
          ) {
            if (typeof f == typeof l) continue;
            kk(f, l);
          }
          (e.sham || (l && l.sham)) && Fk(f, "sham", !0), Lk(o, s, f, e);
        }
    };
  });
  var yt = E((Xne, Cv) => {
    var Pv = _e(),
      Bk = vt(),
      wv = Pv(Pv.bind);
    Cv.exports = function (e, t) {
      return (
        Bk(e),
        t === void 0
          ? e
          : wv
          ? wv(e, t)
          : function () {
              return e.apply(t, arguments);
            }
      );
    };
  });
  var Xo = E(($ne, Ov) => {
    var Vk = rt(),
      Mv = Be(),
      Gk = Zt();
    Ov.exports = function (e, t, r) {
      var n, i;
      Mv(e);
      try {
        if (((n = Gk(e, "return")), !n)) {
          if (t === "throw") throw r;
          return r;
        }
        n = Vk(n, e);
      } catch (a) {
        (i = !0), (n = a);
      }
      if (t === "throw") throw r;
      if (i) throw n;
      return Mv(n), r;
    };
  });
  var Dv = E((Kne, Rv) => {
    var zk = Be(),
      Hk = Xo();
    Rv.exports = function (e, t, r, n) {
      try {
        return n ? t(zk(r)[0], r[1]) : t(r);
      } catch (i) {
        Hk(e, "throw", i);
      }
    };
  });
  var Wr = E((Yne, Fv) => {
    Fv.exports = {};
  });
  var $o = E((Qne, Lv) => {
    var jk = we(),
      Wk = Wr(),
      Uk = jk("iterator"),
      Xk = Array.prototype;
    Lv.exports = function (e) {
      return e !== void 0 && (Wk.Array === e || Xk[Uk] === e);
    };
  });
  var ca = E((Zne, kv) => {
    var $k = we(),
      Kk = $k("toStringTag"),
      qv = {};
    qv[Kk] = "z";
    kv.exports = String(qv) === "[object z]";
  });
  var Hn = E((Jne, Nv) => {
    var Yk = he(),
      Qk = ca(),
      Zk = Pe(),
      ha = Gr(),
      Jk = we(),
      eN = Jk("toStringTag"),
      tN = Yk.Object,
      rN =
        ha(
          (function () {
            return arguments;
          })()
        ) == "Arguments",
      nN = function (e, t) {
        try {
          return e[t];
        } catch {}
      };
    Nv.exports = Qk
      ? ha
      : function (e) {
          var t, r, n;
          return e === void 0
            ? "Undefined"
            : e === null
            ? "Null"
            : typeof (r = nN((t = tN(e)), eN)) == "string"
            ? r
            : rN
            ? ha(t)
            : (n = ha(t)) == "Object" && Zk(t.callee)
            ? "Arguments"
            : n;
        };
  });
  var yr = E((eie, zv) => {
    var iN = _e(),
      aN = Fe(),
      Bv = Pe(),
      sN = Hn(),
      oN = nt(),
      lN = Bn(),
      Vv = function () {},
      uN = [],
      Gv = oN("Reflect", "construct"),
      Ko = /^\s*(?:class|function)\b/,
      cN = iN(Ko.exec),
      hN = !Ko.exec(Vv),
      jn = function (e) {
        if (!Bv(e)) return !1;
        try {
          return Gv(Vv, uN, e), !0;
        } catch {
          return !1;
        }
      },
      fN = function (e) {
        if (!Bv(e)) return !1;
        switch (sN(e)) {
          case "AsyncFunction":
          case "GeneratorFunction":
          case "AsyncGeneratorFunction":
            return !1;
        }
        return hN || !!cN(Ko, lN(e));
      };
    zv.exports =
      !Gv ||
      aN(function () {
        var e;
        return (
          jn(jn.call) ||
          !jn(Object) ||
          !jn(function () {
            e = !0;
          }) ||
          e
        );
      })
        ? fN
        : jn;
  });
  var Ur = E((tie, Hv) => {
    "use strict";
    var pN = kn(),
      dN = at(),
      mN = Fn();
    Hv.exports = function (e, t, r) {
      var n = pN(t);
      n in e ? dN.f(e, n, mN(0, r)) : (e[n] = r);
    };
  });
  var Wn = E((rie, Wv) => {
    var gN = Hn(),
      jv = Zt(),
      vN = Wr(),
      yN = we(),
      EN = yN("iterator");
    Wv.exports = function (e) {
      if (e != null) return jv(e, EN) || jv(e, "@@iterator") || vN[gN(e)];
    };
  });
  var Un = E((nie, Uv) => {
    var bN = he(),
      xN = rt(),
      SN = vt(),
      _N = Be(),
      IN = Ln(),
      TN = Wn(),
      AN = bN.TypeError;
    Uv.exports = function (e, t) {
      var r = arguments.length < 2 ? TN(e) : t;
      if (SN(r)) return _N(xN(r, e));
      throw AN(IN(e) + " is not iterable");
    };
  });
  var Yv = E((iie, Kv) => {
    "use strict";
    var PN = he(),
      wN = yt(),
      CN = rt(),
      MN = Me(),
      ON = Dv(),
      RN = $o(),
      DN = yr(),
      FN = Te(),
      Xv = Ur(),
      LN = Un(),
      qN = Wn(),
      $v = PN.Array;
    Kv.exports = function (t) {
      var r = MN(t),
        n = DN(this),
        i = arguments.length,
        a = i > 1 ? arguments[1] : void 0,
        o = a !== void 0;
      o && (a = wN(a, i > 2 ? arguments[2] : void 0));
      var s = qN(r),
        l = 0,
        f,
        u,
        h,
        m,
        d,
        p;
      if (s && !(this == $v && RN(s)))
        for (
          m = LN(r, s), d = m.next, u = n ? new this() : [];
          !(h = CN(d, m)).done;
          l++
        )
          (p = o ? ON(m, a, [h.value, l], !0) : h.value), Xv(u, l, p);
      else
        for (f = FN(r), u = n ? new this(f) : $v(f); f > l; l++)
          (p = o ? a(r[l], l) : r[l]), Xv(u, l, p);
      return (u.length = l), u;
    };
  });
  var fa = E((aie, ey) => {
    var kN = we(),
      Zv = kN("iterator"),
      Jv = !1;
    try {
      (Qv = 0),
        (Yo = {
          next: function () {
            return { done: !!Qv++ };
          },
          return: function () {
            Jv = !0;
          },
        }),
        (Yo[Zv] = function () {
          return this;
        }),
        Array.from(Yo, function () {
          throw 2;
        });
    } catch {}
    var Qv, Yo;
    ey.exports = function (e, t) {
      if (!t && !Jv) return !1;
      var r = !1;
      try {
        var n = {};
        (n[Zv] = function () {
          return {
            next: function () {
              return { done: (r = !0) };
            },
          };
        }),
          e(n);
      } catch {}
      return r;
    };
  });
  var ty = E(() => {
    var NN = pe(),
      BN = Yv(),
      VN = fa(),
      GN = !VN(function (e) {
        Array.from(e);
      });
    NN({ target: "Array", stat: !0, forced: GN }, { from: BN });
  });
  var tr = E((lie, ry) => {
    var zN = Gr();
    ry.exports =
      Array.isArray ||
      function (t) {
        return zN(t) == "Array";
      };
  });
  var ny = E(() => {
    var HN = pe(),
      jN = tr();
    HN({ target: "Array", stat: !0 }, { isArray: jN });
  });
  var ay = E(() => {
    "use strict";
    var WN = pe(),
      UN = he(),
      XN = Fe(),
      $N = yr(),
      KN = Ur(),
      iy = UN.Array,
      YN = XN(function () {
        function e() {}
        return !(iy.of.call(e) instanceof e);
      });
    WN(
      { target: "Array", stat: !0, forced: YN },
      {
        of: function () {
          for (
            var t = 0, r = arguments.length, n = new ($N(this) ? this : iy)(r);
            r > t;

          )
            KN(n, t, arguments[t++]);
          return (n.length = r), n;
        },
      }
    );
  });
  var oy = E((pie, sy) => {
    var QN = Wo(),
      ZN = oa();
    sy.exports =
      Object.keys ||
      function (t) {
        return QN(t, ZN);
      };
  });
  var uy = E((die, ly) => {
    var JN = mt(),
      eB = at(),
      tB = Be(),
      rB = Tt(),
      nB = oy();
    ly.exports = JN
      ? Object.defineProperties
      : function (t, r) {
          tB(t);
          for (var n = rB(r), i = nB(r), a = i.length, o = 0, s; a > o; )
            eB.f(t, (s = i[o++]), n[s]);
          return t;
        };
  });
  var Qo = E((mie, cy) => {
    var iB = nt();
    cy.exports = iB("document", "documentElement");
  });
  var rr = E((gie, vy) => {
    var aB = Be(),
      sB = uy(),
      hy = oa(),
      oB = Vn(),
      lB = Qo(),
      uB = ta(),
      cB = na(),
      fy = ">",
      py = "<",
      Jo = "prototype",
      el = "script",
      my = cB("IE_PROTO"),
      Zo = function () {},
      gy = function (e) {
        return py + el + fy + e + py + "/" + el + fy;
      },
      dy = function (e) {
        e.write(gy("")), e.close();
        var t = e.parentWindow.Object;
        return (e = null), t;
      },
      hB = function () {
        var e = uB("iframe"),
          t = "java" + el + ":",
          r;
        return (
          (e.style.display = "none"),
          lB.appendChild(e),
          (e.src = String(t)),
          (r = e.contentWindow.document),
          r.open(),
          r.write(gy("document.F=Object")),
          r.close(),
          r.F
        );
      },
      pa,
      da = function () {
        try {
          pa = new ActiveXObject("htmlfile");
        } catch {}
        da =
          typeof document < "u"
            ? document.domain && pa
              ? dy(pa)
              : hB()
            : dy(pa);
        for (var e = hy.length; e--; ) delete da[Jo][hy[e]];
        return da();
      };
    oB[my] = !0;
    vy.exports =
      Object.create ||
      function (t, r) {
        var n;
        return (
          t !== null
            ? ((Zo[Jo] = aB(t)), (n = new Zo()), (Zo[Jo] = null), (n[my] = t))
            : (n = da()),
          r === void 0 ? n : sB(n, r)
        );
      };
  });
  var De = E((vie, yy) => {
    var fB = we(),
      pB = rr(),
      dB = at(),
      tl = fB("unscopables"),
      rl = Array.prototype;
    rl[tl] == null && dB.f(rl, tl, { configurable: !0, value: pB(null) });
    yy.exports = function (e) {
      rl[tl][e] = !0;
    };
  });
  var nl = E(() => {
    "use strict";
    var mB = pe(),
      gB = Me(),
      vB = Te(),
      yB = er(),
      EB = De();
    mB(
      { target: "Array", proto: !0 },
      {
        at: function (t) {
          var r = gB(this),
            n = vB(r),
            i = yB(t),
            a = i >= 0 ? i : n + i;
          return a < 0 || a >= n ? void 0 : r[a];
        },
      }
    );
    EB("at");
  });
  var il = E((bie, xy) => {
    var bB = he(),
      Ey = tr(),
      xB = yr(),
      SB = je(),
      _B = we(),
      IB = _B("species"),
      by = bB.Array;
    xy.exports = function (e) {
      var t;
      return (
        Ey(e) &&
          ((t = e.constructor),
          xB(t) && (t === by || Ey(t.prototype))
            ? (t = void 0)
            : SB(t) && ((t = t[IB]), t === null && (t = void 0))),
        t === void 0 ? by : t
      );
    };
  });
  var Er = E((xie, Sy) => {
    var TB = il();
    Sy.exports = function (e, t) {
      return new (TB(e))(t === 0 ? 0 : t);
    };
  });
  var Xr = E((Sie, _y) => {
    var AB = Fe(),
      PB = we(),
      wB = Qt(),
      CB = PB("species");
    _y.exports = function (e) {
      return (
        wB >= 51 ||
        !AB(function () {
          var t = [],
            r = (t.constructor = {});
          return (
            (r[CB] = function () {
              return { foo: 1 };
            }),
            t[e](Boolean).foo !== 1
          );
        })
      );
    };
  });
  var Cy = E(() => {
    "use strict";
    var MB = pe(),
      OB = he(),
      RB = Fe(),
      DB = tr(),
      FB = je(),
      LB = Me(),
      qB = Te(),
      Iy = Ur(),
      kB = Er(),
      NB = Xr(),
      BB = we(),
      VB = Qt(),
      wy = BB("isConcatSpreadable"),
      Ty = 9007199254740991,
      Ay = "Maximum allowed index exceeded",
      Py = OB.TypeError,
      GB =
        VB >= 51 ||
        !RB(function () {
          var e = [];
          return (e[wy] = !1), e.concat()[0] !== e;
        }),
      zB = NB("concat"),
      HB = function (e) {
        if (!FB(e)) return !1;
        var t = e[wy];
        return t !== void 0 ? !!t : DB(e);
      },
      jB = !GB || !zB;
    MB(
      { target: "Array", proto: !0, forced: jB },
      {
        concat: function (t) {
          var r = LB(this),
            n = kB(r, 0),
            i = 0,
            a,
            o,
            s,
            l,
            f;
          for (a = -1, s = arguments.length; a < s; a++)
            if (((f = a === -1 ? r : arguments[a]), HB(f))) {
              if (((l = qB(f)), i + l > Ty)) throw Py(Ay);
              for (o = 0; o < l; o++, i++) o in f && Iy(n, i, f[o]);
            } else {
              if (i >= Ty) throw Py(Ay);
              Iy(n, i++, f);
            }
          return (n.length = i), n;
        },
      }
    );
  });
  var Oy = E((Tie, My) => {
    "use strict";
    var WB = Me(),
      al = jr(),
      UB = Te(),
      XB = Math.min;
    My.exports =
      [].copyWithin ||
      function (t, r) {
        var n = WB(this),
          i = UB(n),
          a = al(t, i),
          o = al(r, i),
          s = arguments.length > 2 ? arguments[2] : void 0,
          l = XB((s === void 0 ? i : al(s, i)) - o, i - a),
          f = 1;
        for (
          o < a && a < o + l && ((f = -1), (o += l - 1), (a += l - 1));
          l-- > 0;

        )
          o in n ? (n[a] = n[o]) : delete n[a], (a += f), (o += f);
        return n;
      };
  });
  var Ry = E(() => {
    var $B = pe(),
      KB = Oy(),
      YB = De();
    $B({ target: "Array", proto: !0 }, { copyWithin: KB });
    YB("copyWithin");
  });
  var At = E((wie, Fy) => {
    var QB = yt(),
      ZB = _e(),
      JB = dr(),
      eV = Me(),
      tV = Te(),
      rV = Er(),
      Dy = ZB([].push),
      nr = function (e) {
        var t = e == 1,
          r = e == 2,
          n = e == 3,
          i = e == 4,
          a = e == 6,
          o = e == 7,
          s = e == 5 || a;
        return function (l, f, u, h) {
          for (
            var m = eV(l),
              d = JB(m),
              p = QB(f, u),
              g = tV(d),
              c = 0,
              v = h || rV,
              y = t ? v(l, g) : r || o ? v(l, 0) : void 0,
              b,
              x;
            g > c;
            c++
          )
            if ((s || c in d) && ((b = d[c]), (x = p(b, c, m)), e))
              if (t) y[c] = x;
              else if (x)
                switch (e) {
                  case 3:
                    return !0;
                  case 5:
                    return b;
                  case 6:
                    return c;
                  case 2:
                    Dy(y, b);
                }
              else
                switch (e) {
                  case 4:
                    return !1;
                  case 7:
                    Dy(y, b);
                }
          return a ? -1 : n || i ? i : y;
        };
      };
    Fy.exports = {
      forEach: nr(0),
      map: nr(1),
      filter: nr(2),
      some: nr(3),
      every: nr(4),
      find: nr(5),
      findIndex: nr(6),
      filterReject: nr(7),
    };
  });
  var Pt = E((Cie, Ly) => {
    "use strict";
    var nV = Fe();
    Ly.exports = function (e, t) {
      var r = [][e];
      return (
        !!r &&
        nV(function () {
          r.call(
            null,
            t ||
              function () {
                throw 1;
              },
            1
          );
        })
      );
    };
  });
  var qy = E(() => {
    "use strict";
    var iV = pe(),
      aV = At().every,
      sV = Pt(),
      oV = sV("every");
    iV(
      { target: "Array", proto: !0, forced: !oV },
      {
        every: function (t) {
          return aV(this, t, arguments.length > 1 ? arguments[1] : void 0);
        },
      }
    );
  });
  var By = E((Rie, Ny) => {
    "use strict";
    var lV = Me(),
      ky = jr(),
      uV = Te();
    Ny.exports = function (t) {
      for (
        var r = lV(this),
          n = uV(r),
          i = arguments.length,
          a = ky(i > 1 ? arguments[1] : void 0, n),
          o = i > 2 ? arguments[2] : void 0,
          s = o === void 0 ? n : ky(o, n);
        s > a;

      )
        r[a++] = t;
      return r;
    };
  });
  var Vy = E(() => {
    var cV = pe(),
      hV = By(),
      fV = De();
    cV({ target: "Array", proto: !0 }, { fill: hV });
    fV("fill");
  });
  var Gy = E(() => {
    "use strict";
    var pV = pe(),
      dV = At().filter,
      mV = Xr(),
      gV = mV("filter");
    pV(
      { target: "Array", proto: !0, forced: !gV },
      {
        filter: function (t) {
          return dV(this, t, arguments.length > 1 ? arguments[1] : void 0);
        },
      }
    );
  });
  var Hy = E(() => {
    "use strict";
    var vV = pe(),
      yV = At().find,
      EV = De(),
      sl = "find",
      zy = !0;
    sl in [] &&
      Array(1)[sl](function () {
        zy = !1;
      });
    vV(
      { target: "Array", proto: !0, forced: zy },
      {
        find: function (t) {
          return yV(this, t, arguments.length > 1 ? arguments[1] : void 0);
        },
      }
    );
    EV(sl);
  });
  var Wy = E(() => {
    "use strict";
    var bV = pe(),
      xV = At().findIndex,
      SV = De(),
      ol = "findIndex",
      jy = !0;
    ol in [] &&
      Array(1)[ol](function () {
        jy = !1;
      });
    bV(
      { target: "Array", proto: !0, forced: jy },
      {
        findIndex: function (t) {
          return xV(this, t, arguments.length > 1 ? arguments[1] : void 0);
        },
      }
    );
    SV(ol);
  });
  var ll = E((Gie, Xy) => {
    "use strict";
    var _V = he(),
      IV = tr(),
      TV = Te(),
      AV = yt(),
      PV = _V.TypeError,
      Uy = function (e, t, r, n, i, a, o, s) {
        for (var l = i, f = 0, u = o ? AV(o, s) : !1, h, m; f < n; ) {
          if (f in r) {
            if (((h = u ? u(r[f], f, t) : r[f]), a > 0 && IV(h)))
              (m = TV(h)), (l = Uy(e, t, h, m, l, a - 1) - 1);
            else {
              if (l >= 9007199254740991)
                throw PV("Exceed the acceptable array length");
              e[l] = h;
            }
            l++;
          }
          f++;
        }
        return l;
      };
    Xy.exports = Uy;
  });
  var $y = E(() => {
    "use strict";
    var wV = pe(),
      CV = ll(),
      MV = Me(),
      OV = Te(),
      RV = er(),
      DV = Er();
    wV(
      { target: "Array", proto: !0 },
      {
        flat: function () {
          var t = arguments.length ? arguments[0] : void 0,
            r = MV(this),
            n = OV(r),
            i = DV(r, 0);
          return (i.length = CV(i, r, r, n, 0, t === void 0 ? 1 : RV(t))), i;
        },
      }
    );
  });
  var Ky = E(() => {
    "use strict";
    var FV = pe(),
      LV = ll(),
      qV = vt(),
      kV = Me(),
      NV = Te(),
      BV = Er();
    FV(
      { target: "Array", proto: !0 },
      {
        flatMap: function (t) {
          var r = kV(this),
            n = NV(r),
            i;
          return (
            qV(t),
            (i = BV(r, 0)),
            (i.length = LV(
              i,
              r,
              r,
              n,
              0,
              1,
              t,
              arguments.length > 1 ? arguments[1] : void 0
            )),
            i
          );
        },
      }
    );
  });
  var Qy = E((Uie, Yy) => {
    "use strict";
    var VV = At().forEach,
      GV = Pt(),
      zV = GV("forEach");
    Yy.exports = zV
      ? [].forEach
      : function (t) {
          return VV(this, t, arguments.length > 1 ? arguments[1] : void 0);
        };
  });
  var Jy = E(() => {
    "use strict";
    var HV = pe(),
      Zy = Qy();
    HV(
      { target: "Array", proto: !0, forced: [].forEach != Zy },
      { forEach: Zy }
    );
  });
  var e0 = E(() => {
    "use strict";
    var jV = pe(),
      WV = sa().includes,
      UV = De();
    jV(
      { target: "Array", proto: !0 },
      {
        includes: function (t) {
          return WV(this, t, arguments.length > 1 ? arguments[1] : void 0);
        },
      }
    );
    UV("includes");
  });
  var r0 = E(() => {
    "use strict";
    var XV = pe(),
      $V = _e(),
      KV = sa().indexOf,
      YV = Pt(),
      ul = $V([].indexOf),
      t0 = !!ul && 1 / ul([1], 1, -0) < 0,
      QV = YV("indexOf");
    XV(
      { target: "Array", proto: !0, forced: t0 || !QV },
      {
        indexOf: function (t) {
          var r = arguments.length > 1 ? arguments[1] : void 0;
          return t0 ? ul(this, t, r) || 0 : KV(this, t, r);
        },
      }
    );
  });
  var i0 = E((Jie, n0) => {
    var ZV = Fe();
    n0.exports = !ZV(function () {
      function e() {}
      return (
        (e.prototype.constructor = null),
        Object.getPrototypeOf(new e()) !== e.prototype
      );
    });
  });
  var ma = E((eae, s0) => {
    var JV = he(),
      e3 = it(),
      t3 = Pe(),
      r3 = Me(),
      n3 = na(),
      i3 = i0(),
      a0 = n3("IE_PROTO"),
      cl = JV.Object,
      a3 = cl.prototype;
    s0.exports = i3
      ? cl.getPrototypeOf
      : function (e) {
          var t = r3(e);
          if (e3(t, a0)) return t[a0];
          var r = t.constructor;
          return t3(r) && t instanceof r
            ? r.prototype
            : t instanceof cl
            ? a3
            : null;
        };
  });
  var dl = E((tae, u0) => {
    "use strict";
    var s3 = Fe(),
      o3 = Pe(),
      l3 = rr(),
      o0 = ma(),
      u3 = Lt(),
      c3 = we(),
      h3 = zr(),
      pl = c3("iterator"),
      l0 = !1,
      qt,
      hl,
      fl;
    [].keys &&
      ((fl = [].keys()),
      "next" in fl
        ? ((hl = o0(o0(fl))), hl !== Object.prototype && (qt = hl))
        : (l0 = !0));
    var f3 =
      qt == null ||
      s3(function () {
        var e = {};
        return qt[pl].call(e) !== e;
      });
    f3 ? (qt = {}) : h3 && (qt = l3(qt));
    o3(qt[pl]) ||
      u3(qt, pl, function () {
        return this;
      });
    u0.exports = { IteratorPrototype: qt, BUGGY_SAFARI_ITERATORS: l0 };
  });
  var Xn = E((rae, h0) => {
    var p3 = at().f,
      d3 = it(),
      m3 = we(),
      c0 = m3("toStringTag");
    h0.exports = function (e, t, r) {
      e &&
        !d3((e = r ? e : e.prototype), c0) &&
        p3(e, c0, { configurable: !0, value: t });
    };
  });
  var p0 = E((nae, f0) => {
    "use strict";
    var g3 = dl().IteratorPrototype,
      v3 = rr(),
      y3 = Fn(),
      E3 = Xn(),
      b3 = Wr(),
      x3 = function () {
        return this;
      };
    f0.exports = function (e, t, r) {
      var n = t + " Iterator";
      return (
        (e.prototype = v3(g3, { next: y3(1, r) })),
        E3(e, n, !1, !0),
        (b3[n] = x3),
        e
      );
    };
  });
  var g0 = E((iae, m0) => {
    var d0 = he(),
      S3 = Pe(),
      _3 = d0.String,
      I3 = d0.TypeError;
    m0.exports = function (e) {
      if (typeof e == "object" || S3(e)) return e;
      throw I3("Can't set " + _3(e) + " as a prototype");
    };
  });
  var ga = E((aae, v0) => {
    var T3 = _e(),
      A3 = Be(),
      P3 = g0();
    v0.exports =
      Object.setPrototypeOf ||
      ("__proto__" in {}
        ? (function () {
            var e = !1,
              t = {},
              r;
            try {
              (r = T3(
                Object.getOwnPropertyDescriptor(Object.prototype, "__proto__")
                  .set
              )),
                r(t, []),
                (e = t instanceof Array);
            } catch {}
            return function (i, a) {
              return A3(i), P3(a), e ? r(i, a) : (i.__proto__ = a), i;
            };
          })()
        : void 0);
  });
  var Ea = E((sae, P0) => {
    "use strict";
    var w3 = pe(),
      C3 = rt(),
      va = zr(),
      T0 = Ho(),
      M3 = Pe(),
      O3 = p0(),
      y0 = ma(),
      E0 = ga(),
      R3 = Xn(),
      D3 = Nn(),
      ml = Lt(),
      F3 = we(),
      b0 = Wr(),
      A0 = dl(),
      L3 = T0.PROPER,
      q3 = T0.CONFIGURABLE,
      x0 = A0.IteratorPrototype,
      ya = A0.BUGGY_SAFARI_ITERATORS,
      $n = F3("iterator"),
      S0 = "keys",
      Kn = "values",
      _0 = "entries",
      I0 = function () {
        return this;
      };
    P0.exports = function (e, t, r, n, i, a, o) {
      O3(r, t, n);
      var s = function (v) {
          if (v === i && m) return m;
          if (!ya && v in u) return u[v];
          switch (v) {
            case S0:
              return function () {
                return new r(this, v);
              };
            case Kn:
              return function () {
                return new r(this, v);
              };
            case _0:
              return function () {
                return new r(this, v);
              };
          }
          return function () {
            return new r(this);
          };
        },
        l = t + " Iterator",
        f = !1,
        u = e.prototype,
        h = u[$n] || u["@@iterator"] || (i && u[i]),
        m = (!ya && h) || s(i),
        d = (t == "Array" && u.entries) || h,
        p,
        g,
        c;
      if (
        (d &&
          ((p = y0(d.call(new e()))),
          p !== Object.prototype &&
            p.next &&
            (!va &&
              y0(p) !== x0 &&
              (E0 ? E0(p, x0) : M3(p[$n]) || ml(p, $n, I0)),
            R3(p, l, !0, !0),
            va && (b0[l] = I0))),
        L3 &&
          i == Kn &&
          h &&
          h.name !== Kn &&
          (!va && q3
            ? D3(u, "name", Kn)
            : ((f = !0),
              (m = function () {
                return C3(h, this);
              }))),
        i)
      )
        if (((g = { values: s(Kn), keys: a ? m : s(S0), entries: s(_0) }), o))
          for (c in g) (ya || f || !(c in u)) && ml(u, c, g[c]);
        else w3({ target: t, proto: !0, forced: ya || f }, g);
      return (
        (!va || o) && u[$n] !== m && ml(u, $n, m, { name: i }), (b0[t] = m), g
      );
    };
  });
  var R0 = E((oae, O0) => {
    "use strict";
    var k3 = Tt(),
      gl = De(),
      w0 = Wr(),
      C0 = vr(),
      N3 = Ea(),
      M0 = "Array Iterator",
      B3 = C0.set,
      V3 = C0.getterFor(M0);
    O0.exports = N3(
      Array,
      "Array",
      function (e, t) {
        B3(this, { type: M0, target: k3(e), index: 0, kind: t });
      },
      function () {
        var e = V3(this),
          t = e.target,
          r = e.kind,
          n = e.index++;
        return !t || n >= t.length
          ? ((e.target = void 0), { value: void 0, done: !0 })
          : r == "keys"
          ? { value: n, done: !1 }
          : r == "values"
          ? { value: t[n], done: !1 }
          : { value: [n, t[n]], done: !1 };
      },
      "values"
    );
    w0.Arguments = w0.Array;
    gl("keys");
    gl("values");
    gl("entries");
  });
  var D0 = E(() => {
    "use strict";
    var G3 = pe(),
      z3 = _e(),
      H3 = dr(),
      j3 = Tt(),
      W3 = Pt(),
      U3 = z3([].join),
      X3 = H3 != Object,
      $3 = W3("join", ",");
    G3(
      { target: "Array", proto: !0, forced: X3 || !$3 },
      {
        join: function (t) {
          return U3(j3(this), t === void 0 ? "," : t);
        },
      }
    );
  });
  var ba = E((cae, q0) => {
    var vl = Function.prototype,
      F0 = vl.apply,
      K3 = vl.bind,
      L0 = vl.call;
    q0.exports =
      (typeof Reflect == "object" && Reflect.apply) ||
      (K3
        ? L0.bind(F0)
        : function () {
            return L0.apply(F0, arguments);
          });
  });
  var B0 = E((hae, N0) => {
    "use strict";
    var Y3 = ba(),
      Q3 = Tt(),
      Z3 = er(),
      J3 = Te(),
      eG = Pt(),
      tG = Math.min,
      yl = [].lastIndexOf,
      k0 = !!yl && 1 / [1].lastIndexOf(1, -0) < 0,
      rG = eG("lastIndexOf"),
      nG = k0 || !rG;
    N0.exports = nG
      ? function (t) {
          if (k0) return Y3(yl, this, arguments) || 0;
          var r = Q3(this),
            n = J3(r),
            i = n - 1;
          for (
            arguments.length > 1 && (i = tG(i, Z3(arguments[1]))),
              i < 0 && (i = n + i);
            i >= 0;
            i--
          )
            if (i in r && r[i] === t) return i || 0;
          return -1;
        }
      : yl;
  });
  var G0 = E(() => {
    var iG = pe(),
      V0 = B0();
    iG(
      { target: "Array", proto: !0, forced: V0 !== [].lastIndexOf },
      { lastIndexOf: V0 }
    );
  });
  var z0 = E(() => {
    "use strict";
    var aG = pe(),
      sG = At().map,
      oG = Xr(),
      lG = oG("map");
    aG(
      { target: "Array", proto: !0, forced: !lG },
      {
        map: function (t) {
          return sG(this, t, arguments.length > 1 ? arguments[1] : void 0);
        },
      }
    );
  });
  var El = E((gae, j0) => {
    var uG = he(),
      cG = vt(),
      hG = Me(),
      fG = dr(),
      pG = Te(),
      dG = uG.TypeError,
      H0 = function (e) {
        return function (t, r, n, i) {
          cG(r);
          var a = hG(t),
            o = fG(a),
            s = pG(a),
            l = e ? s - 1 : 0,
            f = e ? -1 : 1;
          if (n < 2)
            for (;;) {
              if (l in o) {
                (i = o[l]), (l += f);
                break;
              }
              if (((l += f), e ? l < 0 : s <= l))
                throw dG("Reduce of empty array with no initial value");
            }
          for (; e ? l >= 0 : s > l; l += f) l in o && (i = r(i, o[l], l, a));
          return i;
        };
      };
    j0.exports = { left: H0(!1), right: H0(!0) };
  });
  var $r = E((vae, W0) => {
    var mG = Gr(),
      gG = he();
    W0.exports = mG(gG.process) == "process";
  });
  var X0 = E(() => {
    "use strict";
    var vG = pe(),
      yG = El().left,
      EG = Pt(),
      U0 = Qt(),
      bG = $r(),
      xG = EG("reduce"),
      SG = !bG && U0 > 79 && U0 < 83;
    vG(
      { target: "Array", proto: !0, forced: !xG || SG },
      {
        reduce: function (t) {
          var r = arguments.length;
          return yG(this, t, r, r > 1 ? arguments[1] : void 0);
        },
      }
    );
  });
  var K0 = E(() => {
    "use strict";
    var _G = pe(),
      IG = El().right,
      TG = Pt(),
      $0 = Qt(),
      AG = $r(),
      PG = TG("reduceRight"),
      wG = !AG && $0 > 79 && $0 < 83;
    _G(
      { target: "Array", proto: !0, forced: !PG || wG },
      {
        reduceRight: function (t) {
          return IG(
            this,
            t,
            arguments.length,
            arguments.length > 1 ? arguments[1] : void 0
          );
        },
      }
    );
  });
  var Q0 = E(() => {
    "use strict";
    var CG = pe(),
      MG = _e(),
      OG = tr(),
      RG = MG([].reverse),
      Y0 = [1, 2];
    CG(
      {
        target: "Array",
        proto: !0,
        forced: String(Y0) === String(Y0.reverse()),
      },
      {
        reverse: function () {
          return OG(this) && (this.length = this.length), RG(this);
        },
      }
    );
  });
  var Yn = E((Iae, Z0) => {
    var DG = _e();
    Z0.exports = DG([].slice);
  });
  var tE = E(() => {
    "use strict";
    var FG = pe(),
      LG = he(),
      J0 = tr(),
      qG = yr(),
      kG = je(),
      eE = jr(),
      NG = Te(),
      BG = Tt(),
      VG = Ur(),
      GG = we(),
      zG = Xr(),
      HG = Yn(),
      jG = zG("slice"),
      WG = GG("species"),
      bl = LG.Array,
      UG = Math.max;
    FG(
      { target: "Array", proto: !0, forced: !jG },
      {
        slice: function (t, r) {
          var n = BG(this),
            i = NG(n),
            a = eE(t, i),
            o = eE(r === void 0 ? i : r, i),
            s,
            l,
            f;
          if (
            J0(n) &&
            ((s = n.constructor),
            qG(s) && (s === bl || J0(s.prototype))
              ? (s = void 0)
              : kG(s) && ((s = s[WG]), s === null && (s = void 0)),
            s === bl || s === void 0)
          )
            return HG(n, a, o);
          for (
            l = new (s === void 0 ? bl : s)(UG(o - a, 0)), f = 0;
            a < o;
            a++, f++
          )
            a in n && VG(l, f, n[a]);
          return (l.length = f), l;
        },
      }
    );
  });
  var rE = E(() => {
    "use strict";
    var XG = pe(),
      $G = At().some,
      KG = Pt(),
      YG = KG("some");
    XG(
      { target: "Array", proto: !0, forced: !YG },
      {
        some: function (t) {
          return $G(this, t, arguments.length > 1 ? arguments[1] : void 0);
        },
      }
    );
  });
  var xa = E((Cae, nE) => {
    var QG = he(),
      ZG = Hn(),
      JG = QG.String;
    nE.exports = function (e) {
      if (ZG(e) === "Symbol")
        throw TypeError("Cannot convert a Symbol value to a string");
      return JG(e);
    };
  });
  var sE = E((Mae, aE) => {
    var iE = Yn(),
      e5 = Math.floor,
      xl = function (e, t) {
        var r = e.length,
          n = e5(r / 2);
        return r < 8 ? t5(e, t) : r5(e, xl(iE(e, 0, n), t), xl(iE(e, n), t), t);
      },
      t5 = function (e, t) {
        for (var r = e.length, n = 1, i, a; n < r; ) {
          for (a = n, i = e[n]; a && t(e[a - 1], i) > 0; ) e[a] = e[--a];
          a !== n++ && (e[a] = i);
        }
        return e;
      },
      r5 = function (e, t, r, n) {
        for (var i = t.length, a = r.length, o = 0, s = 0; o < i || s < a; )
          e[o + s] =
            o < i && s < a
              ? n(t[o], r[s]) <= 0
                ? t[o++]
                : r[s++]
              : o < i
              ? t[o++]
              : r[s++];
        return e;
      };
    aE.exports = xl;
  });
  var uE = E((Oae, lE) => {
    var n5 = Yt(),
      oE = n5.match(/firefox\/(\d+)/i);
    lE.exports = !!oE && +oE[1];
  });
  var hE = E((Rae, cE) => {
    var i5 = Yt();
    cE.exports = /MSIE|Trident/.test(i5);
  });
  var dE = E((Dae, pE) => {
    var a5 = Yt(),
      fE = a5.match(/AppleWebKit\/(\d+)\./);
    pE.exports = !!fE && +fE[1];
  });
  var SE = E(() => {
    "use strict";
    var s5 = pe(),
      bE = _e(),
      o5 = vt(),
      l5 = Me(),
      u5 = Te(),
      mE = xa(),
      Sl = Fe(),
      c5 = sE(),
      h5 = Pt(),
      gE = uE(),
      f5 = hE(),
      vE = Qt(),
      yE = dE(),
      ir = [],
      EE = bE(ir.sort),
      p5 = bE(ir.push),
      d5 = Sl(function () {
        ir.sort(void 0);
      }),
      m5 = Sl(function () {
        ir.sort(null);
      }),
      g5 = h5("sort"),
      xE = !Sl(function () {
        if (vE) return vE < 70;
        if (!(gE && gE > 3)) {
          if (f5) return !0;
          if (yE) return yE < 603;
          var e = "",
            t,
            r,
            n,
            i;
          for (t = 65; t < 76; t++) {
            switch (((r = String.fromCharCode(t)), t)) {
              case 66:
              case 69:
              case 70:
              case 72:
                n = 3;
                break;
              case 68:
              case 71:
                n = 4;
                break;
              default:
                n = 2;
            }
            for (i = 0; i < 47; i++) ir.push({ k: r + i, v: n });
          }
          for (
            ir.sort(function (a, o) {
              return o.v - a.v;
            }),
              i = 0;
            i < ir.length;
            i++
          )
            (r = ir[i].k.charAt(0)), e.charAt(e.length - 1) !== r && (e += r);
          return e !== "DGBEFHACIJK";
        }
      }),
      v5 = d5 || !m5 || !g5 || !xE,
      y5 = function (e) {
        return function (t, r) {
          return r === void 0
            ? -1
            : t === void 0
            ? 1
            : e !== void 0
            ? +e(t, r) || 0
            : mE(t) > mE(r)
            ? 1
            : -1;
        };
      };
    s5(
      { target: "Array", proto: !0, forced: v5 },
      {
        sort: function (t) {
          t !== void 0 && o5(t);
          var r = l5(this);
          if (xE) return t === void 0 ? EE(r) : EE(r, t);
          var n = [],
            i = u5(r),
            a,
            o;
          for (o = 0; o < i; o++) o in r && p5(n, r[o]);
          for (c5(n, y5(t)), a = n.length, o = 0; o < a; ) r[o] = n[o++];
          for (; o < i; ) delete r[o++];
          return r;
        },
      }
    );
  });
  var Sa = E((qae, IE) => {
    "use strict";
    var E5 = nt(),
      b5 = at(),
      x5 = we(),
      S5 = mt(),
      _E = x5("species");
    IE.exports = function (e) {
      var t = E5(e),
        r = b5.f;
      S5 &&
        t &&
        !t[_E] &&
        r(t, _E, {
          configurable: !0,
          get: function () {
            return this;
          },
        });
    };
  });
  var TE = E(() => {
    var _5 = Sa();
    _5("Array");
  });
  var AE = E(() => {
    "use strict";
    var I5 = pe(),
      T5 = he(),
      A5 = jr(),
      P5 = er(),
      w5 = Te(),
      C5 = Me(),
      M5 = Er(),
      O5 = Ur(),
      R5 = Xr(),
      D5 = R5("splice"),
      F5 = T5.TypeError,
      L5 = Math.max,
      q5 = Math.min,
      k5 = 9007199254740991,
      N5 = "Maximum allowed length exceeded";
    I5(
      { target: "Array", proto: !0, forced: !D5 },
      {
        splice: function (t, r) {
          var n = C5(this),
            i = w5(n),
            a = A5(t, i),
            o = arguments.length,
            s,
            l,
            f,
            u,
            h,
            m;
          if (
            (o === 0
              ? (s = l = 0)
              : o === 1
              ? ((s = 0), (l = i - a))
              : ((s = o - 2), (l = q5(L5(P5(r), 0), i - a))),
            i + s - l > k5)
          )
            throw F5(N5);
          for (f = M5(n, l), u = 0; u < l; u++)
            (h = a + u), h in n && O5(f, u, n[h]);
          if (((f.length = l), s < l)) {
            for (u = a; u < i - l; u++)
              (h = u + l), (m = u + s), h in n ? (n[m] = n[h]) : delete n[m];
            for (u = i; u > i - l + s; u--) delete n[u - 1];
          } else if (s > l)
            for (u = i - l; u > a; u--)
              (h = u + l - 1),
                (m = u + s - 1),
                h in n ? (n[m] = n[h]) : delete n[m];
          for (u = 0; u < s; u++) n[u + a] = arguments[u + 2];
          return (n.length = i - l + s), f;
        },
      }
    );
  });
  var PE = E(() => {
    var B5 = De();
    B5("flat");
  });
  var wE = E(() => {
    var V5 = De();
    V5("flatMap");
  });
  var ME = E((Wae, CE) => {
    "use strict";
    var G5 = ca(),
      z5 = Hn();
    CE.exports = G5
      ? {}.toString
      : function () {
          return "[object " + z5(this) + "]";
        };
  });
  var OE = E(() => {
    var H5 = ca(),
      j5 = Lt(),
      W5 = ME();
    H5 || j5(Object.prototype, "toString", W5, { unsafe: !0 });
  });
  var LE = E(($ae, FE) => {
    var _l = _e(),
      U5 = er(),
      X5 = xa(),
      $5 = Yi(),
      K5 = _l("".charAt),
      RE = _l("".charCodeAt),
      Y5 = _l("".slice),
      DE = function (e) {
        return function (t, r) {
          var n = X5($5(t)),
            i = U5(r),
            a = n.length,
            o,
            s;
          return i < 0 || i >= a
            ? e
              ? ""
              : void 0
            : ((o = RE(n, i)),
              o < 55296 ||
              o > 56319 ||
              i + 1 === a ||
              (s = RE(n, i + 1)) < 56320 ||
              s > 57343
                ? e
                  ? K5(n, i)
                  : o
                : e
                ? Y5(n, i, i + 2)
                : ((o - 55296) << 10) + (s - 56320) + 65536);
        };
      };
    FE.exports = { codeAt: DE(!1), charAt: DE(!0) };
  });
  var NE = E(() => {
    "use strict";
    var Q5 = LE().charAt,
      Z5 = xa(),
      qE = vr(),
      J5 = Ea(),
      kE = "String Iterator",
      ez = qE.set,
      tz = qE.getterFor(kE);
    J5(
      String,
      "String",
      function (e) {
        ez(this, { type: kE, string: Z5(e), index: 0 });
      },
      function () {
        var t = tz(this),
          r = t.string,
          n = t.index,
          i;
        return n >= r.length
          ? { value: void 0, done: !0 }
          : ((i = Q5(r, n)), (t.index += i.length), { value: i, done: !1 });
      }
    );
  });
  var VE = E((Qae, BE) => {
    var rz = he();
    BE.exports = rz;
  });
  var zE = E((Zae, GE) => {
    ty();
    ny();
    ay();
    nl();
    Cy();
    Ry();
    qy();
    Vy();
    Gy();
    Hy();
    Wy();
    $y();
    Ky();
    Jy();
    e0();
    r0();
    R0();
    D0();
    G0();
    z0();
    X0();
    K0();
    Q0();
    tE();
    rE();
    SE();
    TE();
    AE();
    PE();
    wE();
    OE();
    NE();
    var nz = VE();
    GE.exports = nz.Array;
  });
  var jE = E((Jae, HE) => {
    var iz = zE();
    HE.exports = iz;
  });
  var $E = E((ese, XE) => {
    var az = Gr(),
      sz = Tt(),
      WE = la().f,
      oz = Yn(),
      UE =
        typeof window == "object" && window && Object.getOwnPropertyNames
          ? Object.getOwnPropertyNames(window)
          : [],
      lz = function (e) {
        try {
          return WE(e);
        } catch {
          return oz(UE);
        }
      };
    XE.exports.f = function (t) {
      return UE && az(t) == "Window" ? lz(t) : WE(sz(t));
    };
  });
  var YE = E((tse, KE) => {
    var uz = Fe();
    KE.exports = !uz(function () {
      return Object.isExtensible(Object.preventExtensions({}));
    });
  });
  var Pl = E((rse, JE) => {
    var cz = pe(),
      hz = _e(),
      fz = Vn(),
      pz = je(),
      Il = it(),
      dz = at().f,
      QE = la(),
      mz = $E(),
      gz = ea(),
      vz = YE(),
      ZE = !1,
      kt = gz("meta"),
      yz = 0,
      Tl =
        Object.isExtensible ||
        function () {
          return !0;
        },
      Al = function (e) {
        dz(e, kt, { value: { objectID: "O" + yz++, weakData: {} } });
      },
      Ez = function (e, t) {
        if (!pz(e))
          return typeof e == "symbol"
            ? e
            : (typeof e == "string" ? "S" : "P") + e;
        if (!Il(e, kt)) {
          if (!Tl(e)) return "F";
          if (!t) return "E";
          Al(e);
        }
        return e[kt].objectID;
      },
      bz = function (e, t) {
        if (!Il(e, kt)) {
          if (!Tl(e)) return !0;
          if (!t) return !1;
          Al(e);
        }
        return e[kt].weakData;
      },
      xz = function (e) {
        return vz && ZE && Tl(e) && !Il(e, kt) && Al(e), e;
      },
      Sz = function () {
        (_z.enable = function () {}), (ZE = !0);
        var e = QE.f,
          t = hz([].splice),
          r = {};
        (r[kt] = 1),
          e(r).length &&
            ((QE.f = function (n) {
              for (var i = e(n), a = 0, o = i.length; a < o; a++)
                if (i[a] === kt) {
                  t(i, a, 1);
                  break;
                }
              return i;
            }),
            cz(
              { target: "Object", stat: !0, forced: !0 },
              { getOwnPropertyNames: mz.f }
            ));
      },
      _z = (JE.exports = {
        enable: Sz,
        fastKey: Ez,
        getWeakData: bz,
        onFreeze: xz,
      });
    fz[kt] = !0;
  });
  var Ia = E((nse, n1) => {
    var Iz = he(),
      Tz = yt(),
      Az = rt(),
      Pz = Be(),
      wz = Ln(),
      Cz = $o(),
      Mz = Te(),
      e1 = Qi(),
      Oz = Un(),
      Rz = Wn(),
      t1 = Xo(),
      Dz = Iz.TypeError,
      _a = function (e, t) {
        (this.stopped = e), (this.result = t);
      },
      r1 = _a.prototype;
    n1.exports = function (e, t, r) {
      var n = r && r.that,
        i = !!(r && r.AS_ENTRIES),
        a = !!(r && r.IS_ITERATOR),
        o = !!(r && r.INTERRUPTED),
        s = Tz(t, n),
        l,
        f,
        u,
        h,
        m,
        d,
        p,
        g = function (v) {
          return l && t1(l, "normal", v), new _a(!0, v);
        },
        c = function (v) {
          return i
            ? (Pz(v), o ? s(v[0], v[1], g) : s(v[0], v[1]))
            : o
            ? s(v, g)
            : s(v);
        };
      if (a) l = e;
      else {
        if (((f = Rz(e)), !f)) throw Dz(wz(e) + " is not iterable");
        if (Cz(f)) {
          for (u = 0, h = Mz(e); h > u; u++)
            if (((m = c(e[u])), m && e1(r1, m))) return m;
          return new _a(!1);
        }
        l = Oz(e, f);
      }
      for (d = l.next; !(p = Az(d, l)).done; ) {
        try {
          m = c(p.value);
        } catch (v) {
          t1(l, "throw", v);
        }
        if (typeof m == "object" && m && e1(r1, m)) return m;
      }
      return new _a(!1);
    };
  });
  var Ta = E((ise, i1) => {
    var Fz = he(),
      Lz = Qi(),
      qz = Fz.TypeError;
    i1.exports = function (e, t) {
      if (Lz(t, e)) return e;
      throw qz("Incorrect invocation");
    };
  });
  var o1 = E((ase, s1) => {
    var kz = Pe(),
      Nz = je(),
      a1 = ga();
    s1.exports = function (e, t, r) {
      var n, i;
      return (
        a1 &&
          kz((n = t.constructor)) &&
          n !== r &&
          Nz((i = n.prototype)) &&
          i !== r.prototype &&
          a1(e, i),
        e
      );
    };
  });
  var c1 = E((sse, u1) => {
    "use strict";
    var Bz = pe(),
      Vz = he(),
      Gz = _e(),
      l1 = ua(),
      zz = Lt(),
      Hz = Pl(),
      jz = Ia(),
      Wz = Ta(),
      Uz = Pe(),
      wl = je(),
      Cl = Fe(),
      Xz = fa(),
      $z = Xn(),
      Kz = o1();
    u1.exports = function (e, t, r) {
      var n = e.indexOf("Map") !== -1,
        i = e.indexOf("Weak") !== -1,
        a = n ? "set" : "add",
        o = Vz[e],
        s = o && o.prototype,
        l = o,
        f = {},
        u = function (v) {
          var y = Gz(s[v]);
          zz(
            s,
            v,
            v == "add"
              ? function (x) {
                  return y(this, x === 0 ? 0 : x), this;
                }
              : v == "delete"
              ? function (b) {
                  return i && !wl(b) ? !1 : y(this, b === 0 ? 0 : b);
                }
              : v == "get"
              ? function (x) {
                  return i && !wl(x) ? void 0 : y(this, x === 0 ? 0 : x);
                }
              : v == "has"
              ? function (x) {
                  return i && !wl(x) ? !1 : y(this, x === 0 ? 0 : x);
                }
              : function (x, S) {
                  return y(this, x === 0 ? 0 : x, S), this;
                }
          );
        },
        h = l1(
          e,
          !Uz(o) ||
            !(
              i ||
              (s.forEach &&
                !Cl(function () {
                  new o().entries().next();
                }))
            )
        );
      if (h) (l = r.getConstructor(t, e, n, a)), Hz.enable();
      else if (l1(e, !0)) {
        var m = new l(),
          d = m[a](i ? {} : -0, 1) != m,
          p = Cl(function () {
            m.has(1);
          }),
          g = Xz(function (v) {
            new o(v);
          }),
          c =
            !i &&
            Cl(function () {
              for (var v = new o(), y = 5; y--; ) v[a](y, y);
              return !v.has(-0);
            });
        g ||
          ((l = t(function (v, y) {
            Wz(v, s);
            var b = Kz(new o(), v, l);
            return y != null && jz(y, b[a], { that: b, AS_ENTRIES: n }), b;
          })),
          (l.prototype = s),
          (s.constructor = l)),
          (p || c) && (u("delete"), u("has"), n && u("get")),
          (c || d) && u(a),
          i && s.clear && delete s.clear;
      }
      return (
        (f[e] = l),
        Bz({ global: !0, forced: l != o }, f),
        $z(l, e),
        i || r.setStrong(l, e, n),
        l
      );
    };
  });
  var Aa = E((ose, h1) => {
    var Yz = Lt();
    h1.exports = function (e, t, r) {
      for (var n in t) Yz(e, n, t[n], r);
      return e;
    };
  });
  var v1 = E((lse, g1) => {
    "use strict";
    var Qz = at().f,
      Zz = rr(),
      f1 = Aa(),
      Jz = yt(),
      eH = Ta(),
      tH = Ia(),
      rH = Ea(),
      nH = Sa(),
      Qn = mt(),
      p1 = Pl().fastKey,
      m1 = vr(),
      d1 = m1.set,
      Ml = m1.getterFor;
    g1.exports = {
      getConstructor: function (e, t, r, n) {
        var i = e(function (f, u) {
            eH(f, a),
              d1(f, {
                type: t,
                index: Zz(null),
                first: void 0,
                last: void 0,
                size: 0,
              }),
              Qn || (f.size = 0),
              u != null && tH(u, f[n], { that: f, AS_ENTRIES: r });
          }),
          a = i.prototype,
          o = Ml(t),
          s = function (f, u, h) {
            var m = o(f),
              d = l(f, u),
              p,
              g;
            return (
              d
                ? (d.value = h)
                : ((m.last = d =
                    {
                      index: (g = p1(u, !0)),
                      key: u,
                      value: h,
                      previous: (p = m.last),
                      next: void 0,
                      removed: !1,
                    }),
                  m.first || (m.first = d),
                  p && (p.next = d),
                  Qn ? m.size++ : f.size++,
                  g !== "F" && (m.index[g] = d)),
              f
            );
          },
          l = function (f, u) {
            var h = o(f),
              m = p1(u),
              d;
            if (m !== "F") return h.index[m];
            for (d = h.first; d; d = d.next) if (d.key == u) return d;
          };
        return (
          f1(a, {
            clear: function () {
              for (var u = this, h = o(u), m = h.index, d = h.first; d; )
                (d.removed = !0),
                  d.previous && (d.previous = d.previous.next = void 0),
                  delete m[d.index],
                  (d = d.next);
              (h.first = h.last = void 0), Qn ? (h.size = 0) : (u.size = 0);
            },
            delete: function (f) {
              var u = this,
                h = o(u),
                m = l(u, f);
              if (m) {
                var d = m.next,
                  p = m.previous;
                delete h.index[m.index],
                  (m.removed = !0),
                  p && (p.next = d),
                  d && (d.previous = p),
                  h.first == m && (h.first = d),
                  h.last == m && (h.last = p),
                  Qn ? h.size-- : u.size--;
              }
              return !!m;
            },
            forEach: function (u) {
              for (
                var h = o(this),
                  m = Jz(u, arguments.length > 1 ? arguments[1] : void 0),
                  d;
                (d = d ? d.next : h.first);

              )
                for (m(d.value, d.key, this); d && d.removed; ) d = d.previous;
            },
            has: function (u) {
              return !!l(this, u);
            },
          }),
          f1(
            a,
            r
              ? {
                  get: function (u) {
                    var h = l(this, u);
                    return h && h.value;
                  },
                  set: function (u, h) {
                    return s(this, u === 0 ? 0 : u, h);
                  },
                }
              : {
                  add: function (u) {
                    return s(this, (u = u === 0 ? 0 : u), u);
                  },
                }
          ),
          Qn &&
            Qz(a, "size", {
              get: function () {
                return o(this).size;
              },
            }),
          i
        );
      },
      setStrong: function (e, t, r) {
        var n = t + " Iterator",
          i = Ml(t),
          a = Ml(n);
        rH(
          e,
          t,
          function (o, s) {
            d1(this, {
              type: n,
              target: o,
              state: i(o),
              kind: s,
              last: void 0,
            });
          },
          function () {
            for (var o = a(this), s = o.kind, l = o.last; l && l.removed; )
              l = l.previous;
            return !o.target || !(o.last = l = l ? l.next : o.state.first)
              ? ((o.target = void 0), { value: void 0, done: !0 })
              : s == "keys"
              ? { value: l.key, done: !1 }
              : s == "values"
              ? { value: l.value, done: !1 }
              : { value: [l.key, l.value], done: !1 };
          },
          r ? "entries" : "values",
          !r,
          !0
        ),
          nH(t);
      },
    };
  });
  var y1 = E(() => {
    "use strict";
    var iH = c1(),
      aH = v1();
    iH(
      "Map",
      function (e) {
        return function () {
          return e(this, arguments.length ? arguments[0] : void 0);
        };
      },
      aH
    );
  });
  var b1 = E((hse, E1) => {
    var sH = he();
    E1.exports = sH.Promise;
  });
  var S1 = E((fse, x1) => {
    var oH = he(),
      lH = yr(),
      uH = Ln(),
      cH = oH.TypeError;
    x1.exports = function (e) {
      if (lH(e)) return e;
      throw cH(uH(e) + " is not a constructor");
    };
  });
  var T1 = E((pse, I1) => {
    var _1 = Be(),
      hH = S1(),
      fH = we(),
      pH = fH("species");
    I1.exports = function (e, t) {
      var r = _1(e).constructor,
        n;
      return r === void 0 || (n = _1(r)[pH]) == null ? t : hH(n);
    };
  });
  var Ol = E((dse, A1) => {
    var dH = Yt();
    A1.exports = /(?:ipad|iphone|ipod).*applewebkit/i.test(dH);
  });
  var Vl = E((mse, F1) => {
    var Qe = he(),
      mH = ba(),
      gH = yt(),
      P1 = Pe(),
      vH = it(),
      yH = Fe(),
      w1 = Qo(),
      EH = Yn(),
      C1 = ta(),
      bH = Ol(),
      xH = $r(),
      kl = Qe.setImmediate,
      Nl = Qe.clearImmediate,
      SH = Qe.process,
      Rl = Qe.Dispatch,
      _H = Qe.Function,
      M1 = Qe.MessageChannel,
      IH = Qe.String,
      Dl = 0,
      Zn = {},
      O1 = "onreadystatechange",
      Jn,
      br,
      Fl,
      Ll;
    try {
      Jn = Qe.location;
    } catch {}
    var Bl = function (e) {
        if (vH(Zn, e)) {
          var t = Zn[e];
          delete Zn[e], t();
        }
      },
      ql = function (e) {
        return function () {
          Bl(e);
        };
      },
      R1 = function (e) {
        Bl(e.data);
      },
      D1 = function (e) {
        Qe.postMessage(IH(e), Jn.protocol + "//" + Jn.host);
      };
    (!kl || !Nl) &&
      ((kl = function (t) {
        var r = EH(arguments, 1);
        return (
          (Zn[++Dl] = function () {
            mH(P1(t) ? t : _H(t), void 0, r);
          }),
          br(Dl),
          Dl
        );
      }),
      (Nl = function (t) {
        delete Zn[t];
      }),
      xH
        ? (br = function (e) {
            SH.nextTick(ql(e));
          })
        : Rl && Rl.now
        ? (br = function (e) {
            Rl.now(ql(e));
          })
        : M1 && !bH
        ? ((Fl = new M1()),
          (Ll = Fl.port2),
          (Fl.port1.onmessage = R1),
          (br = gH(Ll.postMessage, Ll)))
        : Qe.addEventListener &&
          P1(Qe.postMessage) &&
          !Qe.importScripts &&
          Jn &&
          Jn.protocol !== "file:" &&
          !yH(D1)
        ? ((br = D1), Qe.addEventListener("message", R1, !1))
        : O1 in C1("script")
        ? (br = function (e) {
            w1.appendChild(C1("script"))[O1] = function () {
              w1.removeChild(this), Bl(e);
            };
          })
        : (br = function (e) {
            setTimeout(ql(e), 0);
          }));
    F1.exports = { set: kl, clear: Nl };
  });
  var q1 = E((gse, L1) => {
    var TH = Yt(),
      AH = he();
    L1.exports = /ipad|iphone|ipod/i.test(TH) && AH.Pebble !== void 0;
  });
  var N1 = E((vse, k1) => {
    var PH = Yt();
    k1.exports = /web0s(?!.*chrome)/i.test(PH);
  });
  var X1 = E((yse, U1) => {
    var Sr = he(),
      B1 = yt(),
      wH = ra().f,
      Gl = Vl().set,
      CH = Ol(),
      MH = q1(),
      OH = N1(),
      zl = $r(),
      V1 = Sr.MutationObserver || Sr.WebKitMutationObserver,
      G1 = Sr.document,
      z1 = Sr.process,
      Pa = Sr.Promise,
      H1 = wH(Sr, "queueMicrotask"),
      W1 = H1 && H1.value,
      ei,
      xr,
      ti,
      Kr,
      Hl,
      jl,
      wa,
      j1;
    W1 ||
      ((ei = function () {
        var e, t;
        for (zl && (e = z1.domain) && e.exit(); xr; ) {
          (t = xr.fn), (xr = xr.next);
          try {
            t();
          } catch (r) {
            throw (xr ? Kr() : (ti = void 0), r);
          }
        }
        (ti = void 0), e && e.enter();
      }),
      !CH && !zl && !OH && V1 && G1
        ? ((Hl = !0),
          (jl = G1.createTextNode("")),
          new V1(ei).observe(jl, { characterData: !0 }),
          (Kr = function () {
            jl.data = Hl = !Hl;
          }))
        : !MH && Pa && Pa.resolve
        ? ((wa = Pa.resolve(void 0)),
          (wa.constructor = Pa),
          (j1 = B1(wa.then, wa)),
          (Kr = function () {
            j1(ei);
          }))
        : zl
        ? (Kr = function () {
            z1.nextTick(ei);
          })
        : ((Gl = B1(Gl, Sr)),
          (Kr = function () {
            Gl(ei);
          })));
    U1.exports =
      W1 ||
      function (e) {
        var t = { fn: e, next: void 0 };
        ti && (ti.next = t), xr || ((xr = t), Kr()), (ti = t);
      };
  });
  var Wl = E((Ese, K1) => {
    "use strict";
    var $1 = vt(),
      RH = function (e) {
        var t, r;
        (this.promise = new e(function (n, i) {
          if (t !== void 0 || r !== void 0)
            throw TypeError("Bad Promise constructor");
          (t = n), (r = i);
        })),
          (this.resolve = $1(t)),
          (this.reject = $1(r));
      };
    K1.exports.f = function (e) {
      return new RH(e);
    };
  });
  var Q1 = E((bse, Y1) => {
    var DH = Be(),
      FH = je(),
      LH = Wl();
    Y1.exports = function (e, t) {
      if ((DH(e), FH(t) && t.constructor === e)) return t;
      var r = LH.f(e),
        n = r.resolve;
      return n(t), r.promise;
    };
  });
  var J1 = E((xse, Z1) => {
    var qH = he();
    Z1.exports = function (e, t) {
      var r = qH.console;
      r && r.error && (arguments.length == 1 ? r.error(e) : r.error(e, t));
    };
  });
  var tb = E((Sse, eb) => {
    eb.exports = function (e) {
      try {
        return { error: !1, value: e() };
      } catch (t) {
        return { error: !0, value: t };
      }
    };
  });
  var nb = E((_se, rb) => {
    rb.exports = typeof window == "object";
  });
  var Ib = E(() => {
    "use strict";
    var Da = pe(),
      Ma = zr(),
      Nt = he(),
      kH = nt(),
      Bt = rt(),
      Oa = b1(),
      ib = Lt(),
      NH = Aa(),
      ab = ga(),
      BH = Xn(),
      VH = Sa(),
      Ul = vt(),
      ri = Pe(),
      GH = je(),
      zH = Ta(),
      HH = Bn(),
      sb = Ia(),
      jH = fa(),
      WH = T1(),
      db = Vl().set,
      mb = X1(),
      UH = Q1(),
      XH = J1(),
      gb = Wl(),
      Xl = tb(),
      Ql = vr(),
      $H = ua(),
      KH = we(),
      YH = nb(),
      Ra = $r(),
      lb = Qt(),
      QH = KH("species"),
      Vt = "Promise",
      ub = Ql.get,
      ZH = Ql.set,
      JH = Ql.getterFor(Vt),
      _r = Oa && Oa.prototype,
      st = Oa,
      Yr = _r,
      vb = Nt.TypeError,
      $l = Nt.document,
      Zl = Nt.process,
      Jr = gb.f,
      ej = Jr,
      tj = !!($l && $l.createEvent && Nt.dispatchEvent),
      yb = ri(Nt.PromiseRejectionEvent),
      Eb = "unhandledrejection",
      rj = "rejectionhandled",
      cb = 0,
      bb = 1,
      nj = 2,
      Jl = 1,
      xb = 2,
      Kl = !1,
      Ca,
      hb,
      eu,
      fb,
      ni = $H(Vt, function () {
        var e = HH(st),
          t = e !== String(st);
        if ((!t && lb === 66) || (Ma && !Yr.finally)) return !0;
        if (lb >= 51 && /native code/.test(e)) return !1;
        var r = new st(function (a) {
            a(1);
          }),
          n = function (a) {
            a(
              function () {},
              function () {}
            );
          },
          i = (r.constructor = {});
        return (
          (i[QH] = n),
          (Kl = r.then(function () {}) instanceof n),
          Kl ? !t && YH && !yb : !0
        );
      }),
      ij =
        ni ||
        !jH(function (e) {
          st.all(e).catch(function () {});
        }),
      Sb = function (e) {
        var t;
        return GH(e) && ri((t = e.then)) ? t : !1;
      },
      tu = function (e, t) {
        if (!e.notified) {
          e.notified = !0;
          var r = e.reactions;
          mb(function () {
            for (var n = e.value, i = e.state == bb, a = 0; r.length > a; ) {
              var o = r[a++],
                s = i ? o.ok : o.fail,
                l = o.resolve,
                f = o.reject,
                u = o.domain,
                h,
                m,
                d;
              try {
                s
                  ? (i || (e.rejection === xb && sj(e), (e.rejection = Jl)),
                    s === !0
                      ? (h = n)
                      : (u && u.enter(), (h = s(n)), u && (u.exit(), (d = !0))),
                    h === o.promise
                      ? f(vb("Promise-chain cycle"))
                      : (m = Sb(h))
                      ? Bt(m, h, l, f)
                      : l(h))
                  : f(n);
              } catch (p) {
                u && !d && u.exit(), f(p);
              }
            }
            (e.reactions = []), (e.notified = !1), t && !e.rejection && aj(e);
          });
        }
      },
      _b = function (e, t, r) {
        var n, i;
        tj
          ? ((n = $l.createEvent("Event")),
            (n.promise = t),
            (n.reason = r),
            n.initEvent(e, !1, !0),
            Nt.dispatchEvent(n))
          : (n = { promise: t, reason: r }),
          !yb && (i = Nt["on" + e])
            ? i(n)
            : e === Eb && XH("Unhandled promise rejection", r);
      },
      aj = function (e) {
        Bt(db, Nt, function () {
          var t = e.facade,
            r = e.value,
            n = pb(e),
            i;
          if (
            n &&
            ((i = Xl(function () {
              Ra ? Zl.emit("unhandledRejection", r, t) : _b(Eb, t, r);
            })),
            (e.rejection = Ra || pb(e) ? xb : Jl),
            i.error)
          )
            throw i.value;
        });
      },
      pb = function (e) {
        return e.rejection !== Jl && !e.parent;
      },
      sj = function (e) {
        Bt(db, Nt, function () {
          var t = e.facade;
          Ra ? Zl.emit("rejectionHandled", t) : _b(rj, t, e.value);
        });
      },
      Qr = function (e, t, r) {
        return function (n) {
          e(t, n, r);
        };
      },
      Zr = function (e, t, r) {
        e.done ||
          ((e.done = !0),
          r && (e = r),
          (e.value = t),
          (e.state = nj),
          tu(e, !0));
      },
      Yl = function (e, t, r) {
        if (!e.done) {
          (e.done = !0), r && (e = r);
          try {
            if (e.facade === t) throw vb("Promise can't be resolved itself");
            var n = Sb(t);
            n
              ? mb(function () {
                  var i = { done: !1 };
                  try {
                    Bt(n, t, Qr(Yl, i, e), Qr(Zr, i, e));
                  } catch (a) {
                    Zr(i, a, e);
                  }
                })
              : ((e.value = t), (e.state = bb), tu(e, !1));
          } catch (i) {
            Zr({ done: !1 }, i, e);
          }
        }
      };
    if (
      ni &&
      ((st = function (t) {
        zH(this, Yr), Ul(t), Bt(Ca, this);
        var r = ub(this);
        try {
          t(Qr(Yl, r), Qr(Zr, r));
        } catch (n) {
          Zr(r, n);
        }
      }),
      (Yr = st.prototype),
      (Ca = function (t) {
        ZH(this, {
          type: Vt,
          done: !1,
          notified: !1,
          parent: !1,
          reactions: [],
          rejection: !1,
          state: cb,
          value: void 0,
        });
      }),
      (Ca.prototype = NH(Yr, {
        then: function (t, r) {
          var n = JH(this),
            i = n.reactions,
            a = Jr(WH(this, st));
          return (
            (a.ok = ri(t) ? t : !0),
            (a.fail = ri(r) && r),
            (a.domain = Ra ? Zl.domain : void 0),
            (n.parent = !0),
            (i[i.length] = a),
            n.state != cb && tu(n, !1),
            a.promise
          );
        },
        catch: function (e) {
          return this.then(void 0, e);
        },
      })),
      (hb = function () {
        var e = new Ca(),
          t = ub(e);
        (this.promise = e),
          (this.resolve = Qr(Yl, t)),
          (this.reject = Qr(Zr, t));
      }),
      (gb.f = Jr =
        function (e) {
          return e === st || e === eu ? new hb(e) : ej(e);
        }),
      !Ma && ri(Oa) && _r !== Object.prototype)
    ) {
      (fb = _r.then),
        Kl ||
          (ib(
            _r,
            "then",
            function (t, r) {
              var n = this;
              return new st(function (i, a) {
                Bt(fb, n, i, a);
              }).then(t, r);
            },
            { unsafe: !0 }
          ),
          ib(_r, "catch", Yr.catch, { unsafe: !0 }));
      try {
        delete _r.constructor;
      } catch {}
      ab && ab(_r, Yr);
    }
    Da({ global: !0, wrap: !0, forced: ni }, { Promise: st });
    BH(st, Vt, !1, !0);
    VH(Vt);
    eu = kH(Vt);
    Da(
      { target: Vt, stat: !0, forced: ni },
      {
        reject: function (t) {
          var r = Jr(this);
          return Bt(r.reject, void 0, t), r.promise;
        },
      }
    );
    Da(
      { target: Vt, stat: !0, forced: Ma || ni },
      {
        resolve: function (t) {
          return UH(Ma && this === eu ? st : this, t);
        },
      }
    );
    Da(
      { target: Vt, stat: !0, forced: ij },
      {
        all: function (t) {
          var r = this,
            n = Jr(r),
            i = n.resolve,
            a = n.reject,
            o = Xl(function () {
              var s = Ul(r.resolve),
                l = [],
                f = 0,
                u = 1;
              sb(t, function (h) {
                var m = f++,
                  d = !1;
                u++,
                  Bt(s, r, h).then(function (p) {
                    d || ((d = !0), (l[m] = p), --u || i(l));
                  }, a);
              }),
                --u || i(l);
            });
          return o.error && a(o.value), n.promise;
        },
        race: function (t) {
          var r = this,
            n = Jr(r),
            i = n.reject,
            a = Xl(function () {
              var o = Ul(r.resolve);
              sb(t, function (s) {
                Bt(o, r, s).then(n.resolve, i);
              });
            });
          return a.error && i(a.value), n.promise;
        },
      }
    );
  });
  var Db = E((Ase, Rb) => {
    var Cb = he(),
      Mb = qn(),
      Ob = Pe(),
      oj = rr(),
      Fa = ma(),
      lj = Lt(),
      uj = we(),
      cj = zr(),
      Tb = "USE_FUNCTION_CONSTRUCTOR",
      Ab = uj("asyncIterator"),
      Pb = Cb.AsyncIterator,
      wb = Mb.AsyncIteratorPrototype,
      wt,
      ru;
    if (wb) wt = wb;
    else if (Ob(Pb)) wt = Pb.prototype;
    else if (Mb[Tb] || Cb[Tb])
      try {
        (ru = Fa(Fa(Fa(Function("return async function*(){}()")())))),
          Fa(ru) === Object.prototype && (wt = ru);
      } catch {}
    wt ? cj && (wt = oj(wt)) : (wt = {});
    Ob(wt[Ab]) ||
      lj(wt, Ab, function () {
        return this;
      });
    Rb.exports = wt;
  });
  var su = E((Pse, kb) => {
    "use strict";
    var nu = ba(),
      La = Be(),
      hj = rr(),
      Fb = Zt(),
      fj = Aa(),
      Lb = vr(),
      pj = nt(),
      dj = Db(),
      qa = pj("Promise"),
      mj = Lb.set,
      iu = Lb.get,
      au = function (e, t, r) {
        var n = e.done;
        qa.resolve(e.value).then(function (i) {
          t({ done: n, value: i });
        }, r);
      },
      qb = function (t) {
        mj(this, { iterator: La(t), next: t.next });
      };
    qb.prototype = fj(hj(dj), {
      next: function (t) {
        var r = iu(this),
          n = !!arguments.length;
        return new qa(function (i, a) {
          var o = La(nu(r.next, r.iterator, n ? [t] : []));
          au(o, i, a);
        });
      },
      return: function (e) {
        var t = iu(this).iterator,
          r = !!arguments.length;
        return new qa(function (n, i) {
          var a = Fb(t, "return");
          if (a === void 0) return n({ done: !0, value: e });
          var o = La(nu(a, t, r ? [e] : []));
          au(o, n, i);
        });
      },
      throw: function (e) {
        var t = iu(this).iterator,
          r = !!arguments.length;
        return new qa(function (n, i) {
          var a = Fb(t, "throw");
          if (a === void 0) return i(e);
          var o = La(nu(a, t, r ? [e] : []));
          au(o, n, i);
        });
      },
    });
    kb.exports = qb;
  });
  var Bb = E((wse, Nb) => {
    var gj = rt(),
      vj = su(),
      yj = Be(),
      Ej = Un(),
      bj = Zt(),
      xj = we(),
      Sj = xj("asyncIterator");
    Nb.exports = function (e, t) {
      var r = arguments.length < 2 ? bj(e, Sj) : t;
      return r ? yj(gj(r, e)) : new vj(Ej(e));
    };
  });
  var Gb = E((Cse, Vb) => {
    var _j = he();
    Vb.exports = function (e) {
      return _j[e].prototype;
    };
  });
  var Wb = E((Mse, jb) => {
    "use strict";
    var Ij = he(),
      zb = rt(),
      Hb = vt(),
      ou = Be(),
      Tj = nt(),
      Aj = Zt(),
      Pj = 9007199254740991,
      wj = Ij.TypeError,
      ii = function (e) {
        var t = e == 0,
          r = e == 1,
          n = e == 2,
          i = e == 3;
        return function (a, o, s) {
          ou(a);
          var l = Tj("Promise"),
            f = Hb(a.next),
            u = 0,
            h = o !== void 0;
          return (
            (h || !t) && Hb(o),
            new l(function (m, d) {
              var p = function (v, y) {
                  try {
                    var b = Aj(a, "return");
                    if (b)
                      return l.resolve(zb(b, a)).then(
                        function () {
                          v(y);
                        },
                        function (x) {
                          d(x);
                        }
                      );
                  } catch (x) {
                    return d(x);
                  }
                  v(y);
                },
                g = function (v) {
                  p(d, v);
                },
                c = function () {
                  try {
                    if (t && u > Pj && h)
                      throw wj(
                        "The allowed number of iterations has been exceeded"
                      );
                    l.resolve(ou(zb(f, a))).then(function (v) {
                      try {
                        if (ou(v).done)
                          t ? ((s.length = u), m(s)) : m(i ? !1 : n || void 0);
                        else {
                          var y = v.value;
                          h
                            ? l.resolve(t ? o(y, u) : o(y)).then(function (b) {
                                r
                                  ? c()
                                  : n
                                  ? b
                                    ? c()
                                    : p(m, !1)
                                  : t
                                  ? ((s[u++] = b), c())
                                  : b
                                  ? p(m, i || y)
                                  : c();
                              }, g)
                            : ((s[u++] = y), c());
                        }
                      } catch (b) {
                        g(b);
                      }
                    }, g);
                  } catch (v) {
                    g(v);
                  }
                };
              c();
            })
          );
        };
      };
    jb.exports = {
      toArray: ii(0),
      forEach: ii(1),
      every: ii(2),
      some: ii(3),
      find: ii(4),
    };
  });
  var Xb = E((Ose, Ub) => {
    "use strict";
    var Cj = yt(),
      Mj = Me(),
      Oj = yr(),
      Rj = Bb(),
      Dj = Un(),
      Fj = Wn(),
      Lj = Zt(),
      qj = Gb(),
      kj = nt(),
      Nj = we(),
      Bj = su(),
      Vj = Wb().toArray,
      Gj = Nj("asyncIterator"),
      zj = qj("Array").values;
    Ub.exports = function (t) {
      var r = this,
        n = arguments.length,
        i = n > 1 ? arguments[1] : void 0,
        a = n > 2 ? arguments[2] : void 0;
      return new (kj("Promise"))(function (o) {
        var s = Mj(t);
        i !== void 0 && (i = Cj(i, a));
        var l = Lj(s, Gj),
          f = l ? void 0 : Fj(s) || zj,
          u = Oj(r) ? new r() : [],
          h = l ? Rj(s, l) : new Bj(Dj(s, f));
        o(Vj(h, i, u));
      });
    };
  });
  var $b = E(() => {
    var Hj = pe(),
      jj = Xb();
    Hj({ target: "Array", stat: !0 }, { fromAsync: jj });
  });
  var Kb = E(() => {
    nl();
  });
  var Yb = E(() => {
    "use strict";
    var Wj = pe(),
      Uj = At().filterReject,
      Xj = De();
    Wj(
      { target: "Array", proto: !0 },
      {
        filterOut: function (t) {
          return Uj(this, t, arguments.length > 1 ? arguments[1] : void 0);
        },
      }
    );
    Xj("filterOut");
  });
  var Qb = E(() => {
    "use strict";
    var $j = pe(),
      Kj = At().filterReject,
      Yj = De();
    $j(
      { target: "Array", proto: !0 },
      {
        filterReject: function (t) {
          return Kj(this, t, arguments.length > 1 ? arguments[1] : void 0);
        },
      }
    );
    Yj("filterReject");
  });
  var lu = E((Vse, Jb) => {
    var Qj = yt(),
      Zj = dr(),
      Jj = Me(),
      eW = Te(),
      Zb = function (e) {
        var t = e == 1;
        return function (r, n, i) {
          for (
            var a = Jj(r), o = Zj(a), s = Qj(n, i), l = eW(o), f, u;
            l-- > 0;

          )
            if (((f = o[l]), (u = s(f, l, a)), u))
              switch (e) {
                case 0:
                  return f;
                case 1:
                  return l;
              }
          return t ? -1 : void 0;
        };
      };
    Jb.exports = { findLast: Zb(0), findLastIndex: Zb(1) };
  });
  var ex = E(() => {
    "use strict";
    var tW = pe(),
      rW = lu().findLast,
      nW = De();
    tW(
      { target: "Array", proto: !0 },
      {
        findLast: function (t) {
          return rW(this, t, arguments.length > 1 ? arguments[1] : void 0);
        },
      }
    );
    nW("findLast");
  });
  var tx = E(() => {
    "use strict";
    var iW = pe(),
      aW = lu().findLastIndex,
      sW = De();
    iW(
      { target: "Array", proto: !0 },
      {
        findLastIndex: function (t) {
          return aW(this, t, arguments.length > 1 ? arguments[1] : void 0);
        },
      }
    );
    sW("findLastIndex");
  });
  var nx = E((Wse, rx) => {
    rx.exports = function (e, t) {
      for (var r = 0, n = t.length, i = new e(n); n > r; ) i[r] = t[r++];
      return i;
    };
  });
  var ax = E((Use, ix) => {
    var oW = he(),
      lW = yt(),
      uW = _e(),
      cW = dr(),
      hW = Me(),
      fW = kn(),
      pW = Te(),
      dW = rr(),
      mW = nx(),
      gW = oW.Array,
      vW = uW([].push);
    ix.exports = function (e, t, r, n) {
      for (
        var i = hW(e),
          a = cW(i),
          o = lW(t, r),
          s = dW(null),
          l = pW(a),
          f = 0,
          u,
          h,
          m;
        l > f;
        f++
      )
        (m = a[f]), (h = fW(o(m, f, i))), h in s ? vW(s[h], m) : (s[h] = [m]);
      if (n && ((u = n(i)), u !== gW)) for (h in s) s[h] = mW(u, s[h]);
      return s;
    };
  });
  var sx = E(() => {
    "use strict";
    var yW = pe(),
      EW = ax(),
      bW = il(),
      xW = De();
    yW(
      { target: "Array", proto: !0 },
      {
        groupBy: function (t) {
          var r = arguments.length > 1 ? arguments[1] : void 0;
          return EW(this, t, r, bW);
        },
      }
    );
    xW("groupBy");
  });
  var ux = E(() => {
    var SW = pe(),
      _W = tr(),
      ox = Object.isFrozen,
      lx = function (e, t) {
        if (!ox || !_W(e) || !ox(e)) return !1;
        for (var r = 0, n = e.length, i; r < n; )
          if (((i = e[r++]), !(typeof i == "string" || (t && typeof i > "u"))))
            return !1;
        return n !== 0;
      };
    SW(
      { target: "Array", stat: !0 },
      {
        isTemplateObject: function (t) {
          if (!lx(t, !0)) return !1;
          var r = t.raw;
          return !(r.length !== t.length || !lx(r, !1));
        },
      }
    );
  });
  var fx = E(() => {
    "use strict";
    var IW = mt(),
      TW = De(),
      cx = Me(),
      hx = Te(),
      AW = at().f;
    IW &&
      !("lastItem" in []) &&
      (AW(Array.prototype, "lastItem", {
        configurable: !0,
        get: function () {
          var t = cx(this),
            r = hx(t);
          return r == 0 ? void 0 : t[r - 1];
        },
        set: function (t) {
          var r = cx(this),
            n = hx(r);
          return (r[n == 0 ? 0 : n - 1] = t);
        },
      }),
      TW("lastItem"));
  });
  var px = E(() => {
    "use strict";
    var PW = mt(),
      wW = De(),
      CW = Me(),
      MW = Te(),
      OW = at().f;
    PW &&
      !("lastIndex" in []) &&
      (OW(Array.prototype, "lastIndex", {
        configurable: !0,
        get: function () {
          var t = CW(this),
            r = MW(t);
          return r == 0 ? 0 : r - 1;
        },
      }),
      wW("lastIndex"));
  });
  var gx = E((toe, mx) => {
    "use strict";
    var RW = nt(),
      ka = _e(),
      DW = vt(),
      FW = Te(),
      LW = Me(),
      qW = Er(),
      dx = RW("Map"),
      uu = dx.prototype,
      kW = ka(uu.forEach),
      NW = ka(uu.has),
      BW = ka(uu.set),
      VW = ka([].push);
    mx.exports = function (t) {
      var r = LW(this),
        n = FW(r),
        i = qW(r, 0),
        a = new dx(),
        o =
          t != null
            ? DW(t)
            : function (u) {
                return u;
              },
        s,
        l,
        f;
      for (s = 0; s < n; s++) (l = r[s]), (f = o(l)), NW(a, f) || BW(a, f, l);
      return (
        kW(a, function (u) {
          VW(i, u);
        }),
        i
      );
    };
  });
  var vx = E(() => {
    "use strict";
    var GW = pe(),
      zW = De(),
      HW = gx();
    GW({ target: "Array", proto: !0 }, { uniqueBy: HW });
    zW("uniqueBy");
  });
  var Ex = E((ioe, yx) => {
    var jW = jE();
    y1();
    Ib();
    $b();
    Kb();
    Yb();
    Qb();
    ex();
    tx();
    sx();
    ux();
    fx();
    px();
    vx();
    yx.exports = jW;
  });
  var kx = E((mu) => {
    "use strict";
    Object.defineProperty(mu, "__esModule", { value: !0 });
    function WW(e, t) {
      for (var r in t)
        Object.defineProperty(e, r, { enumerable: !0, get: t[r] });
    }
    WW(mu, {
      strFromU8: function () {
        return qx;
      },
      unzip: function () {
        return iU;
      },
    });
    var bx = {},
      UW = function (e, t, r, n, i) {
        let a = new Worker(
          bx[t] ||
            (bx[t] = URL.createObjectURL(
              new Blob(
                [
                  e +
                    ';addEventListener("error",function(e){e=e.error;postMessage({$e$:[e.message,e.code,e.stack]})})',
                ],
                { type: "text/javascript" }
              )
            ))
        );
        return (
          (a.onmessage = function (o) {
            let s = o.data,
              l = s.$e$;
            if (l) {
              let f = new Error(l[0]);
              (f.code = l[1]), (f.stack = l[2]), i(f, null);
            } else i(null, s);
          }),
          a.postMessage(r, n),
          a
        );
      },
      Ue = Uint8Array,
      sr = Uint16Array,
      cu = Uint32Array,
      hu = new Ue([
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4,
        5, 5, 5, 5, 0, 0, 0, 0,
      ]),
      fu = new Ue([
        0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10,
        10, 11, 11, 12, 12, 13, 13, 0, 0,
      ]),
      Ix = new Ue([
        16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15,
      ]),
      Tx = function (e, t) {
        let r = new sr(31);
        for (var n = 0; n < 31; ++n) r[n] = t += 1 << e[n - 1];
        let i = new cu(r[30]);
        for (n = 1; n < 30; ++n)
          for (let a = r[n]; a < r[n + 1]; ++a) i[a] = ((a - r[n]) << 5) | n;
        return [r, i];
      },
      Ax = Tx(hu, 2),
      pu = Ax[0],
      XW = Ax[1];
    (pu[28] = 258), (XW[258] = 28);
    var $W = Tx(fu, 0),
      Px = $W[0],
      Ga = new sr(32768);
    for (be = 0; be < 32768; ++be) {
      let e = ((43690 & be) >>> 1) | ((21845 & be) << 1);
      (e = ((52428 & e) >>> 2) | ((13107 & e) << 2)),
        (e = ((61680 & e) >>> 4) | ((3855 & e) << 4)),
        (Ga[be] = (((65280 & e) >>> 8) | ((255 & e) << 8)) >>> 1);
    }
    var be,
      en = function (e, t, r) {
        let n = e.length,
          i = 0,
          a = new sr(t);
        for (; i < n; ++i) e[i] && ++a[e[i] - 1];
        let o = new sr(t);
        for (i = 0; i < t; ++i) o[i] = (o[i - 1] + a[i - 1]) << 1;
        let s;
        if (r) {
          s = new sr(1 << t);
          let l = 15 - t;
          for (i = 0; i < n; ++i)
            if (e[i]) {
              let f = (i << 4) | e[i],
                u = t - e[i],
                h = o[e[i] - 1]++ << u;
              for (let m = h | ((1 << u) - 1); h <= m; ++h) s[Ga[h] >>> l] = f;
            }
        } else
          for (s = new sr(n), i = 0; i < n; ++i)
            e[i] && (s[i] = Ga[o[e[i] - 1]++] >>> (15 - e[i]));
        return s;
      },
      ai = new Ue(288);
    for (be = 0; be < 144; ++be) ai[be] = 8;
    for (be = 144; be < 256; ++be) ai[be] = 9;
    for (be = 256; be < 280; ++be) ai[be] = 7;
    for (be = 280; be < 288; ++be) ai[be] = 8;
    var wx = new Ue(32);
    for (be = 0; be < 32; ++be) wx[be] = 5;
    var Cx = en(ai, 9, 1),
      Mx = en(wx, 5, 1),
      Ba = function (e) {
        let t = e[0];
        for (let r = 1; r < e.length; ++r) e[r] > t && (t = e[r]);
        return t;
      },
      ot = function (e, t, r) {
        let n = (t / 8) | 0;
        return ((e[n] | (e[n + 1] << 8)) >> (7 & t)) & r;
      },
      Va = function (e, t) {
        let r = (t / 8) | 0;
        return (e[r] | (e[r + 1] << 8) | (e[r + 2] << 16)) >> (7 & t);
      },
      Ox = function (e) {
        return ((e + 7) / 8) | 0;
      },
      za = function (e, t, r) {
        (t == null || t < 0) && (t = 0),
          (r == null || r > e.length) && (r = e.length);
        let n = new (
          e.BYTES_PER_ELEMENT === 2 ? sr : e.BYTES_PER_ELEMENT === 4 ? cu : Ue
        )(r - t);
        return n.set(e.subarray(t, r)), n;
      },
      Rx = [
        "unexpected EOF",
        "invalid block type",
        "invalid length/literal",
        "invalid distance",
        "stream finished",
        "no stream handler",
        ,
        "no callback",
        "invalid UTF-8 data",
        "extra field too long",
        "date not in range 1980-2099",
        "filename too long",
        "stream finishing",
        "invalid zip data",
      ],
      We = function (e, t, r) {
        let n = new Error(t || Rx[e]);
        if (
          ((n.code = e),
          Error.captureStackTrace && Error.captureStackTrace(n, We),
          !r)
        )
          throw n;
        return n;
      },
      Dx = function (e, t, r) {
        let n = e.length;
        if (!n || (r && r.f && !r.l)) return t || new Ue(0);
        let i = !t || r,
          a = !r || r.i;
        r || (r = {}), t || (t = new Ue(3 * n));
        let o = function (x) {
            let S = t.length;
            if (x > S) {
              let T = new Ue(Math.max(2 * S, x));
              T.set(t), (t = T);
            }
          },
          s = r.f || 0,
          l = r.p || 0,
          f = r.b || 0,
          u = r.l,
          h = r.d,
          m = r.m,
          d = r.n,
          p = 8 * n;
        do {
          if (!u) {
            s = ot(e, l, 1);
            let I = ot(e, l + 1, 3);
            if (((l += 3), !I)) {
              let P = e[(c = Ox(l) + 4) - 4] | (e[c - 3] << 8),
                L = c + P;
              if (L > n) {
                a && We(0);
                break;
              }
              i && o(f + P),
                t.set(e.subarray(c, L), f),
                (r.b = f += P),
                (r.p = l = 8 * L),
                (r.f = s);
              continue;
            }
            if (I === 1) (u = Cx), (h = Mx), (m = 9), (d = 5);
            else if (I === 2) {
              let P = ot(e, l, 31) + 257,
                L = ot(e, l + 10, 15) + 4,
                M = P + ot(e, l + 5, 31) + 1;
              l += 14;
              let _ = new Ue(M),
                F = new Ue(19);
              for (var g = 0; g < L; ++g) F[Ix[g]] = ot(e, l + 3 * g, 7);
              l += 3 * L;
              let w = Ba(F),
                R = (1 << w) - 1,
                k = en(F, w, 1);
              for (g = 0; g < M; ) {
                let ee = k[ot(e, l, R)];
                var c;
                if (((l += 15 & ee), (c = ee >>> 4) < 16)) _[g++] = c;
                else {
                  var v = 0;
                  let A = 0;
                  for (
                    c === 16
                      ? ((A = 3 + ot(e, l, 3)), (l += 2), (v = _[g - 1]))
                      : c === 17
                      ? ((A = 3 + ot(e, l, 7)), (l += 3))
                      : c === 18 && ((A = 11 + ot(e, l, 127)), (l += 7));
                    A--;

                  )
                    _[g++] = v;
                }
              }
              let z = _.subarray(0, P);
              var y = _.subarray(P);
              (m = Ba(z)), (d = Ba(y)), (u = en(z, m, 1)), (h = en(y, d, 1));
            } else We(1);
            if (l > p) {
              a && We(0);
              break;
            }
          }
          i && o(f + 131072);
          let x = (1 << m) - 1,
            S = (1 << d) - 1,
            T = l;
          for (; ; T = l) {
            let I = (v = u[Va(e, l) & x]) >>> 4;
            if (((l += 15 & v), l > p)) {
              a && We(0);
              break;
            }
            if ((v || We(2), I < 256)) t[f++] = I;
            else {
              if (I === 256) {
                (T = l), (u = null);
                break;
              }
              {
                let P = I - 254;
                if (I > 264) {
                  var b = hu[(g = I - 257)];
                  (P = ot(e, l, (1 << b) - 1) + pu[g]), (l += b);
                }
                let L = h[Va(e, l) & S],
                  M = L >>> 4;
                if (
                  (L || We(3),
                  (l += 15 & L),
                  (y = Px[M]),
                  M > 3 &&
                    ((b = fu[M]), (y += Va(e, l) & ((1 << b) - 1)), (l += b)),
                  l > p)
                ) {
                  a && We(0);
                  break;
                }
                i && o(f + 131072);
                let _ = f + P;
                for (; f < _; f += 4)
                  (t[f] = t[f - y]),
                    (t[f + 1] = t[f + 1 - y]),
                    (t[f + 2] = t[f + 2 - y]),
                    (t[f + 3] = t[f + 3 - y]);
                f = _;
              }
            }
          }
          (r.l = u),
            (r.p = T),
            (r.b = f),
            (r.f = s),
            u && ((s = 1), (r.m = m), (r.d = h), (r.n = d));
        } while (!s);
        return f === t.length ? t : za(t, 0, f);
      },
      KW = function (e, t) {
        let r = {};
        for (var n in e) r[n] = e[n];
        for (var n in t) r[n] = t[n];
        return r;
      },
      xx = function (e, t, r) {
        let n = e(),
          i = e.toString(),
          a = i
            .slice(i.indexOf("[") + 1, i.lastIndexOf("]"))
            .replace(/\s+/g, "")
            .split(",");
        for (let o = 0; o < n.length; ++o) {
          let s = n[o],
            l = a[o];
          if (typeof s == "function") {
            t += ";" + l + "=";
            let f = s.toString();
            if (s.prototype)
              if (f.indexOf("[native code]") !== -1) {
                let u = f.indexOf(" ", 8) + 1;
                t += f.slice(u, f.indexOf("(", u));
              } else {
                t += f;
                for (let u in s.prototype)
                  t +=
                    ";" +
                    l +
                    ".prototype." +
                    u +
                    "=" +
                    s.prototype[u].toString();
              }
            else t += f;
          } else r[l] = s;
        }
        return [t, r];
      },
      Na = [],
      YW = function (e) {
        let t = [];
        for (let r in e)
          e[r].buffer && t.push((e[r] = new e[r].constructor(e[r])).buffer);
        return t;
      },
      QW = function (e, t, r, n) {
        let i;
        if (!Na[r]) {
          let o = "",
            s = {},
            l = e.length - 1;
          for (let f = 0; f < l; ++f)
            (i = xx(e[f], o, s)), (o = i[0]), (s = i[1]);
          Na[r] = xx(e[l], o, s);
        }
        let a = KW({}, Na[r][1]);
        return UW(
          Na[r][0] +
            ";onmessage=function(e){for(var kz in e.data)self[kz]=e.data[kz];onmessage=" +
            t.toString() +
            "}",
          r,
          a,
          YW(a),
          n
        );
      },
      ZW = function () {
        return [
          Ue,
          sr,
          cu,
          hu,
          fu,
          Ix,
          pu,
          Px,
          Cx,
          Mx,
          Ga,
          Rx,
          en,
          Ba,
          ot,
          Va,
          Ox,
          za,
          We,
          Dx,
          du,
          Fx,
          Lx,
        ];
      },
      Fx = function (e) {
        return postMessage(e, [e.buffer]);
      },
      Lx = function (e) {
        return e && e.size && new Ue(e.size);
      },
      JW = function (e, t, r, n, i, a) {
        var o = QW(r, n, i, function (s, l) {
          o.terminate(), a(s, l);
        });
        return (
          o.postMessage([e, t], t.consume ? [e.buffer] : []),
          function () {
            o.terminate();
          }
        );
      },
      ar = function (e, t) {
        return e[t] | (e[t + 1] << 8);
      },
      Gt = function (e, t) {
        return (
          (e[t] | (e[t + 1] << 8) | (e[t + 2] << 16) | (e[t + 3] << 24)) >>> 0
        );
      };
    function eU(e, t, r) {
      return (
        r || ((r = t), (t = {})),
        typeof r != "function" && We(7),
        JW(
          e,
          t,
          [ZW],
          function (n) {
            return Fx(du(n.data[0], Lx(n.data[1])));
          },
          1,
          r
        )
      );
    }
    function du(e, t) {
      return Dx(e, t);
    }
    var Sx = typeof TextDecoder < "u" && new TextDecoder(),
      tU = function (e) {
        for (let t = "", r = 0; ; ) {
          let n = e[r++],
            i = (n > 127) + (n > 223) + (n > 239);
          if (r + i > e.length) return [t, za(e, r - 1)];
          i
            ? i === 3
              ? ((n =
                  (((15 & n) << 18) |
                    ((63 & e[r++]) << 12) |
                    ((63 & e[r++]) << 6) |
                    (63 & e[r++])) -
                  65536),
                (t += String.fromCharCode(
                  55296 | (n >> 10),
                  56320 | (1023 & n)
                )))
              : (t +=
                  1 & i
                    ? String.fromCharCode(((31 & n) << 6) | (63 & e[r++]))
                    : String.fromCharCode(
                        ((15 & n) << 12) | ((63 & e[r++]) << 6) | (63 & e[r++])
                      ))
            : (t += String.fromCharCode(n));
        }
      };
    function qx(e, t) {
      if (t) {
        let r = "";
        for (let n = 0; n < e.length; n += 16384)
          r += String.fromCharCode.apply(null, e.subarray(n, n + 16384));
        return r;
      }
      if (Sx) return Sx.decode(e);
      {
        let r = tU(e),
          n = r[0];
        return r[1].length && We(8), n;
      }
    }
    var rU = function (e, t) {
        return t + 30 + ar(e, t + 26) + ar(e, t + 28);
      },
      nU = function (e, t, r) {
        let n = ar(e, t + 28),
          i = qx(e.subarray(t + 46, t + 46 + n), !(2048 & ar(e, t + 8))),
          a = t + 46 + n,
          o = Gt(e, t + 20),
          s =
            r && o === 4294967295
              ? z64e(e, a)
              : [o, Gt(e, t + 24), Gt(e, t + 42)],
          l = s[0],
          f = s[1],
          u = s[2];
        return [ar(e, t + 10), l, f, i, a + ar(e, t + 30) + ar(e, t + 32), u];
      },
      _x =
        typeof queueMicrotask == "function"
          ? queueMicrotask
          : typeof setTimeout == "function"
          ? setTimeout
          : function (e) {
              e();
            };
    function iU(e, t, r) {
      r || ((r = t), (t = {})), typeof r != "function" && We(7);
      let n = [],
        i = function () {
          for (let f = 0; f < n.length; ++f) n[f]();
        },
        a = {},
        o = function (f, u) {
          _x(function () {
            r(f, u);
          });
        };
      _x(function () {
        o = r;
      });
      let s = e.length - 22;
      for (; Gt(e, s) !== 101010256; --s)
        if (!s || e.length - s > 65558) return o(We(13, 0, 1), null), i;
      let l = ar(e, s + 8);
      if (l) {
        let f = l,
          u = Gt(e, s + 16),
          h = u === 4294967295 || f === 65535;
        if (h) {
          let p = Gt(e, s - 12);
          (h = Gt(e, p) === 101075792),
            h && ((f = l = Gt(e, p + 32)), (u = Gt(e, p + 48)));
        }
        let m = t && t.filter,
          d = function () {
            let p = nU(e, u, h),
              g = p[0],
              c = p[1],
              v = p[2],
              y = p[3],
              b = p[4],
              x = p[5],
              S = rU(e, x);
            u = b;
            let T = function (I, P) {
              I ? (i(), o(I, null)) : (P && (a[y] = P), --l || o(null, a));
            };
            if (!m || m({ name: y, size: c, originalSize: v, compression: g }))
              if (g)
                if (g === 8) {
                  let I = e.subarray(S, S + c);
                  if (c < 32e4)
                    try {
                      T(null, du(I, new Ue(v)));
                    } catch (P) {
                      T(P, null);
                    }
                  else n.push(eU(I, { size: v }, T));
                } else T(We(14, "unknown compression type " + g, 1), null);
              else T(null, za(e, S, S + c));
            else T(null, null);
          };
        for (let p = 0; p < f; ++p) d(p);
      } else o(null, {});
      return i;
    }
  });
  function aU(e) {
    let t = JSON.parse(e);
    if (!("animations" in t)) throw new Error("Manifest not found");
    if (t.animations.length === 0)
      throw new Error("No animations listed in the manifest");
    return t;
  }
  function sU(e) {
    let t = new Uint8Array(e, 0, 32);
    return t[0] === 80 && t[1] === 75 && t[2] === 3 && t[3] === 4;
  }
  async function oU(e) {
    return await fetch(new URL(e, window?.location?.href).href).then((t) =>
      t.arrayBuffer()
    );
  }
  async function lU(e) {
    return (
      await new Promise((r) => {
        let n = new FileReader();
        n.readAsDataURL(new Blob([e])), (n.onload = () => r(n.result));
      })
    ).split(",", 2)[1];
  }
  async function uU(e) {
    let t = new Uint8Array(e),
      r = await new Promise((n, i) => {
        (0, Ha.unzip)(t, (a, o) => (a ? i(a) : n(o)));
      });
    return {
      read: (n) => (0, Ha.strFromU8)(r[n]),
      readB64: async (n) => await lU(r[n]),
    };
  }
  async function cU(e, t) {
    if (!("assets" in e)) return e;
    async function r(i) {
      let { p: a } = i;
      if (a == null || t.read(`images/${a}`) == null) return i;
      let o = a.split(".").pop(),
        s = await t.readB64(`images/${a}`);
      if (o?.startsWith("data:")) return (i.p = o), (i.e = 1), i;
      switch (o) {
        case "svg":
        case "svg+xml":
          i.p = `data:image/svg+xml;base64,${s}`;
          break;
        case "png":
        case "jpg":
        case "jpeg":
        case "gif":
        case "webp":
          i.p = `data:image/${o};base64,${s}`;
          break;
        default:
          i.p = `data:;base64,${s}`;
      }
      return (i.e = 1), i;
    }
    return (
      (await Promise.all(e.assets.map(r))).map((i, a) => {
        e.assets[a] = i;
      }),
      e
    );
  }
  async function hU(e) {
    let t = await uU(e),
      r = aU(t.read("manifest.json"));
    return (
      await Promise.all(
        r.animations.map((i) => {
          let a = JSON.parse(t.read(`animations/${i.id}.json`));
          return cU(a, t);
        })
      )
    )[0];
  }
  async function Nx(e) {
    let t = await oU(e);
    return sU(t) ? await hU(t) : JSON.parse(new TextDecoder().decode(t));
  }
  var Ha,
    Bx = Ee(() => {
      "use strict";
      Ha = me(kx());
    });
  var jx = {};
  He(jx, {
    cleanupElement: () => yu,
    createInstance: () => zx,
    destroy: () => dU,
    init: () => Hx,
    ready: () => mU,
  });
  var ja,
    ooe,
    fU,
    pU,
    si,
    gu,
    Wa,
    Vx,
    vu,
    Gx,
    zx,
    yu,
    Hx,
    dU,
    mU,
    Wx = Ee(() => {
      "use strict";
      (ja = me(bo())), (ooe = me(Ex()));
      Bx();
      (fU = (e) => e.Webflow.require("lottie").lottie),
        (pU = (e) => !!(e.Webflow.env("design") || e.Webflow.env("preview"))),
        (si = { Playing: "playing", Stopped: "stopped" }),
        (gu = class {
          _cache = [];
          set(t, r) {
            let n = (0, ja.default)(this._cache, ({ wrapper: i }) => i === t);
            n !== -1 && this._cache.splice(n, 1),
              this._cache.push({ wrapper: t, instance: r });
          }
          delete(t) {
            let r = (0, ja.default)(this._cache, ({ wrapper: n }) => n === t);
            r !== -1 && this._cache.splice(r, 1);
          }
          get(t) {
            let r = (0, ja.default)(this._cache, ({ wrapper: n }) => n === t);
            return r !== -1 ? this._cache[r].instance : null;
          }
        }),
        (Wa = new gu()),
        (Vx = {}),
        (vu = class {
          config = null;
          currentState = si.Stopped;
          animationItem;
          handlers = {
            enterFrame: [],
            complete: [],
            loop: [],
            dataReady: [],
            destroy: [],
            error: [],
          };
          load(t) {
            let n = (t.dataset || Vx).src || "";
            n.endsWith(".lottie")
              ? Nx(n).then((i) => {
                  this._loadAnimation(t, i);
                })
              : this._loadAnimation(t, void 0),
              Wa.set(t, this),
              (this.container = t);
          }
          _loadAnimation(t, r) {
            let n = t.dataset || Vx,
              i = n.src || "",
              a = n.preserveAspectRatio || "xMidYMid meet",
              o = n.renderer || "svg",
              s = parseFloat(n.loop) === 1,
              l = parseFloat(n.direction) || 1,
              f = parseFloat(n.autoplay) === 1,
              u = parseFloat(n.duration) || 0,
              h = parseFloat(n.isIx2Target) === 1,
              m = parseFloat(n.ix2InitialState);
            isNaN(m) && (m = null);
            let d = {
              src: i,
              loop: s,
              autoplay: f,
              renderer: o,
              direction: l,
              duration: u,
              hasIx2: h,
              ix2InitialValue: m,
              preserveAspectRatio: a,
            };
            if (
              this.animationItem &&
              this.config &&
              this.config.src === i &&
              o === this.config.renderer &&
              a === this.config.preserveAspectRatio
            ) {
              if (
                (s !== this.config.loop && this.setLooping(s),
                h ||
                  (l !== this.config.direction && this.setDirection(l),
                  u !== this.config.duration &&
                    (u > 0 && u !== this.duration
                      ? this.setSpeed(this.duration / u)
                      : this.setSpeed(1))),
                f && this.play(),
                m && m !== this.config.ix2InitialValue)
              ) {
                let c = m / 100;
                this.goToFrame(this.frames * c);
              }
              this.config = d;
              return;
            }
            let p = {
                container: t,
                loop: s,
                autoplay: f,
                renderer: o,
                rendererSettings: {
                  preserveAspectRatio: a,
                  progressiveLoad: !0,
                  hideOnTransparent: !0,
                },
              },
              g = t.ownerDocument.defaultView;
            try {
              this.animationItem && this.destroy(),
                (this.animationItem = fU(g).loadAnimation({
                  ...p,
                  ...(r ? { animationData: r } : { path: i }),
                }));
            } catch (c) {
              this.handlers.error.forEach((v) => v(c));
              return;
            }
            this.animationItem &&
              (pU(g) &&
                (this.animationItem.addEventListener("enterFrame", () => {
                  if (!this.isPlaying) return;
                  let {
                      currentFrame: c,
                      totalFrames: v,
                      playDirection: y,
                    } = this.animationItem,
                    b = (c / v) * 100,
                    x = Math.round(y === 1 ? b : 100 - b);
                  this.handlers.enterFrame.forEach((S) => S(x, c));
                }),
                this.animationItem.addEventListener("complete", () => {
                  if (this.currentState !== si.Playing) {
                    this.handlers.complete.forEach((c) => c());
                    return;
                  }
                  if (!this.animationItem.loop) {
                    this.handlers.complete.forEach((c) => c());
                    return;
                  }
                  this.currentState = si.Stopped;
                }),
                this.animationItem.addEventListener("loopComplete", (c) => {
                  this.handlers.loop.forEach((v) => v(c));
                }),
                this.animationItem.addEventListener("data_failed", (c) => {
                  this.handlers.error.forEach((v) => v(c));
                }),
                this.animationItem.addEventListener("error", (c) => {
                  this.handlers.error.forEach((v) => v(c));
                })),
              this.isLoaded
                ? (this.handlers.dataReady.forEach((c) => c()),
                  f && this.play())
                : this.animationItem.addEventListener("data_ready", () => {
                    if (
                      (this.handlers.dataReady.forEach((c) => c()),
                      h ||
                        (this.setDirection(l),
                        u > 0 &&
                          u !== this.duration &&
                          this.setSpeed(this.duration / u),
                        f && this.play()),
                      m)
                    ) {
                      let c = m / 100;
                      this.goToFrame(this.frames * c);
                    }
                  }),
              (this.config = d));
          }
          onFrameChange(t) {
            this.handlers.enterFrame.indexOf(t) === -1 &&
              this.handlers.enterFrame.push(t);
          }
          onPlaybackComplete(t) {
            this.handlers.complete.indexOf(t) === -1 &&
              this.handlers.complete.push(t);
          }
          onLoopComplete(t) {
            this.handlers.loop.indexOf(t) === -1 && this.handlers.loop.push(t);
          }
          onDestroy(t) {
            this.handlers.destroy.indexOf(t) === -1 &&
              this.handlers.destroy.push(t);
          }
          onDataReady(t) {
            this.handlers.dataReady.indexOf(t) === -1 &&
              this.handlers.dataReady.push(t);
          }
          onError(t) {
            this.handlers.error.indexOf(t) === -1 &&
              this.handlers.error.push(t);
          }
          play() {
            if (!this.animationItem) return;
            let t = this.animationItem.playDirection === 1 ? 0 : this.frames;
            this.animationItem.goToAndPlay(t, !0),
              (this.currentState = si.Playing);
          }
          stop() {
            if (this.animationItem) {
              if (this.isPlaying) {
                let { playDirection: t } = this.animationItem,
                  r = t === 1 ? 0 : this.frames;
                this.animationItem.goToAndStop(r, !0);
              }
              this.currentState = si.Stopped;
            }
          }
          destroy() {
            this.animationItem &&
              (this.isPlaying && this.stop(),
              this.handlers.destroy.forEach((t) => t()),
              this.container && Wa.delete(this.container),
              this.animationItem.destroy(),
              Object.keys(this.handlers).forEach(
                (t) => (this.handlers[t].length = 0)
              ),
              (this.animationItem = null),
              (this.container = null),
              (this.config = null));
          }
          get isPlaying() {
            return this.animationItem ? !this.animationItem.isPaused : !1;
          }
          get isPaused() {
            return this.animationItem ? this.animationItem.isPaused : !1;
          }
          get duration() {
            return this.animationItem ? this.animationItem.getDuration() : 0;
          }
          get frames() {
            return this.animationItem ? this.animationItem.totalFrames : 0;
          }
          get direction() {
            return this.animationItem ? this.animationItem.playDirection : 1;
          }
          get isLoaded() {
            return this.animationItem, this.animationItem.isLoaded;
          }
          get ix2InitialValue() {
            return this.config ? this.config.ix2InitialValue : null;
          }
          goToFrame(t) {
            this.animationItem && this.animationItem.setCurrentRawFrameValue(t);
          }
          setSubframe(t) {
            this.animationItem && this.animationItem.setSubframe(t);
          }
          setSpeed(t = 1) {
            this.animationItem &&
              (this.isPlaying && this.stop(), this.animationItem.setSpeed(t));
          }
          setLooping(t) {
            this.animationItem &&
              (this.isPlaying && this.stop(), (this.animationItem.loop = t));
          }
          setDirection(t) {
            this.animationItem &&
              (this.isPlaying && this.stop(),
              this.animationItem.setDirection(t),
              this.goToFrame(t === 1 ? 0 : this.frames));
          }
        }),
        (Gx = () =>
          Array.from(
            document.querySelectorAll('[data-animation-type="lottie"]')
          )),
        (zx = (e) => {
          let t = Wa.get(e);
          return t == null && (t = new vu()), t.load(e), t;
        }),
        (yu = (e) => {
          let t = Wa.get(e);
          t && t.destroy();
        }),
        (Hx = () => {
          Gx().forEach((e) => {
            parseFloat(e.getAttribute("data-is-ix2-target")) === 1 || yu(e),
              zx(e);
          });
        }),
        (dU = () => {
          Gx().forEach(yu);
        }),
        (mU = Hx);
    });
  var Ux = E((exports, module) => {
    typeof navigator < "u" &&
      (function (e, t) {
        typeof exports == "object" && typeof module < "u"
          ? (module.exports = t())
          : typeof define == "function" && define.amd
          ? define(t)
          : ((e = typeof globalThis < "u" ? globalThis : e || self).lottie =
              t());
      })(exports, function () {
        "use strict";
        var svgNS = "http://www.w3.org/2000/svg",
          locationHref = "",
          _useWebWorker = !1,
          initialDefaultFrame = -999999,
          setWebWorker = function (e) {
            _useWebWorker = !!e;
          },
          getWebWorker = function () {
            return _useWebWorker;
          },
          setLocationHref = function (e) {
            locationHref = e;
          },
          getLocationHref = function () {
            return locationHref;
          };
        function createTag(e) {
          return document.createElement(e);
        }
        function extendPrototype(e, t) {
          var r,
            n,
            i = e.length;
          for (r = 0; r < i; r += 1)
            for (var a in (n = e[r].prototype))
              Object.prototype.hasOwnProperty.call(n, a) &&
                (t.prototype[a] = n[a]);
        }
        function getDescriptor(e, t) {
          return Object.getOwnPropertyDescriptor(e, t);
        }
        function createProxyFunction(e) {
          function t() {}
          return (t.prototype = e), t;
        }
        var audioControllerFactory = (function () {
            function e(t) {
              (this.audios = []),
                (this.audioFactory = t),
                (this._volume = 1),
                (this._isMuted = !1);
            }
            return (
              (e.prototype = {
                addAudio: function (t) {
                  this.audios.push(t);
                },
                pause: function () {
                  var t,
                    r = this.audios.length;
                  for (t = 0; t < r; t += 1) this.audios[t].pause();
                },
                resume: function () {
                  var t,
                    r = this.audios.length;
                  for (t = 0; t < r; t += 1) this.audios[t].resume();
                },
                setRate: function (t) {
                  var r,
                    n = this.audios.length;
                  for (r = 0; r < n; r += 1) this.audios[r].setRate(t);
                },
                createAudio: function (t) {
                  return this.audioFactory
                    ? this.audioFactory(t)
                    : window.Howl
                    ? new window.Howl({ src: [t] })
                    : {
                        isPlaying: !1,
                        play: function () {
                          this.isPlaying = !0;
                        },
                        seek: function () {
                          this.isPlaying = !1;
                        },
                        playing: function () {},
                        rate: function () {},
                        setVolume: function () {},
                      };
                },
                setAudioFactory: function (t) {
                  this.audioFactory = t;
                },
                setVolume: function (t) {
                  (this._volume = t), this._updateVolume();
                },
                mute: function () {
                  (this._isMuted = !0), this._updateVolume();
                },
                unmute: function () {
                  (this._isMuted = !1), this._updateVolume();
                },
                getVolume: function () {
                  return this._volume;
                },
                _updateVolume: function () {
                  var t,
                    r = this.audios.length;
                  for (t = 0; t < r; t += 1)
                    this.audios[t].volume(
                      this._volume * (this._isMuted ? 0 : 1)
                    );
                },
              }),
              function () {
                return new e();
              }
            );
          })(),
          createTypedArray = (function () {
            function e(t, r) {
              var n,
                i = 0,
                a = [];
              switch (t) {
                case "int16":
                case "uint8c":
                  n = 1;
                  break;
                default:
                  n = 1.1;
              }
              for (i = 0; i < r; i += 1) a.push(n);
              return a;
            }
            return typeof Uint8ClampedArray == "function" &&
              typeof Float32Array == "function"
              ? function (t, r) {
                  return t === "float32"
                    ? new Float32Array(r)
                    : t === "int16"
                    ? new Int16Array(r)
                    : t === "uint8c"
                    ? new Uint8ClampedArray(r)
                    : e(t, r);
                }
              : e;
          })();
        function createSizedArray(e) {
          return Array.apply(null, { length: e });
        }
        function _typeof$6(e) {
          return (
            (_typeof$6 =
              typeof Symbol == "function" && typeof Symbol.iterator == "symbol"
                ? function (t) {
                    return typeof t;
                  }
                : function (t) {
                    return t &&
                      typeof Symbol == "function" &&
                      t.constructor === Symbol &&
                      t !== Symbol.prototype
                      ? "symbol"
                      : typeof t;
                  }),
            _typeof$6(e)
          );
        }
        var subframeEnabled = !0,
          expressionsPlugin = null,
          expressionsInterfaces = null,
          idPrefix$1 = "",
          isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent),
          _shouldRoundValues = !1,
          bmPow = Math.pow,
          bmSqrt = Math.sqrt,
          bmFloor = Math.floor,
          bmMax = Math.max,
          bmMin = Math.min,
          BMMath = {};
        function ProjectInterface$1() {
          return {};
        }
        (function () {
          var e,
            t = [
              "abs",
              "acos",
              "acosh",
              "asin",
              "asinh",
              "atan",
              "atanh",
              "atan2",
              "ceil",
              "cbrt",
              "expm1",
              "clz32",
              "cos",
              "cosh",
              "exp",
              "floor",
              "fround",
              "hypot",
              "imul",
              "log",
              "log1p",
              "log2",
              "log10",
              "max",
              "min",
              "pow",
              "random",
              "round",
              "sign",
              "sin",
              "sinh",
              "sqrt",
              "tan",
              "tanh",
              "trunc",
              "E",
              "LN10",
              "LN2",
              "LOG10E",
              "LOG2E",
              "PI",
              "SQRT1_2",
              "SQRT2",
            ],
            r = t.length;
          for (e = 0; e < r; e += 1) BMMath[t[e]] = Math[t[e]];
        })(),
          (BMMath.random = Math.random),
          (BMMath.abs = function (e) {
            if (_typeof$6(e) === "object" && e.length) {
              var t,
                r = createSizedArray(e.length),
                n = e.length;
              for (t = 0; t < n; t += 1) r[t] = Math.abs(e[t]);
              return r;
            }
            return Math.abs(e);
          });
        var defaultCurveSegments = 150,
          degToRads = Math.PI / 180,
          roundCorner = 0.5519;
        function roundValues(e) {
          _shouldRoundValues = !!e;
        }
        function bmRnd(e) {
          return _shouldRoundValues ? Math.round(e) : e;
        }
        function styleDiv(e) {
          (e.style.position = "absolute"),
            (e.style.top = 0),
            (e.style.left = 0),
            (e.style.display = "block"),
            (e.style.transformOrigin = "0 0"),
            (e.style.webkitTransformOrigin = "0 0"),
            (e.style.backfaceVisibility = "visible"),
            (e.style.webkitBackfaceVisibility = "visible"),
            (e.style.transformStyle = "preserve-3d"),
            (e.style.webkitTransformStyle = "preserve-3d"),
            (e.style.mozTransformStyle = "preserve-3d");
        }
        function BMEnterFrameEvent(e, t, r, n) {
          (this.type = e),
            (this.currentTime = t),
            (this.totalTime = r),
            (this.direction = n < 0 ? -1 : 1);
        }
        function BMCompleteEvent(e, t) {
          (this.type = e), (this.direction = t < 0 ? -1 : 1);
        }
        function BMCompleteLoopEvent(e, t, r, n) {
          (this.type = e),
            (this.currentLoop = r),
            (this.totalLoops = t),
            (this.direction = n < 0 ? -1 : 1);
        }
        function BMSegmentStartEvent(e, t, r) {
          (this.type = e), (this.firstFrame = t), (this.totalFrames = r);
        }
        function BMDestroyEvent(e, t) {
          (this.type = e), (this.target = t);
        }
        function BMRenderFrameErrorEvent(e, t) {
          (this.type = "renderFrameError"),
            (this.nativeError = e),
            (this.currentTime = t);
        }
        function BMConfigErrorEvent(e) {
          (this.type = "configError"), (this.nativeError = e);
        }
        function BMAnimationConfigErrorEvent(e, t) {
          (this.type = e), (this.nativeError = t);
        }
        var createElementID =
            ((_count = 0),
            function () {
              return idPrefix$1 + "__lottie_element_" + (_count += 1);
            }),
          _count;
        function HSVtoRGB(e, t, r) {
          var n, i, a, o, s, l, f, u;
          switch (
            ((l = r * (1 - t)),
            (f = r * (1 - (s = 6 * e - (o = Math.floor(6 * e))) * t)),
            (u = r * (1 - (1 - s) * t)),
            o % 6)
          ) {
            case 0:
              (n = r), (i = u), (a = l);
              break;
            case 1:
              (n = f), (i = r), (a = l);
              break;
            case 2:
              (n = l), (i = r), (a = u);
              break;
            case 3:
              (n = l), (i = f), (a = r);
              break;
            case 4:
              (n = u), (i = l), (a = r);
              break;
            case 5:
              (n = r), (i = l), (a = f);
          }
          return [n, i, a];
        }
        function RGBtoHSV(e, t, r) {
          var n,
            i = Math.max(e, t, r),
            a = Math.min(e, t, r),
            o = i - a,
            s = i === 0 ? 0 : o / i,
            l = i / 255;
          switch (i) {
            case a:
              n = 0;
              break;
            case e:
              (n = t - r + o * (t < r ? 6 : 0)), (n /= 6 * o);
              break;
            case t:
              (n = r - e + 2 * o), (n /= 6 * o);
              break;
            case r:
              (n = e - t + 4 * o), (n /= 6 * o);
          }
          return [n, s, l];
        }
        function addSaturationToRGB(e, t) {
          var r = RGBtoHSV(255 * e[0], 255 * e[1], 255 * e[2]);
          return (
            (r[1] += t),
            r[1] > 1 ? (r[1] = 1) : r[1] <= 0 && (r[1] = 0),
            HSVtoRGB(r[0], r[1], r[2])
          );
        }
        function addBrightnessToRGB(e, t) {
          var r = RGBtoHSV(255 * e[0], 255 * e[1], 255 * e[2]);
          return (
            (r[2] += t),
            r[2] > 1 ? (r[2] = 1) : r[2] < 0 && (r[2] = 0),
            HSVtoRGB(r[0], r[1], r[2])
          );
        }
        function addHueToRGB(e, t) {
          var r = RGBtoHSV(255 * e[0], 255 * e[1], 255 * e[2]);
          return (
            (r[0] += t / 360),
            r[0] > 1 ? (r[0] -= 1) : r[0] < 0 && (r[0] += 1),
            HSVtoRGB(r[0], r[1], r[2])
          );
        }
        var rgbToHex = (function () {
            var e,
              t,
              r = [];
            for (e = 0; e < 256; e += 1)
              (t = e.toString(16)), (r[e] = t.length === 1 ? "0" + t : t);
            return function (n, i, a) {
              return (
                n < 0 && (n = 0),
                i < 0 && (i = 0),
                a < 0 && (a = 0),
                "#" + r[n] + r[i] + r[a]
              );
            };
          })(),
          setSubframeEnabled = function (e) {
            subframeEnabled = !!e;
          },
          getSubframeEnabled = function () {
            return subframeEnabled;
          },
          setExpressionsPlugin = function (e) {
            expressionsPlugin = e;
          },
          getExpressionsPlugin = function () {
            return expressionsPlugin;
          },
          setExpressionInterfaces = function (e) {
            expressionsInterfaces = e;
          },
          getExpressionInterfaces = function () {
            return expressionsInterfaces;
          },
          setDefaultCurveSegments = function (e) {
            defaultCurveSegments = e;
          },
          getDefaultCurveSegments = function () {
            return defaultCurveSegments;
          },
          setIdPrefix = function (e) {
            idPrefix$1 = e;
          },
          getIdPrefix = function () {
            return idPrefix$1;
          };
        function createNS(e) {
          return document.createElementNS(svgNS, e);
        }
        function _typeof$5(e) {
          return (
            (_typeof$5 =
              typeof Symbol == "function" && typeof Symbol.iterator == "symbol"
                ? function (t) {
                    return typeof t;
                  }
                : function (t) {
                    return t &&
                      typeof Symbol == "function" &&
                      t.constructor === Symbol &&
                      t !== Symbol.prototype
                      ? "symbol"
                      : typeof t;
                  }),
            _typeof$5(e)
          );
        }
        var dataManager = (function () {
            var e,
              t,
              r = 1,
              n = [],
              i = {
                onmessage: function () {},
                postMessage: function (l) {
                  e({ data: l });
                },
              },
              a = {
                postMessage: function (l) {
                  i.onmessage({ data: l });
                },
              };
            function o() {
              t ||
                ((t = (function (l) {
                  if (window.Worker && window.Blob && getWebWorker()) {
                    var f = new Blob(
                        [
                          "var _workerSelf = self; self.onmessage = ",
                          l.toString(),
                        ],
                        { type: "text/javascript" }
                      ),
                      u = URL.createObjectURL(f);
                    return new Worker(u);
                  }
                  return (e = l), i;
                })(function (l) {
                  if (
                    (a.dataManager ||
                      (a.dataManager = (function () {
                        function u(I, P) {
                          var L,
                            M,
                            _,
                            F,
                            w,
                            R,
                            k = I.length;
                          for (M = 0; M < k; M += 1)
                            if ("ks" in (L = I[M]) && !L.completed) {
                              if (((L.completed = !0), L.hasMask)) {
                                var z = L.masksProperties;
                                for (F = z.length, _ = 0; _ < F; _ += 1)
                                  if (z[_].pt.k.i) d(z[_].pt.k);
                                  else
                                    for (
                                      R = z[_].pt.k.length, w = 0;
                                      w < R;
                                      w += 1
                                    )
                                      z[_].pt.k[w].s && d(z[_].pt.k[w].s[0]),
                                        z[_].pt.k[w].e && d(z[_].pt.k[w].e[0]);
                              }
                              L.ty === 0
                                ? ((L.layers = h(L.refId, P)), u(L.layers, P))
                                : L.ty === 4
                                ? m(L.shapes)
                                : L.ty === 5 && S(L);
                            }
                        }
                        function h(I, P) {
                          var L = (function (M, _) {
                            for (var F = 0, w = _.length; F < w; ) {
                              if (_[F].id === M) return _[F];
                              F += 1;
                            }
                            return null;
                          })(I, P);
                          return L
                            ? L.layers.__used
                              ? JSON.parse(JSON.stringify(L.layers))
                              : ((L.layers.__used = !0), L.layers)
                            : null;
                        }
                        function m(I) {
                          var P, L, M;
                          for (P = I.length - 1; P >= 0; P -= 1)
                            if (I[P].ty === "sh")
                              if (I[P].ks.k.i) d(I[P].ks.k);
                              else
                                for (M = I[P].ks.k.length, L = 0; L < M; L += 1)
                                  I[P].ks.k[L].s && d(I[P].ks.k[L].s[0]),
                                    I[P].ks.k[L].e && d(I[P].ks.k[L].e[0]);
                            else I[P].ty === "gr" && m(I[P].it);
                        }
                        function d(I) {
                          var P,
                            L = I.i.length;
                          for (P = 0; P < L; P += 1)
                            (I.i[P][0] += I.v[P][0]),
                              (I.i[P][1] += I.v[P][1]),
                              (I.o[P][0] += I.v[P][0]),
                              (I.o[P][1] += I.v[P][1]);
                        }
                        function p(I, P) {
                          var L = P ? P.split(".") : [100, 100, 100];
                          return (
                            I[0] > L[0] ||
                            (!(L[0] > I[0]) &&
                              (I[1] > L[1] ||
                                (!(L[1] > I[1]) &&
                                  (I[2] > L[2] || (!(L[2] > I[2]) && null)))))
                          );
                        }
                        var g,
                          c = (function () {
                            var I = [4, 4, 14];
                            function P(L) {
                              var M,
                                _,
                                F,
                                w = L.length;
                              for (M = 0; M < w; M += 1)
                                L[M].ty === 5 &&
                                  ((F = void 0),
                                  (F = (_ = L[M]).t.d),
                                  (_.t.d = { k: [{ s: F, t: 0 }] }));
                            }
                            return function (L) {
                              if (p(I, L.v) && (P(L.layers), L.assets)) {
                                var M,
                                  _ = L.assets.length;
                                for (M = 0; M < _; M += 1)
                                  L.assets[M].layers && P(L.assets[M].layers);
                              }
                            };
                          })(),
                          v =
                            ((g = [4, 7, 99]),
                            function (I) {
                              if (I.chars && !p(g, I.v)) {
                                var P,
                                  L = I.chars.length;
                                for (P = 0; P < L; P += 1) {
                                  var M = I.chars[P];
                                  M.data &&
                                    M.data.shapes &&
                                    (m(M.data.shapes),
                                    (M.data.ip = 0),
                                    (M.data.op = 99999),
                                    (M.data.st = 0),
                                    (M.data.sr = 1),
                                    (M.data.ks = {
                                      p: { k: [0, 0], a: 0 },
                                      s: { k: [100, 100], a: 0 },
                                      a: { k: [0, 0], a: 0 },
                                      r: { k: 0, a: 0 },
                                      o: { k: 100, a: 0 },
                                    }),
                                    I.chars[P].t ||
                                      (M.data.shapes.push({ ty: "no" }),
                                      M.data.shapes[0].it.push({
                                        p: { k: [0, 0], a: 0 },
                                        s: { k: [100, 100], a: 0 },
                                        a: { k: [0, 0], a: 0 },
                                        r: { k: 0, a: 0 },
                                        o: { k: 100, a: 0 },
                                        sk: { k: 0, a: 0 },
                                        sa: { k: 0, a: 0 },
                                        ty: "tr",
                                      })));
                                }
                              }
                            }),
                          y = (function () {
                            var I = [5, 7, 15];
                            function P(L) {
                              var M,
                                _,
                                F = L.length;
                              for (M = 0; M < F; M += 1)
                                L[M].ty === 5 &&
                                  ((_ = void 0),
                                  typeof (_ = L[M].t.p).a == "number" &&
                                    (_.a = { a: 0, k: _.a }),
                                  typeof _.p == "number" &&
                                    (_.p = { a: 0, k: _.p }),
                                  typeof _.r == "number" &&
                                    (_.r = { a: 0, k: _.r }));
                            }
                            return function (L) {
                              if (p(I, L.v) && (P(L.layers), L.assets)) {
                                var M,
                                  _ = L.assets.length;
                                for (M = 0; M < _; M += 1)
                                  L.assets[M].layers && P(L.assets[M].layers);
                              }
                            };
                          })(),
                          b = (function () {
                            var I = [4, 1, 9];
                            function P(M) {
                              var _,
                                F,
                                w,
                                R = M.length;
                              for (_ = 0; _ < R; _ += 1)
                                if (M[_].ty === "gr") P(M[_].it);
                                else if (M[_].ty === "fl" || M[_].ty === "st")
                                  if (M[_].c.k && M[_].c.k[0].i)
                                    for (
                                      w = M[_].c.k.length, F = 0;
                                      F < w;
                                      F += 1
                                    )
                                      M[_].c.k[F].s &&
                                        ((M[_].c.k[F].s[0] /= 255),
                                        (M[_].c.k[F].s[1] /= 255),
                                        (M[_].c.k[F].s[2] /= 255),
                                        (M[_].c.k[F].s[3] /= 255)),
                                        M[_].c.k[F].e &&
                                          ((M[_].c.k[F].e[0] /= 255),
                                          (M[_].c.k[F].e[1] /= 255),
                                          (M[_].c.k[F].e[2] /= 255),
                                          (M[_].c.k[F].e[3] /= 255));
                                  else
                                    (M[_].c.k[0] /= 255),
                                      (M[_].c.k[1] /= 255),
                                      (M[_].c.k[2] /= 255),
                                      (M[_].c.k[3] /= 255);
                            }
                            function L(M) {
                              var _,
                                F = M.length;
                              for (_ = 0; _ < F; _ += 1)
                                M[_].ty === 4 && P(M[_].shapes);
                            }
                            return function (M) {
                              if (p(I, M.v) && (L(M.layers), M.assets)) {
                                var _,
                                  F = M.assets.length;
                                for (_ = 0; _ < F; _ += 1)
                                  M.assets[_].layers && L(M.assets[_].layers);
                              }
                            };
                          })(),
                          x = (function () {
                            var I = [4, 4, 18];
                            function P(M) {
                              var _, F, w;
                              for (_ = M.length - 1; _ >= 0; _ -= 1)
                                if (M[_].ty === "sh")
                                  if (M[_].ks.k.i) M[_].ks.k.c = M[_].closed;
                                  else
                                    for (
                                      w = M[_].ks.k.length, F = 0;
                                      F < w;
                                      F += 1
                                    )
                                      M[_].ks.k[F].s &&
                                        (M[_].ks.k[F].s[0].c = M[_].closed),
                                        M[_].ks.k[F].e &&
                                          (M[_].ks.k[F].e[0].c = M[_].closed);
                                else M[_].ty === "gr" && P(M[_].it);
                            }
                            function L(M) {
                              var _,
                                F,
                                w,
                                R,
                                k,
                                z,
                                ee = M.length;
                              for (F = 0; F < ee; F += 1) {
                                if ((_ = M[F]).hasMask) {
                                  var A = _.masksProperties;
                                  for (R = A.length, w = 0; w < R; w += 1)
                                    if (A[w].pt.k.i) A[w].pt.k.c = A[w].cl;
                                    else
                                      for (
                                        z = A[w].pt.k.length, k = 0;
                                        k < z;
                                        k += 1
                                      )
                                        A[w].pt.k[k].s &&
                                          (A[w].pt.k[k].s[0].c = A[w].cl),
                                          A[w].pt.k[k].e &&
                                            (A[w].pt.k[k].e[0].c = A[w].cl);
                                }
                                _.ty === 4 && P(_.shapes);
                              }
                            }
                            return function (M) {
                              if (p(I, M.v) && (L(M.layers), M.assets)) {
                                var _,
                                  F = M.assets.length;
                                for (_ = 0; _ < F; _ += 1)
                                  M.assets[_].layers && L(M.assets[_].layers);
                              }
                            };
                          })();
                        function S(I) {
                          I.t.a.length === 0 && I.t.p;
                        }
                        var T = {
                          completeData: function (I) {
                            I.__complete ||
                              (b(I),
                              c(I),
                              v(I),
                              y(I),
                              x(I),
                              u(I.layers, I.assets),
                              (function (P, L) {
                                if (P) {
                                  var M = 0,
                                    _ = P.length;
                                  for (M = 0; M < _; M += 1)
                                    P[M].t === 1 &&
                                      ((P[M].data.layers = h(
                                        P[M].data.refId,
                                        L
                                      )),
                                      u(P[M].data.layers, L));
                                }
                              })(I.chars, I.assets),
                              (I.__complete = !0));
                          },
                        };
                        return (
                          (T.checkColors = b),
                          (T.checkChars = v),
                          (T.checkPathProperties = y),
                          (T.checkShapes = x),
                          (T.completeLayers = u),
                          T
                        );
                      })()),
                    a.assetLoader ||
                      (a.assetLoader = (function () {
                        function u(h) {
                          var m = h.getResponseHeader("content-type");
                          return (m &&
                            h.responseType === "json" &&
                            m.indexOf("json") !== -1) ||
                            (h.response && _typeof$5(h.response) === "object")
                            ? h.response
                            : h.response && typeof h.response == "string"
                            ? JSON.parse(h.response)
                            : h.responseText
                            ? JSON.parse(h.responseText)
                            : null;
                        }
                        return {
                          load: function (h, m, d, p) {
                            var g,
                              c = new XMLHttpRequest();
                            try {
                              c.responseType = "json";
                            } catch {}
                            c.onreadystatechange = function () {
                              if (c.readyState === 4)
                                if (c.status === 200) (g = u(c)), d(g);
                                else
                                  try {
                                    (g = u(c)), d(g);
                                  } catch (v) {
                                    p && p(v);
                                  }
                            };
                            try {
                              c.open(["G", "E", "T"].join(""), h, !0);
                            } catch {
                              c.open(["G", "E", "T"].join(""), m + "/" + h, !0);
                            }
                            c.send();
                          },
                        };
                      })()),
                    l.data.type === "loadAnimation")
                  )
                    a.assetLoader.load(
                      l.data.path,
                      l.data.fullPath,
                      function (u) {
                        a.dataManager.completeData(u),
                          a.postMessage({
                            id: l.data.id,
                            payload: u,
                            status: "success",
                          });
                      },
                      function () {
                        a.postMessage({ id: l.data.id, status: "error" });
                      }
                    );
                  else if (l.data.type === "complete") {
                    var f = l.data.animation;
                    a.dataManager.completeData(f),
                      a.postMessage({
                        id: l.data.id,
                        payload: f,
                        status: "success",
                      });
                  } else
                    l.data.type === "loadData" &&
                      a.assetLoader.load(
                        l.data.path,
                        l.data.fullPath,
                        function (u) {
                          a.postMessage({
                            id: l.data.id,
                            payload: u,
                            status: "success",
                          });
                        },
                        function () {
                          a.postMessage({ id: l.data.id, status: "error" });
                        }
                      );
                })),
                (t.onmessage = function (l) {
                  var f = l.data,
                    u = f.id,
                    h = n[u];
                  (n[u] = null),
                    f.status === "success"
                      ? h.onComplete(f.payload)
                      : h.onError && h.onError();
                }));
            }
            function s(l, f) {
              var u = "processId_" + (r += 1);
              return (n[u] = { onComplete: l, onError: f }), u;
            }
            return {
              loadAnimation: function (l, f, u) {
                o();
                var h = s(f, u);
                t.postMessage({
                  type: "loadAnimation",
                  path: l,
                  fullPath: window.location.origin + window.location.pathname,
                  id: h,
                });
              },
              loadData: function (l, f, u) {
                o();
                var h = s(f, u);
                t.postMessage({
                  type: "loadData",
                  path: l,
                  fullPath: window.location.origin + window.location.pathname,
                  id: h,
                });
              },
              completeAnimation: function (l, f, u) {
                o();
                var h = s(f, u);
                t.postMessage({ type: "complete", animation: l, id: h });
              },
            };
          })(),
          ImagePreloader = (function () {
            var e = (function () {
              var s = createTag("canvas");
              (s.width = 1), (s.height = 1);
              var l = s.getContext("2d");
              return (l.fillStyle = "rgba(0,0,0,0)"), l.fillRect(0, 0, 1, 1), s;
            })();
            function t() {
              (this.loadedAssets += 1),
                this.loadedAssets === this.totalImages &&
                  this.loadedFootagesCount === this.totalFootages &&
                  this.imagesLoadedCb &&
                  this.imagesLoadedCb(null);
            }
            function r() {
              (this.loadedFootagesCount += 1),
                this.loadedAssets === this.totalImages &&
                  this.loadedFootagesCount === this.totalFootages &&
                  this.imagesLoadedCb &&
                  this.imagesLoadedCb(null);
            }
            function n(s, l, f) {
              var u = "";
              if (s.e) u = s.p;
              else if (l) {
                var h = s.p;
                h.indexOf("images/") !== -1 && (h = h.split("/")[1]),
                  (u = l + h);
              } else (u = f), (u += s.u ? s.u : ""), (u += s.p);
              return u;
            }
            function i(s) {
              var l = 0,
                f = setInterval(
                  function () {
                    (s.getBBox().width || l > 500) &&
                      (this._imageLoaded(), clearInterval(f)),
                      (l += 1);
                  }.bind(this),
                  50
                );
            }
            function a(s) {
              var l = { assetData: s },
                f = n(s, this.assetsPath, this.path);
              return (
                dataManager.loadData(
                  f,
                  function (u) {
                    (l.img = u), this._footageLoaded();
                  }.bind(this),
                  function () {
                    (l.img = {}), this._footageLoaded();
                  }.bind(this)
                ),
                l
              );
            }
            function o() {
              (this._imageLoaded = t.bind(this)),
                (this._footageLoaded = r.bind(this)),
                (this.testImageLoaded = i.bind(this)),
                (this.createFootageData = a.bind(this)),
                (this.assetsPath = ""),
                (this.path = ""),
                (this.totalImages = 0),
                (this.totalFootages = 0),
                (this.loadedAssets = 0),
                (this.loadedFootagesCount = 0),
                (this.imagesLoadedCb = null),
                (this.images = []);
            }
            return (
              (o.prototype = {
                loadAssets: function (s, l) {
                  var f;
                  this.imagesLoadedCb = l;
                  var u = s.length;
                  for (f = 0; f < u; f += 1)
                    s[f].layers ||
                      (s[f].t && s[f].t !== "seq"
                        ? s[f].t === 3 &&
                          ((this.totalFootages += 1),
                          this.images.push(this.createFootageData(s[f])))
                        : ((this.totalImages += 1),
                          this.images.push(this._createImageData(s[f]))));
                },
                setAssetsPath: function (s) {
                  this.assetsPath = s || "";
                },
                setPath: function (s) {
                  this.path = s || "";
                },
                loadedImages: function () {
                  return this.totalImages === this.loadedAssets;
                },
                loadedFootages: function () {
                  return this.totalFootages === this.loadedFootagesCount;
                },
                destroy: function () {
                  (this.imagesLoadedCb = null), (this.images.length = 0);
                },
                getAsset: function (s) {
                  for (var l = 0, f = this.images.length; l < f; ) {
                    if (this.images[l].assetData === s)
                      return this.images[l].img;
                    l += 1;
                  }
                  return null;
                },
                createImgData: function (s) {
                  var l = n(s, this.assetsPath, this.path),
                    f = createTag("img");
                  (f.crossOrigin = "anonymous"),
                    f.addEventListener("load", this._imageLoaded, !1),
                    f.addEventListener(
                      "error",
                      function () {
                        (u.img = e), this._imageLoaded();
                      }.bind(this),
                      !1
                    ),
                    (f.src = l);
                  var u = { img: f, assetData: s };
                  return u;
                },
                createImageData: function (s) {
                  var l = n(s, this.assetsPath, this.path),
                    f = createNS("image");
                  isSafari
                    ? this.testImageLoaded(f)
                    : f.addEventListener("load", this._imageLoaded, !1),
                    f.addEventListener(
                      "error",
                      function () {
                        (u.img = e), this._imageLoaded();
                      }.bind(this),
                      !1
                    ),
                    f.setAttributeNS("http://www.w3.org/1999/xlink", "href", l),
                    this._elementHelper.append
                      ? this._elementHelper.append(f)
                      : this._elementHelper.appendChild(f);
                  var u = { img: f, assetData: s };
                  return u;
                },
                imageLoaded: t,
                footageLoaded: r,
                setCacheType: function (s, l) {
                  s === "svg"
                    ? ((this._elementHelper = l),
                      (this._createImageData = this.createImageData.bind(this)))
                    : (this._createImageData = this.createImgData.bind(this));
                },
              }),
              o
            );
          })();
        function BaseEvent() {}
        BaseEvent.prototype = {
          triggerEvent: function (e, t) {
            if (this._cbs[e])
              for (var r = this._cbs[e], n = 0; n < r.length; n += 1) r[n](t);
          },
          addEventListener: function (e, t) {
            return (
              this._cbs[e] || (this._cbs[e] = []),
              this._cbs[e].push(t),
              function () {
                this.removeEventListener(e, t);
              }.bind(this)
            );
          },
          removeEventListener: function (e, t) {
            if (t) {
              if (this._cbs[e]) {
                for (var r = 0, n = this._cbs[e].length; r < n; )
                  this._cbs[e][r] === t &&
                    (this._cbs[e].splice(r, 1), (r -= 1), (n -= 1)),
                    (r += 1);
                this._cbs[e].length || (this._cbs[e] = null);
              }
            } else this._cbs[e] = null;
          },
        };
        var markerParser = (function () {
            function e(t) {
              for (
                var r,
                  n = t.split(`\r
    `),
                  i = {},
                  a = 0,
                  o = 0;
                o < n.length;
                o += 1
              )
                (r = n[o].split(":")).length === 2 &&
                  ((i[r[0]] = r[1].trim()), (a += 1));
              if (a === 0) throw new Error();
              return i;
            }
            return function (t) {
              for (var r = [], n = 0; n < t.length; n += 1) {
                var i = t[n],
                  a = { time: i.tm, duration: i.dr };
                try {
                  a.payload = JSON.parse(t[n].cm);
                } catch {
                  try {
                    a.payload = e(t[n].cm);
                  } catch {
                    a.payload = { name: t[n].cm };
                  }
                }
                r.push(a);
              }
              return r;
            };
          })(),
          ProjectInterface = (function () {
            function e(t) {
              this.compositions.push(t);
            }
            return function () {
              function t(r) {
                for (var n = 0, i = this.compositions.length; n < i; ) {
                  if (
                    this.compositions[n].data &&
                    this.compositions[n].data.nm === r
                  )
                    return (
                      this.compositions[n].prepareFrame &&
                        this.compositions[n].data.xt &&
                        this.compositions[n].prepareFrame(this.currentFrame),
                      this.compositions[n].compInterface
                    );
                  n += 1;
                }
                return null;
              }
              return (
                (t.compositions = []),
                (t.currentFrame = 0),
                (t.registerComposition = e),
                t
              );
            };
          })(),
          renderers = {},
          registerRenderer = function (e, t) {
            renderers[e] = t;
          };
        function getRenderer(e) {
          return renderers[e];
        }
        function getRegisteredRenderer() {
          if (renderers.canvas) return "canvas";
          for (var e in renderers) if (renderers[e]) return e;
          return "";
        }
        function _typeof$4(e) {
          return (
            (_typeof$4 =
              typeof Symbol == "function" && typeof Symbol.iterator == "symbol"
                ? function (t) {
                    return typeof t;
                  }
                : function (t) {
                    return t &&
                      typeof Symbol == "function" &&
                      t.constructor === Symbol &&
                      t !== Symbol.prototype
                      ? "symbol"
                      : typeof t;
                  }),
            _typeof$4(e)
          );
        }
        var AnimationItem = function () {
          (this._cbs = []),
            (this.name = ""),
            (this.path = ""),
            (this.isLoaded = !1),
            (this.currentFrame = 0),
            (this.currentRawFrame = 0),
            (this.firstFrame = 0),
            (this.totalFrames = 0),
            (this.frameRate = 0),
            (this.frameMult = 0),
            (this.playSpeed = 1),
            (this.playDirection = 1),
            (this.playCount = 0),
            (this.animationData = {}),
            (this.assets = []),
            (this.isPaused = !0),
            (this.autoplay = !1),
            (this.loop = !0),
            (this.renderer = null),
            (this.animationID = createElementID()),
            (this.assetsPath = ""),
            (this.timeCompleted = 0),
            (this.segmentPos = 0),
            (this.isSubframeEnabled = getSubframeEnabled()),
            (this.segments = []),
            (this._idle = !0),
            (this._completedLoop = !1),
            (this.projectInterface = ProjectInterface()),
            (this.imagePreloader = new ImagePreloader()),
            (this.audioController = audioControllerFactory()),
            (this.markers = []),
            (this.configAnimation = this.configAnimation.bind(this)),
            (this.onSetupError = this.onSetupError.bind(this)),
            (this.onSegmentComplete = this.onSegmentComplete.bind(this)),
            (this.drawnFrameEvent = new BMEnterFrameEvent(
              "drawnFrame",
              0,
              0,
              0
            )),
            (this.expressionsPlugin = getExpressionsPlugin());
        };
        extendPrototype([BaseEvent], AnimationItem),
          (AnimationItem.prototype.setParams = function (e) {
            (e.wrapper || e.container) &&
              (this.wrapper = e.wrapper || e.container);
            var t = "svg";
            e.animType ? (t = e.animType) : e.renderer && (t = e.renderer);
            var r = getRenderer(t);
            (this.renderer = new r(this, e.rendererSettings)),
              this.imagePreloader.setCacheType(
                t,
                this.renderer.globalData.defs
              ),
              this.renderer.setProjectInterface(this.projectInterface),
              (this.animType = t),
              e.loop === "" ||
              e.loop === null ||
              e.loop === void 0 ||
              e.loop === !0
                ? (this.loop = !0)
                : e.loop === !1
                ? (this.loop = !1)
                : (this.loop = parseInt(e.loop, 10)),
              (this.autoplay = !("autoplay" in e) || e.autoplay),
              (this.name = e.name ? e.name : ""),
              (this.autoloadSegments =
                !Object.prototype.hasOwnProperty.call(e, "autoloadSegments") ||
                e.autoloadSegments),
              (this.assetsPath = e.assetsPath),
              (this.initialSegment = e.initialSegment),
              e.audioFactory &&
                this.audioController.setAudioFactory(e.audioFactory),
              e.animationData
                ? this.setupAnimation(e.animationData)
                : e.path &&
                  (e.path.lastIndexOf("\\") !== -1
                    ? (this.path = e.path.substr(
                        0,
                        e.path.lastIndexOf("\\") + 1
                      ))
                    : (this.path = e.path.substr(
                        0,
                        e.path.lastIndexOf("/") + 1
                      )),
                  (this.fileName = e.path.substr(e.path.lastIndexOf("/") + 1)),
                  (this.fileName = this.fileName.substr(
                    0,
                    this.fileName.lastIndexOf(".json")
                  )),
                  dataManager.loadAnimation(
                    e.path,
                    this.configAnimation,
                    this.onSetupError
                  ));
          }),
          (AnimationItem.prototype.onSetupError = function () {
            this.trigger("data_failed");
          }),
          (AnimationItem.prototype.setupAnimation = function (e) {
            dataManager.completeAnimation(e, this.configAnimation);
          }),
          (AnimationItem.prototype.setData = function (e, t) {
            t && _typeof$4(t) !== "object" && (t = JSON.parse(t));
            var r = { wrapper: e, animationData: t },
              n = e.attributes;
            (r.path = n.getNamedItem("data-animation-path")
              ? n.getNamedItem("data-animation-path").value
              : n.getNamedItem("data-bm-path")
              ? n.getNamedItem("data-bm-path").value
              : n.getNamedItem("bm-path")
              ? n.getNamedItem("bm-path").value
              : ""),
              (r.animType = n.getNamedItem("data-anim-type")
                ? n.getNamedItem("data-anim-type").value
                : n.getNamedItem("data-bm-type")
                ? n.getNamedItem("data-bm-type").value
                : n.getNamedItem("bm-type")
                ? n.getNamedItem("bm-type").value
                : n.getNamedItem("data-bm-renderer")
                ? n.getNamedItem("data-bm-renderer").value
                : n.getNamedItem("bm-renderer")
                ? n.getNamedItem("bm-renderer").value
                : getRegisteredRenderer() || "canvas");
            var i = n.getNamedItem("data-anim-loop")
              ? n.getNamedItem("data-anim-loop").value
              : n.getNamedItem("data-bm-loop")
              ? n.getNamedItem("data-bm-loop").value
              : n.getNamedItem("bm-loop")
              ? n.getNamedItem("bm-loop").value
              : "";
            i === "false"
              ? (r.loop = !1)
              : i === "true"
              ? (r.loop = !0)
              : i !== "" && (r.loop = parseInt(i, 10));
            var a = n.getNamedItem("data-anim-autoplay")
              ? n.getNamedItem("data-anim-autoplay").value
              : n.getNamedItem("data-bm-autoplay")
              ? n.getNamedItem("data-bm-autoplay").value
              : !n.getNamedItem("bm-autoplay") ||
                n.getNamedItem("bm-autoplay").value;
            (r.autoplay = a !== "false"),
              (r.name = n.getNamedItem("data-name")
                ? n.getNamedItem("data-name").value
                : n.getNamedItem("data-bm-name")
                ? n.getNamedItem("data-bm-name").value
                : n.getNamedItem("bm-name")
                ? n.getNamedItem("bm-name").value
                : ""),
              (n.getNamedItem("data-anim-prerender")
                ? n.getNamedItem("data-anim-prerender").value
                : n.getNamedItem("data-bm-prerender")
                ? n.getNamedItem("data-bm-prerender").value
                : n.getNamedItem("bm-prerender")
                ? n.getNamedItem("bm-prerender").value
                : "") === "false" && (r.prerender = !1),
              r.path ? this.setParams(r) : this.trigger("destroy");
          }),
          (AnimationItem.prototype.includeLayers = function (e) {
            e.op > this.animationData.op &&
              ((this.animationData.op = e.op),
              (this.totalFrames = Math.floor(e.op - this.animationData.ip)));
            var t,
              r,
              n = this.animationData.layers,
              i = n.length,
              a = e.layers,
              o = a.length;
            for (r = 0; r < o; r += 1)
              for (t = 0; t < i; ) {
                if (n[t].id === a[r].id) {
                  n[t] = a[r];
                  break;
                }
                t += 1;
              }
            if (
              ((e.chars || e.fonts) &&
                (this.renderer.globalData.fontManager.addChars(e.chars),
                this.renderer.globalData.fontManager.addFonts(
                  e.fonts,
                  this.renderer.globalData.defs
                )),
              e.assets)
            )
              for (i = e.assets.length, t = 0; t < i; t += 1)
                this.animationData.assets.push(e.assets[t]);
            (this.animationData.__complete = !1),
              dataManager.completeAnimation(
                this.animationData,
                this.onSegmentComplete
              );
          }),
          (AnimationItem.prototype.onSegmentComplete = function (e) {
            this.animationData = e;
            var t = getExpressionsPlugin();
            t && t.initExpressions(this), this.loadNextSegment();
          }),
          (AnimationItem.prototype.loadNextSegment = function () {
            var e = this.animationData.segments;
            if (!e || e.length === 0 || !this.autoloadSegments)
              return (
                this.trigger("data_ready"),
                void (this.timeCompleted = this.totalFrames)
              );
            var t = e.shift();
            this.timeCompleted = t.time * this.frameRate;
            var r = this.path + this.fileName + "_" + this.segmentPos + ".json";
            (this.segmentPos += 1),
              dataManager.loadData(
                r,
                this.includeLayers.bind(this),
                function () {
                  this.trigger("data_failed");
                }.bind(this)
              );
          }),
          (AnimationItem.prototype.loadSegments = function () {
            this.animationData.segments ||
              (this.timeCompleted = this.totalFrames),
              this.loadNextSegment();
          }),
          (AnimationItem.prototype.imagesLoaded = function () {
            this.trigger("loaded_images"), this.checkLoaded();
          }),
          (AnimationItem.prototype.preloadImages = function () {
            this.imagePreloader.setAssetsPath(this.assetsPath),
              this.imagePreloader.setPath(this.path),
              this.imagePreloader.loadAssets(
                this.animationData.assets,
                this.imagesLoaded.bind(this)
              );
          }),
          (AnimationItem.prototype.configAnimation = function (e) {
            if (this.renderer)
              try {
                (this.animationData = e),
                  this.initialSegment
                    ? ((this.totalFrames = Math.floor(
                        this.initialSegment[1] - this.initialSegment[0]
                      )),
                      (this.firstFrame = Math.round(this.initialSegment[0])))
                    : ((this.totalFrames = Math.floor(
                        this.animationData.op - this.animationData.ip
                      )),
                      (this.firstFrame = Math.round(this.animationData.ip))),
                  this.renderer.configAnimation(e),
                  e.assets || (e.assets = []),
                  (this.assets = this.animationData.assets),
                  (this.frameRate = this.animationData.fr),
                  (this.frameMult = this.animationData.fr / 1e3),
                  this.renderer.searchExtraCompositions(e.assets),
                  (this.markers = markerParser(e.markers || [])),
                  this.trigger("config_ready"),
                  this.preloadImages(),
                  this.loadSegments(),
                  this.updaFrameModifier(),
                  this.waitForFontsLoaded(),
                  this.isPaused && this.audioController.pause();
              } catch (t) {
                this.triggerConfigError(t);
              }
          }),
          (AnimationItem.prototype.waitForFontsLoaded = function () {
            this.renderer &&
              (this.renderer.globalData.fontManager.isLoaded
                ? this.checkLoaded()
                : setTimeout(this.waitForFontsLoaded.bind(this), 20));
          }),
          (AnimationItem.prototype.checkLoaded = function () {
            if (
              !this.isLoaded &&
              this.renderer.globalData.fontManager.isLoaded &&
              (this.imagePreloader.loadedImages() ||
                this.renderer.rendererType !== "canvas") &&
              this.imagePreloader.loadedFootages()
            ) {
              this.isLoaded = !0;
              var e = getExpressionsPlugin();
              e && e.initExpressions(this),
                this.renderer.initItems(),
                setTimeout(
                  function () {
                    this.trigger("DOMLoaded");
                  }.bind(this),
                  0
                ),
                this.gotoFrame(),
                this.autoplay && this.play();
            }
          }),
          (AnimationItem.prototype.resize = function (e, t) {
            var r = typeof e == "number" ? e : void 0,
              n = typeof t == "number" ? t : void 0;
            this.renderer.updateContainerSize(r, n);
          }),
          (AnimationItem.prototype.setSubframe = function (e) {
            this.isSubframeEnabled = !!e;
          }),
          (AnimationItem.prototype.gotoFrame = function () {
            (this.currentFrame = this.isSubframeEnabled
              ? this.currentRawFrame
              : ~~this.currentRawFrame),
              this.timeCompleted !== this.totalFrames &&
                this.currentFrame > this.timeCompleted &&
                (this.currentFrame = this.timeCompleted),
              this.trigger("enterFrame"),
              this.renderFrame(),
              this.trigger("drawnFrame");
          }),
          (AnimationItem.prototype.renderFrame = function () {
            if (this.isLoaded !== !1 && this.renderer)
              try {
                this.expressionsPlugin && this.expressionsPlugin.resetFrame(),
                  this.renderer.renderFrame(
                    this.currentFrame + this.firstFrame
                  );
              } catch (e) {
                this.triggerRenderFrameError(e);
              }
          }),
          (AnimationItem.prototype.play = function (e) {
            (e && this.name !== e) ||
              (this.isPaused === !0 &&
                ((this.isPaused = !1),
                this.trigger("_play"),
                this.audioController.resume(),
                this._idle && ((this._idle = !1), this.trigger("_active"))));
          }),
          (AnimationItem.prototype.pause = function (e) {
            (e && this.name !== e) ||
              (this.isPaused === !1 &&
                ((this.isPaused = !0),
                this.trigger("_pause"),
                (this._idle = !0),
                this.trigger("_idle"),
                this.audioController.pause()));
          }),
          (AnimationItem.prototype.togglePause = function (e) {
            (e && this.name !== e) ||
              (this.isPaused === !0 ? this.play() : this.pause());
          }),
          (AnimationItem.prototype.stop = function (e) {
            (e && this.name !== e) ||
              (this.pause(),
              (this.playCount = 0),
              (this._completedLoop = !1),
              this.setCurrentRawFrameValue(0));
          }),
          (AnimationItem.prototype.getMarkerData = function (e) {
            for (var t, r = 0; r < this.markers.length; r += 1)
              if ((t = this.markers[r]).payload && t.payload.name === e)
                return t;
            return null;
          }),
          (AnimationItem.prototype.goToAndStop = function (e, t, r) {
            if (!r || this.name === r) {
              var n = Number(e);
              if (isNaN(n)) {
                var i = this.getMarkerData(e);
                i && this.goToAndStop(i.time, !0);
              } else
                t
                  ? this.setCurrentRawFrameValue(e)
                  : this.setCurrentRawFrameValue(e * this.frameModifier);
              this.pause();
            }
          }),
          (AnimationItem.prototype.goToAndPlay = function (e, t, r) {
            if (!r || this.name === r) {
              var n = Number(e);
              if (isNaN(n)) {
                var i = this.getMarkerData(e);
                i &&
                  (i.duration
                    ? this.playSegments([i.time, i.time + i.duration], !0)
                    : this.goToAndStop(i.time, !0));
              } else this.goToAndStop(n, t, r);
              this.play();
            }
          }),
          (AnimationItem.prototype.advanceTime = function (e) {
            if (this.isPaused !== !0 && this.isLoaded !== !1) {
              var t = this.currentRawFrame + e * this.frameModifier,
                r = !1;
              t >= this.totalFrames - 1 && this.frameModifier > 0
                ? this.loop && this.playCount !== this.loop
                  ? t >= this.totalFrames
                    ? ((this.playCount += 1),
                      this.checkSegments(t % this.totalFrames) ||
                        (this.setCurrentRawFrameValue(t % this.totalFrames),
                        (this._completedLoop = !0),
                        this.trigger("loopComplete")))
                    : this.setCurrentRawFrameValue(t)
                  : this.checkSegments(
                      t > this.totalFrames ? t % this.totalFrames : 0
                    ) || ((r = !0), (t = this.totalFrames - 1))
                : t < 0
                ? this.checkSegments(t % this.totalFrames) ||
                  (!this.loop || (this.playCount-- <= 0 && this.loop !== !0)
                    ? ((r = !0), (t = 0))
                    : (this.setCurrentRawFrameValue(
                        this.totalFrames + (t % this.totalFrames)
                      ),
                      this._completedLoop
                        ? this.trigger("loopComplete")
                        : (this._completedLoop = !0)))
                : this.setCurrentRawFrameValue(t),
                r &&
                  (this.setCurrentRawFrameValue(t),
                  this.pause(),
                  this.trigger("complete"));
            }
          }),
          (AnimationItem.prototype.adjustSegment = function (e, t) {
            (this.playCount = 0),
              e[1] < e[0]
                ? (this.frameModifier > 0 &&
                    (this.playSpeed < 0
                      ? this.setSpeed(-this.playSpeed)
                      : this.setDirection(-1)),
                  (this.totalFrames = e[0] - e[1]),
                  (this.timeCompleted = this.totalFrames),
                  (this.firstFrame = e[1]),
                  this.setCurrentRawFrameValue(this.totalFrames - 0.001 - t))
                : e[1] > e[0] &&
                  (this.frameModifier < 0 &&
                    (this.playSpeed < 0
                      ? this.setSpeed(-this.playSpeed)
                      : this.setDirection(1)),
                  (this.totalFrames = e[1] - e[0]),
                  (this.timeCompleted = this.totalFrames),
                  (this.firstFrame = e[0]),
                  this.setCurrentRawFrameValue(0.001 + t)),
              this.trigger("segmentStart");
          }),
          (AnimationItem.prototype.setSegment = function (e, t) {
            var r = -1;
            this.isPaused &&
              (this.currentRawFrame + this.firstFrame < e
                ? (r = e)
                : this.currentRawFrame + this.firstFrame > t && (r = t - e)),
              (this.firstFrame = e),
              (this.totalFrames = t - e),
              (this.timeCompleted = this.totalFrames),
              r !== -1 && this.goToAndStop(r, !0);
          }),
          (AnimationItem.prototype.playSegments = function (e, t) {
            if (
              (t && (this.segments.length = 0), _typeof$4(e[0]) === "object")
            ) {
              var r,
                n = e.length;
              for (r = 0; r < n; r += 1) this.segments.push(e[r]);
            } else this.segments.push(e);
            this.segments.length &&
              t &&
              this.adjustSegment(this.segments.shift(), 0),
              this.isPaused && this.play();
          }),
          (AnimationItem.prototype.resetSegments = function (e) {
            (this.segments.length = 0),
              this.segments.push([
                this.animationData.ip,
                this.animationData.op,
              ]),
              e && this.checkSegments(0);
          }),
          (AnimationItem.prototype.checkSegments = function (e) {
            return (
              !!this.segments.length &&
              (this.adjustSegment(this.segments.shift(), e), !0)
            );
          }),
          (AnimationItem.prototype.destroy = function (e) {
            (e && this.name !== e) ||
              !this.renderer ||
              (this.renderer.destroy(),
              this.imagePreloader.destroy(),
              this.trigger("destroy"),
              (this._cbs = null),
              (this.onEnterFrame = null),
              (this.onLoopComplete = null),
              (this.onComplete = null),
              (this.onSegmentStart = null),
              (this.onDestroy = null),
              (this.renderer = null),
              (this.expressionsPlugin = null),
              (this.imagePreloader = null),
              (this.projectInterface = null));
          }),
          (AnimationItem.prototype.setCurrentRawFrameValue = function (e) {
            (this.currentRawFrame = e), this.gotoFrame();
          }),
          (AnimationItem.prototype.setSpeed = function (e) {
            (this.playSpeed = e), this.updaFrameModifier();
          }),
          (AnimationItem.prototype.setDirection = function (e) {
            (this.playDirection = e < 0 ? -1 : 1), this.updaFrameModifier();
          }),
          (AnimationItem.prototype.setLoop = function (e) {
            this.loop = e;
          }),
          (AnimationItem.prototype.setVolume = function (e, t) {
            (t && this.name !== t) || this.audioController.setVolume(e);
          }),
          (AnimationItem.prototype.getVolume = function () {
            return this.audioController.getVolume();
          }),
          (AnimationItem.prototype.mute = function (e) {
            (e && this.name !== e) || this.audioController.mute();
          }),
          (AnimationItem.prototype.unmute = function (e) {
            (e && this.name !== e) || this.audioController.unmute();
          }),
          (AnimationItem.prototype.updaFrameModifier = function () {
            (this.frameModifier =
              this.frameMult * this.playSpeed * this.playDirection),
              this.audioController.setRate(this.playSpeed * this.playDirection);
          }),
          (AnimationItem.prototype.getPath = function () {
            return this.path;
          }),
          (AnimationItem.prototype.getAssetsPath = function (e) {
            var t = "";
            if (e.e) t = e.p;
            else if (this.assetsPath) {
              var r = e.p;
              r.indexOf("images/") !== -1 && (r = r.split("/")[1]),
                (t = this.assetsPath + r);
            } else (t = this.path), (t += e.u ? e.u : ""), (t += e.p);
            return t;
          }),
          (AnimationItem.prototype.getAssetData = function (e) {
            for (var t = 0, r = this.assets.length; t < r; ) {
              if (e === this.assets[t].id) return this.assets[t];
              t += 1;
            }
            return null;
          }),
          (AnimationItem.prototype.hide = function () {
            this.renderer.hide();
          }),
          (AnimationItem.prototype.show = function () {
            this.renderer.show();
          }),
          (AnimationItem.prototype.getDuration = function (e) {
            return e ? this.totalFrames : this.totalFrames / this.frameRate;
          }),
          (AnimationItem.prototype.updateDocumentData = function (e, t, r) {
            try {
              this.renderer.getElementByPath(e).updateDocumentData(t, r);
            } catch {}
          }),
          (AnimationItem.prototype.trigger = function (e) {
            if (this._cbs && this._cbs[e])
              switch (e) {
                case "enterFrame":
                  this.triggerEvent(
                    e,
                    new BMEnterFrameEvent(
                      e,
                      this.currentFrame,
                      this.totalFrames,
                      this.frameModifier
                    )
                  );
                  break;
                case "drawnFrame":
                  (this.drawnFrameEvent.currentTime = this.currentFrame),
                    (this.drawnFrameEvent.totalTime = this.totalFrames),
                    (this.drawnFrameEvent.direction = this.frameModifier),
                    this.triggerEvent(e, this.drawnFrameEvent);
                  break;
                case "loopComplete":
                  this.triggerEvent(
                    e,
                    new BMCompleteLoopEvent(
                      e,
                      this.loop,
                      this.playCount,
                      this.frameMult
                    )
                  );
                  break;
                case "complete":
                  this.triggerEvent(e, new BMCompleteEvent(e, this.frameMult));
                  break;
                case "segmentStart":
                  this.triggerEvent(
                    e,
                    new BMSegmentStartEvent(
                      e,
                      this.firstFrame,
                      this.totalFrames
                    )
                  );
                  break;
                case "destroy":
                  this.triggerEvent(e, new BMDestroyEvent(e, this));
                  break;
                default:
                  this.triggerEvent(e);
              }
            e === "enterFrame" &&
              this.onEnterFrame &&
              this.onEnterFrame.call(
                this,
                new BMEnterFrameEvent(
                  e,
                  this.currentFrame,
                  this.totalFrames,
                  this.frameMult
                )
              ),
              e === "loopComplete" &&
                this.onLoopComplete &&
                this.onLoopComplete.call(
                  this,
                  new BMCompleteLoopEvent(
                    e,
                    this.loop,
                    this.playCount,
                    this.frameMult
                  )
                ),
              e === "complete" &&
                this.onComplete &&
                this.onComplete.call(
                  this,
                  new BMCompleteEvent(e, this.frameMult)
                ),
              e === "segmentStart" &&
                this.onSegmentStart &&
                this.onSegmentStart.call(
                  this,
                  new BMSegmentStartEvent(e, this.firstFrame, this.totalFrames)
                ),
              e === "destroy" &&
                this.onDestroy &&
                this.onDestroy.call(this, new BMDestroyEvent(e, this));
          }),
          (AnimationItem.prototype.triggerRenderFrameError = function (e) {
            var t = new BMRenderFrameErrorEvent(e, this.currentFrame);
            this.triggerEvent("error", t),
              this.onError && this.onError.call(this, t);
          }),
          (AnimationItem.prototype.triggerConfigError = function (e) {
            var t = new BMConfigErrorEvent(e, this.currentFrame);
            this.triggerEvent("error", t),
              this.onError && this.onError.call(this, t);
          });
        var animationManager = (function () {
            var e = {},
              t = [],
              r = 0,
              n = 0,
              i = 0,
              a = !0,
              o = !1;
            function s(g) {
              for (var c = 0, v = g.target; c < n; )
                t[c].animation === v &&
                  (t.splice(c, 1), (c -= 1), (n -= 1), v.isPaused || u()),
                  (c += 1);
            }
            function l(g, c) {
              if (!g) return null;
              for (var v = 0; v < n; ) {
                if (t[v].elem === g && t[v].elem !== null)
                  return t[v].animation;
                v += 1;
              }
              var y = new AnimationItem();
              return h(y, g), y.setData(g, c), y;
            }
            function f() {
              (i += 1), p();
            }
            function u() {
              i -= 1;
            }
            function h(g, c) {
              g.addEventListener("destroy", s),
                g.addEventListener("_active", f),
                g.addEventListener("_idle", u),
                t.push({ elem: c, animation: g }),
                (n += 1);
            }
            function m(g) {
              var c,
                v = g - r;
              for (c = 0; c < n; c += 1) t[c].animation.advanceTime(v);
              (r = g), i && !o ? window.requestAnimationFrame(m) : (a = !0);
            }
            function d(g) {
              (r = g), window.requestAnimationFrame(m);
            }
            function p() {
              !o && i && a && (window.requestAnimationFrame(d), (a = !1));
            }
            return (
              (e.registerAnimation = l),
              (e.loadAnimation = function (g) {
                var c = new AnimationItem();
                return h(c, null), c.setParams(g), c;
              }),
              (e.setSpeed = function (g, c) {
                var v;
                for (v = 0; v < n; v += 1) t[v].animation.setSpeed(g, c);
              }),
              (e.setDirection = function (g, c) {
                var v;
                for (v = 0; v < n; v += 1) t[v].animation.setDirection(g, c);
              }),
              (e.play = function (g) {
                var c;
                for (c = 0; c < n; c += 1) t[c].animation.play(g);
              }),
              (e.pause = function (g) {
                var c;
                for (c = 0; c < n; c += 1) t[c].animation.pause(g);
              }),
              (e.stop = function (g) {
                var c;
                for (c = 0; c < n; c += 1) t[c].animation.stop(g);
              }),
              (e.togglePause = function (g) {
                var c;
                for (c = 0; c < n; c += 1) t[c].animation.togglePause(g);
              }),
              (e.searchAnimations = function (g, c, v) {
                var y,
                  b = [].concat(
                    [].slice.call(document.getElementsByClassName("lottie")),
                    [].slice.call(document.getElementsByClassName("bodymovin"))
                  ),
                  x = b.length;
                for (y = 0; y < x; y += 1)
                  v && b[y].setAttribute("data-bm-type", v), l(b[y], g);
                if (c && x === 0) {
                  v || (v = "svg");
                  var S = document.getElementsByTagName("body")[0];
                  S.innerText = "";
                  var T = createTag("div");
                  (T.style.width = "100%"),
                    (T.style.height = "100%"),
                    T.setAttribute("data-bm-type", v),
                    S.appendChild(T),
                    l(T, g);
                }
              }),
              (e.resize = function () {
                var g;
                for (g = 0; g < n; g += 1) t[g].animation.resize();
              }),
              (e.goToAndStop = function (g, c, v) {
                var y;
                for (y = 0; y < n; y += 1) t[y].animation.goToAndStop(g, c, v);
              }),
              (e.destroy = function (g) {
                var c;
                for (c = n - 1; c >= 0; c -= 1) t[c].animation.destroy(g);
              }),
              (e.freeze = function () {
                o = !0;
              }),
              (e.unfreeze = function () {
                (o = !1), p();
              }),
              (e.setVolume = function (g, c) {
                var v;
                for (v = 0; v < n; v += 1) t[v].animation.setVolume(g, c);
              }),
              (e.mute = function (g) {
                var c;
                for (c = 0; c < n; c += 1) t[c].animation.mute(g);
              }),
              (e.unmute = function (g) {
                var c;
                for (c = 0; c < n; c += 1) t[c].animation.unmute(g);
              }),
              (e.getRegisteredAnimations = function () {
                var g,
                  c = t.length,
                  v = [];
                for (g = 0; g < c; g += 1) v.push(t[g].animation);
                return v;
              }),
              e
            );
          })(),
          BezierFactory = (function () {
            var e = {
                getBezierEasing: function (u, h, m, d, p) {
                  var g =
                    p ||
                    ("bez_" + u + "_" + h + "_" + m + "_" + d).replace(
                      /\./g,
                      "p"
                    );
                  if (t[g]) return t[g];
                  var c = new f([u, h, m, d]);
                  return (t[g] = c), c;
                },
              },
              t = {},
              r = 0.1,
              n = typeof Float32Array == "function";
            function i(u, h) {
              return 1 - 3 * h + 3 * u;
            }
            function a(u, h) {
              return 3 * h - 6 * u;
            }
            function o(u) {
              return 3 * u;
            }
            function s(u, h, m) {
              return ((i(h, m) * u + a(h, m)) * u + o(h)) * u;
            }
            function l(u, h, m) {
              return 3 * i(h, m) * u * u + 2 * a(h, m) * u + o(h);
            }
            function f(u) {
              (this._p = u),
                (this._mSampleValues = n
                  ? new Float32Array(11)
                  : new Array(11)),
                (this._precomputed = !1),
                (this.get = this.get.bind(this));
            }
            return (
              (f.prototype = {
                get: function (u) {
                  var h = this._p[0],
                    m = this._p[1],
                    d = this._p[2],
                    p = this._p[3];
                  return (
                    this._precomputed || this._precompute(),
                    h === m && d === p
                      ? u
                      : u === 0
                      ? 0
                      : u === 1
                      ? 1
                      : s(this._getTForX(u), m, p)
                  );
                },
                _precompute: function () {
                  var u = this._p[0],
                    h = this._p[1],
                    m = this._p[2],
                    d = this._p[3];
                  (this._precomputed = !0),
                    (u === h && m === d) || this._calcSampleValues();
                },
                _calcSampleValues: function () {
                  for (var u = this._p[0], h = this._p[2], m = 0; m < 11; ++m)
                    this._mSampleValues[m] = s(m * r, u, h);
                },
                _getTForX: function (u) {
                  for (
                    var h = this._p[0],
                      m = this._p[2],
                      d = this._mSampleValues,
                      p = 0,
                      g = 1;
                    g !== 10 && d[g] <= u;
                    ++g
                  )
                    p += r;
                  var c = p + ((u - d[--g]) / (d[g + 1] - d[g])) * r,
                    v = l(c, h, m);
                  return v >= 0.001
                    ? (function (y, b, x, S) {
                        for (var T = 0; T < 4; ++T) {
                          var I = l(b, x, S);
                          if (I === 0) return b;
                          b -= (s(b, x, S) - y) / I;
                        }
                        return b;
                      })(u, c, h, m)
                    : v === 0
                    ? c
                    : (function (y, b, x, S, T) {
                        var I,
                          P,
                          L = 0;
                        do
                          (I = s((P = b + (x - b) / 2), S, T) - y) > 0
                            ? (x = P)
                            : (b = P);
                        while (Math.abs(I) > 1e-7 && ++L < 10);
                        return P;
                      })(u, p, p + r, h, m);
                },
              }),
              e
            );
          })(),
          pooling = {
            double: function (e) {
              return e.concat(createSizedArray(e.length));
            },
          },
          poolFactory = function (e, t, r) {
            var n = 0,
              i = e,
              a = createSizedArray(i);
            return {
              newElement: function () {
                return n ? a[(n -= 1)] : t();
              },
              release: function (o) {
                n === i && ((a = pooling.double(a)), (i *= 2)),
                  r && r(o),
                  (a[n] = o),
                  (n += 1);
              },
            };
          },
          bezierLengthPool = poolFactory(8, function () {
            return {
              addedLength: 0,
              percents: createTypedArray("float32", getDefaultCurveSegments()),
              lengths: createTypedArray("float32", getDefaultCurveSegments()),
            };
          }),
          segmentsLengthPool = poolFactory(
            8,
            function () {
              return { lengths: [], totalLength: 0 };
            },
            function (e) {
              var t,
                r = e.lengths.length;
              for (t = 0; t < r; t += 1) bezierLengthPool.release(e.lengths[t]);
              e.lengths.length = 0;
            }
          );
        function bezFunction() {
          var e = Math;
          function t(f, u, h, m, d, p) {
            var g = f * m + u * d + h * p - d * m - p * f - h * u;
            return g > -0.001 && g < 0.001;
          }
          var r = function (f, u, h, m) {
            var d,
              p,
              g,
              c,
              v,
              y,
              b = getDefaultCurveSegments(),
              x = 0,
              S = [],
              T = [],
              I = bezierLengthPool.newElement();
            for (g = h.length, d = 0; d < b; d += 1) {
              for (v = d / (b - 1), y = 0, p = 0; p < g; p += 1)
                (c =
                  bmPow(1 - v, 3) * f[p] +
                  3 * bmPow(1 - v, 2) * v * h[p] +
                  3 * (1 - v) * bmPow(v, 2) * m[p] +
                  bmPow(v, 3) * u[p]),
                  (S[p] = c),
                  T[p] !== null && (y += bmPow(S[p] - T[p], 2)),
                  (T[p] = S[p]);
              y && (x += y = bmSqrt(y)),
                (I.percents[d] = v),
                (I.lengths[d] = x);
            }
            return (I.addedLength = x), I;
          };
          function n(f) {
            (this.segmentLength = 0), (this.points = new Array(f));
          }
          function i(f, u) {
            (this.partialLength = f), (this.point = u);
          }
          var a,
            o =
              ((a = {}),
              function (f, u, h, m) {
                var d = (
                  f[0] +
                  "_" +
                  f[1] +
                  "_" +
                  u[0] +
                  "_" +
                  u[1] +
                  "_" +
                  h[0] +
                  "_" +
                  h[1] +
                  "_" +
                  m[0] +
                  "_" +
                  m[1]
                ).replace(/\./g, "p");
                if (!a[d]) {
                  var p,
                    g,
                    c,
                    v,
                    y,
                    b,
                    x,
                    S = getDefaultCurveSegments(),
                    T = 0,
                    I = null;
                  f.length === 2 &&
                    (f[0] !== u[0] || f[1] !== u[1]) &&
                    t(f[0], f[1], u[0], u[1], f[0] + h[0], f[1] + h[1]) &&
                    t(f[0], f[1], u[0], u[1], u[0] + m[0], u[1] + m[1]) &&
                    (S = 2);
                  var P = new n(S);
                  for (c = h.length, p = 0; p < S; p += 1) {
                    for (
                      x = createSizedArray(c), y = p / (S - 1), b = 0, g = 0;
                      g < c;
                      g += 1
                    )
                      (v =
                        bmPow(1 - y, 3) * f[g] +
                        3 * bmPow(1 - y, 2) * y * (f[g] + h[g]) +
                        3 * (1 - y) * bmPow(y, 2) * (u[g] + m[g]) +
                        bmPow(y, 3) * u[g]),
                        (x[g] = v),
                        I !== null && (b += bmPow(x[g] - I[g], 2));
                    (T += b = bmSqrt(b)), (P.points[p] = new i(b, x)), (I = x);
                  }
                  (P.segmentLength = T), (a[d] = P);
                }
                return a[d];
              });
          function s(f, u) {
            var h = u.percents,
              m = u.lengths,
              d = h.length,
              p = bmFloor((d - 1) * f),
              g = f * u.addedLength,
              c = 0;
            if (p === d - 1 || p === 0 || g === m[p]) return h[p];
            for (var v = m[p] > g ? -1 : 1, y = !0; y; )
              if (
                (m[p] <= g && m[p + 1] > g
                  ? ((c = (g - m[p]) / (m[p + 1] - m[p])), (y = !1))
                  : (p += v),
                p < 0 || p >= d - 1)
              ) {
                if (p === d - 1) return h[p];
                y = !1;
              }
            return h[p] + (h[p + 1] - h[p]) * c;
          }
          var l = createTypedArray("float32", 8);
          return {
            getSegmentsLength: function (f) {
              var u,
                h = segmentsLengthPool.newElement(),
                m = f.c,
                d = f.v,
                p = f.o,
                g = f.i,
                c = f._length,
                v = h.lengths,
                y = 0;
              for (u = 0; u < c - 1; u += 1)
                (v[u] = r(d[u], d[u + 1], p[u], g[u + 1])),
                  (y += v[u].addedLength);
              return (
                m &&
                  c &&
                  ((v[u] = r(d[u], d[0], p[u], g[0])), (y += v[u].addedLength)),
                (h.totalLength = y),
                h
              );
            },
            getNewSegment: function (f, u, h, m, d, p, g) {
              d < 0 ? (d = 0) : d > 1 && (d = 1);
              var c,
                v = s(d, g),
                y = s((p = p > 1 ? 1 : p), g),
                b = f.length,
                x = 1 - v,
                S = 1 - y,
                T = x * x * x,
                I = v * x * x * 3,
                P = v * v * x * 3,
                L = v * v * v,
                M = x * x * S,
                _ = v * x * S + x * v * S + x * x * y,
                F = v * v * S + x * v * y + v * x * y,
                w = v * v * y,
                R = x * S * S,
                k = v * S * S + x * y * S + x * S * y,
                z = v * y * S + x * y * y + v * S * y,
                ee = v * y * y,
                A = S * S * S,
                N = y * S * S + S * y * S + S * S * y,
                X = y * y * S + S * y * y + y * S * y,
                ae = y * y * y;
              for (c = 0; c < b; c += 1)
                (l[4 * c] =
                  e.round(1e3 * (T * f[c] + I * h[c] + P * m[c] + L * u[c])) /
                  1e3),
                  (l[4 * c + 1] =
                    e.round(1e3 * (M * f[c] + _ * h[c] + F * m[c] + w * u[c])) /
                    1e3),
                  (l[4 * c + 2] =
                    e.round(
                      1e3 * (R * f[c] + k * h[c] + z * m[c] + ee * u[c])
                    ) / 1e3),
                  (l[4 * c + 3] =
                    e.round(
                      1e3 * (A * f[c] + N * h[c] + X * m[c] + ae * u[c])
                    ) / 1e3);
              return l;
            },
            getPointInSegment: function (f, u, h, m, d, p) {
              var g = s(d, p),
                c = 1 - g;
              return [
                e.round(
                  1e3 *
                    (c * c * c * f[0] +
                      (g * c * c + c * g * c + c * c * g) * h[0] +
                      (g * g * c + c * g * g + g * c * g) * m[0] +
                      g * g * g * u[0])
                ) / 1e3,
                e.round(
                  1e3 *
                    (c * c * c * f[1] +
                      (g * c * c + c * g * c + c * c * g) * h[1] +
                      (g * g * c + c * g * g + g * c * g) * m[1] +
                      g * g * g * u[1])
                ) / 1e3,
              ];
            },
            buildBezierData: o,
            pointOnLine2D: t,
            pointOnLine3D: function (f, u, h, m, d, p, g, c, v) {
              if (h === 0 && p === 0 && v === 0) return t(f, u, m, d, g, c);
              var y,
                b = e.sqrt(e.pow(m - f, 2) + e.pow(d - u, 2) + e.pow(p - h, 2)),
                x = e.sqrt(e.pow(g - f, 2) + e.pow(c - u, 2) + e.pow(v - h, 2)),
                S = e.sqrt(e.pow(g - m, 2) + e.pow(c - d, 2) + e.pow(v - p, 2));
              return (
                (y =
                  b > x
                    ? b > S
                      ? b - x - S
                      : S - x - b
                    : S > x
                    ? S - x - b
                    : x - b - S) > -1e-4 && y < 1e-4
              );
            },
          };
        }
        var bez = bezFunction(),
          initFrame = initialDefaultFrame,
          mathAbs = Math.abs;
        function interpolateValue(e, t) {
          var r,
            n = this.offsetTime;
          this.propType === "multidimensional" &&
            (r = createTypedArray("float32", this.pv.length));
          for (
            var i,
              a,
              o,
              s,
              l,
              f,
              u,
              h,
              m,
              d = t.lastIndex,
              p = d,
              g = this.keyframes.length - 1,
              c = !0;
            c;

          ) {
            if (
              ((i = this.keyframes[p]),
              (a = this.keyframes[p + 1]),
              p === g - 1 && e >= a.t - n)
            ) {
              i.h && (i = a), (d = 0);
              break;
            }
            if (a.t - n > e) {
              d = p;
              break;
            }
            p < g - 1 ? (p += 1) : ((d = 0), (c = !1));
          }
          o = this.keyframesMetadata[p] || {};
          var v,
            y = a.t - n,
            b = i.t - n;
          if (i.to) {
            o.bezierData ||
              (o.bezierData = bez.buildBezierData(i.s, a.s || i.e, i.to, i.ti));
            var x = o.bezierData;
            if (e >= y || e < b) {
              var S = e >= y ? x.points.length - 1 : 0;
              for (l = x.points[S].point.length, s = 0; s < l; s += 1)
                r[s] = x.points[S].point[s];
            } else {
              o.__fnct
                ? (m = o.__fnct)
                : ((m = BezierFactory.getBezierEasing(
                    i.o.x,
                    i.o.y,
                    i.i.x,
                    i.i.y,
                    i.n
                  ).get),
                  (o.__fnct = m)),
                (f = m((e - b) / (y - b)));
              var T,
                I = x.segmentLength * f,
                P =
                  t.lastFrame < e && t._lastKeyframeIndex === p
                    ? t._lastAddedLength
                    : 0;
              for (
                h =
                  t.lastFrame < e && t._lastKeyframeIndex === p
                    ? t._lastPoint
                    : 0,
                  c = !0,
                  u = x.points.length;
                c;

              ) {
                if (
                  ((P += x.points[h].partialLength),
                  I === 0 || f === 0 || h === x.points.length - 1)
                ) {
                  for (l = x.points[h].point.length, s = 0; s < l; s += 1)
                    r[s] = x.points[h].point[s];
                  break;
                }
                if (I >= P && I < P + x.points[h + 1].partialLength) {
                  for (
                    T = (I - P) / x.points[h + 1].partialLength,
                      l = x.points[h].point.length,
                      s = 0;
                    s < l;
                    s += 1
                  )
                    r[s] =
                      x.points[h].point[s] +
                      (x.points[h + 1].point[s] - x.points[h].point[s]) * T;
                  break;
                }
                h < u - 1 ? (h += 1) : (c = !1);
              }
              (t._lastPoint = h),
                (t._lastAddedLength = P - x.points[h].partialLength),
                (t._lastKeyframeIndex = p);
            }
          } else {
            var L, M, _, F, w;
            if (((g = i.s.length), (v = a.s || i.e), this.sh && i.h !== 1))
              e >= y
                ? ((r[0] = v[0]), (r[1] = v[1]), (r[2] = v[2]))
                : e <= b
                ? ((r[0] = i.s[0]), (r[1] = i.s[1]), (r[2] = i.s[2]))
                : quaternionToEuler(
                    r,
                    slerp(
                      createQuaternion(i.s),
                      createQuaternion(v),
                      (e - b) / (y - b)
                    )
                  );
            else
              for (p = 0; p < g; p += 1)
                i.h !== 1 &&
                  (e >= y
                    ? (f = 1)
                    : e < b
                    ? (f = 0)
                    : (i.o.x.constructor === Array
                        ? (o.__fnct || (o.__fnct = []),
                          o.__fnct[p]
                            ? (m = o.__fnct[p])
                            : ((L = i.o.x[p] === void 0 ? i.o.x[0] : i.o.x[p]),
                              (M = i.o.y[p] === void 0 ? i.o.y[0] : i.o.y[p]),
                              (_ = i.i.x[p] === void 0 ? i.i.x[0] : i.i.x[p]),
                              (F = i.i.y[p] === void 0 ? i.i.y[0] : i.i.y[p]),
                              (m = BezierFactory.getBezierEasing(
                                L,
                                M,
                                _,
                                F
                              ).get),
                              (o.__fnct[p] = m)))
                        : o.__fnct
                        ? (m = o.__fnct)
                        : ((L = i.o.x),
                          (M = i.o.y),
                          (_ = i.i.x),
                          (F = i.i.y),
                          (m = BezierFactory.getBezierEasing(L, M, _, F).get),
                          (i.keyframeMetadata = m)),
                      (f = m((e - b) / (y - b))))),
                  (v = a.s || i.e),
                  (w = i.h === 1 ? i.s[p] : i.s[p] + (v[p] - i.s[p]) * f),
                  this.propType === "multidimensional" ? (r[p] = w) : (r = w);
          }
          return (t.lastIndex = d), r;
        }
        function slerp(e, t, r) {
          var n,
            i,
            a,
            o,
            s,
            l = [],
            f = e[0],
            u = e[1],
            h = e[2],
            m = e[3],
            d = t[0],
            p = t[1],
            g = t[2],
            c = t[3];
          return (
            (i = f * d + u * p + h * g + m * c) < 0 &&
              ((i = -i), (d = -d), (p = -p), (g = -g), (c = -c)),
            1 - i > 1e-6
              ? ((n = Math.acos(i)),
                (a = Math.sin(n)),
                (o = Math.sin((1 - r) * n) / a),
                (s = Math.sin(r * n) / a))
              : ((o = 1 - r), (s = r)),
            (l[0] = o * f + s * d),
            (l[1] = o * u + s * p),
            (l[2] = o * h + s * g),
            (l[3] = o * m + s * c),
            l
          );
        }
        function quaternionToEuler(e, t) {
          var r = t[0],
            n = t[1],
            i = t[2],
            a = t[3],
            o = Math.atan2(2 * n * a - 2 * r * i, 1 - 2 * n * n - 2 * i * i),
            s = Math.asin(2 * r * n + 2 * i * a),
            l = Math.atan2(2 * r * a - 2 * n * i, 1 - 2 * r * r - 2 * i * i);
          (e[0] = o / degToRads),
            (e[1] = s / degToRads),
            (e[2] = l / degToRads);
        }
        function createQuaternion(e) {
          var t = e[0] * degToRads,
            r = e[1] * degToRads,
            n = e[2] * degToRads,
            i = Math.cos(t / 2),
            a = Math.cos(r / 2),
            o = Math.cos(n / 2),
            s = Math.sin(t / 2),
            l = Math.sin(r / 2),
            f = Math.sin(n / 2);
          return [
            s * l * o + i * a * f,
            s * a * o + i * l * f,
            i * l * o - s * a * f,
            i * a * o - s * l * f,
          ];
        }
        function getValueAtCurrentTime() {
          var e = this.comp.renderedFrame - this.offsetTime,
            t = this.keyframes[0].t - this.offsetTime,
            r = this.keyframes[this.keyframes.length - 1].t - this.offsetTime;
          if (
            !(
              e === this._caching.lastFrame ||
              (this._caching.lastFrame !== initFrame &&
                ((this._caching.lastFrame >= r && e >= r) ||
                  (this._caching.lastFrame < t && e < t)))
            )
          ) {
            this._caching.lastFrame >= e &&
              ((this._caching._lastKeyframeIndex = -1),
              (this._caching.lastIndex = 0));
            var n = this.interpolateValue(e, this._caching);
            this.pv = n;
          }
          return (this._caching.lastFrame = e), this.pv;
        }
        function setVValue(e) {
          var t;
          if (this.propType === "unidimensional")
            (t = e * this.mult),
              mathAbs(this.v - t) > 1e-5 && ((this.v = t), (this._mdf = !0));
          else
            for (var r = 0, n = this.v.length; r < n; )
              (t = e[r] * this.mult),
                mathAbs(this.v[r] - t) > 1e-5 &&
                  ((this.v[r] = t), (this._mdf = !0)),
                (r += 1);
        }
        function processEffectsSequence() {
          if (
            this.elem.globalData.frameId !== this.frameId &&
            this.effectsSequence.length
          )
            if (this.lock) this.setVValue(this.pv);
            else {
              var e;
              (this.lock = !0), (this._mdf = this._isFirstFrame);
              var t = this.effectsSequence.length,
                r = this.kf ? this.pv : this.data.k;
              for (e = 0; e < t; e += 1) r = this.effectsSequence[e](r);
              this.setVValue(r),
                (this._isFirstFrame = !1),
                (this.lock = !1),
                (this.frameId = this.elem.globalData.frameId);
            }
        }
        function addEffect(e) {
          this.effectsSequence.push(e), this.container.addDynamicProperty(this);
        }
        function ValueProperty(e, t, r, n) {
          (this.propType = "unidimensional"),
            (this.mult = r || 1),
            (this.data = t),
            (this.v = r ? t.k * r : t.k),
            (this.pv = t.k),
            (this._mdf = !1),
            (this.elem = e),
            (this.container = n),
            (this.comp = e.comp),
            (this.k = !1),
            (this.kf = !1),
            (this.vel = 0),
            (this.effectsSequence = []),
            (this._isFirstFrame = !0),
            (this.getValue = processEffectsSequence),
            (this.setVValue = setVValue),
            (this.addEffect = addEffect);
        }
        function MultiDimensionalProperty(e, t, r, n) {
          var i;
          (this.propType = "multidimensional"),
            (this.mult = r || 1),
            (this.data = t),
            (this._mdf = !1),
            (this.elem = e),
            (this.container = n),
            (this.comp = e.comp),
            (this.k = !1),
            (this.kf = !1),
            (this.frameId = -1);
          var a = t.k.length;
          for (
            this.v = createTypedArray("float32", a),
              this.pv = createTypedArray("float32", a),
              this.vel = createTypedArray("float32", a),
              i = 0;
            i < a;
            i += 1
          )
            (this.v[i] = t.k[i] * this.mult), (this.pv[i] = t.k[i]);
          (this._isFirstFrame = !0),
            (this.effectsSequence = []),
            (this.getValue = processEffectsSequence),
            (this.setVValue = setVValue),
            (this.addEffect = addEffect);
        }
        function KeyframedValueProperty(e, t, r, n) {
          (this.propType = "unidimensional"),
            (this.keyframes = t.k),
            (this.keyframesMetadata = []),
            (this.offsetTime = e.data.st),
            (this.frameId = -1),
            (this._caching = {
              lastFrame: initFrame,
              lastIndex: 0,
              value: 0,
              _lastKeyframeIndex: -1,
            }),
            (this.k = !0),
            (this.kf = !0),
            (this.data = t),
            (this.mult = r || 1),
            (this.elem = e),
            (this.container = n),
            (this.comp = e.comp),
            (this.v = initFrame),
            (this.pv = initFrame),
            (this._isFirstFrame = !0),
            (this.getValue = processEffectsSequence),
            (this.setVValue = setVValue),
            (this.interpolateValue = interpolateValue),
            (this.effectsSequence = [getValueAtCurrentTime.bind(this)]),
            (this.addEffect = addEffect);
        }
        function KeyframedMultidimensionalProperty(e, t, r, n) {
          var i;
          this.propType = "multidimensional";
          var a,
            o,
            s,
            l,
            f = t.k.length;
          for (i = 0; i < f - 1; i += 1)
            t.k[i].to &&
              t.k[i].s &&
              t.k[i + 1] &&
              t.k[i + 1].s &&
              ((a = t.k[i].s),
              (o = t.k[i + 1].s),
              (s = t.k[i].to),
              (l = t.k[i].ti),
              ((a.length === 2 &&
                (a[0] !== o[0] || a[1] !== o[1]) &&
                bez.pointOnLine2D(
                  a[0],
                  a[1],
                  o[0],
                  o[1],
                  a[0] + s[0],
                  a[1] + s[1]
                ) &&
                bez.pointOnLine2D(
                  a[0],
                  a[1],
                  o[0],
                  o[1],
                  o[0] + l[0],
                  o[1] + l[1]
                )) ||
                (a.length === 3 &&
                  (a[0] !== o[0] || a[1] !== o[1] || a[2] !== o[2]) &&
                  bez.pointOnLine3D(
                    a[0],
                    a[1],
                    a[2],
                    o[0],
                    o[1],
                    o[2],
                    a[0] + s[0],
                    a[1] + s[1],
                    a[2] + s[2]
                  ) &&
                  bez.pointOnLine3D(
                    a[0],
                    a[1],
                    a[2],
                    o[0],
                    o[1],
                    o[2],
                    o[0] + l[0],
                    o[1] + l[1],
                    o[2] + l[2]
                  ))) &&
                ((t.k[i].to = null), (t.k[i].ti = null)),
              a[0] === o[0] &&
                a[1] === o[1] &&
                s[0] === 0 &&
                s[1] === 0 &&
                l[0] === 0 &&
                l[1] === 0 &&
                (a.length === 2 ||
                  (a[2] === o[2] && s[2] === 0 && l[2] === 0)) &&
                ((t.k[i].to = null), (t.k[i].ti = null)));
          (this.effectsSequence = [getValueAtCurrentTime.bind(this)]),
            (this.data = t),
            (this.keyframes = t.k),
            (this.keyframesMetadata = []),
            (this.offsetTime = e.data.st),
            (this.k = !0),
            (this.kf = !0),
            (this._isFirstFrame = !0),
            (this.mult = r || 1),
            (this.elem = e),
            (this.container = n),
            (this.comp = e.comp),
            (this.getValue = processEffectsSequence),
            (this.setVValue = setVValue),
            (this.interpolateValue = interpolateValue),
            (this.frameId = -1);
          var u = t.k[0].s.length;
          for (
            this.v = createTypedArray("float32", u),
              this.pv = createTypedArray("float32", u),
              i = 0;
            i < u;
            i += 1
          )
            (this.v[i] = initFrame), (this.pv[i] = initFrame);
          (this._caching = {
            lastFrame: initFrame,
            lastIndex: 0,
            value: createTypedArray("float32", u),
          }),
            (this.addEffect = addEffect);
        }
        var PropertyFactory = {
          getProp: function (e, t, r, n, i) {
            var a;
            if (
              (t.sid && (t = e.globalData.slotManager.getProp(t)), t.k.length)
            )
              if (typeof t.k[0] == "number")
                a = new MultiDimensionalProperty(e, t, n, i);
              else
                switch (r) {
                  case 0:
                    a = new KeyframedValueProperty(e, t, n, i);
                    break;
                  case 1:
                    a = new KeyframedMultidimensionalProperty(e, t, n, i);
                }
            else a = new ValueProperty(e, t, n, i);
            return a.effectsSequence.length && i.addDynamicProperty(a), a;
          },
        };
        function DynamicPropertyContainer() {}
        DynamicPropertyContainer.prototype = {
          addDynamicProperty: function (e) {
            this.dynamicProperties.indexOf(e) === -1 &&
              (this.dynamicProperties.push(e),
              this.container.addDynamicProperty(this),
              (this._isAnimated = !0));
          },
          iterateDynamicProperties: function () {
            var e;
            this._mdf = !1;
            var t = this.dynamicProperties.length;
            for (e = 0; e < t; e += 1)
              this.dynamicProperties[e].getValue(),
                this.dynamicProperties[e]._mdf && (this._mdf = !0);
          },
          initDynamicPropertyContainer: function (e) {
            (this.container = e),
              (this.dynamicProperties = []),
              (this._mdf = !1),
              (this._isAnimated = !1);
          },
        };
        var pointPool = poolFactory(8, function () {
          return createTypedArray("float32", 2);
        });
        function ShapePath() {
          (this.c = !1),
            (this._length = 0),
            (this._maxLength = 8),
            (this.v = createSizedArray(this._maxLength)),
            (this.o = createSizedArray(this._maxLength)),
            (this.i = createSizedArray(this._maxLength));
        }
        (ShapePath.prototype.setPathData = function (e, t) {
          (this.c = e), this.setLength(t);
          for (var r = 0; r < t; )
            (this.v[r] = pointPool.newElement()),
              (this.o[r] = pointPool.newElement()),
              (this.i[r] = pointPool.newElement()),
              (r += 1);
        }),
          (ShapePath.prototype.setLength = function (e) {
            for (; this._maxLength < e; ) this.doubleArrayLength();
            this._length = e;
          }),
          (ShapePath.prototype.doubleArrayLength = function () {
            (this.v = this.v.concat(createSizedArray(this._maxLength))),
              (this.i = this.i.concat(createSizedArray(this._maxLength))),
              (this.o = this.o.concat(createSizedArray(this._maxLength))),
              (this._maxLength *= 2);
          }),
          (ShapePath.prototype.setXYAt = function (e, t, r, n, i) {
            var a;
            switch (
              ((this._length = Math.max(this._length, n + 1)),
              this._length >= this._maxLength && this.doubleArrayLength(),
              r)
            ) {
              case "v":
                a = this.v;
                break;
              case "i":
                a = this.i;
                break;
              case "o":
                a = this.o;
                break;
              default:
                a = [];
            }
            (!a[n] || (a[n] && !i)) && (a[n] = pointPool.newElement()),
              (a[n][0] = e),
              (a[n][1] = t);
          }),
          (ShapePath.prototype.setTripleAt = function (e, t, r, n, i, a, o, s) {
            this.setXYAt(e, t, "v", o, s),
              this.setXYAt(r, n, "o", o, s),
              this.setXYAt(i, a, "i", o, s);
          }),
          (ShapePath.prototype.reverse = function () {
            var e = new ShapePath();
            e.setPathData(this.c, this._length);
            var t = this.v,
              r = this.o,
              n = this.i,
              i = 0;
            this.c &&
              (e.setTripleAt(
                t[0][0],
                t[0][1],
                n[0][0],
                n[0][1],
                r[0][0],
                r[0][1],
                0,
                !1
              ),
              (i = 1));
            var a,
              o = this._length - 1,
              s = this._length;
            for (a = i; a < s; a += 1)
              e.setTripleAt(
                t[o][0],
                t[o][1],
                n[o][0],
                n[o][1],
                r[o][0],
                r[o][1],
                a,
                !1
              ),
                (o -= 1);
            return e;
          }),
          (ShapePath.prototype.length = function () {
            return this._length;
          });
        var shapePool =
            ((factory = poolFactory(
              4,
              function () {
                return new ShapePath();
              },
              function (e) {
                var t,
                  r = e._length;
                for (t = 0; t < r; t += 1)
                  pointPool.release(e.v[t]),
                    pointPool.release(e.i[t]),
                    pointPool.release(e.o[t]),
                    (e.v[t] = null),
                    (e.i[t] = null),
                    (e.o[t] = null);
                (e._length = 0), (e.c = !1);
              }
            )),
            (factory.clone = function (e) {
              var t,
                r = factory.newElement(),
                n = e._length === void 0 ? e.v.length : e._length;
              for (r.setLength(n), r.c = e.c, t = 0; t < n; t += 1)
                r.setTripleAt(
                  e.v[t][0],
                  e.v[t][1],
                  e.o[t][0],
                  e.o[t][1],
                  e.i[t][0],
                  e.i[t][1],
                  t
                );
              return r;
            }),
            factory),
          factory;
        function ShapeCollection() {
          (this._length = 0),
            (this._maxLength = 4),
            (this.shapes = createSizedArray(this._maxLength));
        }
        (ShapeCollection.prototype.addShape = function (e) {
          this._length === this._maxLength &&
            ((this.shapes = this.shapes.concat(
              createSizedArray(this._maxLength)
            )),
            (this._maxLength *= 2)),
            (this.shapes[this._length] = e),
            (this._length += 1);
        }),
          (ShapeCollection.prototype.releaseShapes = function () {
            var e;
            for (e = 0; e < this._length; e += 1)
              shapePool.release(this.shapes[e]);
            this._length = 0;
          });
        var shapeCollectionPool =
            ((ob = {
              newShapeCollection: function () {
                return _length ? pool[(_length -= 1)] : new ShapeCollection();
              },
              release: function (e) {
                var t,
                  r = e._length;
                for (t = 0; t < r; t += 1) shapePool.release(e.shapes[t]);
                (e._length = 0),
                  _length === _maxLength &&
                    ((pool = pooling.double(pool)), (_maxLength *= 2)),
                  (pool[_length] = e),
                  (_length += 1);
              },
            }),
            (_length = 0),
            (_maxLength = 4),
            (pool = createSizedArray(_maxLength)),
            ob),
          ob,
          _length,
          _maxLength,
          pool,
          ShapePropertyFactory = (function () {
            var e = -999999;
            function t(d, p, g) {
              var c,
                v,
                y,
                b,
                x,
                S,
                T,
                I,
                P,
                L = g.lastIndex,
                M = this.keyframes;
              if (d < M[0].t - this.offsetTime)
                (c = M[0].s[0]), (y = !0), (L = 0);
              else if (d >= M[M.length - 1].t - this.offsetTime)
                (c = M[M.length - 1].s
                  ? M[M.length - 1].s[0]
                  : M[M.length - 2].e[0]),
                  (y = !0);
              else {
                for (
                  var _, F, w, R = L, k = M.length - 1, z = !0;
                  z && ((_ = M[R]), !((F = M[R + 1]).t - this.offsetTime > d));

                )
                  R < k - 1 ? (R += 1) : (z = !1);
                if (
                  ((w = this.keyframesMetadata[R] || {}),
                  (L = R),
                  !(y = _.h === 1))
                ) {
                  if (d >= F.t - this.offsetTime) I = 1;
                  else if (d < _.t - this.offsetTime) I = 0;
                  else {
                    var ee;
                    w.__fnct
                      ? (ee = w.__fnct)
                      : ((ee = BezierFactory.getBezierEasing(
                          _.o.x,
                          _.o.y,
                          _.i.x,
                          _.i.y
                        ).get),
                        (w.__fnct = ee)),
                      (I = ee(
                        (d - (_.t - this.offsetTime)) /
                          (F.t - this.offsetTime - (_.t - this.offsetTime))
                      ));
                  }
                  v = F.s ? F.s[0] : _.e[0];
                }
                c = _.s[0];
              }
              for (
                S = p._length, T = c.i[0].length, g.lastIndex = L, b = 0;
                b < S;
                b += 1
              )
                for (x = 0; x < T; x += 1)
                  (P = y ? c.i[b][x] : c.i[b][x] + (v.i[b][x] - c.i[b][x]) * I),
                    (p.i[b][x] = P),
                    (P = y
                      ? c.o[b][x]
                      : c.o[b][x] + (v.o[b][x] - c.o[b][x]) * I),
                    (p.o[b][x] = P),
                    (P = y
                      ? c.v[b][x]
                      : c.v[b][x] + (v.v[b][x] - c.v[b][x]) * I),
                    (p.v[b][x] = P);
            }
            function r() {
              var d = this.comp.renderedFrame - this.offsetTime,
                p = this.keyframes[0].t - this.offsetTime,
                g =
                  this.keyframes[this.keyframes.length - 1].t - this.offsetTime,
                c = this._caching.lastFrame;
              return (
                (c !== e && ((c < p && d < p) || (c > g && d > g))) ||
                  ((this._caching.lastIndex =
                    c < d ? this._caching.lastIndex : 0),
                  this.interpolateShape(d, this.pv, this._caching)),
                (this._caching.lastFrame = d),
                this.pv
              );
            }
            function n() {
              this.paths = this.localShapeCollection;
            }
            function i(d) {
              (function (p, g) {
                if (p._length !== g._length || p.c !== g.c) return !1;
                var c,
                  v = p._length;
                for (c = 0; c < v; c += 1)
                  if (
                    p.v[c][0] !== g.v[c][0] ||
                    p.v[c][1] !== g.v[c][1] ||
                    p.o[c][0] !== g.o[c][0] ||
                    p.o[c][1] !== g.o[c][1] ||
                    p.i[c][0] !== g.i[c][0] ||
                    p.i[c][1] !== g.i[c][1]
                  )
                    return !1;
                return !0;
              })(this.v, d) ||
                ((this.v = shapePool.clone(d)),
                this.localShapeCollection.releaseShapes(),
                this.localShapeCollection.addShape(this.v),
                (this._mdf = !0),
                (this.paths = this.localShapeCollection));
            }
            function a() {
              if (this.elem.globalData.frameId !== this.frameId)
                if (this.effectsSequence.length)
                  if (this.lock) this.setVValue(this.pv);
                  else {
                    var d, p;
                    (this.lock = !0),
                      (this._mdf = !1),
                      (d = this.kf
                        ? this.pv
                        : this.data.ks
                        ? this.data.ks.k
                        : this.data.pt.k);
                    var g = this.effectsSequence.length;
                    for (p = 0; p < g; p += 1) d = this.effectsSequence[p](d);
                    this.setVValue(d),
                      (this.lock = !1),
                      (this.frameId = this.elem.globalData.frameId);
                  }
                else this._mdf = !1;
            }
            function o(d, p, g) {
              (this.propType = "shape"),
                (this.comp = d.comp),
                (this.container = d),
                (this.elem = d),
                (this.data = p),
                (this.k = !1),
                (this.kf = !1),
                (this._mdf = !1);
              var c = g === 3 ? p.pt.k : p.ks.k;
              (this.v = shapePool.clone(c)),
                (this.pv = shapePool.clone(this.v)),
                (this.localShapeCollection =
                  shapeCollectionPool.newShapeCollection()),
                (this.paths = this.localShapeCollection),
                this.paths.addShape(this.v),
                (this.reset = n),
                (this.effectsSequence = []);
            }
            function s(d) {
              this.effectsSequence.push(d),
                this.container.addDynamicProperty(this);
            }
            function l(d, p, g) {
              (this.propType = "shape"),
                (this.comp = d.comp),
                (this.elem = d),
                (this.container = d),
                (this.offsetTime = d.data.st),
                (this.keyframes = g === 3 ? p.pt.k : p.ks.k),
                (this.keyframesMetadata = []),
                (this.k = !0),
                (this.kf = !0);
              var c = this.keyframes[0].s[0].i.length;
              (this.v = shapePool.newElement()),
                this.v.setPathData(this.keyframes[0].s[0].c, c),
                (this.pv = shapePool.clone(this.v)),
                (this.localShapeCollection =
                  shapeCollectionPool.newShapeCollection()),
                (this.paths = this.localShapeCollection),
                this.paths.addShape(this.v),
                (this.lastFrame = e),
                (this.reset = n),
                (this._caching = { lastFrame: e, lastIndex: 0 }),
                (this.effectsSequence = [r.bind(this)]);
            }
            (o.prototype.interpolateShape = t),
              (o.prototype.getValue = a),
              (o.prototype.setVValue = i),
              (o.prototype.addEffect = s),
              (l.prototype.getValue = a),
              (l.prototype.interpolateShape = t),
              (l.prototype.setVValue = i),
              (l.prototype.addEffect = s);
            var f = (function () {
                var d = roundCorner;
                function p(g, c) {
                  (this.v = shapePool.newElement()),
                    this.v.setPathData(!0, 4),
                    (this.localShapeCollection =
                      shapeCollectionPool.newShapeCollection()),
                    (this.paths = this.localShapeCollection),
                    this.localShapeCollection.addShape(this.v),
                    (this.d = c.d),
                    (this.elem = g),
                    (this.comp = g.comp),
                    (this.frameId = -1),
                    this.initDynamicPropertyContainer(g),
                    (this.p = PropertyFactory.getProp(g, c.p, 1, 0, this)),
                    (this.s = PropertyFactory.getProp(g, c.s, 1, 0, this)),
                    this.dynamicProperties.length
                      ? (this.k = !0)
                      : ((this.k = !1), this.convertEllToPath());
                }
                return (
                  (p.prototype = {
                    reset: n,
                    getValue: function () {
                      this.elem.globalData.frameId !== this.frameId &&
                        ((this.frameId = this.elem.globalData.frameId),
                        this.iterateDynamicProperties(),
                        this._mdf && this.convertEllToPath());
                    },
                    convertEllToPath: function () {
                      var g = this.p.v[0],
                        c = this.p.v[1],
                        v = this.s.v[0] / 2,
                        y = this.s.v[1] / 2,
                        b = this.d !== 3,
                        x = this.v;
                      (x.v[0][0] = g),
                        (x.v[0][1] = c - y),
                        (x.v[1][0] = b ? g + v : g - v),
                        (x.v[1][1] = c),
                        (x.v[2][0] = g),
                        (x.v[2][1] = c + y),
                        (x.v[3][0] = b ? g - v : g + v),
                        (x.v[3][1] = c),
                        (x.i[0][0] = b ? g - v * d : g + v * d),
                        (x.i[0][1] = c - y),
                        (x.i[1][0] = b ? g + v : g - v),
                        (x.i[1][1] = c - y * d),
                        (x.i[2][0] = b ? g + v * d : g - v * d),
                        (x.i[2][1] = c + y),
                        (x.i[3][0] = b ? g - v : g + v),
                        (x.i[3][1] = c + y * d),
                        (x.o[0][0] = b ? g + v * d : g - v * d),
                        (x.o[0][1] = c - y),
                        (x.o[1][0] = b ? g + v : g - v),
                        (x.o[1][1] = c + y * d),
                        (x.o[2][0] = b ? g - v * d : g + v * d),
                        (x.o[2][1] = c + y),
                        (x.o[3][0] = b ? g - v : g + v),
                        (x.o[3][1] = c - y * d);
                    },
                  }),
                  extendPrototype([DynamicPropertyContainer], p),
                  p
                );
              })(),
              u = (function () {
                function d(p, g) {
                  (this.v = shapePool.newElement()),
                    this.v.setPathData(!0, 0),
                    (this.elem = p),
                    (this.comp = p.comp),
                    (this.data = g),
                    (this.frameId = -1),
                    (this.d = g.d),
                    this.initDynamicPropertyContainer(p),
                    g.sy === 1
                      ? ((this.ir = PropertyFactory.getProp(
                          p,
                          g.ir,
                          0,
                          0,
                          this
                        )),
                        (this.is = PropertyFactory.getProp(
                          p,
                          g.is,
                          0,
                          0.01,
                          this
                        )),
                        (this.convertToPath = this.convertStarToPath))
                      : (this.convertToPath = this.convertPolygonToPath),
                    (this.pt = PropertyFactory.getProp(p, g.pt, 0, 0, this)),
                    (this.p = PropertyFactory.getProp(p, g.p, 1, 0, this)),
                    (this.r = PropertyFactory.getProp(
                      p,
                      g.r,
                      0,
                      degToRads,
                      this
                    )),
                    (this.or = PropertyFactory.getProp(p, g.or, 0, 0, this)),
                    (this.os = PropertyFactory.getProp(p, g.os, 0, 0.01, this)),
                    (this.localShapeCollection =
                      shapeCollectionPool.newShapeCollection()),
                    this.localShapeCollection.addShape(this.v),
                    (this.paths = this.localShapeCollection),
                    this.dynamicProperties.length
                      ? (this.k = !0)
                      : ((this.k = !1), this.convertToPath());
                }
                return (
                  (d.prototype = {
                    reset: n,
                    getValue: function () {
                      this.elem.globalData.frameId !== this.frameId &&
                        ((this.frameId = this.elem.globalData.frameId),
                        this.iterateDynamicProperties(),
                        this._mdf && this.convertToPath());
                    },
                    convertStarToPath: function () {
                      var p,
                        g,
                        c,
                        v,
                        y = 2 * Math.floor(this.pt.v),
                        b = (2 * Math.PI) / y,
                        x = !0,
                        S = this.or.v,
                        T = this.ir.v,
                        I = this.os.v,
                        P = this.is.v,
                        L = (2 * Math.PI * S) / (2 * y),
                        M = (2 * Math.PI * T) / (2 * y),
                        _ = -Math.PI / 2;
                      _ += this.r.v;
                      var F = this.data.d === 3 ? -1 : 1;
                      for (this.v._length = 0, p = 0; p < y; p += 1) {
                        (c = x ? I : P), (v = x ? L : M);
                        var w = (g = x ? S : T) * Math.cos(_),
                          R = g * Math.sin(_),
                          k =
                            w === 0 && R === 0
                              ? 0
                              : R / Math.sqrt(w * w + R * R),
                          z =
                            w === 0 && R === 0
                              ? 0
                              : -w / Math.sqrt(w * w + R * R);
                        (w += +this.p.v[0]),
                          (R += +this.p.v[1]),
                          this.v.setTripleAt(
                            w,
                            R,
                            w - k * v * c * F,
                            R - z * v * c * F,
                            w + k * v * c * F,
                            R + z * v * c * F,
                            p,
                            !0
                          ),
                          (x = !x),
                          (_ += b * F);
                      }
                    },
                    convertPolygonToPath: function () {
                      var p,
                        g = Math.floor(this.pt.v),
                        c = (2 * Math.PI) / g,
                        v = this.or.v,
                        y = this.os.v,
                        b = (2 * Math.PI * v) / (4 * g),
                        x = 0.5 * -Math.PI,
                        S = this.data.d === 3 ? -1 : 1;
                      for (
                        x += this.r.v, this.v._length = 0, p = 0;
                        p < g;
                        p += 1
                      ) {
                        var T = v * Math.cos(x),
                          I = v * Math.sin(x),
                          P =
                            T === 0 && I === 0
                              ? 0
                              : I / Math.sqrt(T * T + I * I),
                          L =
                            T === 0 && I === 0
                              ? 0
                              : -T / Math.sqrt(T * T + I * I);
                        (T += +this.p.v[0]),
                          (I += +this.p.v[1]),
                          this.v.setTripleAt(
                            T,
                            I,
                            T - P * b * y * S,
                            I - L * b * y * S,
                            T + P * b * y * S,
                            I + L * b * y * S,
                            p,
                            !0
                          ),
                          (x += c * S);
                      }
                      (this.paths.length = 0), (this.paths[0] = this.v);
                    },
                  }),
                  extendPrototype([DynamicPropertyContainer], d),
                  d
                );
              })(),
              h = (function () {
                function d(p, g) {
                  (this.v = shapePool.newElement()),
                    (this.v.c = !0),
                    (this.localShapeCollection =
                      shapeCollectionPool.newShapeCollection()),
                    this.localShapeCollection.addShape(this.v),
                    (this.paths = this.localShapeCollection),
                    (this.elem = p),
                    (this.comp = p.comp),
                    (this.frameId = -1),
                    (this.d = g.d),
                    this.initDynamicPropertyContainer(p),
                    (this.p = PropertyFactory.getProp(p, g.p, 1, 0, this)),
                    (this.s = PropertyFactory.getProp(p, g.s, 1, 0, this)),
                    (this.r = PropertyFactory.getProp(p, g.r, 0, 0, this)),
                    this.dynamicProperties.length
                      ? (this.k = !0)
                      : ((this.k = !1), this.convertRectToPath());
                }
                return (
                  (d.prototype = {
                    convertRectToPath: function () {
                      var p = this.p.v[0],
                        g = this.p.v[1],
                        c = this.s.v[0] / 2,
                        v = this.s.v[1] / 2,
                        y = bmMin(c, v, this.r.v),
                        b = y * (1 - roundCorner);
                      (this.v._length = 0),
                        this.d === 2 || this.d === 1
                          ? (this.v.setTripleAt(
                              p + c,
                              g - v + y,
                              p + c,
                              g - v + y,
                              p + c,
                              g - v + b,
                              0,
                              !0
                            ),
                            this.v.setTripleAt(
                              p + c,
                              g + v - y,
                              p + c,
                              g + v - b,
                              p + c,
                              g + v - y,
                              1,
                              !0
                            ),
                            y !== 0
                              ? (this.v.setTripleAt(
                                  p + c - y,
                                  g + v,
                                  p + c - y,
                                  g + v,
                                  p + c - b,
                                  g + v,
                                  2,
                                  !0
                                ),
                                this.v.setTripleAt(
                                  p - c + y,
                                  g + v,
                                  p - c + b,
                                  g + v,
                                  p - c + y,
                                  g + v,
                                  3,
                                  !0
                                ),
                                this.v.setTripleAt(
                                  p - c,
                                  g + v - y,
                                  p - c,
                                  g + v - y,
                                  p - c,
                                  g + v - b,
                                  4,
                                  !0
                                ),
                                this.v.setTripleAt(
                                  p - c,
                                  g - v + y,
                                  p - c,
                                  g - v + b,
                                  p - c,
                                  g - v + y,
                                  5,
                                  !0
                                ),
                                this.v.setTripleAt(
                                  p - c + y,
                                  g - v,
                                  p - c + y,
                                  g - v,
                                  p - c + b,
                                  g - v,
                                  6,
                                  !0
                                ),
                                this.v.setTripleAt(
                                  p + c - y,
                                  g - v,
                                  p + c - b,
                                  g - v,
                                  p + c - y,
                                  g - v,
                                  7,
                                  !0
                                ))
                              : (this.v.setTripleAt(
                                  p - c,
                                  g + v,
                                  p - c + b,
                                  g + v,
                                  p - c,
                                  g + v,
                                  2
                                ),
                                this.v.setTripleAt(
                                  p - c,
                                  g - v,
                                  p - c,
                                  g - v + b,
                                  p - c,
                                  g - v,
                                  3
                                )))
                          : (this.v.setTripleAt(
                              p + c,
                              g - v + y,
                              p + c,
                              g - v + b,
                              p + c,
                              g - v + y,
                              0,
                              !0
                            ),
                            y !== 0
                              ? (this.v.setTripleAt(
                                  p + c - y,
                                  g - v,
                                  p + c - y,
                                  g - v,
                                  p + c - b,
                                  g - v,
                                  1,
                                  !0
                                ),
                                this.v.setTripleAt(
                                  p - c + y,
                                  g - v,
                                  p - c + b,
                                  g - v,
                                  p - c + y,
                                  g - v,
                                  2,
                                  !0
                                ),
                                this.v.setTripleAt(
                                  p - c,
                                  g - v + y,
                                  p - c,
                                  g - v + y,
                                  p - c,
                                  g - v + b,
                                  3,
                                  !0
                                ),
                                this.v.setTripleAt(
                                  p - c,
                                  g + v - y,
                                  p - c,
                                  g + v - b,
                                  p - c,
                                  g + v - y,
                                  4,
                                  !0
                                ),
                                this.v.setTripleAt(
                                  p - c + y,
                                  g + v,
                                  p - c + y,
                                  g + v,
                                  p - c + b,
                                  g + v,
                                  5,
                                  !0
                                ),
                                this.v.setTripleAt(
                                  p + c - y,
                                  g + v,
                                  p + c - b,
                                  g + v,
                                  p + c - y,
                                  g + v,
                                  6,
                                  !0
                                ),
                                this.v.setTripleAt(
                                  p + c,
                                  g + v - y,
                                  p + c,
                                  g + v - y,
                                  p + c,
                                  g + v - b,
                                  7,
                                  !0
                                ))
                              : (this.v.setTripleAt(
                                  p - c,
                                  g - v,
                                  p - c + b,
                                  g - v,
                                  p - c,
                                  g - v,
                                  1,
                                  !0
                                ),
                                this.v.setTripleAt(
                                  p - c,
                                  g + v,
                                  p - c,
                                  g + v - b,
                                  p - c,
                                  g + v,
                                  2,
                                  !0
                                ),
                                this.v.setTripleAt(
                                  p + c,
                                  g + v,
                                  p + c - b,
                                  g + v,
                                  p + c,
                                  g + v,
                                  3,
                                  !0
                                )));
                    },
                    getValue: function () {
                      this.elem.globalData.frameId !== this.frameId &&
                        ((this.frameId = this.elem.globalData.frameId),
                        this.iterateDynamicProperties(),
                        this._mdf && this.convertRectToPath());
                    },
                    reset: n,
                  }),
                  extendPrototype([DynamicPropertyContainer], d),
                  d
                );
              })(),
              m = {
                getShapeProp: function (d, p, g) {
                  var c;
                  return (
                    g === 3 || g === 4
                      ? (c = (g === 3 ? p.pt : p.ks).k.length
                          ? new l(d, p, g)
                          : new o(d, p, g))
                      : g === 5
                      ? (c = new h(d, p))
                      : g === 6
                      ? (c = new f(d, p))
                      : g === 7 && (c = new u(d, p)),
                    c.k && d.addDynamicProperty(c),
                    c
                  );
                },
                getConstructorFunction: function () {
                  return o;
                },
                getKeyframedConstructorFunction: function () {
                  return l;
                },
              };
            return m;
          })(),
          Matrix = (function () {
            var e = Math.cos,
              t = Math.sin,
              r = Math.tan,
              n = Math.round;
            function i() {
              return (
                (this.props[0] = 1),
                (this.props[1] = 0),
                (this.props[2] = 0),
                (this.props[3] = 0),
                (this.props[4] = 0),
                (this.props[5] = 1),
                (this.props[6] = 0),
                (this.props[7] = 0),
                (this.props[8] = 0),
                (this.props[9] = 0),
                (this.props[10] = 1),
                (this.props[11] = 0),
                (this.props[12] = 0),
                (this.props[13] = 0),
                (this.props[14] = 0),
                (this.props[15] = 1),
                this
              );
            }
            function a(A) {
              if (A === 0) return this;
              var N = e(A),
                X = t(A);
              return this._t(N, -X, 0, 0, X, N, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1);
            }
            function o(A) {
              if (A === 0) return this;
              var N = e(A),
                X = t(A);
              return this._t(1, 0, 0, 0, 0, N, -X, 0, 0, X, N, 0, 0, 0, 0, 1);
            }
            function s(A) {
              if (A === 0) return this;
              var N = e(A),
                X = t(A);
              return this._t(N, 0, X, 0, 0, 1, 0, 0, -X, 0, N, 0, 0, 0, 0, 1);
            }
            function l(A) {
              if (A === 0) return this;
              var N = e(A),
                X = t(A);
              return this._t(N, -X, 0, 0, X, N, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1);
            }
            function f(A, N) {
              return this._t(1, N, A, 1, 0, 0);
            }
            function u(A, N) {
              return this.shear(r(A), r(N));
            }
            function h(A, N) {
              var X = e(N),
                ae = t(N);
              return this._t(X, ae, 0, 0, -ae, X, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1)
                ._t(1, 0, 0, 0, r(A), 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1)
                ._t(X, -ae, 0, 0, ae, X, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1);
            }
            function m(A, N, X) {
              return (
                X || X === 0 || (X = 1),
                A === 1 && N === 1 && X === 1
                  ? this
                  : this._t(A, 0, 0, 0, 0, N, 0, 0, 0, 0, X, 0, 0, 0, 0, 1)
              );
            }
            function d(A, N, X, ae, W, q, O, H, j, V, Z, ie, te, D, J, ne) {
              return (
                (this.props[0] = A),
                (this.props[1] = N),
                (this.props[2] = X),
                (this.props[3] = ae),
                (this.props[4] = W),
                (this.props[5] = q),
                (this.props[6] = O),
                (this.props[7] = H),
                (this.props[8] = j),
                (this.props[9] = V),
                (this.props[10] = Z),
                (this.props[11] = ie),
                (this.props[12] = te),
                (this.props[13] = D),
                (this.props[14] = J),
                (this.props[15] = ne),
                this
              );
            }
            function p(A, N, X) {
              return (
                (X = X || 0),
                A !== 0 || N !== 0 || X !== 0
                  ? this._t(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, A, N, X, 1)
                  : this
              );
            }
            function g(A, N, X, ae, W, q, O, H, j, V, Z, ie, te, D, J, ne) {
              var Y = this.props;
              if (
                A === 1 &&
                N === 0 &&
                X === 0 &&
                ae === 0 &&
                W === 0 &&
                q === 1 &&
                O === 0 &&
                H === 0 &&
                j === 0 &&
                V === 0 &&
                Z === 1 &&
                ie === 0
              )
                return (
                  (Y[12] = Y[12] * A + Y[15] * te),
                  (Y[13] = Y[13] * q + Y[15] * D),
                  (Y[14] = Y[14] * Z + Y[15] * J),
                  (Y[15] *= ne),
                  (this._identityCalculated = !1),
                  this
                );
              var de = Y[0],
                Oe = Y[1],
                Ie = Y[2],
                C = Y[3],
                B = Y[4],
                G = Y[5],
                U = Y[6],
                Q = Y[7],
                K = Y[8],
                se = Y[9],
                le = Y[10],
                oe = Y[11],
                re = Y[12],
                ce = Y[13],
                fe = Y[14],
                xe = Y[15];
              return (
                (Y[0] = de * A + Oe * W + Ie * j + C * te),
                (Y[1] = de * N + Oe * q + Ie * V + C * D),
                (Y[2] = de * X + Oe * O + Ie * Z + C * J),
                (Y[3] = de * ae + Oe * H + Ie * ie + C * ne),
                (Y[4] = B * A + G * W + U * j + Q * te),
                (Y[5] = B * N + G * q + U * V + Q * D),
                (Y[6] = B * X + G * O + U * Z + Q * J),
                (Y[7] = B * ae + G * H + U * ie + Q * ne),
                (Y[8] = K * A + se * W + le * j + oe * te),
                (Y[9] = K * N + se * q + le * V + oe * D),
                (Y[10] = K * X + se * O + le * Z + oe * J),
                (Y[11] = K * ae + se * H + le * ie + oe * ne),
                (Y[12] = re * A + ce * W + fe * j + xe * te),
                (Y[13] = re * N + ce * q + fe * V + xe * D),
                (Y[14] = re * X + ce * O + fe * Z + xe * J),
                (Y[15] = re * ae + ce * H + fe * ie + xe * ne),
                (this._identityCalculated = !1),
                this
              );
            }
            function c(A) {
              var N = A.props;
              return this.transform(
                N[0],
                N[1],
                N[2],
                N[3],
                N[4],
                N[5],
                N[6],
                N[7],
                N[8],
                N[9],
                N[10],
                N[11],
                N[12],
                N[13],
                N[14],
                N[15]
              );
            }
            function v() {
              return (
                this._identityCalculated ||
                  ((this._identity = !(
                    this.props[0] !== 1 ||
                    this.props[1] !== 0 ||
                    this.props[2] !== 0 ||
                    this.props[3] !== 0 ||
                    this.props[4] !== 0 ||
                    this.props[5] !== 1 ||
                    this.props[6] !== 0 ||
                    this.props[7] !== 0 ||
                    this.props[8] !== 0 ||
                    this.props[9] !== 0 ||
                    this.props[10] !== 1 ||
                    this.props[11] !== 0 ||
                    this.props[12] !== 0 ||
                    this.props[13] !== 0 ||
                    this.props[14] !== 0 ||
                    this.props[15] !== 1
                  )),
                  (this._identityCalculated = !0)),
                this._identity
              );
            }
            function y(A) {
              for (var N = 0; N < 16; ) {
                if (A.props[N] !== this.props[N]) return !1;
                N += 1;
              }
              return !0;
            }
            function b(A) {
              var N;
              for (N = 0; N < 16; N += 1) A.props[N] = this.props[N];
              return A;
            }
            function x(A) {
              var N;
              for (N = 0; N < 16; N += 1) this.props[N] = A[N];
            }
            function S(A, N, X) {
              return {
                x:
                  A * this.props[0] +
                  N * this.props[4] +
                  X * this.props[8] +
                  this.props[12],
                y:
                  A * this.props[1] +
                  N * this.props[5] +
                  X * this.props[9] +
                  this.props[13],
                z:
                  A * this.props[2] +
                  N * this.props[6] +
                  X * this.props[10] +
                  this.props[14],
              };
            }
            function T(A, N, X) {
              return (
                A * this.props[0] +
                N * this.props[4] +
                X * this.props[8] +
                this.props[12]
              );
            }
            function I(A, N, X) {
              return (
                A * this.props[1] +
                N * this.props[5] +
                X * this.props[9] +
                this.props[13]
              );
            }
            function P(A, N, X) {
              return (
                A * this.props[2] +
                N * this.props[6] +
                X * this.props[10] +
                this.props[14]
              );
            }
            function L() {
              var A =
                  this.props[0] * this.props[5] - this.props[1] * this.props[4],
                N = this.props[5] / A,
                X = -this.props[1] / A,
                ae = -this.props[4] / A,
                W = this.props[0] / A,
                q =
                  (this.props[4] * this.props[13] -
                    this.props[5] * this.props[12]) /
                  A,
                O =
                  -(
                    this.props[0] * this.props[13] -
                    this.props[1] * this.props[12]
                  ) / A,
                H = new Matrix();
              return (
                (H.props[0] = N),
                (H.props[1] = X),
                (H.props[4] = ae),
                (H.props[5] = W),
                (H.props[12] = q),
                (H.props[13] = O),
                H
              );
            }
            function M(A) {
              return this.getInverseMatrix().applyToPointArray(
                A[0],
                A[1],
                A[2] || 0
              );
            }
            function _(A) {
              var N,
                X = A.length,
                ae = [];
              for (N = 0; N < X; N += 1) ae[N] = M(A[N]);
              return ae;
            }
            function F(A, N, X) {
              var ae = createTypedArray("float32", 6);
              if (this.isIdentity())
                (ae[0] = A[0]),
                  (ae[1] = A[1]),
                  (ae[2] = N[0]),
                  (ae[3] = N[1]),
                  (ae[4] = X[0]),
                  (ae[5] = X[1]);
              else {
                var W = this.props[0],
                  q = this.props[1],
                  O = this.props[4],
                  H = this.props[5],
                  j = this.props[12],
                  V = this.props[13];
                (ae[0] = A[0] * W + A[1] * O + j),
                  (ae[1] = A[0] * q + A[1] * H + V),
                  (ae[2] = N[0] * W + N[1] * O + j),
                  (ae[3] = N[0] * q + N[1] * H + V),
                  (ae[4] = X[0] * W + X[1] * O + j),
                  (ae[5] = X[0] * q + X[1] * H + V);
              }
              return ae;
            }
            function w(A, N, X) {
              return this.isIdentity()
                ? [A, N, X]
                : [
                    A * this.props[0] +
                      N * this.props[4] +
                      X * this.props[8] +
                      this.props[12],
                    A * this.props[1] +
                      N * this.props[5] +
                      X * this.props[9] +
                      this.props[13],
                    A * this.props[2] +
                      N * this.props[6] +
                      X * this.props[10] +
                      this.props[14],
                  ];
            }
            function R(A, N) {
              if (this.isIdentity()) return A + "," + N;
              var X = this.props;
              return (
                Math.round(100 * (A * X[0] + N * X[4] + X[12])) / 100 +
                "," +
                Math.round(100 * (A * X[1] + N * X[5] + X[13])) / 100
              );
            }
            function k() {
              for (var A = 0, N = this.props, X = "matrix3d("; A < 16; )
                (X += n(1e4 * N[A]) / 1e4),
                  (X += A === 15 ? ")" : ","),
                  (A += 1);
              return X;
            }
            function z(A) {
              return (A < 1e-6 && A > 0) || (A > -1e-6 && A < 0)
                ? n(1e4 * A) / 1e4
                : A;
            }
            function ee() {
              var A = this.props;
              return (
                "matrix(" +
                z(A[0]) +
                "," +
                z(A[1]) +
                "," +
                z(A[4]) +
                "," +
                z(A[5]) +
                "," +
                z(A[12]) +
                "," +
                z(A[13]) +
                ")"
              );
            }
            return function () {
              (this.reset = i),
                (this.rotate = a),
                (this.rotateX = o),
                (this.rotateY = s),
                (this.rotateZ = l),
                (this.skew = u),
                (this.skewFromAxis = h),
                (this.shear = f),
                (this.scale = m),
                (this.setTransform = d),
                (this.translate = p),
                (this.transform = g),
                (this.multiply = c),
                (this.applyToPoint = S),
                (this.applyToX = T),
                (this.applyToY = I),
                (this.applyToZ = P),
                (this.applyToPointArray = w),
                (this.applyToTriplePoints = F),
                (this.applyToPointStringified = R),
                (this.toCSS = k),
                (this.to2dCSS = ee),
                (this.clone = b),
                (this.cloneFromProps = x),
                (this.equals = y),
                (this.inversePoints = _),
                (this.inversePoint = M),
                (this.getInverseMatrix = L),
                (this._t = this.transform),
                (this.isIdentity = v),
                (this._identity = !0),
                (this._identityCalculated = !1),
                (this.props = createTypedArray("float32", 16)),
                this.reset();
            };
          })();
        function _typeof$3(e) {
          return (
            (_typeof$3 =
              typeof Symbol == "function" && typeof Symbol.iterator == "symbol"
                ? function (t) {
                    return typeof t;
                  }
                : function (t) {
                    return t &&
                      typeof Symbol == "function" &&
                      t.constructor === Symbol &&
                      t !== Symbol.prototype
                      ? "symbol"
                      : typeof t;
                  }),
            _typeof$3(e)
          );
        }
        var lottie = {},
          standalone = "__[STANDALONE]__",
          animationData = "__[ANIMATIONDATA]__",
          renderer = "";
        function setLocation(e) {
          setLocationHref(e);
        }
        function searchAnimations() {
          standalone === !0
            ? animationManager.searchAnimations(
                animationData,
                standalone,
                renderer
              )
            : animationManager.searchAnimations();
        }
        function setSubframeRendering(e) {
          setSubframeEnabled(e);
        }
        function setPrefix(e) {
          setIdPrefix(e);
        }
        function loadAnimation(e) {
          return (
            standalone === !0 && (e.animationData = JSON.parse(animationData)),
            animationManager.loadAnimation(e)
          );
        }
        function setQuality(e) {
          if (typeof e == "string")
            switch (e) {
              case "high":
                setDefaultCurveSegments(200);
                break;
              default:
              case "medium":
                setDefaultCurveSegments(50);
                break;
              case "low":
                setDefaultCurveSegments(10);
            }
          else !isNaN(e) && e > 1 && setDefaultCurveSegments(e);
          getDefaultCurveSegments() >= 50 ? roundValues(!1) : roundValues(!0);
        }
        function inBrowser() {
          return typeof navigator < "u";
        }
        function installPlugin(e, t) {
          e === "expressions" && setExpressionsPlugin(t);
        }
        function getFactory(e) {
          switch (e) {
            case "propertyFactory":
              return PropertyFactory;
            case "shapePropertyFactory":
              return ShapePropertyFactory;
            case "matrix":
              return Matrix;
            default:
              return null;
          }
        }
        function checkReady() {
          document.readyState === "complete" &&
            (clearInterval(readyStateCheckInterval), searchAnimations());
        }
        function getQueryVariable(e) {
          for (var t = queryString.split("&"), r = 0; r < t.length; r += 1) {
            var n = t[r].split("=");
            if (decodeURIComponent(n[0]) == e) return decodeURIComponent(n[1]);
          }
          return null;
        }
        (lottie.play = animationManager.play),
          (lottie.pause = animationManager.pause),
          (lottie.setLocationHref = setLocation),
          (lottie.togglePause = animationManager.togglePause),
          (lottie.setSpeed = animationManager.setSpeed),
          (lottie.setDirection = animationManager.setDirection),
          (lottie.stop = animationManager.stop),
          (lottie.searchAnimations = searchAnimations),
          (lottie.registerAnimation = animationManager.registerAnimation),
          (lottie.loadAnimation = loadAnimation),
          (lottie.setSubframeRendering = setSubframeRendering),
          (lottie.resize = animationManager.resize),
          (lottie.goToAndStop = animationManager.goToAndStop),
          (lottie.destroy = animationManager.destroy),
          (lottie.setQuality = setQuality),
          (lottie.inBrowser = inBrowser),
          (lottie.installPlugin = installPlugin),
          (lottie.freeze = animationManager.freeze),
          (lottie.unfreeze = animationManager.unfreeze),
          (lottie.setVolume = animationManager.setVolume),
          (lottie.mute = animationManager.mute),
          (lottie.unmute = animationManager.unmute),
          (lottie.getRegisteredAnimations =
            animationManager.getRegisteredAnimations),
          (lottie.useWebWorker = setWebWorker),
          (lottie.setIDPrefix = setPrefix),
          (lottie.__getFactory = getFactory),
          (lottie.version = "5.12.2");
        var queryString = "";
        if (standalone) {
          var scripts = document.getElementsByTagName("script"),
            index = scripts.length - 1,
            myScript = scripts[index] || { src: "" };
          (queryString = myScript.src
            ? myScript.src.replace(/^[^\?]+\??/, "")
            : ""),
            (renderer = getQueryVariable("renderer"));
        }
        var readyStateCheckInterval = setInterval(checkReady, 100);
        try {
          ((typeof exports > "u" ? "undefined" : _typeof$3(exports)) ===
            "object" &&
            typeof module < "u") ||
            (typeof define == "function" && define.amd) ||
            (window.bodymovin = lottie);
        } catch (e) {}
        var ShapeModifiers = (function () {
          var e = {},
            t = {};
          return (
            (e.registerModifier = function (r, n) {
              t[r] || (t[r] = n);
            }),
            (e.getModifier = function (r, n, i) {
              return new t[r](n, i);
            }),
            e
          );
        })();
        function ShapeModifier() {}
        function TrimModifier() {}
        function PuckerAndBloatModifier() {}
        (ShapeModifier.prototype.initModifierProperties = function () {}),
          (ShapeModifier.prototype.addShapeToModifier = function () {}),
          (ShapeModifier.prototype.addShape = function (e) {
            if (!this.closed) {
              e.sh.container.addDynamicProperty(e.sh);
              var t = {
                shape: e.sh,
                data: e,
                localShapeCollection: shapeCollectionPool.newShapeCollection(),
              };
              this.shapes.push(t),
                this.addShapeToModifier(t),
                this._isAnimated && e.setAsAnimated();
            }
          }),
          (ShapeModifier.prototype.init = function (e, t) {
            (this.shapes = []),
              (this.elem = e),
              this.initDynamicPropertyContainer(e),
              this.initModifierProperties(e, t),
              (this.frameId = initialDefaultFrame),
              (this.closed = !1),
              (this.k = !1),
              this.dynamicProperties.length ? (this.k = !0) : this.getValue(!0);
          }),
          (ShapeModifier.prototype.processKeys = function () {
            this.elem.globalData.frameId !== this.frameId &&
              ((this.frameId = this.elem.globalData.frameId),
              this.iterateDynamicProperties());
          }),
          extendPrototype([DynamicPropertyContainer], ShapeModifier),
          extendPrototype([ShapeModifier], TrimModifier),
          (TrimModifier.prototype.initModifierProperties = function (e, t) {
            (this.s = PropertyFactory.getProp(e, t.s, 0, 0.01, this)),
              (this.e = PropertyFactory.getProp(e, t.e, 0, 0.01, this)),
              (this.o = PropertyFactory.getProp(e, t.o, 0, 0, this)),
              (this.sValue = 0),
              (this.eValue = 0),
              (this.getValue = this.processKeys),
              (this.m = t.m),
              (this._isAnimated =
                !!this.s.effectsSequence.length ||
                !!this.e.effectsSequence.length ||
                !!this.o.effectsSequence.length);
          }),
          (TrimModifier.prototype.addShapeToModifier = function (e) {
            e.pathsData = [];
          }),
          (TrimModifier.prototype.calculateShapeEdges = function (
            e,
            t,
            r,
            n,
            i
          ) {
            var a = [];
            t <= 1
              ? a.push({ s: e, e: t })
              : e >= 1
              ? a.push({ s: e - 1, e: t - 1 })
              : (a.push({ s: e, e: 1 }), a.push({ s: 0, e: t - 1 }));
            var o,
              s,
              l = [],
              f = a.length;
            for (o = 0; o < f; o += 1) {
              var u, h;
              (s = a[o]).e * i < n ||
                s.s * i > n + r ||
                ((u = s.s * i <= n ? 0 : (s.s * i - n) / r),
                (h = s.e * i >= n + r ? 1 : (s.e * i - n) / r),
                l.push([u, h]));
            }
            return l.length || l.push([0, 0]), l;
          }),
          (TrimModifier.prototype.releasePathsData = function (e) {
            var t,
              r = e.length;
            for (t = 0; t < r; t += 1) segmentsLengthPool.release(e[t]);
            return (e.length = 0), e;
          }),
          (TrimModifier.prototype.processShapes = function (e) {
            var t, r, n, i;
            if (this._mdf || e) {
              var a = (this.o.v % 360) / 360;
              if (
                (a < 0 && (a += 1),
                (t =
                  this.s.v > 1 ? 1 + a : this.s.v < 0 ? 0 + a : this.s.v + a) >
                  (r =
                    this.e.v > 1 ? 1 + a : this.e.v < 0 ? 0 + a : this.e.v + a))
              ) {
                var o = t;
                (t = r), (r = o);
              }
              (t = 1e-4 * Math.round(1e4 * t)),
                (r = 1e-4 * Math.round(1e4 * r)),
                (this.sValue = t),
                (this.eValue = r);
            } else (t = this.sValue), (r = this.eValue);
            var s,
              l,
              f,
              u,
              h,
              m = this.shapes.length,
              d = 0;
            if (r === t)
              for (i = 0; i < m; i += 1)
                this.shapes[i].localShapeCollection.releaseShapes(),
                  (this.shapes[i].shape._mdf = !0),
                  (this.shapes[i].shape.paths =
                    this.shapes[i].localShapeCollection),
                  this._mdf && (this.shapes[i].pathsData.length = 0);
            else if ((r === 1 && t === 0) || (r === 0 && t === 1)) {
              if (this._mdf)
                for (i = 0; i < m; i += 1)
                  (this.shapes[i].pathsData.length = 0),
                    (this.shapes[i].shape._mdf = !0);
            } else {
              var p,
                g,
                c = [];
              for (i = 0; i < m; i += 1)
                if (
                  (p = this.shapes[i]).shape._mdf ||
                  this._mdf ||
                  e ||
                  this.m === 2
                ) {
                  if (
                    ((l = (n = p.shape.paths)._length),
                    (h = 0),
                    !p.shape._mdf && p.pathsData.length)
                  )
                    h = p.totalShapeLength;
                  else {
                    for (
                      f = this.releasePathsData(p.pathsData), s = 0;
                      s < l;
                      s += 1
                    )
                      (u = bez.getSegmentsLength(n.shapes[s])),
                        f.push(u),
                        (h += u.totalLength);
                    (p.totalShapeLength = h), (p.pathsData = f);
                  }
                  (d += h), (p.shape._mdf = !0);
                } else p.shape.paths = p.localShapeCollection;
              var v,
                y = t,
                b = r,
                x = 0;
              for (i = m - 1; i >= 0; i -= 1)
                if ((p = this.shapes[i]).shape._mdf) {
                  for (
                    (g = p.localShapeCollection).releaseShapes(),
                      this.m === 2 && m > 1
                        ? ((v = this.calculateShapeEdges(
                            t,
                            r,
                            p.totalShapeLength,
                            x,
                            d
                          )),
                          (x += p.totalShapeLength))
                        : (v = [[y, b]]),
                      l = v.length,
                      s = 0;
                    s < l;
                    s += 1
                  ) {
                    (y = v[s][0]),
                      (b = v[s][1]),
                      (c.length = 0),
                      b <= 1
                        ? c.push({
                            s: p.totalShapeLength * y,
                            e: p.totalShapeLength * b,
                          })
                        : y >= 1
                        ? c.push({
                            s: p.totalShapeLength * (y - 1),
                            e: p.totalShapeLength * (b - 1),
                          })
                        : (c.push({
                            s: p.totalShapeLength * y,
                            e: p.totalShapeLength,
                          }),
                          c.push({ s: 0, e: p.totalShapeLength * (b - 1) }));
                    var S = this.addShapes(p, c[0]);
                    if (c[0].s !== c[0].e) {
                      if (c.length > 1)
                        if (p.shape.paths.shapes[p.shape.paths._length - 1].c) {
                          var T = S.pop();
                          this.addPaths(S, g), (S = this.addShapes(p, c[1], T));
                        } else
                          this.addPaths(S, g), (S = this.addShapes(p, c[1]));
                      this.addPaths(S, g);
                    }
                  }
                  p.shape.paths = g;
                }
            }
          }),
          (TrimModifier.prototype.addPaths = function (e, t) {
            var r,
              n = e.length;
            for (r = 0; r < n; r += 1) t.addShape(e[r]);
          }),
          (TrimModifier.prototype.addSegment = function (e, t, r, n, i, a, o) {
            i.setXYAt(t[0], t[1], "o", a),
              i.setXYAt(r[0], r[1], "i", a + 1),
              o && i.setXYAt(e[0], e[1], "v", a),
              i.setXYAt(n[0], n[1], "v", a + 1);
          }),
          (TrimModifier.prototype.addSegmentFromArray = function (e, t, r, n) {
            t.setXYAt(e[1], e[5], "o", r),
              t.setXYAt(e[2], e[6], "i", r + 1),
              n && t.setXYAt(e[0], e[4], "v", r),
              t.setXYAt(e[3], e[7], "v", r + 1);
          }),
          (TrimModifier.prototype.addShapes = function (e, t, r) {
            var n,
              i,
              a,
              o,
              s,
              l,
              f,
              u,
              h = e.pathsData,
              m = e.shape.paths.shapes,
              d = e.shape.paths._length,
              p = 0,
              g = [],
              c = !0;
            for (
              r
                ? ((s = r._length), (u = r._length))
                : ((r = shapePool.newElement()), (s = 0), (u = 0)),
                g.push(r),
                n = 0;
              n < d;
              n += 1
            ) {
              for (
                l = h[n].lengths,
                  r.c = m[n].c,
                  a = m[n].c ? l.length : l.length + 1,
                  i = 1;
                i < a;
                i += 1
              )
                if (p + (o = l[i - 1]).addedLength < t.s)
                  (p += o.addedLength), (r.c = !1);
                else {
                  if (p > t.e) {
                    r.c = !1;
                    break;
                  }
                  t.s <= p && t.e >= p + o.addedLength
                    ? (this.addSegment(
                        m[n].v[i - 1],
                        m[n].o[i - 1],
                        m[n].i[i],
                        m[n].v[i],
                        r,
                        s,
                        c
                      ),
                      (c = !1))
                    : ((f = bez.getNewSegment(
                        m[n].v[i - 1],
                        m[n].v[i],
                        m[n].o[i - 1],
                        m[n].i[i],
                        (t.s - p) / o.addedLength,
                        (t.e - p) / o.addedLength,
                        l[i - 1]
                      )),
                      this.addSegmentFromArray(f, r, s, c),
                      (c = !1),
                      (r.c = !1)),
                    (p += o.addedLength),
                    (s += 1);
                }
              if (m[n].c && l.length) {
                if (((o = l[i - 1]), p <= t.e)) {
                  var v = l[i - 1].addedLength;
                  t.s <= p && t.e >= p + v
                    ? (this.addSegment(
                        m[n].v[i - 1],
                        m[n].o[i - 1],
                        m[n].i[0],
                        m[n].v[0],
                        r,
                        s,
                        c
                      ),
                      (c = !1))
                    : ((f = bez.getNewSegment(
                        m[n].v[i - 1],
                        m[n].v[0],
                        m[n].o[i - 1],
                        m[n].i[0],
                        (t.s - p) / v,
                        (t.e - p) / v,
                        l[i - 1]
                      )),
                      this.addSegmentFromArray(f, r, s, c),
                      (c = !1),
                      (r.c = !1));
                } else r.c = !1;
                (p += o.addedLength), (s += 1);
              }
              if (
                (r._length &&
                  (r.setXYAt(r.v[u][0], r.v[u][1], "i", u),
                  r.setXYAt(
                    r.v[r._length - 1][0],
                    r.v[r._length - 1][1],
                    "o",
                    r._length - 1
                  )),
                p > t.e)
              )
                break;
              n < d - 1 &&
                ((r = shapePool.newElement()), (c = !0), g.push(r), (s = 0));
            }
            return g;
          }),
          extendPrototype([ShapeModifier], PuckerAndBloatModifier),
          (PuckerAndBloatModifier.prototype.initModifierProperties = function (
            e,
            t
          ) {
            (this.getValue = this.processKeys),
              (this.amount = PropertyFactory.getProp(e, t.a, 0, null, this)),
              (this._isAnimated = !!this.amount.effectsSequence.length);
          }),
          (PuckerAndBloatModifier.prototype.processPath = function (e, t) {
            var r = t / 100,
              n = [0, 0],
              i = e._length,
              a = 0;
            for (a = 0; a < i; a += 1) (n[0] += e.v[a][0]), (n[1] += e.v[a][1]);
            (n[0] /= i), (n[1] /= i);
            var o,
              s,
              l,
              f,
              u,
              h,
              m = shapePool.newElement();
            for (m.c = e.c, a = 0; a < i; a += 1)
              (o = e.v[a][0] + (n[0] - e.v[a][0]) * r),
                (s = e.v[a][1] + (n[1] - e.v[a][1]) * r),
                (l = e.o[a][0] + (n[0] - e.o[a][0]) * -r),
                (f = e.o[a][1] + (n[1] - e.o[a][1]) * -r),
                (u = e.i[a][0] + (n[0] - e.i[a][0]) * -r),
                (h = e.i[a][1] + (n[1] - e.i[a][1]) * -r),
                m.setTripleAt(o, s, l, f, u, h, a);
            return m;
          }),
          (PuckerAndBloatModifier.prototype.processShapes = function (e) {
            var t,
              r,
              n,
              i,
              a,
              o,
              s = this.shapes.length,
              l = this.amount.v;
            if (l !== 0)
              for (r = 0; r < s; r += 1) {
                if (
                  ((o = (a = this.shapes[r]).localShapeCollection),
                  a.shape._mdf || this._mdf || e)
                )
                  for (
                    o.releaseShapes(),
                      a.shape._mdf = !0,
                      t = a.shape.paths.shapes,
                      i = a.shape.paths._length,
                      n = 0;
                    n < i;
                    n += 1
                  )
                    o.addShape(this.processPath(t[n], l));
                a.shape.paths = a.localShapeCollection;
              }
            this.dynamicProperties.length || (this._mdf = !1);
          });
        var TransformPropertyFactory = (function () {
          var e = [0, 0];
          function t(r, n, i) {
            if (
              ((this.elem = r),
              (this.frameId = -1),
              (this.propType = "transform"),
              (this.data = n),
              (this.v = new Matrix()),
              (this.pre = new Matrix()),
              (this.appliedTransformations = 0),
              this.initDynamicPropertyContainer(i || r),
              n.p && n.p.s
                ? ((this.px = PropertyFactory.getProp(r, n.p.x, 0, 0, this)),
                  (this.py = PropertyFactory.getProp(r, n.p.y, 0, 0, this)),
                  n.p.z &&
                    (this.pz = PropertyFactory.getProp(r, n.p.z, 0, 0, this)))
                : (this.p = PropertyFactory.getProp(
                    r,
                    n.p || { k: [0, 0, 0] },
                    1,
                    0,
                    this
                  )),
              n.rx)
            ) {
              if (
                ((this.rx = PropertyFactory.getProp(
                  r,
                  n.rx,
                  0,
                  degToRads,
                  this
                )),
                (this.ry = PropertyFactory.getProp(
                  r,
                  n.ry,
                  0,
                  degToRads,
                  this
                )),
                (this.rz = PropertyFactory.getProp(
                  r,
                  n.rz,
                  0,
                  degToRads,
                  this
                )),
                n.or.k[0].ti)
              ) {
                var a,
                  o = n.or.k.length;
                for (a = 0; a < o; a += 1)
                  (n.or.k[a].to = null), (n.or.k[a].ti = null);
              }
              (this.or = PropertyFactory.getProp(r, n.or, 1, degToRads, this)),
                (this.or.sh = !0);
            } else
              this.r = PropertyFactory.getProp(
                r,
                n.r || { k: 0 },
                0,
                degToRads,
                this
              );
            n.sk &&
              ((this.sk = PropertyFactory.getProp(r, n.sk, 0, degToRads, this)),
              (this.sa = PropertyFactory.getProp(r, n.sa, 0, degToRads, this))),
              (this.a = PropertyFactory.getProp(
                r,
                n.a || { k: [0, 0, 0] },
                1,
                0,
                this
              )),
              (this.s = PropertyFactory.getProp(
                r,
                n.s || { k: [100, 100, 100] },
                1,
                0.01,
                this
              )),
              n.o
                ? (this.o = PropertyFactory.getProp(r, n.o, 0, 0.01, r))
                : (this.o = { _mdf: !1, v: 1 }),
              (this._isDirty = !0),
              this.dynamicProperties.length || this.getValue(!0);
          }
          return (
            (t.prototype = {
              applyToMatrix: function (r) {
                var n = this._mdf;
                this.iterateDynamicProperties(),
                  (this._mdf = this._mdf || n),
                  this.a &&
                    r.translate(-this.a.v[0], -this.a.v[1], this.a.v[2]),
                  this.s && r.scale(this.s.v[0], this.s.v[1], this.s.v[2]),
                  this.sk && r.skewFromAxis(-this.sk.v, this.sa.v),
                  this.r
                    ? r.rotate(-this.r.v)
                    : r
                        .rotateZ(-this.rz.v)
                        .rotateY(this.ry.v)
                        .rotateX(this.rx.v)
                        .rotateZ(-this.or.v[2])
                        .rotateY(this.or.v[1])
                        .rotateX(this.or.v[0]),
                  this.data.p.s
                    ? this.data.p.z
                      ? r.translate(this.px.v, this.py.v, -this.pz.v)
                      : r.translate(this.px.v, this.py.v, 0)
                    : r.translate(this.p.v[0], this.p.v[1], -this.p.v[2]);
              },
              getValue: function (r) {
                if (this.elem.globalData.frameId !== this.frameId) {
                  if (
                    (this._isDirty &&
                      (this.precalculateMatrix(), (this._isDirty = !1)),
                    this.iterateDynamicProperties(),
                    this._mdf || r)
                  ) {
                    var n;
                    if (
                      (this.v.cloneFromProps(this.pre.props),
                      this.appliedTransformations < 1 &&
                        this.v.translate(
                          -this.a.v[0],
                          -this.a.v[1],
                          this.a.v[2]
                        ),
                      this.appliedTransformations < 2 &&
                        this.v.scale(this.s.v[0], this.s.v[1], this.s.v[2]),
                      this.sk &&
                        this.appliedTransformations < 3 &&
                        this.v.skewFromAxis(-this.sk.v, this.sa.v),
                      this.r && this.appliedTransformations < 4
                        ? this.v.rotate(-this.r.v)
                        : !this.r &&
                          this.appliedTransformations < 4 &&
                          this.v
                            .rotateZ(-this.rz.v)
                            .rotateY(this.ry.v)
                            .rotateX(this.rx.v)
                            .rotateZ(-this.or.v[2])
                            .rotateY(this.or.v[1])
                            .rotateX(this.or.v[0]),
                      this.autoOriented)
                    ) {
                      var i, a;
                      if (
                        ((n = this.elem.globalData.frameRate),
                        this.p && this.p.keyframes && this.p.getValueAtTime)
                      )
                        this.p._caching.lastFrame + this.p.offsetTime <=
                        this.p.keyframes[0].t
                          ? ((i = this.p.getValueAtTime(
                              (this.p.keyframes[0].t + 0.01) / n,
                              0
                            )),
                            (a = this.p.getValueAtTime(
                              this.p.keyframes[0].t / n,
                              0
                            )))
                          : this.p._caching.lastFrame + this.p.offsetTime >=
                            this.p.keyframes[this.p.keyframes.length - 1].t
                          ? ((i = this.p.getValueAtTime(
                              this.p.keyframes[this.p.keyframes.length - 1].t /
                                n,
                              0
                            )),
                            (a = this.p.getValueAtTime(
                              (this.p.keyframes[this.p.keyframes.length - 1].t -
                                0.05) /
                                n,
                              0
                            )))
                          : ((i = this.p.pv),
                            (a = this.p.getValueAtTime(
                              (this.p._caching.lastFrame +
                                this.p.offsetTime -
                                0.01) /
                                n,
                              this.p.offsetTime
                            )));
                      else if (
                        this.px &&
                        this.px.keyframes &&
                        this.py.keyframes &&
                        this.px.getValueAtTime &&
                        this.py.getValueAtTime
                      ) {
                        (i = []), (a = []);
                        var o = this.px,
                          s = this.py;
                        o._caching.lastFrame + o.offsetTime <= o.keyframes[0].t
                          ? ((i[0] = o.getValueAtTime(
                              (o.keyframes[0].t + 0.01) / n,
                              0
                            )),
                            (i[1] = s.getValueAtTime(
                              (s.keyframes[0].t + 0.01) / n,
                              0
                            )),
                            (a[0] = o.getValueAtTime(o.keyframes[0].t / n, 0)),
                            (a[1] = s.getValueAtTime(s.keyframes[0].t / n, 0)))
                          : o._caching.lastFrame + o.offsetTime >=
                            o.keyframes[o.keyframes.length - 1].t
                          ? ((i[0] = o.getValueAtTime(
                              o.keyframes[o.keyframes.length - 1].t / n,
                              0
                            )),
                            (i[1] = s.getValueAtTime(
                              s.keyframes[s.keyframes.length - 1].t / n,
                              0
                            )),
                            (a[0] = o.getValueAtTime(
                              (o.keyframes[o.keyframes.length - 1].t - 0.01) /
                                n,
                              0
                            )),
                            (a[1] = s.getValueAtTime(
                              (s.keyframes[s.keyframes.length - 1].t - 0.01) /
                                n,
                              0
                            )))
                          : ((i = [o.pv, s.pv]),
                            (a[0] = o.getValueAtTime(
                              (o._caching.lastFrame + o.offsetTime - 0.01) / n,
                              o.offsetTime
                            )),
                            (a[1] = s.getValueAtTime(
                              (s._caching.lastFrame + s.offsetTime - 0.01) / n,
                              s.offsetTime
                            )));
                      } else i = a = e;
                      this.v.rotate(-Math.atan2(i[1] - a[1], i[0] - a[0]));
                    }
                    this.data.p && this.data.p.s
                      ? this.data.p.z
                        ? this.v.translate(this.px.v, this.py.v, -this.pz.v)
                        : this.v.translate(this.px.v, this.py.v, 0)
                      : this.v.translate(
                          this.p.v[0],
                          this.p.v[1],
                          -this.p.v[2]
                        );
                  }
                  this.frameId = this.elem.globalData.frameId;
                }
              },
              precalculateMatrix: function () {
                if (
                  ((this.appliedTransformations = 0),
                  this.pre.reset(),
                  !this.a.effectsSequence.length &&
                    (this.pre.translate(
                      -this.a.v[0],
                      -this.a.v[1],
                      this.a.v[2]
                    ),
                    (this.appliedTransformations = 1),
                    !this.s.effectsSequence.length))
                ) {
                  if (
                    (this.pre.scale(this.s.v[0], this.s.v[1], this.s.v[2]),
                    (this.appliedTransformations = 2),
                    this.sk)
                  ) {
                    if (
                      this.sk.effectsSequence.length ||
                      this.sa.effectsSequence.length
                    )
                      return;
                    this.pre.skewFromAxis(-this.sk.v, this.sa.v),
                      (this.appliedTransformations = 3);
                  }
                  this.r
                    ? this.r.effectsSequence.length ||
                      (this.pre.rotate(-this.r.v),
                      (this.appliedTransformations = 4))
                    : this.rz.effectsSequence.length ||
                      this.ry.effectsSequence.length ||
                      this.rx.effectsSequence.length ||
                      this.or.effectsSequence.length ||
                      (this.pre
                        .rotateZ(-this.rz.v)
                        .rotateY(this.ry.v)
                        .rotateX(this.rx.v)
                        .rotateZ(-this.or.v[2])
                        .rotateY(this.or.v[1])
                        .rotateX(this.or.v[0]),
                      (this.appliedTransformations = 4));
                }
              },
              autoOrient: function () {},
            }),
            extendPrototype([DynamicPropertyContainer], t),
            (t.prototype.addDynamicProperty = function (r) {
              this._addDynamicProperty(r),
                this.elem.addDynamicProperty(r),
                (this._isDirty = !0);
            }),
            (t.prototype._addDynamicProperty =
              DynamicPropertyContainer.prototype.addDynamicProperty),
            {
              getTransformProperty: function (r, n, i) {
                return new t(r, n, i);
              },
            }
          );
        })();
        function RepeaterModifier() {}
        function RoundCornersModifier() {}
        function floatEqual(e, t) {
          return 1e5 * Math.abs(e - t) <= Math.min(Math.abs(e), Math.abs(t));
        }
        function floatZero(e) {
          return Math.abs(e) <= 1e-5;
        }
        function lerp(e, t, r) {
          return e * (1 - r) + t * r;
        }
        function lerpPoint(e, t, r) {
          return [lerp(e[0], t[0], r), lerp(e[1], t[1], r)];
        }
        function quadRoots(e, t, r) {
          if (e === 0) return [];
          var n = t * t - 4 * e * r;
          if (n < 0) return [];
          var i = -t / (2 * e);
          if (n === 0) return [i];
          var a = Math.sqrt(n) / (2 * e);
          return [i - a, i + a];
        }
        function polynomialCoefficients(e, t, r, n) {
          return [
            3 * t - e - 3 * r + n,
            3 * e - 6 * t + 3 * r,
            -3 * e + 3 * t,
            e,
          ];
        }
        function singlePoint(e) {
          return new PolynomialBezier(e, e, e, e, !1);
        }
        function PolynomialBezier(e, t, r, n, i) {
          i && pointEqual(e, t) && (t = lerpPoint(e, n, 1 / 3)),
            i && pointEqual(r, n) && (r = lerpPoint(e, n, 2 / 3));
          var a = polynomialCoefficients(e[0], t[0], r[0], n[0]),
            o = polynomialCoefficients(e[1], t[1], r[1], n[1]);
          (this.a = [a[0], o[0]]),
            (this.b = [a[1], o[1]]),
            (this.c = [a[2], o[2]]),
            (this.d = [a[3], o[3]]),
            (this.points = [e, t, r, n]);
        }
        function extrema(e, t) {
          var r = e.points[0][t],
            n = e.points[e.points.length - 1][t];
          if (r > n) {
            var i = n;
            (n = r), (r = i);
          }
          for (
            var a = quadRoots(3 * e.a[t], 2 * e.b[t], e.c[t]), o = 0;
            o < a.length;
            o += 1
          )
            if (a[o] > 0 && a[o] < 1) {
              var s = e.point(a[o])[t];
              s < r ? (r = s) : s > n && (n = s);
            }
          return { min: r, max: n };
        }
        function intersectData(e, t, r) {
          var n = e.boundingBox();
          return {
            cx: n.cx,
            cy: n.cy,
            width: n.width,
            height: n.height,
            bez: e,
            t: (t + r) / 2,
            t1: t,
            t2: r,
          };
        }
        function splitData(e) {
          var t = e.bez.split(0.5);
          return [
            intersectData(t[0], e.t1, e.t),
            intersectData(t[1], e.t, e.t2),
          ];
        }
        function boxIntersect(e, t) {
          return (
            2 * Math.abs(e.cx - t.cx) < e.width + t.width &&
            2 * Math.abs(e.cy - t.cy) < e.height + t.height
          );
        }
        function intersectsImpl(e, t, r, n, i, a) {
          if (boxIntersect(e, t))
            if (
              r >= a ||
              (e.width <= n && e.height <= n && t.width <= n && t.height <= n)
            )
              i.push([e.t, t.t]);
            else {
              var o = splitData(e),
                s = splitData(t);
              intersectsImpl(o[0], s[0], r + 1, n, i, a),
                intersectsImpl(o[0], s[1], r + 1, n, i, a),
                intersectsImpl(o[1], s[0], r + 1, n, i, a),
                intersectsImpl(o[1], s[1], r + 1, n, i, a);
            }
        }
        function crossProduct(e, t) {
          return [
            e[1] * t[2] - e[2] * t[1],
            e[2] * t[0] - e[0] * t[2],
            e[0] * t[1] - e[1] * t[0],
          ];
        }
        function lineIntersection(e, t, r, n) {
          var i = [e[0], e[1], 1],
            a = [t[0], t[1], 1],
            o = [r[0], r[1], 1],
            s = [n[0], n[1], 1],
            l = crossProduct(crossProduct(i, a), crossProduct(o, s));
          return floatZero(l[2]) ? null : [l[0] / l[2], l[1] / l[2]];
        }
        function polarOffset(e, t, r) {
          return [e[0] + Math.cos(t) * r, e[1] - Math.sin(t) * r];
        }
        function pointDistance(e, t) {
          return Math.hypot(e[0] - t[0], e[1] - t[1]);
        }
        function pointEqual(e, t) {
          return floatEqual(e[0], t[0]) && floatEqual(e[1], t[1]);
        }
        function ZigZagModifier() {}
        function setPoint(e, t, r, n, i, a, o) {
          var s = r - Math.PI / 2,
            l = r + Math.PI / 2,
            f = t[0] + Math.cos(r) * n * i,
            u = t[1] - Math.sin(r) * n * i;
          e.setTripleAt(
            f,
            u,
            f + Math.cos(s) * a,
            u - Math.sin(s) * a,
            f + Math.cos(l) * o,
            u - Math.sin(l) * o,
            e.length()
          );
        }
        function getPerpendicularVector(e, t) {
          var r = [t[0] - e[0], t[1] - e[1]],
            n = 0.5 * -Math.PI;
          return [
            Math.cos(n) * r[0] - Math.sin(n) * r[1],
            Math.sin(n) * r[0] + Math.cos(n) * r[1],
          ];
        }
        function getProjectingAngle(e, t) {
          var r = t === 0 ? e.length() - 1 : t - 1,
            n = (t + 1) % e.length(),
            i = getPerpendicularVector(e.v[r], e.v[n]);
          return Math.atan2(0, 1) - Math.atan2(i[1], i[0]);
        }
        function zigZagCorner(e, t, r, n, i, a, o) {
          var s = getProjectingAngle(t, r),
            l = t.v[r % t._length],
            f = t.v[r === 0 ? t._length - 1 : r - 1],
            u = t.v[(r + 1) % t._length],
            h =
              a === 2
                ? Math.sqrt(Math.pow(l[0] - f[0], 2) + Math.pow(l[1] - f[1], 2))
                : 0,
            m =
              a === 2
                ? Math.sqrt(Math.pow(l[0] - u[0], 2) + Math.pow(l[1] - u[1], 2))
                : 0;
          setPoint(
            e,
            t.v[r % t._length],
            s,
            o,
            n,
            m / (2 * (i + 1)),
            h / (2 * (i + 1)),
            a
          );
        }
        function zigZagSegment(e, t, r, n, i, a) {
          for (var o = 0; o < n; o += 1) {
            var s = (o + 1) / (n + 1),
              l =
                i === 2
                  ? Math.sqrt(
                      Math.pow(t.points[3][0] - t.points[0][0], 2) +
                        Math.pow(t.points[3][1] - t.points[0][1], 2)
                    )
                  : 0,
              f = t.normalAngle(s);
            setPoint(
              e,
              t.point(s),
              f,
              a,
              r,
              l / (2 * (n + 1)),
              l / (2 * (n + 1)),
              i
            ),
              (a = -a);
          }
          return a;
        }
        function linearOffset(e, t, r) {
          var n = Math.atan2(t[0] - e[0], t[1] - e[1]);
          return [polarOffset(e, n, r), polarOffset(t, n, r)];
        }
        function offsetSegment(e, t) {
          var r, n, i, a, o, s, l;
          (r = (l = linearOffset(e.points[0], e.points[1], t))[0]),
            (n = l[1]),
            (i = (l = linearOffset(e.points[1], e.points[2], t))[0]),
            (a = l[1]),
            (o = (l = linearOffset(e.points[2], e.points[3], t))[0]),
            (s = l[1]);
          var f = lineIntersection(r, n, i, a);
          f === null && (f = n);
          var u = lineIntersection(o, s, i, a);
          return u === null && (u = o), new PolynomialBezier(r, f, u, s);
        }
        function joinLines(e, t, r, n, i) {
          var a = t.points[3],
            o = r.points[0];
          if (n === 3 || pointEqual(a, o)) return a;
          if (n === 2) {
            var s = -t.tangentAngle(1),
              l = -r.tangentAngle(0) + Math.PI,
              f = lineIntersection(
                a,
                polarOffset(a, s + Math.PI / 2, 100),
                o,
                polarOffset(o, s + Math.PI / 2, 100)
              ),
              u = f ? pointDistance(f, a) : pointDistance(a, o) / 2,
              h = polarOffset(a, s, 2 * u * roundCorner);
            return (
              e.setXYAt(h[0], h[1], "o", e.length() - 1),
              (h = polarOffset(o, l, 2 * u * roundCorner)),
              e.setTripleAt(o[0], o[1], o[0], o[1], h[0], h[1], e.length()),
              o
            );
          }
          var m = lineIntersection(
            pointEqual(a, t.points[2]) ? t.points[0] : t.points[2],
            a,
            o,
            pointEqual(o, r.points[1]) ? r.points[3] : r.points[1]
          );
          return m && pointDistance(m, a) < i
            ? (e.setTripleAt(m[0], m[1], m[0], m[1], m[0], m[1], e.length()), m)
            : a;
        }
        function getIntersection(e, t) {
          var r = e.intersections(t);
          return (
            r.length && floatEqual(r[0][0], 1) && r.shift(),
            r.length ? r[0] : null
          );
        }
        function pruneSegmentIntersection(e, t) {
          var r = e.slice(),
            n = t.slice(),
            i = getIntersection(e[e.length - 1], t[0]);
          return (
            i &&
              ((r[e.length - 1] = e[e.length - 1].split(i[0])[0]),
              (n[0] = t[0].split(i[1])[1])),
            e.length > 1 &&
            t.length > 1 &&
            (i = getIntersection(e[0], t[t.length - 1]))
              ? [[e[0].split(i[0])[0]], [t[t.length - 1].split(i[1])[1]]]
              : [r, n]
          );
        }
        function pruneIntersections(e) {
          for (var t, r = 1; r < e.length; r += 1)
            (t = pruneSegmentIntersection(e[r - 1], e[r])),
              (e[r - 1] = t[0]),
              (e[r] = t[1]);
          return (
            e.length > 1 &&
              ((t = pruneSegmentIntersection(e[e.length - 1], e[0])),
              (e[e.length - 1] = t[0]),
              (e[0] = t[1])),
            e
          );
        }
        function offsetSegmentSplit(e, t) {
          var r,
            n,
            i,
            a,
            o = e.inflectionPoints();
          if (o.length === 0) return [offsetSegment(e, t)];
          if (o.length === 1 || floatEqual(o[1], 1))
            return (
              (r = (i = e.split(o[0]))[0]),
              (n = i[1]),
              [offsetSegment(r, t), offsetSegment(n, t)]
            );
          r = (i = e.split(o[0]))[0];
          var s = (o[1] - o[0]) / (1 - o[0]);
          return (
            (a = (i = i[1].split(s))[0]),
            (n = i[1]),
            [offsetSegment(r, t), offsetSegment(a, t), offsetSegment(n, t)]
          );
        }
        function OffsetPathModifier() {}
        function getFontProperties(e) {
          for (
            var t = e.fStyle ? e.fStyle.split(" ") : [],
              r = "normal",
              n = "normal",
              i = t.length,
              a = 0;
            a < i;
            a += 1
          )
            switch (t[a].toLowerCase()) {
              case "italic":
                n = "italic";
                break;
              case "bold":
                r = "700";
                break;
              case "black":
                r = "900";
                break;
              case "medium":
                r = "500";
                break;
              case "regular":
              case "normal":
                r = "400";
                break;
              case "light":
              case "thin":
                r = "200";
            }
          return { style: n, weight: e.fWeight || r };
        }
        extendPrototype([ShapeModifier], RepeaterModifier),
          (RepeaterModifier.prototype.initModifierProperties = function (e, t) {
            (this.getValue = this.processKeys),
              (this.c = PropertyFactory.getProp(e, t.c, 0, null, this)),
              (this.o = PropertyFactory.getProp(e, t.o, 0, null, this)),
              (this.tr = TransformPropertyFactory.getTransformProperty(
                e,
                t.tr,
                this
              )),
              (this.so = PropertyFactory.getProp(e, t.tr.so, 0, 0.01, this)),
              (this.eo = PropertyFactory.getProp(e, t.tr.eo, 0, 0.01, this)),
              (this.data = t),
              this.dynamicProperties.length || this.getValue(!0),
              (this._isAnimated = !!this.dynamicProperties.length),
              (this.pMatrix = new Matrix()),
              (this.rMatrix = new Matrix()),
              (this.sMatrix = new Matrix()),
              (this.tMatrix = new Matrix()),
              (this.matrix = new Matrix());
          }),
          (RepeaterModifier.prototype.applyTransforms = function (
            e,
            t,
            r,
            n,
            i,
            a
          ) {
            var o = a ? -1 : 1,
              s = n.s.v[0] + (1 - n.s.v[0]) * (1 - i),
              l = n.s.v[1] + (1 - n.s.v[1]) * (1 - i);
            e.translate(n.p.v[0] * o * i, n.p.v[1] * o * i, n.p.v[2]),
              t.translate(-n.a.v[0], -n.a.v[1], n.a.v[2]),
              t.rotate(-n.r.v * o * i),
              t.translate(n.a.v[0], n.a.v[1], n.a.v[2]),
              r.translate(-n.a.v[0], -n.a.v[1], n.a.v[2]),
              r.scale(a ? 1 / s : s, a ? 1 / l : l),
              r.translate(n.a.v[0], n.a.v[1], n.a.v[2]);
          }),
          (RepeaterModifier.prototype.init = function (e, t, r, n) {
            for (
              this.elem = e,
                this.arr = t,
                this.pos = r,
                this.elemsData = n,
                this._currentCopies = 0,
                this._elements = [],
                this._groups = [],
                this.frameId = -1,
                this.initDynamicPropertyContainer(e),
                this.initModifierProperties(e, t[r]);
              r > 0;

            )
              (r -= 1), this._elements.unshift(t[r]);
            this.dynamicProperties.length ? (this.k = !0) : this.getValue(!0);
          }),
          (RepeaterModifier.prototype.resetElements = function (e) {
            var t,
              r = e.length;
            for (t = 0; t < r; t += 1)
              (e[t]._processed = !1),
                e[t].ty === "gr" && this.resetElements(e[t].it);
          }),
          (RepeaterModifier.prototype.cloneElements = function (e) {
            var t = JSON.parse(JSON.stringify(e));
            return this.resetElements(t), t;
          }),
          (RepeaterModifier.prototype.changeGroupRender = function (e, t) {
            var r,
              n = e.length;
            for (r = 0; r < n; r += 1)
              (e[r]._render = t),
                e[r].ty === "gr" && this.changeGroupRender(e[r].it, t);
          }),
          (RepeaterModifier.prototype.processShapes = function (e) {
            var t,
              r,
              n,
              i,
              a,
              o = !1;
            if (this._mdf || e) {
              var s,
                l = Math.ceil(this.c.v);
              if (this._groups.length < l) {
                for (; this._groups.length < l; ) {
                  var f = { it: this.cloneElements(this._elements), ty: "gr" };
                  f.it.push({
                    a: { a: 0, ix: 1, k: [0, 0] },
                    nm: "Transform",
                    o: { a: 0, ix: 7, k: 100 },
                    p: { a: 0, ix: 2, k: [0, 0] },
                    r: {
                      a: 1,
                      ix: 6,
                      k: [
                        { s: 0, e: 0, t: 0 },
                        { s: 0, e: 0, t: 1 },
                      ],
                    },
                    s: { a: 0, ix: 3, k: [100, 100] },
                    sa: { a: 0, ix: 5, k: 0 },
                    sk: { a: 0, ix: 4, k: 0 },
                    ty: "tr",
                  }),
                    this.arr.splice(0, 0, f),
                    this._groups.splice(0, 0, f),
                    (this._currentCopies += 1);
                }
                this.elem.reloadShapes(), (o = !0);
              }
              for (a = 0, n = 0; n <= this._groups.length - 1; n += 1) {
                if (
                  ((s = a < l),
                  (this._groups[n]._render = s),
                  this.changeGroupRender(this._groups[n].it, s),
                  !s)
                ) {
                  var u = this.elemsData[n].it,
                    h = u[u.length - 1];
                  h.transform.op.v !== 0
                    ? ((h.transform.op._mdf = !0), (h.transform.op.v = 0))
                    : (h.transform.op._mdf = !1);
                }
                a += 1;
              }
              this._currentCopies = l;
              var m = this.o.v,
                d = m % 1,
                p = m > 0 ? Math.floor(m) : Math.ceil(m),
                g = this.pMatrix.props,
                c = this.rMatrix.props,
                v = this.sMatrix.props;
              this.pMatrix.reset(),
                this.rMatrix.reset(),
                this.sMatrix.reset(),
                this.tMatrix.reset(),
                this.matrix.reset();
              var y,
                b,
                x = 0;
              if (m > 0) {
                for (; x < p; )
                  this.applyTransforms(
                    this.pMatrix,
                    this.rMatrix,
                    this.sMatrix,
                    this.tr,
                    1,
                    !1
                  ),
                    (x += 1);
                d &&
                  (this.applyTransforms(
                    this.pMatrix,
                    this.rMatrix,
                    this.sMatrix,
                    this.tr,
                    d,
                    !1
                  ),
                  (x += d));
              } else if (m < 0) {
                for (; x > p; )
                  this.applyTransforms(
                    this.pMatrix,
                    this.rMatrix,
                    this.sMatrix,
                    this.tr,
                    1,
                    !0
                  ),
                    (x -= 1);
                d &&
                  (this.applyTransforms(
                    this.pMatrix,
                    this.rMatrix,
                    this.sMatrix,
                    this.tr,
                    -d,
                    !0
                  ),
                  (x -= d));
              }
              for (
                n = this.data.m === 1 ? 0 : this._currentCopies - 1,
                  i = this.data.m === 1 ? 1 : -1,
                  a = this._currentCopies;
                a;

              ) {
                if (
                  ((b = (r = (t = this.elemsData[n].it)[t.length - 1].transform
                    .mProps.v.props).length),
                  (t[t.length - 1].transform.mProps._mdf = !0),
                  (t[t.length - 1].transform.op._mdf = !0),
                  (t[t.length - 1].transform.op.v =
                    this._currentCopies === 1
                      ? this.so.v
                      : this.so.v +
                        (this.eo.v - this.so.v) *
                          (n / (this._currentCopies - 1))),
                  x !== 0)
                ) {
                  for (
                    ((n !== 0 && i === 1) ||
                      (n !== this._currentCopies - 1 && i === -1)) &&
                      this.applyTransforms(
                        this.pMatrix,
                        this.rMatrix,
                        this.sMatrix,
                        this.tr,
                        1,
                        !1
                      ),
                      this.matrix.transform(
                        c[0],
                        c[1],
                        c[2],
                        c[3],
                        c[4],
                        c[5],
                        c[6],
                        c[7],
                        c[8],
                        c[9],
                        c[10],
                        c[11],
                        c[12],
                        c[13],
                        c[14],
                        c[15]
                      ),
                      this.matrix.transform(
                        v[0],
                        v[1],
                        v[2],
                        v[3],
                        v[4],
                        v[5],
                        v[6],
                        v[7],
                        v[8],
                        v[9],
                        v[10],
                        v[11],
                        v[12],
                        v[13],
                        v[14],
                        v[15]
                      ),
                      this.matrix.transform(
                        g[0],
                        g[1],
                        g[2],
                        g[3],
                        g[4],
                        g[5],
                        g[6],
                        g[7],
                        g[8],
                        g[9],
                        g[10],
                        g[11],
                        g[12],
                        g[13],
                        g[14],
                        g[15]
                      ),
                      y = 0;
                    y < b;
                    y += 1
                  )
                    r[y] = this.matrix.props[y];
                  this.matrix.reset();
                } else
                  for (this.matrix.reset(), y = 0; y < b; y += 1)
                    r[y] = this.matrix.props[y];
                (x += 1), (a -= 1), (n += i);
              }
            } else
              for (a = this._currentCopies, n = 0, i = 1; a; )
                (r = (t = this.elemsData[n].it)[t.length - 1].transform.mProps.v
                  .props),
                  (t[t.length - 1].transform.mProps._mdf = !1),
                  (t[t.length - 1].transform.op._mdf = !1),
                  (a -= 1),
                  (n += i);
            return o;
          }),
          (RepeaterModifier.prototype.addShape = function () {}),
          extendPrototype([ShapeModifier], RoundCornersModifier),
          (RoundCornersModifier.prototype.initModifierProperties = function (
            e,
            t
          ) {
            (this.getValue = this.processKeys),
              (this.rd = PropertyFactory.getProp(e, t.r, 0, null, this)),
              (this._isAnimated = !!this.rd.effectsSequence.length);
          }),
          (RoundCornersModifier.prototype.processPath = function (e, t) {
            var r,
              n = shapePool.newElement();
            n.c = e.c;
            var i,
              a,
              o,
              s,
              l,
              f,
              u,
              h,
              m,
              d,
              p,
              g,
              c = e._length,
              v = 0;
            for (r = 0; r < c; r += 1)
              (i = e.v[r]),
                (o = e.o[r]),
                (a = e.i[r]),
                i[0] === o[0] && i[1] === o[1] && i[0] === a[0] && i[1] === a[1]
                  ? (r !== 0 && r !== c - 1) || e.c
                    ? ((s = r === 0 ? e.v[c - 1] : e.v[r - 1]),
                      (f = (l = Math.sqrt(
                        Math.pow(i[0] - s[0], 2) + Math.pow(i[1] - s[1], 2)
                      ))
                        ? Math.min(l / 2, t) / l
                        : 0),
                      (u = p = i[0] + (s[0] - i[0]) * f),
                      (h = g = i[1] - (i[1] - s[1]) * f),
                      (m = u - (u - i[0]) * roundCorner),
                      (d = h - (h - i[1]) * roundCorner),
                      n.setTripleAt(u, h, m, d, p, g, v),
                      (v += 1),
                      (s = r === c - 1 ? e.v[0] : e.v[r + 1]),
                      (f = (l = Math.sqrt(
                        Math.pow(i[0] - s[0], 2) + Math.pow(i[1] - s[1], 2)
                      ))
                        ? Math.min(l / 2, t) / l
                        : 0),
                      (u = m = i[0] + (s[0] - i[0]) * f),
                      (h = d = i[1] + (s[1] - i[1]) * f),
                      (p = u - (u - i[0]) * roundCorner),
                      (g = h - (h - i[1]) * roundCorner),
                      n.setTripleAt(u, h, m, d, p, g, v),
                      (v += 1))
                    : (n.setTripleAt(i[0], i[1], o[0], o[1], a[0], a[1], v),
                      (v += 1))
                  : (n.setTripleAt(
                      e.v[r][0],
                      e.v[r][1],
                      e.o[r][0],
                      e.o[r][1],
                      e.i[r][0],
                      e.i[r][1],
                      v
                    ),
                    (v += 1));
            return n;
          }),
          (RoundCornersModifier.prototype.processShapes = function (e) {
            var t,
              r,
              n,
              i,
              a,
              o,
              s = this.shapes.length,
              l = this.rd.v;
            if (l !== 0)
              for (r = 0; r < s; r += 1) {
                if (
                  ((o = (a = this.shapes[r]).localShapeCollection),
                  a.shape._mdf || this._mdf || e)
                )
                  for (
                    o.releaseShapes(),
                      a.shape._mdf = !0,
                      t = a.shape.paths.shapes,
                      i = a.shape.paths._length,
                      n = 0;
                    n < i;
                    n += 1
                  )
                    o.addShape(this.processPath(t[n], l));
                a.shape.paths = a.localShapeCollection;
              }
            this.dynamicProperties.length || (this._mdf = !1);
          }),
          (PolynomialBezier.prototype.point = function (e) {
            return [
              ((this.a[0] * e + this.b[0]) * e + this.c[0]) * e + this.d[0],
              ((this.a[1] * e + this.b[1]) * e + this.c[1]) * e + this.d[1],
            ];
          }),
          (PolynomialBezier.prototype.derivative = function (e) {
            return [
              (3 * e * this.a[0] + 2 * this.b[0]) * e + this.c[0],
              (3 * e * this.a[1] + 2 * this.b[1]) * e + this.c[1],
            ];
          }),
          (PolynomialBezier.prototype.tangentAngle = function (e) {
            var t = this.derivative(e);
            return Math.atan2(t[1], t[0]);
          }),
          (PolynomialBezier.prototype.normalAngle = function (e) {
            var t = this.derivative(e);
            return Math.atan2(t[0], t[1]);
          }),
          (PolynomialBezier.prototype.inflectionPoints = function () {
            var e = this.a[1] * this.b[0] - this.a[0] * this.b[1];
            if (floatZero(e)) return [];
            var t =
                (-0.5 * (this.a[1] * this.c[0] - this.a[0] * this.c[1])) / e,
              r =
                t * t -
                ((1 / 3) * (this.b[1] * this.c[0] - this.b[0] * this.c[1])) / e;
            if (r < 0) return [];
            var n = Math.sqrt(r);
            return floatZero(n)
              ? n > 0 && n < 1
                ? [t]
                : []
              : [t - n, t + n].filter(function (i) {
                  return i > 0 && i < 1;
                });
          }),
          (PolynomialBezier.prototype.split = function (e) {
            if (e <= 0) return [singlePoint(this.points[0]), this];
            if (e >= 1)
              return [this, singlePoint(this.points[this.points.length - 1])];
            var t = lerpPoint(this.points[0], this.points[1], e),
              r = lerpPoint(this.points[1], this.points[2], e),
              n = lerpPoint(this.points[2], this.points[3], e),
              i = lerpPoint(t, r, e),
              a = lerpPoint(r, n, e),
              o = lerpPoint(i, a, e);
            return [
              new PolynomialBezier(this.points[0], t, i, o, !0),
              new PolynomialBezier(o, a, n, this.points[3], !0),
            ];
          }),
          (PolynomialBezier.prototype.bounds = function () {
            return { x: extrema(this, 0), y: extrema(this, 1) };
          }),
          (PolynomialBezier.prototype.boundingBox = function () {
            var e = this.bounds();
            return {
              left: e.x.min,
              right: e.x.max,
              top: e.y.min,
              bottom: e.y.max,
              width: e.x.max - e.x.min,
              height: e.y.max - e.y.min,
              cx: (e.x.max + e.x.min) / 2,
              cy: (e.y.max + e.y.min) / 2,
            };
          }),
          (PolynomialBezier.prototype.intersections = function (e, t, r) {
            t === void 0 && (t = 2), r === void 0 && (r = 7);
            var n = [];
            return (
              intersectsImpl(
                intersectData(this, 0, 1),
                intersectData(e, 0, 1),
                0,
                t,
                n,
                r
              ),
              n
            );
          }),
          (PolynomialBezier.shapeSegment = function (e, t) {
            var r = (t + 1) % e.length();
            return new PolynomialBezier(e.v[t], e.o[t], e.i[r], e.v[r], !0);
          }),
          (PolynomialBezier.shapeSegmentInverted = function (e, t) {
            var r = (t + 1) % e.length();
            return new PolynomialBezier(e.v[r], e.i[r], e.o[t], e.v[t], !0);
          }),
          extendPrototype([ShapeModifier], ZigZagModifier),
          (ZigZagModifier.prototype.initModifierProperties = function (e, t) {
            (this.getValue = this.processKeys),
              (this.amplitude = PropertyFactory.getProp(e, t.s, 0, null, this)),
              (this.frequency = PropertyFactory.getProp(e, t.r, 0, null, this)),
              (this.pointsType = PropertyFactory.getProp(
                e,
                t.pt,
                0,
                null,
                this
              )),
              (this._isAnimated =
                this.amplitude.effectsSequence.length !== 0 ||
                this.frequency.effectsSequence.length !== 0 ||
                this.pointsType.effectsSequence.length !== 0);
          }),
          (ZigZagModifier.prototype.processPath = function (e, t, r, n) {
            var i = e._length,
              a = shapePool.newElement();
            if (((a.c = e.c), e.c || (i -= 1), i === 0)) return a;
            var o = -1,
              s = PolynomialBezier.shapeSegment(e, 0);
            zigZagCorner(a, e, 0, t, r, n, o);
            for (var l = 0; l < i; l += 1)
              (o = zigZagSegment(a, s, t, r, n, -o)),
                (s =
                  l !== i - 1 || e.c
                    ? PolynomialBezier.shapeSegment(e, (l + 1) % i)
                    : null),
                zigZagCorner(a, e, l + 1, t, r, n, o);
            return a;
          }),
          (ZigZagModifier.prototype.processShapes = function (e) {
            var t,
              r,
              n,
              i,
              a,
              o,
              s = this.shapes.length,
              l = this.amplitude.v,
              f = Math.max(0, Math.round(this.frequency.v)),
              u = this.pointsType.v;
            if (l !== 0)
              for (r = 0; r < s; r += 1) {
                if (
                  ((o = (a = this.shapes[r]).localShapeCollection),
                  a.shape._mdf || this._mdf || e)
                )
                  for (
                    o.releaseShapes(),
                      a.shape._mdf = !0,
                      t = a.shape.paths.shapes,
                      i = a.shape.paths._length,
                      n = 0;
                    n < i;
                    n += 1
                  )
                    o.addShape(this.processPath(t[n], l, f, u));
                a.shape.paths = a.localShapeCollection;
              }
            this.dynamicProperties.length || (this._mdf = !1);
          }),
          extendPrototype([ShapeModifier], OffsetPathModifier),
          (OffsetPathModifier.prototype.initModifierProperties = function (
            e,
            t
          ) {
            (this.getValue = this.processKeys),
              (this.amount = PropertyFactory.getProp(e, t.a, 0, null, this)),
              (this.miterLimit = PropertyFactory.getProp(
                e,
                t.ml,
                0,
                null,
                this
              )),
              (this.lineJoin = t.lj),
              (this._isAnimated = this.amount.effectsSequence.length !== 0);
          }),
          (OffsetPathModifier.prototype.processPath = function (e, t, r, n) {
            var i = shapePool.newElement();
            i.c = e.c;
            var a,
              o,
              s,
              l = e.length();
            e.c || (l -= 1);
            var f = [];
            for (a = 0; a < l; a += 1)
              (s = PolynomialBezier.shapeSegment(e, a)),
                f.push(offsetSegmentSplit(s, t));
            if (!e.c)
              for (a = l - 1; a >= 0; a -= 1)
                (s = PolynomialBezier.shapeSegmentInverted(e, a)),
                  f.push(offsetSegmentSplit(s, t));
            f = pruneIntersections(f);
            var u = null,
              h = null;
            for (a = 0; a < f.length; a += 1) {
              var m = f[a];
              for (
                h && (u = joinLines(i, h, m[0], r, n)),
                  h = m[m.length - 1],
                  o = 0;
                o < m.length;
                o += 1
              )
                (s = m[o]),
                  u && pointEqual(s.points[0], u)
                    ? i.setXYAt(
                        s.points[1][0],
                        s.points[1][1],
                        "o",
                        i.length() - 1
                      )
                    : i.setTripleAt(
                        s.points[0][0],
                        s.points[0][1],
                        s.points[1][0],
                        s.points[1][1],
                        s.points[0][0],
                        s.points[0][1],
                        i.length()
                      ),
                  i.setTripleAt(
                    s.points[3][0],
                    s.points[3][1],
                    s.points[3][0],
                    s.points[3][1],
                    s.points[2][0],
                    s.points[2][1],
                    i.length()
                  ),
                  (u = s.points[3]);
            }
            return f.length && joinLines(i, h, f[0][0], r, n), i;
          }),
          (OffsetPathModifier.prototype.processShapes = function (e) {
            var t,
              r,
              n,
              i,
              a,
              o,
              s = this.shapes.length,
              l = this.amount.v,
              f = this.miterLimit.v,
              u = this.lineJoin;
            if (l !== 0)
              for (r = 0; r < s; r += 1) {
                if (
                  ((o = (a = this.shapes[r]).localShapeCollection),
                  a.shape._mdf || this._mdf || e)
                )
                  for (
                    o.releaseShapes(),
                      a.shape._mdf = !0,
                      t = a.shape.paths.shapes,
                      i = a.shape.paths._length,
                      n = 0;
                    n < i;
                    n += 1
                  )
                    o.addShape(this.processPath(t[n], l, u, f));
                a.shape.paths = a.localShapeCollection;
              }
            this.dynamicProperties.length || (this._mdf = !1);
          });
        var FontManager = (function () {
          var e = { w: 0, size: 0, shapes: [], data: { shapes: [] } },
            t = [];
          t = t.concat([
            2304, 2305, 2306, 2307, 2362, 2363, 2364, 2364, 2366, 2367, 2368,
            2369, 2370, 2371, 2372, 2373, 2374, 2375, 2376, 2377, 2378, 2379,
            2380, 2381, 2382, 2383, 2387, 2388, 2389, 2390, 2391, 2402, 2403,
          ]);
          var r = 127988,
            n = ["d83cdffb", "d83cdffc", "d83cdffd", "d83cdffe", "d83cdfff"];
          function i(u, h) {
            var m = createTag("span");
            m.setAttribute("aria-hidden", !0), (m.style.fontFamily = h);
            var d = createTag("span");
            (d.innerText = "giItT1WQy@!-/#"),
              (m.style.position = "absolute"),
              (m.style.left = "-10000px"),
              (m.style.top = "-10000px"),
              (m.style.fontSize = "300px"),
              (m.style.fontVariant = "normal"),
              (m.style.fontStyle = "normal"),
              (m.style.fontWeight = "normal"),
              (m.style.letterSpacing = "0"),
              m.appendChild(d),
              document.body.appendChild(m);
            var p = d.offsetWidth;
            return (
              (d.style.fontFamily =
                (function (g) {
                  var c,
                    v = g.split(","),
                    y = v.length,
                    b = [];
                  for (c = 0; c < y; c += 1)
                    v[c] !== "sans-serif" &&
                      v[c] !== "monospace" &&
                      b.push(v[c]);
                  return b.join(",");
                })(u) +
                ", " +
                h),
              { node: d, w: p, parent: m }
            );
          }
          function a(u, h) {
            var m,
              d = document.body && h ? "svg" : "canvas",
              p = getFontProperties(u);
            if (d === "svg") {
              var g = createNS("text");
              (g.style.fontSize = "100px"),
                g.setAttribute("font-family", u.fFamily),
                g.setAttribute("font-style", p.style),
                g.setAttribute("font-weight", p.weight),
                (g.textContent = "1"),
                u.fClass
                  ? ((g.style.fontFamily = "inherit"),
                    g.setAttribute("class", u.fClass))
                  : (g.style.fontFamily = u.fFamily),
                h.appendChild(g),
                (m = g);
            } else {
              var c = new OffscreenCanvas(500, 500).getContext("2d");
              (c.font = p.style + " " + p.weight + " 100px " + u.fFamily),
                (m = c);
            }
            return {
              measureText: function (v) {
                return d === "svg"
                  ? ((m.textContent = v), m.getComputedTextLength())
                  : m.measureText(v).width;
              },
            };
          }
          function o(u) {
            var h = 0,
              m = u.charCodeAt(0);
            if (m >= 55296 && m <= 56319) {
              var d = u.charCodeAt(1);
              d >= 56320 &&
                d <= 57343 &&
                (h = 1024 * (m - 55296) + d - 56320 + 65536);
            }
            return h;
          }
          function s(u) {
            var h = o(u);
            return h >= 127462 && h <= 127487;
          }
          var l = function () {
            (this.fonts = []),
              (this.chars = null),
              (this.typekitLoaded = 0),
              (this.isLoaded = !1),
              (this._warned = !1),
              (this.initTime = Date.now()),
              (this.setIsLoadedBinded = this.setIsLoaded.bind(this)),
              (this.checkLoadedFontsBinded = this.checkLoadedFonts.bind(this));
          };
          (l.isModifier = function (u, h) {
            var m = u.toString(16) + h.toString(16);
            return n.indexOf(m) !== -1;
          }),
            (l.isZeroWidthJoiner = function (u) {
              return u === 8205;
            }),
            (l.isFlagEmoji = function (u) {
              return s(u.substr(0, 2)) && s(u.substr(2, 2));
            }),
            (l.isRegionalCode = s),
            (l.isCombinedCharacter = function (u) {
              return t.indexOf(u) !== -1;
            }),
            (l.isRegionalFlag = function (u, h) {
              var m = o(u.substr(h, 2));
              if (m !== r) return !1;
              var d = 0;
              for (h += 2; d < 5; ) {
                if ((m = o(u.substr(h, 2))) < 917601 || m > 917626) return !1;
                (d += 1), (h += 2);
              }
              return o(u.substr(h, 2)) === 917631;
            }),
            (l.isVariationSelector = function (u) {
              return u === 65039;
            }),
            (l.BLACK_FLAG_CODE_POINT = r);
          var f = {
            addChars: function (u) {
              if (u) {
                var h;
                this.chars || (this.chars = []);
                var m,
                  d,
                  p = u.length,
                  g = this.chars.length;
                for (h = 0; h < p; h += 1) {
                  for (m = 0, d = !1; m < g; )
                    this.chars[m].style === u[h].style &&
                      this.chars[m].fFamily === u[h].fFamily &&
                      this.chars[m].ch === u[h].ch &&
                      (d = !0),
                      (m += 1);
                  d || (this.chars.push(u[h]), (g += 1));
                }
              }
            },
            addFonts: function (u, h) {
              if (u) {
                if (this.chars)
                  return (this.isLoaded = !0), void (this.fonts = u.list);
                if (!document.body)
                  return (
                    (this.isLoaded = !0),
                    u.list.forEach(function (T) {
                      (T.helper = a(T)), (T.cache = {});
                    }),
                    void (this.fonts = u.list)
                  );
                var m,
                  d = u.list,
                  p = d.length,
                  g = p;
                for (m = 0; m < p; m += 1) {
                  var c,
                    v,
                    y = !0;
                  if (
                    ((d[m].loaded = !1),
                    (d[m].monoCase = i(d[m].fFamily, "monospace")),
                    (d[m].sansCase = i(d[m].fFamily, "sans-serif")),
                    d[m].fPath)
                  ) {
                    if (d[m].fOrigin === "p" || d[m].origin === 3) {
                      if (
                        ((c = document.querySelectorAll(
                          'style[f-forigin="p"][f-family="' +
                            d[m].fFamily +
                            '"], style[f-origin="3"][f-family="' +
                            d[m].fFamily +
                            '"]'
                        )).length > 0 && (y = !1),
                        y)
                      ) {
                        var b = createTag("style");
                        b.setAttribute("f-forigin", d[m].fOrigin),
                          b.setAttribute("f-origin", d[m].origin),
                          b.setAttribute("f-family", d[m].fFamily),
                          (b.type = "text/css"),
                          (b.innerText =
                            "@font-face {font-family: " +
                            d[m].fFamily +
                            "; font-style: normal; src: url('" +
                            d[m].fPath +
                            "');}"),
                          h.appendChild(b);
                      }
                    } else if (d[m].fOrigin === "g" || d[m].origin === 1) {
                      for (
                        c = document.querySelectorAll(
                          'link[f-forigin="g"], link[f-origin="1"]'
                        ),
                          v = 0;
                        v < c.length;
                        v += 1
                      )
                        c[v].href.indexOf(d[m].fPath) !== -1 && (y = !1);
                      if (y) {
                        var x = createTag("link");
                        x.setAttribute("f-forigin", d[m].fOrigin),
                          x.setAttribute("f-origin", d[m].origin),
                          (x.type = "text/css"),
                          (x.rel = "stylesheet"),
                          (x.href = d[m].fPath),
                          document.body.appendChild(x);
                      }
                    } else if (d[m].fOrigin === "t" || d[m].origin === 2) {
                      for (
                        c = document.querySelectorAll(
                          'script[f-forigin="t"], script[f-origin="2"]'
                        ),
                          v = 0;
                        v < c.length;
                        v += 1
                      )
                        d[m].fPath === c[v].src && (y = !1);
                      if (y) {
                        var S = createTag("link");
                        S.setAttribute("f-forigin", d[m].fOrigin),
                          S.setAttribute("f-origin", d[m].origin),
                          S.setAttribute("rel", "stylesheet"),
                          S.setAttribute("href", d[m].fPath),
                          h.appendChild(S);
                      }
                    }
                  } else (d[m].loaded = !0), (g -= 1);
                  (d[m].helper = a(d[m], h)),
                    (d[m].cache = {}),
                    this.fonts.push(d[m]);
                }
                g === 0
                  ? (this.isLoaded = !0)
                  : setTimeout(this.checkLoadedFonts.bind(this), 100);
              } else this.isLoaded = !0;
            },
            getCharData: function (u, h, m) {
              for (var d = 0, p = this.chars.length; d < p; ) {
                if (
                  this.chars[d].ch === u &&
                  this.chars[d].style === h &&
                  this.chars[d].fFamily === m
                )
                  return this.chars[d];
                d += 1;
              }
              return (
                ((typeof u == "string" && u.charCodeAt(0) !== 13) || !u) &&
                  console &&
                  console.warn &&
                  !this._warned &&
                  ((this._warned = !0),
                  console.warn(
                    "Missing character from exported characters list: ",
                    u,
                    h,
                    m
                  )),
                e
              );
            },
            getFontByName: function (u) {
              for (var h = 0, m = this.fonts.length; h < m; ) {
                if (this.fonts[h].fName === u) return this.fonts[h];
                h += 1;
              }
              return this.fonts[0];
            },
            measureText: function (u, h, m) {
              var d = this.getFontByName(h),
                p = u;
              if (!d.cache[p]) {
                var g = d.helper;
                if (u === " ") {
                  var c = g.measureText("|" + u + "|"),
                    v = g.measureText("||");
                  d.cache[p] = (c - v) / 100;
                } else d.cache[p] = g.measureText(u) / 100;
              }
              return d.cache[p] * m;
            },
            checkLoadedFonts: function () {
              var u,
                h,
                m,
                d = this.fonts.length,
                p = d;
              for (u = 0; u < d; u += 1)
                this.fonts[u].loaded
                  ? (p -= 1)
                  : this.fonts[u].fOrigin === "n" || this.fonts[u].origin === 0
                  ? (this.fonts[u].loaded = !0)
                  : ((h = this.fonts[u].monoCase.node),
                    (m = this.fonts[u].monoCase.w),
                    h.offsetWidth !== m
                      ? ((p -= 1), (this.fonts[u].loaded = !0))
                      : ((h = this.fonts[u].sansCase.node),
                        (m = this.fonts[u].sansCase.w),
                        h.offsetWidth !== m &&
                          ((p -= 1), (this.fonts[u].loaded = !0))),
                    this.fonts[u].loaded &&
                      (this.fonts[u].sansCase.parent.parentNode.removeChild(
                        this.fonts[u].sansCase.parent
                      ),
                      this.fonts[u].monoCase.parent.parentNode.removeChild(
                        this.fonts[u].monoCase.parent
                      )));
              p !== 0 && Date.now() - this.initTime < 5e3
                ? setTimeout(this.checkLoadedFontsBinded, 20)
                : setTimeout(this.setIsLoadedBinded, 10);
            },
            setIsLoaded: function () {
              this.isLoaded = !0;
            },
          };
          return (l.prototype = f), l;
        })();
        function SlotManager(e) {
          this.animationData = e;
        }
        function slotFactory(e) {
          return new SlotManager(e);
        }
        function RenderableElement() {}
        (SlotManager.prototype.getProp = function (e) {
          return this.animationData.slots && this.animationData.slots[e.sid]
            ? Object.assign(e, this.animationData.slots[e.sid].p)
            : e;
        }),
          (RenderableElement.prototype = {
            initRenderable: function () {
              (this.isInRange = !1),
                (this.hidden = !1),
                (this.isTransparent = !1),
                (this.renderableComponents = []);
            },
            addRenderableComponent: function (e) {
              this.renderableComponents.indexOf(e) === -1 &&
                this.renderableComponents.push(e);
            },
            removeRenderableComponent: function (e) {
              this.renderableComponents.indexOf(e) !== -1 &&
                this.renderableComponents.splice(
                  this.renderableComponents.indexOf(e),
                  1
                );
            },
            prepareRenderableFrame: function (e) {
              this.checkLayerLimits(e);
            },
            checkTransparency: function () {
              this.finalTransform.mProp.o.v <= 0
                ? !this.isTransparent &&
                  this.globalData.renderConfig.hideOnTransparent &&
                  ((this.isTransparent = !0), this.hide())
                : this.isTransparent &&
                  ((this.isTransparent = !1), this.show());
            },
            checkLayerLimits: function (e) {
              this.data.ip - this.data.st <= e &&
              this.data.op - this.data.st > e
                ? this.isInRange !== !0 &&
                  ((this.globalData._mdf = !0),
                  (this._mdf = !0),
                  (this.isInRange = !0),
                  this.show())
                : this.isInRange !== !1 &&
                  ((this.globalData._mdf = !0),
                  (this.isInRange = !1),
                  this.hide());
            },
            renderRenderable: function () {
              var e,
                t = this.renderableComponents.length;
              for (e = 0; e < t; e += 1)
                this.renderableComponents[e].renderFrame(this._isFirstFrame);
            },
            sourceRectAtTime: function () {
              return { top: 0, left: 0, width: 100, height: 100 };
            },
            getLayerSize: function () {
              return this.data.ty === 5
                ? { w: this.data.textData.width, h: this.data.textData.height }
                : { w: this.data.width, h: this.data.height };
            },
          });
        var getBlendMode =
            ((blendModeEnums = {
              0: "source-over",
              1: "multiply",
              2: "screen",
              3: "overlay",
              4: "darken",
              5: "lighten",
              6: "color-dodge",
              7: "color-burn",
              8: "hard-light",
              9: "soft-light",
              10: "difference",
              11: "exclusion",
              12: "hue",
              13: "saturation",
              14: "color",
              15: "luminosity",
            }),
            function (e) {
              return blendModeEnums[e] || "";
            }),
          blendModeEnums;
        function SliderEffect(e, t, r) {
          this.p = PropertyFactory.getProp(t, e.v, 0, 0, r);
        }
        function AngleEffect(e, t, r) {
          this.p = PropertyFactory.getProp(t, e.v, 0, 0, r);
        }
        function ColorEffect(e, t, r) {
          this.p = PropertyFactory.getProp(t, e.v, 1, 0, r);
        }
        function PointEffect(e, t, r) {
          this.p = PropertyFactory.getProp(t, e.v, 1, 0, r);
        }
        function LayerIndexEffect(e, t, r) {
          this.p = PropertyFactory.getProp(t, e.v, 0, 0, r);
        }
        function MaskIndexEffect(e, t, r) {
          this.p = PropertyFactory.getProp(t, e.v, 0, 0, r);
        }
        function CheckboxEffect(e, t, r) {
          this.p = PropertyFactory.getProp(t, e.v, 0, 0, r);
        }
        function NoValueEffect() {
          this.p = {};
        }
        function EffectsManager(e, t) {
          var r,
            n = e.ef || [];
          this.effectElements = [];
          var i,
            a = n.length;
          for (r = 0; r < a; r += 1)
            (i = new GroupEffect(n[r], t)), this.effectElements.push(i);
        }
        function GroupEffect(e, t) {
          this.init(e, t);
        }
        function BaseElement() {}
        function FrameElement() {}
        function FootageElement(e, t, r) {
          this.initFrame(),
            this.initRenderable(),
            (this.assetData = t.getAssetData(e.refId)),
            (this.footageData = t.imageLoader.getAsset(this.assetData)),
            this.initBaseData(e, t, r);
        }
        function AudioElement(e, t, r) {
          this.initFrame(),
            this.initRenderable(),
            (this.assetData = t.getAssetData(e.refId)),
            this.initBaseData(e, t, r),
            (this._isPlaying = !1),
            (this._canPlay = !1);
          var n = this.globalData.getAssetsPath(this.assetData);
          (this.audio = this.globalData.audioController.createAudio(n)),
            (this._currentTime = 0),
            this.globalData.audioController.addAudio(this),
            (this._volumeMultiplier = 1),
            (this._volume = 1),
            (this._previousVolume = null),
            (this.tm = e.tm
              ? PropertyFactory.getProp(this, e.tm, 0, t.frameRate, this)
              : { _placeholder: !0 }),
            (this.lv = PropertyFactory.getProp(
              this,
              e.au && e.au.lv ? e.au.lv : { k: [100] },
              1,
              0.01,
              this
            ));
        }
        function BaseRenderer() {}
        extendPrototype([DynamicPropertyContainer], GroupEffect),
          (GroupEffect.prototype.getValue =
            GroupEffect.prototype.iterateDynamicProperties),
          (GroupEffect.prototype.init = function (e, t) {
            var r;
            (this.data = e),
              (this.effectElements = []),
              this.initDynamicPropertyContainer(t);
            var n,
              i = this.data.ef.length,
              a = this.data.ef;
            for (r = 0; r < i; r += 1) {
              switch (((n = null), a[r].ty)) {
                case 0:
                  n = new SliderEffect(a[r], t, this);
                  break;
                case 1:
                  n = new AngleEffect(a[r], t, this);
                  break;
                case 2:
                  n = new ColorEffect(a[r], t, this);
                  break;
                case 3:
                  n = new PointEffect(a[r], t, this);
                  break;
                case 4:
                case 7:
                  n = new CheckboxEffect(a[r], t, this);
                  break;
                case 10:
                  n = new LayerIndexEffect(a[r], t, this);
                  break;
                case 11:
                  n = new MaskIndexEffect(a[r], t, this);
                  break;
                case 5:
                  n = new EffectsManager(a[r], t, this);
                  break;
                default:
                  n = new NoValueEffect(a[r], t, this);
              }
              n && this.effectElements.push(n);
            }
          }),
          (BaseElement.prototype = {
            checkMasks: function () {
              if (!this.data.hasMask) return !1;
              for (var e = 0, t = this.data.masksProperties.length; e < t; ) {
                if (
                  this.data.masksProperties[e].mode !== "n" &&
                  this.data.masksProperties[e].cl !== !1
                )
                  return !0;
                e += 1;
              }
              return !1;
            },
            initExpressions: function () {
              var e = getExpressionInterfaces();
              if (e) {
                var t = e("layer"),
                  r = e("effects"),
                  n = e("shape"),
                  i = e("text"),
                  a = e("comp");
                (this.layerInterface = t(this)),
                  this.data.hasMask &&
                    this.maskManager &&
                    this.layerInterface.registerMaskInterface(this.maskManager);
                var o = r.createEffectsInterface(this, this.layerInterface);
                this.layerInterface.registerEffectsInterface(o),
                  this.data.ty === 0 || this.data.xt
                    ? (this.compInterface = a(this))
                    : this.data.ty === 4
                    ? ((this.layerInterface.shapeInterface = n(
                        this.shapesData,
                        this.itemsData,
                        this.layerInterface
                      )),
                      (this.layerInterface.content =
                        this.layerInterface.shapeInterface))
                    : this.data.ty === 5 &&
                      ((this.layerInterface.textInterface = i(this)),
                      (this.layerInterface.text =
                        this.layerInterface.textInterface));
              }
            },
            setBlendMode: function () {
              var e = getBlendMode(this.data.bm);
              (this.baseElement || this.layerElement).style["mix-blend-mode"] =
                e;
            },
            initBaseData: function (e, t, r) {
              (this.globalData = t),
                (this.comp = r),
                (this.data = e),
                (this.layerId = createElementID()),
                this.data.sr || (this.data.sr = 1),
                (this.effectsManager = new EffectsManager(
                  this.data,
                  this,
                  this.dynamicProperties
                ));
            },
            getType: function () {
              return this.type;
            },
            sourceRectAtTime: function () {},
          }),
          (FrameElement.prototype = {
            initFrame: function () {
              (this._isFirstFrame = !1),
                (this.dynamicProperties = []),
                (this._mdf = !1);
            },
            prepareProperties: function (e, t) {
              var r,
                n = this.dynamicProperties.length;
              for (r = 0; r < n; r += 1)
                (t ||
                  (this._isParent &&
                    this.dynamicProperties[r].propType === "transform")) &&
                  (this.dynamicProperties[r].getValue(),
                  this.dynamicProperties[r]._mdf &&
                    ((this.globalData._mdf = !0), (this._mdf = !0)));
            },
            addDynamicProperty: function (e) {
              this.dynamicProperties.indexOf(e) === -1 &&
                this.dynamicProperties.push(e);
            },
          }),
          (FootageElement.prototype.prepareFrame = function () {}),
          extendPrototype(
            [RenderableElement, BaseElement, FrameElement],
            FootageElement
          ),
          (FootageElement.prototype.getBaseElement = function () {
            return null;
          }),
          (FootageElement.prototype.renderFrame = function () {}),
          (FootageElement.prototype.destroy = function () {}),
          (FootageElement.prototype.initExpressions = function () {
            var e = getExpressionInterfaces();
            if (e) {
              var t = e("footage");
              this.layerInterface = t(this);
            }
          }),
          (FootageElement.prototype.getFootageData = function () {
            return this.footageData;
          }),
          (AudioElement.prototype.prepareFrame = function (e) {
            if (
              (this.prepareRenderableFrame(e, !0),
              this.prepareProperties(e, !0),
              this.tm._placeholder)
            )
              this._currentTime = e / this.data.sr;
            else {
              var t = this.tm.v;
              this._currentTime = t;
            }
            this._volume = this.lv.v[0];
            var r = this._volume * this._volumeMultiplier;
            this._previousVolume !== r &&
              ((this._previousVolume = r), this.audio.volume(r));
          }),
          extendPrototype(
            [RenderableElement, BaseElement, FrameElement],
            AudioElement
          ),
          (AudioElement.prototype.renderFrame = function () {
            this.isInRange &&
              this._canPlay &&
              (this._isPlaying
                ? (!this.audio.playing() ||
                    Math.abs(
                      this._currentTime / this.globalData.frameRate -
                        this.audio.seek()
                    ) > 0.1) &&
                  this.audio.seek(this._currentTime / this.globalData.frameRate)
                : (this.audio.play(),
                  this.audio.seek(
                    this._currentTime / this.globalData.frameRate
                  ),
                  (this._isPlaying = !0)));
          }),
          (AudioElement.prototype.show = function () {}),
          (AudioElement.prototype.hide = function () {
            this.audio.pause(), (this._isPlaying = !1);
          }),
          (AudioElement.prototype.pause = function () {
            this.audio.pause(), (this._isPlaying = !1), (this._canPlay = !1);
          }),
          (AudioElement.prototype.resume = function () {
            this._canPlay = !0;
          }),
          (AudioElement.prototype.setRate = function (e) {
            this.audio.rate(e);
          }),
          (AudioElement.prototype.volume = function (e) {
            (this._volumeMultiplier = e),
              (this._previousVolume = e * this._volume),
              this.audio.volume(this._previousVolume);
          }),
          (AudioElement.prototype.getBaseElement = function () {
            return null;
          }),
          (AudioElement.prototype.destroy = function () {}),
          (AudioElement.prototype.sourceRectAtTime = function () {}),
          (AudioElement.prototype.initExpressions = function () {}),
          (BaseRenderer.prototype.checkLayers = function (e) {
            var t,
              r,
              n = this.layers.length;
            for (this.completeLayers = !0, t = n - 1; t >= 0; t -= 1)
              this.elements[t] ||
                ((r = this.layers[t]).ip - r.st <= e - this.layers[t].st &&
                  r.op - r.st > e - this.layers[t].st &&
                  this.buildItem(t)),
                (this.completeLayers =
                  !!this.elements[t] && this.completeLayers);
            this.checkPendingElements();
          }),
          (BaseRenderer.prototype.createItem = function (e) {
            switch (e.ty) {
              case 2:
                return this.createImage(e);
              case 0:
                return this.createComp(e);
              case 1:
                return this.createSolid(e);
              case 3:
              default:
                return this.createNull(e);
              case 4:
                return this.createShape(e);
              case 5:
                return this.createText(e);
              case 6:
                return this.createAudio(e);
              case 13:
                return this.createCamera(e);
              case 15:
                return this.createFootage(e);
            }
          }),
          (BaseRenderer.prototype.createCamera = function () {
            throw new Error("You're using a 3d camera. Try the html renderer.");
          }),
          (BaseRenderer.prototype.createAudio = function (e) {
            return new AudioElement(e, this.globalData, this);
          }),
          (BaseRenderer.prototype.createFootage = function (e) {
            return new FootageElement(e, this.globalData, this);
          }),
          (BaseRenderer.prototype.buildAllItems = function () {
            var e,
              t = this.layers.length;
            for (e = 0; e < t; e += 1) this.buildItem(e);
            this.checkPendingElements();
          }),
          (BaseRenderer.prototype.includeLayers = function (e) {
            var t;
            this.completeLayers = !1;
            var r,
              n = e.length,
              i = this.layers.length;
            for (t = 0; t < n; t += 1)
              for (r = 0; r < i; ) {
                if (this.layers[r].id === e[t].id) {
                  this.layers[r] = e[t];
                  break;
                }
                r += 1;
              }
          }),
          (BaseRenderer.prototype.setProjectInterface = function (e) {
            this.globalData.projectInterface = e;
          }),
          (BaseRenderer.prototype.initItems = function () {
            this.globalData.progressiveLoad || this.buildAllItems();
          }),
          (BaseRenderer.prototype.buildElementParenting = function (e, t, r) {
            for (
              var n = this.elements, i = this.layers, a = 0, o = i.length;
              a < o;

            )
              i[a].ind == t &&
                (n[a] && n[a] !== !0
                  ? (r.push(n[a]),
                    n[a].setAsParent(),
                    i[a].parent !== void 0
                      ? this.buildElementParenting(e, i[a].parent, r)
                      : e.setHierarchy(r))
                  : (this.buildItem(a), this.addPendingElement(e))),
                (a += 1);
          }),
          (BaseRenderer.prototype.addPendingElement = function (e) {
            this.pendingElements.push(e);
          }),
          (BaseRenderer.prototype.searchExtraCompositions = function (e) {
            var t,
              r = e.length;
            for (t = 0; t < r; t += 1)
              if (e[t].xt) {
                var n = this.createComp(e[t]);
                n.initExpressions(),
                  this.globalData.projectInterface.registerComposition(n);
              }
          }),
          (BaseRenderer.prototype.getElementById = function (e) {
            var t,
              r = this.elements.length;
            for (t = 0; t < r; t += 1)
              if (this.elements[t].data.ind === e) return this.elements[t];
            return null;
          }),
          (BaseRenderer.prototype.getElementByPath = function (e) {
            var t,
              r = e.shift();
            if (typeof r == "number") t = this.elements[r];
            else {
              var n,
                i = this.elements.length;
              for (n = 0; n < i; n += 1)
                if (this.elements[n].data.nm === r) {
                  t = this.elements[n];
                  break;
                }
            }
            return e.length === 0 ? t : t.getElementByPath(e);
          }),
          (BaseRenderer.prototype.setupGlobalData = function (e, t) {
            (this.globalData.fontManager = new FontManager()),
              (this.globalData.slotManager = slotFactory(e)),
              this.globalData.fontManager.addChars(e.chars),
              this.globalData.fontManager.addFonts(e.fonts, t),
              (this.globalData.getAssetData =
                this.animationItem.getAssetData.bind(this.animationItem)),
              (this.globalData.getAssetsPath =
                this.animationItem.getAssetsPath.bind(this.animationItem)),
              (this.globalData.imageLoader = this.animationItem.imagePreloader),
              (this.globalData.audioController =
                this.animationItem.audioController),
              (this.globalData.frameId = 0),
              (this.globalData.frameRate = e.fr),
              (this.globalData.nm = e.nm),
              (this.globalData.compSize = { w: e.w, h: e.h });
          });
        var effectTypes = { TRANSFORM_EFFECT: "transformEFfect" };
        function TransformElement() {}
        function MaskElement(e, t, r) {
          (this.data = e),
            (this.element = t),
            (this.globalData = r),
            (this.storedData = []),
            (this.masksProperties = this.data.masksProperties || []),
            (this.maskElement = null);
          var n,
            i,
            a = this.globalData.defs,
            o = this.masksProperties ? this.masksProperties.length : 0;
          (this.viewData = createSizedArray(o)), (this.solidPath = "");
          var s,
            l,
            f,
            u,
            h,
            m,
            d = this.masksProperties,
            p = 0,
            g = [],
            c = createElementID(),
            v = "clipPath",
            y = "clip-path";
          for (n = 0; n < o; n += 1)
            if (
              (((d[n].mode !== "a" && d[n].mode !== "n") ||
                d[n].inv ||
                d[n].o.k !== 100 ||
                d[n].o.x) &&
                ((v = "mask"), (y = "mask")),
              (d[n].mode !== "s" && d[n].mode !== "i") || p !== 0
                ? (f = null)
                : ((f = createNS("rect")).setAttribute("fill", "#ffffff"),
                  f.setAttribute("width", this.element.comp.data.w || 0),
                  f.setAttribute("height", this.element.comp.data.h || 0),
                  g.push(f)),
              (i = createNS("path")),
              d[n].mode === "n")
            )
              (this.viewData[n] = {
                op: PropertyFactory.getProp(
                  this.element,
                  d[n].o,
                  0,
                  0.01,
                  this.element
                ),
                prop: ShapePropertyFactory.getShapeProp(this.element, d[n], 3),
                elem: i,
                lastPath: "",
              }),
                a.appendChild(i);
            else {
              var b;
              if (
                ((p += 1),
                i.setAttribute(
                  "fill",
                  d[n].mode === "s" ? "#000000" : "#ffffff"
                ),
                i.setAttribute("clip-rule", "nonzero"),
                d[n].x.k !== 0
                  ? ((v = "mask"),
                    (y = "mask"),
                    (m = PropertyFactory.getProp(
                      this.element,
                      d[n].x,
                      0,
                      null,
                      this.element
                    )),
                    (b = createElementID()),
                    (u = createNS("filter")).setAttribute("id", b),
                    (h = createNS("feMorphology")).setAttribute(
                      "operator",
                      "erode"
                    ),
                    h.setAttribute("in", "SourceGraphic"),
                    h.setAttribute("radius", "0"),
                    u.appendChild(h),
                    a.appendChild(u),
                    i.setAttribute(
                      "stroke",
                      d[n].mode === "s" ? "#000000" : "#ffffff"
                    ))
                  : ((h = null), (m = null)),
                (this.storedData[n] = {
                  elem: i,
                  x: m,
                  expan: h,
                  lastPath: "",
                  lastOperator: "",
                  filterId: b,
                  lastRadius: 0,
                }),
                d[n].mode === "i")
              ) {
                l = g.length;
                var x = createNS("g");
                for (s = 0; s < l; s += 1) x.appendChild(g[s]);
                var S = createNS("mask");
                S.setAttribute("mask-type", "alpha"),
                  S.setAttribute("id", c + "_" + p),
                  S.appendChild(i),
                  a.appendChild(S),
                  x.setAttribute(
                    "mask",
                    "url(" + getLocationHref() + "#" + c + "_" + p + ")"
                  ),
                  (g.length = 0),
                  g.push(x);
              } else g.push(i);
              d[n].inv &&
                !this.solidPath &&
                (this.solidPath = this.createLayerSolidPath()),
                (this.viewData[n] = {
                  elem: i,
                  lastPath: "",
                  op: PropertyFactory.getProp(
                    this.element,
                    d[n].o,
                    0,
                    0.01,
                    this.element
                  ),
                  prop: ShapePropertyFactory.getShapeProp(
                    this.element,
                    d[n],
                    3
                  ),
                  invRect: f,
                }),
                this.viewData[n].prop.k ||
                  this.drawPath(
                    d[n],
                    this.viewData[n].prop.v,
                    this.viewData[n]
                  );
            }
          for (
            this.maskElement = createNS(v), o = g.length, n = 0;
            n < o;
            n += 1
          )
            this.maskElement.appendChild(g[n]);
          p > 0 &&
            (this.maskElement.setAttribute("id", c),
            this.element.maskedElement.setAttribute(
              y,
              "url(" + getLocationHref() + "#" + c + ")"
            ),
            a.appendChild(this.maskElement)),
            this.viewData.length && this.element.addRenderableComponent(this);
        }
        (TransformElement.prototype = {
          initTransform: function () {
            var e = new Matrix();
            (this.finalTransform = {
              mProp: this.data.ks
                ? TransformPropertyFactory.getTransformProperty(
                    this,
                    this.data.ks,
                    this
                  )
                : { o: 0 },
              _matMdf: !1,
              _localMatMdf: !1,
              _opMdf: !1,
              mat: e,
              localMat: e,
              localOpacity: 1,
            }),
              this.data.ao && (this.finalTransform.mProp.autoOriented = !0),
              this.data.ty;
          },
          renderTransform: function () {
            if (
              ((this.finalTransform._opMdf =
                this.finalTransform.mProp.o._mdf || this._isFirstFrame),
              (this.finalTransform._matMdf =
                this.finalTransform.mProp._mdf || this._isFirstFrame),
              this.hierarchy)
            ) {
              var e,
                t = this.finalTransform.mat,
                r = 0,
                n = this.hierarchy.length;
              if (!this.finalTransform._matMdf)
                for (; r < n; ) {
                  if (this.hierarchy[r].finalTransform.mProp._mdf) {
                    this.finalTransform._matMdf = !0;
                    break;
                  }
                  r += 1;
                }
              if (this.finalTransform._matMdf)
                for (
                  e = this.finalTransform.mProp.v.props,
                    t.cloneFromProps(e),
                    r = 0;
                  r < n;
                  r += 1
                )
                  t.multiply(this.hierarchy[r].finalTransform.mProp.v);
            }
            this.finalTransform._matMdf &&
              (this.finalTransform._localMatMdf = this.finalTransform._matMdf),
              this.finalTransform._opMdf &&
                (this.finalTransform.localOpacity =
                  this.finalTransform.mProp.o.v);
          },
          renderLocalTransform: function () {
            if (this.localTransforms) {
              var e = 0,
                t = this.localTransforms.length;
              if (
                ((this.finalTransform._localMatMdf =
                  this.finalTransform._matMdf),
                !this.finalTransform._localMatMdf ||
                  !this.finalTransform._opMdf)
              )
                for (; e < t; )
                  this.localTransforms[e]._mdf &&
                    (this.finalTransform._localMatMdf = !0),
                    this.localTransforms[e]._opMdf &&
                      !this.finalTransform._opMdf &&
                      ((this.finalTransform.localOpacity =
                        this.finalTransform.mProp.o.v),
                      (this.finalTransform._opMdf = !0)),
                    (e += 1);
              if (this.finalTransform._localMatMdf) {
                var r = this.finalTransform.localMat;
                for (
                  this.localTransforms[0].matrix.clone(r), e = 1;
                  e < t;
                  e += 1
                ) {
                  var n = this.localTransforms[e].matrix;
                  r.multiply(n);
                }
                r.multiply(this.finalTransform.mat);
              }
              if (this.finalTransform._opMdf) {
                var i = this.finalTransform.localOpacity;
                for (e = 0; e < t; e += 1)
                  i *= 0.01 * this.localTransforms[e].opacity;
                this.finalTransform.localOpacity = i;
              }
            }
          },
          searchEffectTransforms: function () {
            if (this.renderableEffectsManager) {
              var e = this.renderableEffectsManager.getEffects(
                effectTypes.TRANSFORM_EFFECT
              );
              if (e.length) {
                (this.localTransforms = []),
                  (this.finalTransform.localMat = new Matrix());
                var t = 0,
                  r = e.length;
                for (t = 0; t < r; t += 1) this.localTransforms.push(e[t]);
              }
            }
          },
          globalToLocal: function (e) {
            var t = [];
            t.push(this.finalTransform);
            for (var r, n = !0, i = this.comp; n; )
              i.finalTransform
                ? (i.data.hasMask && t.splice(0, 0, i.finalTransform),
                  (i = i.comp))
                : (n = !1);
            var a,
              o = t.length;
            for (r = 0; r < o; r += 1)
              (a = t[r].mat.applyToPointArray(0, 0, 0)),
                (e = [e[0] - a[0], e[1] - a[1], 0]);
            return e;
          },
          mHelper: new Matrix(),
        }),
          (MaskElement.prototype.getMaskProperty = function (e) {
            return this.viewData[e].prop;
          }),
          (MaskElement.prototype.renderFrame = function (e) {
            var t,
              r = this.element.finalTransform.mat,
              n = this.masksProperties.length;
            for (t = 0; t < n; t += 1)
              if (
                ((this.viewData[t].prop._mdf || e) &&
                  this.drawPath(
                    this.masksProperties[t],
                    this.viewData[t].prop.v,
                    this.viewData[t]
                  ),
                (this.viewData[t].op._mdf || e) &&
                  this.viewData[t].elem.setAttribute(
                    "fill-opacity",
                    this.viewData[t].op.v
                  ),
                this.masksProperties[t].mode !== "n" &&
                  (this.viewData[t].invRect &&
                    (this.element.finalTransform.mProp._mdf || e) &&
                    this.viewData[t].invRect.setAttribute(
                      "transform",
                      r.getInverseMatrix().to2dCSS()
                    ),
                  this.storedData[t].x && (this.storedData[t].x._mdf || e)))
              ) {
                var i = this.storedData[t].expan;
                this.storedData[t].x.v < 0
                  ? (this.storedData[t].lastOperator !== "erode" &&
                      ((this.storedData[t].lastOperator = "erode"),
                      this.storedData[t].elem.setAttribute(
                        "filter",
                        "url(" +
                          getLocationHref() +
                          "#" +
                          this.storedData[t].filterId +
                          ")"
                      )),
                    i.setAttribute("radius", -this.storedData[t].x.v))
                  : (this.storedData[t].lastOperator !== "dilate" &&
                      ((this.storedData[t].lastOperator = "dilate"),
                      this.storedData[t].elem.setAttribute("filter", null)),
                    this.storedData[t].elem.setAttribute(
                      "stroke-width",
                      2 * this.storedData[t].x.v
                    ));
              }
          }),
          (MaskElement.prototype.getMaskelement = function () {
            return this.maskElement;
          }),
          (MaskElement.prototype.createLayerSolidPath = function () {
            var e = "M0,0 ";
            return (
              (e += " h" + this.globalData.compSize.w),
              (e += " v" + this.globalData.compSize.h),
              (e += " h-" + this.globalData.compSize.w),
              (e += " v-" + this.globalData.compSize.h + " ")
            );
          }),
          (MaskElement.prototype.drawPath = function (e, t, r) {
            var n,
              i,
              a = " M" + t.v[0][0] + "," + t.v[0][1];
            for (i = t._length, n = 1; n < i; n += 1)
              a +=
                " C" +
                t.o[n - 1][0] +
                "," +
                t.o[n - 1][1] +
                " " +
                t.i[n][0] +
                "," +
                t.i[n][1] +
                " " +
                t.v[n][0] +
                "," +
                t.v[n][1];
            if (
              (t.c &&
                i > 1 &&
                (a +=
                  " C" +
                  t.o[n - 1][0] +
                  "," +
                  t.o[n - 1][1] +
                  " " +
                  t.i[0][0] +
                  "," +
                  t.i[0][1] +
                  " " +
                  t.v[0][0] +
                  "," +
                  t.v[0][1]),
              r.lastPath !== a)
            ) {
              var o = "";
              r.elem &&
                (t.c && (o = e.inv ? this.solidPath + a : a),
                r.elem.setAttribute("d", o)),
                (r.lastPath = a);
            }
          }),
          (MaskElement.prototype.destroy = function () {
            (this.element = null),
              (this.globalData = null),
              (this.maskElement = null),
              (this.data = null),
              (this.masksProperties = null);
          });
        var filtersFactory = (function () {
            var e = {};
            return (
              (e.createFilter = function (t, r) {
                var n = createNS("filter");
                return (
                  n.setAttribute("id", t),
                  r !== !0 &&
                    (n.setAttribute("filterUnits", "objectBoundingBox"),
                    n.setAttribute("x", "0%"),
                    n.setAttribute("y", "0%"),
                    n.setAttribute("width", "100%"),
                    n.setAttribute("height", "100%")),
                  n
                );
              }),
              (e.createAlphaToLuminanceFilter = function () {
                var t = createNS("feColorMatrix");
                return (
                  t.setAttribute("type", "matrix"),
                  t.setAttribute("color-interpolation-filters", "sRGB"),
                  t.setAttribute(
                    "values",
                    "0 0 0 1 0  0 0 0 1 0  0 0 0 1 0  0 0 0 1 1"
                  ),
                  t
                );
              }),
              e
            );
          })(),
          featureSupport = (function () {
            var e = {
              maskType: !0,
              svgLumaHidden: !0,
              offscreenCanvas: typeof OffscreenCanvas < "u",
            };
            return (
              (/MSIE 10/i.test(navigator.userAgent) ||
                /MSIE 9/i.test(navigator.userAgent) ||
                /rv:11.0/i.test(navigator.userAgent) ||
                /Edge\/\d./i.test(navigator.userAgent)) &&
                (e.maskType = !1),
              /firefox/i.test(navigator.userAgent) && (e.svgLumaHidden = !1),
              e
            );
          })(),
          registeredEffects$1 = {},
          idPrefix = "filter_result_";
        function SVGEffects(e) {
          var t,
            r,
            n = "SourceGraphic",
            i = e.data.ef ? e.data.ef.length : 0,
            a = createElementID(),
            o = filtersFactory.createFilter(a, !0),
            s = 0;
          for (this.filters = [], t = 0; t < i; t += 1) {
            r = null;
            var l = e.data.ef[t].ty;
            registeredEffects$1[l] &&
              ((r = new registeredEffects$1[l].effect(
                o,
                e.effectsManager.effectElements[t],
                e,
                idPrefix + s,
                n
              )),
              (n = idPrefix + s),
              registeredEffects$1[l].countsAsEffect && (s += 1)),
              r && this.filters.push(r);
          }
          s &&
            (e.globalData.defs.appendChild(o),
            e.layerElement.setAttribute(
              "filter",
              "url(" + getLocationHref() + "#" + a + ")"
            )),
            this.filters.length && e.addRenderableComponent(this);
        }
        function registerEffect$1(e, t, r) {
          registeredEffects$1[e] = { effect: t, countsAsEffect: r };
        }
        function SVGBaseElement() {}
        function HierarchyElement() {}
        function RenderableDOMElement() {}
        function IImageElement(e, t, r) {
          (this.assetData = t.getAssetData(e.refId)),
            this.assetData &&
              this.assetData.sid &&
              (this.assetData = t.slotManager.getProp(this.assetData)),
            this.initElement(e, t, r),
            (this.sourceRect = {
              top: 0,
              left: 0,
              width: this.assetData.w,
              height: this.assetData.h,
            });
        }
        function ProcessedElement(e, t) {
          (this.elem = e), (this.pos = t);
        }
        function IShapeElement() {}
        (SVGEffects.prototype.renderFrame = function (e) {
          var t,
            r = this.filters.length;
          for (t = 0; t < r; t += 1) this.filters[t].renderFrame(e);
        }),
          (SVGEffects.prototype.getEffects = function (e) {
            var t,
              r = this.filters.length,
              n = [];
            for (t = 0; t < r; t += 1)
              this.filters[t].type === e && n.push(this.filters[t]);
            return n;
          }),
          (SVGBaseElement.prototype = {
            initRendererElement: function () {
              this.layerElement = createNS("g");
            },
            createContainerElements: function () {
              (this.matteElement = createNS("g")),
                (this.transformedElement = this.layerElement),
                (this.maskedElement = this.layerElement),
                (this._sizeChanged = !1);
              var e = null;
              if (this.data.td) {
                this.matteMasks = {};
                var t = createNS("g");
                t.setAttribute("id", this.layerId),
                  t.appendChild(this.layerElement),
                  (e = t),
                  this.globalData.defs.appendChild(t);
              } else
                this.data.tt
                  ? (this.matteElement.appendChild(this.layerElement),
                    (e = this.matteElement),
                    (this.baseElement = this.matteElement))
                  : (this.baseElement = this.layerElement);
              if (
                (this.data.ln &&
                  this.layerElement.setAttribute("id", this.data.ln),
                this.data.cl &&
                  this.layerElement.setAttribute("class", this.data.cl),
                this.data.ty === 0 && !this.data.hd)
              ) {
                var r = createNS("clipPath"),
                  n = createNS("path");
                n.setAttribute(
                  "d",
                  "M0,0 L" +
                    this.data.w +
                    ",0 L" +
                    this.data.w +
                    "," +
                    this.data.h +
                    " L0," +
                    this.data.h +
                    "z"
                );
                var i = createElementID();
                if (
                  (r.setAttribute("id", i),
                  r.appendChild(n),
                  this.globalData.defs.appendChild(r),
                  this.checkMasks())
                ) {
                  var a = createNS("g");
                  a.setAttribute(
                    "clip-path",
                    "url(" + getLocationHref() + "#" + i + ")"
                  ),
                    a.appendChild(this.layerElement),
                    (this.transformedElement = a),
                    e
                      ? e.appendChild(this.transformedElement)
                      : (this.baseElement = this.transformedElement);
                } else
                  this.layerElement.setAttribute(
                    "clip-path",
                    "url(" + getLocationHref() + "#" + i + ")"
                  );
              }
              this.data.bm !== 0 && this.setBlendMode();
            },
            renderElement: function () {
              this.finalTransform._localMatMdf &&
                this.transformedElement.setAttribute(
                  "transform",
                  this.finalTransform.localMat.to2dCSS()
                ),
                this.finalTransform._opMdf &&
                  this.transformedElement.setAttribute(
                    "opacity",
                    this.finalTransform.localOpacity
                  );
            },
            destroyBaseElement: function () {
              (this.layerElement = null),
                (this.matteElement = null),
                this.maskManager.destroy();
            },
            getBaseElement: function () {
              return this.data.hd ? null : this.baseElement;
            },
            createRenderableComponents: function () {
              (this.maskManager = new MaskElement(
                this.data,
                this,
                this.globalData
              )),
                (this.renderableEffectsManager = new SVGEffects(this)),
                this.searchEffectTransforms();
            },
            getMatte: function (e) {
              if (
                (this.matteMasks || (this.matteMasks = {}), !this.matteMasks[e])
              ) {
                var t,
                  r,
                  n,
                  i,
                  a = this.layerId + "_" + e;
                if (e === 1 || e === 3) {
                  var o = createNS("mask");
                  o.setAttribute("id", a),
                    o.setAttribute(
                      "mask-type",
                      e === 3 ? "luminance" : "alpha"
                    ),
                    (n = createNS("use")).setAttributeNS(
                      "http://www.w3.org/1999/xlink",
                      "href",
                      "#" + this.layerId
                    ),
                    o.appendChild(n),
                    this.globalData.defs.appendChild(o),
                    featureSupport.maskType ||
                      e !== 1 ||
                      (o.setAttribute("mask-type", "luminance"),
                      (t = createElementID()),
                      (r = filtersFactory.createFilter(t)),
                      this.globalData.defs.appendChild(r),
                      r.appendChild(
                        filtersFactory.createAlphaToLuminanceFilter()
                      ),
                      (i = createNS("g")).appendChild(n),
                      o.appendChild(i),
                      i.setAttribute(
                        "filter",
                        "url(" + getLocationHref() + "#" + t + ")"
                      ));
                } else if (e === 2) {
                  var s = createNS("mask");
                  s.setAttribute("id", a), s.setAttribute("mask-type", "alpha");
                  var l = createNS("g");
                  s.appendChild(l),
                    (t = createElementID()),
                    (r = filtersFactory.createFilter(t));
                  var f = createNS("feComponentTransfer");
                  f.setAttribute("in", "SourceGraphic"), r.appendChild(f);
                  var u = createNS("feFuncA");
                  u.setAttribute("type", "table"),
                    u.setAttribute("tableValues", "1.0 0.0"),
                    f.appendChild(u),
                    this.globalData.defs.appendChild(r);
                  var h = createNS("rect");
                  h.setAttribute("width", this.comp.data.w),
                    h.setAttribute("height", this.comp.data.h),
                    h.setAttribute("x", "0"),
                    h.setAttribute("y", "0"),
                    h.setAttribute("fill", "#ffffff"),
                    h.setAttribute("opacity", "0"),
                    l.setAttribute(
                      "filter",
                      "url(" + getLocationHref() + "#" + t + ")"
                    ),
                    l.appendChild(h),
                    (n = createNS("use")).setAttributeNS(
                      "http://www.w3.org/1999/xlink",
                      "href",
                      "#" + this.layerId
                    ),
                    l.appendChild(n),
                    featureSupport.maskType ||
                      (s.setAttribute("mask-type", "luminance"),
                      r.appendChild(
                        filtersFactory.createAlphaToLuminanceFilter()
                      ),
                      (i = createNS("g")),
                      l.appendChild(h),
                      i.appendChild(this.layerElement),
                      l.appendChild(i)),
                    this.globalData.defs.appendChild(s);
                }
                this.matteMasks[e] = a;
              }
              return this.matteMasks[e];
            },
            setMatte: function (e) {
              this.matteElement &&
                this.matteElement.setAttribute(
                  "mask",
                  "url(" + getLocationHref() + "#" + e + ")"
                );
            },
          }),
          (HierarchyElement.prototype = {
            initHierarchy: function () {
              (this.hierarchy = []),
                (this._isParent = !1),
                this.checkParenting();
            },
            setHierarchy: function (e) {
              this.hierarchy = e;
            },
            setAsParent: function () {
              this._isParent = !0;
            },
            checkParenting: function () {
              this.data.parent !== void 0 &&
                this.comp.buildElementParenting(this, this.data.parent, []);
            },
          }),
          extendPrototype(
            [
              RenderableElement,
              createProxyFunction({
                initElement: function (e, t, r) {
                  this.initFrame(),
                    this.initBaseData(e, t, r),
                    this.initTransform(e, t, r),
                    this.initHierarchy(),
                    this.initRenderable(),
                    this.initRendererElement(),
                    this.createContainerElements(),
                    this.createRenderableComponents(),
                    this.createContent(),
                    this.hide();
                },
                hide: function () {
                  this.hidden ||
                    (this.isInRange && !this.isTransparent) ||
                    (((this.baseElement || this.layerElement).style.display =
                      "none"),
                    (this.hidden = !0));
                },
                show: function () {
                  this.isInRange &&
                    !this.isTransparent &&
                    (this.data.hd ||
                      ((this.baseElement || this.layerElement).style.display =
                        "block"),
                    (this.hidden = !1),
                    (this._isFirstFrame = !0));
                },
                renderFrame: function () {
                  this.data.hd ||
                    this.hidden ||
                    (this.renderTransform(),
                    this.renderRenderable(),
                    this.renderLocalTransform(),
                    this.renderElement(),
                    this.renderInnerContent(),
                    this._isFirstFrame && (this._isFirstFrame = !1));
                },
                renderInnerContent: function () {},
                prepareFrame: function (e) {
                  (this._mdf = !1),
                    this.prepareRenderableFrame(e),
                    this.prepareProperties(e, this.isInRange),
                    this.checkTransparency();
                },
                destroy: function () {
                  (this.innerElem = null), this.destroyBaseElement();
                },
              }),
            ],
            RenderableDOMElement
          ),
          extendPrototype(
            [
              BaseElement,
              TransformElement,
              SVGBaseElement,
              HierarchyElement,
              FrameElement,
              RenderableDOMElement,
            ],
            IImageElement
          ),
          (IImageElement.prototype.createContent = function () {
            var e = this.globalData.getAssetsPath(this.assetData);
            (this.innerElem = createNS("image")),
              this.innerElem.setAttribute("width", this.assetData.w + "px"),
              this.innerElem.setAttribute("height", this.assetData.h + "px"),
              this.innerElem.setAttribute(
                "preserveAspectRatio",
                this.assetData.pr ||
                  this.globalData.renderConfig.imagePreserveAspectRatio
              ),
              this.innerElem.setAttributeNS(
                "http://www.w3.org/1999/xlink",
                "href",
                e
              ),
              this.layerElement.appendChild(this.innerElem);
          }),
          (IImageElement.prototype.sourceRectAtTime = function () {
            return this.sourceRect;
          }),
          (IShapeElement.prototype = {
            addShapeToModifiers: function (e) {
              var t,
                r = this.shapeModifiers.length;
              for (t = 0; t < r; t += 1) this.shapeModifiers[t].addShape(e);
            },
            isShapeInAnimatedModifiers: function (e) {
              for (var t = this.shapeModifiers.length; 0 < t; )
                if (this.shapeModifiers[0].isAnimatedWithShape(e)) return !0;
              return !1;
            },
            renderModifiers: function () {
              if (this.shapeModifiers.length) {
                var e,
                  t = this.shapes.length;
                for (e = 0; e < t; e += 1) this.shapes[e].sh.reset();
                for (
                  e = (t = this.shapeModifiers.length) - 1;
                  e >= 0 &&
                  !this.shapeModifiers[e].processShapes(this._isFirstFrame);
                  e -= 1
                );
              }
            },
            searchProcessedElement: function (e) {
              for (
                var t = this.processedElements, r = 0, n = t.length;
                r < n;

              ) {
                if (t[r].elem === e) return t[r].pos;
                r += 1;
              }
              return 0;
            },
            addProcessedElement: function (e, t) {
              for (var r = this.processedElements, n = r.length; n; )
                if (r[(n -= 1)].elem === e) return void (r[n].pos = t);
              r.push(new ProcessedElement(e, t));
            },
            prepareFrame: function (e) {
              this.prepareRenderableFrame(e),
                this.prepareProperties(e, this.isInRange);
            },
          });
        var lineCapEnum = { 1: "butt", 2: "round", 3: "square" },
          lineJoinEnum = { 1: "miter", 2: "round", 3: "bevel" };
        function SVGShapeData(e, t, r) {
          (this.caches = []),
            (this.styles = []),
            (this.transformers = e),
            (this.lStr = ""),
            (this.sh = r),
            (this.lvl = t),
            (this._isAnimated = !!r.k);
          for (var n = 0, i = e.length; n < i; ) {
            if (e[n].mProps.dynamicProperties.length) {
              this._isAnimated = !0;
              break;
            }
            n += 1;
          }
        }
        function SVGStyleData(e, t) {
          (this.data = e),
            (this.type = e.ty),
            (this.d = ""),
            (this.lvl = t),
            (this._mdf = !1),
            (this.closed = e.hd === !0),
            (this.pElem = createNS("path")),
            (this.msElem = null);
        }
        function DashProperty(e, t, r, n) {
          var i;
          (this.elem = e),
            (this.frameId = -1),
            (this.dataProps = createSizedArray(t.length)),
            (this.renderer = r),
            (this.k = !1),
            (this.dashStr = ""),
            (this.dashArray = createTypedArray(
              "float32",
              t.length ? t.length - 1 : 0
            )),
            (this.dashoffset = createTypedArray("float32", 1)),
            this.initDynamicPropertyContainer(n);
          var a,
            o = t.length || 0;
          for (i = 0; i < o; i += 1)
            (a = PropertyFactory.getProp(e, t[i].v, 0, 0, this)),
              (this.k = a.k || this.k),
              (this.dataProps[i] = { n: t[i].n, p: a });
          this.k || this.getValue(!0), (this._isAnimated = this.k);
        }
        function SVGStrokeStyleData(e, t, r) {
          this.initDynamicPropertyContainer(e),
            (this.getValue = this.iterateDynamicProperties),
            (this.o = PropertyFactory.getProp(e, t.o, 0, 0.01, this)),
            (this.w = PropertyFactory.getProp(e, t.w, 0, null, this)),
            (this.d = new DashProperty(e, t.d || {}, "svg", this)),
            (this.c = PropertyFactory.getProp(e, t.c, 1, 255, this)),
            (this.style = r),
            (this._isAnimated = !!this._isAnimated);
        }
        function SVGFillStyleData(e, t, r) {
          this.initDynamicPropertyContainer(e),
            (this.getValue = this.iterateDynamicProperties),
            (this.o = PropertyFactory.getProp(e, t.o, 0, 0.01, this)),
            (this.c = PropertyFactory.getProp(e, t.c, 1, 255, this)),
            (this.style = r);
        }
        function SVGNoStyleData(e, t, r) {
          this.initDynamicPropertyContainer(e),
            (this.getValue = this.iterateDynamicProperties),
            (this.style = r);
        }
        function GradientProperty(e, t, r) {
          (this.data = t), (this.c = createTypedArray("uint8c", 4 * t.p));
          var n = t.k.k[0].s
            ? t.k.k[0].s.length - 4 * t.p
            : t.k.k.length - 4 * t.p;
          (this.o = createTypedArray("float32", n)),
            (this._cmdf = !1),
            (this._omdf = !1),
            (this._collapsable = this.checkCollapsable()),
            (this._hasOpacity = n),
            this.initDynamicPropertyContainer(r),
            (this.prop = PropertyFactory.getProp(e, t.k, 1, null, this)),
            (this.k = this.prop.k),
            this.getValue(!0);
        }
        function SVGGradientFillStyleData(e, t, r) {
          this.initDynamicPropertyContainer(e),
            (this.getValue = this.iterateDynamicProperties),
            this.initGradientData(e, t, r);
        }
        function SVGGradientStrokeStyleData(e, t, r) {
          this.initDynamicPropertyContainer(e),
            (this.getValue = this.iterateDynamicProperties),
            (this.w = PropertyFactory.getProp(e, t.w, 0, null, this)),
            (this.d = new DashProperty(e, t.d || {}, "svg", this)),
            this.initGradientData(e, t, r),
            (this._isAnimated = !!this._isAnimated);
        }
        function ShapeGroupData() {
          (this.it = []), (this.prevViewData = []), (this.gr = createNS("g"));
        }
        function SVGTransformData(e, t, r) {
          (this.transform = { mProps: e, op: t, container: r }),
            (this.elements = []),
            (this._isAnimated =
              this.transform.mProps.dynamicProperties.length ||
              this.transform.op.effectsSequence.length);
        }
        (SVGShapeData.prototype.setAsAnimated = function () {
          this._isAnimated = !0;
        }),
          (SVGStyleData.prototype.reset = function () {
            (this.d = ""), (this._mdf = !1);
          }),
          (DashProperty.prototype.getValue = function (e) {
            if (
              (this.elem.globalData.frameId !== this.frameId || e) &&
              ((this.frameId = this.elem.globalData.frameId),
              this.iterateDynamicProperties(),
              (this._mdf = this._mdf || e),
              this._mdf)
            ) {
              var t = 0,
                r = this.dataProps.length;
              for (
                this.renderer === "svg" && (this.dashStr = ""), t = 0;
                t < r;
                t += 1
              )
                this.dataProps[t].n !== "o"
                  ? this.renderer === "svg"
                    ? (this.dashStr += " " + this.dataProps[t].p.v)
                    : (this.dashArray[t] = this.dataProps[t].p.v)
                  : (this.dashoffset[0] = this.dataProps[t].p.v);
            }
          }),
          extendPrototype([DynamicPropertyContainer], DashProperty),
          extendPrototype([DynamicPropertyContainer], SVGStrokeStyleData),
          extendPrototype([DynamicPropertyContainer], SVGFillStyleData),
          extendPrototype([DynamicPropertyContainer], SVGNoStyleData),
          (GradientProperty.prototype.comparePoints = function (e, t) {
            for (var r = 0, n = this.o.length / 2; r < n; ) {
              if (Math.abs(e[4 * r] - e[4 * t + 2 * r]) > 0.01) return !1;
              r += 1;
            }
            return !0;
          }),
          (GradientProperty.prototype.checkCollapsable = function () {
            if (this.o.length / 2 != this.c.length / 4) return !1;
            if (this.data.k.k[0].s)
              for (var e = 0, t = this.data.k.k.length; e < t; ) {
                if (!this.comparePoints(this.data.k.k[e].s, this.data.p))
                  return !1;
                e += 1;
              }
            else if (!this.comparePoints(this.data.k.k, this.data.p)) return !1;
            return !0;
          }),
          (GradientProperty.prototype.getValue = function (e) {
            if (
              (this.prop.getValue(),
              (this._mdf = !1),
              (this._cmdf = !1),
              (this._omdf = !1),
              this.prop._mdf || e)
            ) {
              var t,
                r,
                n,
                i = 4 * this.data.p;
              for (t = 0; t < i; t += 1)
                (r = t % 4 == 0 ? 100 : 255),
                  (n = Math.round(this.prop.v[t] * r)),
                  this.c[t] !== n && ((this.c[t] = n), (this._cmdf = !e));
              if (this.o.length)
                for (i = this.prop.v.length, t = 4 * this.data.p; t < i; t += 1)
                  (r = t % 2 == 0 ? 100 : 1),
                    (n =
                      t % 2 == 0
                        ? Math.round(100 * this.prop.v[t])
                        : this.prop.v[t]),
                    this.o[t - 4 * this.data.p] !== n &&
                      ((this.o[t - 4 * this.data.p] = n), (this._omdf = !e));
              this._mdf = !e;
            }
          }),
          extendPrototype([DynamicPropertyContainer], GradientProperty),
          (SVGGradientFillStyleData.prototype.initGradientData = function (
            e,
            t,
            r
          ) {
            (this.o = PropertyFactory.getProp(e, t.o, 0, 0.01, this)),
              (this.s = PropertyFactory.getProp(e, t.s, 1, null, this)),
              (this.e = PropertyFactory.getProp(e, t.e, 1, null, this)),
              (this.h = PropertyFactory.getProp(
                e,
                t.h || { k: 0 },
                0,
                0.01,
                this
              )),
              (this.a = PropertyFactory.getProp(
                e,
                t.a || { k: 0 },
                0,
                degToRads,
                this
              )),
              (this.g = new GradientProperty(e, t.g, this)),
              (this.style = r),
              (this.stops = []),
              this.setGradientData(r.pElem, t),
              this.setGradientOpacity(t, r),
              (this._isAnimated = !!this._isAnimated);
          }),
          (SVGGradientFillStyleData.prototype.setGradientData = function (
            e,
            t
          ) {
            var r = createElementID(),
              n = createNS(t.t === 1 ? "linearGradient" : "radialGradient");
            n.setAttribute("id", r),
              n.setAttribute("spreadMethod", "pad"),
              n.setAttribute("gradientUnits", "userSpaceOnUse");
            var i,
              a,
              o,
              s = [];
            for (o = 4 * t.g.p, a = 0; a < o; a += 4)
              (i = createNS("stop")), n.appendChild(i), s.push(i);
            e.setAttribute(
              t.ty === "gf" ? "fill" : "stroke",
              "url(" + getLocationHref() + "#" + r + ")"
            ),
              (this.gf = n),
              (this.cst = s);
          }),
          (SVGGradientFillStyleData.prototype.setGradientOpacity = function (
            e,
            t
          ) {
            if (this.g._hasOpacity && !this.g._collapsable) {
              var r,
                n,
                i,
                a = createNS("mask"),
                o = createNS("path");
              a.appendChild(o);
              var s = createElementID(),
                l = createElementID();
              a.setAttribute("id", l);
              var f = createNS(e.t === 1 ? "linearGradient" : "radialGradient");
              f.setAttribute("id", s),
                f.setAttribute("spreadMethod", "pad"),
                f.setAttribute("gradientUnits", "userSpaceOnUse"),
                (i = e.g.k.k[0].s ? e.g.k.k[0].s.length : e.g.k.k.length);
              var u = this.stops;
              for (n = 4 * e.g.p; n < i; n += 2)
                (r = createNS("stop")).setAttribute(
                  "stop-color",
                  "rgb(255,255,255)"
                ),
                  f.appendChild(r),
                  u.push(r);
              o.setAttribute(
                e.ty === "gf" ? "fill" : "stroke",
                "url(" + getLocationHref() + "#" + s + ")"
              ),
                e.ty === "gs" &&
                  (o.setAttribute("stroke-linecap", lineCapEnum[e.lc || 2]),
                  o.setAttribute("stroke-linejoin", lineJoinEnum[e.lj || 2]),
                  e.lj === 1 && o.setAttribute("stroke-miterlimit", e.ml)),
                (this.of = f),
                (this.ms = a),
                (this.ost = u),
                (this.maskId = l),
                (t.msElem = o);
            }
          }),
          extendPrototype([DynamicPropertyContainer], SVGGradientFillStyleData),
          extendPrototype(
            [SVGGradientFillStyleData, DynamicPropertyContainer],
            SVGGradientStrokeStyleData
          );
        var buildShapeString = function (e, t, r, n) {
            if (t === 0) return "";
            var i,
              a = e.o,
              o = e.i,
              s = e.v,
              l = " M" + n.applyToPointStringified(s[0][0], s[0][1]);
            for (i = 1; i < t; i += 1)
              l +=
                " C" +
                n.applyToPointStringified(a[i - 1][0], a[i - 1][1]) +
                " " +
                n.applyToPointStringified(o[i][0], o[i][1]) +
                " " +
                n.applyToPointStringified(s[i][0], s[i][1]);
            return (
              r &&
                t &&
                ((l +=
                  " C" +
                  n.applyToPointStringified(a[i - 1][0], a[i - 1][1]) +
                  " " +
                  n.applyToPointStringified(o[0][0], o[0][1]) +
                  " " +
                  n.applyToPointStringified(s[0][0], s[0][1])),
                (l += "z")),
              l
            );
          },
          SVGElementsRenderer = (function () {
            var e = new Matrix(),
              t = new Matrix();
            function r(f, u, h) {
              (h || u.transform.op._mdf) &&
                u.transform.container.setAttribute("opacity", u.transform.op.v),
                (h || u.transform.mProps._mdf) &&
                  u.transform.container.setAttribute(
                    "transform",
                    u.transform.mProps.v.to2dCSS()
                  );
            }
            function n() {}
            function i(f, u, h) {
              var m,
                d,
                p,
                g,
                c,
                v,
                y,
                b,
                x,
                S,
                T = u.styles.length,
                I = u.lvl;
              for (v = 0; v < T; v += 1) {
                if (((g = u.sh._mdf || h), u.styles[v].lvl < I)) {
                  for (
                    b = t.reset(),
                      x = I - u.styles[v].lvl,
                      S = u.transformers.length - 1;
                    !g && x > 0;

                  )
                    (g = u.transformers[S].mProps._mdf || g),
                      (x -= 1),
                      (S -= 1);
                  if (g)
                    for (
                      x = I - u.styles[v].lvl, S = u.transformers.length - 1;
                      x > 0;

                    )
                      b.multiply(u.transformers[S].mProps.v),
                        (x -= 1),
                        (S -= 1);
                } else b = e;
                if (((d = (y = u.sh.paths)._length), g)) {
                  for (p = "", m = 0; m < d; m += 1)
                    (c = y.shapes[m]) &&
                      c._length &&
                      (p += buildShapeString(c, c._length, c.c, b));
                  u.caches[v] = p;
                } else p = u.caches[v];
                (u.styles[v].d += f.hd === !0 ? "" : p),
                  (u.styles[v]._mdf = g || u.styles[v]._mdf);
              }
            }
            function a(f, u, h) {
              var m = u.style;
              (u.c._mdf || h) &&
                m.pElem.setAttribute(
                  "fill",
                  "rgb(" +
                    bmFloor(u.c.v[0]) +
                    "," +
                    bmFloor(u.c.v[1]) +
                    "," +
                    bmFloor(u.c.v[2]) +
                    ")"
                ),
                (u.o._mdf || h) && m.pElem.setAttribute("fill-opacity", u.o.v);
            }
            function o(f, u, h) {
              s(f, u, h), l(f, u, h);
            }
            function s(f, u, h) {
              var m,
                d,
                p,
                g,
                c,
                v = u.gf,
                y = u.g._hasOpacity,
                b = u.s.v,
                x = u.e.v;
              if (u.o._mdf || h) {
                var S = f.ty === "gf" ? "fill-opacity" : "stroke-opacity";
                u.style.pElem.setAttribute(S, u.o.v);
              }
              if (u.s._mdf || h) {
                var T = f.t === 1 ? "x1" : "cx",
                  I = T === "x1" ? "y1" : "cy";
                v.setAttribute(T, b[0]),
                  v.setAttribute(I, b[1]),
                  y &&
                    !u.g._collapsable &&
                    (u.of.setAttribute(T, b[0]), u.of.setAttribute(I, b[1]));
              }
              if (u.g._cmdf || h) {
                m = u.cst;
                var P = u.g.c;
                for (p = m.length, d = 0; d < p; d += 1)
                  (g = m[d]).setAttribute("offset", P[4 * d] + "%"),
                    g.setAttribute(
                      "stop-color",
                      "rgb(" +
                        P[4 * d + 1] +
                        "," +
                        P[4 * d + 2] +
                        "," +
                        P[4 * d + 3] +
                        ")"
                    );
              }
              if (y && (u.g._omdf || h)) {
                var L = u.g.o;
                for (
                  p = (m = u.g._collapsable ? u.cst : u.ost).length, d = 0;
                  d < p;
                  d += 1
                )
                  (g = m[d]),
                    u.g._collapsable ||
                      g.setAttribute("offset", L[2 * d] + "%"),
                    g.setAttribute("stop-opacity", L[2 * d + 1]);
              }
              if (f.t === 1)
                (u.e._mdf || h) &&
                  (v.setAttribute("x2", x[0]),
                  v.setAttribute("y2", x[1]),
                  y &&
                    !u.g._collapsable &&
                    (u.of.setAttribute("x2", x[0]),
                    u.of.setAttribute("y2", x[1])));
              else if (
                ((u.s._mdf || u.e._mdf || h) &&
                  ((c = Math.sqrt(
                    Math.pow(b[0] - x[0], 2) + Math.pow(b[1] - x[1], 2)
                  )),
                  v.setAttribute("r", c),
                  y && !u.g._collapsable && u.of.setAttribute("r", c)),
                u.e._mdf || u.h._mdf || u.a._mdf || h)
              ) {
                c ||
                  (c = Math.sqrt(
                    Math.pow(b[0] - x[0], 2) + Math.pow(b[1] - x[1], 2)
                  ));
                var M = Math.atan2(x[1] - b[1], x[0] - b[0]),
                  _ = u.h.v;
                _ >= 1 ? (_ = 0.99) : _ <= -1 && (_ = -0.99);
                var F = c * _,
                  w = Math.cos(M + u.a.v) * F + b[0],
                  R = Math.sin(M + u.a.v) * F + b[1];
                v.setAttribute("fx", w),
                  v.setAttribute("fy", R),
                  y &&
                    !u.g._collapsable &&
                    (u.of.setAttribute("fx", w), u.of.setAttribute("fy", R));
              }
            }
            function l(f, u, h) {
              var m = u.style,
                d = u.d;
              d &&
                (d._mdf || h) &&
                d.dashStr &&
                (m.pElem.setAttribute("stroke-dasharray", d.dashStr),
                m.pElem.setAttribute("stroke-dashoffset", d.dashoffset[0])),
                u.c &&
                  (u.c._mdf || h) &&
                  m.pElem.setAttribute(
                    "stroke",
                    "rgb(" +
                      bmFloor(u.c.v[0]) +
                      "," +
                      bmFloor(u.c.v[1]) +
                      "," +
                      bmFloor(u.c.v[2]) +
                      ")"
                  ),
                (u.o._mdf || h) &&
                  m.pElem.setAttribute("stroke-opacity", u.o.v),
                (u.w._mdf || h) &&
                  (m.pElem.setAttribute("stroke-width", u.w.v),
                  m.msElem && m.msElem.setAttribute("stroke-width", u.w.v));
            }
            return {
              createRenderFunction: function (f) {
                switch (f.ty) {
                  case "fl":
                    return a;
                  case "gf":
                    return s;
                  case "gs":
                    return o;
                  case "st":
                    return l;
                  case "sh":
                  case "el":
                  case "rc":
                  case "sr":
                    return i;
                  case "tr":
                    return r;
                  case "no":
                    return n;
                  default:
                    return null;
                }
              },
            };
          })();
        function SVGShapeElement(e, t, r) {
          (this.shapes = []),
            (this.shapesData = e.shapes),
            (this.stylesList = []),
            (this.shapeModifiers = []),
            (this.itemsData = []),
            (this.processedElements = []),
            (this.animatedContents = []),
            this.initElement(e, t, r),
            (this.prevViewData = []);
        }
        function LetterProps(e, t, r, n, i, a) {
          (this.o = e),
            (this.sw = t),
            (this.sc = r),
            (this.fc = n),
            (this.m = i),
            (this.p = a),
            (this._mdf = { o: !0, sw: !!t, sc: !!r, fc: !!n, m: !0, p: !0 });
        }
        function TextProperty(e, t) {
          (this._frameId = initialDefaultFrame),
            (this.pv = ""),
            (this.v = ""),
            (this.kf = !1),
            (this._isFirstFrame = !0),
            (this._mdf = !1),
            t.d && t.d.sid && (t.d = e.globalData.slotManager.getProp(t.d)),
            (this.data = t),
            (this.elem = e),
            (this.comp = this.elem.comp),
            (this.keysIndex = 0),
            (this.canResize = !1),
            (this.minimumFontSize = 1),
            (this.effectsSequence = []),
            (this.currentData = {
              ascent: 0,
              boxWidth: this.defaultBoxWidth,
              f: "",
              fStyle: "",
              fWeight: "",
              fc: "",
              j: "",
              justifyOffset: "",
              l: [],
              lh: 0,
              lineWidths: [],
              ls: "",
              of: "",
              s: "",
              sc: "",
              sw: 0,
              t: 0,
              tr: 0,
              sz: 0,
              ps: null,
              fillColorAnim: !1,
              strokeColorAnim: !1,
              strokeWidthAnim: !1,
              yOffset: 0,
              finalSize: 0,
              finalText: [],
              finalLineHeight: 0,
              __complete: !1,
            }),
            this.copyData(this.currentData, this.data.d.k[0].s),
            this.searchProperty() || this.completeTextData(this.currentData);
        }
        extendPrototype(
          [
            BaseElement,
            TransformElement,
            SVGBaseElement,
            IShapeElement,
            HierarchyElement,
            FrameElement,
            RenderableDOMElement,
          ],
          SVGShapeElement
        ),
          (SVGShapeElement.prototype.initSecondaryElement = function () {}),
          (SVGShapeElement.prototype.identityMatrix = new Matrix()),
          (SVGShapeElement.prototype.buildExpressionInterface = function () {}),
          (SVGShapeElement.prototype.createContent = function () {
            this.searchShapes(
              this.shapesData,
              this.itemsData,
              this.prevViewData,
              this.layerElement,
              0,
              [],
              !0
            ),
              this.filterUniqueShapes();
          }),
          (SVGShapeElement.prototype.filterUniqueShapes = function () {
            var e,
              t,
              r,
              n,
              i = this.shapes.length,
              a = this.stylesList.length,
              o = [],
              s = !1;
            for (r = 0; r < a; r += 1) {
              for (
                n = this.stylesList[r], s = !1, o.length = 0, e = 0;
                e < i;
                e += 1
              )
                (t = this.shapes[e]).styles.indexOf(n) !== -1 &&
                  (o.push(t), (s = t._isAnimated || s));
              o.length > 1 && s && this.setShapesAsAnimated(o);
            }
          }),
          (SVGShapeElement.prototype.setShapesAsAnimated = function (e) {
            var t,
              r = e.length;
            for (t = 0; t < r; t += 1) e[t].setAsAnimated();
          }),
          (SVGShapeElement.prototype.createStyleElement = function (e, t) {
            var r,
              n = new SVGStyleData(e, t),
              i = n.pElem;
            return (
              e.ty === "st"
                ? (r = new SVGStrokeStyleData(this, e, n))
                : e.ty === "fl"
                ? (r = new SVGFillStyleData(this, e, n))
                : e.ty === "gf" || e.ty === "gs"
                ? ((r = new (
                    e.ty === "gf"
                      ? SVGGradientFillStyleData
                      : SVGGradientStrokeStyleData
                  )(this, e, n)),
                  this.globalData.defs.appendChild(r.gf),
                  r.maskId &&
                    (this.globalData.defs.appendChild(r.ms),
                    this.globalData.defs.appendChild(r.of),
                    i.setAttribute(
                      "mask",
                      "url(" + getLocationHref() + "#" + r.maskId + ")"
                    )))
                : e.ty === "no" && (r = new SVGNoStyleData(this, e, n)),
              (e.ty !== "st" && e.ty !== "gs") ||
                (i.setAttribute("stroke-linecap", lineCapEnum[e.lc || 2]),
                i.setAttribute("stroke-linejoin", lineJoinEnum[e.lj || 2]),
                i.setAttribute("fill-opacity", "0"),
                e.lj === 1 && i.setAttribute("stroke-miterlimit", e.ml)),
              e.r === 2 && i.setAttribute("fill-rule", "evenodd"),
              e.ln && i.setAttribute("id", e.ln),
              e.cl && i.setAttribute("class", e.cl),
              e.bm && (i.style["mix-blend-mode"] = getBlendMode(e.bm)),
              this.stylesList.push(n),
              this.addToAnimatedContents(e, r),
              r
            );
          }),
          (SVGShapeElement.prototype.createGroupElement = function (e) {
            var t = new ShapeGroupData();
            return (
              e.ln && t.gr.setAttribute("id", e.ln),
              e.cl && t.gr.setAttribute("class", e.cl),
              e.bm && (t.gr.style["mix-blend-mode"] = getBlendMode(e.bm)),
              t
            );
          }),
          (SVGShapeElement.prototype.createTransformElement = function (e, t) {
            var r = TransformPropertyFactory.getTransformProperty(
                this,
                e,
                this
              ),
              n = new SVGTransformData(r, r.o, t);
            return this.addToAnimatedContents(e, n), n;
          }),
          (SVGShapeElement.prototype.createShapeElement = function (e, t, r) {
            var n = 4;
            e.ty === "rc"
              ? (n = 5)
              : e.ty === "el"
              ? (n = 6)
              : e.ty === "sr" && (n = 7);
            var i = new SVGShapeData(
              t,
              r,
              ShapePropertyFactory.getShapeProp(this, e, n, this)
            );
            return (
              this.shapes.push(i),
              this.addShapeToModifiers(i),
              this.addToAnimatedContents(e, i),
              i
            );
          }),
          (SVGShapeElement.prototype.addToAnimatedContents = function (e, t) {
            for (var r = 0, n = this.animatedContents.length; r < n; ) {
              if (this.animatedContents[r].element === t) return;
              r += 1;
            }
            this.animatedContents.push({
              fn: SVGElementsRenderer.createRenderFunction(e),
              element: t,
              data: e,
            });
          }),
          (SVGShapeElement.prototype.setElementStyles = function (e) {
            var t,
              r = e.styles,
              n = this.stylesList.length;
            for (t = 0; t < n; t += 1)
              this.stylesList[t].closed || r.push(this.stylesList[t]);
          }),
          (SVGShapeElement.prototype.reloadShapes = function () {
            var e;
            this._isFirstFrame = !0;
            var t = this.itemsData.length;
            for (e = 0; e < t; e += 1) this.prevViewData[e] = this.itemsData[e];
            for (
              this.searchShapes(
                this.shapesData,
                this.itemsData,
                this.prevViewData,
                this.layerElement,
                0,
                [],
                !0
              ),
                this.filterUniqueShapes(),
                t = this.dynamicProperties.length,
                e = 0;
              e < t;
              e += 1
            )
              this.dynamicProperties[e].getValue();
            this.renderModifiers();
          }),
          (SVGShapeElement.prototype.searchShapes = function (
            e,
            t,
            r,
            n,
            i,
            a,
            o
          ) {
            var s,
              l,
              f,
              u,
              h,
              m,
              d = [].concat(a),
              p = e.length - 1,
              g = [],
              c = [];
            for (s = p; s >= 0; s -= 1) {
              if (
                ((m = this.searchProcessedElement(e[s]))
                  ? (t[s] = r[m - 1])
                  : (e[s]._render = o),
                e[s].ty === "fl" ||
                  e[s].ty === "st" ||
                  e[s].ty === "gf" ||
                  e[s].ty === "gs" ||
                  e[s].ty === "no")
              )
                m
                  ? (t[s].style.closed = !1)
                  : (t[s] = this.createStyleElement(e[s], i)),
                  e[s]._render &&
                    t[s].style.pElem.parentNode !== n &&
                    n.appendChild(t[s].style.pElem),
                  g.push(t[s].style);
              else if (e[s].ty === "gr") {
                if (m)
                  for (f = t[s].it.length, l = 0; l < f; l += 1)
                    t[s].prevViewData[l] = t[s].it[l];
                else t[s] = this.createGroupElement(e[s]);
                this.searchShapes(
                  e[s].it,
                  t[s].it,
                  t[s].prevViewData,
                  t[s].gr,
                  i + 1,
                  d,
                  o
                ),
                  e[s]._render &&
                    t[s].gr.parentNode !== n &&
                    n.appendChild(t[s].gr);
              } else
                e[s].ty === "tr"
                  ? (m || (t[s] = this.createTransformElement(e[s], n)),
                    (u = t[s].transform),
                    d.push(u))
                  : e[s].ty === "sh" ||
                    e[s].ty === "rc" ||
                    e[s].ty === "el" ||
                    e[s].ty === "sr"
                  ? (m || (t[s] = this.createShapeElement(e[s], d, i)),
                    this.setElementStyles(t[s]))
                  : e[s].ty === "tm" ||
                    e[s].ty === "rd" ||
                    e[s].ty === "ms" ||
                    e[s].ty === "pb" ||
                    e[s].ty === "zz" ||
                    e[s].ty === "op"
                  ? (m
                      ? ((h = t[s]).closed = !1)
                      : ((h = ShapeModifiers.getModifier(e[s].ty)).init(
                          this,
                          e[s]
                        ),
                        (t[s] = h),
                        this.shapeModifiers.push(h)),
                    c.push(h))
                  : e[s].ty === "rp" &&
                    (m
                      ? ((h = t[s]).closed = !0)
                      : ((h = ShapeModifiers.getModifier(e[s].ty)),
                        (t[s] = h),
                        h.init(this, e, s, t),
                        this.shapeModifiers.push(h),
                        (o = !1)),
                    c.push(h));
              this.addProcessedElement(e[s], s + 1);
            }
            for (p = g.length, s = 0; s < p; s += 1) g[s].closed = !0;
            for (p = c.length, s = 0; s < p; s += 1) c[s].closed = !0;
          }),
          (SVGShapeElement.prototype.renderInnerContent = function () {
            var e;
            this.renderModifiers();
            var t = this.stylesList.length;
            for (e = 0; e < t; e += 1) this.stylesList[e].reset();
            for (this.renderShape(), e = 0; e < t; e += 1)
              (this.stylesList[e]._mdf || this._isFirstFrame) &&
                (this.stylesList[e].msElem &&
                  (this.stylesList[e].msElem.setAttribute(
                    "d",
                    this.stylesList[e].d
                  ),
                  (this.stylesList[e].d = "M0 0" + this.stylesList[e].d)),
                this.stylesList[e].pElem.setAttribute(
                  "d",
                  this.stylesList[e].d || "M0 0"
                ));
          }),
          (SVGShapeElement.prototype.renderShape = function () {
            var e,
              t,
              r = this.animatedContents.length;
            for (e = 0; e < r; e += 1)
              (t = this.animatedContents[e]),
                (this._isFirstFrame || t.element._isAnimated) &&
                  t.data !== !0 &&
                  t.fn(t.data, t.element, this._isFirstFrame);
          }),
          (SVGShapeElement.prototype.destroy = function () {
            this.destroyBaseElement(),
              (this.shapesData = null),
              (this.itemsData = null);
          }),
          (LetterProps.prototype.update = function (e, t, r, n, i, a) {
            (this._mdf.o = !1),
              (this._mdf.sw = !1),
              (this._mdf.sc = !1),
              (this._mdf.fc = !1),
              (this._mdf.m = !1),
              (this._mdf.p = !1);
            var o = !1;
            return (
              this.o !== e && ((this.o = e), (this._mdf.o = !0), (o = !0)),
              this.sw !== t && ((this.sw = t), (this._mdf.sw = !0), (o = !0)),
              this.sc !== r && ((this.sc = r), (this._mdf.sc = !0), (o = !0)),
              this.fc !== n && ((this.fc = n), (this._mdf.fc = !0), (o = !0)),
              this.m !== i && ((this.m = i), (this._mdf.m = !0), (o = !0)),
              !a.length ||
                (this.p[0] === a[0] &&
                  this.p[1] === a[1] &&
                  this.p[4] === a[4] &&
                  this.p[5] === a[5] &&
                  this.p[12] === a[12] &&
                  this.p[13] === a[13]) ||
                ((this.p = a), (this._mdf.p = !0), (o = !0)),
              o
            );
          }),
          (TextProperty.prototype.defaultBoxWidth = [0, 0]),
          (TextProperty.prototype.copyData = function (e, t) {
            for (var r in t)
              Object.prototype.hasOwnProperty.call(t, r) && (e[r] = t[r]);
            return e;
          }),
          (TextProperty.prototype.setCurrentData = function (e) {
            e.__complete || this.completeTextData(e),
              (this.currentData = e),
              (this.currentData.boxWidth =
                this.currentData.boxWidth || this.defaultBoxWidth),
              (this._mdf = !0);
          }),
          (TextProperty.prototype.searchProperty = function () {
            return this.searchKeyframes();
          }),
          (TextProperty.prototype.searchKeyframes = function () {
            return (
              (this.kf = this.data.d.k.length > 1),
              this.kf && this.addEffect(this.getKeyframeValue.bind(this)),
              this.kf
            );
          }),
          (TextProperty.prototype.addEffect = function (e) {
            this.effectsSequence.push(e), this.elem.addDynamicProperty(this);
          }),
          (TextProperty.prototype.getValue = function (e) {
            if (
              (this.elem.globalData.frameId !== this.frameId &&
                this.effectsSequence.length) ||
              e
            ) {
              this.currentData.t = this.data.d.k[this.keysIndex].s.t;
              var t = this.currentData,
                r = this.keysIndex;
              if (this.lock) this.setCurrentData(this.currentData);
              else {
                var n;
                (this.lock = !0), (this._mdf = !1);
                var i = this.effectsSequence.length,
                  a = e || this.data.d.k[this.keysIndex].s;
                for (n = 0; n < i; n += 1)
                  a =
                    r !== this.keysIndex
                      ? this.effectsSequence[n](a, a.t)
                      : this.effectsSequence[n](this.currentData, a.t);
                t !== a && this.setCurrentData(a),
                  (this.v = this.currentData),
                  (this.pv = this.v),
                  (this.lock = !1),
                  (this.frameId = this.elem.globalData.frameId);
              }
            }
          }),
          (TextProperty.prototype.getKeyframeValue = function () {
            for (
              var e = this.data.d.k,
                t = this.elem.comp.renderedFrame,
                r = 0,
                n = e.length;
              r <= n - 1 && !(r === n - 1 || e[r + 1].t > t);

            )
              r += 1;
            return (
              this.keysIndex !== r && (this.keysIndex = r),
              this.data.d.k[this.keysIndex].s
            );
          }),
          (TextProperty.prototype.buildFinalText = function (e) {
            for (
              var t, r, n = [], i = 0, a = e.length, o = !1, s = !1, l = "";
              i < a;

            )
              (o = s),
                (s = !1),
                (t = e.charCodeAt(i)),
                (l = e.charAt(i)),
                FontManager.isCombinedCharacter(t)
                  ? (o = !0)
                  : t >= 55296 && t <= 56319
                  ? FontManager.isRegionalFlag(e, i)
                    ? (l = e.substr(i, 14))
                    : (r = e.charCodeAt(i + 1)) >= 56320 &&
                      r <= 57343 &&
                      (FontManager.isModifier(t, r)
                        ? ((l = e.substr(i, 2)), (o = !0))
                        : (l = FontManager.isFlagEmoji(e.substr(i, 4))
                            ? e.substr(i, 4)
                            : e.substr(i, 2)))
                  : t > 56319
                  ? ((r = e.charCodeAt(i + 1)),
                    FontManager.isVariationSelector(t) && (o = !0))
                  : FontManager.isZeroWidthJoiner(t) && ((o = !0), (s = !0)),
                o ? ((n[n.length - 1] += l), (o = !1)) : n.push(l),
                (i += l.length);
            return n;
          }),
          (TextProperty.prototype.completeTextData = function (e) {
            e.__complete = !0;
            var t,
              r,
              n,
              i,
              a,
              o,
              s,
              l = this.elem.globalData.fontManager,
              f = this.data,
              u = [],
              h = 0,
              m = f.m.g,
              d = 0,
              p = 0,
              g = 0,
              c = [],
              v = 0,
              y = 0,
              b = l.getFontByName(e.f),
              x = 0,
              S = getFontProperties(b);
            (e.fWeight = S.weight),
              (e.fStyle = S.style),
              (e.finalSize = e.s),
              (e.finalText = this.buildFinalText(e.t)),
              (r = e.finalText.length),
              (e.finalLineHeight = e.lh);
            var T,
              I = (e.tr / 1e3) * e.finalSize;
            if (e.sz)
              for (var P, L, M = !0, _ = e.sz[0], F = e.sz[1]; M; ) {
                (P = 0),
                  (v = 0),
                  (r = (L = this.buildFinalText(e.t)).length),
                  (I = (e.tr / 1e3) * e.finalSize);
                var w = -1;
                for (t = 0; t < r; t += 1)
                  (T = L[t].charCodeAt(0)),
                    (n = !1),
                    L[t] === " "
                      ? (w = t)
                      : (T !== 13 && T !== 3) ||
                        ((v = 0),
                        (n = !0),
                        (P += e.finalLineHeight || 1.2 * e.finalSize)),
                    l.chars
                      ? ((s = l.getCharData(L[t], b.fStyle, b.fFamily)),
                        (x = n ? 0 : (s.w * e.finalSize) / 100))
                      : (x = l.measureText(L[t], e.f, e.finalSize)),
                    v + x > _ && L[t] !== " "
                      ? (w === -1 ? (r += 1) : (t = w),
                        (P += e.finalLineHeight || 1.2 * e.finalSize),
                        L.splice(t, w === t ? 1 : 0, "\r"),
                        (w = -1),
                        (v = 0))
                      : ((v += x), (v += I));
                (P += (b.ascent * e.finalSize) / 100),
                  this.canResize && e.finalSize > this.minimumFontSize && F < P
                    ? ((e.finalSize -= 1),
                      (e.finalLineHeight = (e.finalSize * e.lh) / e.s))
                    : ((e.finalText = L), (r = e.finalText.length), (M = !1));
              }
            (v = -I), (x = 0);
            var R,
              k = 0;
            for (t = 0; t < r; t += 1)
              if (
                ((n = !1),
                (T = (R = e.finalText[t]).charCodeAt(0)) === 13 || T === 3
                  ? ((k = 0),
                    c.push(v),
                    (y = v > y ? v : y),
                    (v = -2 * I),
                    (i = ""),
                    (n = !0),
                    (g += 1))
                  : (i = R),
                l.chars
                  ? ((s = l.getCharData(
                      R,
                      b.fStyle,
                      l.getFontByName(e.f).fFamily
                    )),
                    (x = n ? 0 : (s.w * e.finalSize) / 100))
                  : (x = l.measureText(i, e.f, e.finalSize)),
                R === " " ? (k += x + I) : ((v += x + I + k), (k = 0)),
                u.push({
                  l: x,
                  an: x,
                  add: d,
                  n,
                  anIndexes: [],
                  val: i,
                  line: g,
                  animatorJustifyOffset: 0,
                }),
                m == 2)
              ) {
                if (((d += x), i === "" || i === " " || t === r - 1)) {
                  for ((i !== "" && i !== " ") || (d -= x); p <= t; )
                    (u[p].an = d), (u[p].ind = h), (u[p].extra = x), (p += 1);
                  (h += 1), (d = 0);
                }
              } else if (m == 3) {
                if (((d += x), i === "" || t === r - 1)) {
                  for (i === "" && (d -= x); p <= t; )
                    (u[p].an = d), (u[p].ind = h), (u[p].extra = x), (p += 1);
                  (d = 0), (h += 1);
                }
              } else (u[h].ind = h), (u[h].extra = 0), (h += 1);
            if (((e.l = u), (y = v > y ? v : y), c.push(v), e.sz))
              (e.boxWidth = e.sz[0]), (e.justifyOffset = 0);
            else
              switch (((e.boxWidth = y), e.j)) {
                case 1:
                  e.justifyOffset = -e.boxWidth;
                  break;
                case 2:
                  e.justifyOffset = -e.boxWidth / 2;
                  break;
                default:
                  e.justifyOffset = 0;
              }
            e.lineWidths = c;
            var z,
              ee,
              A,
              N,
              X = f.a;
            o = X.length;
            var ae = [];
            for (a = 0; a < o; a += 1) {
              for (
                (z = X[a]).a.sc && (e.strokeColorAnim = !0),
                  z.a.sw && (e.strokeWidthAnim = !0),
                  (z.a.fc || z.a.fh || z.a.fs || z.a.fb) &&
                    (e.fillColorAnim = !0),
                  N = 0,
                  A = z.s.b,
                  t = 0;
                t < r;
                t += 1
              )
                ((ee = u[t]).anIndexes[a] = N),
                  ((A == 1 && ee.val !== "") ||
                    (A == 2 && ee.val !== "" && ee.val !== " ") ||
                    (A == 3 && (ee.n || ee.val == " " || t == r - 1)) ||
                    (A == 4 && (ee.n || t == r - 1))) &&
                    (z.s.rn === 1 && ae.push(N), (N += 1));
              f.a[a].s.totalChars = N;
              var W,
                q = -1;
              if (z.s.rn === 1)
                for (t = 0; t < r; t += 1)
                  q != (ee = u[t]).anIndexes[a] &&
                    ((q = ee.anIndexes[a]),
                    (W = ae.splice(
                      Math.floor(Math.random() * ae.length),
                      1
                    )[0])),
                    (ee.anIndexes[a] = W);
            }
            (e.yOffset = e.finalLineHeight || 1.2 * e.finalSize),
              (e.ls = e.ls || 0),
              (e.ascent = (b.ascent * e.finalSize) / 100);
          }),
          (TextProperty.prototype.updateDocumentData = function (e, t) {
            t = t === void 0 ? this.keysIndex : t;
            var r = this.copyData({}, this.data.d.k[t].s);
            (r = this.copyData(r, e)),
              (this.data.d.k[t].s = r),
              this.recalculate(t),
              this.setCurrentData(r),
              this.elem.addDynamicProperty(this);
          }),
          (TextProperty.prototype.recalculate = function (e) {
            var t = this.data.d.k[e].s;
            (t.__complete = !1),
              (this.keysIndex = 0),
              (this._isFirstFrame = !0),
              this.getValue(t);
          }),
          (TextProperty.prototype.canResizeFont = function (e) {
            (this.canResize = e),
              this.recalculate(this.keysIndex),
              this.elem.addDynamicProperty(this);
          }),
          (TextProperty.prototype.setMinimumFontSize = function (e) {
            (this.minimumFontSize = Math.floor(e) || 1),
              this.recalculate(this.keysIndex),
              this.elem.addDynamicProperty(this);
          });
        var TextSelectorProp = (function () {
          var e = Math.max,
            t = Math.min,
            r = Math.floor;
          function n(i, a) {
            (this._currentTextLength = -1),
              (this.k = !1),
              (this.data = a),
              (this.elem = i),
              (this.comp = i.comp),
              (this.finalS = 0),
              (this.finalE = 0),
              this.initDynamicPropertyContainer(i),
              (this.s = PropertyFactory.getProp(
                i,
                a.s || { k: 0 },
                0,
                0,
                this
              )),
              (this.e =
                "e" in a
                  ? PropertyFactory.getProp(i, a.e, 0, 0, this)
                  : { v: 100 }),
              (this.o = PropertyFactory.getProp(
                i,
                a.o || { k: 0 },
                0,
                0,
                this
              )),
              (this.xe = PropertyFactory.getProp(
                i,
                a.xe || { k: 0 },
                0,
                0,
                this
              )),
              (this.ne = PropertyFactory.getProp(
                i,
                a.ne || { k: 0 },
                0,
                0,
                this
              )),
              (this.sm = PropertyFactory.getProp(
                i,
                a.sm || { k: 100 },
                0,
                0,
                this
              )),
              (this.a = PropertyFactory.getProp(i, a.a, 0, 0.01, this)),
              this.dynamicProperties.length || this.getValue();
          }
          return (
            (n.prototype = {
              getMult: function (i) {
                this._currentTextLength !==
                  this.elem.textProperty.currentData.l.length &&
                  this.getValue();
                var a = 0,
                  o = 0,
                  s = 1,
                  l = 1;
                this.ne.v > 0 ? (a = this.ne.v / 100) : (o = -this.ne.v / 100),
                  this.xe.v > 0
                    ? (s = 1 - this.xe.v / 100)
                    : (l = 1 + this.xe.v / 100);
                var f = BezierFactory.getBezierEasing(a, o, s, l).get,
                  u = 0,
                  h = this.finalS,
                  m = this.finalE,
                  d = this.data.sh;
                if (d === 2)
                  u = f(
                    (u =
                      m === h
                        ? i >= m
                          ? 1
                          : 0
                        : e(0, t(0.5 / (m - h) + (i - h) / (m - h), 1)))
                  );
                else if (d === 3)
                  u = f(
                    (u =
                      m === h
                        ? i >= m
                          ? 0
                          : 1
                        : 1 - e(0, t(0.5 / (m - h) + (i - h) / (m - h), 1)))
                  );
                else if (d === 4)
                  m === h
                    ? (u = 0)
                    : (u = e(0, t(0.5 / (m - h) + (i - h) / (m - h), 1))) < 0.5
                    ? (u *= 2)
                    : (u = 1 - 2 * (u - 0.5)),
                    (u = f(u));
                else if (d === 5) {
                  if (m === h) u = 0;
                  else {
                    var p = m - h,
                      g = -p / 2 + (i = t(e(0, i + 0.5 - h), m - h)),
                      c = p / 2;
                    u = Math.sqrt(1 - (g * g) / (c * c));
                  }
                  u = f(u);
                } else
                  d === 6
                    ? (m === h
                        ? (u = 0)
                        : ((i = t(e(0, i + 0.5 - h), m - h)),
                          (u =
                            (1 +
                              Math.cos(Math.PI + (2 * Math.PI * i) / (m - h))) /
                            2)),
                      (u = f(u)))
                    : (i >= r(h) &&
                        (u = e(0, t(i - h < 0 ? t(m, 1) - (h - i) : m - i, 1))),
                      (u = f(u)));
                if (this.sm.v !== 100) {
                  var v = 0.01 * this.sm.v;
                  v === 0 && (v = 1e-8);
                  var y = 0.5 - 0.5 * v;
                  u < y ? (u = 0) : (u = (u - y) / v) > 1 && (u = 1);
                }
                return u * this.a.v;
              },
              getValue: function (i) {
                this.iterateDynamicProperties(),
                  (this._mdf = i || this._mdf),
                  (this._currentTextLength =
                    this.elem.textProperty.currentData.l.length || 0),
                  i &&
                    this.data.r === 2 &&
                    (this.e.v = this._currentTextLength);
                var a = this.data.r === 2 ? 1 : 100 / this.data.totalChars,
                  o = this.o.v / a,
                  s = this.s.v / a + o,
                  l = this.e.v / a + o;
                if (s > l) {
                  var f = s;
                  (s = l), (l = f);
                }
                (this.finalS = s), (this.finalE = l);
              },
            }),
            extendPrototype([DynamicPropertyContainer], n),
            {
              getTextSelectorProp: function (i, a, o) {
                return new n(i, a, o);
              },
            }
          );
        })();
        function TextAnimatorDataProperty(e, t, r) {
          var n = { propType: !1 },
            i = PropertyFactory.getProp,
            a = t.a;
          (this.a = {
            r: a.r ? i(e, a.r, 0, degToRads, r) : n,
            rx: a.rx ? i(e, a.rx, 0, degToRads, r) : n,
            ry: a.ry ? i(e, a.ry, 0, degToRads, r) : n,
            sk: a.sk ? i(e, a.sk, 0, degToRads, r) : n,
            sa: a.sa ? i(e, a.sa, 0, degToRads, r) : n,
            s: a.s ? i(e, a.s, 1, 0.01, r) : n,
            a: a.a ? i(e, a.a, 1, 0, r) : n,
            o: a.o ? i(e, a.o, 0, 0.01, r) : n,
            p: a.p ? i(e, a.p, 1, 0, r) : n,
            sw: a.sw ? i(e, a.sw, 0, 0, r) : n,
            sc: a.sc ? i(e, a.sc, 1, 0, r) : n,
            fc: a.fc ? i(e, a.fc, 1, 0, r) : n,
            fh: a.fh ? i(e, a.fh, 0, 0, r) : n,
            fs: a.fs ? i(e, a.fs, 0, 0.01, r) : n,
            fb: a.fb ? i(e, a.fb, 0, 0.01, r) : n,
            t: a.t ? i(e, a.t, 0, 0, r) : n,
          }),
            (this.s = TextSelectorProp.getTextSelectorProp(e, t.s, r)),
            (this.s.t = t.s.t);
        }
        function TextAnimatorProperty(e, t, r) {
          (this._isFirstFrame = !0),
            (this._hasMaskedPath = !1),
            (this._frameId = -1),
            (this._textData = e),
            (this._renderType = t),
            (this._elem = r),
            (this._animatorsData = createSizedArray(this._textData.a.length)),
            (this._pathData = {}),
            (this._moreOptions = { alignment: {} }),
            (this.renderedLetters = []),
            (this.lettersChangedFlag = !1),
            this.initDynamicPropertyContainer(r);
        }
        function ITextElement() {}
        (TextAnimatorProperty.prototype.searchProperties = function () {
          var e,
            t,
            r = this._textData.a.length,
            n = PropertyFactory.getProp;
          for (e = 0; e < r; e += 1)
            (t = this._textData.a[e]),
              (this._animatorsData[e] = new TextAnimatorDataProperty(
                this._elem,
                t,
                this
              ));
          this._textData.p && "m" in this._textData.p
            ? ((this._pathData = {
                a: n(this._elem, this._textData.p.a, 0, 0, this),
                f: n(this._elem, this._textData.p.f, 0, 0, this),
                l: n(this._elem, this._textData.p.l, 0, 0, this),
                r: n(this._elem, this._textData.p.r, 0, 0, this),
                p: n(this._elem, this._textData.p.p, 0, 0, this),
                m: this._elem.maskManager.getMaskProperty(this._textData.p.m),
              }),
              (this._hasMaskedPath = !0))
            : (this._hasMaskedPath = !1),
            (this._moreOptions.alignment = n(
              this._elem,
              this._textData.m.a,
              1,
              0,
              this
            ));
        }),
          (TextAnimatorProperty.prototype.getMeasures = function (e, t) {
            if (
              ((this.lettersChangedFlag = t),
              this._mdf ||
                this._isFirstFrame ||
                t ||
                (this._hasMaskedPath && this._pathData.m._mdf))
            ) {
              this._isFirstFrame = !1;
              var r,
                n,
                i,
                a,
                o,
                s,
                l,
                f,
                u,
                h,
                m,
                d,
                p,
                g,
                c,
                v,
                y,
                b,
                x,
                S = this._moreOptions.alignment.v,
                T = this._animatorsData,
                I = this._textData,
                P = this.mHelper,
                L = this._renderType,
                M = this.renderedLetters.length,
                _ = e.l;
              if (this._hasMaskedPath) {
                if (
                  ((x = this._pathData.m),
                  !this._pathData.n || this._pathData._mdf)
                ) {
                  var F,
                    w = x.v;
                  for (
                    this._pathData.r.v && (w = w.reverse()),
                      o = { tLength: 0, segments: [] },
                      a = w._length - 1,
                      v = 0,
                      i = 0;
                    i < a;
                    i += 1
                  )
                    (F = bez.buildBezierData(
                      w.v[i],
                      w.v[i + 1],
                      [w.o[i][0] - w.v[i][0], w.o[i][1] - w.v[i][1]],
                      [
                        w.i[i + 1][0] - w.v[i + 1][0],
                        w.i[i + 1][1] - w.v[i + 1][1],
                      ]
                    )),
                      (o.tLength += F.segmentLength),
                      o.segments.push(F),
                      (v += F.segmentLength);
                  (i = a),
                    x.v.c &&
                      ((F = bez.buildBezierData(
                        w.v[i],
                        w.v[0],
                        [w.o[i][0] - w.v[i][0], w.o[i][1] - w.v[i][1]],
                        [w.i[0][0] - w.v[0][0], w.i[0][1] - w.v[0][1]]
                      )),
                      (o.tLength += F.segmentLength),
                      o.segments.push(F),
                      (v += F.segmentLength)),
                    (this._pathData.pi = o);
                }
                if (
                  ((o = this._pathData.pi),
                  (s = this._pathData.f.v),
                  (m = 0),
                  (h = 1),
                  (f = 0),
                  (u = !0),
                  (g = o.segments),
                  s < 0 && x.v.c)
                )
                  for (
                    o.tLength < Math.abs(s) && (s = -Math.abs(s) % o.tLength),
                      h = (p = g[(m = g.length - 1)].points).length - 1;
                    s < 0;

                  )
                    (s += p[h].partialLength),
                      (h -= 1) < 0 && (h = (p = g[(m -= 1)].points).length - 1);
                (d = (p = g[m].points)[h - 1]), (c = (l = p[h]).partialLength);
              }
              (a = _.length), (r = 0), (n = 0);
              var R,
                k,
                z,
                ee,
                A,
                N = 1.2 * e.finalSize * 0.714,
                X = !0;
              z = T.length;
              var ae,
                W,
                q,
                O,
                H,
                j,
                V,
                Z,
                ie,
                te,
                D,
                J,
                ne = -1,
                Y = s,
                de = m,
                Oe = h,
                Ie = -1,
                C = "",
                B = this.defaultPropsArray;
              if (e.j === 2 || e.j === 1) {
                var G = 0,
                  U = 0,
                  Q = e.j === 2 ? -0.5 : -1,
                  K = 0,
                  se = !0;
                for (i = 0; i < a; i += 1)
                  if (_[i].n) {
                    for (G && (G += U); K < i; )
                      (_[K].animatorJustifyOffset = G), (K += 1);
                    (G = 0), (se = !0);
                  } else {
                    for (k = 0; k < z; k += 1)
                      (R = T[k].a).t.propType &&
                        (se && e.j === 2 && (U += R.t.v * Q),
                        (A = T[k].s.getMult(
                          _[i].anIndexes[k],
                          I.a[k].s.totalChars
                        )).length
                          ? (G += R.t.v * A[0] * Q)
                          : (G += R.t.v * A * Q));
                    se = !1;
                  }
                for (G && (G += U); K < i; )
                  (_[K].animatorJustifyOffset = G), (K += 1);
              }
              for (i = 0; i < a; i += 1) {
                if ((P.reset(), (O = 1), _[i].n))
                  (r = 0),
                    (n += e.yOffset),
                    (n += X ? 1 : 0),
                    (s = Y),
                    (X = !1),
                    this._hasMaskedPath &&
                      ((h = Oe),
                      (d = (p = g[(m = de)].points)[h - 1]),
                      (c = (l = p[h]).partialLength),
                      (f = 0)),
                    (C = ""),
                    (D = ""),
                    (ie = ""),
                    (J = ""),
                    (B = this.defaultPropsArray);
                else {
                  if (this._hasMaskedPath) {
                    if (Ie !== _[i].line) {
                      switch (e.j) {
                        case 1:
                          s += v - e.lineWidths[_[i].line];
                          break;
                        case 2:
                          s += (v - e.lineWidths[_[i].line]) / 2;
                      }
                      Ie = _[i].line;
                    }
                    ne !== _[i].ind &&
                      (_[ne] && (s += _[ne].extra),
                      (s += _[i].an / 2),
                      (ne = _[i].ind)),
                      (s += S[0] * _[i].an * 0.005);
                    var le = 0;
                    for (k = 0; k < z; k += 1)
                      (R = T[k].a).p.propType &&
                        ((A = T[k].s.getMult(
                          _[i].anIndexes[k],
                          I.a[k].s.totalChars
                        )).length
                          ? (le += R.p.v[0] * A[0])
                          : (le += R.p.v[0] * A)),
                        R.a.propType &&
                          ((A = T[k].s.getMult(
                            _[i].anIndexes[k],
                            I.a[k].s.totalChars
                          )).length
                            ? (le += R.a.v[0] * A[0])
                            : (le += R.a.v[0] * A));
                    for (
                      u = !0,
                        this._pathData.a.v &&
                          ((s =
                            0.5 * _[0].an +
                            ((v -
                              this._pathData.f.v -
                              0.5 * _[0].an -
                              0.5 * _[_.length - 1].an) *
                              ne) /
                              (a - 1)),
                          (s += this._pathData.f.v));
                      u;

                    )
                      f + c >= s + le || !p
                        ? ((y = (s + le - f) / l.partialLength),
                          (W = d.point[0] + (l.point[0] - d.point[0]) * y),
                          (q = d.point[1] + (l.point[1] - d.point[1]) * y),
                          P.translate(
                            -S[0] * _[i].an * 0.005,
                            -S[1] * N * 0.01
                          ),
                          (u = !1))
                        : p &&
                          ((f += l.partialLength),
                          (h += 1) >= p.length &&
                            ((h = 0),
                            g[(m += 1)]
                              ? (p = g[m].points)
                              : x.v.c
                              ? ((h = 0), (p = g[(m = 0)].points))
                              : ((f -= l.partialLength), (p = null))),
                          p && ((d = l), (c = (l = p[h]).partialLength)));
                    (ae = _[i].an / 2 - _[i].add), P.translate(-ae, 0, 0);
                  } else
                    (ae = _[i].an / 2 - _[i].add),
                      P.translate(-ae, 0, 0),
                      P.translate(-S[0] * _[i].an * 0.005, -S[1] * N * 0.01, 0);
                  for (k = 0; k < z; k += 1)
                    (R = T[k].a).t.propType &&
                      ((A = T[k].s.getMult(
                        _[i].anIndexes[k],
                        I.a[k].s.totalChars
                      )),
                      (r === 0 && e.j === 0) ||
                        (this._hasMaskedPath
                          ? A.length
                            ? (s += R.t.v * A[0])
                            : (s += R.t.v * A)
                          : A.length
                          ? (r += R.t.v * A[0])
                          : (r += R.t.v * A)));
                  for (
                    e.strokeWidthAnim && (j = e.sw || 0),
                      e.strokeColorAnim &&
                        (H = e.sc ? [e.sc[0], e.sc[1], e.sc[2]] : [0, 0, 0]),
                      e.fillColorAnim &&
                        e.fc &&
                        (V = [e.fc[0], e.fc[1], e.fc[2]]),
                      k = 0;
                    k < z;
                    k += 1
                  )
                    (R = T[k].a).a.propType &&
                      ((A = T[k].s.getMult(
                        _[i].anIndexes[k],
                        I.a[k].s.totalChars
                      )).length
                        ? P.translate(
                            -R.a.v[0] * A[0],
                            -R.a.v[1] * A[1],
                            R.a.v[2] * A[2]
                          )
                        : P.translate(
                            -R.a.v[0] * A,
                            -R.a.v[1] * A,
                            R.a.v[2] * A
                          ));
                  for (k = 0; k < z; k += 1)
                    (R = T[k].a).s.propType &&
                      ((A = T[k].s.getMult(
                        _[i].anIndexes[k],
                        I.a[k].s.totalChars
                      )).length
                        ? P.scale(
                            1 + (R.s.v[0] - 1) * A[0],
                            1 + (R.s.v[1] - 1) * A[1],
                            1
                          )
                        : P.scale(
                            1 + (R.s.v[0] - 1) * A,
                            1 + (R.s.v[1] - 1) * A,
                            1
                          ));
                  for (k = 0; k < z; k += 1) {
                    if (
                      ((R = T[k].a),
                      (A = T[k].s.getMult(
                        _[i].anIndexes[k],
                        I.a[k].s.totalChars
                      )),
                      R.sk.propType &&
                        (A.length
                          ? P.skewFromAxis(-R.sk.v * A[0], R.sa.v * A[1])
                          : P.skewFromAxis(-R.sk.v * A, R.sa.v * A)),
                      R.r.propType &&
                        (A.length
                          ? P.rotateZ(-R.r.v * A[2])
                          : P.rotateZ(-R.r.v * A)),
                      R.ry.propType &&
                        (A.length
                          ? P.rotateY(R.ry.v * A[1])
                          : P.rotateY(R.ry.v * A)),
                      R.rx.propType &&
                        (A.length
                          ? P.rotateX(R.rx.v * A[0])
                          : P.rotateX(R.rx.v * A)),
                      R.o.propType &&
                        (A.length
                          ? (O += (R.o.v * A[0] - O) * A[0])
                          : (O += (R.o.v * A - O) * A)),
                      e.strokeWidthAnim &&
                        R.sw.propType &&
                        (A.length ? (j += R.sw.v * A[0]) : (j += R.sw.v * A)),
                      e.strokeColorAnim && R.sc.propType)
                    )
                      for (Z = 0; Z < 3; Z += 1)
                        A.length
                          ? (H[Z] += (R.sc.v[Z] - H[Z]) * A[0])
                          : (H[Z] += (R.sc.v[Z] - H[Z]) * A);
                    if (e.fillColorAnim && e.fc) {
                      if (R.fc.propType)
                        for (Z = 0; Z < 3; Z += 1)
                          A.length
                            ? (V[Z] += (R.fc.v[Z] - V[Z]) * A[0])
                            : (V[Z] += (R.fc.v[Z] - V[Z]) * A);
                      R.fh.propType &&
                        (V = A.length
                          ? addHueToRGB(V, R.fh.v * A[0])
                          : addHueToRGB(V, R.fh.v * A)),
                        R.fs.propType &&
                          (V = A.length
                            ? addSaturationToRGB(V, R.fs.v * A[0])
                            : addSaturationToRGB(V, R.fs.v * A)),
                        R.fb.propType &&
                          (V = A.length
                            ? addBrightnessToRGB(V, R.fb.v * A[0])
                            : addBrightnessToRGB(V, R.fb.v * A));
                    }
                  }
                  for (k = 0; k < z; k += 1)
                    (R = T[k].a).p.propType &&
                      ((A = T[k].s.getMult(
                        _[i].anIndexes[k],
                        I.a[k].s.totalChars
                      )),
                      this._hasMaskedPath
                        ? A.length
                          ? P.translate(0, R.p.v[1] * A[0], -R.p.v[2] * A[1])
                          : P.translate(0, R.p.v[1] * A, -R.p.v[2] * A)
                        : A.length
                        ? P.translate(
                            R.p.v[0] * A[0],
                            R.p.v[1] * A[1],
                            -R.p.v[2] * A[2]
                          )
                        : P.translate(
                            R.p.v[0] * A,
                            R.p.v[1] * A,
                            -R.p.v[2] * A
                          ));
                  if (
                    (e.strokeWidthAnim && (ie = j < 0 ? 0 : j),
                    e.strokeColorAnim &&
                      (te =
                        "rgb(" +
                        Math.round(255 * H[0]) +
                        "," +
                        Math.round(255 * H[1]) +
                        "," +
                        Math.round(255 * H[2]) +
                        ")"),
                    e.fillColorAnim &&
                      e.fc &&
                      (D =
                        "rgb(" +
                        Math.round(255 * V[0]) +
                        "," +
                        Math.round(255 * V[1]) +
                        "," +
                        Math.round(255 * V[2]) +
                        ")"),
                    this._hasMaskedPath)
                  ) {
                    if (
                      (P.translate(0, -e.ls),
                      P.translate(0, S[1] * N * 0.01 + n, 0),
                      this._pathData.p.v)
                    ) {
                      b = (l.point[1] - d.point[1]) / (l.point[0] - d.point[0]);
                      var oe = (180 * Math.atan(b)) / Math.PI;
                      l.point[0] < d.point[0] && (oe += 180),
                        P.rotate((-oe * Math.PI) / 180);
                    }
                    P.translate(W, q, 0),
                      (s -= S[0] * _[i].an * 0.005),
                      _[i + 1] &&
                        ne !== _[i + 1].ind &&
                        ((s += _[i].an / 2), (s += 0.001 * e.tr * e.finalSize));
                  } else {
                    switch (
                      (P.translate(r, n, 0),
                      e.ps && P.translate(e.ps[0], e.ps[1] + e.ascent, 0),
                      e.j)
                    ) {
                      case 1:
                        P.translate(
                          _[i].animatorJustifyOffset +
                            e.justifyOffset +
                            (e.boxWidth - e.lineWidths[_[i].line]),
                          0,
                          0
                        );
                        break;
                      case 2:
                        P.translate(
                          _[i].animatorJustifyOffset +
                            e.justifyOffset +
                            (e.boxWidth - e.lineWidths[_[i].line]) / 2,
                          0,
                          0
                        );
                    }
                    P.translate(0, -e.ls),
                      P.translate(ae, 0, 0),
                      P.translate(S[0] * _[i].an * 0.005, S[1] * N * 0.01, 0),
                      (r += _[i].l + 0.001 * e.tr * e.finalSize);
                  }
                  L === "html"
                    ? (C = P.toCSS())
                    : L === "svg"
                    ? (C = P.to2dCSS())
                    : (B = [
                        P.props[0],
                        P.props[1],
                        P.props[2],
                        P.props[3],
                        P.props[4],
                        P.props[5],
                        P.props[6],
                        P.props[7],
                        P.props[8],
                        P.props[9],
                        P.props[10],
                        P.props[11],
                        P.props[12],
                        P.props[13],
                        P.props[14],
                        P.props[15],
                      ]),
                    (J = O);
                }
                M <= i
                  ? ((ee = new LetterProps(J, ie, te, D, C, B)),
                    this.renderedLetters.push(ee),
                    (M += 1),
                    (this.lettersChangedFlag = !0))
                  : ((ee = this.renderedLetters[i]),
                    (this.lettersChangedFlag =
                      ee.update(J, ie, te, D, C, B) ||
                      this.lettersChangedFlag));
              }
            }
          }),
          (TextAnimatorProperty.prototype.getValue = function () {
            this._elem.globalData.frameId !== this._frameId &&
              ((this._frameId = this._elem.globalData.frameId),
              this.iterateDynamicProperties());
          }),
          (TextAnimatorProperty.prototype.mHelper = new Matrix()),
          (TextAnimatorProperty.prototype.defaultPropsArray = []),
          extendPrototype([DynamicPropertyContainer], TextAnimatorProperty),
          (ITextElement.prototype.initElement = function (e, t, r) {
            (this.lettersChangedFlag = !0),
              this.initFrame(),
              this.initBaseData(e, t, r),
              (this.textProperty = new TextProperty(
                this,
                e.t,
                this.dynamicProperties
              )),
              (this.textAnimator = new TextAnimatorProperty(
                e.t,
                this.renderType,
                this
              )),
              this.initTransform(e, t, r),
              this.initHierarchy(),
              this.initRenderable(),
              this.initRendererElement(),
              this.createContainerElements(),
              this.createRenderableComponents(),
              this.createContent(),
              this.hide(),
              this.textAnimator.searchProperties(this.dynamicProperties);
          }),
          (ITextElement.prototype.prepareFrame = function (e) {
            (this._mdf = !1),
              this.prepareRenderableFrame(e),
              this.prepareProperties(e, this.isInRange);
          }),
          (ITextElement.prototype.createPathShape = function (e, t) {
            var r,
              n,
              i = t.length,
              a = "";
            for (r = 0; r < i; r += 1)
              t[r].ty === "sh" &&
                ((n = t[r].ks.k),
                (a += buildShapeString(n, n.i.length, !0, e)));
            return a;
          }),
          (ITextElement.prototype.updateDocumentData = function (e, t) {
            this.textProperty.updateDocumentData(e, t);
          }),
          (ITextElement.prototype.canResizeFont = function (e) {
            this.textProperty.canResizeFont(e);
          }),
          (ITextElement.prototype.setMinimumFontSize = function (e) {
            this.textProperty.setMinimumFontSize(e);
          }),
          (ITextElement.prototype.applyTextPropertiesToMatrix = function (
            e,
            t,
            r,
            n,
            i
          ) {
            switch (
              (e.ps && t.translate(e.ps[0], e.ps[1] + e.ascent, 0),
              t.translate(0, -e.ls, 0),
              e.j)
            ) {
              case 1:
                t.translate(
                  e.justifyOffset + (e.boxWidth - e.lineWidths[r]),
                  0,
                  0
                );
                break;
              case 2:
                t.translate(
                  e.justifyOffset + (e.boxWidth - e.lineWidths[r]) / 2,
                  0,
                  0
                );
            }
            t.translate(n, i, 0);
          }),
          (ITextElement.prototype.buildColor = function (e) {
            return (
              "rgb(" +
              Math.round(255 * e[0]) +
              "," +
              Math.round(255 * e[1]) +
              "," +
              Math.round(255 * e[2]) +
              ")"
            );
          }),
          (ITextElement.prototype.emptyProp = new LetterProps()),
          (ITextElement.prototype.destroy = function () {}),
          (ITextElement.prototype.validateText = function () {
            (this.textProperty._mdf || this.textProperty._isFirstFrame) &&
              (this.buildNewText(),
              (this.textProperty._isFirstFrame = !1),
              (this.textProperty._mdf = !1));
          });
        var emptyShapeData = { shapes: [] };
        function SVGTextLottieElement(e, t, r) {
          (this.textSpans = []),
            (this.renderType = "svg"),
            this.initElement(e, t, r);
        }
        function ISolidElement(e, t, r) {
          this.initElement(e, t, r);
        }
        function NullElement(e, t, r) {
          this.initFrame(),
            this.initBaseData(e, t, r),
            this.initFrame(),
            this.initTransform(e, t, r),
            this.initHierarchy();
        }
        function SVGRendererBase() {}
        function ICompElement() {}
        function SVGCompElement(e, t, r) {
          (this.layers = e.layers),
            (this.supports3d = !0),
            (this.completeLayers = !1),
            (this.pendingElements = []),
            (this.elements = this.layers
              ? createSizedArray(this.layers.length)
              : []),
            this.initElement(e, t, r),
            (this.tm = e.tm
              ? PropertyFactory.getProp(this, e.tm, 0, t.frameRate, this)
              : { _placeholder: !0 });
        }
        function SVGRenderer(e, t) {
          (this.animationItem = e),
            (this.layers = null),
            (this.renderedFrame = -1),
            (this.svgElement = createNS("svg"));
          var r = "";
          if (t && t.title) {
            var n = createNS("title"),
              i = createElementID();
            n.setAttribute("id", i),
              (n.textContent = t.title),
              this.svgElement.appendChild(n),
              (r += i);
          }
          if (t && t.description) {
            var a = createNS("desc"),
              o = createElementID();
            a.setAttribute("id", o),
              (a.textContent = t.description),
              this.svgElement.appendChild(a),
              (r += " " + o);
          }
          r && this.svgElement.setAttribute("aria-labelledby", r);
          var s = createNS("defs");
          this.svgElement.appendChild(s);
          var l = createNS("g");
          this.svgElement.appendChild(l),
            (this.layerElement = l),
            (this.renderConfig = {
              preserveAspectRatio:
                (t && t.preserveAspectRatio) || "xMidYMid meet",
              imagePreserveAspectRatio:
                (t && t.imagePreserveAspectRatio) || "xMidYMid slice",
              contentVisibility: (t && t.contentVisibility) || "visible",
              progressiveLoad: (t && t.progressiveLoad) || !1,
              hideOnTransparent: !(t && t.hideOnTransparent === !1),
              viewBoxOnly: (t && t.viewBoxOnly) || !1,
              viewBoxSize: (t && t.viewBoxSize) || !1,
              className: (t && t.className) || "",
              id: (t && t.id) || "",
              focusable: t && t.focusable,
              filterSize: {
                width: (t && t.filterSize && t.filterSize.width) || "100%",
                height: (t && t.filterSize && t.filterSize.height) || "100%",
                x: (t && t.filterSize && t.filterSize.x) || "0%",
                y: (t && t.filterSize && t.filterSize.y) || "0%",
              },
              width: t && t.width,
              height: t && t.height,
              runExpressions:
                !t || t.runExpressions === void 0 || t.runExpressions,
            }),
            (this.globalData = {
              _mdf: !1,
              frameNum: -1,
              defs: s,
              renderConfig: this.renderConfig,
            }),
            (this.elements = []),
            (this.pendingElements = []),
            (this.destroyed = !1),
            (this.rendererType = "svg");
        }
        function ShapeTransformManager() {
          (this.sequences = {}),
            (this.sequenceList = []),
            (this.transform_key_count = 0);
        }
        extendPrototype(
          [
            BaseElement,
            TransformElement,
            SVGBaseElement,
            HierarchyElement,
            FrameElement,
            RenderableDOMElement,
            ITextElement,
          ],
          SVGTextLottieElement
        ),
          (SVGTextLottieElement.prototype.createContent = function () {
            this.data.singleShape &&
              !this.globalData.fontManager.chars &&
              (this.textContainer = createNS("text"));
          }),
          (SVGTextLottieElement.prototype.buildTextContents = function (e) {
            for (var t = 0, r = e.length, n = [], i = ""; t < r; )
              e[t] === String.fromCharCode(13) ||
              e[t] === String.fromCharCode(3)
                ? (n.push(i), (i = ""))
                : (i += e[t]),
                (t += 1);
            return n.push(i), n;
          }),
          (SVGTextLottieElement.prototype.buildShapeData = function (e, t) {
            if (e.shapes && e.shapes.length) {
              var r = e.shapes[0];
              if (r.it) {
                var n = r.it[r.it.length - 1];
                n.s && ((n.s.k[0] = t), (n.s.k[1] = t));
              }
            }
            return e;
          }),
          (SVGTextLottieElement.prototype.buildNewText = function () {
            var e, t;
            this.addDynamicProperty(this);
            var r = this.textProperty.currentData;
            (this.renderedLetters = createSizedArray(r ? r.l.length : 0)),
              r.fc
                ? this.layerElement.setAttribute("fill", this.buildColor(r.fc))
                : this.layerElement.setAttribute("fill", "rgba(0,0,0,0)"),
              r.sc &&
                (this.layerElement.setAttribute(
                  "stroke",
                  this.buildColor(r.sc)
                ),
                this.layerElement.setAttribute("stroke-width", r.sw)),
              this.layerElement.setAttribute("font-size", r.finalSize);
            var n = this.globalData.fontManager.getFontByName(r.f);
            if (n.fClass) this.layerElement.setAttribute("class", n.fClass);
            else {
              this.layerElement.setAttribute("font-family", n.fFamily);
              var i = r.fWeight,
                a = r.fStyle;
              this.layerElement.setAttribute("font-style", a),
                this.layerElement.setAttribute("font-weight", i);
            }
            this.layerElement.setAttribute("aria-label", r.t);
            var o,
              s = r.l || [],
              l = !!this.globalData.fontManager.chars;
            t = s.length;
            var f = this.mHelper,
              u = this.data.singleShape,
              h = 0,
              m = 0,
              d = !0,
              p = 0.001 * r.tr * r.finalSize;
            if (!u || l || r.sz) {
              var g,
                c = this.textSpans.length;
              for (e = 0; e < t; e += 1) {
                if (
                  (this.textSpans[e] ||
                    (this.textSpans[e] = {
                      span: null,
                      childSpan: null,
                      glyph: null,
                    }),
                  !l || !u || e === 0)
                ) {
                  if (
                    ((o =
                      c > e
                        ? this.textSpans[e].span
                        : createNS(l ? "g" : "text")),
                    c <= e)
                  ) {
                    if (
                      (o.setAttribute("stroke-linecap", "butt"),
                      o.setAttribute("stroke-linejoin", "round"),
                      o.setAttribute("stroke-miterlimit", "4"),
                      (this.textSpans[e].span = o),
                      l)
                    ) {
                      var v = createNS("g");
                      o.appendChild(v), (this.textSpans[e].childSpan = v);
                    }
                    (this.textSpans[e].span = o),
                      this.layerElement.appendChild(o);
                  }
                  o.style.display = "inherit";
                }
                if (
                  (f.reset(),
                  u &&
                    (s[e].n &&
                      ((h = -p), (m += r.yOffset), (m += d ? 1 : 0), (d = !1)),
                    this.applyTextPropertiesToMatrix(r, f, s[e].line, h, m),
                    (h += s[e].l || 0),
                    (h += p)),
                  l)
                ) {
                  var y;
                  if (
                    (g = this.globalData.fontManager.getCharData(
                      r.finalText[e],
                      n.fStyle,
                      this.globalData.fontManager.getFontByName(r.f).fFamily
                    )).t === 1
                  )
                    y = new SVGCompElement(g.data, this.globalData, this);
                  else {
                    var b = emptyShapeData;
                    g.data &&
                      g.data.shapes &&
                      (b = this.buildShapeData(g.data, r.finalSize)),
                      (y = new SVGShapeElement(b, this.globalData, this));
                  }
                  if (this.textSpans[e].glyph) {
                    var x = this.textSpans[e].glyph;
                    this.textSpans[e].childSpan.removeChild(x.layerElement),
                      x.destroy();
                  }
                  (this.textSpans[e].glyph = y),
                    (y._debug = !0),
                    y.prepareFrame(0),
                    y.renderFrame(),
                    this.textSpans[e].childSpan.appendChild(y.layerElement),
                    g.t === 1 &&
                      this.textSpans[e].childSpan.setAttribute(
                        "transform",
                        "scale(" +
                          r.finalSize / 100 +
                          "," +
                          r.finalSize / 100 +
                          ")"
                      );
                } else
                  u &&
                    o.setAttribute(
                      "transform",
                      "translate(" + f.props[12] + "," + f.props[13] + ")"
                    ),
                    (o.textContent = s[e].val),
                    o.setAttributeNS(
                      "http://www.w3.org/XML/1998/namespace",
                      "xml:space",
                      "preserve"
                    );
              }
              u && o && o.setAttribute("d", "");
            } else {
              var S = this.textContainer,
                T = "start";
              switch (r.j) {
                case 1:
                  T = "end";
                  break;
                case 2:
                  T = "middle";
                  break;
                default:
                  T = "start";
              }
              S.setAttribute("text-anchor", T),
                S.setAttribute("letter-spacing", p);
              var I = this.buildTextContents(r.finalText);
              for (
                t = I.length, m = r.ps ? r.ps[1] + r.ascent : 0, e = 0;
                e < t;
                e += 1
              )
                ((o = this.textSpans[e].span || createNS("tspan")).textContent =
                  I[e]),
                  o.setAttribute("x", 0),
                  o.setAttribute("y", m),
                  (o.style.display = "inherit"),
                  S.appendChild(o),
                  this.textSpans[e] ||
                    (this.textSpans[e] = { span: null, glyph: null }),
                  (this.textSpans[e].span = o),
                  (m += r.finalLineHeight);
              this.layerElement.appendChild(S);
            }
            for (; e < this.textSpans.length; )
              (this.textSpans[e].span.style.display = "none"), (e += 1);
            this._sizeChanged = !0;
          }),
          (SVGTextLottieElement.prototype.sourceRectAtTime = function () {
            if (
              (this.prepareFrame(this.comp.renderedFrame - this.data.st),
              this.renderInnerContent(),
              this._sizeChanged)
            ) {
              this._sizeChanged = !1;
              var e = this.layerElement.getBBox();
              this.bbox = {
                top: e.y,
                left: e.x,
                width: e.width,
                height: e.height,
              };
            }
            return this.bbox;
          }),
          (SVGTextLottieElement.prototype.getValue = function () {
            var e,
              t,
              r = this.textSpans.length;
            for (
              this.renderedFrame = this.comp.renderedFrame, e = 0;
              e < r;
              e += 1
            )
              (t = this.textSpans[e].glyph) &&
                (t.prepareFrame(this.comp.renderedFrame - this.data.st),
                t._mdf && (this._mdf = !0));
          }),
          (SVGTextLottieElement.prototype.renderInnerContent = function () {
            if (
              (this.validateText(),
              (!this.data.singleShape || this._mdf) &&
                (this.textAnimator.getMeasures(
                  this.textProperty.currentData,
                  this.lettersChangedFlag
                ),
                this.lettersChangedFlag ||
                  this.textAnimator.lettersChangedFlag))
            ) {
              var e, t;
              this._sizeChanged = !0;
              var r,
                n,
                i,
                a = this.textAnimator.renderedLetters,
                o = this.textProperty.currentData.l;
              for (t = o.length, e = 0; e < t; e += 1)
                o[e].n ||
                  ((r = a[e]),
                  (n = this.textSpans[e].span),
                  (i = this.textSpans[e].glyph) && i.renderFrame(),
                  r._mdf.m && n.setAttribute("transform", r.m),
                  r._mdf.o && n.setAttribute("opacity", r.o),
                  r._mdf.sw && n.setAttribute("stroke-width", r.sw),
                  r._mdf.sc && n.setAttribute("stroke", r.sc),
                  r._mdf.fc && n.setAttribute("fill", r.fc));
            }
          }),
          extendPrototype([IImageElement], ISolidElement),
          (ISolidElement.prototype.createContent = function () {
            var e = createNS("rect");
            e.setAttribute("width", this.data.sw),
              e.setAttribute("height", this.data.sh),
              e.setAttribute("fill", this.data.sc),
              this.layerElement.appendChild(e);
          }),
          (NullElement.prototype.prepareFrame = function (e) {
            this.prepareProperties(e, !0);
          }),
          (NullElement.prototype.renderFrame = function () {}),
          (NullElement.prototype.getBaseElement = function () {
            return null;
          }),
          (NullElement.prototype.destroy = function () {}),
          (NullElement.prototype.sourceRectAtTime = function () {}),
          (NullElement.prototype.hide = function () {}),
          extendPrototype(
            [BaseElement, TransformElement, HierarchyElement, FrameElement],
            NullElement
          ),
          extendPrototype([BaseRenderer], SVGRendererBase),
          (SVGRendererBase.prototype.createNull = function (e) {
            return new NullElement(e, this.globalData, this);
          }),
          (SVGRendererBase.prototype.createShape = function (e) {
            return new SVGShapeElement(e, this.globalData, this);
          }),
          (SVGRendererBase.prototype.createText = function (e) {
            return new SVGTextLottieElement(e, this.globalData, this);
          }),
          (SVGRendererBase.prototype.createImage = function (e) {
            return new IImageElement(e, this.globalData, this);
          }),
          (SVGRendererBase.prototype.createSolid = function (e) {
            return new ISolidElement(e, this.globalData, this);
          }),
          (SVGRendererBase.prototype.configAnimation = function (e) {
            this.svgElement.setAttribute("xmlns", "http://www.w3.org/2000/svg"),
              this.svgElement.setAttribute(
                "xmlns:xlink",
                "http://www.w3.org/1999/xlink"
              ),
              this.renderConfig.viewBoxSize
                ? this.svgElement.setAttribute(
                    "viewBox",
                    this.renderConfig.viewBoxSize
                  )
                : this.svgElement.setAttribute(
                    "viewBox",
                    "0 0 " + e.w + " " + e.h
                  ),
              this.renderConfig.viewBoxOnly ||
                (this.svgElement.setAttribute("width", e.w),
                this.svgElement.setAttribute("height", e.h),
                (this.svgElement.style.width = "100%"),
                (this.svgElement.style.height = "100%"),
                (this.svgElement.style.transform = "translate3d(0,0,0)"),
                (this.svgElement.style.contentVisibility =
                  this.renderConfig.contentVisibility)),
              this.renderConfig.width &&
                this.svgElement.setAttribute("width", this.renderConfig.width),
              this.renderConfig.height &&
                this.svgElement.setAttribute(
                  "height",
                  this.renderConfig.height
                ),
              this.renderConfig.className &&
                this.svgElement.setAttribute(
                  "class",
                  this.renderConfig.className
                ),
              this.renderConfig.id &&
                this.svgElement.setAttribute("id", this.renderConfig.id),
              this.renderConfig.focusable !== void 0 &&
                this.svgElement.setAttribute(
                  "focusable",
                  this.renderConfig.focusable
                ),
              this.svgElement.setAttribute(
                "preserveAspectRatio",
                this.renderConfig.preserveAspectRatio
              ),
              this.animationItem.wrapper.appendChild(this.svgElement);
            var t = this.globalData.defs;
            this.setupGlobalData(e, t),
              (this.globalData.progressiveLoad =
                this.renderConfig.progressiveLoad),
              (this.data = e);
            var r = createNS("clipPath"),
              n = createNS("rect");
            n.setAttribute("width", e.w),
              n.setAttribute("height", e.h),
              n.setAttribute("x", 0),
              n.setAttribute("y", 0);
            var i = createElementID();
            r.setAttribute("id", i),
              r.appendChild(n),
              this.layerElement.setAttribute(
                "clip-path",
                "url(" + getLocationHref() + "#" + i + ")"
              ),
              t.appendChild(r),
              (this.layers = e.layers),
              (this.elements = createSizedArray(e.layers.length));
          }),
          (SVGRendererBase.prototype.destroy = function () {
            var e;
            this.animationItem.wrapper &&
              (this.animationItem.wrapper.innerText = ""),
              (this.layerElement = null),
              (this.globalData.defs = null);
            var t = this.layers ? this.layers.length : 0;
            for (e = 0; e < t; e += 1)
              this.elements[e] &&
                this.elements[e].destroy &&
                this.elements[e].destroy();
            (this.elements.length = 0),
              (this.destroyed = !0),
              (this.animationItem = null);
          }),
          (SVGRendererBase.prototype.updateContainerSize = function () {}),
          (SVGRendererBase.prototype.findIndexByInd = function (e) {
            var t = 0,
              r = this.layers.length;
            for (t = 0; t < r; t += 1) if (this.layers[t].ind === e) return t;
            return -1;
          }),
          (SVGRendererBase.prototype.buildItem = function (e) {
            var t = this.elements;
            if (!t[e] && this.layers[e].ty !== 99) {
              t[e] = !0;
              var r = this.createItem(this.layers[e]);
              if (
                ((t[e] = r),
                getExpressionsPlugin() &&
                  (this.layers[e].ty === 0 &&
                    this.globalData.projectInterface.registerComposition(r),
                  r.initExpressions()),
                this.appendElementInPos(r, e),
                this.layers[e].tt)
              ) {
                var n =
                  "tp" in this.layers[e]
                    ? this.findIndexByInd(this.layers[e].tp)
                    : e - 1;
                if (n === -1) return;
                if (this.elements[n] && this.elements[n] !== !0) {
                  var i = t[n].getMatte(this.layers[e].tt);
                  r.setMatte(i);
                } else this.buildItem(n), this.addPendingElement(r);
              }
            }
          }),
          (SVGRendererBase.prototype.checkPendingElements = function () {
            for (; this.pendingElements.length; ) {
              var e = this.pendingElements.pop();
              if ((e.checkParenting(), e.data.tt))
                for (var t = 0, r = this.elements.length; t < r; ) {
                  if (this.elements[t] === e) {
                    var n =
                        "tp" in e.data ? this.findIndexByInd(e.data.tp) : t - 1,
                      i = this.elements[n].getMatte(this.layers[t].tt);
                    e.setMatte(i);
                    break;
                  }
                  t += 1;
                }
            }
          }),
          (SVGRendererBase.prototype.renderFrame = function (e) {
            if (this.renderedFrame !== e && !this.destroyed) {
              var t;
              e === null ? (e = this.renderedFrame) : (this.renderedFrame = e),
                (this.globalData.frameNum = e),
                (this.globalData.frameId += 1),
                (this.globalData.projectInterface.currentFrame = e),
                (this.globalData._mdf = !1);
              var r = this.layers.length;
              for (
                this.completeLayers || this.checkLayers(e), t = r - 1;
                t >= 0;
                t -= 1
              )
                (this.completeLayers || this.elements[t]) &&
                  this.elements[t].prepareFrame(e - this.layers[t].st);
              if (this.globalData._mdf)
                for (t = 0; t < r; t += 1)
                  (this.completeLayers || this.elements[t]) &&
                    this.elements[t].renderFrame();
            }
          }),
          (SVGRendererBase.prototype.appendElementInPos = function (e, t) {
            var r = e.getBaseElement();
            if (r) {
              for (var n, i = 0; i < t; )
                this.elements[i] &&
                  this.elements[i] !== !0 &&
                  this.elements[i].getBaseElement() &&
                  (n = this.elements[i].getBaseElement()),
                  (i += 1);
              n
                ? this.layerElement.insertBefore(r, n)
                : this.layerElement.appendChild(r);
            }
          }),
          (SVGRendererBase.prototype.hide = function () {
            this.layerElement.style.display = "none";
          }),
          (SVGRendererBase.prototype.show = function () {
            this.layerElement.style.display = "block";
          }),
          extendPrototype(
            [
              BaseElement,
              TransformElement,
              HierarchyElement,
              FrameElement,
              RenderableDOMElement,
            ],
            ICompElement
          ),
          (ICompElement.prototype.initElement = function (e, t, r) {
            this.initFrame(),
              this.initBaseData(e, t, r),
              this.initTransform(e, t, r),
              this.initRenderable(),
              this.initHierarchy(),
              this.initRendererElement(),
              this.createContainerElements(),
              this.createRenderableComponents(),
              (!this.data.xt && t.progressiveLoad) || this.buildAllItems(),
              this.hide();
          }),
          (ICompElement.prototype.prepareFrame = function (e) {
            if (
              ((this._mdf = !1),
              this.prepareRenderableFrame(e),
              this.prepareProperties(e, this.isInRange),
              this.isInRange || this.data.xt)
            ) {
              if (this.tm._placeholder) this.renderedFrame = e / this.data.sr;
              else {
                var t = this.tm.v;
                t === this.data.op && (t = this.data.op - 1),
                  (this.renderedFrame = t);
              }
              var r,
                n = this.elements.length;
              for (
                this.completeLayers || this.checkLayers(this.renderedFrame),
                  r = n - 1;
                r >= 0;
                r -= 1
              )
                (this.completeLayers || this.elements[r]) &&
                  (this.elements[r].prepareFrame(
                    this.renderedFrame - this.layers[r].st
                  ),
                  this.elements[r]._mdf && (this._mdf = !0));
            }
          }),
          (ICompElement.prototype.renderInnerContent = function () {
            var e,
              t = this.layers.length;
            for (e = 0; e < t; e += 1)
              (this.completeLayers || this.elements[e]) &&
                this.elements[e].renderFrame();
          }),
          (ICompElement.prototype.setElements = function (e) {
            this.elements = e;
          }),
          (ICompElement.prototype.getElements = function () {
            return this.elements;
          }),
          (ICompElement.prototype.destroyElements = function () {
            var e,
              t = this.layers.length;
            for (e = 0; e < t; e += 1)
              this.elements[e] && this.elements[e].destroy();
          }),
          (ICompElement.prototype.destroy = function () {
            this.destroyElements(), this.destroyBaseElement();
          }),
          extendPrototype(
            [SVGRendererBase, ICompElement, SVGBaseElement],
            SVGCompElement
          ),
          (SVGCompElement.prototype.createComp = function (e) {
            return new SVGCompElement(e, this.globalData, this);
          }),
          extendPrototype([SVGRendererBase], SVGRenderer),
          (SVGRenderer.prototype.createComp = function (e) {
            return new SVGCompElement(e, this.globalData, this);
          }),
          (ShapeTransformManager.prototype = {
            addTransformSequence: function (e) {
              var t,
                r = e.length,
                n = "_";
              for (t = 0; t < r; t += 1) n += e[t].transform.key + "_";
              var i = this.sequences[n];
              return (
                i ||
                  ((i = {
                    transforms: [].concat(e),
                    finalTransform: new Matrix(),
                    _mdf: !1,
                  }),
                  (this.sequences[n] = i),
                  this.sequenceList.push(i)),
                i
              );
            },
            processSequence: function (e, t) {
              for (var r = 0, n = e.transforms.length, i = t; r < n && !t; ) {
                if (e.transforms[r].transform.mProps._mdf) {
                  i = !0;
                  break;
                }
                r += 1;
              }
              if (i)
                for (e.finalTransform.reset(), r = n - 1; r >= 0; r -= 1)
                  e.finalTransform.multiply(e.transforms[r].transform.mProps.v);
              e._mdf = i;
            },
            processSequences: function (e) {
              var t,
                r = this.sequenceList.length;
              for (t = 0; t < r; t += 1)
                this.processSequence(this.sequenceList[t], e);
            },
            getNewKey: function () {
              return (
                (this.transform_key_count += 1), "_" + this.transform_key_count
              );
            },
          });
        var lumaLoader = function () {
          var e = "__lottie_element_luma_buffer",
            t = null,
            r = null,
            n = null;
          function i() {
            var a, o, s;
            t ||
              ((a = createNS("svg")),
              (o = createNS("filter")),
              (s = createNS("feColorMatrix")),
              o.setAttribute("id", e),
              s.setAttribute("type", "matrix"),
              s.setAttribute("color-interpolation-filters", "sRGB"),
              s.setAttribute(
                "values",
                "0.3, 0.3, 0.3, 0, 0, 0.3, 0.3, 0.3, 0, 0, 0.3, 0.3, 0.3, 0, 0, 0.3, 0.3, 0.3, 0, 0"
              ),
              o.appendChild(s),
              a.appendChild(o),
              a.setAttribute("id", e + "_svg"),
              featureSupport.svgLumaHidden && (a.style.display = "none"),
              (n = a),
              document.body.appendChild(n),
              (t = createTag("canvas")),
              ((r = t.getContext("2d")).filter = "url(#" + e + ")"),
              (r.fillStyle = "rgba(0,0,0,0)"),
              r.fillRect(0, 0, 1, 1));
          }
          return {
            load: i,
            get: function (a) {
              return (
                t || i(),
                (t.width = a.width),
                (t.height = a.height),
                (r.filter = "url(#" + e + ")"),
                t
              );
            },
          };
        };
        function createCanvas(e, t) {
          if (featureSupport.offscreenCanvas) return new OffscreenCanvas(e, t);
          var r = createTag("canvas");
          return (r.width = e), (r.height = t), r;
        }
        var assetLoader = {
            loadLumaCanvas: lumaLoader.load,
            getLumaCanvas: lumaLoader.get,
            createCanvas,
          },
          registeredEffects = {};
        function CVEffects(e) {
          var t,
            r,
            n = e.data.ef ? e.data.ef.length : 0;
          for (this.filters = [], t = 0; t < n; t += 1) {
            r = null;
            var i = e.data.ef[t].ty;
            registeredEffects[i] &&
              (r = new registeredEffects[i].effect(
                e.effectsManager.effectElements[t],
                e
              )),
              r && this.filters.push(r);
          }
          this.filters.length && e.addRenderableComponent(this);
        }
        function registerEffect(e, t) {
          registeredEffects[e] = { effect: t };
        }
        function CVMaskElement(e, t) {
          var r;
          (this.data = e),
            (this.element = t),
            (this.masksProperties = this.data.masksProperties || []),
            (this.viewData = createSizedArray(this.masksProperties.length));
          var n = this.masksProperties.length,
            i = !1;
          for (r = 0; r < n; r += 1)
            this.masksProperties[r].mode !== "n" && (i = !0),
              (this.viewData[r] = ShapePropertyFactory.getShapeProp(
                this.element,
                this.masksProperties[r],
                3
              ));
          (this.hasMasks = i), i && this.element.addRenderableComponent(this);
        }
        function CVBaseElement() {}
        (CVEffects.prototype.renderFrame = function (e) {
          var t,
            r = this.filters.length;
          for (t = 0; t < r; t += 1) this.filters[t].renderFrame(e);
        }),
          (CVEffects.prototype.getEffects = function (e) {
            var t,
              r = this.filters.length,
              n = [];
            for (t = 0; t < r; t += 1)
              this.filters[t].type === e && n.push(this.filters[t]);
            return n;
          }),
          (CVMaskElement.prototype.renderFrame = function () {
            if (this.hasMasks) {
              var e,
                t,
                r,
                n,
                i = this.element.finalTransform.mat,
                a = this.element.canvasContext,
                o = this.masksProperties.length;
              for (a.beginPath(), e = 0; e < o; e += 1)
                if (this.masksProperties[e].mode !== "n") {
                  var s;
                  this.masksProperties[e].inv &&
                    (a.moveTo(0, 0),
                    a.lineTo(this.element.globalData.compSize.w, 0),
                    a.lineTo(
                      this.element.globalData.compSize.w,
                      this.element.globalData.compSize.h
                    ),
                    a.lineTo(0, this.element.globalData.compSize.h),
                    a.lineTo(0, 0)),
                    (n = this.viewData[e].v),
                    (t = i.applyToPointArray(n.v[0][0], n.v[0][1], 0)),
                    a.moveTo(t[0], t[1]);
                  var l = n._length;
                  for (s = 1; s < l; s += 1)
                    (r = i.applyToTriplePoints(n.o[s - 1], n.i[s], n.v[s])),
                      a.bezierCurveTo(r[0], r[1], r[2], r[3], r[4], r[5]);
                  (r = i.applyToTriplePoints(n.o[s - 1], n.i[0], n.v[0])),
                    a.bezierCurveTo(r[0], r[1], r[2], r[3], r[4], r[5]);
                }
              this.element.globalData.renderer.save(!0), a.clip();
            }
          }),
          (CVMaskElement.prototype.getMaskProperty =
            MaskElement.prototype.getMaskProperty),
          (CVMaskElement.prototype.destroy = function () {
            this.element = null;
          });
        var operationsMap = {
          1: "source-in",
          2: "source-out",
          3: "source-in",
          4: "source-out",
        };
        function CVShapeData(e, t, r, n) {
          (this.styledShapes = []), (this.tr = [0, 0, 0, 0, 0, 0]);
          var i,
            a = 4;
          t.ty === "rc"
            ? (a = 5)
            : t.ty === "el"
            ? (a = 6)
            : t.ty === "sr" && (a = 7),
            (this.sh = ShapePropertyFactory.getShapeProp(e, t, a, e));
          var o,
            s = r.length;
          for (i = 0; i < s; i += 1)
            r[i].closed ||
              ((o = {
                transforms: n.addTransformSequence(r[i].transforms),
                trNodes: [],
              }),
              this.styledShapes.push(o),
              r[i].elements.push(o));
        }
        function CVShapeElement(e, t, r) {
          (this.shapes = []),
            (this.shapesData = e.shapes),
            (this.stylesList = []),
            (this.itemsData = []),
            (this.prevViewData = []),
            (this.shapeModifiers = []),
            (this.processedElements = []),
            (this.transformsManager = new ShapeTransformManager()),
            this.initElement(e, t, r);
        }
        function CVTextElement(e, t, r) {
          (this.textSpans = []),
            (this.yOffset = 0),
            (this.fillColorAnim = !1),
            (this.strokeColorAnim = !1),
            (this.strokeWidthAnim = !1),
            (this.stroke = !1),
            (this.fill = !1),
            (this.justifyOffset = 0),
            (this.currentRender = null),
            (this.renderType = "canvas"),
            (this.values = {
              fill: "rgba(0,0,0,0)",
              stroke: "rgba(0,0,0,0)",
              sWidth: 0,
              fValue: "",
            }),
            this.initElement(e, t, r);
        }
        function CVImageElement(e, t, r) {
          (this.assetData = t.getAssetData(e.refId)),
            (this.img = t.imageLoader.getAsset(this.assetData)),
            this.initElement(e, t, r);
        }
        function CVSolidElement(e, t, r) {
          this.initElement(e, t, r);
        }
        function CanvasRendererBase() {}
        function CanvasContext() {
          (this.opacity = -1),
            (this.transform = createTypedArray("float32", 16)),
            (this.fillStyle = ""),
            (this.strokeStyle = ""),
            (this.lineWidth = ""),
            (this.lineCap = ""),
            (this.lineJoin = ""),
            (this.miterLimit = ""),
            (this.id = Math.random());
        }
        function CVContextData() {
          var e;
          for (
            this.stack = [], this.cArrPos = 0, this.cTr = new Matrix(), e = 0;
            e < 15;
            e += 1
          ) {
            var t = new CanvasContext();
            this.stack[e] = t;
          }
          (this._length = 15),
            (this.nativeContext = null),
            (this.transformMat = new Matrix()),
            (this.currentOpacity = 1),
            (this.currentFillStyle = ""),
            (this.appliedFillStyle = ""),
            (this.currentStrokeStyle = ""),
            (this.appliedStrokeStyle = ""),
            (this.currentLineWidth = ""),
            (this.appliedLineWidth = ""),
            (this.currentLineCap = ""),
            (this.appliedLineCap = ""),
            (this.currentLineJoin = ""),
            (this.appliedLineJoin = ""),
            (this.appliedMiterLimit = ""),
            (this.currentMiterLimit = "");
        }
        function CVCompElement(e, t, r) {
          (this.completeLayers = !1),
            (this.layers = e.layers),
            (this.pendingElements = []),
            (this.elements = createSizedArray(this.layers.length)),
            this.initElement(e, t, r),
            (this.tm = e.tm
              ? PropertyFactory.getProp(this, e.tm, 0, t.frameRate, this)
              : { _placeholder: !0 });
        }
        function CanvasRenderer(e, t) {
          (this.animationItem = e),
            (this.renderConfig = {
              clearCanvas: !t || t.clearCanvas === void 0 || t.clearCanvas,
              context: (t && t.context) || null,
              progressiveLoad: (t && t.progressiveLoad) || !1,
              preserveAspectRatio:
                (t && t.preserveAspectRatio) || "xMidYMid meet",
              imagePreserveAspectRatio:
                (t && t.imagePreserveAspectRatio) || "xMidYMid slice",
              contentVisibility: (t && t.contentVisibility) || "visible",
              className: (t && t.className) || "",
              id: (t && t.id) || "",
              runExpressions:
                !t || t.runExpressions === void 0 || t.runExpressions,
            }),
            (this.renderConfig.dpr = (t && t.dpr) || 1),
            this.animationItem.wrapper &&
              (this.renderConfig.dpr =
                (t && t.dpr) || window.devicePixelRatio || 1),
            (this.renderedFrame = -1),
            (this.globalData = {
              frameNum: -1,
              _mdf: !1,
              renderConfig: this.renderConfig,
              currentGlobalAlpha: -1,
            }),
            (this.contextData = new CVContextData()),
            (this.elements = []),
            (this.pendingElements = []),
            (this.transformMat = new Matrix()),
            (this.completeLayers = !1),
            (this.rendererType = "canvas"),
            this.renderConfig.clearCanvas &&
              ((this.ctxTransform = this.contextData.transform.bind(
                this.contextData
              )),
              (this.ctxOpacity = this.contextData.opacity.bind(
                this.contextData
              )),
              (this.ctxFillStyle = this.contextData.fillStyle.bind(
                this.contextData
              )),
              (this.ctxStrokeStyle = this.contextData.strokeStyle.bind(
                this.contextData
              )),
              (this.ctxLineWidth = this.contextData.lineWidth.bind(
                this.contextData
              )),
              (this.ctxLineCap = this.contextData.lineCap.bind(
                this.contextData
              )),
              (this.ctxLineJoin = this.contextData.lineJoin.bind(
                this.contextData
              )),
              (this.ctxMiterLimit = this.contextData.miterLimit.bind(
                this.contextData
              )),
              (this.ctxFill = this.contextData.fill.bind(this.contextData)),
              (this.ctxFillRect = this.contextData.fillRect.bind(
                this.contextData
              )),
              (this.ctxStroke = this.contextData.stroke.bind(this.contextData)),
              (this.save = this.contextData.save.bind(this.contextData)));
        }
        function HBaseElement() {}
        function HSolidElement(e, t, r) {
          this.initElement(e, t, r);
        }
        function HShapeElement(e, t, r) {
          (this.shapes = []),
            (this.shapesData = e.shapes),
            (this.stylesList = []),
            (this.shapeModifiers = []),
            (this.itemsData = []),
            (this.processedElements = []),
            (this.animatedContents = []),
            (this.shapesContainer = createNS("g")),
            this.initElement(e, t, r),
            (this.prevViewData = []),
            (this.currentBBox = { x: 999999, y: -999999, h: 0, w: 0 });
        }
        function HTextElement(e, t, r) {
          (this.textSpans = []),
            (this.textPaths = []),
            (this.currentBBox = { x: 999999, y: -999999, h: 0, w: 0 }),
            (this.renderType = "svg"),
            (this.isMasked = !1),
            this.initElement(e, t, r);
        }
        function HCameraElement(e, t, r) {
          this.initFrame(), this.initBaseData(e, t, r), this.initHierarchy();
          var n = PropertyFactory.getProp;
          if (
            ((this.pe = n(this, e.pe, 0, 0, this)),
            e.ks.p.s
              ? ((this.px = n(this, e.ks.p.x, 1, 0, this)),
                (this.py = n(this, e.ks.p.y, 1, 0, this)),
                (this.pz = n(this, e.ks.p.z, 1, 0, this)))
              : (this.p = n(this, e.ks.p, 1, 0, this)),
            e.ks.a && (this.a = n(this, e.ks.a, 1, 0, this)),
            e.ks.or.k.length && e.ks.or.k[0].to)
          ) {
            var i,
              a = e.ks.or.k.length;
            for (i = 0; i < a; i += 1)
              (e.ks.or.k[i].to = null), (e.ks.or.k[i].ti = null);
          }
          (this.or = n(this, e.ks.or, 1, degToRads, this)),
            (this.or.sh = !0),
            (this.rx = n(this, e.ks.rx, 0, degToRads, this)),
            (this.ry = n(this, e.ks.ry, 0, degToRads, this)),
            (this.rz = n(this, e.ks.rz, 0, degToRads, this)),
            (this.mat = new Matrix()),
            (this._prevMat = new Matrix()),
            (this._isFirstFrame = !0),
            (this.finalTransform = { mProp: this });
        }
        function HImageElement(e, t, r) {
          (this.assetData = t.getAssetData(e.refId)), this.initElement(e, t, r);
        }
        function HybridRendererBase(e, t) {
          (this.animationItem = e),
            (this.layers = null),
            (this.renderedFrame = -1),
            (this.renderConfig = {
              className: (t && t.className) || "",
              imagePreserveAspectRatio:
                (t && t.imagePreserveAspectRatio) || "xMidYMid slice",
              hideOnTransparent: !(t && t.hideOnTransparent === !1),
              filterSize: {
                width: (t && t.filterSize && t.filterSize.width) || "400%",
                height: (t && t.filterSize && t.filterSize.height) || "400%",
                x: (t && t.filterSize && t.filterSize.x) || "-100%",
                y: (t && t.filterSize && t.filterSize.y) || "-100%",
              },
            }),
            (this.globalData = {
              _mdf: !1,
              frameNum: -1,
              renderConfig: this.renderConfig,
            }),
            (this.pendingElements = []),
            (this.elements = []),
            (this.threeDElements = []),
            (this.destroyed = !1),
            (this.camera = null),
            (this.supports3d = !0),
            (this.rendererType = "html");
        }
        function HCompElement(e, t, r) {
          (this.layers = e.layers),
            (this.supports3d = !e.hasMask),
            (this.completeLayers = !1),
            (this.pendingElements = []),
            (this.elements = this.layers
              ? createSizedArray(this.layers.length)
              : []),
            this.initElement(e, t, r),
            (this.tm = e.tm
              ? PropertyFactory.getProp(this, e.tm, 0, t.frameRate, this)
              : { _placeholder: !0 });
        }
        function HybridRenderer(e, t) {
          (this.animationItem = e),
            (this.layers = null),
            (this.renderedFrame = -1),
            (this.renderConfig = {
              className: (t && t.className) || "",
              imagePreserveAspectRatio:
                (t && t.imagePreserveAspectRatio) || "xMidYMid slice",
              hideOnTransparent: !(t && t.hideOnTransparent === !1),
              filterSize: {
                width: (t && t.filterSize && t.filterSize.width) || "400%",
                height: (t && t.filterSize && t.filterSize.height) || "400%",
                x: (t && t.filterSize && t.filterSize.x) || "-100%",
                y: (t && t.filterSize && t.filterSize.y) || "-100%",
              },
              runExpressions:
                !t || t.runExpressions === void 0 || t.runExpressions,
            }),
            (this.globalData = {
              _mdf: !1,
              frameNum: -1,
              renderConfig: this.renderConfig,
            }),
            (this.pendingElements = []),
            (this.elements = []),
            (this.threeDElements = []),
            (this.destroyed = !1),
            (this.camera = null),
            (this.supports3d = !0),
            (this.rendererType = "html");
        }
        (CVBaseElement.prototype = {
          createElements: function () {},
          initRendererElement: function () {},
          createContainerElements: function () {
            if (this.data.tt >= 1) {
              this.buffers = [];
              var e = this.globalData.canvasContext,
                t = assetLoader.createCanvas(e.canvas.width, e.canvas.height);
              this.buffers.push(t);
              var r = assetLoader.createCanvas(e.canvas.width, e.canvas.height);
              this.buffers.push(r),
                this.data.tt >= 3 &&
                  !document._isProxy &&
                  assetLoader.loadLumaCanvas();
            }
            (this.canvasContext = this.globalData.canvasContext),
              (this.transformCanvas = this.globalData.transformCanvas),
              (this.renderableEffectsManager = new CVEffects(this)),
              this.searchEffectTransforms();
          },
          createContent: function () {},
          setBlendMode: function () {
            var e = this.globalData;
            if (e.blendMode !== this.data.bm) {
              e.blendMode = this.data.bm;
              var t = getBlendMode(this.data.bm);
              e.canvasContext.globalCompositeOperation = t;
            }
          },
          createRenderableComponents: function () {
            (this.maskManager = new CVMaskElement(this.data, this)),
              (this.transformEffects = this.renderableEffectsManager.getEffects(
                effectTypes.TRANSFORM_EFFECT
              ));
          },
          hideElement: function () {
            this.hidden ||
              (this.isInRange && !this.isTransparent) ||
              (this.hidden = !0);
          },
          showElement: function () {
            this.isInRange &&
              !this.isTransparent &&
              ((this.hidden = !1),
              (this._isFirstFrame = !0),
              (this.maskManager._isFirstFrame = !0));
          },
          clearCanvas: function (e) {
            e.clearRect(
              this.transformCanvas.tx,
              this.transformCanvas.ty,
              this.transformCanvas.w * this.transformCanvas.sx,
              this.transformCanvas.h * this.transformCanvas.sy
            );
          },
          prepareLayer: function () {
            if (this.data.tt >= 1) {
              var e = this.buffers[0].getContext("2d");
              this.clearCanvas(e),
                e.drawImage(this.canvasContext.canvas, 0, 0),
                (this.currentTransform = this.canvasContext.getTransform()),
                this.canvasContext.setTransform(1, 0, 0, 1, 0, 0),
                this.clearCanvas(this.canvasContext),
                this.canvasContext.setTransform(this.currentTransform);
            }
          },
          exitLayer: function () {
            if (this.data.tt >= 1) {
              var e = this.buffers[1],
                t = e.getContext("2d");
              if (
                (this.clearCanvas(t),
                t.drawImage(this.canvasContext.canvas, 0, 0),
                this.canvasContext.setTransform(1, 0, 0, 1, 0, 0),
                this.clearCanvas(this.canvasContext),
                this.canvasContext.setTransform(this.currentTransform),
                this.comp
                  .getElementById(
                    "tp" in this.data ? this.data.tp : this.data.ind - 1
                  )
                  .renderFrame(!0),
                this.canvasContext.setTransform(1, 0, 0, 1, 0, 0),
                this.data.tt >= 3 && !document._isProxy)
              ) {
                var r = assetLoader.getLumaCanvas(this.canvasContext.canvas);
                r.getContext("2d").drawImage(this.canvasContext.canvas, 0, 0),
                  this.clearCanvas(this.canvasContext),
                  this.canvasContext.drawImage(r, 0, 0);
              }
              (this.canvasContext.globalCompositeOperation =
                operationsMap[this.data.tt]),
                this.canvasContext.drawImage(e, 0, 0),
                (this.canvasContext.globalCompositeOperation =
                  "destination-over"),
                this.canvasContext.drawImage(this.buffers[0], 0, 0),
                this.canvasContext.setTransform(this.currentTransform),
                (this.canvasContext.globalCompositeOperation = "source-over");
            }
          },
          renderFrame: function (e) {
            if (!this.hidden && !this.data.hd && (this.data.td !== 1 || e)) {
              this.renderTransform(),
                this.renderRenderable(),
                this.renderLocalTransform(),
                this.setBlendMode();
              var t = this.data.ty === 0;
              this.prepareLayer(),
                this.globalData.renderer.save(t),
                this.globalData.renderer.ctxTransform(
                  this.finalTransform.localMat.props
                ),
                this.globalData.renderer.ctxOpacity(
                  this.finalTransform.localOpacity
                ),
                this.renderInnerContent(),
                this.globalData.renderer.restore(t),
                this.exitLayer(),
                this.maskManager.hasMasks &&
                  this.globalData.renderer.restore(!0),
                this._isFirstFrame && (this._isFirstFrame = !1);
            }
          },
          destroy: function () {
            (this.canvasContext = null),
              (this.data = null),
              (this.globalData = null),
              this.maskManager.destroy();
          },
          mHelper: new Matrix(),
        }),
          (CVBaseElement.prototype.hide = CVBaseElement.prototype.hideElement),
          (CVBaseElement.prototype.show = CVBaseElement.prototype.showElement),
          (CVShapeData.prototype.setAsAnimated =
            SVGShapeData.prototype.setAsAnimated),
          extendPrototype(
            [
              BaseElement,
              TransformElement,
              CVBaseElement,
              IShapeElement,
              HierarchyElement,
              FrameElement,
              RenderableElement,
            ],
            CVShapeElement
          ),
          (CVShapeElement.prototype.initElement =
            RenderableDOMElement.prototype.initElement),
          (CVShapeElement.prototype.transformHelper = {
            opacity: 1,
            _opMdf: !1,
          }),
          (CVShapeElement.prototype.dashResetter = []),
          (CVShapeElement.prototype.createContent = function () {
            this.searchShapes(
              this.shapesData,
              this.itemsData,
              this.prevViewData,
              !0,
              []
            );
          }),
          (CVShapeElement.prototype.createStyleElement = function (e, t) {
            var r = {
                data: e,
                type: e.ty,
                preTransforms: this.transformsManager.addTransformSequence(t),
                transforms: [],
                elements: [],
                closed: e.hd === !0,
              },
              n = {};
            if (
              (e.ty === "fl" || e.ty === "st"
                ? ((n.c = PropertyFactory.getProp(this, e.c, 1, 255, this)),
                  n.c.k ||
                    (r.co =
                      "rgb(" +
                      bmFloor(n.c.v[0]) +
                      "," +
                      bmFloor(n.c.v[1]) +
                      "," +
                      bmFloor(n.c.v[2]) +
                      ")"))
                : (e.ty !== "gf" && e.ty !== "gs") ||
                  ((n.s = PropertyFactory.getProp(this, e.s, 1, null, this)),
                  (n.e = PropertyFactory.getProp(this, e.e, 1, null, this)),
                  (n.h = PropertyFactory.getProp(
                    this,
                    e.h || { k: 0 },
                    0,
                    0.01,
                    this
                  )),
                  (n.a = PropertyFactory.getProp(
                    this,
                    e.a || { k: 0 },
                    0,
                    degToRads,
                    this
                  )),
                  (n.g = new GradientProperty(this, e.g, this))),
              (n.o = PropertyFactory.getProp(this, e.o, 0, 0.01, this)),
              e.ty === "st" || e.ty === "gs")
            ) {
              if (
                ((r.lc = lineCapEnum[e.lc || 2]),
                (r.lj = lineJoinEnum[e.lj || 2]),
                e.lj == 1 && (r.ml = e.ml),
                (n.w = PropertyFactory.getProp(this, e.w, 0, null, this)),
                n.w.k || (r.wi = n.w.v),
                e.d)
              ) {
                var i = new DashProperty(this, e.d, "canvas", this);
                (n.d = i),
                  n.d.k || ((r.da = n.d.dashArray), (r.do = n.d.dashoffset[0]));
              }
            } else r.r = e.r === 2 ? "evenodd" : "nonzero";
            return this.stylesList.push(r), (n.style = r), n;
          }),
          (CVShapeElement.prototype.createGroupElement = function () {
            return { it: [], prevViewData: [] };
          }),
          (CVShapeElement.prototype.createTransformElement = function (e) {
            return {
              transform: {
                opacity: 1,
                _opMdf: !1,
                key: this.transformsManager.getNewKey(),
                op: PropertyFactory.getProp(this, e.o, 0, 0.01, this),
                mProps: TransformPropertyFactory.getTransformProperty(
                  this,
                  e,
                  this
                ),
              },
            };
          }),
          (CVShapeElement.prototype.createShapeElement = function (e) {
            var t = new CVShapeData(
              this,
              e,
              this.stylesList,
              this.transformsManager
            );
            return this.shapes.push(t), this.addShapeToModifiers(t), t;
          }),
          (CVShapeElement.prototype.reloadShapes = function () {
            var e;
            this._isFirstFrame = !0;
            var t = this.itemsData.length;
            for (e = 0; e < t; e += 1) this.prevViewData[e] = this.itemsData[e];
            for (
              this.searchShapes(
                this.shapesData,
                this.itemsData,
                this.prevViewData,
                !0,
                []
              ),
                t = this.dynamicProperties.length,
                e = 0;
              e < t;
              e += 1
            )
              this.dynamicProperties[e].getValue();
            this.renderModifiers(),
              this.transformsManager.processSequences(this._isFirstFrame);
          }),
          (CVShapeElement.prototype.addTransformToStyleList = function (e) {
            var t,
              r = this.stylesList.length;
            for (t = 0; t < r; t += 1)
              this.stylesList[t].closed ||
                this.stylesList[t].transforms.push(e);
          }),
          (CVShapeElement.prototype.removeTransformFromStyleList = function () {
            var e,
              t = this.stylesList.length;
            for (e = 0; e < t; e += 1)
              this.stylesList[e].closed || this.stylesList[e].transforms.pop();
          }),
          (CVShapeElement.prototype.closeStyles = function (e) {
            var t,
              r = e.length;
            for (t = 0; t < r; t += 1) e[t].closed = !0;
          }),
          (CVShapeElement.prototype.searchShapes = function (e, t, r, n, i) {
            var a,
              o,
              s,
              l,
              f,
              u,
              h = e.length - 1,
              m = [],
              d = [],
              p = [].concat(i);
            for (a = h; a >= 0; a -= 1) {
              if (
                ((l = this.searchProcessedElement(e[a]))
                  ? (t[a] = r[l - 1])
                  : (e[a]._shouldRender = n),
                e[a].ty === "fl" ||
                  e[a].ty === "st" ||
                  e[a].ty === "gf" ||
                  e[a].ty === "gs")
              )
                l
                  ? (t[a].style.closed = !1)
                  : (t[a] = this.createStyleElement(e[a], p)),
                  m.push(t[a].style);
              else if (e[a].ty === "gr") {
                if (l)
                  for (s = t[a].it.length, o = 0; o < s; o += 1)
                    t[a].prevViewData[o] = t[a].it[o];
                else t[a] = this.createGroupElement(e[a]);
                this.searchShapes(e[a].it, t[a].it, t[a].prevViewData, n, p);
              } else
                e[a].ty === "tr"
                  ? (l || ((u = this.createTransformElement(e[a])), (t[a] = u)),
                    p.push(t[a]),
                    this.addTransformToStyleList(t[a]))
                  : e[a].ty === "sh" ||
                    e[a].ty === "rc" ||
                    e[a].ty === "el" ||
                    e[a].ty === "sr"
                  ? l || (t[a] = this.createShapeElement(e[a]))
                  : e[a].ty === "tm" ||
                    e[a].ty === "rd" ||
                    e[a].ty === "pb" ||
                    e[a].ty === "zz" ||
                    e[a].ty === "op"
                  ? (l
                      ? ((f = t[a]).closed = !1)
                      : ((f = ShapeModifiers.getModifier(e[a].ty)).init(
                          this,
                          e[a]
                        ),
                        (t[a] = f),
                        this.shapeModifiers.push(f)),
                    d.push(f))
                  : e[a].ty === "rp" &&
                    (l
                      ? ((f = t[a]).closed = !0)
                      : ((f = ShapeModifiers.getModifier(e[a].ty)),
                        (t[a] = f),
                        f.init(this, e, a, t),
                        this.shapeModifiers.push(f),
                        (n = !1)),
                    d.push(f));
              this.addProcessedElement(e[a], a + 1);
            }
            for (
              this.removeTransformFromStyleList(),
                this.closeStyles(m),
                h = d.length,
                a = 0;
              a < h;
              a += 1
            )
              d[a].closed = !0;
          }),
          (CVShapeElement.prototype.renderInnerContent = function () {
            (this.transformHelper.opacity = 1),
              (this.transformHelper._opMdf = !1),
              this.renderModifiers(),
              this.transformsManager.processSequences(this._isFirstFrame),
              this.renderShape(
                this.transformHelper,
                this.shapesData,
                this.itemsData,
                !0
              );
          }),
          (CVShapeElement.prototype.renderShapeTransform = function (e, t) {
            (e._opMdf || t.op._mdf || this._isFirstFrame) &&
              ((t.opacity = e.opacity), (t.opacity *= t.op.v), (t._opMdf = !0));
          }),
          (CVShapeElement.prototype.drawLayer = function () {
            var e,
              t,
              r,
              n,
              i,
              a,
              o,
              s,
              l,
              f = this.stylesList.length,
              u = this.globalData.renderer,
              h = this.globalData.canvasContext;
            for (e = 0; e < f; e += 1)
              if (
                (((s = (l = this.stylesList[e]).type) !== "st" && s !== "gs") ||
                  l.wi !== 0) &&
                l.data._shouldRender &&
                l.coOp !== 0 &&
                this.globalData.currentGlobalAlpha !== 0
              ) {
                for (
                  u.save(),
                    a = l.elements,
                    s === "st" || s === "gs"
                      ? (u.ctxStrokeStyle(s === "st" ? l.co : l.grd),
                        u.ctxLineWidth(l.wi),
                        u.ctxLineCap(l.lc),
                        u.ctxLineJoin(l.lj),
                        u.ctxMiterLimit(l.ml || 0))
                      : u.ctxFillStyle(s === "fl" ? l.co : l.grd),
                    u.ctxOpacity(l.coOp),
                    s !== "st" && s !== "gs" && h.beginPath(),
                    u.ctxTransform(l.preTransforms.finalTransform.props),
                    r = a.length,
                    t = 0;
                  t < r;
                  t += 1
                ) {
                  for (
                    (s !== "st" && s !== "gs") ||
                      (h.beginPath(),
                      l.da && (h.setLineDash(l.da), (h.lineDashOffset = l.do))),
                      i = (o = a[t].trNodes).length,
                      n = 0;
                    n < i;
                    n += 1
                  )
                    o[n].t === "m"
                      ? h.moveTo(o[n].p[0], o[n].p[1])
                      : o[n].t === "c"
                      ? h.bezierCurveTo(
                          o[n].pts[0],
                          o[n].pts[1],
                          o[n].pts[2],
                          o[n].pts[3],
                          o[n].pts[4],
                          o[n].pts[5]
                        )
                      : h.closePath();
                  (s !== "st" && s !== "gs") ||
                    (u.ctxStroke(), l.da && h.setLineDash(this.dashResetter));
                }
                s !== "st" &&
                  s !== "gs" &&
                  this.globalData.renderer.ctxFill(l.r),
                  u.restore();
              }
          }),
          (CVShapeElement.prototype.renderShape = function (e, t, r, n) {
            var i, a;
            for (a = e, i = t.length - 1; i >= 0; i -= 1)
              t[i].ty === "tr"
                ? ((a = r[i].transform), this.renderShapeTransform(e, a))
                : t[i].ty === "sh" ||
                  t[i].ty === "el" ||
                  t[i].ty === "rc" ||
                  t[i].ty === "sr"
                ? this.renderPath(t[i], r[i])
                : t[i].ty === "fl"
                ? this.renderFill(t[i], r[i], a)
                : t[i].ty === "st"
                ? this.renderStroke(t[i], r[i], a)
                : t[i].ty === "gf" || t[i].ty === "gs"
                ? this.renderGradientFill(t[i], r[i], a)
                : t[i].ty === "gr"
                ? this.renderShape(a, t[i].it, r[i].it)
                : t[i].ty;
            n && this.drawLayer();
          }),
          (CVShapeElement.prototype.renderStyledShape = function (e, t) {
            if (this._isFirstFrame || t._mdf || e.transforms._mdf) {
              var r,
                n,
                i,
                a = e.trNodes,
                o = t.paths,
                s = o._length;
              a.length = 0;
              var l = e.transforms.finalTransform;
              for (i = 0; i < s; i += 1) {
                var f = o.shapes[i];
                if (f && f.v) {
                  for (n = f._length, r = 1; r < n; r += 1)
                    r === 1 &&
                      a.push({
                        t: "m",
                        p: l.applyToPointArray(f.v[0][0], f.v[0][1], 0),
                      }),
                      a.push({
                        t: "c",
                        pts: l.applyToTriplePoints(f.o[r - 1], f.i[r], f.v[r]),
                      });
                  n === 1 &&
                    a.push({
                      t: "m",
                      p: l.applyToPointArray(f.v[0][0], f.v[0][1], 0),
                    }),
                    f.c &&
                      n &&
                      (a.push({
                        t: "c",
                        pts: l.applyToTriplePoints(f.o[r - 1], f.i[0], f.v[0]),
                      }),
                      a.push({ t: "z" }));
                }
              }
              e.trNodes = a;
            }
          }),
          (CVShapeElement.prototype.renderPath = function (e, t) {
            if (e.hd !== !0 && e._shouldRender) {
              var r,
                n = t.styledShapes.length;
              for (r = 0; r < n; r += 1)
                this.renderStyledShape(t.styledShapes[r], t.sh);
            }
          }),
          (CVShapeElement.prototype.renderFill = function (e, t, r) {
            var n = t.style;
            (t.c._mdf || this._isFirstFrame) &&
              (n.co =
                "rgb(" +
                bmFloor(t.c.v[0]) +
                "," +
                bmFloor(t.c.v[1]) +
                "," +
                bmFloor(t.c.v[2]) +
                ")"),
              (t.o._mdf || r._opMdf || this._isFirstFrame) &&
                (n.coOp = t.o.v * r.opacity);
          }),
          (CVShapeElement.prototype.renderGradientFill = function (e, t, r) {
            var n,
              i = t.style;
            if (
              !i.grd ||
              t.g._mdf ||
              t.s._mdf ||
              t.e._mdf ||
              (e.t !== 1 && (t.h._mdf || t.a._mdf))
            ) {
              var a,
                o = this.globalData.canvasContext,
                s = t.s.v,
                l = t.e.v;
              if (e.t === 1) n = o.createLinearGradient(s[0], s[1], l[0], l[1]);
              else {
                var f = Math.sqrt(
                    Math.pow(s[0] - l[0], 2) + Math.pow(s[1] - l[1], 2)
                  ),
                  u = Math.atan2(l[1] - s[1], l[0] - s[0]),
                  h = t.h.v;
                h >= 1 ? (h = 0.99) : h <= -1 && (h = -0.99);
                var m = f * h,
                  d = Math.cos(u + t.a.v) * m + s[0],
                  p = Math.sin(u + t.a.v) * m + s[1];
                n = o.createRadialGradient(d, p, 0, s[0], s[1], f);
              }
              var g = e.g.p,
                c = t.g.c,
                v = 1;
              for (a = 0; a < g; a += 1)
                t.g._hasOpacity && t.g._collapsable && (v = t.g.o[2 * a + 1]),
                  n.addColorStop(
                    c[4 * a] / 100,
                    "rgba(" +
                      c[4 * a + 1] +
                      "," +
                      c[4 * a + 2] +
                      "," +
                      c[4 * a + 3] +
                      "," +
                      v +
                      ")"
                  );
              i.grd = n;
            }
            i.coOp = t.o.v * r.opacity;
          }),
          (CVShapeElement.prototype.renderStroke = function (e, t, r) {
            var n = t.style,
              i = t.d;
            i &&
              (i._mdf || this._isFirstFrame) &&
              ((n.da = i.dashArray), (n.do = i.dashoffset[0])),
              (t.c._mdf || this._isFirstFrame) &&
                (n.co =
                  "rgb(" +
                  bmFloor(t.c.v[0]) +
                  "," +
                  bmFloor(t.c.v[1]) +
                  "," +
                  bmFloor(t.c.v[2]) +
                  ")"),
              (t.o._mdf || r._opMdf || this._isFirstFrame) &&
                (n.coOp = t.o.v * r.opacity),
              (t.w._mdf || this._isFirstFrame) && (n.wi = t.w.v);
          }),
          (CVShapeElement.prototype.destroy = function () {
            (this.shapesData = null),
              (this.globalData = null),
              (this.canvasContext = null),
              (this.stylesList.length = 0),
              (this.itemsData.length = 0);
          }),
          extendPrototype(
            [
              BaseElement,
              TransformElement,
              CVBaseElement,
              HierarchyElement,
              FrameElement,
              RenderableElement,
              ITextElement,
            ],
            CVTextElement
          ),
          (CVTextElement.prototype.tHelper =
            createTag("canvas").getContext("2d")),
          (CVTextElement.prototype.buildNewText = function () {
            var e = this.textProperty.currentData;
            this.renderedLetters = createSizedArray(e.l ? e.l.length : 0);
            var t = !1;
            e.fc
              ? ((t = !0), (this.values.fill = this.buildColor(e.fc)))
              : (this.values.fill = "rgba(0,0,0,0)"),
              (this.fill = t);
            var r = !1;
            e.sc &&
              ((r = !0),
              (this.values.stroke = this.buildColor(e.sc)),
              (this.values.sWidth = e.sw));
            var n,
              i,
              a,
              o,
              s,
              l,
              f,
              u,
              h,
              m,
              d,
              p,
              g = this.globalData.fontManager.getFontByName(e.f),
              c = e.l,
              v = this.mHelper;
            (this.stroke = r),
              (this.values.fValue =
                e.finalSize +
                "px " +
                this.globalData.fontManager.getFontByName(e.f).fFamily),
              (i = e.finalText.length);
            var y = this.data.singleShape,
              b = 0.001 * e.tr * e.finalSize,
              x = 0,
              S = 0,
              T = !0,
              I = 0;
            for (n = 0; n < i; n += 1) {
              (o =
                ((a = this.globalData.fontManager.getCharData(
                  e.finalText[n],
                  g.fStyle,
                  this.globalData.fontManager.getFontByName(e.f).fFamily
                )) &&
                  a.data) ||
                {}),
                v.reset(),
                y &&
                  c[n].n &&
                  ((x = -b), (S += e.yOffset), (S += T ? 1 : 0), (T = !1)),
                (h = (f = o.shapes ? o.shapes[0].it : []).length),
                v.scale(e.finalSize / 100, e.finalSize / 100),
                y && this.applyTextPropertiesToMatrix(e, v, c[n].line, x, S),
                (d = createSizedArray(h - 1));
              var P = 0;
              for (u = 0; u < h; u += 1)
                if (f[u].ty === "sh") {
                  for (
                    l = f[u].ks.k.i.length, m = f[u].ks.k, p = [], s = 1;
                    s < l;
                    s += 1
                  )
                    s === 1 &&
                      p.push(
                        v.applyToX(m.v[0][0], m.v[0][1], 0),
                        v.applyToY(m.v[0][0], m.v[0][1], 0)
                      ),
                      p.push(
                        v.applyToX(m.o[s - 1][0], m.o[s - 1][1], 0),
                        v.applyToY(m.o[s - 1][0], m.o[s - 1][1], 0),
                        v.applyToX(m.i[s][0], m.i[s][1], 0),
                        v.applyToY(m.i[s][0], m.i[s][1], 0),
                        v.applyToX(m.v[s][0], m.v[s][1], 0),
                        v.applyToY(m.v[s][0], m.v[s][1], 0)
                      );
                  p.push(
                    v.applyToX(m.o[s - 1][0], m.o[s - 1][1], 0),
                    v.applyToY(m.o[s - 1][0], m.o[s - 1][1], 0),
                    v.applyToX(m.i[0][0], m.i[0][1], 0),
                    v.applyToY(m.i[0][0], m.i[0][1], 0),
                    v.applyToX(m.v[0][0], m.v[0][1], 0),
                    v.applyToY(m.v[0][0], m.v[0][1], 0)
                  ),
                    (d[P] = p),
                    (P += 1);
                }
              y && ((x += c[n].l), (x += b)),
                this.textSpans[I]
                  ? (this.textSpans[I].elem = d)
                  : (this.textSpans[I] = { elem: d }),
                (I += 1);
            }
          }),
          (CVTextElement.prototype.renderInnerContent = function () {
            var e, t, r, n, i, a;
            this.validateText(),
              (this.canvasContext.font = this.values.fValue),
              this.globalData.renderer.ctxLineCap("butt"),
              this.globalData.renderer.ctxLineJoin("miter"),
              this.globalData.renderer.ctxMiterLimit(4),
              this.data.singleShape ||
                this.textAnimator.getMeasures(
                  this.textProperty.currentData,
                  this.lettersChangedFlag
                );
            var o,
              s = this.textAnimator.renderedLetters,
              l = this.textProperty.currentData.l;
            t = l.length;
            var f,
              u,
              h = null,
              m = null,
              d = null,
              p = this.globalData.renderer;
            for (e = 0; e < t; e += 1)
              if (!l[e].n) {
                if (
                  ((o = s[e]) &&
                    (p.save(), p.ctxTransform(o.p), p.ctxOpacity(o.o)),
                  this.fill)
                ) {
                  for (
                    o && o.fc
                      ? h !== o.fc && (p.ctxFillStyle(o.fc), (h = o.fc))
                      : h !== this.values.fill &&
                        ((h = this.values.fill),
                        p.ctxFillStyle(this.values.fill)),
                      n = (f = this.textSpans[e].elem).length,
                      this.globalData.canvasContext.beginPath(),
                      r = 0;
                    r < n;
                    r += 1
                  )
                    for (
                      a = (u = f[r]).length,
                        this.globalData.canvasContext.moveTo(u[0], u[1]),
                        i = 2;
                      i < a;
                      i += 6
                    )
                      this.globalData.canvasContext.bezierCurveTo(
                        u[i],
                        u[i + 1],
                        u[i + 2],
                        u[i + 3],
                        u[i + 4],
                        u[i + 5]
                      );
                  this.globalData.canvasContext.closePath(), p.ctxFill();
                }
                if (this.stroke) {
                  for (
                    o && o.sw
                      ? d !== o.sw && ((d = o.sw), p.ctxLineWidth(o.sw))
                      : d !== this.values.sWidth &&
                        ((d = this.values.sWidth),
                        p.ctxLineWidth(this.values.sWidth)),
                      o && o.sc
                        ? m !== o.sc && ((m = o.sc), p.ctxStrokeStyle(o.sc))
                        : m !== this.values.stroke &&
                          ((m = this.values.stroke),
                          p.ctxStrokeStyle(this.values.stroke)),
                      n = (f = this.textSpans[e].elem).length,
                      this.globalData.canvasContext.beginPath(),
                      r = 0;
                    r < n;
                    r += 1
                  )
                    for (
                      a = (u = f[r]).length,
                        this.globalData.canvasContext.moveTo(u[0], u[1]),
                        i = 2;
                      i < a;
                      i += 6
                    )
                      this.globalData.canvasContext.bezierCurveTo(
                        u[i],
                        u[i + 1],
                        u[i + 2],
                        u[i + 3],
                        u[i + 4],
                        u[i + 5]
                      );
                  this.globalData.canvasContext.closePath(), p.ctxStroke();
                }
                o && this.globalData.renderer.restore();
              }
          }),
          extendPrototype(
            [
              BaseElement,
              TransformElement,
              CVBaseElement,
              HierarchyElement,
              FrameElement,
              RenderableElement,
            ],
            CVImageElement
          ),
          (CVImageElement.prototype.initElement =
            SVGShapeElement.prototype.initElement),
          (CVImageElement.prototype.prepareFrame =
            IImageElement.prototype.prepareFrame),
          (CVImageElement.prototype.createContent = function () {
            if (
              this.img.width &&
              (this.assetData.w !== this.img.width ||
                this.assetData.h !== this.img.height)
            ) {
              var e = createTag("canvas");
              (e.width = this.assetData.w), (e.height = this.assetData.h);
              var t,
                r,
                n = e.getContext("2d"),
                i = this.img.width,
                a = this.img.height,
                o = i / a,
                s = this.assetData.w / this.assetData.h,
                l =
                  this.assetData.pr ||
                  this.globalData.renderConfig.imagePreserveAspectRatio;
              (o > s && l === "xMidYMid slice") ||
              (o < s && l !== "xMidYMid slice")
                ? (t = (r = a) * s)
                : (r = (t = i) / s),
                n.drawImage(
                  this.img,
                  (i - t) / 2,
                  (a - r) / 2,
                  t,
                  r,
                  0,
                  0,
                  this.assetData.w,
                  this.assetData.h
                ),
                (this.img = e);
            }
          }),
          (CVImageElement.prototype.renderInnerContent = function () {
            this.canvasContext.drawImage(this.img, 0, 0);
          }),
          (CVImageElement.prototype.destroy = function () {
            this.img = null;
          }),
          extendPrototype(
            [
              BaseElement,
              TransformElement,
              CVBaseElement,
              HierarchyElement,
              FrameElement,
              RenderableElement,
            ],
            CVSolidElement
          ),
          (CVSolidElement.prototype.initElement =
            SVGShapeElement.prototype.initElement),
          (CVSolidElement.prototype.prepareFrame =
            IImageElement.prototype.prepareFrame),
          (CVSolidElement.prototype.renderInnerContent = function () {
            this.globalData.renderer.ctxFillStyle(this.data.sc),
              this.globalData.renderer.ctxFillRect(
                0,
                0,
                this.data.sw,
                this.data.sh
              );
          }),
          extendPrototype([BaseRenderer], CanvasRendererBase),
          (CanvasRendererBase.prototype.createShape = function (e) {
            return new CVShapeElement(e, this.globalData, this);
          }),
          (CanvasRendererBase.prototype.createText = function (e) {
            return new CVTextElement(e, this.globalData, this);
          }),
          (CanvasRendererBase.prototype.createImage = function (e) {
            return new CVImageElement(e, this.globalData, this);
          }),
          (CanvasRendererBase.prototype.createSolid = function (e) {
            return new CVSolidElement(e, this.globalData, this);
          }),
          (CanvasRendererBase.prototype.createNull =
            SVGRenderer.prototype.createNull),
          (CanvasRendererBase.prototype.ctxTransform = function (e) {
            (e[0] === 1 &&
              e[1] === 0 &&
              e[4] === 0 &&
              e[5] === 1 &&
              e[12] === 0 &&
              e[13] === 0) ||
              this.canvasContext.transform(
                e[0],
                e[1],
                e[4],
                e[5],
                e[12],
                e[13]
              );
          }),
          (CanvasRendererBase.prototype.ctxOpacity = function (e) {
            this.canvasContext.globalAlpha *= e < 0 ? 0 : e;
          }),
          (CanvasRendererBase.prototype.ctxFillStyle = function (e) {
            this.canvasContext.fillStyle = e;
          }),
          (CanvasRendererBase.prototype.ctxStrokeStyle = function (e) {
            this.canvasContext.strokeStyle = e;
          }),
          (CanvasRendererBase.prototype.ctxLineWidth = function (e) {
            this.canvasContext.lineWidth = e;
          }),
          (CanvasRendererBase.prototype.ctxLineCap = function (e) {
            this.canvasContext.lineCap = e;
          }),
          (CanvasRendererBase.prototype.ctxLineJoin = function (e) {
            this.canvasContext.lineJoin = e;
          }),
          (CanvasRendererBase.prototype.ctxMiterLimit = function (e) {
            this.canvasContext.miterLimit = e;
          }),
          (CanvasRendererBase.prototype.ctxFill = function (e) {
            this.canvasContext.fill(e);
          }),
          (CanvasRendererBase.prototype.ctxFillRect = function (e, t, r, n) {
            this.canvasContext.fillRect(e, t, r, n);
          }),
          (CanvasRendererBase.prototype.ctxStroke = function () {
            this.canvasContext.stroke();
          }),
          (CanvasRendererBase.prototype.reset = function () {
            this.renderConfig.clearCanvas
              ? this.contextData.reset()
              : this.canvasContext.restore();
          }),
          (CanvasRendererBase.prototype.save = function () {
            this.canvasContext.save();
          }),
          (CanvasRendererBase.prototype.restore = function (e) {
            this.renderConfig.clearCanvas
              ? (e && (this.globalData.blendMode = "source-over"),
                this.contextData.restore(e))
              : this.canvasContext.restore();
          }),
          (CanvasRendererBase.prototype.configAnimation = function (e) {
            if (this.animationItem.wrapper) {
              this.animationItem.container = createTag("canvas");
              var t = this.animationItem.container.style;
              (t.width = "100%"), (t.height = "100%");
              var r = "0px 0px 0px";
              (t.transformOrigin = r),
                (t.mozTransformOrigin = r),
                (t.webkitTransformOrigin = r),
                (t["-webkit-transform"] = r),
                (t.contentVisibility = this.renderConfig.contentVisibility),
                this.animationItem.wrapper.appendChild(
                  this.animationItem.container
                ),
                (this.canvasContext =
                  this.animationItem.container.getContext("2d")),
                this.renderConfig.className &&
                  this.animationItem.container.setAttribute(
                    "class",
                    this.renderConfig.className
                  ),
                this.renderConfig.id &&
                  this.animationItem.container.setAttribute(
                    "id",
                    this.renderConfig.id
                  );
            } else this.canvasContext = this.renderConfig.context;
            this.contextData.setContext(this.canvasContext),
              (this.data = e),
              (this.layers = e.layers),
              (this.transformCanvas = {
                w: e.w,
                h: e.h,
                sx: 0,
                sy: 0,
                tx: 0,
                ty: 0,
              }),
              this.setupGlobalData(e, document.body),
              (this.globalData.canvasContext = this.canvasContext),
              (this.globalData.renderer = this),
              (this.globalData.isDashed = !1),
              (this.globalData.progressiveLoad =
                this.renderConfig.progressiveLoad),
              (this.globalData.transformCanvas = this.transformCanvas),
              (this.elements = createSizedArray(e.layers.length)),
              this.updateContainerSize();
          }),
          (CanvasRendererBase.prototype.updateContainerSize = function (e, t) {
            var r, n, i, a;
            if (
              (this.reset(),
              e
                ? ((r = e),
                  (n = t),
                  (this.canvasContext.canvas.width = r),
                  (this.canvasContext.canvas.height = n))
                : (this.animationItem.wrapper && this.animationItem.container
                    ? ((r = this.animationItem.wrapper.offsetWidth),
                      (n = this.animationItem.wrapper.offsetHeight))
                    : ((r = this.canvasContext.canvas.width),
                      (n = this.canvasContext.canvas.height)),
                  (this.canvasContext.canvas.width = r * this.renderConfig.dpr),
                  (this.canvasContext.canvas.height =
                    n * this.renderConfig.dpr)),
              this.renderConfig.preserveAspectRatio.indexOf("meet") !== -1 ||
                this.renderConfig.preserveAspectRatio.indexOf("slice") !== -1)
            ) {
              var o = this.renderConfig.preserveAspectRatio.split(" "),
                s = o[1] || "meet",
                l = o[0] || "xMidYMid",
                f = l.substr(0, 4),
                u = l.substr(4);
              (i = r / n),
                ((a = this.transformCanvas.w / this.transformCanvas.h) > i &&
                  s === "meet") ||
                (a < i && s === "slice")
                  ? ((this.transformCanvas.sx =
                      r / (this.transformCanvas.w / this.renderConfig.dpr)),
                    (this.transformCanvas.sy =
                      r / (this.transformCanvas.w / this.renderConfig.dpr)))
                  : ((this.transformCanvas.sx =
                      n / (this.transformCanvas.h / this.renderConfig.dpr)),
                    (this.transformCanvas.sy =
                      n / (this.transformCanvas.h / this.renderConfig.dpr))),
                (this.transformCanvas.tx =
                  f === "xMid" &&
                  ((a < i && s === "meet") || (a > i && s === "slice"))
                    ? ((r -
                        this.transformCanvas.w * (n / this.transformCanvas.h)) /
                        2) *
                      this.renderConfig.dpr
                    : f === "xMax" &&
                      ((a < i && s === "meet") || (a > i && s === "slice"))
                    ? (r -
                        this.transformCanvas.w * (n / this.transformCanvas.h)) *
                      this.renderConfig.dpr
                    : 0),
                (this.transformCanvas.ty =
                  u === "YMid" &&
                  ((a > i && s === "meet") || (a < i && s === "slice"))
                    ? ((n -
                        this.transformCanvas.h * (r / this.transformCanvas.w)) /
                        2) *
                      this.renderConfig.dpr
                    : u === "YMax" &&
                      ((a > i && s === "meet") || (a < i && s === "slice"))
                    ? (n -
                        this.transformCanvas.h * (r / this.transformCanvas.w)) *
                      this.renderConfig.dpr
                    : 0);
            } else
              this.renderConfig.preserveAspectRatio === "none"
                ? ((this.transformCanvas.sx =
                    r / (this.transformCanvas.w / this.renderConfig.dpr)),
                  (this.transformCanvas.sy =
                    n / (this.transformCanvas.h / this.renderConfig.dpr)),
                  (this.transformCanvas.tx = 0),
                  (this.transformCanvas.ty = 0))
                : ((this.transformCanvas.sx = this.renderConfig.dpr),
                  (this.transformCanvas.sy = this.renderConfig.dpr),
                  (this.transformCanvas.tx = 0),
                  (this.transformCanvas.ty = 0));
            (this.transformCanvas.props = [
              this.transformCanvas.sx,
              0,
              0,
              0,
              0,
              this.transformCanvas.sy,
              0,
              0,
              0,
              0,
              1,
              0,
              this.transformCanvas.tx,
              this.transformCanvas.ty,
              0,
              1,
            ]),
              this.ctxTransform(this.transformCanvas.props),
              this.canvasContext.beginPath(),
              this.canvasContext.rect(
                0,
                0,
                this.transformCanvas.w,
                this.transformCanvas.h
              ),
              this.canvasContext.closePath(),
              this.canvasContext.clip(),
              this.renderFrame(this.renderedFrame, !0);
          }),
          (CanvasRendererBase.prototype.destroy = function () {
            var e;
            for (
              this.renderConfig.clearCanvas &&
                this.animationItem.wrapper &&
                (this.animationItem.wrapper.innerText = ""),
                e = (this.layers ? this.layers.length : 0) - 1;
              e >= 0;
              e -= 1
            )
              this.elements[e] &&
                this.elements[e].destroy &&
                this.elements[e].destroy();
            (this.elements.length = 0),
              (this.globalData.canvasContext = null),
              (this.animationItem.container = null),
              (this.destroyed = !0);
          }),
          (CanvasRendererBase.prototype.renderFrame = function (e, t) {
            if (
              (this.renderedFrame !== e ||
                this.renderConfig.clearCanvas !== !0 ||
                t) &&
              !this.destroyed &&
              e !== -1
            ) {
              var r;
              (this.renderedFrame = e),
                (this.globalData.frameNum =
                  e - this.animationItem._isFirstFrame),
                (this.globalData.frameId += 1),
                (this.globalData._mdf = !this.renderConfig.clearCanvas || t),
                (this.globalData.projectInterface.currentFrame = e);
              var n = this.layers.length;
              for (
                this.completeLayers || this.checkLayers(e), r = n - 1;
                r >= 0;
                r -= 1
              )
                (this.completeLayers || this.elements[r]) &&
                  this.elements[r].prepareFrame(e - this.layers[r].st);
              if (this.globalData._mdf) {
                for (
                  this.renderConfig.clearCanvas === !0
                    ? this.canvasContext.clearRect(
                        0,
                        0,
                        this.transformCanvas.w,
                        this.transformCanvas.h
                      )
                    : this.save(),
                    r = n - 1;
                  r >= 0;
                  r -= 1
                )
                  (this.completeLayers || this.elements[r]) &&
                    this.elements[r].renderFrame();
                this.renderConfig.clearCanvas !== !0 && this.restore();
              }
            }
          }),
          (CanvasRendererBase.prototype.buildItem = function (e) {
            var t = this.elements;
            if (!t[e] && this.layers[e].ty !== 99) {
              var r = this.createItem(this.layers[e], this, this.globalData);
              (t[e] = r), r.initExpressions();
            }
          }),
          (CanvasRendererBase.prototype.checkPendingElements = function () {
            for (; this.pendingElements.length; )
              this.pendingElements.pop().checkParenting();
          }),
          (CanvasRendererBase.prototype.hide = function () {
            this.animationItem.container.style.display = "none";
          }),
          (CanvasRendererBase.prototype.show = function () {
            this.animationItem.container.style.display = "block";
          }),
          (CVContextData.prototype.duplicate = function () {
            var e = 2 * this._length,
              t = 0;
            for (t = this._length; t < e; t += 1)
              this.stack[t] = new CanvasContext();
            this._length = e;
          }),
          (CVContextData.prototype.reset = function () {
            (this.cArrPos = 0),
              this.cTr.reset(),
              (this.stack[this.cArrPos].opacity = 1);
          }),
          (CVContextData.prototype.restore = function (e) {
            this.cArrPos -= 1;
            var t,
              r = this.stack[this.cArrPos],
              n = r.transform,
              i = this.cTr.props;
            for (t = 0; t < 16; t += 1) i[t] = n[t];
            if (e) {
              this.nativeContext.restore();
              var a = this.stack[this.cArrPos + 1];
              (this.appliedFillStyle = a.fillStyle),
                (this.appliedStrokeStyle = a.strokeStyle),
                (this.appliedLineWidth = a.lineWidth),
                (this.appliedLineCap = a.lineCap),
                (this.appliedLineJoin = a.lineJoin),
                (this.appliedMiterLimit = a.miterLimit);
            }
            this.nativeContext.setTransform(
              n[0],
              n[1],
              n[4],
              n[5],
              n[12],
              n[13]
            ),
              (e || (r.opacity !== -1 && this.currentOpacity !== r.opacity)) &&
                ((this.nativeContext.globalAlpha = r.opacity),
                (this.currentOpacity = r.opacity)),
              (this.currentFillStyle = r.fillStyle),
              (this.currentStrokeStyle = r.strokeStyle),
              (this.currentLineWidth = r.lineWidth),
              (this.currentLineCap = r.lineCap),
              (this.currentLineJoin = r.lineJoin),
              (this.currentMiterLimit = r.miterLimit);
          }),
          (CVContextData.prototype.save = function (e) {
            e && this.nativeContext.save();
            var t = this.cTr.props;
            this._length <= this.cArrPos && this.duplicate();
            var r,
              n = this.stack[this.cArrPos];
            for (r = 0; r < 16; r += 1) n.transform[r] = t[r];
            this.cArrPos += 1;
            var i = this.stack[this.cArrPos];
            (i.opacity = n.opacity),
              (i.fillStyle = n.fillStyle),
              (i.strokeStyle = n.strokeStyle),
              (i.lineWidth = n.lineWidth),
              (i.lineCap = n.lineCap),
              (i.lineJoin = n.lineJoin),
              (i.miterLimit = n.miterLimit);
          }),
          (CVContextData.prototype.setOpacity = function (e) {
            this.stack[this.cArrPos].opacity = e;
          }),
          (CVContextData.prototype.setContext = function (e) {
            this.nativeContext = e;
          }),
          (CVContextData.prototype.fillStyle = function (e) {
            this.stack[this.cArrPos].fillStyle !== e &&
              ((this.currentFillStyle = e),
              (this.stack[this.cArrPos].fillStyle = e));
          }),
          (CVContextData.prototype.strokeStyle = function (e) {
            this.stack[this.cArrPos].strokeStyle !== e &&
              ((this.currentStrokeStyle = e),
              (this.stack[this.cArrPos].strokeStyle = e));
          }),
          (CVContextData.prototype.lineWidth = function (e) {
            this.stack[this.cArrPos].lineWidth !== e &&
              ((this.currentLineWidth = e),
              (this.stack[this.cArrPos].lineWidth = e));
          }),
          (CVContextData.prototype.lineCap = function (e) {
            this.stack[this.cArrPos].lineCap !== e &&
              ((this.currentLineCap = e),
              (this.stack[this.cArrPos].lineCap = e));
          }),
          (CVContextData.prototype.lineJoin = function (e) {
            this.stack[this.cArrPos].lineJoin !== e &&
              ((this.currentLineJoin = e),
              (this.stack[this.cArrPos].lineJoin = e));
          }),
          (CVContextData.prototype.miterLimit = function (e) {
            this.stack[this.cArrPos].miterLimit !== e &&
              ((this.currentMiterLimit = e),
              (this.stack[this.cArrPos].miterLimit = e));
          }),
          (CVContextData.prototype.transform = function (e) {
            this.transformMat.cloneFromProps(e);
            var t = this.cTr;
            this.transformMat.multiply(t),
              t.cloneFromProps(this.transformMat.props);
            var r = t.props;
            this.nativeContext.setTransform(
              r[0],
              r[1],
              r[4],
              r[5],
              r[12],
              r[13]
            );
          }),
          (CVContextData.prototype.opacity = function (e) {
            var t = this.stack[this.cArrPos].opacity;
            (t *= e < 0 ? 0 : e),
              this.stack[this.cArrPos].opacity !== t &&
                (this.currentOpacity !== e &&
                  ((this.nativeContext.globalAlpha = e),
                  (this.currentOpacity = e)),
                (this.stack[this.cArrPos].opacity = t));
          }),
          (CVContextData.prototype.fill = function (e) {
            this.appliedFillStyle !== this.currentFillStyle &&
              ((this.appliedFillStyle = this.currentFillStyle),
              (this.nativeContext.fillStyle = this.appliedFillStyle)),
              this.nativeContext.fill(e);
          }),
          (CVContextData.prototype.fillRect = function (e, t, r, n) {
            this.appliedFillStyle !== this.currentFillStyle &&
              ((this.appliedFillStyle = this.currentFillStyle),
              (this.nativeContext.fillStyle = this.appliedFillStyle)),
              this.nativeContext.fillRect(e, t, r, n);
          }),
          (CVContextData.prototype.stroke = function () {
            this.appliedStrokeStyle !== this.currentStrokeStyle &&
              ((this.appliedStrokeStyle = this.currentStrokeStyle),
              (this.nativeContext.strokeStyle = this.appliedStrokeStyle)),
              this.appliedLineWidth !== this.currentLineWidth &&
                ((this.appliedLineWidth = this.currentLineWidth),
                (this.nativeContext.lineWidth = this.appliedLineWidth)),
              this.appliedLineCap !== this.currentLineCap &&
                ((this.appliedLineCap = this.currentLineCap),
                (this.nativeContext.lineCap = this.appliedLineCap)),
              this.appliedLineJoin !== this.currentLineJoin &&
                ((this.appliedLineJoin = this.currentLineJoin),
                (this.nativeContext.lineJoin = this.appliedLineJoin)),
              this.appliedMiterLimit !== this.currentMiterLimit &&
                ((this.appliedMiterLimit = this.currentMiterLimit),
                (this.nativeContext.miterLimit = this.appliedMiterLimit)),
              this.nativeContext.stroke();
          }),
          extendPrototype(
            [CanvasRendererBase, ICompElement, CVBaseElement],
            CVCompElement
          ),
          (CVCompElement.prototype.renderInnerContent = function () {
            var e,
              t = this.canvasContext;
            for (
              t.beginPath(),
                t.moveTo(0, 0),
                t.lineTo(this.data.w, 0),
                t.lineTo(this.data.w, this.data.h),
                t.lineTo(0, this.data.h),
                t.lineTo(0, 0),
                t.clip(),
                e = this.layers.length - 1;
              e >= 0;
              e -= 1
            )
              (this.completeLayers || this.elements[e]) &&
                this.elements[e].renderFrame();
          }),
          (CVCompElement.prototype.destroy = function () {
            var e;
            for (e = this.layers.length - 1; e >= 0; e -= 1)
              this.elements[e] && this.elements[e].destroy();
            (this.layers = null), (this.elements = null);
          }),
          (CVCompElement.prototype.createComp = function (e) {
            return new CVCompElement(e, this.globalData, this);
          }),
          extendPrototype([CanvasRendererBase], CanvasRenderer),
          (CanvasRenderer.prototype.createComp = function (e) {
            return new CVCompElement(e, this.globalData, this);
          }),
          (HBaseElement.prototype = {
            checkBlendMode: function () {},
            initRendererElement: function () {
              (this.baseElement = createTag(this.data.tg || "div")),
                this.data.hasMask
                  ? ((this.svgElement = createNS("svg")),
                    (this.layerElement = createNS("g")),
                    (this.maskedElement = this.layerElement),
                    this.svgElement.appendChild(this.layerElement),
                    this.baseElement.appendChild(this.svgElement))
                  : (this.layerElement = this.baseElement),
                styleDiv(this.baseElement);
            },
            createContainerElements: function () {
              (this.renderableEffectsManager = new CVEffects(this)),
                (this.transformedElement = this.baseElement),
                (this.maskedElement = this.layerElement),
                this.data.ln &&
                  this.layerElement.setAttribute("id", this.data.ln),
                this.data.cl &&
                  this.layerElement.setAttribute("class", this.data.cl),
                this.data.bm !== 0 && this.setBlendMode();
            },
            renderElement: function () {
              var e = this.transformedElement
                ? this.transformedElement.style
                : {};
              if (this.finalTransform._matMdf) {
                var t = this.finalTransform.mat.toCSS();
                (e.transform = t), (e.webkitTransform = t);
              }
              this.finalTransform._opMdf &&
                (e.opacity = this.finalTransform.mProp.o.v);
            },
            renderFrame: function () {
              this.data.hd ||
                this.hidden ||
                (this.renderTransform(),
                this.renderRenderable(),
                this.renderElement(),
                this.renderInnerContent(),
                this._isFirstFrame && (this._isFirstFrame = !1));
            },
            destroy: function () {
              (this.layerElement = null),
                (this.transformedElement = null),
                this.matteElement && (this.matteElement = null),
                this.maskManager &&
                  (this.maskManager.destroy(), (this.maskManager = null));
            },
            createRenderableComponents: function () {
              this.maskManager = new MaskElement(
                this.data,
                this,
                this.globalData
              );
            },
            addEffects: function () {},
            setMatte: function () {},
          }),
          (HBaseElement.prototype.getBaseElement =
            SVGBaseElement.prototype.getBaseElement),
          (HBaseElement.prototype.destroyBaseElement =
            HBaseElement.prototype.destroy),
          (HBaseElement.prototype.buildElementParenting =
            BaseRenderer.prototype.buildElementParenting),
          extendPrototype(
            [
              BaseElement,
              TransformElement,
              HBaseElement,
              HierarchyElement,
              FrameElement,
              RenderableDOMElement,
            ],
            HSolidElement
          ),
          (HSolidElement.prototype.createContent = function () {
            var e;
            this.data.hasMask
              ? ((e = createNS("rect")).setAttribute("width", this.data.sw),
                e.setAttribute("height", this.data.sh),
                e.setAttribute("fill", this.data.sc),
                this.svgElement.setAttribute("width", this.data.sw),
                this.svgElement.setAttribute("height", this.data.sh))
              : (((e = createTag("div")).style.width = this.data.sw + "px"),
                (e.style.height = this.data.sh + "px"),
                (e.style.backgroundColor = this.data.sc)),
              this.layerElement.appendChild(e);
          }),
          extendPrototype(
            [
              BaseElement,
              TransformElement,
              HSolidElement,
              SVGShapeElement,
              HBaseElement,
              HierarchyElement,
              FrameElement,
              RenderableElement,
            ],
            HShapeElement
          ),
          (HShapeElement.prototype._renderShapeFrame =
            HShapeElement.prototype.renderInnerContent),
          (HShapeElement.prototype.createContent = function () {
            var e;
            if (((this.baseElement.style.fontSize = 0), this.data.hasMask))
              this.layerElement.appendChild(this.shapesContainer),
                (e = this.svgElement);
            else {
              e = createNS("svg");
              var t = this.comp.data
                ? this.comp.data
                : this.globalData.compSize;
              e.setAttribute("width", t.w),
                e.setAttribute("height", t.h),
                e.appendChild(this.shapesContainer),
                this.layerElement.appendChild(e);
            }
            this.searchShapes(
              this.shapesData,
              this.itemsData,
              this.prevViewData,
              this.shapesContainer,
              0,
              [],
              !0
            ),
              this.filterUniqueShapes(),
              (this.shapeCont = e);
          }),
          (HShapeElement.prototype.getTransformedPoint = function (e, t) {
            var r,
              n = e.length;
            for (r = 0; r < n; r += 1)
              t = e[r].mProps.v.applyToPointArray(t[0], t[1], 0);
            return t;
          }),
          (HShapeElement.prototype.calculateShapeBoundingBox = function (e, t) {
            var r,
              n,
              i,
              a,
              o,
              s = e.sh.v,
              l = e.transformers,
              f = s._length;
            if (!(f <= 1)) {
              for (r = 0; r < f - 1; r += 1)
                (n = this.getTransformedPoint(l, s.v[r])),
                  (i = this.getTransformedPoint(l, s.o[r])),
                  (a = this.getTransformedPoint(l, s.i[r + 1])),
                  (o = this.getTransformedPoint(l, s.v[r + 1])),
                  this.checkBounds(n, i, a, o, t);
              s.c &&
                ((n = this.getTransformedPoint(l, s.v[r])),
                (i = this.getTransformedPoint(l, s.o[r])),
                (a = this.getTransformedPoint(l, s.i[0])),
                (o = this.getTransformedPoint(l, s.v[0])),
                this.checkBounds(n, i, a, o, t));
            }
          }),
          (HShapeElement.prototype.checkBounds = function (e, t, r, n, i) {
            this.getBoundsOfCurve(e, t, r, n);
            var a = this.shapeBoundingBox;
            (i.x = bmMin(a.left, i.x)),
              (i.xMax = bmMax(a.right, i.xMax)),
              (i.y = bmMin(a.top, i.y)),
              (i.yMax = bmMax(a.bottom, i.yMax));
          }),
          (HShapeElement.prototype.shapeBoundingBox = {
            left: 0,
            right: 0,
            top: 0,
            bottom: 0,
          }),
          (HShapeElement.prototype.tempBoundingBox = {
            x: 0,
            xMax: 0,
            y: 0,
            yMax: 0,
            width: 0,
            height: 0,
          }),
          (HShapeElement.prototype.getBoundsOfCurve = function (e, t, r, n) {
            for (
              var i,
                a,
                o,
                s,
                l,
                f,
                u,
                h = [
                  [e[0], n[0]],
                  [e[1], n[1]],
                ],
                m = 0;
              m < 2;
              ++m
            )
              (a = 6 * e[m] - 12 * t[m] + 6 * r[m]),
                (i = -3 * e[m] + 9 * t[m] - 9 * r[m] + 3 * n[m]),
                (o = 3 * t[m] - 3 * e[m]),
                (a |= 0),
                (o |= 0),
                ((i |= 0) === 0 && a === 0) ||
                  (i === 0
                    ? (s = -o / a) > 0 &&
                      s < 1 &&
                      h[m].push(this.calculateF(s, e, t, r, n, m))
                    : (l = a * a - 4 * o * i) >= 0 &&
                      ((f = (-a + bmSqrt(l)) / (2 * i)) > 0 &&
                        f < 1 &&
                        h[m].push(this.calculateF(f, e, t, r, n, m)),
                      (u = (-a - bmSqrt(l)) / (2 * i)) > 0 &&
                        u < 1 &&
                        h[m].push(this.calculateF(u, e, t, r, n, m))));
            (this.shapeBoundingBox.left = bmMin.apply(null, h[0])),
              (this.shapeBoundingBox.top = bmMin.apply(null, h[1])),
              (this.shapeBoundingBox.right = bmMax.apply(null, h[0])),
              (this.shapeBoundingBox.bottom = bmMax.apply(null, h[1]));
          }),
          (HShapeElement.prototype.calculateF = function (e, t, r, n, i, a) {
            return (
              bmPow(1 - e, 3) * t[a] +
              3 * bmPow(1 - e, 2) * e * r[a] +
              3 * (1 - e) * bmPow(e, 2) * n[a] +
              bmPow(e, 3) * i[a]
            );
          }),
          (HShapeElement.prototype.calculateBoundingBox = function (e, t) {
            var r,
              n = e.length;
            for (r = 0; r < n; r += 1)
              e[r] && e[r].sh
                ? this.calculateShapeBoundingBox(e[r], t)
                : e[r] && e[r].it
                ? this.calculateBoundingBox(e[r].it, t)
                : e[r] &&
                  e[r].style &&
                  e[r].w &&
                  this.expandStrokeBoundingBox(e[r].w, t);
          }),
          (HShapeElement.prototype.expandStrokeBoundingBox = function (e, t) {
            var r = 0;
            if (e.keyframes) {
              for (var n = 0; n < e.keyframes.length; n += 1) {
                var i = e.keyframes[n].s;
                i > r && (r = i);
              }
              r *= e.mult;
            } else r = e.v * e.mult;
            (t.x -= r), (t.xMax += r), (t.y -= r), (t.yMax += r);
          }),
          (HShapeElement.prototype.currentBoxContains = function (e) {
            return (
              this.currentBBox.x <= e.x &&
              this.currentBBox.y <= e.y &&
              this.currentBBox.width + this.currentBBox.x >= e.x + e.width &&
              this.currentBBox.height + this.currentBBox.y >= e.y + e.height
            );
          }),
          (HShapeElement.prototype.renderInnerContent = function () {
            if (
              (this._renderShapeFrame(),
              !this.hidden && (this._isFirstFrame || this._mdf))
            ) {
              var e = this.tempBoundingBox,
                t = 999999;
              if (
                ((e.x = t),
                (e.xMax = -t),
                (e.y = t),
                (e.yMax = -t),
                this.calculateBoundingBox(this.itemsData, e),
                (e.width = e.xMax < e.x ? 0 : e.xMax - e.x),
                (e.height = e.yMax < e.y ? 0 : e.yMax - e.y),
                this.currentBoxContains(e))
              )
                return;
              var r = !1;
              if (
                (this.currentBBox.w !== e.width &&
                  ((this.currentBBox.w = e.width),
                  this.shapeCont.setAttribute("width", e.width),
                  (r = !0)),
                this.currentBBox.h !== e.height &&
                  ((this.currentBBox.h = e.height),
                  this.shapeCont.setAttribute("height", e.height),
                  (r = !0)),
                r || this.currentBBox.x !== e.x || this.currentBBox.y !== e.y)
              ) {
                (this.currentBBox.w = e.width),
                  (this.currentBBox.h = e.height),
                  (this.currentBBox.x = e.x),
                  (this.currentBBox.y = e.y),
                  this.shapeCont.setAttribute(
                    "viewBox",
                    this.currentBBox.x +
                      " " +
                      this.currentBBox.y +
                      " " +
                      this.currentBBox.w +
                      " " +
                      this.currentBBox.h
                  );
                var n = this.shapeCont.style,
                  i =
                    "translate(" +
                    this.currentBBox.x +
                    "px," +
                    this.currentBBox.y +
                    "px)";
                (n.transform = i), (n.webkitTransform = i);
              }
            }
          }),
          extendPrototype(
            [
              BaseElement,
              TransformElement,
              HBaseElement,
              HierarchyElement,
              FrameElement,
              RenderableDOMElement,
              ITextElement,
            ],
            HTextElement
          ),
          (HTextElement.prototype.createContent = function () {
            if (((this.isMasked = this.checkMasks()), this.isMasked)) {
              (this.renderType = "svg"),
                (this.compW = this.comp.data.w),
                (this.compH = this.comp.data.h),
                this.svgElement.setAttribute("width", this.compW),
                this.svgElement.setAttribute("height", this.compH);
              var e = createNS("g");
              this.maskedElement.appendChild(e), (this.innerElem = e);
            } else
              (this.renderType = "html"), (this.innerElem = this.layerElement);
            this.checkParenting();
          }),
          (HTextElement.prototype.buildNewText = function () {
            var e = this.textProperty.currentData;
            this.renderedLetters = createSizedArray(e.l ? e.l.length : 0);
            var t = this.innerElem.style,
              r = e.fc ? this.buildColor(e.fc) : "rgba(0,0,0,0)";
            (t.fill = r),
              (t.color = r),
              e.sc &&
                ((t.stroke = this.buildColor(e.sc)),
                (t.strokeWidth = e.sw + "px"));
            var n,
              i,
              a = this.globalData.fontManager.getFontByName(e.f);
            if (!this.globalData.fontManager.chars)
              if (
                ((t.fontSize = e.finalSize + "px"),
                (t.lineHeight = e.finalSize + "px"),
                a.fClass)
              )
                this.innerElem.className = a.fClass;
              else {
                t.fontFamily = a.fFamily;
                var o = e.fWeight,
                  s = e.fStyle;
                (t.fontStyle = s), (t.fontWeight = o);
              }
            var l,
              f,
              u,
              h = e.l;
            i = h.length;
            var m,
              d = this.mHelper,
              p = "",
              g = 0;
            for (n = 0; n < i; n += 1) {
              if (
                (this.globalData.fontManager.chars
                  ? (this.textPaths[g]
                      ? (l = this.textPaths[g])
                      : ((l = createNS("path")).setAttribute(
                          "stroke-linecap",
                          lineCapEnum[1]
                        ),
                        l.setAttribute("stroke-linejoin", lineJoinEnum[2]),
                        l.setAttribute("stroke-miterlimit", "4")),
                    this.isMasked ||
                      (this.textSpans[g]
                        ? (u = (f = this.textSpans[g]).children[0])
                        : (((f = createTag("div")).style.lineHeight = 0),
                          (u = createNS("svg")).appendChild(l),
                          styleDiv(f))))
                  : this.isMasked
                  ? (l = this.textPaths[g]
                      ? this.textPaths[g]
                      : createNS("text"))
                  : this.textSpans[g]
                  ? ((f = this.textSpans[g]), (l = this.textPaths[g]))
                  : (styleDiv((f = createTag("span"))),
                    styleDiv((l = createTag("span"))),
                    f.appendChild(l)),
                this.globalData.fontManager.chars)
              ) {
                var c,
                  v = this.globalData.fontManager.getCharData(
                    e.finalText[n],
                    a.fStyle,
                    this.globalData.fontManager.getFontByName(e.f).fFamily
                  );
                if (
                  ((c = v ? v.data : null),
                  d.reset(),
                  c &&
                    c.shapes &&
                    c.shapes.length &&
                    ((m = c.shapes[0].it),
                    d.scale(e.finalSize / 100, e.finalSize / 100),
                    (p = this.createPathShape(d, m)),
                    l.setAttribute("d", p)),
                  this.isMasked)
                )
                  this.innerElem.appendChild(l);
                else {
                  if ((this.innerElem.appendChild(f), c && c.shapes)) {
                    document.body.appendChild(u);
                    var y = u.getBBox();
                    u.setAttribute("width", y.width + 2),
                      u.setAttribute("height", y.height + 2),
                      u.setAttribute(
                        "viewBox",
                        y.x -
                          1 +
                          " " +
                          (y.y - 1) +
                          " " +
                          (y.width + 2) +
                          " " +
                          (y.height + 2)
                      );
                    var b = u.style,
                      x = "translate(" + (y.x - 1) + "px," + (y.y - 1) + "px)";
                    (b.transform = x),
                      (b.webkitTransform = x),
                      (h[n].yOffset = y.y - 1);
                  } else
                    u.setAttribute("width", 1), u.setAttribute("height", 1);
                  f.appendChild(u);
                }
              } else if (
                ((l.textContent = h[n].val),
                l.setAttributeNS(
                  "http://www.w3.org/XML/1998/namespace",
                  "xml:space",
                  "preserve"
                ),
                this.isMasked)
              )
                this.innerElem.appendChild(l);
              else {
                this.innerElem.appendChild(f);
                var S = l.style,
                  T = "translate3d(0," + -e.finalSize / 1.2 + "px,0)";
                (S.transform = T), (S.webkitTransform = T);
              }
              this.isMasked ? (this.textSpans[g] = l) : (this.textSpans[g] = f),
                (this.textSpans[g].style.display = "block"),
                (this.textPaths[g] = l),
                (g += 1);
            }
            for (; g < this.textSpans.length; )
              (this.textSpans[g].style.display = "none"), (g += 1);
          }),
          (HTextElement.prototype.renderInnerContent = function () {
            var e;
            if ((this.validateText(), this.data.singleShape)) {
              if (!this._isFirstFrame && !this.lettersChangedFlag) return;
              if (this.isMasked && this.finalTransform._matMdf) {
                this.svgElement.setAttribute(
                  "viewBox",
                  -this.finalTransform.mProp.p.v[0] +
                    " " +
                    -this.finalTransform.mProp.p.v[1] +
                    " " +
                    this.compW +
                    " " +
                    this.compH
                ),
                  (e = this.svgElement.style);
                var t =
                  "translate(" +
                  -this.finalTransform.mProp.p.v[0] +
                  "px," +
                  -this.finalTransform.mProp.p.v[1] +
                  "px)";
                (e.transform = t), (e.webkitTransform = t);
              }
            }
            if (
              (this.textAnimator.getMeasures(
                this.textProperty.currentData,
                this.lettersChangedFlag
              ),
              this.lettersChangedFlag || this.textAnimator.lettersChangedFlag)
            ) {
              var r,
                n,
                i,
                a,
                o,
                s = 0,
                l = this.textAnimator.renderedLetters,
                f = this.textProperty.currentData.l;
              for (n = f.length, r = 0; r < n; r += 1)
                f[r].n
                  ? (s += 1)
                  : ((a = this.textSpans[r]),
                    (o = this.textPaths[r]),
                    (i = l[s]),
                    (s += 1),
                    i._mdf.m &&
                      (this.isMasked
                        ? a.setAttribute("transform", i.m)
                        : ((a.style.webkitTransform = i.m),
                          (a.style.transform = i.m))),
                    (a.style.opacity = i.o),
                    i.sw && i._mdf.sw && o.setAttribute("stroke-width", i.sw),
                    i.sc && i._mdf.sc && o.setAttribute("stroke", i.sc),
                    i.fc &&
                      i._mdf.fc &&
                      (o.setAttribute("fill", i.fc), (o.style.color = i.fc)));
              if (
                this.innerElem.getBBox &&
                !this.hidden &&
                (this._isFirstFrame || this._mdf)
              ) {
                var u = this.innerElem.getBBox();
                if (
                  (this.currentBBox.w !== u.width &&
                    ((this.currentBBox.w = u.width),
                    this.svgElement.setAttribute("width", u.width)),
                  this.currentBBox.h !== u.height &&
                    ((this.currentBBox.h = u.height),
                    this.svgElement.setAttribute("height", u.height)),
                  this.currentBBox.w !== u.width + 2 ||
                    this.currentBBox.h !== u.height + 2 ||
                    this.currentBBox.x !== u.x - 1 ||
                    this.currentBBox.y !== u.y - 1)
                ) {
                  (this.currentBBox.w = u.width + 2),
                    (this.currentBBox.h = u.height + 2),
                    (this.currentBBox.x = u.x - 1),
                    (this.currentBBox.y = u.y - 1),
                    this.svgElement.setAttribute(
                      "viewBox",
                      this.currentBBox.x +
                        " " +
                        this.currentBBox.y +
                        " " +
                        this.currentBBox.w +
                        " " +
                        this.currentBBox.h
                    ),
                    (e = this.svgElement.style);
                  var h =
                    "translate(" +
                    this.currentBBox.x +
                    "px," +
                    this.currentBBox.y +
                    "px)";
                  (e.transform = h), (e.webkitTransform = h);
                }
              }
            }
          }),
          extendPrototype(
            [BaseElement, FrameElement, HierarchyElement],
            HCameraElement
          ),
          (HCameraElement.prototype.setup = function () {
            var e,
              t,
              r,
              n,
              i = this.comp.threeDElements.length;
            for (e = 0; e < i; e += 1)
              if ((t = this.comp.threeDElements[e]).type === "3d") {
                (r = t.perspectiveElem.style), (n = t.container.style);
                var a = this.pe.v + "px",
                  o = "0px 0px 0px",
                  s = "matrix3d(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)";
                (r.perspective = a),
                  (r.webkitPerspective = a),
                  (n.transformOrigin = o),
                  (n.mozTransformOrigin = o),
                  (n.webkitTransformOrigin = o),
                  (r.transform = s),
                  (r.webkitTransform = s);
              }
          }),
          (HCameraElement.prototype.createElements = function () {}),
          (HCameraElement.prototype.hide = function () {}),
          (HCameraElement.prototype.renderFrame = function () {
            var e,
              t,
              r = this._isFirstFrame;
            if (this.hierarchy)
              for (t = this.hierarchy.length, e = 0; e < t; e += 1)
                r = this.hierarchy[e].finalTransform.mProp._mdf || r;
            if (
              r ||
              this.pe._mdf ||
              (this.p && this.p._mdf) ||
              (this.px && (this.px._mdf || this.py._mdf || this.pz._mdf)) ||
              this.rx._mdf ||
              this.ry._mdf ||
              this.rz._mdf ||
              this.or._mdf ||
              (this.a && this.a._mdf)
            ) {
              if ((this.mat.reset(), this.hierarchy))
                for (e = t = this.hierarchy.length - 1; e >= 0; e -= 1) {
                  var n = this.hierarchy[e].finalTransform.mProp;
                  this.mat.translate(-n.p.v[0], -n.p.v[1], n.p.v[2]),
                    this.mat
                      .rotateX(-n.or.v[0])
                      .rotateY(-n.or.v[1])
                      .rotateZ(n.or.v[2]),
                    this.mat.rotateX(-n.rx.v).rotateY(-n.ry.v).rotateZ(n.rz.v),
                    this.mat.scale(1 / n.s.v[0], 1 / n.s.v[1], 1 / n.s.v[2]),
                    this.mat.translate(n.a.v[0], n.a.v[1], n.a.v[2]);
                }
              if (
                (this.p
                  ? this.mat.translate(-this.p.v[0], -this.p.v[1], this.p.v[2])
                  : this.mat.translate(-this.px.v, -this.py.v, this.pz.v),
                this.a)
              ) {
                var i;
                i = this.p
                  ? [
                      this.p.v[0] - this.a.v[0],
                      this.p.v[1] - this.a.v[1],
                      this.p.v[2] - this.a.v[2],
                    ]
                  : [
                      this.px.v - this.a.v[0],
                      this.py.v - this.a.v[1],
                      this.pz.v - this.a.v[2],
                    ];
                var a = Math.sqrt(
                    Math.pow(i[0], 2) + Math.pow(i[1], 2) + Math.pow(i[2], 2)
                  ),
                  o = [i[0] / a, i[1] / a, i[2] / a],
                  s = Math.sqrt(o[2] * o[2] + o[0] * o[0]),
                  l = Math.atan2(o[1], s),
                  f = Math.atan2(o[0], -o[2]);
                this.mat.rotateY(f).rotateX(-l);
              }
              this.mat
                .rotateX(-this.rx.v)
                .rotateY(-this.ry.v)
                .rotateZ(this.rz.v),
                this.mat
                  .rotateX(-this.or.v[0])
                  .rotateY(-this.or.v[1])
                  .rotateZ(this.or.v[2]),
                this.mat.translate(
                  this.globalData.compSize.w / 2,
                  this.globalData.compSize.h / 2,
                  0
                ),
                this.mat.translate(0, 0, this.pe.v);
              var u = !this._prevMat.equals(this.mat);
              if ((u || this.pe._mdf) && this.comp.threeDElements) {
                var h, m, d;
                for (t = this.comp.threeDElements.length, e = 0; e < t; e += 1)
                  if ((h = this.comp.threeDElements[e]).type === "3d") {
                    if (u) {
                      var p = this.mat.toCSS();
                      ((d = h.container.style).transform = p),
                        (d.webkitTransform = p);
                    }
                    this.pe._mdf &&
                      (((m = h.perspectiveElem.style).perspective =
                        this.pe.v + "px"),
                      (m.webkitPerspective = this.pe.v + "px"));
                  }
                this.mat.clone(this._prevMat);
              }
            }
            this._isFirstFrame = !1;
          }),
          (HCameraElement.prototype.prepareFrame = function (e) {
            this.prepareProperties(e, !0);
          }),
          (HCameraElement.prototype.destroy = function () {}),
          (HCameraElement.prototype.getBaseElement = function () {
            return null;
          }),
          extendPrototype(
            [
              BaseElement,
              TransformElement,
              HBaseElement,
              HSolidElement,
              HierarchyElement,
              FrameElement,
              RenderableElement,
            ],
            HImageElement
          ),
          (HImageElement.prototype.createContent = function () {
            var e = this.globalData.getAssetsPath(this.assetData),
              t = new Image();
            this.data.hasMask
              ? ((this.imageElem = createNS("image")),
                this.imageElem.setAttribute("width", this.assetData.w + "px"),
                this.imageElem.setAttribute("height", this.assetData.h + "px"),
                this.imageElem.setAttributeNS(
                  "http://www.w3.org/1999/xlink",
                  "href",
                  e
                ),
                this.layerElement.appendChild(this.imageElem),
                this.baseElement.setAttribute("width", this.assetData.w),
                this.baseElement.setAttribute("height", this.assetData.h))
              : this.layerElement.appendChild(t),
              (t.crossOrigin = "anonymous"),
              (t.src = e),
              this.data.ln && this.baseElement.setAttribute("id", this.data.ln);
          }),
          extendPrototype([BaseRenderer], HybridRendererBase),
          (HybridRendererBase.prototype.buildItem =
            SVGRenderer.prototype.buildItem),
          (HybridRendererBase.prototype.checkPendingElements = function () {
            for (; this.pendingElements.length; )
              this.pendingElements.pop().checkParenting();
          }),
          (HybridRendererBase.prototype.appendElementInPos = function (e, t) {
            var r = e.getBaseElement();
            if (r) {
              var n = this.layers[t];
              if (n.ddd && this.supports3d) this.addTo3dContainer(r, t);
              else if (this.threeDElements) this.addTo3dContainer(r, t);
              else {
                for (var i, a, o = 0; o < t; )
                  this.elements[o] &&
                    this.elements[o] !== !0 &&
                    this.elements[o].getBaseElement &&
                    ((a = this.elements[o]),
                    (i =
                      (this.layers[o].ddd
                        ? this.getThreeDContainerByPos(o)
                        : a.getBaseElement()) || i)),
                    (o += 1);
                i
                  ? (n.ddd && this.supports3d) ||
                    this.layerElement.insertBefore(r, i)
                  : (n.ddd && this.supports3d) ||
                    this.layerElement.appendChild(r);
              }
            }
          }),
          (HybridRendererBase.prototype.createShape = function (e) {
            return this.supports3d
              ? new HShapeElement(e, this.globalData, this)
              : new SVGShapeElement(e, this.globalData, this);
          }),
          (HybridRendererBase.prototype.createText = function (e) {
            return this.supports3d
              ? new HTextElement(e, this.globalData, this)
              : new SVGTextLottieElement(e, this.globalData, this);
          }),
          (HybridRendererBase.prototype.createCamera = function (e) {
            return (
              (this.camera = new HCameraElement(e, this.globalData, this)),
              this.camera
            );
          }),
          (HybridRendererBase.prototype.createImage = function (e) {
            return this.supports3d
              ? new HImageElement(e, this.globalData, this)
              : new IImageElement(e, this.globalData, this);
          }),
          (HybridRendererBase.prototype.createSolid = function (e) {
            return this.supports3d
              ? new HSolidElement(e, this.globalData, this)
              : new ISolidElement(e, this.globalData, this);
          }),
          (HybridRendererBase.prototype.createNull =
            SVGRenderer.prototype.createNull),
          (HybridRendererBase.prototype.getThreeDContainerByPos = function (e) {
            for (var t = 0, r = this.threeDElements.length; t < r; ) {
              if (
                this.threeDElements[t].startPos <= e &&
                this.threeDElements[t].endPos >= e
              )
                return this.threeDElements[t].perspectiveElem;
              t += 1;
            }
            return null;
          }),
          (HybridRendererBase.prototype.createThreeDContainer = function (
            e,
            t
          ) {
            var r,
              n,
              i = createTag("div");
            styleDiv(i);
            var a = createTag("div");
            if ((styleDiv(a), t === "3d")) {
              ((r = i.style).width = this.globalData.compSize.w + "px"),
                (r.height = this.globalData.compSize.h + "px");
              var o = "50% 50%";
              (r.webkitTransformOrigin = o),
                (r.mozTransformOrigin = o),
                (r.transformOrigin = o);
              var s = "matrix3d(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)";
              ((n = a.style).transform = s), (n.webkitTransform = s);
            }
            i.appendChild(a);
            var l = {
              container: a,
              perspectiveElem: i,
              startPos: e,
              endPos: e,
              type: t,
            };
            return this.threeDElements.push(l), l;
          }),
          (HybridRendererBase.prototype.build3dContainers = function () {
            var e,
              t,
              r = this.layers.length,
              n = "";
            for (e = 0; e < r; e += 1)
              this.layers[e].ddd && this.layers[e].ty !== 3
                ? (n !== "3d" &&
                    ((n = "3d"), (t = this.createThreeDContainer(e, "3d"))),
                  (t.endPos = Math.max(t.endPos, e)))
                : (n !== "2d" &&
                    ((n = "2d"), (t = this.createThreeDContainer(e, "2d"))),
                  (t.endPos = Math.max(t.endPos, e)));
            for (e = (r = this.threeDElements.length) - 1; e >= 0; e -= 1)
              this.resizerElem.appendChild(
                this.threeDElements[e].perspectiveElem
              );
          }),
          (HybridRendererBase.prototype.addTo3dContainer = function (e, t) {
            for (var r = 0, n = this.threeDElements.length; r < n; ) {
              if (t <= this.threeDElements[r].endPos) {
                for (var i, a = this.threeDElements[r].startPos; a < t; )
                  this.elements[a] &&
                    this.elements[a].getBaseElement &&
                    (i = this.elements[a].getBaseElement()),
                    (a += 1);
                i
                  ? this.threeDElements[r].container.insertBefore(e, i)
                  : this.threeDElements[r].container.appendChild(e);
                break;
              }
              r += 1;
            }
          }),
          (HybridRendererBase.prototype.configAnimation = function (e) {
            var t = createTag("div"),
              r = this.animationItem.wrapper,
              n = t.style;
            (n.width = e.w + "px"),
              (n.height = e.h + "px"),
              (this.resizerElem = t),
              styleDiv(t),
              (n.transformStyle = "flat"),
              (n.mozTransformStyle = "flat"),
              (n.webkitTransformStyle = "flat"),
              this.renderConfig.className &&
                t.setAttribute("class", this.renderConfig.className),
              r.appendChild(t),
              (n.overflow = "hidden");
            var i = createNS("svg");
            i.setAttribute("width", "1"),
              i.setAttribute("height", "1"),
              styleDiv(i),
              this.resizerElem.appendChild(i);
            var a = createNS("defs");
            i.appendChild(a),
              (this.data = e),
              this.setupGlobalData(e, i),
              (this.globalData.defs = a),
              (this.layers = e.layers),
              (this.layerElement = this.resizerElem),
              this.build3dContainers(),
              this.updateContainerSize();
          }),
          (HybridRendererBase.prototype.destroy = function () {
            var e;
            this.animationItem.wrapper &&
              (this.animationItem.wrapper.innerText = ""),
              (this.animationItem.container = null),
              (this.globalData.defs = null);
            var t = this.layers ? this.layers.length : 0;
            for (e = 0; e < t; e += 1)
              this.elements[e] &&
                this.elements[e].destroy &&
                this.elements[e].destroy();
            (this.elements.length = 0),
              (this.destroyed = !0),
              (this.animationItem = null);
          }),
          (HybridRendererBase.prototype.updateContainerSize = function () {
            var e,
              t,
              r,
              n,
              i = this.animationItem.wrapper.offsetWidth,
              a = this.animationItem.wrapper.offsetHeight,
              o = i / a;
            this.globalData.compSize.w / this.globalData.compSize.h > o
              ? ((e = i / this.globalData.compSize.w),
                (t = i / this.globalData.compSize.w),
                (r = 0),
                (n =
                  (a -
                    this.globalData.compSize.h *
                      (i / this.globalData.compSize.w)) /
                  2))
              : ((e = a / this.globalData.compSize.h),
                (t = a / this.globalData.compSize.h),
                (r =
                  (i -
                    this.globalData.compSize.w *
                      (a / this.globalData.compSize.h)) /
                  2),
                (n = 0));
            var s = this.resizerElem.style;
            (s.webkitTransform =
              "matrix3d(" +
              e +
              ",0,0,0,0," +
              t +
              ",0,0,0,0,1,0," +
              r +
              "," +
              n +
              ",0,1)"),
              (s.transform = s.webkitTransform);
          }),
          (HybridRendererBase.prototype.renderFrame =
            SVGRenderer.prototype.renderFrame),
          (HybridRendererBase.prototype.hide = function () {
            this.resizerElem.style.display = "none";
          }),
          (HybridRendererBase.prototype.show = function () {
            this.resizerElem.style.display = "block";
          }),
          (HybridRendererBase.prototype.initItems = function () {
            if ((this.buildAllItems(), this.camera)) this.camera.setup();
            else {
              var e,
                t = this.globalData.compSize.w,
                r = this.globalData.compSize.h,
                n = this.threeDElements.length;
              for (e = 0; e < n; e += 1) {
                var i = this.threeDElements[e].perspectiveElem.style;
                (i.webkitPerspective =
                  Math.sqrt(Math.pow(t, 2) + Math.pow(r, 2)) + "px"),
                  (i.perspective = i.webkitPerspective);
              }
            }
          }),
          (HybridRendererBase.prototype.searchExtraCompositions = function (e) {
            var t,
              r = e.length,
              n = createTag("div");
            for (t = 0; t < r; t += 1)
              if (e[t].xt) {
                var i = this.createComp(e[t], n, this.globalData.comp, null);
                i.initExpressions(),
                  this.globalData.projectInterface.registerComposition(i);
              }
          }),
          extendPrototype(
            [HybridRendererBase, ICompElement, HBaseElement],
            HCompElement
          ),
          (HCompElement.prototype._createBaseContainerElements =
            HCompElement.prototype.createContainerElements),
          (HCompElement.prototype.createContainerElements = function () {
            this._createBaseContainerElements(),
              this.data.hasMask
                ? (this.svgElement.setAttribute("width", this.data.w),
                  this.svgElement.setAttribute("height", this.data.h),
                  (this.transformedElement = this.baseElement))
                : (this.transformedElement = this.layerElement);
          }),
          (HCompElement.prototype.addTo3dContainer = function (e, t) {
            for (var r, n = 0; n < t; )
              this.elements[n] &&
                this.elements[n].getBaseElement &&
                (r = this.elements[n].getBaseElement()),
                (n += 1);
            r
              ? this.layerElement.insertBefore(e, r)
              : this.layerElement.appendChild(e);
          }),
          (HCompElement.prototype.createComp = function (e) {
            return this.supports3d
              ? new HCompElement(e, this.globalData, this)
              : new SVGCompElement(e, this.globalData, this);
          }),
          extendPrototype([HybridRendererBase], HybridRenderer),
          (HybridRenderer.prototype.createComp = function (e) {
            return this.supports3d
              ? new HCompElement(e, this.globalData, this)
              : new SVGCompElement(e, this.globalData, this);
          });
        var CompExpressionInterface = function (e) {
          function t(r) {
            for (var n = 0, i = e.layers.length; n < i; ) {
              if (e.layers[n].nm === r || e.layers[n].ind === r)
                return e.elements[n].layerInterface;
              n += 1;
            }
            return null;
          }
          return (
            Object.defineProperty(t, "_name", { value: e.data.nm }),
            (t.layer = t),
            (t.pixelAspect = 1),
            (t.height = e.data.h || e.globalData.compSize.h),
            (t.width = e.data.w || e.globalData.compSize.w),
            (t.pixelAspect = 1),
            (t.frameDuration = 1 / e.globalData.frameRate),
            (t.displayStartTime = 0),
            (t.numLayers = e.layers.length),
            t
          );
        };
        function _typeof$2(e) {
          return (
            (_typeof$2 =
              typeof Symbol == "function" && typeof Symbol.iterator == "symbol"
                ? function (t) {
                    return typeof t;
                  }
                : function (t) {
                    return t &&
                      typeof Symbol == "function" &&
                      t.constructor === Symbol &&
                      t !== Symbol.prototype
                      ? "symbol"
                      : typeof t;
                  }),
            _typeof$2(e)
          );
        }
        function seedRandom(e, t) {
          var r,
            n = this,
            i = 256,
            a = t.pow(i, 6),
            o = t.pow(2, 52),
            s = 2 * o,
            l = 255;
          function f(p) {
            var g,
              c = p.length,
              v = this,
              y = 0,
              b = (v.i = v.j = 0),
              x = (v.S = []);
            for (c || (p = [c++]); y < i; ) x[y] = y++;
            for (y = 0; y < i; y++)
              (x[y] = x[(b = l & (b + p[y % c] + (g = x[y])))]), (x[b] = g);
            v.g = function (S) {
              for (var T, I = 0, P = v.i, L = v.j, M = v.S; S--; )
                (T = M[(P = l & (P + 1))]),
                  (I =
                    I * i +
                    M[l & ((M[P] = M[(L = l & (L + T))]) + (M[L] = T))]);
              return (v.i = P), (v.j = L), I;
            };
          }
          function u(p, g) {
            return (g.i = p.i), (g.j = p.j), (g.S = p.S.slice()), g;
          }
          function h(p, g) {
            var c,
              v = [],
              y = _typeof$2(p);
            if (g && y == "object")
              for (c in p)
                try {
                  v.push(h(p[c], g - 1));
                } catch {}
            return v.length ? v : y == "string" ? p : p + "\0";
          }
          function m(p, g) {
            for (var c, v = p + "", y = 0; y < v.length; )
              g[l & y] = l & ((c ^= 19 * g[l & y]) + v.charCodeAt(y++));
            return d(g);
          }
          function d(p) {
            return String.fromCharCode.apply(0, p);
          }
          (t.seedrandom = function (p, g, c) {
            var v = [],
              y = m(
                h(
                  (g = g === !0 ? { entropy: !0 } : g || {}).entropy
                    ? [p, d(e)]
                    : p === null
                    ? (function () {
                        try {
                          var S = new Uint8Array(i);
                          return (
                            (n.crypto || n.msCrypto).getRandomValues(S), d(S)
                          );
                        } catch {
                          var T = n.navigator,
                            I = T && T.plugins;
                          return [+new Date(), n, I, n.screen, d(e)];
                        }
                      })()
                    : p,
                  3
                ),
                v
              ),
              b = new f(v),
              x = function () {
                for (var S = b.g(6), T = a, I = 0; S < o; )
                  (S = (S + I) * i), (T *= i), (I = b.g(1));
                for (; S >= s; ) (S /= 2), (T /= 2), (I >>>= 1);
                return (S + I) / T;
              };
            return (
              (x.int32 = function () {
                return 0 | b.g(4);
              }),
              (x.quick = function () {
                return b.g(4) / 4294967296;
              }),
              (x.double = x),
              m(d(b.S), e),
              (
                g.pass ||
                c ||
                function (S, T, I, P) {
                  return (
                    P &&
                      (P.S && u(P, b),
                      (S.state = function () {
                        return u(b, {});
                      })),
                    I ? ((t.random = S), T) : S
                  );
                }
              )(x, y, "global" in g ? g.global : this == t, g.state)
            );
          }),
            m(t.random(), e);
        }
        function initialize$2(e) {
          seedRandom([], e);
        }
        var propTypes = { SHAPE: "shape" };
        function _typeof$1(e) {
          return (
            (_typeof$1 =
              typeof Symbol == "function" && typeof Symbol.iterator == "symbol"
                ? function (t) {
                    return typeof t;
                  }
                : function (t) {
                    return t &&
                      typeof Symbol == "function" &&
                      t.constructor === Symbol &&
                      t !== Symbol.prototype
                      ? "symbol"
                      : typeof t;
                  }),
            _typeof$1(e)
          );
        }
        var ExpressionManager = (function () {
            var ob = {},
              Math = BMMath,
              window = null,
              document = null,
              XMLHttpRequest = null,
              fetch = null,
              frames = null,
              _lottieGlobal = {};
            function resetFrame() {
              _lottieGlobal = {};
            }
            function $bm_isInstanceOfArray(e) {
              return e.constructor === Array || e.constructor === Float32Array;
            }
            function isNumerable(e, t) {
              return (
                e === "number" ||
                t instanceof Number ||
                e === "boolean" ||
                e === "string"
              );
            }
            function $bm_neg(e) {
              var t = _typeof$1(e);
              if (t === "number" || e instanceof Number || t === "boolean")
                return -e;
              if ($bm_isInstanceOfArray(e)) {
                var r,
                  n = e.length,
                  i = [];
                for (r = 0; r < n; r += 1) i[r] = -e[r];
                return i;
              }
              return e.propType ? e.v : -e;
            }
            initialize$2(BMMath);
            var easeInBez = BezierFactory.getBezierEasing(
                0.333,
                0,
                0.833,
                0.833,
                "easeIn"
              ).get,
              easeOutBez = BezierFactory.getBezierEasing(
                0.167,
                0.167,
                0.667,
                1,
                "easeOut"
              ).get,
              easeInOutBez = BezierFactory.getBezierEasing(
                0.33,
                0,
                0.667,
                1,
                "easeInOut"
              ).get;
            function sum(e, t) {
              var r = _typeof$1(e),
                n = _typeof$1(t);
              if (
                (isNumerable(r, e) && isNumerable(n, t)) ||
                r === "string" ||
                n === "string"
              )
                return e + t;
              if ($bm_isInstanceOfArray(e) && isNumerable(n, t))
                return ((e = e.slice(0))[0] += t), e;
              if (isNumerable(r, e) && $bm_isInstanceOfArray(t))
                return ((t = t.slice(0))[0] = e + t[0]), t;
              if ($bm_isInstanceOfArray(e) && $bm_isInstanceOfArray(t)) {
                for (
                  var i = 0, a = e.length, o = t.length, s = [];
                  i < a || i < o;

                )
                  (typeof e[i] == "number" || e[i] instanceof Number) &&
                  (typeof t[i] == "number" || t[i] instanceof Number)
                    ? (s[i] = e[i] + t[i])
                    : (s[i] = t[i] === void 0 ? e[i] : e[i] || t[i]),
                    (i += 1);
                return s;
              }
              return 0;
            }
            var add = sum;
            function sub(e, t) {
              var r = _typeof$1(e),
                n = _typeof$1(t);
              if (isNumerable(r, e) && isNumerable(n, t))
                return (
                  r === "string" && (e = parseInt(e, 10)),
                  n === "string" && (t = parseInt(t, 10)),
                  e - t
                );
              if ($bm_isInstanceOfArray(e) && isNumerable(n, t))
                return ((e = e.slice(0))[0] -= t), e;
              if (isNumerable(r, e) && $bm_isInstanceOfArray(t))
                return ((t = t.slice(0))[0] = e - t[0]), t;
              if ($bm_isInstanceOfArray(e) && $bm_isInstanceOfArray(t)) {
                for (
                  var i = 0, a = e.length, o = t.length, s = [];
                  i < a || i < o;

                )
                  (typeof e[i] == "number" || e[i] instanceof Number) &&
                  (typeof t[i] == "number" || t[i] instanceof Number)
                    ? (s[i] = e[i] - t[i])
                    : (s[i] = t[i] === void 0 ? e[i] : e[i] || t[i]),
                    (i += 1);
                return s;
              }
              return 0;
            }
            function mul(e, t) {
              var r,
                n,
                i,
                a = _typeof$1(e),
                o = _typeof$1(t);
              if (isNumerable(a, e) && isNumerable(o, t)) return e * t;
              if ($bm_isInstanceOfArray(e) && isNumerable(o, t)) {
                for (
                  i = e.length, r = createTypedArray("float32", i), n = 0;
                  n < i;
                  n += 1
                )
                  r[n] = e[n] * t;
                return r;
              }
              if (isNumerable(a, e) && $bm_isInstanceOfArray(t)) {
                for (
                  i = t.length, r = createTypedArray("float32", i), n = 0;
                  n < i;
                  n += 1
                )
                  r[n] = e * t[n];
                return r;
              }
              return 0;
            }
            function div(e, t) {
              var r,
                n,
                i,
                a = _typeof$1(e),
                o = _typeof$1(t);
              if (isNumerable(a, e) && isNumerable(o, t)) return e / t;
              if ($bm_isInstanceOfArray(e) && isNumerable(o, t)) {
                for (
                  i = e.length, r = createTypedArray("float32", i), n = 0;
                  n < i;
                  n += 1
                )
                  r[n] = e[n] / t;
                return r;
              }
              if (isNumerable(a, e) && $bm_isInstanceOfArray(t)) {
                for (
                  i = t.length, r = createTypedArray("float32", i), n = 0;
                  n < i;
                  n += 1
                )
                  r[n] = e / t[n];
                return r;
              }
              return 0;
            }
            function mod(e, t) {
              return (
                typeof e == "string" && (e = parseInt(e, 10)),
                typeof t == "string" && (t = parseInt(t, 10)),
                e % t
              );
            }
            var $bm_sum = sum,
              $bm_sub = sub,
              $bm_mul = mul,
              $bm_div = div,
              $bm_mod = mod;
            function clamp(e, t, r) {
              if (t > r) {
                var n = r;
                (r = t), (t = n);
              }
              return Math.min(Math.max(e, t), r);
            }
            function radiansToDegrees(e) {
              return e / degToRads;
            }
            var radians_to_degrees = radiansToDegrees;
            function degreesToRadians(e) {
              return e * degToRads;
            }
            var degrees_to_radians = radiansToDegrees,
              helperLengthArray = [0, 0, 0, 0, 0, 0];
            function length(e, t) {
              if (typeof e == "number" || e instanceof Number)
                return (t = t || 0), Math.abs(e - t);
              var r;
              t || (t = helperLengthArray);
              var n = Math.min(e.length, t.length),
                i = 0;
              for (r = 0; r < n; r += 1) i += Math.pow(t[r] - e[r], 2);
              return Math.sqrt(i);
            }
            function normalize(e) {
              return div(e, length(e));
            }
            function rgbToHsl(e) {
              var t,
                r,
                n = e[0],
                i = e[1],
                a = e[2],
                o = Math.max(n, i, a),
                s = Math.min(n, i, a),
                l = (o + s) / 2;
              if (o === s) (t = 0), (r = 0);
              else {
                var f = o - s;
                switch (((r = l > 0.5 ? f / (2 - o - s) : f / (o + s)), o)) {
                  case n:
                    t = (i - a) / f + (i < a ? 6 : 0);
                    break;
                  case i:
                    t = (a - n) / f + 2;
                    break;
                  case a:
                    t = (n - i) / f + 4;
                }
                t /= 6;
              }
              return [t, r, l, e[3]];
            }
            function hue2rgb(e, t, r) {
              return (
                r < 0 && (r += 1),
                r > 1 && (r -= 1),
                r < 1 / 6
                  ? e + 6 * (t - e) * r
                  : r < 0.5
                  ? t
                  : r < 2 / 3
                  ? e + (t - e) * (2 / 3 - r) * 6
                  : e
              );
            }
            function hslToRgb(e) {
              var t,
                r,
                n,
                i = e[0],
                a = e[1],
                o = e[2];
              if (a === 0) (t = o), (n = o), (r = o);
              else {
                var s = o < 0.5 ? o * (1 + a) : o + a - o * a,
                  l = 2 * o - s;
                (t = hue2rgb(l, s, i + 1 / 3)),
                  (r = hue2rgb(l, s, i)),
                  (n = hue2rgb(l, s, i - 1 / 3));
              }
              return [t, r, n, e[3]];
            }
            function linear(e, t, r, n, i) {
              if (
                ((n !== void 0 && i !== void 0) ||
                  ((n = t), (i = r), (t = 0), (r = 1)),
                r < t)
              ) {
                var a = r;
                (r = t), (t = a);
              }
              if (e <= t) return n;
              if (e >= r) return i;
              var o,
                s = r === t ? 0 : (e - t) / (r - t);
              if (!n.length) return n + (i - n) * s;
              var l = n.length,
                f = createTypedArray("float32", l);
              for (o = 0; o < l; o += 1) f[o] = n[o] + (i[o] - n[o]) * s;
              return f;
            }
            function random(e, t) {
              if (
                (t === void 0 &&
                  (e === void 0 ? ((e = 0), (t = 1)) : ((t = e), (e = void 0))),
                t.length)
              ) {
                var r,
                  n = t.length;
                e || (e = createTypedArray("float32", n));
                var i = createTypedArray("float32", n),
                  a = BMMath.random();
                for (r = 0; r < n; r += 1) i[r] = e[r] + a * (t[r] - e[r]);
                return i;
              }
              return e === void 0 && (e = 0), e + BMMath.random() * (t - e);
            }
            function createPath(e, t, r, n) {
              var i,
                a = e.length,
                o = shapePool.newElement();
              o.setPathData(!!n, a);
              var s,
                l,
                f = [0, 0];
              for (i = 0; i < a; i += 1)
                (s = t && t[i] ? t[i] : f),
                  (l = r && r[i] ? r[i] : f),
                  o.setTripleAt(
                    e[i][0],
                    e[i][1],
                    l[0] + e[i][0],
                    l[1] + e[i][1],
                    s[0] + e[i][0],
                    s[1] + e[i][1],
                    i,
                    !0
                  );
              return o;
            }
            function initiateExpression(elem, data, property) {
              function noOp(e) {
                return e;
              }
              if (!elem.globalData.renderConfig.runExpressions) return noOp;
              var val = data.x,
                needsVelocity = /velocity(?![\w\d])/.test(val),
                _needsRandom = val.indexOf("random") !== -1,
                elemType = elem.data.ty,
                transform,
                $bm_transform,
                content,
                effect,
                thisProperty = property;
              (thisProperty.valueAtTime = thisProperty.getValueAtTime),
                Object.defineProperty(thisProperty, "value", {
                  get: function () {
                    return thisProperty.v;
                  },
                }),
                (elem.comp.frameDuration = 1 / elem.comp.globalData.frameRate),
                (elem.comp.displayStartTime = 0);
              var inPoint = elem.data.ip / elem.comp.globalData.frameRate,
                outPoint = elem.data.op / elem.comp.globalData.frameRate,
                width = elem.data.sw ? elem.data.sw : 0,
                height = elem.data.sh ? elem.data.sh : 0,
                name = elem.data.nm,
                loopIn,
                loop_in,
                loopOut,
                loop_out,
                smooth,
                toWorld,
                fromWorld,
                fromComp,
                toComp,
                fromCompToSurface,
                position,
                rotation,
                anchorPoint,
                scale,
                thisLayer,
                thisComp,
                mask,
                valueAtTime,
                velocityAtTime,
                scoped_bm_rt,
                expression_function = eval(
                  "[function _expression_function(){" +
                    val +
                    ";scoped_bm_rt=$bm_rt}]"
                )[0],
                numKeys = property.kf ? data.k.length : 0,
                active = !this.data || this.data.hd !== !0,
                wiggle = function (e, t) {
                  var r,
                    n,
                    i = this.pv.length ? this.pv.length : 1,
                    a = createTypedArray("float32", i),
                    o = Math.floor(5 * time);
                  for (r = 0, n = 0; r < o; ) {
                    for (n = 0; n < i; n += 1)
                      a[n] += -t + 2 * t * BMMath.random();
                    r += 1;
                  }
                  var s = 5 * time,
                    l = s - Math.floor(s),
                    f = createTypedArray("float32", i);
                  if (i > 1) {
                    for (n = 0; n < i; n += 1)
                      f[n] =
                        this.pv[n] + a[n] + (-t + 2 * t * BMMath.random()) * l;
                    return f;
                  }
                  return this.pv + a[0] + (-t + 2 * t * BMMath.random()) * l;
                }.bind(this);
              function loopInDuration(e, t) {
                return loopIn(e, t, !0);
              }
              function loopOutDuration(e, t) {
                return loopOut(e, t, !0);
              }
              thisProperty.loopIn &&
                ((loopIn = thisProperty.loopIn.bind(thisProperty)),
                (loop_in = loopIn)),
                thisProperty.loopOut &&
                  ((loopOut = thisProperty.loopOut.bind(thisProperty)),
                  (loop_out = loopOut)),
                thisProperty.smooth &&
                  (smooth = thisProperty.smooth.bind(thisProperty)),
                this.getValueAtTime &&
                  (valueAtTime = this.getValueAtTime.bind(this)),
                this.getVelocityAtTime &&
                  (velocityAtTime = this.getVelocityAtTime.bind(this));
              var comp = elem.comp.globalData.projectInterface.bind(
                  elem.comp.globalData.projectInterface
                ),
                time,
                velocity,
                value,
                text,
                textIndex,
                textTotal,
                selectorValue;
              function lookAt(e, t) {
                var r = [t[0] - e[0], t[1] - e[1], t[2] - e[2]],
                  n =
                    Math.atan2(r[0], Math.sqrt(r[1] * r[1] + r[2] * r[2])) /
                    degToRads;
                return [-Math.atan2(r[1], r[2]) / degToRads, n, 0];
              }
              function easeOut(e, t, r, n, i) {
                return applyEase(easeOutBez, e, t, r, n, i);
              }
              function easeIn(e, t, r, n, i) {
                return applyEase(easeInBez, e, t, r, n, i);
              }
              function ease(e, t, r, n, i) {
                return applyEase(easeInOutBez, e, t, r, n, i);
              }
              function applyEase(e, t, r, n, i, a) {
                i === void 0 ? ((i = r), (a = n)) : (t = (t - r) / (n - r)),
                  t > 1 ? (t = 1) : t < 0 && (t = 0);
                var o = e(t);
                if ($bm_isInstanceOfArray(i)) {
                  var s,
                    l = i.length,
                    f = createTypedArray("float32", l);
                  for (s = 0; s < l; s += 1) f[s] = (a[s] - i[s]) * o + i[s];
                  return f;
                }
                return (a - i) * o + i;
              }
              function nearestKey(e) {
                var t,
                  r,
                  n,
                  i = data.k.length;
                if (data.k.length && typeof data.k[0] != "number")
                  if (
                    ((r = -1),
                    (e *= elem.comp.globalData.frameRate) < data.k[0].t)
                  )
                    (r = 1), (n = data.k[0].t);
                  else {
                    for (t = 0; t < i - 1; t += 1) {
                      if (e === data.k[t].t) {
                        (r = t + 1), (n = data.k[t].t);
                        break;
                      }
                      if (e > data.k[t].t && e < data.k[t + 1].t) {
                        e - data.k[t].t > data.k[t + 1].t - e
                          ? ((r = t + 2), (n = data.k[t + 1].t))
                          : ((r = t + 1), (n = data.k[t].t));
                        break;
                      }
                    }
                    r === -1 && ((r = t + 1), (n = data.k[t].t));
                  }
                else (r = 0), (n = 0);
                var a = {};
                return (
                  (a.index = r),
                  (a.time = n / elem.comp.globalData.frameRate),
                  a
                );
              }
              function key(e) {
                var t, r, n;
                if (!data.k.length || typeof data.k[0] == "number")
                  throw new Error("The property has no keyframe at index " + e);
                (e -= 1),
                  (t = {
                    time: data.k[e].t / elem.comp.globalData.frameRate,
                    value: [],
                  });
                var i = Object.prototype.hasOwnProperty.call(data.k[e], "s")
                  ? data.k[e].s
                  : data.k[e - 1].e;
                for (n = i.length, r = 0; r < n; r += 1)
                  (t[r] = i[r]), (t.value[r] = i[r]);
                return t;
              }
              function framesToTime(e, t) {
                return t || (t = elem.comp.globalData.frameRate), e / t;
              }
              function timeToFrames(e, t) {
                return (
                  e || e === 0 || (e = time),
                  t || (t = elem.comp.globalData.frameRate),
                  e * t
                );
              }
              function seedRandom(e) {
                BMMath.seedrandom(randSeed + e);
              }
              function sourceRectAtTime() {
                return elem.sourceRectAtTime();
              }
              function substring(e, t) {
                return typeof value == "string"
                  ? t === void 0
                    ? value.substring(e)
                    : value.substring(e, t)
                  : "";
              }
              function substr(e, t) {
                return typeof value == "string"
                  ? t === void 0
                    ? value.substr(e)
                    : value.substr(e, t)
                  : "";
              }
              function posterizeTime(e) {
                (time = e === 0 ? 0 : Math.floor(time * e) / e),
                  (value = valueAtTime(time));
              }
              var index = elem.data.ind,
                hasParent = !(!elem.hierarchy || !elem.hierarchy.length),
                parent,
                randSeed = Math.floor(1e6 * Math.random()),
                globalData = elem.globalData;
              function executeExpression(e) {
                return (
                  (value = e),
                  this.frameExpressionId === elem.globalData.frameId &&
                  this.propType !== "textSelector"
                    ? value
                    : (this.propType === "textSelector" &&
                        ((textIndex = this.textIndex),
                        (textTotal = this.textTotal),
                        (selectorValue = this.selectorValue)),
                      thisLayer ||
                        ((text = elem.layerInterface.text),
                        (thisLayer = elem.layerInterface),
                        (thisComp = elem.comp.compInterface),
                        (toWorld = thisLayer.toWorld.bind(thisLayer)),
                        (fromWorld = thisLayer.fromWorld.bind(thisLayer)),
                        (fromComp = thisLayer.fromComp.bind(thisLayer)),
                        (toComp = thisLayer.toComp.bind(thisLayer)),
                        (mask = thisLayer.mask
                          ? thisLayer.mask.bind(thisLayer)
                          : null),
                        (fromCompToSurface = fromComp)),
                      transform ||
                        ((transform = elem.layerInterface(
                          "ADBE Transform Group"
                        )),
                        ($bm_transform = transform),
                        transform && (anchorPoint = transform.anchorPoint)),
                      elemType !== 4 ||
                        content ||
                        (content = thisLayer("ADBE Root Vectors Group")),
                      effect || (effect = thisLayer(4)),
                      (hasParent = !(
                        !elem.hierarchy || !elem.hierarchy.length
                      )) &&
                        !parent &&
                        (parent = elem.hierarchy[0].layerInterface),
                      (time =
                        this.comp.renderedFrame /
                        this.comp.globalData.frameRate),
                      _needsRandom && seedRandom(randSeed + time),
                      needsVelocity && (velocity = velocityAtTime(time)),
                      expression_function(),
                      (this.frameExpressionId = elem.globalData.frameId),
                      (scoped_bm_rt =
                        scoped_bm_rt.propType === propTypes.SHAPE
                          ? scoped_bm_rt.v
                          : scoped_bm_rt))
                );
              }
              return (
                (executeExpression.__preventDeadCodeRemoval = [
                  $bm_transform,
                  anchorPoint,
                  time,
                  velocity,
                  inPoint,
                  outPoint,
                  width,
                  height,
                  name,
                  loop_in,
                  loop_out,
                  smooth,
                  toComp,
                  fromCompToSurface,
                  toWorld,
                  fromWorld,
                  mask,
                  position,
                  rotation,
                  scale,
                  thisComp,
                  numKeys,
                  active,
                  wiggle,
                  loopInDuration,
                  loopOutDuration,
                  comp,
                  lookAt,
                  easeOut,
                  easeIn,
                  ease,
                  nearestKey,
                  key,
                  text,
                  textIndex,
                  textTotal,
                  selectorValue,
                  framesToTime,
                  timeToFrames,
                  sourceRectAtTime,
                  substring,
                  substr,
                  posterizeTime,
                  index,
                  globalData,
                ]),
                executeExpression
              );
            }
            return (
              (ob.initiateExpression = initiateExpression),
              (ob.__preventDeadCodeRemoval = [
                window,
                document,
                XMLHttpRequest,
                fetch,
                frames,
                $bm_neg,
                add,
                $bm_sum,
                $bm_sub,
                $bm_mul,
                $bm_div,
                $bm_mod,
                clamp,
                radians_to_degrees,
                degreesToRadians,
                degrees_to_radians,
                normalize,
                rgbToHsl,
                hslToRgb,
                linear,
                random,
                createPath,
                _lottieGlobal,
              ]),
              (ob.resetFrame = resetFrame),
              ob
            );
          })(),
          Expressions = (function () {
            var e = {};
            return (
              (e.initExpressions = function (t) {
                var r = 0,
                  n = [];
                (t.renderer.compInterface = CompExpressionInterface(
                  t.renderer
                )),
                  t.renderer.globalData.projectInterface.registerComposition(
                    t.renderer
                  ),
                  (t.renderer.globalData.pushExpression = function () {
                    r += 1;
                  }),
                  (t.renderer.globalData.popExpression = function () {
                    (r -= 1) == 0 &&
                      (function () {
                        var i,
                          a = n.length;
                        for (i = 0; i < a; i += 1) n[i].release();
                        n.length = 0;
                      })();
                  }),
                  (t.renderer.globalData.registerExpressionProperty = function (
                    i
                  ) {
                    n.indexOf(i) === -1 && n.push(i);
                  });
              }),
              (e.resetFrame = ExpressionManager.resetFrame),
              e
            );
          })(),
          MaskManagerInterface = (function () {
            function e(t, r) {
              (this._mask = t), (this._data = r);
            }
            return (
              Object.defineProperty(e.prototype, "maskPath", {
                get: function () {
                  return (
                    this._mask.prop.k && this._mask.prop.getValue(),
                    this._mask.prop
                  );
                },
              }),
              Object.defineProperty(e.prototype, "maskOpacity", {
                get: function () {
                  return (
                    this._mask.op.k && this._mask.op.getValue(),
                    100 * this._mask.op.v
                  );
                },
              }),
              function (t) {
                var r,
                  n = createSizedArray(t.viewData.length),
                  i = t.viewData.length;
                for (r = 0; r < i; r += 1)
                  n[r] = new e(t.viewData[r], t.masksProperties[r]);
                return function (a) {
                  for (r = 0; r < i; ) {
                    if (t.masksProperties[r].nm === a) return n[r];
                    r += 1;
                  }
                  return null;
                };
              }
            );
          })(),
          ExpressionPropertyInterface = (function () {
            var e = { pv: 0, v: 0, mult: 1 },
              t = { pv: [0, 0, 0], v: [0, 0, 0], mult: 1 };
            function r(i, a, o) {
              Object.defineProperty(i, "velocity", {
                get: function () {
                  return a.getVelocityAtTime(a.comp.currentFrame);
                },
              }),
                (i.numKeys = a.keyframes ? a.keyframes.length : 0),
                (i.key = function (s) {
                  if (!i.numKeys) return 0;
                  var l = "";
                  l =
                    "s" in a.keyframes[s - 1]
                      ? a.keyframes[s - 1].s
                      : "e" in a.keyframes[s - 2]
                      ? a.keyframes[s - 2].e
                      : a.keyframes[s - 2].s;
                  var f =
                    o === "unidimensional"
                      ? new Number(l)
                      : Object.assign({}, l);
                  return (
                    (f.time =
                      a.keyframes[s - 1].t / a.elem.comp.globalData.frameRate),
                    (f.value = o === "unidimensional" ? l[0] : l),
                    f
                  );
                }),
                (i.valueAtTime = a.getValueAtTime),
                (i.speedAtTime = a.getSpeedAtTime),
                (i.velocityAtTime = a.getVelocityAtTime),
                (i.propertyGroup = a.propertyGroup);
            }
            function n() {
              return e;
            }
            return function (i) {
              return i
                ? i.propType === "unidimensional"
                  ? (function (a) {
                      (a && "pv" in a) || (a = e);
                      var o = 1 / a.mult,
                        s = a.pv * o,
                        l = new Number(s);
                      return (
                        (l.value = s),
                        r(l, a, "unidimensional"),
                        function () {
                          return (
                            a.k && a.getValue(),
                            (s = a.v * o),
                            l.value !== s &&
                              (((l = new Number(s)).value = s),
                              r(l, a, "unidimensional")),
                            l
                          );
                        }
                      );
                    })(i)
                  : (function (a) {
                      (a && "pv" in a) || (a = t);
                      var o = 1 / a.mult,
                        s = (a.data && a.data.l) || a.pv.length,
                        l = createTypedArray("float32", s),
                        f = createTypedArray("float32", s);
                      return (
                        (l.value = f),
                        r(l, a, "multidimensional"),
                        function () {
                          a.k && a.getValue();
                          for (var u = 0; u < s; u += 1)
                            (f[u] = a.v[u] * o), (l[u] = f[u]);
                          return l;
                        }
                      );
                    })(i)
                : n;
            };
          })(),
          TransformExpressionInterface = function (e) {
            function t(o) {
              switch (o) {
                case "scale":
                case "Scale":
                case "ADBE Scale":
                case 6:
                  return t.scale;
                case "rotation":
                case "Rotation":
                case "ADBE Rotation":
                case "ADBE Rotate Z":
                case 10:
                  return t.rotation;
                case "ADBE Rotate X":
                  return t.xRotation;
                case "ADBE Rotate Y":
                  return t.yRotation;
                case "position":
                case "Position":
                case "ADBE Position":
                case 2:
                  return t.position;
                case "ADBE Position_0":
                  return t.xPosition;
                case "ADBE Position_1":
                  return t.yPosition;
                case "ADBE Position_2":
                  return t.zPosition;
                case "anchorPoint":
                case "AnchorPoint":
                case "Anchor Point":
                case "ADBE AnchorPoint":
                case 1:
                  return t.anchorPoint;
                case "opacity":
                case "Opacity":
                case 11:
                  return t.opacity;
                default:
                  return null;
              }
            }
            var r, n, i, a;
            return (
              Object.defineProperty(t, "rotation", {
                get: ExpressionPropertyInterface(e.r || e.rz),
              }),
              Object.defineProperty(t, "zRotation", {
                get: ExpressionPropertyInterface(e.rz || e.r),
              }),
              Object.defineProperty(t, "xRotation", {
                get: ExpressionPropertyInterface(e.rx),
              }),
              Object.defineProperty(t, "yRotation", {
                get: ExpressionPropertyInterface(e.ry),
              }),
              Object.defineProperty(t, "scale", {
                get: ExpressionPropertyInterface(e.s),
              }),
              e.p
                ? (a = ExpressionPropertyInterface(e.p))
                : ((r = ExpressionPropertyInterface(e.px)),
                  (n = ExpressionPropertyInterface(e.py)),
                  e.pz && (i = ExpressionPropertyInterface(e.pz))),
              Object.defineProperty(t, "position", {
                get: function () {
                  return e.p ? a() : [r(), n(), i ? i() : 0];
                },
              }),
              Object.defineProperty(t, "xPosition", {
                get: ExpressionPropertyInterface(e.px),
              }),
              Object.defineProperty(t, "yPosition", {
                get: ExpressionPropertyInterface(e.py),
              }),
              Object.defineProperty(t, "zPosition", {
                get: ExpressionPropertyInterface(e.pz),
              }),
              Object.defineProperty(t, "anchorPoint", {
                get: ExpressionPropertyInterface(e.a),
              }),
              Object.defineProperty(t, "opacity", {
                get: ExpressionPropertyInterface(e.o),
              }),
              Object.defineProperty(t, "skew", {
                get: ExpressionPropertyInterface(e.sk),
              }),
              Object.defineProperty(t, "skewAxis", {
                get: ExpressionPropertyInterface(e.sa),
              }),
              Object.defineProperty(t, "orientation", {
                get: ExpressionPropertyInterface(e.or),
              }),
              t
            );
          },
          LayerExpressionInterface = (function () {
            function e(f) {
              var u = new Matrix();
              return (
                f !== void 0
                  ? this._elem.finalTransform.mProp.getValueAtTime(f).clone(u)
                  : this._elem.finalTransform.mProp.applyToMatrix(u),
                u
              );
            }
            function t(f, u) {
              var h = this.getMatrix(u);
              return (
                (h.props[12] = 0),
                (h.props[13] = 0),
                (h.props[14] = 0),
                this.applyPoint(h, f)
              );
            }
            function r(f, u) {
              var h = this.getMatrix(u);
              return this.applyPoint(h, f);
            }
            function n(f, u) {
              var h = this.getMatrix(u);
              return (
                (h.props[12] = 0),
                (h.props[13] = 0),
                (h.props[14] = 0),
                this.invertPoint(h, f)
              );
            }
            function i(f, u) {
              var h = this.getMatrix(u);
              return this.invertPoint(h, f);
            }
            function a(f, u) {
              if (this._elem.hierarchy && this._elem.hierarchy.length) {
                var h,
                  m = this._elem.hierarchy.length;
                for (h = 0; h < m; h += 1)
                  this._elem.hierarchy[h].finalTransform.mProp.applyToMatrix(f);
              }
              return f.applyToPointArray(u[0], u[1], u[2] || 0);
            }
            function o(f, u) {
              if (this._elem.hierarchy && this._elem.hierarchy.length) {
                var h,
                  m = this._elem.hierarchy.length;
                for (h = 0; h < m; h += 1)
                  this._elem.hierarchy[h].finalTransform.mProp.applyToMatrix(f);
              }
              return f.inversePoint(u);
            }
            function s(f) {
              var u = new Matrix();
              if (
                (u.reset(),
                this._elem.finalTransform.mProp.applyToMatrix(u),
                this._elem.hierarchy && this._elem.hierarchy.length)
              ) {
                var h,
                  m = this._elem.hierarchy.length;
                for (h = 0; h < m; h += 1)
                  this._elem.hierarchy[h].finalTransform.mProp.applyToMatrix(u);
                return u.inversePoint(f);
              }
              return u.inversePoint(f);
            }
            function l() {
              return [1, 1, 1, 1];
            }
            return function (f) {
              var u;
              function h(d) {
                switch (d) {
                  case "ADBE Root Vectors Group":
                  case "Contents":
                  case 2:
                    return h.shapeInterface;
                  case 1:
                  case 6:
                  case "Transform":
                  case "transform":
                  case "ADBE Transform Group":
                    return u;
                  case 4:
                  case "ADBE Effect Parade":
                  case "effects":
                  case "Effects":
                    return h.effect;
                  case "ADBE Text Properties":
                    return h.textInterface;
                  default:
                    return null;
                }
              }
              (h.getMatrix = e),
                (h.invertPoint = o),
                (h.applyPoint = a),
                (h.toWorld = r),
                (h.toWorldVec = t),
                (h.fromWorld = i),
                (h.fromWorldVec = n),
                (h.toComp = r),
                (h.fromComp = s),
                (h.sampleImage = l),
                (h.sourceRectAtTime = f.sourceRectAtTime.bind(f)),
                (h._elem = f);
              var m = getDescriptor(
                (u = TransformExpressionInterface(f.finalTransform.mProp)),
                "anchorPoint"
              );
              return (
                Object.defineProperties(h, {
                  hasParent: {
                    get: function () {
                      return f.hierarchy.length;
                    },
                  },
                  parent: {
                    get: function () {
                      return f.hierarchy[0].layerInterface;
                    },
                  },
                  rotation: getDescriptor(u, "rotation"),
                  scale: getDescriptor(u, "scale"),
                  position: getDescriptor(u, "position"),
                  opacity: getDescriptor(u, "opacity"),
                  anchorPoint: m,
                  anchor_point: m,
                  transform: {
                    get: function () {
                      return u;
                    },
                  },
                  active: {
                    get: function () {
                      return f.isInRange;
                    },
                  },
                }),
                (h.startTime = f.data.st),
                (h.index = f.data.ind),
                (h.source = f.data.refId),
                (h.height = f.data.ty === 0 ? f.data.h : 100),
                (h.width = f.data.ty === 0 ? f.data.w : 100),
                (h.inPoint = f.data.ip / f.comp.globalData.frameRate),
                (h.outPoint = f.data.op / f.comp.globalData.frameRate),
                (h._name = f.data.nm),
                (h.registerMaskInterface = function (d) {
                  h.mask = new MaskManagerInterface(d, f);
                }),
                (h.registerEffectsInterface = function (d) {
                  h.effect = d;
                }),
                h
              );
            };
          })(),
          propertyGroupFactory = function (e, t) {
            return function (r) {
              return (r = r === void 0 ? 1 : r) <= 0 ? e : t(r - 1);
            };
          },
          PropertyInterface = function (e, t) {
            var r = { _name: e };
            return function (n) {
              return (n = n === void 0 ? 1 : n) <= 0 ? r : t(n - 1);
            };
          },
          EffectsExpressionInterface = (function () {
            function e(r, n, i, a) {
              function o(h) {
                for (var m = r.ef, d = 0, p = m.length; d < p; ) {
                  if (h === m[d].nm || h === m[d].mn || h === m[d].ix)
                    return m[d].ty === 5 ? f[d] : f[d]();
                  d += 1;
                }
                throw new Error();
              }
              var s,
                l = propertyGroupFactory(o, i),
                f = [],
                u = r.ef.length;
              for (s = 0; s < u; s += 1)
                r.ef[s].ty === 5
                  ? f.push(
                      e(
                        r.ef[s],
                        n.effectElements[s],
                        n.effectElements[s].propertyGroup,
                        a
                      )
                    )
                  : f.push(t(n.effectElements[s], r.ef[s].ty, a, l));
              return (
                r.mn === "ADBE Color Control" &&
                  Object.defineProperty(o, "color", {
                    get: function () {
                      return f[0]();
                    },
                  }),
                Object.defineProperties(o, {
                  numProperties: {
                    get: function () {
                      return r.np;
                    },
                  },
                  _name: { value: r.nm },
                  propertyGroup: { value: l },
                }),
                (o.enabled = r.en !== 0),
                (o.active = o.enabled),
                o
              );
            }
            function t(r, n, i, a) {
              var o = ExpressionPropertyInterface(r.p);
              return (
                r.p.setGroupProperty &&
                  r.p.setGroupProperty(PropertyInterface("", a)),
                function () {
                  return n === 10 ? i.comp.compInterface(r.p.v) : o();
                }
              );
            }
            return {
              createEffectsInterface: function (r, n) {
                if (r.effectsManager) {
                  var i,
                    a = [],
                    o = r.data.ef,
                    s = r.effectsManager.effectElements.length;
                  for (i = 0; i < s; i += 1)
                    a.push(e(o[i], r.effectsManager.effectElements[i], n, r));
                  var l = r.data.ef || [],
                    f = function (u) {
                      for (i = 0, s = l.length; i < s; ) {
                        if (u === l[i].nm || u === l[i].mn || u === l[i].ix)
                          return a[i];
                        i += 1;
                      }
                      return null;
                    };
                  return (
                    Object.defineProperty(f, "numProperties", {
                      get: function () {
                        return l.length;
                      },
                    }),
                    f
                  );
                }
                return null;
              },
            };
          })(),
          ShapePathInterface = function (e, t, r) {
            var n = t.sh;
            function i(o) {
              return o === "Shape" ||
                o === "shape" ||
                o === "Path" ||
                o === "path" ||
                o === "ADBE Vector Shape" ||
                o === 2
                ? i.path
                : null;
            }
            var a = propertyGroupFactory(i, r);
            return (
              n.setGroupProperty(PropertyInterface("Path", a)),
              Object.defineProperties(i, {
                path: {
                  get: function () {
                    return n.k && n.getValue(), n;
                  },
                },
                shape: {
                  get: function () {
                    return n.k && n.getValue(), n;
                  },
                },
                _name: { value: e.nm },
                ix: { value: e.ix },
                propertyIndex: { value: e.ix },
                mn: { value: e.mn },
                propertyGroup: { value: r },
              }),
              i
            );
          },
          ShapeExpressionInterface = (function () {
            function e(d, p, g) {
              var c,
                v = [],
                y = d ? d.length : 0;
              for (c = 0; c < y; c += 1)
                d[c].ty === "gr"
                  ? v.push(t(d[c], p[c], g))
                  : d[c].ty === "fl"
                  ? v.push(r(d[c], p[c], g))
                  : d[c].ty === "st"
                  ? v.push(a(d[c], p[c], g))
                  : d[c].ty === "tm"
                  ? v.push(o(d[c], p[c], g))
                  : d[c].ty === "tr" ||
                    (d[c].ty === "el"
                      ? v.push(l(d[c], p[c], g))
                      : d[c].ty === "sr"
                      ? v.push(f(d[c], p[c], g))
                      : d[c].ty === "sh"
                      ? v.push(ShapePathInterface(d[c], p[c], g))
                      : d[c].ty === "rc"
                      ? v.push(u(d[c], p[c], g))
                      : d[c].ty === "rd"
                      ? v.push(h(d[c], p[c], g))
                      : d[c].ty === "rp"
                      ? v.push(m(d[c], p[c], g))
                      : d[c].ty === "gf"
                      ? v.push(n(d[c], p[c], g))
                      : v.push(i(d[c], p[c])));
              return v;
            }
            function t(d, p, g) {
              var c = function (b) {
                switch (b) {
                  case "ADBE Vectors Group":
                  case "Contents":
                  case 2:
                    return c.content;
                  default:
                    return c.transform;
                }
              };
              c.propertyGroup = propertyGroupFactory(c, g);
              var v = (function (b, x, S) {
                  var T,
                    I = function (L) {
                      for (var M = 0, _ = T.length; M < _; ) {
                        if (
                          T[M]._name === L ||
                          T[M].mn === L ||
                          T[M].propertyIndex === L ||
                          T[M].ix === L ||
                          T[M].ind === L
                        )
                          return T[M];
                        M += 1;
                      }
                      return typeof L == "number" ? T[L - 1] : null;
                    };
                  (I.propertyGroup = propertyGroupFactory(I, S)),
                    (T = e(b.it, x.it, I.propertyGroup)),
                    (I.numProperties = T.length);
                  var P = s(
                    b.it[b.it.length - 1],
                    x.it[x.it.length - 1],
                    I.propertyGroup
                  );
                  return (
                    (I.transform = P),
                    (I.propertyIndex = b.cix),
                    (I._name = b.nm),
                    I
                  );
                })(d, p, c.propertyGroup),
                y = s(
                  d.it[d.it.length - 1],
                  p.it[p.it.length - 1],
                  c.propertyGroup
                );
              return (
                (c.content = v),
                (c.transform = y),
                Object.defineProperty(c, "_name", {
                  get: function () {
                    return d.nm;
                  },
                }),
                (c.numProperties = d.np),
                (c.propertyIndex = d.ix),
                (c.nm = d.nm),
                (c.mn = d.mn),
                c
              );
            }
            function r(d, p, g) {
              function c(v) {
                return v === "Color" || v === "color"
                  ? c.color
                  : v === "Opacity" || v === "opacity"
                  ? c.opacity
                  : null;
              }
              return (
                Object.defineProperties(c, {
                  color: { get: ExpressionPropertyInterface(p.c) },
                  opacity: { get: ExpressionPropertyInterface(p.o) },
                  _name: { value: d.nm },
                  mn: { value: d.mn },
                }),
                p.c.setGroupProperty(PropertyInterface("Color", g)),
                p.o.setGroupProperty(PropertyInterface("Opacity", g)),
                c
              );
            }
            function n(d, p, g) {
              function c(v) {
                return v === "Start Point" || v === "start point"
                  ? c.startPoint
                  : v === "End Point" || v === "end point"
                  ? c.endPoint
                  : v === "Opacity" || v === "opacity"
                  ? c.opacity
                  : null;
              }
              return (
                Object.defineProperties(c, {
                  startPoint: { get: ExpressionPropertyInterface(p.s) },
                  endPoint: { get: ExpressionPropertyInterface(p.e) },
                  opacity: { get: ExpressionPropertyInterface(p.o) },
                  type: {
                    get: function () {
                      return "a";
                    },
                  },
                  _name: { value: d.nm },
                  mn: { value: d.mn },
                }),
                p.s.setGroupProperty(PropertyInterface("Start Point", g)),
                p.e.setGroupProperty(PropertyInterface("End Point", g)),
                p.o.setGroupProperty(PropertyInterface("Opacity", g)),
                c
              );
            }
            function i() {
              return function () {
                return null;
              };
            }
            function a(d, p, g) {
              var c,
                v = propertyGroupFactory(T, g),
                y = propertyGroupFactory(S, v);
              function b(I) {
                Object.defineProperty(S, d.d[I].nm, {
                  get: ExpressionPropertyInterface(p.d.dataProps[I].p),
                });
              }
              var x = d.d ? d.d.length : 0,
                S = {};
              for (c = 0; c < x; c += 1)
                b(c), p.d.dataProps[c].p.setGroupProperty(y);
              function T(I) {
                return I === "Color" || I === "color"
                  ? T.color
                  : I === "Opacity" || I === "opacity"
                  ? T.opacity
                  : I === "Stroke Width" || I === "stroke width"
                  ? T.strokeWidth
                  : null;
              }
              return (
                Object.defineProperties(T, {
                  color: { get: ExpressionPropertyInterface(p.c) },
                  opacity: { get: ExpressionPropertyInterface(p.o) },
                  strokeWidth: { get: ExpressionPropertyInterface(p.w) },
                  dash: {
                    get: function () {
                      return S;
                    },
                  },
                  _name: { value: d.nm },
                  mn: { value: d.mn },
                }),
                p.c.setGroupProperty(PropertyInterface("Color", v)),
                p.o.setGroupProperty(PropertyInterface("Opacity", v)),
                p.w.setGroupProperty(PropertyInterface("Stroke Width", v)),
                T
              );
            }
            function o(d, p, g) {
              function c(y) {
                return y === d.e.ix || y === "End" || y === "end"
                  ? c.end
                  : y === d.s.ix
                  ? c.start
                  : y === d.o.ix
                  ? c.offset
                  : null;
              }
              var v = propertyGroupFactory(c, g);
              return (
                (c.propertyIndex = d.ix),
                p.s.setGroupProperty(PropertyInterface("Start", v)),
                p.e.setGroupProperty(PropertyInterface("End", v)),
                p.o.setGroupProperty(PropertyInterface("Offset", v)),
                (c.propertyIndex = d.ix),
                (c.propertyGroup = g),
                Object.defineProperties(c, {
                  start: { get: ExpressionPropertyInterface(p.s) },
                  end: { get: ExpressionPropertyInterface(p.e) },
                  offset: { get: ExpressionPropertyInterface(p.o) },
                  _name: { value: d.nm },
                }),
                (c.mn = d.mn),
                c
              );
            }
            function s(d, p, g) {
              function c(y) {
                return d.a.ix === y || y === "Anchor Point"
                  ? c.anchorPoint
                  : d.o.ix === y || y === "Opacity"
                  ? c.opacity
                  : d.p.ix === y || y === "Position"
                  ? c.position
                  : d.r.ix === y ||
                    y === "Rotation" ||
                    y === "ADBE Vector Rotation"
                  ? c.rotation
                  : d.s.ix === y || y === "Scale"
                  ? c.scale
                  : (d.sk && d.sk.ix === y) || y === "Skew"
                  ? c.skew
                  : (d.sa && d.sa.ix === y) || y === "Skew Axis"
                  ? c.skewAxis
                  : null;
              }
              var v = propertyGroupFactory(c, g);
              return (
                p.transform.mProps.o.setGroupProperty(
                  PropertyInterface("Opacity", v)
                ),
                p.transform.mProps.p.setGroupProperty(
                  PropertyInterface("Position", v)
                ),
                p.transform.mProps.a.setGroupProperty(
                  PropertyInterface("Anchor Point", v)
                ),
                p.transform.mProps.s.setGroupProperty(
                  PropertyInterface("Scale", v)
                ),
                p.transform.mProps.r.setGroupProperty(
                  PropertyInterface("Rotation", v)
                ),
                p.transform.mProps.sk &&
                  (p.transform.mProps.sk.setGroupProperty(
                    PropertyInterface("Skew", v)
                  ),
                  p.transform.mProps.sa.setGroupProperty(
                    PropertyInterface("Skew Angle", v)
                  )),
                p.transform.op.setGroupProperty(
                  PropertyInterface("Opacity", v)
                ),
                Object.defineProperties(c, {
                  opacity: {
                    get: ExpressionPropertyInterface(p.transform.mProps.o),
                  },
                  position: {
                    get: ExpressionPropertyInterface(p.transform.mProps.p),
                  },
                  anchorPoint: {
                    get: ExpressionPropertyInterface(p.transform.mProps.a),
                  },
                  scale: {
                    get: ExpressionPropertyInterface(p.transform.mProps.s),
                  },
                  rotation: {
                    get: ExpressionPropertyInterface(p.transform.mProps.r),
                  },
                  skew: {
                    get: ExpressionPropertyInterface(p.transform.mProps.sk),
                  },
                  skewAxis: {
                    get: ExpressionPropertyInterface(p.transform.mProps.sa),
                  },
                  _name: { value: d.nm },
                }),
                (c.ty = "tr"),
                (c.mn = d.mn),
                (c.propertyGroup = g),
                c
              );
            }
            function l(d, p, g) {
              function c(b) {
                return d.p.ix === b ? c.position : d.s.ix === b ? c.size : null;
              }
              var v = propertyGroupFactory(c, g);
              c.propertyIndex = d.ix;
              var y = p.sh.ty === "tm" ? p.sh.prop : p.sh;
              return (
                y.s.setGroupProperty(PropertyInterface("Size", v)),
                y.p.setGroupProperty(PropertyInterface("Position", v)),
                Object.defineProperties(c, {
                  size: { get: ExpressionPropertyInterface(y.s) },
                  position: { get: ExpressionPropertyInterface(y.p) },
                  _name: { value: d.nm },
                }),
                (c.mn = d.mn),
                c
              );
            }
            function f(d, p, g) {
              function c(b) {
                return d.p.ix === b
                  ? c.position
                  : d.r.ix === b
                  ? c.rotation
                  : d.pt.ix === b
                  ? c.points
                  : d.or.ix === b || b === "ADBE Vector Star Outer Radius"
                  ? c.outerRadius
                  : d.os.ix === b
                  ? c.outerRoundness
                  : !d.ir ||
                    (d.ir.ix !== b && b !== "ADBE Vector Star Inner Radius")
                  ? d.is && d.is.ix === b
                    ? c.innerRoundness
                    : null
                  : c.innerRadius;
              }
              var v = propertyGroupFactory(c, g),
                y = p.sh.ty === "tm" ? p.sh.prop : p.sh;
              return (
                (c.propertyIndex = d.ix),
                y.or.setGroupProperty(PropertyInterface("Outer Radius", v)),
                y.os.setGroupProperty(PropertyInterface("Outer Roundness", v)),
                y.pt.setGroupProperty(PropertyInterface("Points", v)),
                y.p.setGroupProperty(PropertyInterface("Position", v)),
                y.r.setGroupProperty(PropertyInterface("Rotation", v)),
                d.ir &&
                  (y.ir.setGroupProperty(PropertyInterface("Inner Radius", v)),
                  y.is.setGroupProperty(
                    PropertyInterface("Inner Roundness", v)
                  )),
                Object.defineProperties(c, {
                  position: { get: ExpressionPropertyInterface(y.p) },
                  rotation: { get: ExpressionPropertyInterface(y.r) },
                  points: { get: ExpressionPropertyInterface(y.pt) },
                  outerRadius: { get: ExpressionPropertyInterface(y.or) },
                  outerRoundness: { get: ExpressionPropertyInterface(y.os) },
                  innerRadius: { get: ExpressionPropertyInterface(y.ir) },
                  innerRoundness: { get: ExpressionPropertyInterface(y.is) },
                  _name: { value: d.nm },
                }),
                (c.mn = d.mn),
                c
              );
            }
            function u(d, p, g) {
              function c(b) {
                return d.p.ix === b
                  ? c.position
                  : d.r.ix === b
                  ? c.roundness
                  : d.s.ix === b ||
                    b === "Size" ||
                    b === "ADBE Vector Rect Size"
                  ? c.size
                  : null;
              }
              var v = propertyGroupFactory(c, g),
                y = p.sh.ty === "tm" ? p.sh.prop : p.sh;
              return (
                (c.propertyIndex = d.ix),
                y.p.setGroupProperty(PropertyInterface("Position", v)),
                y.s.setGroupProperty(PropertyInterface("Size", v)),
                y.r.setGroupProperty(PropertyInterface("Rotation", v)),
                Object.defineProperties(c, {
                  position: { get: ExpressionPropertyInterface(y.p) },
                  roundness: { get: ExpressionPropertyInterface(y.r) },
                  size: { get: ExpressionPropertyInterface(y.s) },
                  _name: { value: d.nm },
                }),
                (c.mn = d.mn),
                c
              );
            }
            function h(d, p, g) {
              function c(b) {
                return d.r.ix === b || b === "Round Corners 1"
                  ? c.radius
                  : null;
              }
              var v = propertyGroupFactory(c, g),
                y = p;
              return (
                (c.propertyIndex = d.ix),
                y.rd.setGroupProperty(PropertyInterface("Radius", v)),
                Object.defineProperties(c, {
                  radius: { get: ExpressionPropertyInterface(y.rd) },
                  _name: { value: d.nm },
                }),
                (c.mn = d.mn),
                c
              );
            }
            function m(d, p, g) {
              function c(b) {
                return d.c.ix === b || b === "Copies"
                  ? c.copies
                  : d.o.ix === b || b === "Offset"
                  ? c.offset
                  : null;
              }
              var v = propertyGroupFactory(c, g),
                y = p;
              return (
                (c.propertyIndex = d.ix),
                y.c.setGroupProperty(PropertyInterface("Copies", v)),
                y.o.setGroupProperty(PropertyInterface("Offset", v)),
                Object.defineProperties(c, {
                  copies: { get: ExpressionPropertyInterface(y.c) },
                  offset: { get: ExpressionPropertyInterface(y.o) },
                  _name: { value: d.nm },
                }),
                (c.mn = d.mn),
                c
              );
            }
            return function (d, p, g) {
              var c;
              function v(y) {
                if (typeof y == "number")
                  return (y = y === void 0 ? 1 : y) === 0 ? g : c[y - 1];
                for (var b = 0, x = c.length; b < x; ) {
                  if (c[b]._name === y) return c[b];
                  b += 1;
                }
                return null;
              }
              return (
                (v.propertyGroup = propertyGroupFactory(v, function () {
                  return g;
                })),
                (c = e(d, p, v.propertyGroup)),
                (v.numProperties = c.length),
                (v._name = "Contents"),
                v
              );
            };
          })(),
          TextExpressionInterface = function (e) {
            var t;
            function r(n) {
              return n === "ADBE Text Document" ? r.sourceText : null;
            }
            return (
              Object.defineProperty(r, "sourceText", {
                get: function () {
                  e.textProperty.getValue();
                  var n = e.textProperty.currentData.t;
                  return (
                    (t && n === t.value) ||
                      (((t = new String(n)).value = n || new String(n)),
                      Object.defineProperty(t, "style", {
                        get: function () {
                          return { fillColor: e.textProperty.currentData.fc };
                        },
                      })),
                    t
                  );
                },
              }),
              r
            );
          };
        function _typeof(e) {
          return (
            (_typeof =
              typeof Symbol == "function" && typeof Symbol.iterator == "symbol"
                ? function (t) {
                    return typeof t;
                  }
                : function (t) {
                    return t &&
                      typeof Symbol == "function" &&
                      t.constructor === Symbol &&
                      t !== Symbol.prototype
                      ? "symbol"
                      : typeof t;
                  }),
            _typeof(e)
          );
        }
        var FootageInterface =
            ((dataInterfaceFactory = function (e) {
              function t(r) {
                return r === "Outline" ? t.outlineInterface() : null;
              }
              return (
                (t._name = "Outline"),
                (t.outlineInterface = (function (r) {
                  var n = "",
                    i = r.getFootageData();
                  function a(o) {
                    if (i[o])
                      return (n = o), _typeof((i = i[o])) === "object" ? a : i;
                    var s = o.indexOf(n);
                    if (s !== -1) {
                      var l = parseInt(o.substr(s + n.length), 10);
                      return _typeof((i = i[l])) === "object" ? a : i;
                    }
                    return "";
                  }
                  return function () {
                    return (n = ""), (i = r.getFootageData()), a;
                  };
                })(e)),
                t
              );
            }),
            function (e) {
              function t(r) {
                return r === "Data" ? t.dataInterface : null;
              }
              return (
                (t._name = "Data"),
                (t.dataInterface = dataInterfaceFactory(e)),
                t
              );
            }),
          dataInterfaceFactory,
          interfaces = {
            layer: LayerExpressionInterface,
            effects: EffectsExpressionInterface,
            comp: CompExpressionInterface,
            shape: ShapeExpressionInterface,
            text: TextExpressionInterface,
            footage: FootageInterface,
          };
        function getInterface(e) {
          return interfaces[e] || null;
        }
        var expressionHelpers = {
          searchExpressions: function (e, t, r) {
            t.x &&
              ((r.k = !0),
              (r.x = !0),
              (r.initiateExpression = ExpressionManager.initiateExpression),
              r.effectsSequence.push(r.initiateExpression(e, t, r).bind(r)));
          },
          getSpeedAtTime: function (e) {
            var t = this.getValueAtTime(e),
              r = this.getValueAtTime(e + -0.01),
              n = 0;
            if (t.length) {
              var i;
              for (i = 0; i < t.length; i += 1) n += Math.pow(r[i] - t[i], 2);
              n = 100 * Math.sqrt(n);
            } else n = 0;
            return n;
          },
          getVelocityAtTime: function (e) {
            if (this.vel !== void 0) return this.vel;
            var t,
              r,
              n = -0.001,
              i = this.getValueAtTime(e),
              a = this.getValueAtTime(e + n);
            if (i.length)
              for (
                t = createTypedArray("float32", i.length), r = 0;
                r < i.length;
                r += 1
              )
                t[r] = (a[r] - i[r]) / n;
            else t = (a - i) / n;
            return t;
          },
          getValueAtTime: function (e) {
            return (
              (e *= this.elem.globalData.frameRate),
              (e -= this.offsetTime) !== this._cachingAtTime.lastFrame &&
                ((this._cachingAtTime.lastIndex =
                  this._cachingAtTime.lastFrame < e
                    ? this._cachingAtTime.lastIndex
                    : 0),
                (this._cachingAtTime.value = this.interpolateValue(
                  e,
                  this._cachingAtTime
                )),
                (this._cachingAtTime.lastFrame = e)),
              this._cachingAtTime.value
            );
          },
          getStaticValueAtTime: function () {
            return this.pv;
          },
          setGroupProperty: function (e) {
            this.propertyGroup = e;
          },
        };
        function addPropertyDecorator() {
          function e(h, m, d) {
            if (!this.k || !this.keyframes) return this.pv;
            h = h ? h.toLowerCase() : "";
            var p,
              g,
              c,
              v,
              y,
              b = this.comp.renderedFrame,
              x = this.keyframes,
              S = x[x.length - 1].t;
            if (b <= S) return this.pv;
            if (
              (d
                ? (g =
                    S -
                    (p = m
                      ? Math.abs(S - this.elem.comp.globalData.frameRate * m)
                      : Math.max(0, S - this.elem.data.ip)))
                : ((!m || m > x.length - 1) && (m = x.length - 1),
                  (p = S - (g = x[x.length - 1 - m].t))),
              h === "pingpong")
            ) {
              if (Math.floor((b - g) / p) % 2 != 0)
                return this.getValueAtTime(
                  (p - ((b - g) % p) + g) / this.comp.globalData.frameRate,
                  0
                );
            } else {
              if (h === "offset") {
                var T = this.getValueAtTime(
                    g / this.comp.globalData.frameRate,
                    0
                  ),
                  I = this.getValueAtTime(
                    S / this.comp.globalData.frameRate,
                    0
                  ),
                  P = this.getValueAtTime(
                    (((b - g) % p) + g) / this.comp.globalData.frameRate,
                    0
                  ),
                  L = Math.floor((b - g) / p);
                if (this.pv.length) {
                  for (
                    v = (y = new Array(T.length)).length, c = 0;
                    c < v;
                    c += 1
                  )
                    y[c] = (I[c] - T[c]) * L + P[c];
                  return y;
                }
                return (I - T) * L + P;
              }
              if (h === "continue") {
                var M = this.getValueAtTime(
                    S / this.comp.globalData.frameRate,
                    0
                  ),
                  _ = this.getValueAtTime(
                    (S - 0.001) / this.comp.globalData.frameRate,
                    0
                  );
                if (this.pv.length) {
                  for (
                    v = (y = new Array(M.length)).length, c = 0;
                    c < v;
                    c += 1
                  )
                    y[c] =
                      M[c] +
                      ((M[c] - _[c]) *
                        ((b - S) / this.comp.globalData.frameRate)) /
                        5e-4;
                  return y;
                }
                return M + ((b - S) / 0.001) * (M - _);
              }
            }
            return this.getValueAtTime(
              (((b - g) % p) + g) / this.comp.globalData.frameRate,
              0
            );
          }
          function t(h, m, d) {
            if (!this.k) return this.pv;
            h = h ? h.toLowerCase() : "";
            var p,
              g,
              c,
              v,
              y,
              b = this.comp.renderedFrame,
              x = this.keyframes,
              S = x[0].t;
            if (b >= S) return this.pv;
            if (
              (d
                ? (g =
                    S +
                    (p = m
                      ? Math.abs(this.elem.comp.globalData.frameRate * m)
                      : Math.max(0, this.elem.data.op - S)))
                : ((!m || m > x.length - 1) && (m = x.length - 1),
                  (p = (g = x[m].t) - S)),
              h === "pingpong")
            ) {
              if (Math.floor((S - b) / p) % 2 == 0)
                return this.getValueAtTime(
                  (((S - b) % p) + S) / this.comp.globalData.frameRate,
                  0
                );
            } else {
              if (h === "offset") {
                var T = this.getValueAtTime(
                    S / this.comp.globalData.frameRate,
                    0
                  ),
                  I = this.getValueAtTime(
                    g / this.comp.globalData.frameRate,
                    0
                  ),
                  P = this.getValueAtTime(
                    (p - ((S - b) % p) + S) / this.comp.globalData.frameRate,
                    0
                  ),
                  L = Math.floor((S - b) / p) + 1;
                if (this.pv.length) {
                  for (
                    v = (y = new Array(T.length)).length, c = 0;
                    c < v;
                    c += 1
                  )
                    y[c] = P[c] - (I[c] - T[c]) * L;
                  return y;
                }
                return P - (I - T) * L;
              }
              if (h === "continue") {
                var M = this.getValueAtTime(
                    S / this.comp.globalData.frameRate,
                    0
                  ),
                  _ = this.getValueAtTime(
                    (S + 0.001) / this.comp.globalData.frameRate,
                    0
                  );
                if (this.pv.length) {
                  for (
                    v = (y = new Array(M.length)).length, c = 0;
                    c < v;
                    c += 1
                  )
                    y[c] = M[c] + ((M[c] - _[c]) * (S - b)) / 0.001;
                  return y;
                }
                return M + ((M - _) * (S - b)) / 0.001;
              }
            }
            return this.getValueAtTime(
              (p - (((S - b) % p) + S)) / this.comp.globalData.frameRate,
              0
            );
          }
          function r(h, m) {
            if (!this.k) return this.pv;
            if (((h = 0.5 * (h || 0.4)), (m = Math.floor(m || 5)) <= 1))
              return this.pv;
            var d,
              p,
              g = this.comp.renderedFrame / this.comp.globalData.frameRate,
              c = g - h,
              v = m > 1 ? (g + h - c) / (m - 1) : 1,
              y = 0,
              b = 0;
            for (
              d = this.pv.length
                ? createTypedArray("float32", this.pv.length)
                : 0;
              y < m;

            ) {
              if (((p = this.getValueAtTime(c + y * v)), this.pv.length))
                for (b = 0; b < this.pv.length; b += 1) d[b] += p[b];
              else d += p;
              y += 1;
            }
            if (this.pv.length)
              for (b = 0; b < this.pv.length; b += 1) d[b] /= m;
            else d /= m;
            return d;
          }
          function n(h) {
            this._transformCachingAtTime ||
              (this._transformCachingAtTime = { v: new Matrix() });
            var m = this._transformCachingAtTime.v;
            if (
              (m.cloneFromProps(this.pre.props),
              this.appliedTransformations < 1)
            ) {
              var d = this.a.getValueAtTime(h);
              m.translate(
                -d[0] * this.a.mult,
                -d[1] * this.a.mult,
                d[2] * this.a.mult
              );
            }
            if (this.appliedTransformations < 2) {
              var p = this.s.getValueAtTime(h);
              m.scale(
                p[0] * this.s.mult,
                p[1] * this.s.mult,
                p[2] * this.s.mult
              );
            }
            if (this.sk && this.appliedTransformations < 3) {
              var g = this.sk.getValueAtTime(h),
                c = this.sa.getValueAtTime(h);
              m.skewFromAxis(-g * this.sk.mult, c * this.sa.mult);
            }
            if (this.r && this.appliedTransformations < 4) {
              var v = this.r.getValueAtTime(h);
              m.rotate(-v * this.r.mult);
            } else if (!this.r && this.appliedTransformations < 4) {
              var y = this.rz.getValueAtTime(h),
                b = this.ry.getValueAtTime(h),
                x = this.rx.getValueAtTime(h),
                S = this.or.getValueAtTime(h);
              m.rotateZ(-y * this.rz.mult)
                .rotateY(b * this.ry.mult)
                .rotateX(x * this.rx.mult)
                .rotateZ(-S[2] * this.or.mult)
                .rotateY(S[1] * this.or.mult)
                .rotateX(S[0] * this.or.mult);
            }
            if (this.data.p && this.data.p.s) {
              var T = this.px.getValueAtTime(h),
                I = this.py.getValueAtTime(h);
              if (this.data.p.z) {
                var P = this.pz.getValueAtTime(h);
                m.translate(
                  T * this.px.mult,
                  I * this.py.mult,
                  -P * this.pz.mult
                );
              } else m.translate(T * this.px.mult, I * this.py.mult, 0);
            } else {
              var L = this.p.getValueAtTime(h);
              m.translate(
                L[0] * this.p.mult,
                L[1] * this.p.mult,
                -L[2] * this.p.mult
              );
            }
            return m;
          }
          function i() {
            return this.v.clone(new Matrix());
          }
          var a = TransformPropertyFactory.getTransformProperty;
          TransformPropertyFactory.getTransformProperty = function (h, m, d) {
            var p = a(h, m, d);
            return (
              p.dynamicProperties.length
                ? (p.getValueAtTime = n.bind(p))
                : (p.getValueAtTime = i.bind(p)),
              (p.setGroupProperty = expressionHelpers.setGroupProperty),
              p
            );
          };
          var o = PropertyFactory.getProp;
          PropertyFactory.getProp = function (h, m, d, p, g) {
            var c = o(h, m, d, p, g);
            c.kf
              ? (c.getValueAtTime = expressionHelpers.getValueAtTime.bind(c))
              : (c.getValueAtTime =
                  expressionHelpers.getStaticValueAtTime.bind(c)),
              (c.setGroupProperty = expressionHelpers.setGroupProperty),
              (c.loopOut = e),
              (c.loopIn = t),
              (c.smooth = r),
              (c.getVelocityAtTime =
                expressionHelpers.getVelocityAtTime.bind(c)),
              (c.getSpeedAtTime = expressionHelpers.getSpeedAtTime.bind(c)),
              (c.numKeys = m.a === 1 ? m.k.length : 0),
              (c.propertyIndex = m.ix);
            var v = 0;
            return (
              d !== 0 &&
                (v = createTypedArray(
                  "float32",
                  m.a === 1 ? m.k[0].s.length : m.k.length
                )),
              (c._cachingAtTime = {
                lastFrame: initialDefaultFrame,
                lastIndex: 0,
                value: v,
              }),
              expressionHelpers.searchExpressions(h, m, c),
              c.k && g.addDynamicProperty(c),
              c
            );
          };
          var s = ShapePropertyFactory.getConstructorFunction(),
            l = ShapePropertyFactory.getKeyframedConstructorFunction();
          function f() {}
          (f.prototype = {
            vertices: function (h, m) {
              this.k && this.getValue();
              var d,
                p = this.v;
              m !== void 0 && (p = this.getValueAtTime(m, 0));
              var g = p._length,
                c = p[h],
                v = p.v,
                y = createSizedArray(g);
              for (d = 0; d < g; d += 1)
                y[d] =
                  h === "i" || h === "o"
                    ? [c[d][0] - v[d][0], c[d][1] - v[d][1]]
                    : [c[d][0], c[d][1]];
              return y;
            },
            points: function (h) {
              return this.vertices("v", h);
            },
            inTangents: function (h) {
              return this.vertices("i", h);
            },
            outTangents: function (h) {
              return this.vertices("o", h);
            },
            isClosed: function () {
              return this.v.c;
            },
            pointOnPath: function (h, m) {
              var d = this.v;
              m !== void 0 && (d = this.getValueAtTime(m, 0)),
                this._segmentsLength ||
                  (this._segmentsLength = bez.getSegmentsLength(d));
              for (
                var p,
                  g = this._segmentsLength,
                  c = g.lengths,
                  v = g.totalLength * h,
                  y = 0,
                  b = c.length,
                  x = 0;
                y < b;

              ) {
                if (x + c[y].addedLength > v) {
                  var S = y,
                    T = d.c && y === b - 1 ? 0 : y + 1,
                    I = (v - x) / c[y].addedLength;
                  p = bez.getPointInSegment(
                    d.v[S],
                    d.v[T],
                    d.o[S],
                    d.i[T],
                    I,
                    c[y]
                  );
                  break;
                }
                (x += c[y].addedLength), (y += 1);
              }
              return (
                p ||
                  (p = d.c
                    ? [d.v[0][0], d.v[0][1]]
                    : [d.v[d._length - 1][0], d.v[d._length - 1][1]]),
                p
              );
            },
            vectorOnPath: function (h, m, d) {
              h == 1 ? (h = this.v.c) : h == 0 && (h = 0.999);
              var p = this.pointOnPath(h, m),
                g = this.pointOnPath(h + 0.001, m),
                c = g[0] - p[0],
                v = g[1] - p[1],
                y = Math.sqrt(Math.pow(c, 2) + Math.pow(v, 2));
              return y === 0
                ? [0, 0]
                : d === "tangent"
                ? [c / y, v / y]
                : [-v / y, c / y];
            },
            tangentOnPath: function (h, m) {
              return this.vectorOnPath(h, m, "tangent");
            },
            normalOnPath: function (h, m) {
              return this.vectorOnPath(h, m, "normal");
            },
            setGroupProperty: expressionHelpers.setGroupProperty,
            getValueAtTime: expressionHelpers.getStaticValueAtTime,
          }),
            extendPrototype([f], s),
            extendPrototype([f], l),
            (l.prototype.getValueAtTime = function (h) {
              return (
                this._cachingAtTime ||
                  (this._cachingAtTime = {
                    shapeValue: shapePool.clone(this.pv),
                    lastIndex: 0,
                    lastTime: initialDefaultFrame,
                  }),
                (h *= this.elem.globalData.frameRate),
                (h -= this.offsetTime) !== this._cachingAtTime.lastTime &&
                  ((this._cachingAtTime.lastIndex =
                    this._cachingAtTime.lastTime < h
                      ? this._caching.lastIndex
                      : 0),
                  (this._cachingAtTime.lastTime = h),
                  this.interpolateShape(
                    h,
                    this._cachingAtTime.shapeValue,
                    this._cachingAtTime
                  )),
                this._cachingAtTime.shapeValue
              );
            }),
            (l.prototype.initiateExpression =
              ExpressionManager.initiateExpression);
          var u = ShapePropertyFactory.getShapeProp;
          ShapePropertyFactory.getShapeProp = function (h, m, d, p, g) {
            var c = u(h, m, d, p, g);
            return (
              (c.propertyIndex = m.ix),
              (c.lock = !1),
              d === 3
                ? expressionHelpers.searchExpressions(h, m.pt, c)
                : d === 4 && expressionHelpers.searchExpressions(h, m.ks, c),
              c.k && h.addDynamicProperty(c),
              c
            );
          };
        }
        function initialize$1() {
          addPropertyDecorator();
        }
        function addDecorator() {
          (TextProperty.prototype.getExpressionValue = function (e, t) {
            var r = this.calculateExpression(t);
            if (e.t !== r) {
              var n = {};
              return (
                this.copyData(n, e),
                (n.t = r.toString()),
                (n.__complete = !1),
                n
              );
            }
            return e;
          }),
            (TextProperty.prototype.searchProperty = function () {
              var e = this.searchKeyframes(),
                t = this.searchExpressions();
              return (this.kf = e || t), this.kf;
            }),
            (TextProperty.prototype.searchExpressions = function () {
              return this.data.d.x
                ? ((this.calculateExpression =
                    ExpressionManager.initiateExpression.bind(this)(
                      this.elem,
                      this.data.d,
                      this
                    )),
                  this.addEffect(this.getExpressionValue.bind(this)),
                  !0)
                : null;
            });
        }
        function initialize() {
          addDecorator();
        }
        function SVGComposableEffect() {}
        SVGComposableEffect.prototype = {
          createMergeNode: function (e, t) {
            var r,
              n,
              i = createNS("feMerge");
            for (i.setAttribute("result", e), n = 0; n < t.length; n += 1)
              (r = createNS("feMergeNode")).setAttribute("in", t[n]),
                i.appendChild(r),
                i.appendChild(r);
            return i;
          },
        };
        var linearFilterValue =
          "0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0";
        function SVGTintFilter(e, t, r, n, i) {
          this.filterManager = t;
          var a = createNS("feColorMatrix");
          a.setAttribute("type", "matrix"),
            a.setAttribute("color-interpolation-filters", "linearRGB"),
            a.setAttribute("values", linearFilterValue + " 1 0"),
            (this.linearFilter = a),
            a.setAttribute("result", n + "_tint_1"),
            e.appendChild(a),
            (a = createNS("feColorMatrix")).setAttribute("type", "matrix"),
            a.setAttribute("color-interpolation-filters", "sRGB"),
            a.setAttribute("values", "1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"),
            a.setAttribute("result", n + "_tint_2"),
            e.appendChild(a),
            (this.matrixFilter = a);
          var o = this.createMergeNode(n, [i, n + "_tint_1", n + "_tint_2"]);
          e.appendChild(o);
        }
        function SVGFillFilter(e, t, r, n) {
          this.filterManager = t;
          var i = createNS("feColorMatrix");
          i.setAttribute("type", "matrix"),
            i.setAttribute("color-interpolation-filters", "sRGB"),
            i.setAttribute("values", "1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"),
            i.setAttribute("result", n),
            e.appendChild(i),
            (this.matrixFilter = i);
        }
        function SVGStrokeEffect(e, t, r) {
          (this.initialized = !1),
            (this.filterManager = t),
            (this.elem = r),
            (this.paths = []);
        }
        function SVGTritoneFilter(e, t, r, n) {
          this.filterManager = t;
          var i = createNS("feColorMatrix");
          i.setAttribute("type", "matrix"),
            i.setAttribute("color-interpolation-filters", "linearRGB"),
            i.setAttribute(
              "values",
              "0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0"
            ),
            e.appendChild(i);
          var a = createNS("feComponentTransfer");
          a.setAttribute("color-interpolation-filters", "sRGB"),
            a.setAttribute("result", n),
            (this.matrixFilter = a);
          var o = createNS("feFuncR");
          o.setAttribute("type", "table"), a.appendChild(o), (this.feFuncR = o);
          var s = createNS("feFuncG");
          s.setAttribute("type", "table"), a.appendChild(s), (this.feFuncG = s);
          var l = createNS("feFuncB");
          l.setAttribute("type", "table"),
            a.appendChild(l),
            (this.feFuncB = l),
            e.appendChild(a);
        }
        function SVGProLevelsFilter(e, t, r, n) {
          this.filterManager = t;
          var i = this.filterManager.effectElements,
            a = createNS("feComponentTransfer");
          (i[10].p.k ||
            i[10].p.v !== 0 ||
            i[11].p.k ||
            i[11].p.v !== 1 ||
            i[12].p.k ||
            i[12].p.v !== 1 ||
            i[13].p.k ||
            i[13].p.v !== 0 ||
            i[14].p.k ||
            i[14].p.v !== 1) &&
            (this.feFuncR = this.createFeFunc("feFuncR", a)),
            (i[17].p.k ||
              i[17].p.v !== 0 ||
              i[18].p.k ||
              i[18].p.v !== 1 ||
              i[19].p.k ||
              i[19].p.v !== 1 ||
              i[20].p.k ||
              i[20].p.v !== 0 ||
              i[21].p.k ||
              i[21].p.v !== 1) &&
              (this.feFuncG = this.createFeFunc("feFuncG", a)),
            (i[24].p.k ||
              i[24].p.v !== 0 ||
              i[25].p.k ||
              i[25].p.v !== 1 ||
              i[26].p.k ||
              i[26].p.v !== 1 ||
              i[27].p.k ||
              i[27].p.v !== 0 ||
              i[28].p.k ||
              i[28].p.v !== 1) &&
              (this.feFuncB = this.createFeFunc("feFuncB", a)),
            (i[31].p.k ||
              i[31].p.v !== 0 ||
              i[32].p.k ||
              i[32].p.v !== 1 ||
              i[33].p.k ||
              i[33].p.v !== 1 ||
              i[34].p.k ||
              i[34].p.v !== 0 ||
              i[35].p.k ||
              i[35].p.v !== 1) &&
              (this.feFuncA = this.createFeFunc("feFuncA", a)),
            (this.feFuncR || this.feFuncG || this.feFuncB || this.feFuncA) &&
              (a.setAttribute("color-interpolation-filters", "sRGB"),
              e.appendChild(a)),
            (i[3].p.k ||
              i[3].p.v !== 0 ||
              i[4].p.k ||
              i[4].p.v !== 1 ||
              i[5].p.k ||
              i[5].p.v !== 1 ||
              i[6].p.k ||
              i[6].p.v !== 0 ||
              i[7].p.k ||
              i[7].p.v !== 1) &&
              ((a = createNS("feComponentTransfer")).setAttribute(
                "color-interpolation-filters",
                "sRGB"
              ),
              a.setAttribute("result", n),
              e.appendChild(a),
              (this.feFuncRComposed = this.createFeFunc("feFuncR", a)),
              (this.feFuncGComposed = this.createFeFunc("feFuncG", a)),
              (this.feFuncBComposed = this.createFeFunc("feFuncB", a)));
        }
        function SVGDropShadowEffect(e, t, r, n, i) {
          var a = t.container.globalData.renderConfig.filterSize,
            o = t.data.fs || a;
          e.setAttribute("x", o.x || a.x),
            e.setAttribute("y", o.y || a.y),
            e.setAttribute("width", o.width || a.width),
            e.setAttribute("height", o.height || a.height),
            (this.filterManager = t);
          var s = createNS("feGaussianBlur");
          s.setAttribute("in", "SourceAlpha"),
            s.setAttribute("result", n + "_drop_shadow_1"),
            s.setAttribute("stdDeviation", "0"),
            (this.feGaussianBlur = s),
            e.appendChild(s);
          var l = createNS("feOffset");
          l.setAttribute("dx", "25"),
            l.setAttribute("dy", "0"),
            l.setAttribute("in", n + "_drop_shadow_1"),
            l.setAttribute("result", n + "_drop_shadow_2"),
            (this.feOffset = l),
            e.appendChild(l);
          var f = createNS("feFlood");
          f.setAttribute("flood-color", "#00ff00"),
            f.setAttribute("flood-opacity", "1"),
            f.setAttribute("result", n + "_drop_shadow_3"),
            (this.feFlood = f),
            e.appendChild(f);
          var u = createNS("feComposite");
          u.setAttribute("in", n + "_drop_shadow_3"),
            u.setAttribute("in2", n + "_drop_shadow_2"),
            u.setAttribute("operator", "in"),
            u.setAttribute("result", n + "_drop_shadow_4"),
            e.appendChild(u);
          var h = this.createMergeNode(n, [n + "_drop_shadow_4", i]);
          e.appendChild(h);
        }
        extendPrototype([SVGComposableEffect], SVGTintFilter),
          (SVGTintFilter.prototype.renderFrame = function (e) {
            if (e || this.filterManager._mdf) {
              var t = this.filterManager.effectElements[0].p.v,
                r = this.filterManager.effectElements[1].p.v,
                n = this.filterManager.effectElements[2].p.v / 100;
              this.linearFilter.setAttribute(
                "values",
                linearFilterValue + " " + n + " 0"
              ),
                this.matrixFilter.setAttribute(
                  "values",
                  r[0] -
                    t[0] +
                    " 0 0 0 " +
                    t[0] +
                    " " +
                    (r[1] - t[1]) +
                    " 0 0 0 " +
                    t[1] +
                    " " +
                    (r[2] - t[2]) +
                    " 0 0 0 " +
                    t[2] +
                    " 0 0 0 1 0"
                );
            }
          }),
          (SVGFillFilter.prototype.renderFrame = function (e) {
            if (e || this.filterManager._mdf) {
              var t = this.filterManager.effectElements[2].p.v,
                r = this.filterManager.effectElements[6].p.v;
              this.matrixFilter.setAttribute(
                "values",
                "0 0 0 0 " +
                  t[0] +
                  " 0 0 0 0 " +
                  t[1] +
                  " 0 0 0 0 " +
                  t[2] +
                  " 0 0 0 " +
                  r +
                  " 0"
              );
            }
          }),
          (SVGStrokeEffect.prototype.initialize = function () {
            var e,
              t,
              r,
              n,
              i =
                this.elem.layerElement.children ||
                this.elem.layerElement.childNodes;
            for (
              this.filterManager.effectElements[1].p.v === 1
                ? ((n = this.elem.maskManager.masksProperties.length), (r = 0))
                : (n = (r = this.filterManager.effectElements[0].p.v - 1) + 1),
                (t = createNS("g")).setAttribute("fill", "none"),
                t.setAttribute("stroke-linecap", "round"),
                t.setAttribute("stroke-dashoffset", 1);
              r < n;
              r += 1
            )
              (e = createNS("path")),
                t.appendChild(e),
                this.paths.push({ p: e, m: r });
            if (this.filterManager.effectElements[10].p.v === 3) {
              var a = createNS("mask"),
                o = createElementID();
              a.setAttribute("id", o),
                a.setAttribute("mask-type", "alpha"),
                a.appendChild(t),
                this.elem.globalData.defs.appendChild(a);
              var s = createNS("g");
              for (
                s.setAttribute(
                  "mask",
                  "url(" + getLocationHref() + "#" + o + ")"
                );
                i[0];

              )
                s.appendChild(i[0]);
              this.elem.layerElement.appendChild(s),
                (this.masker = a),
                t.setAttribute("stroke", "#fff");
            } else if (
              this.filterManager.effectElements[10].p.v === 1 ||
              this.filterManager.effectElements[10].p.v === 2
            ) {
              if (this.filterManager.effectElements[10].p.v === 2)
                for (
                  i =
                    this.elem.layerElement.children ||
                    this.elem.layerElement.childNodes;
                  i.length;

                )
                  this.elem.layerElement.removeChild(i[0]);
              this.elem.layerElement.appendChild(t),
                this.elem.layerElement.removeAttribute("mask"),
                t.setAttribute("stroke", "#fff");
            }
            (this.initialized = !0), (this.pathMasker = t);
          }),
          (SVGStrokeEffect.prototype.renderFrame = function (e) {
            var t;
            this.initialized || this.initialize();
            var r,
              n,
              i = this.paths.length;
            for (t = 0; t < i; t += 1)
              if (
                this.paths[t].m !== -1 &&
                ((r = this.elem.maskManager.viewData[this.paths[t].m]),
                (n = this.paths[t].p),
                (e || this.filterManager._mdf || r.prop._mdf) &&
                  n.setAttribute("d", r.lastPath),
                e ||
                  this.filterManager.effectElements[9].p._mdf ||
                  this.filterManager.effectElements[4].p._mdf ||
                  this.filterManager.effectElements[7].p._mdf ||
                  this.filterManager.effectElements[8].p._mdf ||
                  r.prop._mdf)
              ) {
                var a;
                if (
                  this.filterManager.effectElements[7].p.v !== 0 ||
                  this.filterManager.effectElements[8].p.v !== 100
                ) {
                  var o =
                      0.01 *
                      Math.min(
                        this.filterManager.effectElements[7].p.v,
                        this.filterManager.effectElements[8].p.v
                      ),
                    s =
                      0.01 *
                      Math.max(
                        this.filterManager.effectElements[7].p.v,
                        this.filterManager.effectElements[8].p.v
                      ),
                    l = n.getTotalLength();
                  a = "0 0 0 " + l * o + " ";
                  var f,
                    u = l * (s - o),
                    h =
                      1 +
                      2 *
                        this.filterManager.effectElements[4].p.v *
                        this.filterManager.effectElements[9].p.v *
                        0.01,
                    m = Math.floor(u / h);
                  for (f = 0; f < m; f += 1)
                    a +=
                      "1 " +
                      2 *
                        this.filterManager.effectElements[4].p.v *
                        this.filterManager.effectElements[9].p.v *
                        0.01 +
                      " ";
                  a += "0 " + 10 * l + " 0 0";
                } else
                  a =
                    "1 " +
                    2 *
                      this.filterManager.effectElements[4].p.v *
                      this.filterManager.effectElements[9].p.v *
                      0.01;
                n.setAttribute("stroke-dasharray", a);
              }
            if (
              ((e || this.filterManager.effectElements[4].p._mdf) &&
                this.pathMasker.setAttribute(
                  "stroke-width",
                  2 * this.filterManager.effectElements[4].p.v
                ),
              (e || this.filterManager.effectElements[6].p._mdf) &&
                this.pathMasker.setAttribute(
                  "opacity",
                  this.filterManager.effectElements[6].p.v
                ),
              (this.filterManager.effectElements[10].p.v === 1 ||
                this.filterManager.effectElements[10].p.v === 2) &&
                (e || this.filterManager.effectElements[3].p._mdf))
            ) {
              var d = this.filterManager.effectElements[3].p.v;
              this.pathMasker.setAttribute(
                "stroke",
                "rgb(" +
                  bmFloor(255 * d[0]) +
                  "," +
                  bmFloor(255 * d[1]) +
                  "," +
                  bmFloor(255 * d[2]) +
                  ")"
              );
            }
          }),
          (SVGTritoneFilter.prototype.renderFrame = function (e) {
            if (e || this.filterManager._mdf) {
              var t = this.filterManager.effectElements[0].p.v,
                r = this.filterManager.effectElements[1].p.v,
                n = this.filterManager.effectElements[2].p.v,
                i = n[0] + " " + r[0] + " " + t[0],
                a = n[1] + " " + r[1] + " " + t[1],
                o = n[2] + " " + r[2] + " " + t[2];
              this.feFuncR.setAttribute("tableValues", i),
                this.feFuncG.setAttribute("tableValues", a),
                this.feFuncB.setAttribute("tableValues", o);
            }
          }),
          (SVGProLevelsFilter.prototype.createFeFunc = function (e, t) {
            var r = createNS(e);
            return r.setAttribute("type", "table"), t.appendChild(r), r;
          }),
          (SVGProLevelsFilter.prototype.getTableValue = function (
            e,
            t,
            r,
            n,
            i
          ) {
            for (
              var a,
                o,
                s = 0,
                l = Math.min(e, t),
                f = Math.max(e, t),
                u = Array.call(null, { length: 256 }),
                h = 0,
                m = i - n,
                d = t - e;
              s <= 256;

            )
              (o =
                (a = s / 256) <= l
                  ? d < 0
                    ? i
                    : n
                  : a >= f
                  ? d < 0
                    ? n
                    : i
                  : n + m * Math.pow((a - e) / d, 1 / r)),
                (u[h] = o),
                (h += 1),
                (s += 256 / 255);
            return u.join(" ");
          }),
          (SVGProLevelsFilter.prototype.renderFrame = function (e) {
            if (e || this.filterManager._mdf) {
              var t,
                r = this.filterManager.effectElements;
              this.feFuncRComposed &&
                (e ||
                  r[3].p._mdf ||
                  r[4].p._mdf ||
                  r[5].p._mdf ||
                  r[6].p._mdf ||
                  r[7].p._mdf) &&
                ((t = this.getTableValue(
                  r[3].p.v,
                  r[4].p.v,
                  r[5].p.v,
                  r[6].p.v,
                  r[7].p.v
                )),
                this.feFuncRComposed.setAttribute("tableValues", t),
                this.feFuncGComposed.setAttribute("tableValues", t),
                this.feFuncBComposed.setAttribute("tableValues", t)),
                this.feFuncR &&
                  (e ||
                    r[10].p._mdf ||
                    r[11].p._mdf ||
                    r[12].p._mdf ||
                    r[13].p._mdf ||
                    r[14].p._mdf) &&
                  ((t = this.getTableValue(
                    r[10].p.v,
                    r[11].p.v,
                    r[12].p.v,
                    r[13].p.v,
                    r[14].p.v
                  )),
                  this.feFuncR.setAttribute("tableValues", t)),
                this.feFuncG &&
                  (e ||
                    r[17].p._mdf ||
                    r[18].p._mdf ||
                    r[19].p._mdf ||
                    r[20].p._mdf ||
                    r[21].p._mdf) &&
                  ((t = this.getTableValue(
                    r[17].p.v,
                    r[18].p.v,
                    r[19].p.v,
                    r[20].p.v,
                    r[21].p.v
                  )),
                  this.feFuncG.setAttribute("tableValues", t)),
                this.feFuncB &&
                  (e ||
                    r[24].p._mdf ||
                    r[25].p._mdf ||
                    r[26].p._mdf ||
                    r[27].p._mdf ||
                    r[28].p._mdf) &&
                  ((t = this.getTableValue(
                    r[24].p.v,
                    r[25].p.v,
                    r[26].p.v,
                    r[27].p.v,
                    r[28].p.v
                  )),
                  this.feFuncB.setAttribute("tableValues", t)),
                this.feFuncA &&
                  (e ||
                    r[31].p._mdf ||
                    r[32].p._mdf ||
                    r[33].p._mdf ||
                    r[34].p._mdf ||
                    r[35].p._mdf) &&
                  ((t = this.getTableValue(
                    r[31].p.v,
                    r[32].p.v,
                    r[33].p.v,
                    r[34].p.v,
                    r[35].p.v
                  )),
                  this.feFuncA.setAttribute("tableValues", t));
            }
          }),
          extendPrototype([SVGComposableEffect], SVGDropShadowEffect),
          (SVGDropShadowEffect.prototype.renderFrame = function (e) {
            if (e || this.filterManager._mdf) {
              if (
                ((e || this.filterManager.effectElements[4].p._mdf) &&
                  this.feGaussianBlur.setAttribute(
                    "stdDeviation",
                    this.filterManager.effectElements[4].p.v / 4
                  ),
                e || this.filterManager.effectElements[0].p._mdf)
              ) {
                var t = this.filterManager.effectElements[0].p.v;
                this.feFlood.setAttribute(
                  "flood-color",
                  rgbToHex(
                    Math.round(255 * t[0]),
                    Math.round(255 * t[1]),
                    Math.round(255 * t[2])
                  )
                );
              }
              if (
                ((e || this.filterManager.effectElements[1].p._mdf) &&
                  this.feFlood.setAttribute(
                    "flood-opacity",
                    this.filterManager.effectElements[1].p.v / 255
                  ),
                e ||
                  this.filterManager.effectElements[2].p._mdf ||
                  this.filterManager.effectElements[3].p._mdf)
              ) {
                var r = this.filterManager.effectElements[3].p.v,
                  n =
                    (this.filterManager.effectElements[2].p.v - 90) * degToRads,
                  i = r * Math.cos(n),
                  a = r * Math.sin(n);
                this.feOffset.setAttribute("dx", i),
                  this.feOffset.setAttribute("dy", a);
              }
            }
          });
        var _svgMatteSymbols = [];
        function SVGMatte3Effect(e, t, r) {
          (this.initialized = !1),
            (this.filterManager = t),
            (this.filterElem = e),
            (this.elem = r),
            (r.matteElement = createNS("g")),
            r.matteElement.appendChild(r.layerElement),
            r.matteElement.appendChild(r.transformedElement),
            (r.baseElement = r.matteElement);
        }
        function SVGGaussianBlurEffect(e, t, r, n) {
          e.setAttribute("x", "-100%"),
            e.setAttribute("y", "-100%"),
            e.setAttribute("width", "300%"),
            e.setAttribute("height", "300%"),
            (this.filterManager = t);
          var i = createNS("feGaussianBlur");
          i.setAttribute("result", n),
            e.appendChild(i),
            (this.feGaussianBlur = i);
        }
        function TransformEffect() {}
        function SVGTransformEffect(e, t) {
          this.init(t);
        }
        function CVTransformEffect(e) {
          this.init(e);
        }
        return (
          (SVGMatte3Effect.prototype.findSymbol = function (e) {
            for (var t = 0, r = _svgMatteSymbols.length; t < r; ) {
              if (_svgMatteSymbols[t] === e) return _svgMatteSymbols[t];
              t += 1;
            }
            return null;
          }),
          (SVGMatte3Effect.prototype.replaceInParent = function (e, t) {
            var r = e.layerElement.parentNode;
            if (r) {
              for (
                var n, i = r.children, a = 0, o = i.length;
                a < o && i[a] !== e.layerElement;

              )
                a += 1;
              a <= o - 2 && (n = i[a + 1]);
              var s = createNS("use");
              s.setAttribute("href", "#" + t),
                n ? r.insertBefore(s, n) : r.appendChild(s);
            }
          }),
          (SVGMatte3Effect.prototype.setElementAsMask = function (e, t) {
            if (!this.findSymbol(t)) {
              var r = createElementID(),
                n = createNS("mask");
              n.setAttribute("id", t.layerId),
                n.setAttribute("mask-type", "alpha"),
                _svgMatteSymbols.push(t);
              var i = e.globalData.defs;
              i.appendChild(n);
              var a = createNS("symbol");
              a.setAttribute("id", r),
                this.replaceInParent(t, r),
                a.appendChild(t.layerElement),
                i.appendChild(a);
              var o = createNS("use");
              o.setAttribute("href", "#" + r),
                n.appendChild(o),
                (t.data.hd = !1),
                t.show();
            }
            e.setMatte(t.layerId);
          }),
          (SVGMatte3Effect.prototype.initialize = function () {
            for (
              var e = this.filterManager.effectElements[0].p.v,
                t = this.elem.comp.elements,
                r = 0,
                n = t.length;
              r < n;

            )
              t[r] &&
                t[r].data.ind === e &&
                this.setElementAsMask(this.elem, t[r]),
                (r += 1);
            this.initialized = !0;
          }),
          (SVGMatte3Effect.prototype.renderFrame = function () {
            this.initialized || this.initialize();
          }),
          (SVGGaussianBlurEffect.prototype.renderFrame = function (e) {
            if (e || this.filterManager._mdf) {
              var t = 0.3 * this.filterManager.effectElements[0].p.v,
                r = this.filterManager.effectElements[1].p.v,
                n = r == 3 ? 0 : t,
                i = r == 2 ? 0 : t;
              this.feGaussianBlur.setAttribute("stdDeviation", n + " " + i);
              var a =
                this.filterManager.effectElements[2].p.v == 1
                  ? "wrap"
                  : "duplicate";
              this.feGaussianBlur.setAttribute("edgeMode", a);
            }
          }),
          (TransformEffect.prototype.init = function (e) {
            (this.effectsManager = e),
              (this.type = effectTypes.TRANSFORM_EFFECT),
              (this.matrix = new Matrix()),
              (this.opacity = -1),
              (this._mdf = !1),
              (this._opMdf = !1);
          }),
          (TransformEffect.prototype.renderFrame = function (e) {
            if (
              ((this._opMdf = !1),
              (this._mdf = !1),
              e || this.effectsManager._mdf)
            ) {
              var t = this.effectsManager.effectElements,
                r = t[0].p.v,
                n = t[1].p.v,
                i = t[2].p.v === 1,
                a = t[3].p.v,
                o = i ? a : t[4].p.v,
                s = t[5].p.v,
                l = t[6].p.v,
                f = t[7].p.v;
              this.matrix.reset(),
                this.matrix.translate(-r[0], -r[1], r[2]),
                this.matrix.scale(0.01 * o, 0.01 * a, 1),
                this.matrix.rotate(-f * degToRads),
                this.matrix.skewFromAxis(-s * degToRads, (l + 90) * degToRads),
                this.matrix.translate(n[0], n[1], 0),
                (this._mdf = !0),
                this.opacity !== t[8].p.v &&
                  ((this.opacity = t[8].p.v), (this._opMdf = !0));
            }
          }),
          extendPrototype([TransformEffect], SVGTransformEffect),
          extendPrototype([TransformEffect], CVTransformEffect),
          registerRenderer("canvas", CanvasRenderer),
          registerRenderer("html", HybridRenderer),
          registerRenderer("svg", SVGRenderer),
          ShapeModifiers.registerModifier("tm", TrimModifier),
          ShapeModifiers.registerModifier("pb", PuckerAndBloatModifier),
          ShapeModifiers.registerModifier("rp", RepeaterModifier),
          ShapeModifiers.registerModifier("rd", RoundCornersModifier),
          ShapeModifiers.registerModifier("zz", ZigZagModifier),
          ShapeModifiers.registerModifier("op", OffsetPathModifier),
          setExpressionsPlugin(Expressions),
          setExpressionInterfaces(getInterface),
          initialize$1(),
          initialize(),
          registerEffect$1(20, SVGTintFilter, !0),
          registerEffect$1(21, SVGFillFilter, !0),
          registerEffect$1(22, SVGStrokeEffect, !1),
          registerEffect$1(23, SVGTritoneFilter, !0),
          registerEffect$1(24, SVGProLevelsFilter, !0),
          registerEffect$1(25, SVGDropShadowEffect, !0),
          registerEffect$1(28, SVGMatte3Effect, !1),
          registerEffect$1(29, SVGGaussianBlurEffect, !0),
          registerEffect$1(35, SVGTransformEffect, !1),
          registerEffect(35, CVTransformEffect),
          lottie
        );
      });
  });
  var $x = E((uoe, Xx) => {
    "use strict";
    var gU = Ne(),
      oi = (Wx(), ht(jx)),
      vU = Ux();
    gU.define(
      "lottie",
      (Xx.exports = function () {
        return {
          lottie: vU,
          createInstance: oi.createInstance,
          cleanupElement: oi.cleanupElement,
          init: oi.init,
          destroy: oi.destroy,
          ready: oi.ready,
        };
      })
    );
  });
  var Kx = E(() => {
    "use strict";
    (function () {
      if (typeof window > "u") return;
      let e = window.navigator.userAgent.match(/Edge\/(\d{2})\./),
        t = e ? parseInt(e[1], 10) >= 16 : !1;
      if ("objectFit" in document.documentElement.style && !t) {
        window.objectFitPolyfill = function () {
          return !1;
        };
        return;
      }
      let n = function (s) {
          let l = window.getComputedStyle(s, null),
            f = l.getPropertyValue("position"),
            u = l.getPropertyValue("overflow"),
            h = l.getPropertyValue("display");
          (!f || f === "static") && (s.style.position = "relative"),
            u !== "hidden" && (s.style.overflow = "hidden"),
            (!h || h === "inline") && (s.style.display = "block"),
            s.clientHeight === 0 && (s.style.height = "100%"),
            s.className.indexOf("object-fit-polyfill") === -1 &&
              (s.className += " object-fit-polyfill");
        },
        i = function (s) {
          let l = window.getComputedStyle(s, null),
            f = {
              "max-width": "none",
              "max-height": "none",
              "min-width": "0px",
              "min-height": "0px",
              top: "auto",
              right: "auto",
              bottom: "auto",
              left: "auto",
              "margin-top": "0px",
              "margin-right": "0px",
              "margin-bottom": "0px",
              "margin-left": "0px",
            };
          for (let u in f)
            l.getPropertyValue(u) !== f[u] && (s.style[u] = f[u]);
        },
        a = function (s) {
          let l = s.parentNode;
          n(l),
            i(s),
            (s.style.position = "absolute"),
            (s.style.height = "100%"),
            (s.style.width = "auto"),
            s.clientWidth > l.clientWidth
              ? ((s.style.top = "0"),
                (s.style.marginTop = "0"),
                (s.style.left = "50%"),
                (s.style.marginLeft = s.clientWidth / -2 + "px"))
              : ((s.style.width = "100%"),
                (s.style.height = "auto"),
                (s.style.left = "0"),
                (s.style.marginLeft = "0"),
                (s.style.top = "50%"),
                (s.style.marginTop = s.clientHeight / -2 + "px"));
        },
        o = function (s) {
          if (typeof s > "u" || s instanceof Event)
            s = document.querySelectorAll("[data-object-fit]");
          else if (s && s.nodeName) s = [s];
          else if (typeof s == "object" && s.length && s[0].nodeName) s = s;
          else return !1;
          for (let l = 0; l < s.length; l++) {
            if (!s[l].nodeName) continue;
            let f = s[l].nodeName.toLowerCase();
            if (f === "img") {
              if (t) continue;
              s[l].complete
                ? a(s[l])
                : s[l].addEventListener("load", function () {
                    a(this);
                  });
            } else
              f === "video"
                ? s[l].readyState > 0
                  ? a(s[l])
                  : s[l].addEventListener("loadedmetadata", function () {
                      a(this);
                    })
                : a(s[l]);
          }
          return !0;
        };
      document.readyState === "loading"
        ? document.addEventListener("DOMContentLoaded", o)
        : o(),
        window.addEventListener("resize", o),
        (window.objectFitPolyfill = o);
    })();
  });
  var Yx = E(() => {
    "use strict";
    (function () {
      if (typeof window > "u") return;
      function e(n) {
        Webflow.env("design") ||
          ($("video").each(function () {
            n && $(this).prop("autoplay") ? this.play() : this.pause();
          }),
          $(".w-background-video--control").each(function () {
            n ? r($(this)) : t($(this));
          }));
      }
      function t(n) {
        n.find("> span").each(function (i) {
          $(this).prop("hidden", () => i === 0);
        });
      }
      function r(n) {
        n.find("> span").each(function (i) {
          $(this).prop("hidden", () => i === 1);
        });
      }
      $(document).ready(() => {
        let n = window.matchMedia("(prefers-reduced-motion: reduce)");
        n.addEventListener("change", (i) => {
          e(!i.matches);
        }),
          n.matches && e(!1),
          $("video:not([autoplay])").each(function () {
            $(this)
              .parent()
              .find(".w-background-video--control")
              .each(function () {
                t($(this));
              });
          }),
          $(document).on("click", ".w-background-video--control", function (i) {
            if (Webflow.env("design")) return;
            let a = $(i.currentTarget),
              o = $(`video#${a.attr("aria-controls")}`).get(0);
            if (o)
              if (o.paused) {
                let s = o.play();
                r(a),
                  s &&
                    typeof s.catch == "function" &&
                    s.catch(() => {
                      t(a);
                    });
              } else o.pause(), t(a);
          });
      });
    })();
  });
  var Jx = E((doe, Zx) => {
    "use strict";
    var Qx = Ne();
    Qx.define(
      "brand",
      (Zx.exports = function (e) {
        var t = {},
          r = document,
          n = e("html"),
          i = e("body"),
          a = ".w-webflow-badge",
          o = window.location,
          s = /PhantomJS/i.test(navigator.userAgent),
          l =
            "fullscreenchange webkitfullscreenchange mozfullscreenchange msfullscreenchange",
          f;
        t.ready = function () {
          var d = n.attr("data-wf-status"),
            p = n.attr("data-wf-domain") || "";
          /\.webflow\.io$/i.test(p) && o.hostname !== p && (d = !0),
            d &&
              !s &&
              ((f = f || h()),
              m(),
              setTimeout(m, 500),
              e(r).off(l, u).on(l, u));
        };
        function u() {
          var d =
            r.fullScreen ||
            r.mozFullScreen ||
            r.webkitIsFullScreen ||
            r.msFullscreenElement ||
            !!r.webkitFullscreenElement;
          e(f).attr("style", d ? "display: none !important;" : "");
        }
        function h() {
          var d = e('<a class="w-webflow-badge"></a>').attr(
              "href",
              "https://webflow.com?utm_campaign=brandjs"
            ),
            p = e("<img>")
              .attr(
                "src",
                "https://d3e54v103j8qbb.cloudfront.net/img/webflow-badge-icon-d2.89e12c322e.svg"
              )
              .attr("alt", "")
              .css({ marginRight: "4px", width: "26px" }),
            g = e("<img>")
              .attr(
                "src",
                "https://d3e54v103j8qbb.cloudfront.net/img/webflow-badge-text-d2.c82cec3b78.svg"
              )
              .attr("alt", "Made in Webflow");
          return d.append(p, g), d[0];
        }
        function m() {
          var d = i.children(a),
            p = d.length && d.get(0) === f,
            g = Qx.env("editor");
          if (p) {
            g && d.remove();
            return;
          }
          d.length && d.remove(), g || i.append(f);
        }
        return t;
      })
    );
  });
  var tS = E((moe, eS) => {
    "use strict";
    var Eu = Ne();
    Eu.define(
      "edit",
      (eS.exports = function (e, t, r) {
        if (
          ((r = r || {}),
          (Eu.env("test") || Eu.env("frame")) && !r.fixture && !yU())
        )
          return { exit: 1 };
        var n = {},
          i = e(window),
          a = e(document.documentElement),
          o = document.location,
          s = "hashchange",
          l,
          f = r.load || m,
          u = !1;
        try {
          u =
            localStorage &&
            localStorage.getItem &&
            localStorage.getItem("WebflowEditor");
        } catch {}
        u
          ? f()
          : o.search
          ? (/[?&](edit)(?:[=&?]|$)/.test(o.search) ||
              /\?edit$/.test(o.href)) &&
            f()
          : i.on(s, h).triggerHandler(s);
        function h() {
          l || (/\?edit/.test(o.hash) && f());
        }
        function m() {
          (l = !0),
            (window.WebflowEditor = !0),
            i.off(s, h),
            y(function (x) {
              e.ajax({
                url: v("https://editor-api.webflow.com/api/editor/view"),
                data: { siteId: a.attr("data-wf-site") },
                xhrFields: { withCredentials: !0 },
                dataType: "json",
                crossDomain: !0,
                success: d(x),
              });
            });
        }
        function d(x) {
          return function (S) {
            if (!S) {
              console.error("Could not load editor data");
              return;
            }
            (S.thirdPartyCookiesSupported = x),
              p(c(S.scriptPath), function () {
                window.WebflowEditor(S);
              });
          };
        }
        function p(x, S) {
          e.ajax({ type: "GET", url: x, dataType: "script", cache: !0 }).then(
            S,
            g
          );
        }
        function g(x, S, T) {
          throw (console.error("Could not load editor script: " + S), T);
        }
        function c(x) {
          return x.indexOf("//") >= 0
            ? x
            : v("https://editor-api.webflow.com" + x);
        }
        function v(x) {
          return x.replace(/([^:])\/\//g, "$1/");
        }
        function y(x) {
          var S = window.document.createElement("iframe");
          (S.src = "https://webflow.com/site/third-party-cookie-check.html"),
            (S.style.display = "none"),
            (S.sandbox = "allow-scripts allow-same-origin");
          var T = function (I) {
            I.data === "WF_third_party_cookies_unsupported"
              ? (b(S, T), x(!1))
              : I.data === "WF_third_party_cookies_supported" &&
                (b(S, T), x(!0));
          };
          (S.onerror = function () {
            b(S, T), x(!1);
          }),
            window.addEventListener("message", T, !1),
            window.document.body.appendChild(S);
        }
        function b(x, S) {
          window.removeEventListener("message", S, !1), x.remove();
        }
        return n;
      })
    );
    function yU() {
      try {
        return window.top.__Cypress__;
      } catch {
        return !1;
      }
    }
  });
  var nS = E((goe, rS) => {
    "use strict";
    var EU = Ne();
    EU.define(
      "focus-visible",
      (rS.exports = function () {
        function e(r) {
          var n = !0,
            i = !1,
            a = null,
            o = {
              text: !0,
              search: !0,
              url: !0,
              tel: !0,
              email: !0,
              password: !0,
              number: !0,
              date: !0,
              month: !0,
              week: !0,
              time: !0,
              datetime: !0,
              "datetime-local": !0,
            };
          function s(b) {
            return !!(
              b &&
              b !== document &&
              b.nodeName !== "HTML" &&
              b.nodeName !== "BODY" &&
              "classList" in b &&
              "contains" in b.classList
            );
          }
          function l(b) {
            var x = b.type,
              S = b.tagName;
            return !!(
              (S === "INPUT" && o[x] && !b.readOnly) ||
              (S === "TEXTAREA" && !b.readOnly) ||
              b.isContentEditable
            );
          }
          function f(b) {
            b.getAttribute("data-wf-focus-visible") ||
              b.setAttribute("data-wf-focus-visible", "true");
          }
          function u(b) {
            b.getAttribute("data-wf-focus-visible") &&
              b.removeAttribute("data-wf-focus-visible");
          }
          function h(b) {
            b.metaKey ||
              b.altKey ||
              b.ctrlKey ||
              (s(r.activeElement) && f(r.activeElement), (n = !0));
          }
          function m() {
            n = !1;
          }
          function d(b) {
            s(b.target) && (n || l(b.target)) && f(b.target);
          }
          function p(b) {
            s(b.target) &&
              b.target.hasAttribute("data-wf-focus-visible") &&
              ((i = !0),
              window.clearTimeout(a),
              (a = window.setTimeout(function () {
                i = !1;
              }, 100)),
              u(b.target));
          }
          function g() {
            document.visibilityState === "hidden" && (i && (n = !0), c());
          }
          function c() {
            document.addEventListener("mousemove", y),
              document.addEventListener("mousedown", y),
              document.addEventListener("mouseup", y),
              document.addEventListener("pointermove", y),
              document.addEventListener("pointerdown", y),
              document.addEventListener("pointerup", y),
              document.addEventListener("touchmove", y),
              document.addEventListener("touchstart", y),
              document.addEventListener("touchend", y);
          }
          function v() {
            document.removeEventListener("mousemove", y),
              document.removeEventListener("mousedown", y),
              document.removeEventListener("mouseup", y),
              document.removeEventListener("pointermove", y),
              document.removeEventListener("pointerdown", y),
              document.removeEventListener("pointerup", y),
              document.removeEventListener("touchmove", y),
              document.removeEventListener("touchstart", y),
              document.removeEventListener("touchend", y);
          }
          function y(b) {
            (b.target.nodeName && b.target.nodeName.toLowerCase() === "html") ||
              ((n = !1), v());
          }
          document.addEventListener("keydown", h, !0),
            document.addEventListener("mousedown", m, !0),
            document.addEventListener("pointerdown", m, !0),
            document.addEventListener("touchstart", m, !0),
            document.addEventListener("visibilitychange", g, !0),
            c(),
            r.addEventListener("focus", d, !0),
            r.addEventListener("blur", p, !0);
        }
        function t() {
          if (typeof document < "u")
            try {
              document.querySelector(":focus-visible");
            } catch {
              e(document);
            }
        }
        return { ready: t };
      })
    );
  });
  var sS = E((voe, aS) => {
    "use strict";
    var iS = Ne();
    iS.define(
      "focus",
      (aS.exports = function () {
        var e = [],
          t = !1;
        function r(o) {
          t &&
            (o.preventDefault(),
            o.stopPropagation(),
            o.stopImmediatePropagation(),
            e.unshift(o));
        }
        function n(o) {
          var s = o.target,
            l = s.tagName;
          return (
            (/^a$/i.test(l) && s.href != null) ||
            (/^(button|textarea)$/i.test(l) && s.disabled !== !0) ||
            (/^input$/i.test(l) &&
              /^(button|reset|submit|radio|checkbox)$/i.test(s.type) &&
              !s.disabled) ||
            (!/^(button|input|textarea|select|a)$/i.test(l) &&
              !Number.isNaN(Number.parseFloat(s.tabIndex))) ||
            /^audio$/i.test(l) ||
            (/^video$/i.test(l) && s.controls === !0)
          );
        }
        function i(o) {
          n(o) &&
            ((t = !0),
            setTimeout(() => {
              for (t = !1, o.target.focus(); e.length > 0; ) {
                var s = e.pop();
                s.target.dispatchEvent(new MouseEvent(s.type, s));
              }
            }, 0));
        }
        function a() {
          typeof document < "u" &&
            document.body.hasAttribute("data-wf-focus-within") &&
            iS.env.safari &&
            (document.addEventListener("mousedown", i, !0),
            document.addEventListener("mouseup", r, !0),
            document.addEventListener("click", r, !0));
        }
        return { ready: a };
      })
    );
  });
  var uS = E((yoe, lS) => {
    "use strict";
    var bu = window.jQuery,
      Ct = {},
      Ua = [],
      oS = ".w-ix",
      Xa = {
        reset: function (e, t) {
          t.__wf_intro = null;
        },
        intro: function (e, t) {
          t.__wf_intro ||
            ((t.__wf_intro = !0), bu(t).triggerHandler(Ct.types.INTRO));
        },
        outro: function (e, t) {
          t.__wf_intro &&
            ((t.__wf_intro = null), bu(t).triggerHandler(Ct.types.OUTRO));
        },
      };
    Ct.triggers = {};
    Ct.types = { INTRO: "w-ix-intro" + oS, OUTRO: "w-ix-outro" + oS };
    Ct.init = function () {
      for (var e = Ua.length, t = 0; t < e; t++) {
        var r = Ua[t];
        r[0](0, r[1]);
      }
      (Ua = []), bu.extend(Ct.triggers, Xa);
    };
    Ct.async = function () {
      for (var e in Xa) {
        var t = Xa[e];
        Xa.hasOwnProperty(e) &&
          (Ct.triggers[e] = function (r, n) {
            Ua.push([t, n]);
          });
      }
    };
    Ct.async();
    lS.exports = Ct;
  });
  var li = E((Eoe, fS) => {
    "use strict";
    var xu = uS();
    function cS(e, t) {
      var r = document.createEvent("CustomEvent");
      r.initCustomEvent(t, !0, !0, null), e.dispatchEvent(r);
    }
    var bU = window.jQuery,
      $a = {},
      hS = ".w-ix",
      xU = {
        reset: function (e, t) {
          xu.triggers.reset(e, t);
        },
        intro: function (e, t) {
          xu.triggers.intro(e, t), cS(t, "COMPONENT_ACTIVE");
        },
        outro: function (e, t) {
          xu.triggers.outro(e, t), cS(t, "COMPONENT_INACTIVE");
        },
      };
    $a.triggers = {};
    $a.types = { INTRO: "w-ix-intro" + hS, OUTRO: "w-ix-outro" + hS };
    bU.extend($a.triggers, xU);
    fS.exports = $a;
  });
  var Su = E((boe, pS) => {
    var SU = io(),
      _U = SU(Object.getPrototypeOf, Object);
    pS.exports = _U;
  });
  var _u = E((xoe, mS) => {
    var IU = Xt(),
      TU = Su(),
      AU = Ft(),
      PU = "[object Object]",
      wU = Function.prototype,
      CU = Object.prototype,
      dS = wU.toString,
      MU = CU.hasOwnProperty,
      OU = dS.call(Object);
    function RU(e) {
      if (!AU(e) || IU(e) != PU) return !1;
      var t = TU(e);
      if (t === null) return !0;
      var r = MU.call(t, "constructor") && t.constructor;
      return typeof r == "function" && r instanceof r && dS.call(r) == OU;
    }
    mS.exports = RU;
  });
  var gS = E((Iu) => {
    "use strict";
    Object.defineProperty(Iu, "__esModule", { value: !0 });
    Iu.default = DU;
    function DU(e) {
      var t,
        r = e.Symbol;
      return (
        typeof r == "function"
          ? r.observable
            ? (t = r.observable)
            : ((t = r("observable")), (r.observable = t))
          : (t = "@@observable"),
        t
      );
    }
  });
  var vS = E((Au, Tu) => {
    "use strict";
    Object.defineProperty(Au, "__esModule", { value: !0 });
    var FU = gS(),
      LU = qU(FU);
    function qU(e) {
      return e && e.__esModule ? e : { default: e };
    }
    var tn;
    typeof self < "u"
      ? (tn = self)
      : typeof window < "u"
      ? (tn = window)
      : typeof global < "u"
      ? (tn = global)
      : typeof Tu < "u"
      ? (tn = Tu)
      : (tn = Function("return this")());
    var kU = (0, LU.default)(tn);
    Au.default = kU;
  });
  var Pu = E((ui) => {
    "use strict";
    ui.__esModule = !0;
    ui.ActionTypes = void 0;
    ui.default = xS;
    var NU = _u(),
      BU = bS(NU),
      VU = vS(),
      yS = bS(VU);
    function bS(e) {
      return e && e.__esModule ? e : { default: e };
    }
    var ES = (ui.ActionTypes = { INIT: "@@redux/INIT" });
    function xS(e, t, r) {
      var n;
      if (
        (typeof t == "function" && typeof r > "u" && ((r = t), (t = void 0)),
        typeof r < "u")
      ) {
        if (typeof r != "function")
          throw new Error("Expected the enhancer to be a function.");
        return r(xS)(e, t);
      }
      if (typeof e != "function")
        throw new Error("Expected the reducer to be a function.");
      var i = e,
        a = t,
        o = [],
        s = o,
        l = !1;
      function f() {
        s === o && (s = o.slice());
      }
      function u() {
        return a;
      }
      function h(g) {
        if (typeof g != "function")
          throw new Error("Expected listener to be a function.");
        var c = !0;
        return (
          f(),
          s.push(g),
          function () {
            if (c) {
              (c = !1), f();
              var y = s.indexOf(g);
              s.splice(y, 1);
            }
          }
        );
      }
      function m(g) {
        if (!(0, BU.default)(g))
          throw new Error(
            "Actions must be plain objects. Use custom middleware for async actions."
          );
        if (typeof g.type > "u")
          throw new Error(
            'Actions may not have an undefined "type" property. Have you misspelled a constant?'
          );
        if (l) throw new Error("Reducers may not dispatch actions.");
        try {
          (l = !0), (a = i(a, g));
        } finally {
          l = !1;
        }
        for (var c = (o = s), v = 0; v < c.length; v++) c[v]();
        return g;
      }
      function d(g) {
        if (typeof g != "function")
          throw new Error("Expected the nextReducer to be a function.");
        (i = g), m({ type: ES.INIT });
      }
      function p() {
        var g,
          c = h;
        return (
          (g = {
            subscribe: function (y) {
              if (typeof y != "object")
                throw new TypeError("Expected the observer to be an object.");
              function b() {
                y.next && y.next(u());
              }
              b();
              var x = c(b);
              return { unsubscribe: x };
            },
          }),
          (g[yS.default] = function () {
            return this;
          }),
          g
        );
      }
      return (
        m({ type: ES.INIT }),
        (n = { dispatch: m, subscribe: h, getState: u, replaceReducer: d }),
        (n[yS.default] = p),
        n
      );
    }
  });
  var Cu = E((wu) => {
    "use strict";
    wu.__esModule = !0;
    wu.default = GU;
    function GU(e) {
      typeof console < "u" &&
        typeof console.error == "function" &&
        console.error(e);
      try {
        throw new Error(e);
      } catch {}
    }
  });
  var IS = E((Mu) => {
    "use strict";
    Mu.__esModule = !0;
    Mu.default = UU;
    var SS = Pu(),
      zU = _u(),
      Toe = _S(zU),
      HU = Cu(),
      Aoe = _S(HU);
    function _S(e) {
      return e && e.__esModule ? e : { default: e };
    }
    function jU(e, t) {
      var r = t && t.type,
        n = (r && '"' + r.toString() + '"') || "an action";
      return (
        "Given action " +
        n +
        ', reducer "' +
        e +
        '" returned undefined. To ignore an action, you must explicitly return the previous state.'
      );
    }
    function WU(e) {
      Object.keys(e).forEach(function (t) {
        var r = e[t],
          n = r(void 0, { type: SS.ActionTypes.INIT });
        if (typeof n > "u")
          throw new Error(
            'Reducer "' +
              t +
              '" returned undefined during initialization. If the state passed to the reducer is undefined, you must explicitly return the initial state. The initial state may not be undefined.'
          );
        var i =
          "@@redux/PROBE_UNKNOWN_ACTION_" +
          Math.random().toString(36).substring(7).split("").join(".");
        if (typeof r(void 0, { type: i }) > "u")
          throw new Error(
            'Reducer "' +
              t +
              '" returned undefined when probed with a random type. ' +
              ("Don't try to handle " +
                SS.ActionTypes.INIT +
                ' or other actions in "redux/*" ') +
              "namespace. They are considered private. Instead, you must return the current state for any unknown actions, unless it is undefined, in which case you must return the initial state, regardless of the action type. The initial state may not be undefined."
          );
      });
    }
    function UU(e) {
      for (var t = Object.keys(e), r = {}, n = 0; n < t.length; n++) {
        var i = t[n];
        typeof e[i] == "function" && (r[i] = e[i]);
      }
      var a = Object.keys(r);
      if (!1) var o;
      var s;
      try {
        WU(r);
      } catch (l) {
        s = l;
      }
      return function () {
        var f =
            arguments.length <= 0 || arguments[0] === void 0
              ? {}
              : arguments[0],
          u = arguments[1];
        if (s) throw s;
        if (!1) var h;
        for (var m = !1, d = {}, p = 0; p < a.length; p++) {
          var g = a[p],
            c = r[g],
            v = f[g],
            y = c(v, u);
          if (typeof y > "u") {
            var b = jU(g, u);
            throw new Error(b);
          }
          (d[g] = y), (m = m || y !== v);
        }
        return m ? d : f;
      };
    }
  });
  var AS = E((Ou) => {
    "use strict";
    Ou.__esModule = !0;
    Ou.default = XU;
    function TS(e, t) {
      return function () {
        return t(e.apply(void 0, arguments));
      };
    }
    function XU(e, t) {
      if (typeof e == "function") return TS(e, t);
      if (typeof e != "object" || e === null)
        throw new Error(
          "bindActionCreators expected an object or a function, instead received " +
            (e === null ? "null" : typeof e) +
            '. Did you write "import ActionCreators from" instead of "import * as ActionCreators from"?'
        );
      for (var r = Object.keys(e), n = {}, i = 0; i < r.length; i++) {
        var a = r[i],
          o = e[a];
        typeof o == "function" && (n[a] = TS(o, t));
      }
      return n;
    }
  });
  var Du = E((Ru) => {
    "use strict";
    Ru.__esModule = !0;
    Ru.default = $U;
    function $U() {
      for (var e = arguments.length, t = Array(e), r = 0; r < e; r++)
        t[r] = arguments[r];
      if (t.length === 0)
        return function (a) {
          return a;
        };
      if (t.length === 1) return t[0];
      var n = t[t.length - 1],
        i = t.slice(0, -1);
      return function () {
        return i.reduceRight(function (a, o) {
          return o(a);
        }, n.apply(void 0, arguments));
      };
    }
  });
  var PS = E((Fu) => {
    "use strict";
    Fu.__esModule = !0;
    var KU =
      Object.assign ||
      function (e) {
        for (var t = 1; t < arguments.length; t++) {
          var r = arguments[t];
          for (var n in r)
            Object.prototype.hasOwnProperty.call(r, n) && (e[n] = r[n]);
        }
        return e;
      };
    Fu.default = JU;
    var YU = Du(),
      QU = ZU(YU);
    function ZU(e) {
      return e && e.__esModule ? e : { default: e };
    }
    function JU() {
      for (var e = arguments.length, t = Array(e), r = 0; r < e; r++)
        t[r] = arguments[r];
      return function (n) {
        return function (i, a, o) {
          var s = n(i, a, o),
            l = s.dispatch,
            f = [],
            u = {
              getState: s.getState,
              dispatch: function (m) {
                return l(m);
              },
            };
          return (
            (f = t.map(function (h) {
              return h(u);
            })),
            (l = QU.default.apply(void 0, f)(s.dispatch)),
            KU({}, s, { dispatch: l })
          );
        };
      };
    }
  });
  var Lu = E((lt) => {
    "use strict";
    lt.__esModule = !0;
    lt.compose =
      lt.applyMiddleware =
      lt.bindActionCreators =
      lt.combineReducers =
      lt.createStore =
        void 0;
    var e4 = Pu(),
      t4 = rn(e4),
      r4 = IS(),
      n4 = rn(r4),
      i4 = AS(),
      a4 = rn(i4),
      s4 = PS(),
      o4 = rn(s4),
      l4 = Du(),
      u4 = rn(l4),
      c4 = Cu(),
      Ooe = rn(c4);
    function rn(e) {
      return e && e.__esModule ? e : { default: e };
    }
    lt.createStore = t4.default;
    lt.combineReducers = n4.default;
    lt.bindActionCreators = a4.default;
    lt.applyMiddleware = o4.default;
    lt.compose = u4.default;
  });
  var Et,
    qu,
    Mt,
    h4,
    f4,
    Ka,
    p4,
    ku = Ee(() => {
      "use strict";
      (Et = {
        NAVBAR_OPEN: "NAVBAR_OPEN",
        NAVBAR_CLOSE: "NAVBAR_CLOSE",
        TAB_ACTIVE: "TAB_ACTIVE",
        TAB_INACTIVE: "TAB_INACTIVE",
        SLIDER_ACTIVE: "SLIDER_ACTIVE",
        SLIDER_INACTIVE: "SLIDER_INACTIVE",
        DROPDOWN_OPEN: "DROPDOWN_OPEN",
        DROPDOWN_CLOSE: "DROPDOWN_CLOSE",
        MOUSE_CLICK: "MOUSE_CLICK",
        MOUSE_SECOND_CLICK: "MOUSE_SECOND_CLICK",
        MOUSE_DOWN: "MOUSE_DOWN",
        MOUSE_UP: "MOUSE_UP",
        MOUSE_OVER: "MOUSE_OVER",
        MOUSE_OUT: "MOUSE_OUT",
        MOUSE_MOVE: "MOUSE_MOVE",
        MOUSE_MOVE_IN_VIEWPORT: "MOUSE_MOVE_IN_VIEWPORT",
        SCROLL_INTO_VIEW: "SCROLL_INTO_VIEW",
        SCROLL_OUT_OF_VIEW: "SCROLL_OUT_OF_VIEW",
        SCROLLING_IN_VIEW: "SCROLLING_IN_VIEW",
        ECOMMERCE_CART_OPEN: "ECOMMERCE_CART_OPEN",
        ECOMMERCE_CART_CLOSE: "ECOMMERCE_CART_CLOSE",
        PAGE_START: "PAGE_START",
        PAGE_FINISH: "PAGE_FINISH",
        PAGE_SCROLL_UP: "PAGE_SCROLL_UP",
        PAGE_SCROLL_DOWN: "PAGE_SCROLL_DOWN",
        PAGE_SCROLL: "PAGE_SCROLL",
      }),
        (qu = { ELEMENT: "ELEMENT", CLASS: "CLASS", PAGE: "PAGE" }),
        (Mt = { ELEMENT: "ELEMENT", VIEWPORT: "VIEWPORT" }),
        (h4 = { X_AXIS: "X_AXIS", Y_AXIS: "Y_AXIS" }),
        (f4 = {
          CHILDREN: "CHILDREN",
          SIBLINGS: "SIBLINGS",
          IMMEDIATE_CHILDREN: "IMMEDIATE_CHILDREN",
        }),
        (Ka = {
          FADE_EFFECT: "FADE_EFFECT",
          SLIDE_EFFECT: "SLIDE_EFFECT",
          GROW_EFFECT: "GROW_EFFECT",
          SHRINK_EFFECT: "SHRINK_EFFECT",
          SPIN_EFFECT: "SPIN_EFFECT",
          FLY_EFFECT: "FLY_EFFECT",
          POP_EFFECT: "POP_EFFECT",
          FLIP_EFFECT: "FLIP_EFFECT",
          JIGGLE_EFFECT: "JIGGLE_EFFECT",
          PULSE_EFFECT: "PULSE_EFFECT",
          DROP_EFFECT: "DROP_EFFECT",
          BLINK_EFFECT: "BLINK_EFFECT",
          BOUNCE_EFFECT: "BOUNCE_EFFECT",
          FLIP_LEFT_TO_RIGHT_EFFECT: "FLIP_LEFT_TO_RIGHT_EFFECT",
          FLIP_RIGHT_TO_LEFT_EFFECT: "FLIP_RIGHT_TO_LEFT_EFFECT",
          RUBBER_BAND_EFFECT: "RUBBER_BAND_EFFECT",
          JELLO_EFFECT: "JELLO_EFFECT",
          GROW_BIG_EFFECT: "GROW_BIG_EFFECT",
          SHRINK_BIG_EFFECT: "SHRINK_BIG_EFFECT",
          PLUGIN_LOTTIE_EFFECT: "PLUGIN_LOTTIE_EFFECT",
        }),
        (p4 = {
          LEFT: "LEFT",
          RIGHT: "RIGHT",
          BOTTOM: "BOTTOM",
          TOP: "TOP",
          BOTTOM_LEFT: "BOTTOM_LEFT",
          BOTTOM_RIGHT: "BOTTOM_RIGHT",
          TOP_RIGHT: "TOP_RIGHT",
          TOP_LEFT: "TOP_LEFT",
          CLOCKWISE: "CLOCKWISE",
          COUNTER_CLOCKWISE: "COUNTER_CLOCKWISE",
        });
    });
  var Xe,
    d4,
    Ya = Ee(() => {
      "use strict";
      (Xe = {
        TRANSFORM_MOVE: "TRANSFORM_MOVE",
        TRANSFORM_SCALE: "TRANSFORM_SCALE",
        TRANSFORM_ROTATE: "TRANSFORM_ROTATE",
        TRANSFORM_SKEW: "TRANSFORM_SKEW",
        STYLE_OPACITY: "STYLE_OPACITY",
        STYLE_SIZE: "STYLE_SIZE",
        STYLE_FILTER: "STYLE_FILTER",
        STYLE_FONT_VARIATION: "STYLE_FONT_VARIATION",
        STYLE_BACKGROUND_COLOR: "STYLE_BACKGROUND_COLOR",
        STYLE_BORDER: "STYLE_BORDER",
        STYLE_TEXT_COLOR: "STYLE_TEXT_COLOR",
        OBJECT_VALUE: "OBJECT_VALUE",
        PLUGIN_LOTTIE: "PLUGIN_LOTTIE",
        PLUGIN_SPLINE: "PLUGIN_SPLINE",
        PLUGIN_RIVE: "PLUGIN_RIVE",
        PLUGIN_VARIABLE: "PLUGIN_VARIABLE",
        GENERAL_DISPLAY: "GENERAL_DISPLAY",
        GENERAL_START_ACTION: "GENERAL_START_ACTION",
        GENERAL_CONTINUOUS_ACTION: "GENERAL_CONTINUOUS_ACTION",
        GENERAL_COMBO_CLASS: "GENERAL_COMBO_CLASS",
        GENERAL_STOP_ACTION: "GENERAL_STOP_ACTION",
        GENERAL_LOOP: "GENERAL_LOOP",
        STYLE_BOX_SHADOW: "STYLE_BOX_SHADOW",
      }),
        (d4 = {
          ELEMENT: "ELEMENT",
          ELEMENT_CLASS: "ELEMENT_CLASS",
          TRIGGER_ELEMENT: "TRIGGER_ELEMENT",
        });
    });
  var m4,
    wS = Ee(() => {
      "use strict";
      m4 = {
        MOUSE_CLICK_INTERACTION: "MOUSE_CLICK_INTERACTION",
        MOUSE_HOVER_INTERACTION: "MOUSE_HOVER_INTERACTION",
        MOUSE_MOVE_INTERACTION: "MOUSE_MOVE_INTERACTION",
        SCROLL_INTO_VIEW_INTERACTION: "SCROLL_INTO_VIEW_INTERACTION",
        SCROLLING_IN_VIEW_INTERACTION: "SCROLLING_IN_VIEW_INTERACTION",
        MOUSE_MOVE_IN_VIEWPORT_INTERACTION:
          "MOUSE_MOVE_IN_VIEWPORT_INTERACTION",
        PAGE_IS_SCROLLING_INTERACTION: "PAGE_IS_SCROLLING_INTERACTION",
        PAGE_LOAD_INTERACTION: "PAGE_LOAD_INTERACTION",
        PAGE_SCROLLED_INTERACTION: "PAGE_SCROLLED_INTERACTION",
        NAVBAR_INTERACTION: "NAVBAR_INTERACTION",
        DROPDOWN_INTERACTION: "DROPDOWN_INTERACTION",
        ECOMMERCE_CART_INTERACTION: "ECOMMERCE_CART_INTERACTION",
        TAB_INTERACTION: "TAB_INTERACTION",
        SLIDER_INTERACTION: "SLIDER_INTERACTION",
      };
    });
  var g4,
    v4,
    y4,
    E4,
    b4,
    x4,
    S4,
    Nu,
    CS = Ee(() => {
      "use strict";
      Ya();
      ({
        TRANSFORM_MOVE: g4,
        TRANSFORM_SCALE: v4,
        TRANSFORM_ROTATE: y4,
        TRANSFORM_SKEW: E4,
        STYLE_SIZE: b4,
        STYLE_FILTER: x4,
        STYLE_FONT_VARIATION: S4,
      } = Xe),
        (Nu = {
          [g4]: !0,
          [v4]: !0,
          [y4]: !0,
          [E4]: !0,
          [b4]: !0,
          [x4]: !0,
          [S4]: !0,
        });
    });
  var Le = {};
  He(Le, {
    IX2_ACTION_LIST_PLAYBACK_CHANGED: () => B4,
    IX2_ANIMATION_FRAME_CHANGED: () => D4,
    IX2_CLEAR_REQUESTED: () => M4,
    IX2_ELEMENT_STATE_CHANGED: () => N4,
    IX2_EVENT_LISTENER_ADDED: () => O4,
    IX2_EVENT_STATE_CHANGED: () => R4,
    IX2_INSTANCE_ADDED: () => L4,
    IX2_INSTANCE_REMOVED: () => k4,
    IX2_INSTANCE_STARTED: () => q4,
    IX2_MEDIA_QUERIES_DEFINED: () => G4,
    IX2_PARAMETER_CHANGED: () => F4,
    IX2_PLAYBACK_REQUESTED: () => w4,
    IX2_PREVIEW_REQUESTED: () => P4,
    IX2_RAW_DATA_IMPORTED: () => _4,
    IX2_SESSION_INITIALIZED: () => I4,
    IX2_SESSION_STARTED: () => T4,
    IX2_SESSION_STOPPED: () => A4,
    IX2_STOP_REQUESTED: () => C4,
    IX2_TEST_FRAME_RENDERED: () => z4,
    IX2_VIEWPORT_WIDTH_CHANGED: () => V4,
  });
  var _4,
    I4,
    T4,
    A4,
    P4,
    w4,
    C4,
    M4,
    O4,
    R4,
    D4,
    F4,
    L4,
    q4,
    k4,
    N4,
    B4,
    V4,
    G4,
    z4,
    MS = Ee(() => {
      "use strict";
      (_4 = "IX2_RAW_DATA_IMPORTED"),
        (I4 = "IX2_SESSION_INITIALIZED"),
        (T4 = "IX2_SESSION_STARTED"),
        (A4 = "IX2_SESSION_STOPPED"),
        (P4 = "IX2_PREVIEW_REQUESTED"),
        (w4 = "IX2_PLAYBACK_REQUESTED"),
        (C4 = "IX2_STOP_REQUESTED"),
        (M4 = "IX2_CLEAR_REQUESTED"),
        (O4 = "IX2_EVENT_LISTENER_ADDED"),
        (R4 = "IX2_EVENT_STATE_CHANGED"),
        (D4 = "IX2_ANIMATION_FRAME_CHANGED"),
        (F4 = "IX2_PARAMETER_CHANGED"),
        (L4 = "IX2_INSTANCE_ADDED"),
        (q4 = "IX2_INSTANCE_STARTED"),
        (k4 = "IX2_INSTANCE_REMOVED"),
        (N4 = "IX2_ELEMENT_STATE_CHANGED"),
        (B4 = "IX2_ACTION_LIST_PLAYBACK_CHANGED"),
        (V4 = "IX2_VIEWPORT_WIDTH_CHANGED"),
        (G4 = "IX2_MEDIA_QUERIES_DEFINED"),
        (z4 = "IX2_TEST_FRAME_RENDERED");
    });
  var Ve = {};
  He(Ve, {
    ABSTRACT_NODE: () => VX,
    AUTO: () => CX,
    BACKGROUND: () => _X,
    BACKGROUND_COLOR: () => SX,
    BAR_DELIMITER: () => RX,
    BORDER_COLOR: () => IX,
    BOUNDARY_SELECTOR: () => X4,
    CHILDREN: () => DX,
    COLON_DELIMITER: () => OX,
    COLOR: () => TX,
    COMMA_DELIMITER: () => MX,
    CONFIG_UNIT: () => tX,
    CONFIG_VALUE: () => Q4,
    CONFIG_X_UNIT: () => Z4,
    CONFIG_X_VALUE: () => $4,
    CONFIG_Y_UNIT: () => J4,
    CONFIG_Y_VALUE: () => K4,
    CONFIG_Z_UNIT: () => eX,
    CONFIG_Z_VALUE: () => Y4,
    DISPLAY: () => AX,
    FILTER: () => yX,
    FLEX: () => PX,
    FONT_VARIATION_SETTINGS: () => EX,
    HEIGHT: () => xX,
    HTML_ELEMENT: () => NX,
    IMMEDIATE_CHILDREN: () => FX,
    IX2_ID_DELIMITER: () => H4,
    OPACITY: () => vX,
    PARENT: () => qX,
    PLAIN_OBJECT: () => BX,
    PRESERVE_3D: () => kX,
    RENDER_GENERAL: () => zX,
    RENDER_PLUGIN: () => jX,
    RENDER_STYLE: () => HX,
    RENDER_TRANSFORM: () => GX,
    ROTATE_X: () => hX,
    ROTATE_Y: () => fX,
    ROTATE_Z: () => pX,
    SCALE_3D: () => cX,
    SCALE_X: () => oX,
    SCALE_Y: () => lX,
    SCALE_Z: () => uX,
    SIBLINGS: () => LX,
    SKEW: () => dX,
    SKEW_X: () => mX,
    SKEW_Y: () => gX,
    TRANSFORM: () => rX,
    TRANSLATE_3D: () => sX,
    TRANSLATE_X: () => nX,
    TRANSLATE_Y: () => iX,
    TRANSLATE_Z: () => aX,
    WF_PAGE: () => j4,
    WIDTH: () => bX,
    WILL_CHANGE: () => wX,
    W_MOD_IX: () => U4,
    W_MOD_JS: () => W4,
  });
  var H4,
    j4,
    W4,
    U4,
    X4,
    $4,
    K4,
    Y4,
    Q4,
    Z4,
    J4,
    eX,
    tX,
    rX,
    nX,
    iX,
    aX,
    sX,
    oX,
    lX,
    uX,
    cX,
    hX,
    fX,
    pX,
    dX,
    mX,
    gX,
    vX,
    yX,
    EX,
    bX,
    xX,
    SX,
    _X,
    IX,
    TX,
    AX,
    PX,
    wX,
    CX,
    MX,
    OX,
    RX,
    DX,
    FX,
    LX,
    qX,
    kX,
    NX,
    BX,
    VX,
    GX,
    zX,
    HX,
    jX,
    OS = Ee(() => {
      "use strict";
      (H4 = "|"),
        (j4 = "data-wf-page"),
        (W4 = "w-mod-js"),
        (U4 = "w-mod-ix"),
        (X4 = ".w-dyn-item"),
        ($4 = "xValue"),
        (K4 = "yValue"),
        (Y4 = "zValue"),
        (Q4 = "value"),
        (Z4 = "xUnit"),
        (J4 = "yUnit"),
        (eX = "zUnit"),
        (tX = "unit"),
        (rX = "transform"),
        (nX = "translateX"),
        (iX = "translateY"),
        (aX = "translateZ"),
        (sX = "translate3d"),
        (oX = "scaleX"),
        (lX = "scaleY"),
        (uX = "scaleZ"),
        (cX = "scale3d"),
        (hX = "rotateX"),
        (fX = "rotateY"),
        (pX = "rotateZ"),
        (dX = "skew"),
        (mX = "skewX"),
        (gX = "skewY"),
        (vX = "opacity"),
        (yX = "filter"),
        (EX = "font-variation-settings"),
        (bX = "width"),
        (xX = "height"),
        (SX = "backgroundColor"),
        (_X = "background"),
        (IX = "borderColor"),
        (TX = "color"),
        (AX = "display"),
        (PX = "flex"),
        (wX = "willChange"),
        (CX = "AUTO"),
        (MX = ","),
        (OX = ":"),
        (RX = "|"),
        (DX = "CHILDREN"),
        (FX = "IMMEDIATE_CHILDREN"),
        (LX = "SIBLINGS"),
        (qX = "PARENT"),
        (kX = "preserve-3d"),
        (NX = "HTML_ELEMENT"),
        (BX = "PLAIN_OBJECT"),
        (VX = "ABSTRACT_NODE"),
        (GX = "RENDER_TRANSFORM"),
        (zX = "RENDER_GENERAL"),
        (HX = "RENDER_STYLE"),
        (jX = "RENDER_PLUGIN");
    });
  var RS = {};
  He(RS, {
    ActionAppliesTo: () => d4,
    ActionTypeConsts: () => Xe,
    EventAppliesTo: () => qu,
    EventBasedOn: () => Mt,
    EventContinuousMouseAxes: () => h4,
    EventLimitAffectedElements: () => f4,
    EventTypeConsts: () => Et,
    IX2EngineActionTypes: () => Le,
    IX2EngineConstants: () => Ve,
    InteractionTypeConsts: () => m4,
    QuickEffectDirectionConsts: () => p4,
    QuickEffectIds: () => Ka,
    ReducedMotionTypes: () => Nu,
  });
  var Ze = Ee(() => {
    "use strict";
    ku();
    Ya();
    wS();
    CS();
    MS();
    OS();
    Ya();
    ku();
  });
  var WX,
    DS,
    FS = Ee(() => {
      "use strict";
      Ze();
      ({ IX2_RAW_DATA_IMPORTED: WX } = Le),
        (DS = (e = Object.freeze({}), t) => {
          switch (t.type) {
            case WX:
              return t.payload.ixData || Object.freeze({});
            default:
              return e;
          }
        });
    });
  var nn = E((Ce) => {
    "use strict";
    Object.defineProperty(Ce, "__esModule", { value: !0 });
    var UX =
      typeof Symbol == "function" && typeof Symbol.iterator == "symbol"
        ? function (e) {
            return typeof e;
          }
        : function (e) {
            return e &&
              typeof Symbol == "function" &&
              e.constructor === Symbol &&
              e !== Symbol.prototype
              ? "symbol"
              : typeof e;
          };
    Ce.clone = Za;
    Ce.addLast = kS;
    Ce.addFirst = NS;
    Ce.removeLast = BS;
    Ce.removeFirst = VS;
    Ce.insert = GS;
    Ce.removeAt = zS;
    Ce.replaceAt = HS;
    Ce.getIn = Ja;
    Ce.set = es;
    Ce.setIn = ts;
    Ce.update = WS;
    Ce.updateIn = US;
    Ce.merge = XS;
    Ce.mergeDeep = $S;
    Ce.mergeIn = KS;
    Ce.omit = YS;
    Ce.addDefaults = QS;
    var LS = "INVALID_ARGS";
    function qS(e) {
      throw new Error(e);
    }
    function Bu(e) {
      var t = Object.keys(e);
      return Object.getOwnPropertySymbols
        ? t.concat(Object.getOwnPropertySymbols(e))
        : t;
    }
    var XX = {}.hasOwnProperty;
    function Za(e) {
      if (Array.isArray(e)) return e.slice();
      for (var t = Bu(e), r = {}, n = 0; n < t.length; n++) {
        var i = t[n];
        r[i] = e[i];
      }
      return r;
    }
    function Je(e, t, r) {
      var n = r;
      n == null && qS(LS);
      for (
        var i = !1, a = arguments.length, o = Array(a > 3 ? a - 3 : 0), s = 3;
        s < a;
        s++
      )
        o[s - 3] = arguments[s];
      for (var l = 0; l < o.length; l++) {
        var f = o[l];
        if (f != null) {
          var u = Bu(f);
          if (u.length)
            for (var h = 0; h <= u.length; h++) {
              var m = u[h];
              if (!(e && n[m] !== void 0)) {
                var d = f[m];
                t && Qa(n[m]) && Qa(d) && (d = Je(e, t, n[m], d)),
                  !(d === void 0 || d === n[m]) &&
                    (i || ((i = !0), (n = Za(n))), (n[m] = d));
              }
            }
        }
      }
      return n;
    }
    function Qa(e) {
      var t = typeof e > "u" ? "undefined" : UX(e);
      return e != null && (t === "object" || t === "function");
    }
    function kS(e, t) {
      return Array.isArray(t) ? e.concat(t) : e.concat([t]);
    }
    function NS(e, t) {
      return Array.isArray(t) ? t.concat(e) : [t].concat(e);
    }
    function BS(e) {
      return e.length ? e.slice(0, e.length - 1) : e;
    }
    function VS(e) {
      return e.length ? e.slice(1) : e;
    }
    function GS(e, t, r) {
      return e
        .slice(0, t)
        .concat(Array.isArray(r) ? r : [r])
        .concat(e.slice(t));
    }
    function zS(e, t) {
      return t >= e.length || t < 0 ? e : e.slice(0, t).concat(e.slice(t + 1));
    }
    function HS(e, t, r) {
      if (e[t] === r) return e;
      for (var n = e.length, i = Array(n), a = 0; a < n; a++) i[a] = e[a];
      return (i[t] = r), i;
    }
    function Ja(e, t) {
      if ((!Array.isArray(t) && qS(LS), e != null)) {
        for (var r = e, n = 0; n < t.length; n++) {
          var i = t[n];
          if (((r = r?.[i]), r === void 0)) return r;
        }
        return r;
      }
    }
    function es(e, t, r) {
      var n = typeof t == "number" ? [] : {},
        i = e ?? n;
      if (i[t] === r) return i;
      var a = Za(i);
      return (a[t] = r), a;
    }
    function jS(e, t, r, n) {
      var i = void 0,
        a = t[n];
      if (n === t.length - 1) i = r;
      else {
        var o =
          Qa(e) && Qa(e[a]) ? e[a] : typeof t[n + 1] == "number" ? [] : {};
        i = jS(o, t, r, n + 1);
      }
      return es(e, a, i);
    }
    function ts(e, t, r) {
      return t.length ? jS(e, t, r, 0) : r;
    }
    function WS(e, t, r) {
      var n = e?.[t],
        i = r(n);
      return es(e, t, i);
    }
    function US(e, t, r) {
      var n = Ja(e, t),
        i = r(n);
      return ts(e, t, i);
    }
    function XS(e, t, r, n, i, a) {
      for (
        var o = arguments.length, s = Array(o > 6 ? o - 6 : 0), l = 6;
        l < o;
        l++
      )
        s[l - 6] = arguments[l];
      return s.length
        ? Je.call.apply(Je, [null, !1, !1, e, t, r, n, i, a].concat(s))
        : Je(!1, !1, e, t, r, n, i, a);
    }
    function $S(e, t, r, n, i, a) {
      for (
        var o = arguments.length, s = Array(o > 6 ? o - 6 : 0), l = 6;
        l < o;
        l++
      )
        s[l - 6] = arguments[l];
      return s.length
        ? Je.call.apply(Je, [null, !1, !0, e, t, r, n, i, a].concat(s))
        : Je(!1, !0, e, t, r, n, i, a);
    }
    function KS(e, t, r, n, i, a, o) {
      var s = Ja(e, t);
      s == null && (s = {});
      for (
        var l = void 0,
          f = arguments.length,
          u = Array(f > 7 ? f - 7 : 0),
          h = 7;
        h < f;
        h++
      )
        u[h - 7] = arguments[h];
      return (
        u.length
          ? (l = Je.call.apply(Je, [null, !1, !1, s, r, n, i, a, o].concat(u)))
          : (l = Je(!1, !1, s, r, n, i, a, o)),
        ts(e, t, l)
      );
    }
    function YS(e, t) {
      for (var r = Array.isArray(t) ? t : [t], n = !1, i = 0; i < r.length; i++)
        if (XX.call(e, r[i])) {
          n = !0;
          break;
        }
      if (!n) return e;
      for (var a = {}, o = Bu(e), s = 0; s < o.length; s++) {
        var l = o[s];
        r.indexOf(l) >= 0 || (a[l] = e[l]);
      }
      return a;
    }
    function QS(e, t, r, n, i, a) {
      for (
        var o = arguments.length, s = Array(o > 6 ? o - 6 : 0), l = 6;
        l < o;
        l++
      )
        s[l - 6] = arguments[l];
      return s.length
        ? Je.call.apply(Je, [null, !0, !1, e, t, r, n, i, a].concat(s))
        : Je(!0, !1, e, t, r, n, i, a);
    }
    var $X = {
      clone: Za,
      addLast: kS,
      addFirst: NS,
      removeLast: BS,
      removeFirst: VS,
      insert: GS,
      removeAt: zS,
      replaceAt: HS,
      getIn: Ja,
      set: es,
      setIn: ts,
      update: WS,
      updateIn: US,
      merge: XS,
      mergeDeep: $S,
      mergeIn: KS,
      omit: YS,
      addDefaults: QS,
    };
    Ce.default = $X;
  });
  var JS,
    KX,
    YX,
    QX,
    ZX,
    JX,
    ZS,
    e_,
    t_ = Ee(() => {
      "use strict";
      Ze();
      (JS = me(nn())),
        ({
          IX2_PREVIEW_REQUESTED: KX,
          IX2_PLAYBACK_REQUESTED: YX,
          IX2_STOP_REQUESTED: QX,
          IX2_CLEAR_REQUESTED: ZX,
        } = Le),
        (JX = { preview: {}, playback: {}, stop: {}, clear: {} }),
        (ZS = Object.create(null, {
          [KX]: { value: "preview" },
          [YX]: { value: "playback" },
          [QX]: { value: "stop" },
          [ZX]: { value: "clear" },
        })),
        (e_ = (e = JX, t) => {
          if (t.type in ZS) {
            let r = [ZS[t.type]];
            return (0, JS.setIn)(e, [r], { ...t.payload });
          }
          return e;
        });
    });
  var $e,
    e6,
    t6,
    r6,
    n6,
    i6,
    a6,
    s6,
    o6,
    l6,
    u6,
    r_,
    c6,
    n_,
    i_ = Ee(() => {
      "use strict";
      Ze();
      ($e = me(nn())),
        ({
          IX2_SESSION_INITIALIZED: e6,
          IX2_SESSION_STARTED: t6,
          IX2_TEST_FRAME_RENDERED: r6,
          IX2_SESSION_STOPPED: n6,
          IX2_EVENT_LISTENER_ADDED: i6,
          IX2_EVENT_STATE_CHANGED: a6,
          IX2_ANIMATION_FRAME_CHANGED: s6,
          IX2_ACTION_LIST_PLAYBACK_CHANGED: o6,
          IX2_VIEWPORT_WIDTH_CHANGED: l6,
          IX2_MEDIA_QUERIES_DEFINED: u6,
        } = Le),
        (r_ = {
          active: !1,
          tick: 0,
          eventListeners: [],
          eventState: {},
          playbackState: {},
          viewportWidth: 0,
          mediaQueryKey: null,
          hasBoundaryNodes: !1,
          hasDefinedMediaQueries: !1,
          reducedMotion: !1,
        }),
        (c6 = 20),
        (n_ = (e = r_, t) => {
          switch (t.type) {
            case e6: {
              let { hasBoundaryNodes: r, reducedMotion: n } = t.payload;
              return (0, $e.merge)(e, {
                hasBoundaryNodes: r,
                reducedMotion: n,
              });
            }
            case t6:
              return (0, $e.set)(e, "active", !0);
            case r6: {
              let {
                payload: { step: r = c6 },
              } = t;
              return (0, $e.set)(e, "tick", e.tick + r);
            }
            case n6:
              return r_;
            case s6: {
              let {
                payload: { now: r },
              } = t;
              return (0, $e.set)(e, "tick", r);
            }
            case i6: {
              let r = (0, $e.addLast)(e.eventListeners, t.payload);
              return (0, $e.set)(e, "eventListeners", r);
            }
            case a6: {
              let { stateKey: r, newState: n } = t.payload;
              return (0, $e.setIn)(e, ["eventState", r], n);
            }
            case o6: {
              let { actionListId: r, isPlaying: n } = t.payload;
              return (0, $e.setIn)(e, ["playbackState", r], n);
            }
            case l6: {
              let { width: r, mediaQueries: n } = t.payload,
                i = n.length,
                a = null;
              for (let o = 0; o < i; o++) {
                let { key: s, min: l, max: f } = n[o];
                if (r >= l && r <= f) {
                  a = s;
                  break;
                }
              }
              return (0, $e.merge)(e, { viewportWidth: r, mediaQueryKey: a });
            }
            case u6:
              return (0, $e.set)(e, "hasDefinedMediaQueries", !0);
            default:
              return e;
          }
        });
    });
  var Vu = E((Qoe, a_) => {
    var h6 = Kt(),
      f6 = fr(),
      p6 = Mn();
    function d6(e) {
      return function (t, r, n) {
        var i = Object(t);
        if (!f6(t)) {
          var a = h6(r, 3);
          (t = p6(t)),
            (r = function (s) {
              return a(i[s], s, i);
            });
        }
        var o = e(t, r, n);
        return o > -1 ? i[a ? t[o] : o] : void 0;
      };
    }
    a_.exports = d6;
  });
  var Gu = E((Zoe, s_) => {
    var m6 = Vu(),
      g6 = bo(),
      v6 = m6(g6);
    s_.exports = v6;
  });
  var u_ = {};
  He(u_, {
    ELEMENT_MATCHES: () => y6,
    FLEX_PREFIXED: () => zu,
    IS_BROWSER_ENV: () => bt,
    TRANSFORM_PREFIXED: () => or,
    TRANSFORM_STYLE_PREFIXED: () => ns,
    withBrowser: () => rs,
  });
  var l_,
    bt,
    rs,
    y6,
    zu,
    or,
    o_,
    ns,
    is = Ee(() => {
      "use strict";
      (l_ = me(Gu())),
        (bt = typeof window < "u"),
        (rs = (e, t) => (bt ? e() : t)),
        (y6 = rs(() =>
          (0, l_.default)(
            [
              "matches",
              "matchesSelector",
              "mozMatchesSelector",
              "msMatchesSelector",
              "oMatchesSelector",
              "webkitMatchesSelector",
            ],
            (e) => e in Element.prototype
          )
        )),
        (zu = rs(() => {
          let e = document.createElement("i"),
            t = [
              "flex",
              "-webkit-flex",
              "-ms-flexbox",
              "-moz-box",
              "-webkit-box",
            ],
            r = "";
          try {
            let { length: n } = t;
            for (let i = 0; i < n; i++) {
              let a = t[i];
              if (((e.style.display = a), e.style.display === a)) return a;
            }
            return r;
          } catch {
            return r;
          }
        }, "flex")),
        (or = rs(() => {
          let e = document.createElement("i");
          if (e.style.transform == null) {
            let t = ["Webkit", "Moz", "ms"],
              r = "Transform",
              { length: n } = t;
            for (let i = 0; i < n; i++) {
              let a = t[i] + r;
              if (e.style[a] !== void 0) return a;
            }
          }
          return "transform";
        }, "transform")),
        (o_ = or.split("transform")[0]),
        (ns = o_ ? o_ + "TransformStyle" : "transformStyle");
    });
  var Hu = E((Joe, d_) => {
    var E6 = 4,
      b6 = 0.001,
      x6 = 1e-7,
      S6 = 10,
      ci = 11,
      as = 1 / (ci - 1),
      _6 = typeof Float32Array == "function";
    function c_(e, t) {
      return 1 - 3 * t + 3 * e;
    }
    function h_(e, t) {
      return 3 * t - 6 * e;
    }
    function f_(e) {
      return 3 * e;
    }
    function ss(e, t, r) {
      return ((c_(t, r) * e + h_(t, r)) * e + f_(t)) * e;
    }
    function p_(e, t, r) {
      return 3 * c_(t, r) * e * e + 2 * h_(t, r) * e + f_(t);
    }
    function I6(e, t, r, n, i) {
      var a,
        o,
        s = 0;
      do
        (o = t + (r - t) / 2), (a = ss(o, n, i) - e), a > 0 ? (r = o) : (t = o);
      while (Math.abs(a) > x6 && ++s < S6);
      return o;
    }
    function T6(e, t, r, n) {
      for (var i = 0; i < E6; ++i) {
        var a = p_(t, r, n);
        if (a === 0) return t;
        var o = ss(t, r, n) - e;
        t -= o / a;
      }
      return t;
    }
    d_.exports = function (t, r, n, i) {
      if (!(0 <= t && t <= 1 && 0 <= n && n <= 1))
        throw new Error("bezier x values must be in [0, 1] range");
      var a = _6 ? new Float32Array(ci) : new Array(ci);
      if (t !== r || n !== i)
        for (var o = 0; o < ci; ++o) a[o] = ss(o * as, t, n);
      function s(l) {
        for (var f = 0, u = 1, h = ci - 1; u !== h && a[u] <= l; ++u) f += as;
        --u;
        var m = (l - a[u]) / (a[u + 1] - a[u]),
          d = f + m * as,
          p = p_(d, t, n);
        return p >= b6 ? T6(l, d, t, n) : p === 0 ? d : I6(l, f, f + as, t, n);
      }
      return function (f) {
        return t === r && n === i
          ? f
          : f === 0
          ? 0
          : f === 1
          ? 1
          : ss(s(f), r, i);
      };
    };
  });
  var fi = {};
  He(fi, {
    bounce: () => o8,
    bouncePast: () => l8,
    ease: () => A6,
    easeIn: () => P6,
    easeInOut: () => C6,
    easeOut: () => w6,
    inBack: () => Z6,
    inCirc: () => $6,
    inCubic: () => D6,
    inElastic: () => t8,
    inExpo: () => W6,
    inOutBack: () => e8,
    inOutCirc: () => Y6,
    inOutCubic: () => L6,
    inOutElastic: () => n8,
    inOutExpo: () => X6,
    inOutQuad: () => R6,
    inOutQuart: () => N6,
    inOutQuint: () => G6,
    inOutSine: () => j6,
    inQuad: () => M6,
    inQuart: () => q6,
    inQuint: () => B6,
    inSine: () => z6,
    outBack: () => J6,
    outBounce: () => Q6,
    outCirc: () => K6,
    outCubic: () => F6,
    outElastic: () => r8,
    outExpo: () => U6,
    outQuad: () => O6,
    outQuart: () => k6,
    outQuint: () => V6,
    outSine: () => H6,
    swingFrom: () => a8,
    swingFromTo: () => i8,
    swingTo: () => s8,
  });
  function M6(e) {
    return Math.pow(e, 2);
  }
  function O6(e) {
    return -(Math.pow(e - 1, 2) - 1);
  }
  function R6(e) {
    return (e /= 0.5) < 1 ? 0.5 * Math.pow(e, 2) : -0.5 * ((e -= 2) * e - 2);
  }
  function D6(e) {
    return Math.pow(e, 3);
  }
  function F6(e) {
    return Math.pow(e - 1, 3) + 1;
  }
  function L6(e) {
    return (e /= 0.5) < 1
      ? 0.5 * Math.pow(e, 3)
      : 0.5 * (Math.pow(e - 2, 3) + 2);
  }
  function q6(e) {
    return Math.pow(e, 4);
  }
  function k6(e) {
    return -(Math.pow(e - 1, 4) - 1);
  }
  function N6(e) {
    return (e /= 0.5) < 1
      ? 0.5 * Math.pow(e, 4)
      : -0.5 * ((e -= 2) * Math.pow(e, 3) - 2);
  }
  function B6(e) {
    return Math.pow(e, 5);
  }
  function V6(e) {
    return Math.pow(e - 1, 5) + 1;
  }
  function G6(e) {
    return (e /= 0.5) < 1
      ? 0.5 * Math.pow(e, 5)
      : 0.5 * (Math.pow(e - 2, 5) + 2);
  }
  function z6(e) {
    return -Math.cos(e * (Math.PI / 2)) + 1;
  }
  function H6(e) {
    return Math.sin(e * (Math.PI / 2));
  }
  function j6(e) {
    return -0.5 * (Math.cos(Math.PI * e) - 1);
  }
  function W6(e) {
    return e === 0 ? 0 : Math.pow(2, 10 * (e - 1));
  }
  function U6(e) {
    return e === 1 ? 1 : -Math.pow(2, -10 * e) + 1;
  }
  function X6(e) {
    return e === 0
      ? 0
      : e === 1
      ? 1
      : (e /= 0.5) < 1
      ? 0.5 * Math.pow(2, 10 * (e - 1))
      : 0.5 * (-Math.pow(2, -10 * --e) + 2);
  }
  function $6(e) {
    return -(Math.sqrt(1 - e * e) - 1);
  }
  function K6(e) {
    return Math.sqrt(1 - Math.pow(e - 1, 2));
  }
  function Y6(e) {
    return (e /= 0.5) < 1
      ? -0.5 * (Math.sqrt(1 - e * e) - 1)
      : 0.5 * (Math.sqrt(1 - (e -= 2) * e) + 1);
  }
  function Q6(e) {
    return e < 1 / 2.75
      ? 7.5625 * e * e
      : e < 2 / 2.75
      ? 7.5625 * (e -= 1.5 / 2.75) * e + 0.75
      : e < 2.5 / 2.75
      ? 7.5625 * (e -= 2.25 / 2.75) * e + 0.9375
      : 7.5625 * (e -= 2.625 / 2.75) * e + 0.984375;
  }
  function Z6(e) {
    let t = zt;
    return e * e * ((t + 1) * e - t);
  }
  function J6(e) {
    let t = zt;
    return (e -= 1) * e * ((t + 1) * e + t) + 1;
  }
  function e8(e) {
    let t = zt;
    return (e /= 0.5) < 1
      ? 0.5 * (e * e * (((t *= 1.525) + 1) * e - t))
      : 0.5 * ((e -= 2) * e * (((t *= 1.525) + 1) * e + t) + 2);
  }
  function t8(e) {
    let t = zt,
      r = 0,
      n = 1;
    return e === 0
      ? 0
      : e === 1
      ? 1
      : (r || (r = 0.3),
        n < 1
          ? ((n = 1), (t = r / 4))
          : (t = (r / (2 * Math.PI)) * Math.asin(1 / n)),
        -(
          n *
          Math.pow(2, 10 * (e -= 1)) *
          Math.sin(((e - t) * (2 * Math.PI)) / r)
        ));
  }
  function r8(e) {
    let t = zt,
      r = 0,
      n = 1;
    return e === 0
      ? 0
      : e === 1
      ? 1
      : (r || (r = 0.3),
        n < 1
          ? ((n = 1), (t = r / 4))
          : (t = (r / (2 * Math.PI)) * Math.asin(1 / n)),
        n * Math.pow(2, -10 * e) * Math.sin(((e - t) * (2 * Math.PI)) / r) + 1);
  }
  function n8(e) {
    let t = zt,
      r = 0,
      n = 1;
    return e === 0
      ? 0
      : (e /= 1 / 2) === 2
      ? 1
      : (r || (r = 0.3 * 1.5),
        n < 1
          ? ((n = 1), (t = r / 4))
          : (t = (r / (2 * Math.PI)) * Math.asin(1 / n)),
        e < 1
          ? -0.5 *
            (n *
              Math.pow(2, 10 * (e -= 1)) *
              Math.sin(((e - t) * (2 * Math.PI)) / r))
          : n *
              Math.pow(2, -10 * (e -= 1)) *
              Math.sin(((e - t) * (2 * Math.PI)) / r) *
              0.5 +
            1);
  }
  function i8(e) {
    let t = zt;
    return (e /= 0.5) < 1
      ? 0.5 * (e * e * (((t *= 1.525) + 1) * e - t))
      : 0.5 * ((e -= 2) * e * (((t *= 1.525) + 1) * e + t) + 2);
  }
  function a8(e) {
    let t = zt;
    return e * e * ((t + 1) * e - t);
  }
  function s8(e) {
    let t = zt;
    return (e -= 1) * e * ((t + 1) * e + t) + 1;
  }
  function o8(e) {
    return e < 1 / 2.75
      ? 7.5625 * e * e
      : e < 2 / 2.75
      ? 7.5625 * (e -= 1.5 / 2.75) * e + 0.75
      : e < 2.5 / 2.75
      ? 7.5625 * (e -= 2.25 / 2.75) * e + 0.9375
      : 7.5625 * (e -= 2.625 / 2.75) * e + 0.984375;
  }
  function l8(e) {
    return e < 1 / 2.75
      ? 7.5625 * e * e
      : e < 2 / 2.75
      ? 2 - (7.5625 * (e -= 1.5 / 2.75) * e + 0.75)
      : e < 2.5 / 2.75
      ? 2 - (7.5625 * (e -= 2.25 / 2.75) * e + 0.9375)
      : 2 - (7.5625 * (e -= 2.625 / 2.75) * e + 0.984375);
  }
  var hi,
    zt,
    A6,
    P6,
    w6,
    C6,
    ju = Ee(() => {
      "use strict";
      (hi = me(Hu())),
        (zt = 1.70158),
        (A6 = (0, hi.default)(0.25, 0.1, 0.25, 1)),
        (P6 = (0, hi.default)(0.42, 0, 1, 1)),
        (w6 = (0, hi.default)(0, 0, 0.58, 1)),
        (C6 = (0, hi.default)(0.42, 0, 0.58, 1));
    });
  var g_ = {};
  He(g_, {
    applyEasing: () => c8,
    createBezierEasing: () => u8,
    optimizeFloat: () => pi,
  });
  function pi(e, t = 5, r = 10) {
    let n = Math.pow(r, t),
      i = Number(Math.round(e * n) / n);
    return Math.abs(i) > 1e-4 ? i : 0;
  }
  function u8(e) {
    return (0, m_.default)(...e);
  }
  function c8(e, t, r) {
    return t === 0
      ? 0
      : t === 1
      ? 1
      : pi(r ? (t > 0 ? r(t) : t) : t > 0 && e && fi[e] ? fi[e](t) : t);
  }
  var m_,
    Wu = Ee(() => {
      "use strict";
      ju();
      m_ = me(Hu());
    });
  var E_ = {};
  He(E_, {
    createElementState: () => y_,
    ixElements: () => I8,
    mergeActionState: () => Uu,
  });
  function y_(e, t, r, n, i) {
    let a =
      r === h8 ? (0, an.getIn)(i, ["config", "target", "objectId"]) : null;
    return (0, an.mergeIn)(e, [n], { id: n, ref: t, refId: a, refType: r });
  }
  function Uu(e, t, r, n, i) {
    let a = A8(i);
    return (0, an.mergeIn)(e, [t, _8, r], n, a);
  }
  function A8(e) {
    let { config: t } = e;
    return T8.reduce((r, n) => {
      let i = n[0],
        a = n[1],
        o = t[i],
        s = t[a];
      return o != null && s != null && (r[a] = s), r;
    }, {});
  }
  var an,
    tle,
    h8,
    rle,
    f8,
    p8,
    d8,
    m8,
    g8,
    v8,
    y8,
    E8,
    b8,
    x8,
    S8,
    v_,
    _8,
    I8,
    T8,
    b_ = Ee(() => {
      "use strict";
      an = me(nn());
      Ze();
      ({
        HTML_ELEMENT: tle,
        PLAIN_OBJECT: h8,
        ABSTRACT_NODE: rle,
        CONFIG_X_VALUE: f8,
        CONFIG_Y_VALUE: p8,
        CONFIG_Z_VALUE: d8,
        CONFIG_VALUE: m8,
        CONFIG_X_UNIT: g8,
        CONFIG_Y_UNIT: v8,
        CONFIG_Z_UNIT: y8,
        CONFIG_UNIT: E8,
      } = Ve),
        ({
          IX2_SESSION_STOPPED: b8,
          IX2_INSTANCE_ADDED: x8,
          IX2_ELEMENT_STATE_CHANGED: S8,
        } = Le),
        (v_ = {}),
        (_8 = "refState"),
        (I8 = (e = v_, t = {}) => {
          switch (t.type) {
            case b8:
              return v_;
            case x8: {
              let {
                  elementId: r,
                  element: n,
                  origin: i,
                  actionItem: a,
                  refType: o,
                } = t.payload,
                { actionTypeId: s } = a,
                l = e;
              return (
                (0, an.getIn)(l, [r, n]) !== n && (l = y_(l, n, o, r, a)),
                Uu(l, r, s, i, a)
              );
            }
            case S8: {
              let {
                elementId: r,
                actionTypeId: n,
                current: i,
                actionItem: a,
              } = t.payload;
              return Uu(e, r, n, i, a);
            }
            default:
              return e;
          }
        });
      T8 = [
        [f8, g8],
        [p8, v8],
        [d8, y8],
        [m8, E8],
      ];
    });
  var x_ = E((Xu) => {
    "use strict";
    Object.defineProperty(Xu, "__esModule", { value: !0 });
    function P8(e, t) {
      for (var r in t)
        Object.defineProperty(e, r, { enumerable: !0, get: t[r] });
    }
    P8(Xu, {
      clearPlugin: function () {
        return F8;
      },
      createPluginInstance: function () {
        return R8;
      },
      getPluginConfig: function () {
        return w8;
      },
      getPluginDestination: function () {
        return O8;
      },
      getPluginDuration: function () {
        return C8;
      },
      getPluginOrigin: function () {
        return M8;
      },
      renderPlugin: function () {
        return D8;
      },
    });
    var w8 = (e) => e.value,
      C8 = (e, t) => {
        if (t.config.duration !== "auto") return null;
        let r = parseFloat(e.getAttribute("data-duration"));
        return r > 0
          ? r * 1e3
          : parseFloat(e.getAttribute("data-default-duration")) * 1e3;
      },
      M8 = (e) => e || { value: 0 },
      O8 = (e) => ({ value: e.value }),
      R8 = (e) => {
        let t = window.Webflow.require("lottie").createInstance(e);
        return t.stop(), t.setSubframe(!0), t;
      },
      D8 = (e, t, r) => {
        if (!e) return;
        let n = t[r.actionTypeId].value / 100;
        e.goToFrame(e.frames * n);
      },
      F8 = (e) => {
        window.Webflow.require("lottie").createInstance(e).stop();
      };
  });
  var __ = E(($u) => {
    "use strict";
    Object.defineProperty($u, "__esModule", { value: !0 });
    function L8(e, t) {
      for (var r in t)
        Object.defineProperty(e, r, { enumerable: !0, get: t[r] });
    }
    L8($u, {
      clearPlugin: function () {
        return W8;
      },
      createPluginInstance: function () {
        return H8;
      },
      getPluginConfig: function () {
        return B8;
      },
      getPluginDestination: function () {
        return z8;
      },
      getPluginDuration: function () {
        return V8;
      },
      getPluginOrigin: function () {
        return G8;
      },
      renderPlugin: function () {
        return j8;
      },
    });
    var q8 = (e) => document.querySelector(`[data-w-id="${e}"]`),
      k8 = () => window.Webflow.require("spline"),
      N8 = (e, t) => e.filter((r) => !t.includes(r)),
      B8 = (e, t) => e.value[t],
      V8 = () => null,
      S_ = Object.freeze({
        positionX: 0,
        positionY: 0,
        positionZ: 0,
        rotationX: 0,
        rotationY: 0,
        rotationZ: 0,
        scaleX: 1,
        scaleY: 1,
        scaleZ: 1,
      }),
      G8 = (e, t) => {
        let r = t.config.value,
          n = Object.keys(r);
        if (e) {
          let a = Object.keys(e),
            o = N8(n, a);
          return o.length ? o.reduce((l, f) => ((l[f] = S_[f]), l), e) : e;
        }
        return n.reduce((a, o) => ((a[o] = S_[o]), a), {});
      },
      z8 = (e) => e.value,
      H8 = (e, t) => {
        let r = t?.config?.target?.pluginElement;
        return r ? q8(r) : null;
      },
      j8 = (e, t, r) => {
        let n = k8(),
          i = n.getInstance(e),
          a = r.config.target.objectId,
          o = (s) => {
            if (!s)
              throw new Error("Invalid spline app passed to renderSpline");
            let l = a && s.findObjectById(a);
            if (!l) return;
            let { PLUGIN_SPLINE: f } = t;
            f.positionX != null && (l.position.x = f.positionX),
              f.positionY != null && (l.position.y = f.positionY),
              f.positionZ != null && (l.position.z = f.positionZ),
              f.rotationX != null && (l.rotation.x = f.rotationX),
              f.rotationY != null && (l.rotation.y = f.rotationY),
              f.rotationZ != null && (l.rotation.z = f.rotationZ),
              f.scaleX != null && (l.scale.x = f.scaleX),
              f.scaleY != null && (l.scale.y = f.scaleY),
              f.scaleZ != null && (l.scale.z = f.scaleZ);
          };
        i ? o(i.spline) : n.setLoadHandler(e, o);
      },
      W8 = () => null;
  });
  var I_ = E((Qu) => {
    "use strict";
    Object.defineProperty(Qu, "__esModule", { value: !0 });
    function U8(e, t) {
      for (var r in t)
        Object.defineProperty(e, r, { enumerable: !0, get: t[r] });
    }
    U8(Qu, {
      clearPlugin: function () {
        return t9;
      },
      createPluginInstance: function () {
        return J8;
      },
      getPluginConfig: function () {
        return K8;
      },
      getPluginDestination: function () {
        return Z8;
      },
      getPluginDuration: function () {
        return Y8;
      },
      getPluginOrigin: function () {
        return Q8;
      },
      renderPlugin: function () {
        return e9;
      },
    });
    var Ku = "--wf-rive-fit",
      Yu = "--wf-rive-alignment",
      X8 = (e) => document.querySelector(`[data-w-id="${e}"]`),
      $8 = () => window.Webflow.require("rive"),
      K8 = (e, t) => e.value.inputs[t],
      Y8 = () => null,
      Q8 = (e, t) => {
        if (e) return e;
        let r = {},
          { inputs: n = {} } = t.config.value;
        for (let i in n) n[i] == null && (r[i] = 0);
        return r;
      },
      Z8 = (e) => e.value.inputs ?? {},
      J8 = (e, t) => {
        if ((t.config?.target?.selectorGuids || []).length > 0) return e;
        let n = t?.config?.target?.pluginElement;
        return n ? X8(n) : null;
      },
      e9 = (e, { PLUGIN_RIVE: t }, r) => {
        let n = $8(),
          i = n.getInstance(e),
          a = n.rive.StateMachineInputType,
          { name: o, inputs: s = {} } = r.config.value || {};
        function l(f) {
          if (f.loaded) u();
          else {
            let h = () => {
              u(), f?.off("load", h);
            };
            f?.on("load", h);
          }
          function u() {
            let h = f.stateMachineInputs(o);
            if (h != null) {
              if ((f.isPlaying || f.play(o, !1), Ku in s || Yu in s)) {
                let m = f.layout,
                  d = s[Ku] ?? m.fit,
                  p = s[Yu] ?? m.alignment;
                (d !== m.fit || p !== m.alignment) &&
                  (f.layout = m.copyWith({ fit: d, alignment: p }));
              }
              for (let m in s) {
                if (m === Ku || m === Yu) continue;
                let d = h.find((p) => p.name === m);
                if (d != null)
                  switch (d.type) {
                    case a.Boolean: {
                      if (s[m] != null) {
                        let p = !!s[m];
                        d.value = p;
                      }
                      break;
                    }
                    case a.Number: {
                      let p = t[m];
                      p != null && (d.value = p);
                      break;
                    }
                    case a.Trigger: {
                      s[m] && d.fire();
                      break;
                    }
                  }
              }
            }
          }
        }
        i?.rive ? l(i.rive) : n.setLoadHandler(e, l);
      },
      t9 = (e, t) => null;
  });
  var Ju = E((Zu) => {
    "use strict";
    Object.defineProperty(Zu, "__esModule", { value: !0 });
    Object.defineProperty(Zu, "normalizeColor", {
      enumerable: !0,
      get: function () {
        return r9;
      },
    });
    var T_ = {
      aliceblue: "#F0F8FF",
      antiquewhite: "#FAEBD7",
      aqua: "#00FFFF",
      aquamarine: "#7FFFD4",
      azure: "#F0FFFF",
      beige: "#F5F5DC",
      bisque: "#FFE4C4",
      black: "#000000",
      blanchedalmond: "#FFEBCD",
      blue: "#0000FF",
      blueviolet: "#8A2BE2",
      brown: "#A52A2A",
      burlywood: "#DEB887",
      cadetblue: "#5F9EA0",
      chartreuse: "#7FFF00",
      chocolate: "#D2691E",
      coral: "#FF7F50",
      cornflowerblue: "#6495ED",
      cornsilk: "#FFF8DC",
      crimson: "#DC143C",
      cyan: "#00FFFF",
      darkblue: "#00008B",
      darkcyan: "#008B8B",
      darkgoldenrod: "#B8860B",
      darkgray: "#A9A9A9",
      darkgreen: "#006400",
      darkgrey: "#A9A9A9",
      darkkhaki: "#BDB76B",
      darkmagenta: "#8B008B",
      darkolivegreen: "#556B2F",
      darkorange: "#FF8C00",
      darkorchid: "#9932CC",
      darkred: "#8B0000",
      darksalmon: "#E9967A",
      darkseagreen: "#8FBC8F",
      darkslateblue: "#483D8B",
      darkslategray: "#2F4F4F",
      darkslategrey: "#2F4F4F",
      darkturquoise: "#00CED1",
      darkviolet: "#9400D3",
      deeppink: "#FF1493",
      deepskyblue: "#00BFFF",
      dimgray: "#696969",
      dimgrey: "#696969",
      dodgerblue: "#1E90FF",
      firebrick: "#B22222",
      floralwhite: "#FFFAF0",
      forestgreen: "#228B22",
      fuchsia: "#FF00FF",
      gainsboro: "#DCDCDC",
      ghostwhite: "#F8F8FF",
      gold: "#FFD700",
      goldenrod: "#DAA520",
      gray: "#808080",
      green: "#008000",
      greenyellow: "#ADFF2F",
      grey: "#808080",
      honeydew: "#F0FFF0",
      hotpink: "#FF69B4",
      indianred: "#CD5C5C",
      indigo: "#4B0082",
      ivory: "#FFFFF0",
      khaki: "#F0E68C",
      lavender: "#E6E6FA",
      lavenderblush: "#FFF0F5",
      lawngreen: "#7CFC00",
      lemonchiffon: "#FFFACD",
      lightblue: "#ADD8E6",
      lightcoral: "#F08080",
      lightcyan: "#E0FFFF",
      lightgoldenrodyellow: "#FAFAD2",
      lightgray: "#D3D3D3",
      lightgreen: "#90EE90",
      lightgrey: "#D3D3D3",
      lightpink: "#FFB6C1",
      lightsalmon: "#FFA07A",
      lightseagreen: "#20B2AA",
      lightskyblue: "#87CEFA",
      lightslategray: "#778899",
      lightslategrey: "#778899",
      lightsteelblue: "#B0C4DE",
      lightyellow: "#FFFFE0",
      lime: "#00FF00",
      limegreen: "#32CD32",
      linen: "#FAF0E6",
      magenta: "#FF00FF",
      maroon: "#800000",
      mediumaquamarine: "#66CDAA",
      mediumblue: "#0000CD",
      mediumorchid: "#BA55D3",
      mediumpurple: "#9370DB",
      mediumseagreen: "#3CB371",
      mediumslateblue: "#7B68EE",
      mediumspringgreen: "#00FA9A",
      mediumturquoise: "#48D1CC",
      mediumvioletred: "#C71585",
      midnightblue: "#191970",
      mintcream: "#F5FFFA",
      mistyrose: "#FFE4E1",
      moccasin: "#FFE4B5",
      navajowhite: "#FFDEAD",
      navy: "#000080",
      oldlace: "#FDF5E6",
      olive: "#808000",
      olivedrab: "#6B8E23",
      orange: "#FFA500",
      orangered: "#FF4500",
      orchid: "#DA70D6",
      palegoldenrod: "#EEE8AA",
      palegreen: "#98FB98",
      paleturquoise: "#AFEEEE",
      palevioletred: "#DB7093",
      papayawhip: "#FFEFD5",
      peachpuff: "#FFDAB9",
      peru: "#CD853F",
      pink: "#FFC0CB",
      plum: "#DDA0DD",
      powderblue: "#B0E0E6",
      purple: "#800080",
      rebeccapurple: "#663399",
      red: "#FF0000",
      rosybrown: "#BC8F8F",
      royalblue: "#4169E1",
      saddlebrown: "#8B4513",
      salmon: "#FA8072",
      sandybrown: "#F4A460",
      seagreen: "#2E8B57",
      seashell: "#FFF5EE",
      sienna: "#A0522D",
      silver: "#C0C0C0",
      skyblue: "#87CEEB",
      slateblue: "#6A5ACD",
      slategray: "#708090",
      slategrey: "#708090",
      snow: "#FFFAFA",
      springgreen: "#00FF7F",
      steelblue: "#4682B4",
      tan: "#D2B48C",
      teal: "#008080",
      thistle: "#D8BFD8",
      tomato: "#FF6347",
      turquoise: "#40E0D0",
      violet: "#EE82EE",
      wheat: "#F5DEB3",
      white: "#FFFFFF",
      whitesmoke: "#F5F5F5",
      yellow: "#FFFF00",
      yellowgreen: "#9ACD32",
    };
    function r9(e) {
      let t,
        r,
        n,
        i = 1,
        a = e.replace(/\s/g, "").toLowerCase(),
        s = (typeof T_[a] == "string" ? T_[a].toLowerCase() : null) || a;
      if (s.startsWith("#")) {
        let l = s.substring(1);
        l.length === 3 || l.length === 4
          ? ((t = parseInt(l[0] + l[0], 16)),
            (r = parseInt(l[1] + l[1], 16)),
            (n = parseInt(l[2] + l[2], 16)),
            l.length === 4 && (i = parseInt(l[3] + l[3], 16) / 255))
          : (l.length === 6 || l.length === 8) &&
            ((t = parseInt(l.substring(0, 2), 16)),
            (r = parseInt(l.substring(2, 4), 16)),
            (n = parseInt(l.substring(4, 6), 16)),
            l.length === 8 && (i = parseInt(l.substring(6, 8), 16) / 255));
      } else if (s.startsWith("rgba")) {
        let l = s.match(/rgba\(([^)]+)\)/)[1].split(",");
        (t = parseInt(l[0], 10)),
          (r = parseInt(l[1], 10)),
          (n = parseInt(l[2], 10)),
          (i = parseFloat(l[3]));
      } else if (s.startsWith("rgb")) {
        let l = s.match(/rgb\(([^)]+)\)/)[1].split(",");
        (t = parseInt(l[0], 10)),
          (r = parseInt(l[1], 10)),
          (n = parseInt(l[2], 10));
      } else if (s.startsWith("hsla")) {
        let l = s.match(/hsla\(([^)]+)\)/)[1].split(","),
          f = parseFloat(l[0]),
          u = parseFloat(l[1].replace("%", "")) / 100,
          h = parseFloat(l[2].replace("%", "")) / 100;
        i = parseFloat(l[3]);
        let m = (1 - Math.abs(2 * h - 1)) * u,
          d = m * (1 - Math.abs(((f / 60) % 2) - 1)),
          p = h - m / 2,
          g,
          c,
          v;
        f >= 0 && f < 60
          ? ((g = m), (c = d), (v = 0))
          : f >= 60 && f < 120
          ? ((g = d), (c = m), (v = 0))
          : f >= 120 && f < 180
          ? ((g = 0), (c = m), (v = d))
          : f >= 180 && f < 240
          ? ((g = 0), (c = d), (v = m))
          : f >= 240 && f < 300
          ? ((g = d), (c = 0), (v = m))
          : ((g = m), (c = 0), (v = d)),
          (t = Math.round((g + p) * 255)),
          (r = Math.round((c + p) * 255)),
          (n = Math.round((v + p) * 255));
      } else if (s.startsWith("hsl")) {
        let l = s.match(/hsl\(([^)]+)\)/)[1].split(","),
          f = parseFloat(l[0]),
          u = parseFloat(l[1].replace("%", "")) / 100,
          h = parseFloat(l[2].replace("%", "")) / 100,
          m = (1 - Math.abs(2 * h - 1)) * u,
          d = m * (1 - Math.abs(((f / 60) % 2) - 1)),
          p = h - m / 2,
          g,
          c,
          v;
        f >= 0 && f < 60
          ? ((g = m), (c = d), (v = 0))
          : f >= 60 && f < 120
          ? ((g = d), (c = m), (v = 0))
          : f >= 120 && f < 180
          ? ((g = 0), (c = m), (v = d))
          : f >= 180 && f < 240
          ? ((g = 0), (c = d), (v = m))
          : f >= 240 && f < 300
          ? ((g = d), (c = 0), (v = m))
          : ((g = m), (c = 0), (v = d)),
          (t = Math.round((g + p) * 255)),
          (r = Math.round((c + p) * 255)),
          (n = Math.round((v + p) * 255));
      }
      if (Number.isNaN(t) || Number.isNaN(r) || Number.isNaN(n))
        throw new Error(
          `Invalid color in [ix2/shared/utils/normalizeColor.js] '${e}'`
        );
      return { red: t, green: r, blue: n, alpha: i };
    }
  });
  var A_ = E((ec) => {
    "use strict";
    Object.defineProperty(ec, "__esModule", { value: !0 });
    function n9(e, t) {
      for (var r in t)
        Object.defineProperty(e, r, { enumerable: !0, get: t[r] });
    }
    n9(ec, {
      clearPlugin: function () {
        return h9;
      },
      createPluginInstance: function () {
        return u9;
      },
      getPluginConfig: function () {
        return a9;
      },
      getPluginDestination: function () {
        return l9;
      },
      getPluginDuration: function () {
        return s9;
      },
      getPluginOrigin: function () {
        return o9;
      },
      renderPlugin: function () {
        return c9;
      },
    });
    var i9 = Ju(),
      a9 = (e, t) => e.value[t],
      s9 = () => null,
      o9 = (e, t) => {
        if (e) return e;
        let r = t.config.value,
          n = t.config.target.objectId,
          i = getComputedStyle(document.documentElement).getPropertyValue(n);
        if (r.size != null) return { size: parseInt(i, 10) };
        if (r.red != null && r.green != null && r.blue != null)
          return (0, i9.normalizeColor)(i);
      },
      l9 = (e) => e.value,
      u9 = () => null,
      c9 = (e, t, r) => {
        let n = r.config.target.objectId,
          i = r.config.value.unit,
          { PLUGIN_VARIABLE: a } = t,
          { size: o, red: s, green: l, blue: f, alpha: u } = a,
          h;
        o != null && (h = o + i),
          s != null &&
            f != null &&
            l != null &&
            u != null &&
            (h = `rgba(${s}, ${l}, ${f}, ${u})`),
          h != null && document.documentElement.style.setProperty(n, h);
      },
      h9 = (e, t) => {
        let r = t.config.target.objectId;
        document.documentElement.style.removeProperty(r);
      };
  });
  var w_ = E((tc) => {
    "use strict";
    Object.defineProperty(tc, "__esModule", { value: !0 });
    Object.defineProperty(tc, "pluginMethodMap", {
      enumerable: !0,
      get: function () {
        return g9;
      },
    });
    var os = (Ze(), ht(RS)),
      f9 = ls(x_()),
      p9 = ls(__()),
      d9 = ls(I_()),
      m9 = ls(A_());
    function P_(e) {
      if (typeof WeakMap != "function") return null;
      var t = new WeakMap(),
        r = new WeakMap();
      return (P_ = function (n) {
        return n ? r : t;
      })(e);
    }
    function ls(e, t) {
      if (!t && e && e.__esModule) return e;
      if (e === null || (typeof e != "object" && typeof e != "function"))
        return { default: e };
      var r = P_(t);
      if (r && r.has(e)) return r.get(e);
      var n = { __proto__: null },
        i = Object.defineProperty && Object.getOwnPropertyDescriptor;
      for (var a in e)
        if (a !== "default" && Object.prototype.hasOwnProperty.call(e, a)) {
          var o = i ? Object.getOwnPropertyDescriptor(e, a) : null;
          o && (o.get || o.set)
            ? Object.defineProperty(n, a, o)
            : (n[a] = e[a]);
        }
      return (n.default = e), r && r.set(e, n), n;
    }
    var g9 = new Map([
      [os.ActionTypeConsts.PLUGIN_LOTTIE, { ...f9 }],
      [os.ActionTypeConsts.PLUGIN_SPLINE, { ...p9 }],
      [os.ActionTypeConsts.PLUGIN_RIVE, { ...d9 }],
      [os.ActionTypeConsts.PLUGIN_VARIABLE, { ...m9 }],
    ]);
  });
  var C_ = {};
  He(C_, {
    clearPlugin: () => oc,
    createPluginInstance: () => y9,
    getPluginConfig: () => nc,
    getPluginDestination: () => ac,
    getPluginDuration: () => v9,
    getPluginOrigin: () => ic,
    isPluginType: () => Ir,
    renderPlugin: () => sc,
  });
  function Ir(e) {
    return rc.pluginMethodMap.has(e);
  }
  var rc,
    Tr,
    nc,
    ic,
    v9,
    ac,
    y9,
    sc,
    oc,
    lc = Ee(() => {
      "use strict";
      is();
      rc = me(w_());
      (Tr = (e) => (t) => {
        if (!bt) return () => null;
        let r = rc.pluginMethodMap.get(t);
        if (!r) throw new Error(`IX2 no plugin configured for: ${t}`);
        let n = r[e];
        if (!n) throw new Error(`IX2 invalid plugin method: ${e}`);
        return n;
      }),
        (nc = Tr("getPluginConfig")),
        (ic = Tr("getPluginOrigin")),
        (v9 = Tr("getPluginDuration")),
        (ac = Tr("getPluginDestination")),
        (y9 = Tr("createPluginInstance")),
        (sc = Tr("renderPlugin")),
        (oc = Tr("clearPlugin"));
    });
  var O_ = E((cle, M_) => {
    function E9(e, t) {
      return e == null || e !== e ? t : e;
    }
    M_.exports = E9;
  });
  var D_ = E((hle, R_) => {
    function b9(e, t, r, n) {
      var i = -1,
        a = e == null ? 0 : e.length;
      for (n && a && (r = e[++i]); ++i < a; ) r = t(r, e[i], i, e);
      return r;
    }
    R_.exports = b9;
  });
  var L_ = E((fle, F_) => {
    function x9(e) {
      return function (t, r, n) {
        for (var i = -1, a = Object(t), o = n(t), s = o.length; s--; ) {
          var l = o[e ? s : ++i];
          if (r(a[l], l, a) === !1) break;
        }
        return t;
      };
    }
    F_.exports = x9;
  });
  var k_ = E((ple, q_) => {
    var S9 = L_(),
      _9 = S9();
    q_.exports = _9;
  });
  var uc = E((dle, N_) => {
    var I9 = k_(),
      T9 = Mn();
    function A9(e, t) {
      return e && I9(e, t, T9);
    }
    N_.exports = A9;
  });
  var V_ = E((mle, B_) => {
    var P9 = fr();
    function w9(e, t) {
      return function (r, n) {
        if (r == null) return r;
        if (!P9(r)) return e(r, n);
        for (
          var i = r.length, a = t ? i : -1, o = Object(r);
          (t ? a-- : ++a < i) && n(o[a], a, o) !== !1;

        );
        return r;
      };
    }
    B_.exports = w9;
  });
  var cc = E((gle, G_) => {
    var C9 = uc(),
      M9 = V_(),
      O9 = M9(C9);
    G_.exports = O9;
  });
  var H_ = E((vle, z_) => {
    function R9(e, t, r, n, i) {
      return (
        i(e, function (a, o, s) {
          r = n ? ((n = !1), a) : t(r, a, o, s);
        }),
        r
      );
    }
    z_.exports = R9;
  });
  var W_ = E((yle, j_) => {
    var D9 = D_(),
      F9 = cc(),
      L9 = Kt(),
      q9 = H_(),
      k9 = qe();
    function N9(e, t, r) {
      var n = k9(e) ? D9 : q9,
        i = arguments.length < 3;
      return n(e, L9(t, 4), r, i, F9);
    }
    j_.exports = N9;
  });
  var X_ = E((Ele, U_) => {
    var B9 = Ws(),
      V9 = Kt(),
      G9 = Eo(),
      z9 = Math.max,
      H9 = Math.min;
    function j9(e, t, r) {
      var n = e == null ? 0 : e.length;
      if (!n) return -1;
      var i = n - 1;
      return (
        r !== void 0 &&
          ((i = G9(r)), (i = r < 0 ? z9(n + i, 0) : H9(i, n - 1))),
        B9(e, V9(t, 3), i, !0)
      );
    }
    U_.exports = j9;
  });
  var K_ = E((ble, $_) => {
    var W9 = Vu(),
      U9 = X_(),
      X9 = W9(U9);
    $_.exports = X9;
  });
  function Y_(e, t) {
    return e === t ? e !== 0 || t !== 0 || 1 / e === 1 / t : e !== e && t !== t;
  }
  function $9(e, t) {
    if (Y_(e, t)) return !0;
    if (
      typeof e != "object" ||
      e === null ||
      typeof t != "object" ||
      t === null
    )
      return !1;
    let r = Object.keys(e),
      n = Object.keys(t);
    if (r.length !== n.length) return !1;
    for (let i = 0; i < r.length; i++)
      if (!Object.hasOwn(t, r[i]) || !Y_(e[r[i]], t[r[i]])) return !1;
    return !0;
  }
  var hc,
    Q_ = Ee(() => {
      "use strict";
      hc = $9;
    });
  var mI = {};
  He(mI, {
    cleanupHTMLElement: () => W$,
    clearAllStyles: () => j$,
    clearObjectCache: () => h$,
    getActionListProgress: () => X$,
    getAffectedElements: () => gc,
    getComputedStyle: () => E$,
    getDestinationValues: () => A$,
    getElementId: () => m$,
    getInstanceId: () => p$,
    getInstanceOrigin: () => S$,
    getItemConfigByKey: () => T$,
    getMaxDurationItemIndex: () => dI,
    getNamespacedParameterId: () => Y$,
    getRenderType: () => hI,
    getStyleProp: () => P$,
    mediaQueriesEqual: () => Z$,
    observeStore: () => y$,
    reduceListToGroup: () => $$,
    reifyState: () => g$,
    renderHTMLElement: () => w$,
    shallowEqual: () => hc,
    shouldAllowMediaQuery: () => Q$,
    shouldNamespaceEventParameter: () => K$,
    stringifyTarget: () => J$,
  });
  function h$() {
    us.clear();
  }
  function p$() {
    return "i" + f$++;
  }
  function m$(e, t) {
    for (let r in e) {
      let n = e[r];
      if (n && n.ref === t) return n.id;
    }
    return "e" + d$++;
  }
  function g$({ events: e, actionLists: t, site: r } = {}) {
    let n = (0, ps.default)(
        e,
        (o, s) => {
          let { eventTypeId: l } = s;
          return o[l] || (o[l] = {}), (o[l][s.id] = s), o;
        },
        {}
      ),
      i = r && r.mediaQueries,
      a = [];
    return (
      i
        ? (a = i.map((o) => o.key))
        : ((i = []), console.warn("IX2 missing mediaQueries in site data")),
      {
        ixData: {
          events: e,
          actionLists: t,
          eventTypeMap: n,
          mediaQueries: i,
          mediaQueryKeys: a,
        },
      }
    );
  }
  function y$({ store: e, select: t, onChange: r, comparator: n = v$ }) {
    let { getState: i, subscribe: a } = e,
      o = a(l),
      s = t(i());
    function l() {
      let f = t(i());
      if (f == null) {
        o();
        return;
      }
      n(f, s) || ((s = f), r(s, e));
    }
    return o;
  }
  function eI(e) {
    let t = typeof e;
    if (t === "string") return { id: e };
    if (e != null && t === "object") {
      let {
        id: r,
        objectId: n,
        selector: i,
        selectorGuids: a,
        appliesTo: o,
        useEventTarget: s,
      } = e;
      return {
        id: r,
        objectId: n,
        selector: i,
        selectorGuids: a,
        appliesTo: o,
        useEventTarget: s,
      };
    }
    return {};
  }
  function gc({
    config: e,
    event: t,
    eventTarget: r,
    elementRoot: n,
    elementApi: i,
  }) {
    if (!i) throw new Error("IX2 missing elementApi");
    let { targets: a } = e;
    if (Array.isArray(a) && a.length > 0)
      return a.reduce(
        (F, w) =>
          F.concat(
            gc({
              config: { target: w },
              event: t,
              eventTarget: r,
              elementRoot: n,
              elementApi: i,
            })
          ),
        []
      );
    let {
        getValidDocument: o,
        getQuerySelector: s,
        queryDocument: l,
        getChildElements: f,
        getSiblingElements: u,
        matchSelector: h,
        elementContains: m,
        isSiblingNode: d,
      } = i,
      { target: p } = e;
    if (!p) return [];
    let {
      id: g,
      objectId: c,
      selector: v,
      selectorGuids: y,
      appliesTo: b,
      useEventTarget: x,
    } = eI(p);
    if (c) return [us.has(c) ? us.get(c) : us.set(c, {}).get(c)];
    if (b === qu.PAGE) {
      let F = o(g);
      return F ? [F] : [];
    }
    let T = (t?.action?.config?.affectedElements ?? {})[g || v] || {},
      I = !!(T.id || T.selector),
      P,
      L,
      M,
      _ = t && s(eI(t.target));
    if (
      (I
        ? ((P = T.limitAffectedElements), (L = _), (M = s(T)))
        : (L = M = s({ id: g, selector: v, selectorGuids: y })),
      t && x)
    ) {
      let F = r && (M || x === !0) ? [r] : l(_);
      if (M) {
        if (x === l$) return l(M).filter((w) => F.some((R) => m(w, R)));
        if (x === Z_) return l(M).filter((w) => F.some((R) => m(R, w)));
        if (x === J_) return l(M).filter((w) => F.some((R) => d(R, w)));
      }
      return F;
    }
    return L == null || M == null
      ? []
      : bt && n
      ? l(M).filter((F) => n.contains(F))
      : P === Z_
      ? l(L, M)
      : P === o$
      ? f(l(L)).filter(h(M))
      : P === J_
      ? u(l(L)).filter(h(M))
      : l(M);
  }
  function E$({ element: e, actionItem: t }) {
    if (!bt) return {};
    let { actionTypeId: r } = t;
    switch (r) {
      case cn:
      case hn:
      case fn:
      case pn:
      case ms:
        return window.getComputedStyle(e);
      default:
        return {};
    }
  }
  function S$(e, t = {}, r = {}, n, i) {
    let { getStyle: a } = i,
      { actionTypeId: o } = n;
    if (Ir(o)) return ic(o)(t[o], n);
    switch (n.actionTypeId) {
      case on:
      case ln:
      case un:
      case vi:
        return t[n.actionTypeId] || vc[n.actionTypeId];
      case yi:
        return b$(t[n.actionTypeId], n.config.filters);
      case Ei:
        return x$(t[n.actionTypeId], n.config.fontVariations);
      case lI:
        return { value: (0, Ht.default)(parseFloat(a(e, hs)), 1) };
      case cn: {
        let s = a(e, Ot),
          l = a(e, Rt),
          f,
          u;
        return (
          n.config.widthUnit === lr
            ? (f = tI.test(s) ? parseFloat(s) : parseFloat(r.width))
            : (f = (0, Ht.default)(parseFloat(s), parseFloat(r.width))),
          n.config.heightUnit === lr
            ? (u = tI.test(l) ? parseFloat(l) : parseFloat(r.height))
            : (u = (0, Ht.default)(parseFloat(l), parseFloat(r.height))),
          { widthValue: f, heightValue: u }
        );
      }
      case hn:
      case fn:
      case pn:
        return G$({
          element: e,
          actionTypeId: n.actionTypeId,
          computedStyle: r,
          getStyle: a,
        });
      case ms:
        return { value: (0, Ht.default)(a(e, fs), r.display) };
      case c$:
        return t[n.actionTypeId] || { value: 0 };
      default:
        return;
    }
  }
  function A$({ element: e, actionItem: t, elementApi: r }) {
    if (Ir(t.actionTypeId)) return ac(t.actionTypeId)(t.config);
    switch (t.actionTypeId) {
      case on:
      case ln:
      case un:
      case vi: {
        let { xValue: n, yValue: i, zValue: a } = t.config;
        return { xValue: n, yValue: i, zValue: a };
      }
      case cn: {
        let { getStyle: n, setStyle: i, getProperty: a } = r,
          { widthUnit: o, heightUnit: s } = t.config,
          { widthValue: l, heightValue: f } = t.config;
        if (!bt) return { widthValue: l, heightValue: f };
        if (o === lr) {
          let u = n(e, Ot);
          i(e, Ot, ""), (l = a(e, "offsetWidth")), i(e, Ot, u);
        }
        if (s === lr) {
          let u = n(e, Rt);
          i(e, Rt, ""), (f = a(e, "offsetHeight")), i(e, Rt, u);
        }
        return { widthValue: l, heightValue: f };
      }
      case hn:
      case fn:
      case pn: {
        let {
          rValue: n,
          gValue: i,
          bValue: a,
          aValue: o,
          globalSwatchId: s,
        } = t.config;
        if (s && s.startsWith("--")) {
          let { getStyle: l } = r,
            f = l(e, s),
            u = (0, iI.normalizeColor)(f);
          return {
            rValue: u.red,
            gValue: u.green,
            bValue: u.blue,
            aValue: u.alpha,
          };
        }
        return { rValue: n, gValue: i, bValue: a, aValue: o };
      }
      case yi:
        return t.config.filters.reduce(_$, {});
      case Ei:
        return t.config.fontVariations.reduce(I$, {});
      default: {
        let { value: n } = t.config;
        return { value: n };
      }
    }
  }
  function hI(e) {
    if (/^TRANSFORM_/.test(e)) return sI;
    if (/^STYLE_/.test(e)) return dc;
    if (/^GENERAL_/.test(e)) return pc;
    if (/^PLUGIN_/.test(e)) return oI;
  }
  function P$(e, t) {
    return e === dc ? t.replace("STYLE_", "").toLowerCase() : null;
  }
  function w$(e, t, r, n, i, a, o, s, l) {
    switch (s) {
      case sI:
        return D$(e, t, r, i, o);
      case dc:
        return z$(e, t, r, i, a, o);
      case pc:
        return H$(e, i, o);
      case oI: {
        let { actionTypeId: f } = i;
        if (Ir(f)) return sc(f)(l, t, i);
      }
    }
  }
  function D$(e, t, r, n, i) {
    let a = R$.map((s) => {
        let l = vc[s],
          {
            xValue: f = l.xValue,
            yValue: u = l.yValue,
            zValue: h = l.zValue,
            xUnit: m = "",
            yUnit: d = "",
            zUnit: p = "",
          } = t[s] || {};
        switch (s) {
          case on:
            return `${Q9}(${f}${m}, ${u}${d}, ${h}${p})`;
          case ln:
            return `${Z9}(${f}${m}, ${u}${d}, ${h}${p})`;
          case un:
            return `${J9}(${f}${m}) ${e$}(${u}${d}) ${t$}(${h}${p})`;
          case vi:
            return `${r$}(${f}${m}, ${u}${d})`;
          default:
            return "";
        }
      }).join(" "),
      { setStyle: o } = i;
    Ar(e, or, i), o(e, or, a), q$(n, r) && o(e, ns, n$);
  }
  function F$(e, t, r, n) {
    let i = (0, ps.default)(t, (o, s, l) => `${o} ${l}(${s}${O$(l, r)})`, ""),
      { setStyle: a } = n;
    Ar(e, di, n), a(e, di, i);
  }
  function L$(e, t, r, n) {
    let i = (0, ps.default)(
        t,
        (o, s, l) => (o.push(`"${l}" ${s}`), o),
        []
      ).join(", "),
      { setStyle: a } = n;
    Ar(e, mi, n), a(e, mi, i);
  }
  function q$({ actionTypeId: e }, { xValue: t, yValue: r, zValue: n }) {
    return (
      (e === on && n !== void 0) ||
      (e === ln && n !== void 0) ||
      (e === un && (t !== void 0 || r !== void 0))
    );
  }
  function V$(e, t) {
    let r = e.exec(t);
    return r ? r[1] : "";
  }
  function G$({ element: e, actionTypeId: t, computedStyle: r, getStyle: n }) {
    let i = mc[t],
      a = n(e, i),
      o = N$.test(a) ? a : r[i],
      s = V$(B$, o).split(gi);
    return {
      rValue: (0, Ht.default)(parseInt(s[0], 10), 255),
      gValue: (0, Ht.default)(parseInt(s[1], 10), 255),
      bValue: (0, Ht.default)(parseInt(s[2], 10), 255),
      aValue: (0, Ht.default)(parseFloat(s[3]), 1),
    };
  }
  function z$(e, t, r, n, i, a) {
    let { setStyle: o } = a;
    switch (n.actionTypeId) {
      case cn: {
        let { widthUnit: s = "", heightUnit: l = "" } = n.config,
          { widthValue: f, heightValue: u } = r;
        f !== void 0 && (s === lr && (s = "px"), Ar(e, Ot, a), o(e, Ot, f + s)),
          u !== void 0 &&
            (l === lr && (l = "px"), Ar(e, Rt, a), o(e, Rt, u + l));
        break;
      }
      case yi: {
        F$(e, r, n.config, a);
        break;
      }
      case Ei: {
        L$(e, r, n.config, a);
        break;
      }
      case hn:
      case fn:
      case pn: {
        let s = mc[n.actionTypeId],
          l = Math.round(r.rValue),
          f = Math.round(r.gValue),
          u = Math.round(r.bValue),
          h = r.aValue;
        Ar(e, s, a),
          o(e, s, h >= 1 ? `rgb(${l},${f},${u})` : `rgba(${l},${f},${u},${h})`);
        break;
      }
      default: {
        let { unit: s = "" } = n.config;
        Ar(e, i, a), o(e, i, r.value + s);
        break;
      }
    }
  }
  function H$(e, t, r) {
    let { setStyle: n } = r;
    switch (t.actionTypeId) {
      case ms: {
        let { value: i } = t.config;
        i === i$ && bt ? n(e, fs, zu) : n(e, fs, i);
        return;
      }
    }
  }
  function Ar(e, t, r) {
    if (!bt) return;
    let n = cI[t];
    if (!n) return;
    let { getStyle: i, setStyle: a } = r,
      o = i(e, sn);
    if (!o) {
      a(e, sn, n);
      return;
    }
    let s = o.split(gi).map(uI);
    s.indexOf(n) === -1 && a(e, sn, s.concat(n).join(gi));
  }
  function fI(e, t, r) {
    if (!bt) return;
    let n = cI[t];
    if (!n) return;
    let { getStyle: i, setStyle: a } = r,
      o = i(e, sn);
    !o ||
      o.indexOf(n) === -1 ||
      a(
        e,
        sn,
        o
          .split(gi)
          .map(uI)
          .filter((s) => s !== n)
          .join(gi)
      );
  }
  function j$({ store: e, elementApi: t }) {
    let { ixData: r } = e.getState(),
      { events: n = {}, actionLists: i = {} } = r;
    Object.keys(n).forEach((a) => {
      let o = n[a],
        { config: s } = o.action,
        { actionListId: l } = s,
        f = i[l];
      f && rI({ actionList: f, event: o, elementApi: t });
    }),
      Object.keys(i).forEach((a) => {
        rI({ actionList: i[a], elementApi: t });
      });
  }
  function rI({ actionList: e = {}, event: t, elementApi: r }) {
    let { actionItemGroups: n, continuousParameterGroups: i } = e;
    n &&
      n.forEach((a) => {
        nI({ actionGroup: a, event: t, elementApi: r });
      }),
      i &&
        i.forEach((a) => {
          let { continuousActionGroups: o } = a;
          o.forEach((s) => {
            nI({ actionGroup: s, event: t, elementApi: r });
          });
        });
  }
  function nI({ actionGroup: e, event: t, elementApi: r }) {
    let { actionItems: n } = e;
    n.forEach((i) => {
      let { actionTypeId: a, config: o } = i,
        s;
      Ir(a)
        ? (s = (l) => oc(a)(l, i))
        : (s = pI({ effect: U$, actionTypeId: a, elementApi: r })),
        gc({ config: o, event: t, elementApi: r }).forEach(s);
    });
  }
  function W$(e, t, r) {
    let { setStyle: n, getStyle: i } = r,
      { actionTypeId: a } = t;
    if (a === cn) {
      let { config: o } = t;
      o.widthUnit === lr && n(e, Ot, ""), o.heightUnit === lr && n(e, Rt, "");
    }
    i(e, sn) && pI({ effect: fI, actionTypeId: a, elementApi: r })(e);
  }
  function U$(e, t, r) {
    let { setStyle: n } = r;
    fI(e, t, r), n(e, t, ""), t === or && n(e, ns, "");
  }
  function dI(e) {
    let t = 0,
      r = 0;
    return (
      e.forEach((n, i) => {
        let { config: a } = n,
          o = a.delay + a.duration;
        o >= t && ((t = o), (r = i));
      }),
      r
    );
  }
  function X$(e, t) {
    let { actionItemGroups: r, useFirstGroupAsInitialState: n } = e,
      { actionItem: i, verboseTimeElapsed: a = 0 } = t,
      o = 0,
      s = 0;
    return (
      r.forEach((l, f) => {
        if (n && f === 0) return;
        let { actionItems: u } = l,
          h = u[dI(u)],
          { config: m, actionTypeId: d } = h;
        i.id === h.id && (s = o + a);
        let p = hI(d) === pc ? 0 : m.duration;
        o += m.delay + p;
      }),
      o > 0 ? pi(s / o) : 0
    );
  }
  function $$({ actionList: e, actionItemId: t, rawData: r }) {
    let { actionItemGroups: n, continuousParameterGroups: i } = e,
      a = [],
      o = (s) => (
        a.push((0, ds.mergeIn)(s, ["config"], { delay: 0, duration: 0 })),
        s.id === t
      );
    return (
      n && n.some(({ actionItems: s }) => s.some(o)),
      i &&
        i.some((s) => {
          let { continuousActionGroups: l } = s;
          return l.some(({ actionItems: f }) => f.some(o));
        }),
      (0, ds.setIn)(r, ["actionLists"], {
        [e.id]: { id: e.id, actionItemGroups: [{ actionItems: a }] },
      })
    );
  }
  function K$(e, { basedOn: t }) {
    return (
      (e === Et.SCROLLING_IN_VIEW && (t === Mt.ELEMENT || t == null)) ||
      (e === Et.MOUSE_MOVE && t === Mt.ELEMENT)
    );
  }
  function Y$(e, t) {
    return e + u$ + t;
  }
  function Q$(e, t) {
    return t == null ? !0 : e.indexOf(t) !== -1;
  }
  function Z$(e, t) {
    return hc(e && e.sort(), t && t.sort());
  }
  function J$(e) {
    if (typeof e == "string") return e;
    if (e.pluginElement && e.objectId) return e.pluginElement + fc + e.objectId;
    if (e.objectId) return e.objectId;
    let { id: t = "", selector: r = "", useEventTarget: n = "" } = e;
    return t + fc + r + fc + n;
  }
  var Ht,
    ps,
    cs,
    ds,
    iI,
    K9,
    Y9,
    Q9,
    Z9,
    J9,
    e$,
    t$,
    r$,
    n$,
    i$,
    hs,
    di,
    mi,
    Ot,
    Rt,
    aI,
    a$,
    s$,
    Z_,
    o$,
    J_,
    l$,
    fs,
    sn,
    lr,
    gi,
    u$,
    fc,
    sI,
    pc,
    dc,
    oI,
    on,
    ln,
    un,
    vi,
    lI,
    yi,
    Ei,
    cn,
    hn,
    fn,
    pn,
    ms,
    c$,
    uI,
    mc,
    cI,
    us,
    f$,
    d$,
    v$,
    tI,
    b$,
    x$,
    _$,
    I$,
    T$,
    vc,
    C$,
    M$,
    O$,
    R$,
    k$,
    N$,
    B$,
    pI,
    gI = Ee(() => {
      "use strict";
      (Ht = me(O_())), (ps = me(W_())), (cs = me(K_())), (ds = me(nn()));
      Ze();
      Q_();
      Wu();
      iI = me(Ju());
      lc();
      is();
      ({
        BACKGROUND: K9,
        TRANSFORM: Y9,
        TRANSLATE_3D: Q9,
        SCALE_3D: Z9,
        ROTATE_X: J9,
        ROTATE_Y: e$,
        ROTATE_Z: t$,
        SKEW: r$,
        PRESERVE_3D: n$,
        FLEX: i$,
        OPACITY: hs,
        FILTER: di,
        FONT_VARIATION_SETTINGS: mi,
        WIDTH: Ot,
        HEIGHT: Rt,
        BACKGROUND_COLOR: aI,
        BORDER_COLOR: a$,
        COLOR: s$,
        CHILDREN: Z_,
        IMMEDIATE_CHILDREN: o$,
        SIBLINGS: J_,
        PARENT: l$,
        DISPLAY: fs,
        WILL_CHANGE: sn,
        AUTO: lr,
        COMMA_DELIMITER: gi,
        COLON_DELIMITER: u$,
        BAR_DELIMITER: fc,
        RENDER_TRANSFORM: sI,
        RENDER_GENERAL: pc,
        RENDER_STYLE: dc,
        RENDER_PLUGIN: oI,
      } = Ve),
        ({
          TRANSFORM_MOVE: on,
          TRANSFORM_SCALE: ln,
          TRANSFORM_ROTATE: un,
          TRANSFORM_SKEW: vi,
          STYLE_OPACITY: lI,
          STYLE_FILTER: yi,
          STYLE_FONT_VARIATION: Ei,
          STYLE_SIZE: cn,
          STYLE_BACKGROUND_COLOR: hn,
          STYLE_BORDER: fn,
          STYLE_TEXT_COLOR: pn,
          GENERAL_DISPLAY: ms,
          OBJECT_VALUE: c$,
        } = Xe),
        (uI = (e) => e.trim()),
        (mc = Object.freeze({ [hn]: aI, [fn]: a$, [pn]: s$ })),
        (cI = Object.freeze({
          [or]: Y9,
          [aI]: K9,
          [hs]: hs,
          [di]: di,
          [Ot]: Ot,
          [Rt]: Rt,
          [mi]: mi,
        })),
        (us = new Map());
      f$ = 1;
      d$ = 1;
      v$ = (e, t) => e === t;
      (tI = /px/),
        (b$ = (e, t) =>
          t.reduce(
            (r, n) => (r[n.type] == null && (r[n.type] = C$[n.type]), r),
            e || {}
          )),
        (x$ = (e, t) =>
          t.reduce(
            (r, n) => (
              r[n.type] == null &&
                (r[n.type] = M$[n.type] || n.defaultValue || 0),
              r
            ),
            e || {}
          ));
      (_$ = (e, t) => (t && (e[t.type] = t.value || 0), e)),
        (I$ = (e, t) => (t && (e[t.type] = t.value || 0), e)),
        (T$ = (e, t, r) => {
          if (Ir(e)) return nc(e)(r, t);
          switch (e) {
            case yi: {
              let n = (0, cs.default)(r.filters, ({ type: i }) => i === t);
              return n ? n.value : 0;
            }
            case Ei: {
              let n = (0, cs.default)(
                r.fontVariations,
                ({ type: i }) => i === t
              );
              return n ? n.value : 0;
            }
            default:
              return r[t];
          }
        });
      (vc = {
        [on]: Object.freeze({ xValue: 0, yValue: 0, zValue: 0 }),
        [ln]: Object.freeze({ xValue: 1, yValue: 1, zValue: 1 }),
        [un]: Object.freeze({ xValue: 0, yValue: 0, zValue: 0 }),
        [vi]: Object.freeze({ xValue: 0, yValue: 0 }),
      }),
        (C$ = Object.freeze({
          blur: 0,
          "hue-rotate": 0,
          invert: 0,
          grayscale: 0,
          saturate: 100,
          sepia: 0,
          contrast: 100,
          brightness: 100,
        })),
        (M$ = Object.freeze({ wght: 0, opsz: 0, wdth: 0, slnt: 0 })),
        (O$ = (e, t) => {
          let r = (0, cs.default)(t.filters, ({ type: n }) => n === e);
          if (r && r.unit) return r.unit;
          switch (e) {
            case "blur":
              return "px";
            case "hue-rotate":
              return "deg";
            default:
              return "%";
          }
        }),
        (R$ = Object.keys(vc));
      (k$ = "\\(([^)]+)\\)"), (N$ = /^rgb/), (B$ = RegExp(`rgba?${k$}`));
      pI =
        ({ effect: e, actionTypeId: t, elementApi: r }) =>
        (n) => {
          switch (t) {
            case on:
            case ln:
            case un:
            case vi:
              e(n, or, r);
              break;
            case yi:
              e(n, di, r);
              break;
            case Ei:
              e(n, mi, r);
              break;
            case lI:
              e(n, hs, r);
              break;
            case cn:
              e(n, Ot, r), e(n, Rt, r);
              break;
            case hn:
            case fn:
            case pn:
              e(n, mc[t], r);
              break;
            case ms:
              e(n, fs, r);
              break;
          }
        };
    });
  var Pr = E((yc) => {
    "use strict";
    Object.defineProperty(yc, "__esModule", { value: !0 });
    function e7(e, t) {
      for (var r in t)
        Object.defineProperty(e, r, { enumerable: !0, get: t[r] });
    }
    e7(yc, {
      IX2BrowserSupport: function () {
        return t7;
      },
      IX2EasingUtils: function () {
        return n7;
      },
      IX2Easings: function () {
        return r7;
      },
      IX2ElementsReducer: function () {
        return i7;
      },
      IX2VanillaPlugins: function () {
        return a7;
      },
      IX2VanillaUtils: function () {
        return s7;
      },
    });
    var t7 = dn((is(), ht(u_))),
      r7 = dn((ju(), ht(fi))),
      n7 = dn((Wu(), ht(g_))),
      i7 = dn((b_(), ht(E_))),
      a7 = dn((lc(), ht(C_))),
      s7 = dn((gI(), ht(mI)));
    function vI(e) {
      if (typeof WeakMap != "function") return null;
      var t = new WeakMap(),
        r = new WeakMap();
      return (vI = function (n) {
        return n ? r : t;
      })(e);
    }
    function dn(e, t) {
      if (!t && e && e.__esModule) return e;
      if (e === null || (typeof e != "object" && typeof e != "function"))
        return { default: e };
      var r = vI(t);
      if (r && r.has(e)) return r.get(e);
      var n = { __proto__: null },
        i = Object.defineProperty && Object.getOwnPropertyDescriptor;
      for (var a in e)
        if (a !== "default" && Object.prototype.hasOwnProperty.call(e, a)) {
          var o = i ? Object.getOwnPropertyDescriptor(e, a) : null;
          o && (o.get || o.set)
            ? Object.defineProperty(n, a, o)
            : (n[a] = e[a]);
        }
      return (n.default = e), r && r.set(e, n), n;
    }
  });
  var vs,
    jt,
    o7,
    l7,
    u7,
    c7,
    h7,
    f7,
    gs,
    yI,
    p7,
    d7,
    Ec,
    m7,
    g7,
    v7,
    y7,
    EI,
    bI = Ee(() => {
      "use strict";
      Ze();
      (vs = me(Pr())),
        (jt = me(nn())),
        ({
          IX2_RAW_DATA_IMPORTED: o7,
          IX2_SESSION_STOPPED: l7,
          IX2_INSTANCE_ADDED: u7,
          IX2_INSTANCE_STARTED: c7,
          IX2_INSTANCE_REMOVED: h7,
          IX2_ANIMATION_FRAME_CHANGED: f7,
        } = Le),
        ({
          optimizeFloat: gs,
          applyEasing: yI,
          createBezierEasing: p7,
        } = vs.IX2EasingUtils),
        ({ RENDER_GENERAL: d7 } = Ve),
        ({
          getItemConfigByKey: Ec,
          getRenderType: m7,
          getStyleProp: g7,
        } = vs.IX2VanillaUtils),
        (v7 = (e, t) => {
          let {
              position: r,
              parameterId: n,
              actionGroups: i,
              destinationKeys: a,
              smoothing: o,
              restingValue: s,
              actionTypeId: l,
              customEasingFn: f,
              skipMotion: u,
              skipToValue: h,
            } = e,
            { parameters: m } = t.payload,
            d = Math.max(1 - o, 0.01),
            p = m[n];
          p == null && ((d = 1), (p = s));
          let g = Math.max(p, 0) || 0,
            c = gs(g - r),
            v = u ? h : gs(r + c * d),
            y = v * 100;
          if (v === r && e.current) return e;
          let b, x, S, T;
          for (let P = 0, { length: L } = i; P < L; P++) {
            let { keyframe: M, actionItems: _ } = i[P];
            if ((P === 0 && (b = _[0]), y >= M)) {
              b = _[0];
              let F = i[P + 1],
                w = F && y !== M;
              (x = w ? F.actionItems[0] : null),
                w && ((S = M / 100), (T = (F.keyframe - M) / 100));
            }
          }
          let I = {};
          if (b && !x)
            for (let P = 0, { length: L } = a; P < L; P++) {
              let M = a[P];
              I[M] = Ec(l, M, b.config);
            }
          else if (b && x && S !== void 0 && T !== void 0) {
            let P = (v - S) / T,
              L = b.config.easing,
              M = yI(L, P, f);
            for (let _ = 0, { length: F } = a; _ < F; _++) {
              let w = a[_],
                R = Ec(l, w, b.config),
                ee = (Ec(l, w, x.config) - R) * M + R;
              I[w] = ee;
            }
          }
          return (0, jt.merge)(e, { position: v, current: I });
        }),
        (y7 = (e, t) => {
          let {
              active: r,
              origin: n,
              start: i,
              immediate: a,
              renderType: o,
              verbose: s,
              actionItem: l,
              destination: f,
              destinationKeys: u,
              pluginDuration: h,
              instanceDelay: m,
              customEasingFn: d,
              skipMotion: p,
            } = e,
            g = l.config.easing,
            { duration: c, delay: v } = l.config;
          h != null && (c = h),
            (v = m ?? v),
            o === d7 ? (c = 0) : (a || p) && (c = v = 0);
          let { now: y } = t.payload;
          if (r && n) {
            let b = y - (i + v);
            if (s) {
              let P = y - i,
                L = c + v,
                M = gs(Math.min(Math.max(0, P / L), 1));
              e = (0, jt.set)(e, "verboseTimeElapsed", L * M);
            }
            if (b < 0) return e;
            let x = gs(Math.min(Math.max(0, b / c), 1)),
              S = yI(g, x, d),
              T = {},
              I = null;
            return (
              u.length &&
                (I = u.reduce((P, L) => {
                  let M = f[L],
                    _ = parseFloat(n[L]) || 0,
                    w = (parseFloat(M) - _) * S + _;
                  return (P[L] = w), P;
                }, {})),
              (T.current = I),
              (T.position = x),
              x === 1 && ((T.active = !1), (T.complete = !0)),
              (0, jt.merge)(e, T)
            );
          }
          return e;
        }),
        (EI = (e = Object.freeze({}), t) => {
          switch (t.type) {
            case o7:
              return t.payload.ixInstances || Object.freeze({});
            case l7:
              return Object.freeze({});
            case u7: {
              let {
                  instanceId: r,
                  elementId: n,
                  actionItem: i,
                  eventId: a,
                  eventTarget: o,
                  eventStateKey: s,
                  actionListId: l,
                  groupIndex: f,
                  isCarrier: u,
                  origin: h,
                  destination: m,
                  immediate: d,
                  verbose: p,
                  continuous: g,
                  parameterId: c,
                  actionGroups: v,
                  smoothing: y,
                  restingValue: b,
                  pluginInstance: x,
                  pluginDuration: S,
                  instanceDelay: T,
                  skipMotion: I,
                  skipToValue: P,
                } = t.payload,
                { actionTypeId: L } = i,
                M = m7(L),
                _ = g7(M, L),
                F = Object.keys(m).filter(
                  (R) => m[R] != null && typeof m[R] != "string"
                ),
                { easing: w } = i.config;
              return (0, jt.set)(e, r, {
                id: r,
                elementId: n,
                active: !1,
                position: 0,
                start: 0,
                origin: h,
                destination: m,
                destinationKeys: F,
                immediate: d,
                verbose: p,
                current: null,
                actionItem: i,
                actionTypeId: L,
                eventId: a,
                eventTarget: o,
                eventStateKey: s,
                actionListId: l,
                groupIndex: f,
                renderType: M,
                isCarrier: u,
                styleProp: _,
                continuous: g,
                parameterId: c,
                actionGroups: v,
                smoothing: y,
                restingValue: b,
                pluginInstance: x,
                pluginDuration: S,
                instanceDelay: T,
                skipMotion: I,
                skipToValue: P,
                customEasingFn:
                  Array.isArray(w) && w.length === 4 ? p7(w) : void 0,
              });
            }
            case c7: {
              let { instanceId: r, time: n } = t.payload;
              return (0, jt.mergeIn)(e, [r], {
                active: !0,
                complete: !1,
                start: n,
              });
            }
            case h7: {
              let { instanceId: r } = t.payload;
              if (!e[r]) return e;
              let n = {},
                i = Object.keys(e),
                { length: a } = i;
              for (let o = 0; o < a; o++) {
                let s = i[o];
                s !== r && (n[s] = e[s]);
              }
              return n;
            }
            case f7: {
              let r = e,
                n = Object.keys(e),
                { length: i } = n;
              for (let a = 0; a < i; a++) {
                let o = n[a],
                  s = e[o],
                  l = s.continuous ? v7 : y7;
                r = (0, jt.set)(r, o, l(s, t));
              }
              return r;
            }
            default:
              return e;
          }
        });
    });
  var E7,
    b7,
    x7,
    xI,
    SI = Ee(() => {
      "use strict";
      Ze();
      ({
        IX2_RAW_DATA_IMPORTED: E7,
        IX2_SESSION_STOPPED: b7,
        IX2_PARAMETER_CHANGED: x7,
      } = Le),
        (xI = (e = {}, t) => {
          switch (t.type) {
            case E7:
              return t.payload.ixParameters || {};
            case b7:
              return {};
            case x7: {
              let { key: r, value: n } = t.payload;
              return (e[r] = n), e;
            }
            default:
              return e;
          }
        });
    });
  var TI = {};
  He(TI, { default: () => _7 });
  var _I,
    II,
    S7,
    _7,
    AI = Ee(() => {
      "use strict";
      _I = me(Lu());
      FS();
      t_();
      i_();
      II = me(Pr());
      bI();
      SI();
      ({ ixElements: S7 } = II.IX2ElementsReducer),
        (_7 = (0, _I.combineReducers)({
          ixData: DS,
          ixRequest: e_,
          ixSession: n_,
          ixElements: S7,
          ixInstances: EI,
          ixParameters: xI,
        }));
    });
  var wI = E((Nle, PI) => {
    var I7 = Xt(),
      T7 = qe(),
      A7 = Ft(),
      P7 = "[object String]";
    function w7(e) {
      return typeof e == "string" || (!T7(e) && A7(e) && I7(e) == P7);
    }
    PI.exports = w7;
  });
  var MI = E((Ble, CI) => {
    var C7 = yo(),
      M7 = C7("length");
    CI.exports = M7;
  });
  var RI = E((Vle, OI) => {
    var O7 = "\\ud800-\\udfff",
      R7 = "\\u0300-\\u036f",
      D7 = "\\ufe20-\\ufe2f",
      F7 = "\\u20d0-\\u20ff",
      L7 = R7 + D7 + F7,
      q7 = "\\ufe0e\\ufe0f",
      k7 = "\\u200d",
      N7 = RegExp("[" + k7 + O7 + L7 + q7 + "]");
    function B7(e) {
      return N7.test(e);
    }
    OI.exports = B7;
  });
  var GI = E((Gle, VI) => {
    var FI = "\\ud800-\\udfff",
      V7 = "\\u0300-\\u036f",
      G7 = "\\ufe20-\\ufe2f",
      z7 = "\\u20d0-\\u20ff",
      H7 = V7 + G7 + z7,
      j7 = "\\ufe0e\\ufe0f",
      W7 = "[" + FI + "]",
      bc = "[" + H7 + "]",
      xc = "\\ud83c[\\udffb-\\udfff]",
      U7 = "(?:" + bc + "|" + xc + ")",
      LI = "[^" + FI + "]",
      qI = "(?:\\ud83c[\\udde6-\\uddff]){2}",
      kI = "[\\ud800-\\udbff][\\udc00-\\udfff]",
      X7 = "\\u200d",
      NI = U7 + "?",
      BI = "[" + j7 + "]?",
      $7 = "(?:" + X7 + "(?:" + [LI, qI, kI].join("|") + ")" + BI + NI + ")*",
      K7 = BI + NI + $7,
      Y7 = "(?:" + [LI + bc + "?", bc, qI, kI, W7].join("|") + ")",
      DI = RegExp(xc + "(?=" + xc + ")|" + Y7 + K7, "g");
    function Q7(e) {
      for (var t = (DI.lastIndex = 0); DI.test(e); ) ++t;
      return t;
    }
    VI.exports = Q7;
  });
  var HI = E((zle, zI) => {
    var Z7 = MI(),
      J7 = RI(),
      eK = GI();
    function tK(e) {
      return J7(e) ? eK(e) : Z7(e);
    }
    zI.exports = tK;
  });
  var WI = E((Hle, jI) => {
    var rK = Gi(),
      nK = zi(),
      iK = fr(),
      aK = wI(),
      sK = HI(),
      oK = "[object Map]",
      lK = "[object Set]";
    function uK(e) {
      if (e == null) return 0;
      if (iK(e)) return aK(e) ? sK(e) : e.length;
      var t = nK(e);
      return t == oK || t == lK ? e.size : rK(e).length;
    }
    jI.exports = uK;
  });
  var XI = E((jle, UI) => {
    var cK = "Expected a function";
    function hK(e) {
      if (typeof e != "function") throw new TypeError(cK);
      return function () {
        var t = arguments;
        switch (t.length) {
          case 0:
            return !e.call(this);
          case 1:
            return !e.call(this, t[0]);
          case 2:
            return !e.call(this, t[0], t[1]);
          case 3:
            return !e.call(this, t[0], t[1], t[2]);
        }
        return !e.apply(this, t);
      };
    }
    UI.exports = hK;
  });
  var Sc = E((Wle, $I) => {
    var fK = $t(),
      pK = (function () {
        try {
          var e = fK(Object, "defineProperty");
          return e({}, "", {}), e;
        } catch {}
      })();
    $I.exports = pK;
  });
  var _c = E((Ule, YI) => {
    var KI = Sc();
    function dK(e, t, r) {
      t == "__proto__" && KI
        ? KI(e, t, { configurable: !0, enumerable: !0, value: r, writable: !0 })
        : (e[t] = r);
    }
    YI.exports = dK;
  });
  var ZI = E((Xle, QI) => {
    var mK = _c(),
      gK = Oi(),
      vK = Object.prototype,
      yK = vK.hasOwnProperty;
    function EK(e, t, r) {
      var n = e[t];
      (!(yK.call(e, t) && gK(n, r)) || (r === void 0 && !(t in e))) &&
        mK(e, t, r);
    }
    QI.exports = EK;
  });
  var tT = E(($le, eT) => {
    var bK = ZI(),
      xK = Rn(),
      SK = ki(),
      JI = It(),
      _K = Vr();
    function IK(e, t, r, n) {
      if (!JI(e)) return e;
      t = xK(t, e);
      for (var i = -1, a = t.length, o = a - 1, s = e; s != null && ++i < a; ) {
        var l = _K(t[i]),
          f = r;
        if (l === "__proto__" || l === "constructor" || l === "prototype")
          return e;
        if (i != o) {
          var u = s[l];
          (f = n ? n(u, l, s) : void 0),
            f === void 0 && (f = JI(u) ? u : SK(t[i + 1]) ? [] : {});
        }
        bK(s, l, f), (s = s[l]);
      }
      return e;
    }
    eT.exports = IK;
  });
  var nT = E((Kle, rT) => {
    var TK = Wi(),
      AK = tT(),
      PK = Rn();
    function wK(e, t, r) {
      for (var n = -1, i = t.length, a = {}; ++n < i; ) {
        var o = t[n],
          s = TK(e, o);
        r(s, o) && AK(a, PK(o, e), s);
      }
      return a;
    }
    rT.exports = wK;
  });
  var aT = E((Yle, iT) => {
    var CK = Li(),
      MK = Su(),
      OK = to(),
      RK = eo(),
      DK = Object.getOwnPropertySymbols,
      FK = DK
        ? function (e) {
            for (var t = []; e; ) CK(t, OK(e)), (e = MK(e));
            return t;
          }
        : RK;
    iT.exports = FK;
  });
  var oT = E((Qle, sT) => {
    function LK(e) {
      var t = [];
      if (e != null) for (var r in Object(e)) t.push(r);
      return t;
    }
    sT.exports = LK;
  });
  var uT = E((Zle, lT) => {
    var qK = It(),
      kK = Vi(),
      NK = oT(),
      BK = Object.prototype,
      VK = BK.hasOwnProperty;
    function GK(e) {
      if (!qK(e)) return NK(e);
      var t = kK(e),
        r = [];
      for (var n in e)
        (n == "constructor" && (t || !VK.call(e, n))) || r.push(n);
      return r;
    }
    lT.exports = GK;
  });
  var hT = E((Jle, cT) => {
    var zK = no(),
      HK = uT(),
      jK = fr();
    function WK(e) {
      return jK(e) ? zK(e, !0) : HK(e);
    }
    cT.exports = WK;
  });
  var pT = E((eue, fT) => {
    var UK = Js(),
      XK = aT(),
      $K = hT();
    function KK(e) {
      return UK(e, $K, XK);
    }
    fT.exports = KK;
  });
  var mT = E((tue, dT) => {
    var YK = vo(),
      QK = Kt(),
      ZK = nT(),
      JK = pT();
    function eY(e, t) {
      if (e == null) return {};
      var r = YK(JK(e), function (n) {
        return [n];
      });
      return (
        (t = QK(t)),
        ZK(e, r, function (n, i) {
          return t(n, i[0]);
        })
      );
    }
    dT.exports = eY;
  });
  var vT = E((rue, gT) => {
    var tY = Kt(),
      rY = XI(),
      nY = mT();
    function iY(e, t) {
      return nY(e, rY(tY(t)));
    }
    gT.exports = iY;
  });
  var ET = E((nue, yT) => {
    var aY = Gi(),
      sY = zi(),
      oY = An(),
      lY = qe(),
      uY = fr(),
      cY = qi(),
      hY = Vi(),
      fY = Bi(),
      pY = "[object Map]",
      dY = "[object Set]",
      mY = Object.prototype,
      gY = mY.hasOwnProperty;
    function vY(e) {
      if (e == null) return !0;
      if (
        uY(e) &&
        (lY(e) ||
          typeof e == "string" ||
          typeof e.splice == "function" ||
          cY(e) ||
          fY(e) ||
          oY(e))
      )
        return !e.length;
      var t = sY(e);
      if (t == pY || t == dY) return !e.size;
      if (hY(e)) return !aY(e).length;
      for (var r in e) if (gY.call(e, r)) return !1;
      return !0;
    }
    yT.exports = vY;
  });
  var xT = E((iue, bT) => {
    var yY = _c(),
      EY = uc(),
      bY = Kt();
    function xY(e, t) {
      var r = {};
      return (
        (t = bY(t, 3)),
        EY(e, function (n, i, a) {
          yY(r, i, t(n, i, a));
        }),
        r
      );
    }
    bT.exports = xY;
  });
  var _T = E((aue, ST) => {
    function SY(e, t) {
      for (
        var r = -1, n = e == null ? 0 : e.length;
        ++r < n && t(e[r], r, e) !== !1;

      );
      return e;
    }
    ST.exports = SY;
  });
  var TT = E((sue, IT) => {
    var _Y = Xi();
    function IY(e) {
      return typeof e == "function" ? e : _Y;
    }
    IT.exports = IY;
  });
  var PT = E((oue, AT) => {
    var TY = _T(),
      AY = cc(),
      PY = TT(),
      wY = qe();
    function CY(e, t) {
      var r = wY(e) ? TY : AY;
      return r(e, PY(t));
    }
    AT.exports = CY;
  });
  var CT = E((lue, wT) => {
    var MY = dt(),
      OY = function () {
        return MY.Date.now();
      };
    wT.exports = OY;
  });
  var RT = E((uue, OT) => {
    var RY = It(),
      Ic = CT(),
      MT = $i(),
      DY = "Expected a function",
      FY = Math.max,
      LY = Math.min;
    function qY(e, t, r) {
      var n,
        i,
        a,
        o,
        s,
        l,
        f = 0,
        u = !1,
        h = !1,
        m = !0;
      if (typeof e != "function") throw new TypeError(DY);
      (t = MT(t) || 0),
        RY(r) &&
          ((u = !!r.leading),
          (h = "maxWait" in r),
          (a = h ? FY(MT(r.maxWait) || 0, t) : a),
          (m = "trailing" in r ? !!r.trailing : m));
      function d(T) {
        var I = n,
          P = i;
        return (n = i = void 0), (f = T), (o = e.apply(P, I)), o;
      }
      function p(T) {
        return (f = T), (s = setTimeout(v, t)), u ? d(T) : o;
      }
      function g(T) {
        var I = T - l,
          P = T - f,
          L = t - I;
        return h ? LY(L, a - P) : L;
      }
      function c(T) {
        var I = T - l,
          P = T - f;
        return l === void 0 || I >= t || I < 0 || (h && P >= a);
      }
      function v() {
        var T = Ic();
        if (c(T)) return y(T);
        s = setTimeout(v, g(T));
      }
      function y(T) {
        return (s = void 0), m && n ? d(T) : ((n = i = void 0), o);
      }
      function b() {
        s !== void 0 && clearTimeout(s), (f = 0), (n = l = i = s = void 0);
      }
      function x() {
        return s === void 0 ? o : y(Ic());
      }
      function S() {
        var T = Ic(),
          I = c(T);
        if (((n = arguments), (i = this), (l = T), I)) {
          if (s === void 0) return p(l);
          if (h) return clearTimeout(s), (s = setTimeout(v, t)), d(l);
        }
        return s === void 0 && (s = setTimeout(v, t)), o;
      }
      return (S.cancel = b), (S.flush = x), S;
    }
    OT.exports = qY;
  });
  var FT = E((cue, DT) => {
    var kY = RT(),
      NY = It(),
      BY = "Expected a function";
    function VY(e, t, r) {
      var n = !0,
        i = !0;
      if (typeof e != "function") throw new TypeError(BY);
      return (
        NY(r) &&
          ((n = "leading" in r ? !!r.leading : n),
          (i = "trailing" in r ? !!r.trailing : i)),
        kY(e, t, { leading: n, maxWait: t, trailing: i })
      );
    }
    DT.exports = VY;
  });
  var qT = {};
  He(qT, {
    actionListPlaybackChanged: () => gn,
    animationFrameChanged: () => Es,
    clearRequested: () => hQ,
    elementStateChanged: () => Rc,
    eventListenerAdded: () => ys,
    eventStateChanged: () => Cc,
    instanceAdded: () => Mc,
    instanceRemoved: () => Oc,
    instanceStarted: () => bs,
    mediaQueriesDefined: () => Fc,
    parameterChanged: () => mn,
    playbackRequested: () => uQ,
    previewRequested: () => lQ,
    rawDataImported: () => Tc,
    sessionInitialized: () => Ac,
    sessionStarted: () => Pc,
    sessionStopped: () => wc,
    stopRequested: () => cQ,
    testFrameRendered: () => fQ,
    viewportWidthChanged: () => Dc,
  });
  var LT,
    GY,
    zY,
    HY,
    jY,
    WY,
    UY,
    XY,
    $Y,
    KY,
    YY,
    QY,
    ZY,
    JY,
    eQ,
    tQ,
    rQ,
    nQ,
    iQ,
    aQ,
    sQ,
    oQ,
    Tc,
    Ac,
    Pc,
    wc,
    lQ,
    uQ,
    cQ,
    hQ,
    ys,
    fQ,
    Cc,
    Es,
    mn,
    Mc,
    bs,
    Oc,
    Rc,
    gn,
    Dc,
    Fc,
    xs = Ee(() => {
      "use strict";
      Ze();
      (LT = me(Pr())),
        ({
          IX2_RAW_DATA_IMPORTED: GY,
          IX2_SESSION_INITIALIZED: zY,
          IX2_SESSION_STARTED: HY,
          IX2_SESSION_STOPPED: jY,
          IX2_PREVIEW_REQUESTED: WY,
          IX2_PLAYBACK_REQUESTED: UY,
          IX2_STOP_REQUESTED: XY,
          IX2_CLEAR_REQUESTED: $Y,
          IX2_EVENT_LISTENER_ADDED: KY,
          IX2_TEST_FRAME_RENDERED: YY,
          IX2_EVENT_STATE_CHANGED: QY,
          IX2_ANIMATION_FRAME_CHANGED: ZY,
          IX2_PARAMETER_CHANGED: JY,
          IX2_INSTANCE_ADDED: eQ,
          IX2_INSTANCE_STARTED: tQ,
          IX2_INSTANCE_REMOVED: rQ,
          IX2_ELEMENT_STATE_CHANGED: nQ,
          IX2_ACTION_LIST_PLAYBACK_CHANGED: iQ,
          IX2_VIEWPORT_WIDTH_CHANGED: aQ,
          IX2_MEDIA_QUERIES_DEFINED: sQ,
        } = Le),
        ({ reifyState: oQ } = LT.IX2VanillaUtils),
        (Tc = (e) => ({ type: GY, payload: { ...oQ(e) } })),
        (Ac = ({ hasBoundaryNodes: e, reducedMotion: t }) => ({
          type: zY,
          payload: { hasBoundaryNodes: e, reducedMotion: t },
        })),
        (Pc = () => ({ type: HY })),
        (wc = () => ({ type: jY })),
        (lQ = ({ rawData: e, defer: t }) => ({
          type: WY,
          payload: { defer: t, rawData: e },
        })),
        (uQ = ({
          actionTypeId: e = Xe.GENERAL_START_ACTION,
          actionListId: t,
          actionItemId: r,
          eventId: n,
          allowEvents: i,
          immediate: a,
          testManual: o,
          verbose: s,
          rawData: l,
        }) => ({
          type: UY,
          payload: {
            actionTypeId: e,
            actionListId: t,
            actionItemId: r,
            testManual: o,
            eventId: n,
            allowEvents: i,
            immediate: a,
            verbose: s,
            rawData: l,
          },
        })),
        (cQ = (e) => ({ type: XY, payload: { actionListId: e } })),
        (hQ = () => ({ type: $Y })),
        (ys = (e, t) => ({
          type: KY,
          payload: { target: e, listenerParams: t },
        })),
        (fQ = (e = 1) => ({ type: YY, payload: { step: e } })),
        (Cc = (e, t) => ({ type: QY, payload: { stateKey: e, newState: t } })),
        (Es = (e, t) => ({ type: ZY, payload: { now: e, parameters: t } })),
        (mn = (e, t) => ({ type: JY, payload: { key: e, value: t } })),
        (Mc = (e) => ({ type: eQ, payload: { ...e } })),
        (bs = (e, t) => ({ type: tQ, payload: { instanceId: e, time: t } })),
        (Oc = (e) => ({ type: rQ, payload: { instanceId: e } })),
        (Rc = (e, t, r, n) => ({
          type: nQ,
          payload: { elementId: e, actionTypeId: t, current: r, actionItem: n },
        })),
        (gn = ({ actionListId: e, isPlaying: t }) => ({
          type: iQ,
          payload: { actionListId: e, isPlaying: t },
        })),
        (Dc = ({ width: e, mediaQueries: t }) => ({
          type: aQ,
          payload: { width: e, mediaQueries: t },
        })),
        (Fc = () => ({ type: sQ }));
    });
  var Ke = {};
  He(Ke, {
    elementContains: () => kc,
    getChildElements: () => SQ,
    getClosestElement: () => bi,
    getProperty: () => vQ,
    getQuerySelector: () => qc,
    getRefType: () => Nc,
    getSiblingElements: () => _Q,
    getStyle: () => gQ,
    getValidDocument: () => EQ,
    isSiblingNode: () => xQ,
    matchSelector: () => yQ,
    queryDocument: () => bQ,
    setStyle: () => mQ,
  });
  function mQ(e, t, r) {
    e.style[t] = r;
  }
  function gQ(e, t) {
    return t.startsWith("--")
      ? window.getComputedStyle(document.documentElement).getPropertyValue(t)
      : e.style[t];
  }
  function vQ(e, t) {
    return e[t];
  }
  function yQ(e) {
    return (t) => t[Lc](e);
  }
  function qc({ id: e, selector: t }) {
    if (e) {
      let r = e;
      if (e.indexOf(kT) !== -1) {
        let n = e.split(kT),
          i = n[0];
        if (((r = n[1]), i !== document.documentElement.getAttribute(BT)))
          return null;
      }
      return `[data-w-id="${r}"], [data-w-id^="${r}_instance"]`;
    }
    return t;
  }
  function EQ(e) {
    return e == null || e === document.documentElement.getAttribute(BT)
      ? document
      : null;
  }
  function bQ(e, t) {
    return Array.prototype.slice.call(
      document.querySelectorAll(t ? e + " " + t : e)
    );
  }
  function kc(e, t) {
    return e.contains(t);
  }
  function xQ(e, t) {
    return e !== t && e.parentNode === t.parentNode;
  }
  function SQ(e) {
    let t = [];
    for (let r = 0, { length: n } = e || []; r < n; r++) {
      let { children: i } = e[r],
        { length: a } = i;
      if (a) for (let o = 0; o < a; o++) t.push(i[o]);
    }
    return t;
  }
  function _Q(e = []) {
    let t = [],
      r = [];
    for (let n = 0, { length: i } = e; n < i; n++) {
      let { parentNode: a } = e[n];
      if (!a || !a.children || !a.children.length || r.indexOf(a) !== -1)
        continue;
      r.push(a);
      let o = a.firstElementChild;
      for (; o != null; )
        e.indexOf(o) === -1 && t.push(o), (o = o.nextElementSibling);
    }
    return t;
  }
  function Nc(e) {
    return e != null && typeof e == "object"
      ? e instanceof Element
        ? pQ
        : dQ
      : null;
  }
  var NT,
    Lc,
    kT,
    pQ,
    dQ,
    BT,
    bi,
    VT = Ee(() => {
      "use strict";
      NT = me(Pr());
      Ze();
      ({ ELEMENT_MATCHES: Lc } = NT.IX2BrowserSupport),
        ({
          IX2_ID_DELIMITER: kT,
          HTML_ELEMENT: pQ,
          PLAIN_OBJECT: dQ,
          WF_PAGE: BT,
        } = Ve);
      bi = Element.prototype.closest
        ? (e, t) => (document.documentElement.contains(e) ? e.closest(t) : null)
        : (e, t) => {
            if (!document.documentElement.contains(e)) return null;
            let r = e;
            do {
              if (r[Lc] && r[Lc](t)) return r;
              r = r.parentNode;
            } while (r != null);
            return null;
          };
    });
  var Bc = E((pue, zT) => {
    var IQ = It(),
      GT = Object.create,
      TQ = (function () {
        function e() {}
        return function (t) {
          if (!IQ(t)) return {};
          if (GT) return GT(t);
          e.prototype = t;
          var r = new e();
          return (e.prototype = void 0), r;
        };
      })();
    zT.exports = TQ;
  });
  var Ss = E((due, HT) => {
    function AQ() {}
    HT.exports = AQ;
  });
  var Is = E((mue, jT) => {
    var PQ = Bc(),
      wQ = Ss();
    function _s(e, t) {
      (this.__wrapped__ = e),
        (this.__actions__ = []),
        (this.__chain__ = !!t),
        (this.__index__ = 0),
        (this.__values__ = void 0);
    }
    _s.prototype = PQ(wQ.prototype);
    _s.prototype.constructor = _s;
    jT.exports = _s;
  });
  var $T = E((gue, XT) => {
    var WT = Dr(),
      CQ = An(),
      MQ = qe(),
      UT = WT ? WT.isConcatSpreadable : void 0;
    function OQ(e) {
      return MQ(e) || CQ(e) || !!(UT && e && e[UT]);
    }
    XT.exports = OQ;
  });
  var QT = E((vue, YT) => {
    var RQ = Li(),
      DQ = $T();
    function KT(e, t, r, n, i) {
      var a = -1,
        o = e.length;
      for (r || (r = DQ), i || (i = []); ++a < o; ) {
        var s = e[a];
        t > 0 && r(s)
          ? t > 1
            ? KT(s, t - 1, r, n, i)
            : RQ(i, s)
          : n || (i[i.length] = s);
      }
      return i;
    }
    YT.exports = KT;
  });
  var JT = E((yue, ZT) => {
    var FQ = QT();
    function LQ(e) {
      var t = e == null ? 0 : e.length;
      return t ? FQ(e, 1) : [];
    }
    ZT.exports = LQ;
  });
  var tA = E((Eue, eA) => {
    function qQ(e, t, r) {
      switch (r.length) {
        case 0:
          return e.call(t);
        case 1:
          return e.call(t, r[0]);
        case 2:
          return e.call(t, r[0], r[1]);
        case 3:
          return e.call(t, r[0], r[1], r[2]);
      }
      return e.apply(t, r);
    }
    eA.exports = qQ;
  });
  var iA = E((bue, nA) => {
    var kQ = tA(),
      rA = Math.max;
    function NQ(e, t, r) {
      return (
        (t = rA(t === void 0 ? e.length - 1 : t, 0)),
        function () {
          for (
            var n = arguments, i = -1, a = rA(n.length - t, 0), o = Array(a);
            ++i < a;

          )
            o[i] = n[t + i];
          i = -1;
          for (var s = Array(t + 1); ++i < t; ) s[i] = n[i];
          return (s[t] = r(o)), kQ(e, this, s);
        }
      );
    }
    nA.exports = NQ;
  });
  var sA = E((xue, aA) => {
    function BQ(e) {
      return function () {
        return e;
      };
    }
    aA.exports = BQ;
  });
  var uA = E((Sue, lA) => {
    var VQ = sA(),
      oA = Sc(),
      GQ = Xi(),
      zQ = oA
        ? function (e, t) {
            return oA(e, "toString", {
              configurable: !0,
              enumerable: !1,
              value: VQ(t),
              writable: !0,
            });
          }
        : GQ;
    lA.exports = zQ;
  });
  var hA = E((_ue, cA) => {
    var HQ = 800,
      jQ = 16,
      WQ = Date.now;
    function UQ(e) {
      var t = 0,
        r = 0;
      return function () {
        var n = WQ(),
          i = jQ - (n - r);
        if (((r = n), i > 0)) {
          if (++t >= HQ) return arguments[0];
        } else t = 0;
        return e.apply(void 0, arguments);
      };
    }
    cA.exports = UQ;
  });
  var pA = E((Iue, fA) => {
    var XQ = uA(),
      $Q = hA(),
      KQ = $Q(XQ);
    fA.exports = KQ;
  });
  var mA = E((Tue, dA) => {
    var YQ = JT(),
      QQ = iA(),
      ZQ = pA();
    function JQ(e) {
      return ZQ(QQ(e, void 0, YQ), e + "");
    }
    dA.exports = JQ;
  });
  var yA = E((Aue, vA) => {
    var gA = ao(),
      eZ = gA && new gA();
    vA.exports = eZ;
  });
  var bA = E((Pue, EA) => {
    function tZ() {}
    EA.exports = tZ;
  });
  var Vc = E((wue, SA) => {
    var xA = yA(),
      rZ = bA(),
      nZ = xA
        ? function (e) {
            return xA.get(e);
          }
        : rZ;
    SA.exports = nZ;
  });
  var IA = E((Cue, _A) => {
    var iZ = {};
    _A.exports = iZ;
  });
  var Gc = E((Mue, AA) => {
    var TA = IA(),
      aZ = Object.prototype,
      sZ = aZ.hasOwnProperty;
    function oZ(e) {
      for (
        var t = e.name + "", r = TA[t], n = sZ.call(TA, t) ? r.length : 0;
        n--;

      ) {
        var i = r[n],
          a = i.func;
        if (a == null || a == e) return i.name;
      }
      return t;
    }
    AA.exports = oZ;
  });
  var As = E((Oue, PA) => {
    var lZ = Bc(),
      uZ = Ss(),
      cZ = 4294967295;
    function Ts(e) {
      (this.__wrapped__ = e),
        (this.__actions__ = []),
        (this.__dir__ = 1),
        (this.__filtered__ = !1),
        (this.__iteratees__ = []),
        (this.__takeCount__ = cZ),
        (this.__views__ = []);
    }
    Ts.prototype = lZ(uZ.prototype);
    Ts.prototype.constructor = Ts;
    PA.exports = Ts;
  });
  var CA = E((Rue, wA) => {
    function hZ(e, t) {
      var r = -1,
        n = e.length;
      for (t || (t = Array(n)); ++r < n; ) t[r] = e[r];
      return t;
    }
    wA.exports = hZ;
  });
  var OA = E((Due, MA) => {
    var fZ = As(),
      pZ = Is(),
      dZ = CA();
    function mZ(e) {
      if (e instanceof fZ) return e.clone();
      var t = new pZ(e.__wrapped__, e.__chain__);
      return (
        (t.__actions__ = dZ(e.__actions__)),
        (t.__index__ = e.__index__),
        (t.__values__ = e.__values__),
        t
      );
    }
    MA.exports = mZ;
  });
  var FA = E((Fue, DA) => {
    var gZ = As(),
      RA = Is(),
      vZ = Ss(),
      yZ = qe(),
      EZ = Ft(),
      bZ = OA(),
      xZ = Object.prototype,
      SZ = xZ.hasOwnProperty;
    function Ps(e) {
      if (EZ(e) && !yZ(e) && !(e instanceof gZ)) {
        if (e instanceof RA) return e;
        if (SZ.call(e, "__wrapped__")) return bZ(e);
      }
      return new RA(e);
    }
    Ps.prototype = vZ.prototype;
    Ps.prototype.constructor = Ps;
    DA.exports = Ps;
  });
  var qA = E((Lue, LA) => {
    var _Z = As(),
      IZ = Vc(),
      TZ = Gc(),
      AZ = FA();
    function PZ(e) {
      var t = TZ(e),
        r = AZ[t];
      if (typeof r != "function" || !(t in _Z.prototype)) return !1;
      if (e === r) return !0;
      var n = IZ(r);
      return !!n && e === n[0];
    }
    LA.exports = PZ;
  });
  var VA = E((que, BA) => {
    var kA = Is(),
      wZ = mA(),
      CZ = Vc(),
      zc = Gc(),
      MZ = qe(),
      NA = qA(),
      OZ = "Expected a function",
      RZ = 8,
      DZ = 32,
      FZ = 128,
      LZ = 256;
    function qZ(e) {
      return wZ(function (t) {
        var r = t.length,
          n = r,
          i = kA.prototype.thru;
        for (e && t.reverse(); n--; ) {
          var a = t[n];
          if (typeof a != "function") throw new TypeError(OZ);
          if (i && !o && zc(a) == "wrapper") var o = new kA([], !0);
        }
        for (n = o ? n : r; ++n < r; ) {
          a = t[n];
          var s = zc(a),
            l = s == "wrapper" ? CZ(a) : void 0;
          l &&
          NA(l[0]) &&
          l[1] == (FZ | RZ | DZ | LZ) &&
          !l[4].length &&
          l[9] == 1
            ? (o = o[zc(l[0])].apply(o, l[3]))
            : (o = a.length == 1 && NA(a) ? o[s]() : o.thru(a));
        }
        return function () {
          var f = arguments,
            u = f[0];
          if (o && f.length == 1 && MZ(u)) return o.plant(u).value();
          for (var h = 0, m = r ? t[h].apply(this, f) : u; ++h < r; )
            m = t[h].call(this, m);
          return m;
        };
      });
    }
    BA.exports = qZ;
  });
  var zA = E((kue, GA) => {
    var kZ = VA(),
      NZ = kZ();
    GA.exports = NZ;
  });
  var jA = E((Nue, HA) => {
    function BZ(e, t, r) {
      return (
        e === e &&
          (r !== void 0 && (e = e <= r ? e : r),
          t !== void 0 && (e = e >= t ? e : t)),
        e
      );
    }
    HA.exports = BZ;
  });
  var UA = E((Bue, WA) => {
    var VZ = jA(),
      Hc = $i();
    function GZ(e, t, r) {
      return (
        r === void 0 && ((r = t), (t = void 0)),
        r !== void 0 && ((r = Hc(r)), (r = r === r ? r : 0)),
        t !== void 0 && ((t = Hc(t)), (t = t === t ? t : 0)),
        VZ(Hc(e), t, r)
      );
    }
    WA.exports = GZ;
  });
  var tP,
    rP,
    nP,
    iP,
    zZ,
    HZ,
    jZ,
    WZ,
    UZ,
    XZ,
    $Z,
    KZ,
    YZ,
    QZ,
    ZZ,
    JZ,
    eJ,
    tJ,
    rJ,
    aP,
    sP,
    nJ,
    iJ,
    aJ,
    oP,
    sJ,
    oJ,
    lP,
    lJ,
    jc,
    uP,
    XA,
    $A,
    cP,
    Si,
    uJ,
    Dt,
    hP,
    cJ,
    et,
    xt,
    _i,
    fP,
    Wc,
    KA,
    Uc,
    hJ,
    xi,
    fJ,
    pJ,
    dJ,
    pP,
    YA,
    mJ,
    QA,
    gJ,
    vJ,
    yJ,
    ZA,
    ws,
    Cs,
    JA,
    eP,
    dP,
    mP = Ee(() => {
      "use strict";
      (tP = me(zA())), (rP = me(Ui())), (nP = me(UA()));
      Ze();
      Xc();
      xs();
      (iP = me(Pr())),
        ({
          MOUSE_CLICK: zZ,
          MOUSE_SECOND_CLICK: HZ,
          MOUSE_DOWN: jZ,
          MOUSE_UP: WZ,
          MOUSE_OVER: UZ,
          MOUSE_OUT: XZ,
          DROPDOWN_CLOSE: $Z,
          DROPDOWN_OPEN: KZ,
          SLIDER_ACTIVE: YZ,
          SLIDER_INACTIVE: QZ,
          TAB_ACTIVE: ZZ,
          TAB_INACTIVE: JZ,
          NAVBAR_CLOSE: eJ,
          NAVBAR_OPEN: tJ,
          MOUSE_MOVE: rJ,
          PAGE_SCROLL_DOWN: aP,
          SCROLL_INTO_VIEW: sP,
          SCROLL_OUT_OF_VIEW: nJ,
          PAGE_SCROLL_UP: iJ,
          SCROLLING_IN_VIEW: aJ,
          PAGE_FINISH: oP,
          ECOMMERCE_CART_CLOSE: sJ,
          ECOMMERCE_CART_OPEN: oJ,
          PAGE_START: lP,
          PAGE_SCROLL: lJ,
        } = Et),
        (jc = "COMPONENT_ACTIVE"),
        (uP = "COMPONENT_INACTIVE"),
        ({ COLON_DELIMITER: XA } = Ve),
        ({ getNamespacedParameterId: $A } = iP.IX2VanillaUtils),
        (cP = (e) => (t) => typeof t == "object" && e(t) ? !0 : t),
        (Si = cP(({ element: e, nativeEvent: t }) => e === t.target)),
        (uJ = cP(({ element: e, nativeEvent: t }) => e.contains(t.target))),
        (Dt = (0, tP.default)([Si, uJ])),
        (hP = (e, t) => {
          if (t) {
            let { ixData: r } = e.getState(),
              { events: n } = r,
              i = n[t];
            if (i && !hJ[i.eventTypeId]) return i;
          }
          return null;
        }),
        (cJ = ({ store: e, event: t }) => {
          let { action: r } = t,
            { autoStopEventId: n } = r.config;
          return !!hP(e, n);
        }),
        (et = ({ store: e, event: t, element: r, eventStateKey: n }, i) => {
          let { action: a, id: o } = t,
            { actionListId: s, autoStopEventId: l } = a.config,
            f = hP(e, l);
          return (
            f &&
              vn({
                store: e,
                eventId: l,
                eventTarget: r,
                eventStateKey: l + XA + n.split(XA)[1],
                actionListId: (0, rP.default)(f, "action.config.actionListId"),
              }),
            vn({
              store: e,
              eventId: o,
              eventTarget: r,
              eventStateKey: n,
              actionListId: s,
            }),
            Ii({
              store: e,
              eventId: o,
              eventTarget: r,
              eventStateKey: n,
              actionListId: s,
            }),
            i
          );
        }),
        (xt = (e, t) => (r, n) => e(r, n) === !0 ? t(r, n) : n),
        (_i = { handler: xt(Dt, et) }),
        (fP = { ..._i, types: [jc, uP].join(" ") }),
        (Wc = [
          { target: window, types: "resize orientationchange", throttle: !0 },
          {
            target: document,
            types: "scroll wheel readystatechange IX2_PAGE_UPDATE",
            throttle: !0,
          },
        ]),
        (KA = "mouseover mouseout"),
        (Uc = { types: Wc }),
        (hJ = { PAGE_START: lP, PAGE_FINISH: oP }),
        (xi = (() => {
          let e = window.pageXOffset !== void 0,
            r =
              document.compatMode === "CSS1Compat"
                ? document.documentElement
                : document.body;
          return () => ({
            scrollLeft: e ? window.pageXOffset : r.scrollLeft,
            scrollTop: e ? window.pageYOffset : r.scrollTop,
            stiffScrollTop: (0, nP.default)(
              e ? window.pageYOffset : r.scrollTop,
              0,
              r.scrollHeight - window.innerHeight
            ),
            scrollWidth: r.scrollWidth,
            scrollHeight: r.scrollHeight,
            clientWidth: r.clientWidth,
            clientHeight: r.clientHeight,
            innerWidth: window.innerWidth,
            innerHeight: window.innerHeight,
          });
        })()),
        (fJ = (e, t) =>
          !(
            e.left > t.right ||
            e.right < t.left ||
            e.top > t.bottom ||
            e.bottom < t.top
          )),
        (pJ = ({ element: e, nativeEvent: t }) => {
          let { type: r, target: n, relatedTarget: i } = t,
            a = e.contains(n);
          if (r === "mouseover" && a) return !0;
          let o = e.contains(i);
          return !!(r === "mouseout" && a && o);
        }),
        (dJ = (e) => {
          let {
              element: t,
              event: { config: r },
            } = e,
            { clientWidth: n, clientHeight: i } = xi(),
            a = r.scrollOffsetValue,
            l = r.scrollOffsetUnit === "PX" ? a : (i * (a || 0)) / 100;
          return fJ(t.getBoundingClientRect(), {
            left: 0,
            top: l,
            right: n,
            bottom: i - l,
          });
        }),
        (pP = (e) => (t, r) => {
          let { type: n } = t.nativeEvent,
            i = [jc, uP].indexOf(n) !== -1 ? n === jc : r.isActive,
            a = { ...r, isActive: i };
          return ((!r || a.isActive !== r.isActive) && e(t, a)) || a;
        }),
        (YA = (e) => (t, r) => {
          let n = { elementHovered: pJ(t) };
          return (
            ((r ? n.elementHovered !== r.elementHovered : n.elementHovered) &&
              e(t, n)) ||
            n
          );
        }),
        (mJ = (e) => (t, r) => {
          let n = { ...r, elementVisible: dJ(t) };
          return (
            ((r ? n.elementVisible !== r.elementVisible : n.elementVisible) &&
              e(t, n)) ||
            n
          );
        }),
        (QA =
          (e) =>
          (t, r = {}) => {
            let { stiffScrollTop: n, scrollHeight: i, innerHeight: a } = xi(),
              {
                event: { config: o, eventTypeId: s },
              } = t,
              { scrollOffsetValue: l, scrollOffsetUnit: f } = o,
              u = f === "PX",
              h = i - a,
              m = Number((n / h).toFixed(2));
            if (r && r.percentTop === m) return r;
            let d = (u ? l : (a * (l || 0)) / 100) / h,
              p,
              g,
              c = 0;
            r &&
              ((p = m > r.percentTop),
              (g = r.scrollingDown !== p),
              (c = g ? m : r.anchorTop));
            let v = s === aP ? m >= c + d : m <= c - d,
              y = {
                ...r,
                percentTop: m,
                inBounds: v,
                anchorTop: c,
                scrollingDown: p,
              };
            return (r && v && (g || y.inBounds !== r.inBounds) && e(t, y)) || y;
          }),
        (gJ = (e, t) =>
          e.left > t.left &&
          e.left < t.right &&
          e.top > t.top &&
          e.top < t.bottom),
        (vJ = (e) => (t, r) => {
          let n = { finished: document.readyState === "complete" };
          return n.finished && !(r && r.finshed) && e(t), n;
        }),
        (yJ = (e) => (t, r) => {
          let n = { started: !0 };
          return r || e(t), n;
        }),
        (ZA =
          (e) =>
          (t, r = { clickCount: 0 }) => {
            let n = { clickCount: (r.clickCount % 2) + 1 };
            return (n.clickCount !== r.clickCount && e(t, n)) || n;
          }),
        (ws = (e = !0) => ({
          ...fP,
          handler: xt(
            e ? Dt : Si,
            pP((t, r) => (r.isActive ? _i.handler(t, r) : r))
          ),
        })),
        (Cs = (e = !0) => ({
          ...fP,
          handler: xt(
            e ? Dt : Si,
            pP((t, r) => (r.isActive ? r : _i.handler(t, r)))
          ),
        })),
        (JA = {
          ...Uc,
          handler: mJ((e, t) => {
            let { elementVisible: r } = t,
              { event: n, store: i } = e,
              { ixData: a } = i.getState(),
              { events: o } = a;
            return !o[n.action.config.autoStopEventId] && t.triggered
              ? t
              : (n.eventTypeId === sP) === r
              ? (et(e), { ...t, triggered: !0 })
              : t;
          }),
        }),
        (eP = 0.05),
        (dP = {
          [YZ]: ws(),
          [QZ]: Cs(),
          [KZ]: ws(),
          [$Z]: Cs(),
          [tJ]: ws(!1),
          [eJ]: Cs(!1),
          [ZZ]: ws(),
          [JZ]: Cs(),
          [oJ]: { types: "ecommerce-cart-open", handler: xt(Dt, et) },
          [sJ]: { types: "ecommerce-cart-close", handler: xt(Dt, et) },
          [zZ]: {
            types: "click",
            handler: xt(
              Dt,
              ZA((e, { clickCount: t }) => {
                cJ(e) ? t === 1 && et(e) : et(e);
              })
            ),
          },
          [HZ]: {
            types: "click",
            handler: xt(
              Dt,
              ZA((e, { clickCount: t }) => {
                t === 2 && et(e);
              })
            ),
          },
          [jZ]: { ..._i, types: "mousedown" },
          [WZ]: { ..._i, types: "mouseup" },
          [UZ]: {
            types: KA,
            handler: xt(
              Dt,
              YA((e, t) => {
                t.elementHovered && et(e);
              })
            ),
          },
          [XZ]: {
            types: KA,
            handler: xt(
              Dt,
              YA((e, t) => {
                t.elementHovered || et(e);
              })
            ),
          },
          [rJ]: {
            types: "mousemove mouseout scroll",
            handler: (
              {
                store: e,
                element: t,
                eventConfig: r,
                nativeEvent: n,
                eventStateKey: i,
              },
              a = { clientX: 0, clientY: 0, pageX: 0, pageY: 0 }
            ) => {
              let {
                  basedOn: o,
                  selectedAxis: s,
                  continuousParameterGroupId: l,
                  reverse: f,
                  restingState: u = 0,
                } = r,
                {
                  clientX: h = a.clientX,
                  clientY: m = a.clientY,
                  pageX: d = a.pageX,
                  pageY: p = a.pageY,
                } = n,
                g = s === "X_AXIS",
                c = n.type === "mouseout",
                v = u / 100,
                y = l,
                b = !1;
              switch (o) {
                case Mt.VIEWPORT: {
                  v = g
                    ? Math.min(h, window.innerWidth) / window.innerWidth
                    : Math.min(m, window.innerHeight) / window.innerHeight;
                  break;
                }
                case Mt.PAGE: {
                  let {
                    scrollLeft: x,
                    scrollTop: S,
                    scrollWidth: T,
                    scrollHeight: I,
                  } = xi();
                  v = g ? Math.min(x + d, T) / T : Math.min(S + p, I) / I;
                  break;
                }
                case Mt.ELEMENT:
                default: {
                  y = $A(i, l);
                  let x = n.type.indexOf("mouse") === 0;
                  if (x && Dt({ element: t, nativeEvent: n }) !== !0) break;
                  let S = t.getBoundingClientRect(),
                    { left: T, top: I, width: P, height: L } = S;
                  if (!x && !gJ({ left: h, top: m }, S)) break;
                  (b = !0), (v = g ? (h - T) / P : (m - I) / L);
                  break;
                }
              }
              return (
                c && (v > 1 - eP || v < eP) && (v = Math.round(v)),
                (o !== Mt.ELEMENT || b || b !== a.elementHovered) &&
                  ((v = f ? 1 - v : v), e.dispatch(mn(y, v))),
                {
                  elementHovered: b,
                  clientX: h,
                  clientY: m,
                  pageX: d,
                  pageY: p,
                }
              );
            },
          },
          [lJ]: {
            types: Wc,
            handler: ({ store: e, eventConfig: t }) => {
              let { continuousParameterGroupId: r, reverse: n } = t,
                { scrollTop: i, scrollHeight: a, clientHeight: o } = xi(),
                s = i / (a - o);
              (s = n ? 1 - s : s), e.dispatch(mn(r, s));
       